/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.base;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.javacomm.client.resource.Resource;
import net.javacomm.multilingual.Babelfish;
import net.javacomm.multilingual.MultilingualButton;
import net.javacomm.multilingual.schema.ISO639;
import net.javacomm.multilingual.schema.KEY;
import net.javacomm.window.manager.Control;



public class ButtonPane extends JPanel implements ActionListener, Babelfish {

  private static final long serialVersionUID = 3543839679848308439L;
  private MultilingualButton buttonAbschicken = new MultilingualButton(KEY.BUTTON_ABSCHICKEN);
  private PropertyChangeSupport changes = new PropertyChangeSupport (this);
  private JPanel panButton = new JPanel (new GridLayout(1,3,24,0));
  private ImageIcon iconSend;

  
  


  public ButtonPane () {
    setLayout (new FlowLayout (FlowLayout.CENTER,24,12));
    Class<? extends ButtonPane> resource = getClass();

    iconSend = new ImageIcon (resource.getResource(Resource.REMOTE));
    resource = getClass();

    panButton.add (buttonAbschicken);
    buttonAbschicken.addActionListener (this);
    buttonAbschicken.setIcon (iconSend);

    add (panButton);
  }



  @Override
  public void actionPerformed (ActionEvent event) {
    Object obj;

    obj = event.getSource ();
    if (obj.equals (buttonAbschicken)) {
      changes.firePropertyChange ("ButtonPane",
                                  Control.NULL,
                                  Control.SEND);
    }
  }



  public synchronized void addButtonListener (PropertyChangeListener l) {
    changes.addPropertyChangeListener (l);
  }




  public synchronized void removeButtonListener (PropertyChangeListener l) {
    changes.removePropertyChangeListener (l);
  }



  @Override
  public void setLanguage(ISO639 code) {
    buttonAbschicken.setLanguage(code);
  }

}
