/**
 *  Copyright © 2021-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.mediaplayer;

import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.nexuswob.gui.swing.JavacommInternalFrame;
import net.javacomm.client.base.Mnemonics;



@SuppressWarnings("serial")
public class JVirtuelleMausFrame extends JavacommInternalFrame {

  private JPanel mainpane = new JPanel();
  private JButton buttonOben = new JButton(Mnemonics.OBEN.toString());
  private JButton buttonUnten = new JButton(Mnemonics.UNTEN.toString());
  private JButton buttonLinks = new JButton(Mnemonics.LINKS.toString());
  private JButton buttonRechts = new JButton(Mnemonics.RECHTS.toString());
  private JButton buttonEnter = new JButton(Mnemonics.ENTER.toString());
  private PropertyChangeSupport changes = new PropertyChangeSupport(this);


  public JVirtuelleMausFrame() {
    setLayout(new BorderLayout());


    mainpane.add(buttonOben, BorderLayout.NORTH);
    mainpane.add(buttonUnten, BorderLayout.SOUTH);
    mainpane.add(buttonLinks, BorderLayout.WEST);
    mainpane.add(buttonRechts, BorderLayout.EAST);
    mainpane.add(buttonEnter, BorderLayout.CENTER);
    setContentPane(mainpane);
  }



  public synchronized void addVirtuelleMausListener(PropertyChangeListener l) {
    changes.addPropertyChangeListener(l);
  }



  public synchronized void removeAllListener() {
    for (PropertyChangeListener tmp : changes.getPropertyChangeListeners()) {
      removeVirtuelleMausListener(tmp);
    }
  }


  public synchronized void removeVirtuelleMausListener(PropertyChangeListener l) {
    changes.removePropertyChangeListener(l);
  }




}
