/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.mediaplayer;

import uk.co.caprica.vlcj.media.MediaRef;
import uk.co.caprica.vlcj.media.TrackType;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventListener;



public abstract class VLCMediaPlayerAdapter implements MediaPlayerEventListener {

  @Override
  public void audioDeviceChanged(MediaPlayer mediaPlayer, String audioDevice) {

  }



  @Override
  public void backward(MediaPlayer mediaPlayer) {

  }



  @Override
  public void buffering(MediaPlayer mediaPlayer, float newCache) {

  }



  @Override
  public void chapterChanged(MediaPlayer mediaPlayer, int newChapter) {

  }



  @Override
  public void corked(MediaPlayer mediaPlayer, boolean corked) {

  }



  @Override
  public void elementaryStreamAdded(MediaPlayer mediaPlayer, TrackType type, int id) {

  }



  @Override
  public void elementaryStreamDeleted(MediaPlayer mediaPlayer, TrackType type, int id) {

  }



  @Override
  public void elementaryStreamSelected(MediaPlayer mediaPlayer, TrackType type, int id) {

  }



  @Override
  public void error(MediaPlayer mediaPlayer) {

  }



  @Override
  public void finished(MediaPlayer mediaPlayer) {

  }



  @Override
  public void forward(MediaPlayer mediaPlayer) {

  }



  @Override
  public void lengthChanged(MediaPlayer mediaPlayer, long newLength) {

  }



  @Override
  public void mediaChanged(MediaPlayer mediaPlayer, MediaRef media) {

  }



  @Override
  public void mediaPlayerReady(MediaPlayer mediaPlayer) {

  }



  @Override
  public void muted(MediaPlayer mediaPlayer, boolean muted) {

  }



  @Override
  public void opening(MediaPlayer mediaPlayer) {

  }



  @Override
  public void pausableChanged(MediaPlayer mediaPlayer, int newPausable) {

  }



  @Override
  public void paused(MediaPlayer mediaPlayer) {

  }



  @Override
  public void playing(MediaPlayer mediaPlayer) {

  }



  @Override
  public void positionChanged(MediaPlayer mediaPlayer, float newPosition) {

  }



  @Override
  public void scrambledChanged(MediaPlayer mediaPlayer, int newScrambled) {

  }



  @Override
  public void seekableChanged(MediaPlayer mediaPlayer, int newSeekable) {

  }



  @Override
  public void snapshotTaken(MediaPlayer mediaPlayer, String filename) {

  }



  @Override
  public void stopped(MediaPlayer mediaPlayer) {

  }



  @Override
  public void timeChanged(MediaPlayer mediaPlayer, long newTime) {

  }



  @Override
  public void titleChanged(MediaPlayer mediaPlayer, int newTitle) {

  }



  @Override
  public void videoOutput(MediaPlayer mediaPlayer, int newCount) {

  }



  @Override
  public void volumeChanged(MediaPlayer mediaPlayer, float volume) {}

}
