/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.websocket;

import java.util.EventObject;
import net.javacomm.protocol.MESSAGE;

public class WebsocketEvent extends EventObject {

  private static final long serialVersionUID = -5434098426488203457L;
  /**
   * Events ON_OPEN, ON_MESSAGE, ON_CLOSE, ON_ERROR
   * 
   * @author llange
   *
   */
  public enum Event {ON_OPEN, ON_MESSAGE, ON_CLOSE, ON_ERROR};
 
  private MESSAGE message;
  private Event id;
  
  /**
   * Auf dem Websocket ist gerade etwas passiert.
   * 
   * 
   * @param source
   *               das auslösende Objekt
   */
  public WebsocketEvent(Object source) {
    super(source);
  }


  
  /**
   * Auf dem Websocket ist gerade etwas passiert.
   * 
   * @param source
   *               das auslösende Objekt
   * @param id
   *               das Ereignis
   */
  public WebsocketEvent(Object source, Event id) {
    super(source);
    setId(id);
  }

  
  
  /**
   * Auf dem Websocket ist gerade etwas passiert. Die Ereignis ist
   * {@code Event.ON_MESSAGE}.
   * 
   * @param source
   *                das auslösende Objekt
   * @param message
   *                eine mögliche Botschaft oder {@code null}
   */
  public WebsocketEvent(Object source, MESSAGE message) {
    this(source, Event.ON_MESSAGE);
    setMessage(message);
  }

  
  /**
   * Was war passiert?
   * 
   * @return Ereignis
   */
  public Event getId() {
    return id;
  }
  
  
  private void setId(Event value) {
    id = value;
  }
  
  protected void setMessage(MESSAGE value) {
    message = value;
  }
  
  
  /**
   * Eine Nachricht wurde empfangen.
   * 
   * @return eine Botschaft
   */
  public MESSAGE getMessage() {
    return message;
  }

  
  
}
