/**
 * The MIT License
 * Copyright © 2020 Thorsten Schulz <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package net.javacomm.schulz;

/*****************************************************************************/
/*                                                                           */
/* Class       : AbililyCheckDatas                                           */
/* Owner       : Thorsten Schulz                                             */
/* License     : All rights reserved                                         */
/* Createtd    : 04.08.2002 by Thorsten Schulz, TSchulz@javacomm.net         */
/* Last Update : 26.02.2004 by Thorsten Schulz                               */
/*                                                                           */
/*****************************************************************************/


public class AbilityCheckDatas{

  private int dieValue, effectValue;
  private boolean critical;


  public AbilityCheckDatas(){
  }

  public void initValues(){
    dieValue = 0;
    effectValue = 0;
    critical = false;
    return;
  }

  public void setValuesOnError(){
    dieValue = 0;
    effectValue = 0;
    critical = true;
    return;
  }

  public int getDieValue(){
    return(dieValue);
  }

  public int getEffectValue(){
    return(effectValue);
  }

  public boolean isCritical(){
    return(critical);
  }

  public void setDieValue(int value){
    dieValue = value;
    return;
  }

  public void setEffectValue(int value){
    effectValue = value;
    return;
  }

  public void setCritical(boolean value){
    critical = value;
    return;
  }
}