/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;



public class INCOMINGCALL extends MESSAGE {

  public final static String CALLER_USERID = "CALLER_USERID";
  public final static String CALLER_NICKNAME = "CALLER_NICKNAME";
  public final static String CALLER_VOICE = "CALLER_VOICE";
  public final static String CALLER_SESSION = "CALLER_SESSION";
  public final static String RECEIVER_USERID = "RECEIVER_USERID";
  public final static String RECEIVER_NICKNAME = "RECEIVER_NICKNAME";
  public final static String RECEIVER_SESSION = "RECEIVER_SESSION";
  public final static String RECEIVER_VOICE = "RECEIVER_VOICE";

  private String callerUserid;
  private String callerNickname;
  private String callerVoice;
  private String callerSession;
  private String receiverUserid;
  private String receiverNickname;
  private String receiverSession;
  private String receiverVoice;

  public String getCallerNickname() {
    return callerNickname;
  }



  public String getCallerSession() {
    return callerSession;
  }



  public String getCallerUserid() {
    return callerUserid;
  }



  public String getCallerVoice() {
    return callerVoice;
  }



  public String getReceiverNickname() {
    return receiverNickname;
  }



  public String getReceiverSession() {
    return receiverSession;
  }



  public String getReceiverUserid() {
    return receiverUserid;
  }



  public String getReceiverVoice() {
    return receiverVoice;
  }



  public void setCallerNickname(String callerNickname) {
    this.callerNickname = callerNickname;
  }



  public void setCallerSession(String callerSession) {
    this.callerSession = callerSession;
  }



  public void setCallerUserid(String callerUserid) {
    this.callerUserid = callerUserid;
  }



  public void setCallerVoice(String callerVoice) {
    this.callerVoice = callerVoice;
  }



  /**
   * REQUEST : zwingend<br>
   * <br>
   * RESPONSE :
   * 
   * 
   * @param receiverNickname
   *                         dieser Nickname
   */
  public void setReceiverNickname(String receiverNickname) {
    this.receiverNickname = receiverNickname;
  }



  /**
   * REQUEST : zwingend<br>
   * <br>
   * RESPONSE :
   * 
   * @param receiverSession
   *                        diese Websocketsession
   */
  public void setReceiverSession(String receiverSession) {
    this.receiverSession = receiverSession;
  }



  /**
   * REQUEST : zwingend<br>
   * <br>
   * RESPONSE :
   * 
   * @param receiverUserid
   */
  public void setReceiverUserid(String receiverUserid) {
    this.receiverUserid = receiverUserid;
  }



  /**
   * REQUEST : nicht vorhanden<br>
   * <br>
   * RESPONSE :
   * 
   * @param receiverVoice
   *                      diese Qualitätsstufe
   */
  public void setReceiverVoice(String receiverVoice) {
    this.receiverVoice = receiverVoice;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    builder.registerTypeHierarchyAdapter(INCOMINGCALL.class, new IncomingCallSerializer());
    Gson gson = builder.create();
    return gson.toJson(this);
  }
}
