/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;



public class PRIVATEMESSAGE extends MESSAGE implements Attachment {

  public final static String SENDER_UID = "SENDER_UID";
  public final static String LOCAL_SESSIONID = "LOCAL_SESSIONID";
  public final static String REMOTE_SESSIONID = "REMOTE_SESSIONID";
  public final static String MESSAGE = "MESSAGE";
  public final static String DATETIME = "DATETIME";
  public final static String ROOM = "ROOM";
  public final static String CHATUSER = "CHATUSER";

  private String localsession;
  private String remotesession;
  private String message;
  private String sender_uid;
  private Long datetime;
  /* die Nachricht kommt aus diesem Raum */
  private String room;
  // Chatuser enthält den Absender der Nachricht
  private ChatUser chatuser;

  // optional
  private Long attachment;
  private String filename;
  private Long filesize;

  public void setLocalSessionid(String value) {
    localsession = value;
  }



  public void setRemoteSessionid(String value) {
    remotesession = value;
  }



  @Override
  public void setMessage(String value) {
    message = value;
  }



  public String getLocalSessionid() {
    return localsession;
  }



  public String getRemoteSessionid() {
    return remotesession;
  }



  @Override
  public String getMessage() {
    return message;
  }



  public void setSenderUID(String value) {
    sender_uid = value;
  }



  public String getSenderUID() {
    return sender_uid;
  }



  @Override
  public void setRoom(String value) {
    room = value;
  }



  @Override
  public String getRoom() {
    return room;
  }



  @Override
  public void setDatetime(Long value) {
    datetime = value;
  }



  @Override
  public Long getDatetime() {
    return datetime;
  }



  @Override
  public void setChatUser(ChatUser value) {
    chatuser = value;
  }



  @Override
  public ChatUser getChatUser() {
    return chatuser;
  }



  @Override
  public Long getAttachment() {
    return attachment;
  }



  @Override
  public void setAttachment(Long number) {
    this.attachment = number;
  }



  @Override
  public String getFilename() {
    return filename;
  }



  @Override
  public void setFilename(String filename) {
    this.filename = filename;
  }



  @Override
  public Long getFilesize() {
    return filesize;
  }



  @Override
  public void setFilesize(Long filesize) {
    this.filesize = filesize;
  }



  @Override
  public String toString() {
    Gson gson = new Gson();
    return gson.toJson(this);
  }

}
