/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

public class Room {


	public final static String ROOM = "ROOM";
  public final static String LIFETIME = "LIFETIME";
  public final static String OWNER = "OWNER";
  public final static String ENTRY = "ENTRY";
  public final static String ROOMTYPE = "ROOMTYPE";
	
	
	private String chatid; // room
	private Lifetime lifetime;
	private String owner;
	private Entry entry;
  private Roomtype roomtype;
	
	
	public final void setChatid(String value) {
		chatid = value;
	}
	
	
	public final String getChatid() {
		return chatid;
	}
	
	
	
	public void setOwner(String value) {
		owner = value;
	}
	
	
	public String getOwner() {
		return owner;
	}


  public Entry getEntry() {
    return entry;
  }


  public void setEntry(Entry entry) {
    this.entry = entry;
  }


  public Lifetime getLifetime() {
    return lifetime;
  }


  public void setLifetime(Lifetime lifetime) {
    this.lifetime = lifetime;
  }



  public Roomtype getRoomtype() {
    return roomtype;
  }



  public void setRoomtype(Roomtype roomtype) {
    this.roomtype = roomtype;
  }
	
	
	
	
}
