/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;



public class UPDATEUSER extends MESSAGE {

  public final static String IDENTITY = "IDENTITY";
  public final static String NICKNAME = USER.NICKNAME;
  public final static String FOREGROUND_COLOR = USER.FOREGROUND_COLOR;
  public final static String BACKGROUND_COLOR = USER.BACKGROUND_COLOR;

  private Integer backgroundColor;
  private Integer foregroundColor;
  private String nickname;
  private String identity;

  public Integer getBackgroundColor() {
    return backgroundColor;
  }



  public Integer getForegroundColor() {
    return foregroundColor;
  }



  public String getIdentity() {
    return identity;
  }



  public String getNickname() {
    return nickname;
  }



  public void setBackgroundColor(Integer backgroundColor) {
    this.backgroundColor = backgroundColor;
  }



  public void setForegroundColor(Integer foregroundColor) {
    this.foregroundColor = foregroundColor;
  }



  public void setIdentity(String identity) {
    this.identity = identity;
  }



  public void setNickname(String nickname) {
    this.nickname = nickname;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    builder.registerTypeAdapter(UPDATEUSER.class, new UpdateuserSerializer());
    Gson gson = builder.create();
    return gson.toJson(this);
  }

}
