/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.transfer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.ZonedDateTime;



public class TransferBenutzerkonto {

  private String uid;
  private String nickname;
  private String mail;
  private boolean ldelete;
  private ZonedDateTime time;

  public String getUid() {
    return uid;
  }



  public void setUid(String uid) {
    this.uid = uid;
  }



  public String getNickname() {
    return nickname;
  }



  public void setNickname(String nickname) {
    this.nickname = nickname;
  }



  public String getMail() {
    return mail;
  }



  public void setMail(String mail) {
    this.mail = mail;
  }



  public boolean isLdelete() {
    return ldelete;
  }



  public void setLdelete(boolean ldelete) {
    this.ldelete = ldelete;
  }



  public ZonedDateTime getTime() {
    return time;
  }



  public void setTime(ZonedDateTime time) {
    this.time = time;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    builder = builder.registerTypeAdapter(ZonedDateTime.class, new ZonedDateTimeSerializer());
    Gson gson = builder.create();
    return gson.toJson(this);
  }

}
