package net.javacomm.transfer;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotEquals;
import com.google.gson.Gson;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;



public class TestTransferChatfile {

  TransferChatfile chatfile;
  Gson gson;

  @BeforeEach
  public void setUp() {
    chatfile = new TransferChatfile();
    gson = new Gson();
  }



  @Test
  @DisplayName(value = "alle Attribute")
  public void serialize() {
    chatfile.setAbsoluteFilename("C:\\Hallo\\meine\\Freunde.mp4");
    chatfile.setError(true);
    chatfile.setFilename("Freunde.mp4");
    chatfile.setFilesize(1024 * 1024 * 16);
    chatfile.setMessage("Wie geht es euch");
    chatfile.setReceiverUid("receiver");
    chatfile.setUid("user");
    chatfile.setNumber(99l);

    String serialized = chatfile.toString();
    assertEquals(
        "{\"number\":99,\"receiverUid\":\"receiver\",\"uid\":\"user\",\"absoluteFilename\":\"C:\\\\Hallo\\\\meine\\\\Freunde.mp4\",\"filename\":\"Freunde.mp4\",\"message\":\"Wie geht es euch\",\"filesize\":16777216,\"error\":true}",
        serialized
    );

  }



  @Test
  @DisplayName(value = "KEY fehlt")
  public void serializeNumber() {
    chatfile.setAbsoluteFilename("C:\\Hallo\\meine\\Freunde.mp4");
    chatfile.setError(true);
    chatfile.setFilename("Freunde.mp4");
    chatfile.setFilesize(1024 * 1024 * 16);
    chatfile.setMessage("Wie geht es euch");
    chatfile.setReceiverUid("receiver");
    chatfile.setUid("user");

    String serialized = chatfile.toString();
    assertNotEquals(
        "{\"number\":0,\"receiverUid\":\"receiver\",\"uid\":\"user\",\"absoluteFilename\":\"C:\\\\Hallo\\\\meine\\\\Freunde.mp4\",\"filename\":\"Freunde.mp4\",\"message\":\"Wie geht es euch\",\"filesize\":16777216,\"error\":true}",
        serialized
    );

  }



  @Test
  @DisplayName(value = "ruid, uid, absoluteFilename")
  public void serializeMandotory() {
    chatfile.setAbsoluteFilename("C:\\Hallo\\meine\\Freunde.mp4");
    chatfile.setReceiverUid("receiver");
    chatfile.setUid("user");
    chatfile.setNumber(0l);

    String serialized = chatfile.toString();
    assertEquals(
        "{\"number\":0,\"receiverUid\":\"receiver\",\"uid\":\"user\",\"absoluteFilename\":\"C:\\\\Hallo\\\\meine\\\\Freunde.mp4\",\"filesize\":0,\"error\":false}",
        serialized
    );

  }



  @Test
  public void deserialize() {
    String deserialized = "{\"number\":99,\"receiverUid\":\"receiver\",\"uid\":\"user\",\"absoluteFilename\":\"C:\\\\Hallo\\\\meine\\\\Freunde.mp4\",\"filesize\":0,\"error\":false}";
    TransferChatfile result = gson.fromJson(deserialized, TransferChatfile.class);
    assertEquals("receiver", result.getReceiverUid());
    assertEquals("C:\\Hallo\\meine\\Freunde.mp4", result.getAbsoluteFilename());
    assertEquals(null, result.getFilename());
    assertEquals(0, result.getFilesize());
    assertEquals(false, result.isError());
    assertEquals(null, result.getMessage());
    assertEquals("user", result.getUid());
    assertEquals(99, result.getNumber());

  }

}
