/**
 *  Copyright © 2022-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.window.manager;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;



public final class WMResource {

  private final static Logger log = LogManager.getLogger(WMResource.class);

  public final static String PRE_PACKAGE = "net/javacomm/window";
  public final static String PACKGAE = PRE_PACKAGE + "/manager/";

  public final static String LAUNCH = PACKGAE + "rooms_26x26.png";
  public final static String PRIVAT_26x26 = PACKGAE + "privat_26x26.png";
  public final static String CONFERENCE_23x26 = PACKGAE + "speakerphone_23x26.png";
  public final static String PROJEKTOR_43x26 = PACKGAE + "projector_43x26.png";
  public final static String VIDEOMEETING_25x25 = PACKGAE + "video-meeting-25x25.png";

  public final static String TVTEST_41x26 = PACKGAE + "tv-test-screen_41x26.png";
  public final static String HANDSHAKE_39x26 = PACKGAE + "handshake_39x26.png";
  public final static String SHARE_36x26 = PACKGAE + "Magnify-clip_36x26.png";
  public final static String PHONE_RING = PACKGAE + "phone_ring_25x18.png";
  public final static String FTP = PACKGAE + "peer2peer25x24.png";

  public final static String CHECKABLE = PACKGAE + "formula_25x26.png";
  public final static String CHECK_VALID = PACKGAE + "check-yes_30x26.png";
  public final static String CHECK_INVALID = PACKGAE + "check-no_30x26.png";
  public final static String ODXPLUS = PACKGAE + "green-plus_22x22.png";
  public final static String ODXMINUS = PACKGAE + "remove_22x7.png";
  public final static String ODXREPORT = PACKGAE + "odx_report_26x26.png";
  public final static String ODXMERGE_25x26 = PACKGAE + "merge_25x26.png";
  public final static String ODXIMPORT_26x26 = PACKGAE + "import_26x26.png";
  public final static String ODX_REMOVE_EVS_22x22 = PACKGAE + "delete-table_22x22.png";
  public final static String ODX_MISCHEN = PACKGAE + "cards_29x26.png";
  public final static String ODX_SCHEMA_VALIDIEREN_19x26 = PACKGAE + "clipboard_19x26.png";
  public final static String EXCEL_25x26 = PACKGAE + "x-office-spreadsheet_25x26.png";
  public final static String MASTERMIND_19x26 = PACKGAE + "head-and-brain-outline-th_22x26.png";
  public final static String TESTER_26x26 = PACKGAE + "tester_26x26.png";
  public final static String KING_26x26 = PACKGAE + "king_26x26.png";
  public final static String DEVELOPER_26x26 = PACKGAE + "developer_26x26.png";
  public final static String ODX_26x26 = PACKGAE + "odx_26x26.png";

  // public final static String MICROPHONE = PACKGAE + "microphone_18x25.png";
  public final static String SCHWARZE_LISTE = PACKGAE + "check-list_21x26.png";
  public final static String ADMINISTRATOR = PACKGAE + "admin_27x26.png";
  public final static String INFO_25x25 = PACKGAE + "info_red_25x25.png";
  public final static String WINDOW_LIST = PACKGAE + "blue-open-window_25.png";
  public final static String WINDOW_NEW = PACKGAE + "closed-blue_28x25.png";
  public final static String TELEFONEINRICHTEN_42x26 = PACKGAE + "telephone_42x26.png";
  public final static String PAUSENRAUM = PACKGAE + "pausenraum_26x26.png";
  public final static String CONFIGURE = PACKGAE + "configuration25x25.png";
  public final static String CALL = PACKGAE + "Telephone_receiver_25x23.png";
  public final static String EL_MUNDO = PACKGAE + "welt_26x26.png";
  public final static String FORUM_26x26 = PACKGAE + "forum4_26x26.png";

  public final static String BESPRECUNGSRAUM_35x26 = PACKGAE + "meeting_35x26.png";
  public final static String GRUPPENRAUM_25x26 = PACKGAE + "group_25x26.png";
  public final static String MP3PLAYER = PACKGAE + "audio-x-generic_25x25.png";
  public final static String ODX = PACKGAE + "taxi-madrid_35x26.png";

  // Fonts
  public final static String FONTNAME_THIN = "Nunito-Light";
  public final static String FONTNAME_REGULAR = "Nunito-Regular";
  public final static String FONTNAME_BOLD = "Nunito-Bold";

  public final static String TRUETYPE_THIN = PACKGAE + FONTNAME_THIN + ".ttf";
  public final static String TRUETYPE_REGULAR = PACKGAE + FONTNAME_REGULAR + ".ttf";
  public final static String TRUETYPE_BOLD = PACKGAE + FONTNAME_BOLD + ".ttf";

  // JQUERY
  public static final Color JQUERY_HELLBLAU = new Color(218, 212, 247);
  public static final Color JQUERY_TEXTBRAUN = new Color(52, 43, 9);
  public static final Color JQUERY_BLAU = new Color(68, 36, 214);
  public static final Color JQUERY_RED = new Color(254, 39, 18);
  public static final Color JQUERY_YELLOW = new Color(254, 254, 51);
  public static final Color JQUERY_MOKKA = new Color(217, 217, 217);
//  public static final Color JQUERY_VANILLE = new Color(255, 249, 185);
  public static final Color JQUERY_VANILLE = new Color(243, 229, 171);

  public static Color ENABLED_BUTTON_FOREGROUND = JQUERY_HELLBLAU;
  public static Color ENABLED_BUTTON_BACKGROUND = JQUERY_TEXTBRAUN;
  public static Color DISABLED_BUTTON_FOREGROUND = Color.WHITE;
  public static Color DISABLED_BUTTON_BACKGROUND = JQUERY_RED;

  private WMResource() {}



  /**
   * Registriere einen TrueTypeFont.
   *
   * @param ttf
   *            der TrueTypeFont
   */
  public static Font registerFonts(String ttf) {
    Font font = null;
    try(InputStream input = WMResource.class.getClassLoader().getResourceAsStream(ttf)) {
      font = Font.createFont(Font.TRUETYPE_FONT, input);
      GraphicsEnvironment graphicEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
      // Exception werfen, wenn der Font nicht erstellt werden konnte
      graphicEnvironment.registerFont(font);
    }
    catch (IOException | FontFormatException e) {
      log.error(e.getMessage(), e.getCause());
    }
    return font;
  }

}
