/*
 * Copyright © 2025 Luis Andrés Lange <http://javacomm.net>
 *
 * The MIT Licence
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package net.javacomm.multilingual;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Component.BaselineResizeBehavior;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent.Cause;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.EventListener;
import java.util.Locale;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JInternalFrame.JDesktopIcon;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.AncestorListener;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.InternalFrameUI;
import net.javacomm.multilingual.schema.COMMAND;
import net.javacomm.multilingual.schema.ISO639;
import net.javacomm.multilingual.schema.KEY;
import net.javacomm.multilingual.schema.LANGUAGE;
import net.javacomm.multilingual.schema.LANGUAGES;



/**
 * Dieser InternalFrame kann für Dialoge oder Kurzmeldungen benutzt werden. Die
 * Sprache verändert den Titel auf Deutsch/Englisch/Spanisch.
 * MultilingualInternalFrame ist ein Delegate auf {@code JInternalFrame}.
 */
public class MultilingualInternalFrame implements Babelfish {

//  private final static Logger log = LogManager.getLogger(MultilingualInternalFrame.class);

  private KEY key;
  private JInternalFrame internalFrame;

  /**
   * Dieser Konstruktor ist ein Delegate auf {@code JInternalFrame}.
   * 
   * @param internalFrame
   *                      dieser JInternalFrame
   */
  public MultilingualInternalFrame(JInternalFrame internalFrame) {
    this.internalFrame = internalFrame;
  }



  /**
   * Dieser Konstruktor ist ein Delegate auf {@code JInternalFrame}. Der Titel von
   * JInternalFrame wird in einer bestimmten Sprache erzeugt.
   * 
   * @param key
   *                      der Zugriffsschlüssel auf ein Label
   * @param language
   *                      die angezeigte Sprache
   * @param internalFrame
   *                      dieser JInternalFrame
   */
  public MultilingualInternalFrame(KEY key, ISO639 language, JInternalFrame internalFrame) {
    this(internalFrame);
    setLanguage(key, language);
  }



  /**
   * Dieser Konstruktor ist ein Delegate auf {@code JInternalFrame}. Diesem
   * Konstruktor wird ein Übersetzungsschlüssel übergeben.
   * 
   * @param key
   *                      dieser Schlüssel verweist wählt den Anzeigewert aus der
   *                      {@code multilingual.xml} aus.
   * @param internalFrame
   *                      dieser JInternalFrame
   */
  public MultilingualInternalFrame(KEY key, JInternalFrame internalFrame) {
    this(key, ISO639.DE, internalFrame);
  }



  public boolean action(Event evt, Object what) {
    return internalFrame.action(evt, what);
  }



  public Component add(Component comp) {
    return internalFrame.add(comp);
  }



  public Component add(Component comp, int index) {
    return internalFrame.add(comp, index);
  }



  public void add(Component comp, Object constraints) {
    internalFrame.add(comp, constraints);
  }



  public void add(Component comp, Object constraints, int index) {
    internalFrame.add(comp, constraints, index);
  }



  public void add(PopupMenu popup) {
    internalFrame.add(popup);
  }



  public Component add(String name, Component comp) {
    return internalFrame.add(name, comp);
  }



  public void addAncestorListener(AncestorListener listener) {
    internalFrame.addAncestorListener(listener);
  }



  public void addComponentListener(ComponentListener l) {
    internalFrame.addComponentListener(l);
  }



  public void addContainerListener(ContainerListener l) {
    internalFrame.addContainerListener(l);
  }



  public void addFocusListener(FocusListener l) {
    internalFrame.addFocusListener(l);
  }



  public void addHierarchyBoundsListener(HierarchyBoundsListener l) {
    internalFrame.addHierarchyBoundsListener(l);
  }



  public void addHierarchyListener(HierarchyListener l) {
    internalFrame.addHierarchyListener(l);
  }



  public void addInputMethodListener(InputMethodListener l) {
    internalFrame.addInputMethodListener(l);
  }



  public void addInternalFrameListener(InternalFrameListener l) {
    internalFrame.addInternalFrameListener(l);
  }



  public void addKeyListener(KeyListener l) {
    internalFrame.addKeyListener(l);
  }



  public void addMouseListener(MouseListener l) {
    internalFrame.addMouseListener(l);
  }



  public void addMouseMotionListener(MouseMotionListener l) {
    internalFrame.addMouseMotionListener(l);
  }



  public void addMouseWheelListener(MouseWheelListener l) {
    internalFrame.addMouseWheelListener(l);
  }



  public void addNotify() {
    internalFrame.addNotify();
  }



  public void addPropertyChangeListener(PropertyChangeListener listener) {
    internalFrame.addPropertyChangeListener(listener);
  }



  public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    internalFrame.addPropertyChangeListener(propertyName, listener);
  }



  public void addVetoableChangeListener(VetoableChangeListener listener) {
    internalFrame.addVetoableChangeListener(listener);
  }



  public void applyComponentOrientation(ComponentOrientation o) {
    internalFrame.applyComponentOrientation(o);
  }



  public boolean areFocusTraversalKeysSet(int id) {
    return internalFrame.areFocusTraversalKeysSet(id);
  }



  public Rectangle bounds() {
    return internalFrame.bounds();
  }



  public int checkImage(Image image, ImageObserver observer) {
    return internalFrame.checkImage(image, observer);
  }



  public int checkImage(Image image, int width, int height, ImageObserver observer) {
    return internalFrame.checkImage(image, width, height, observer);
  }



  public void computeVisibleRect(Rectangle visibleRect) {
    internalFrame.computeVisibleRect(visibleRect);
  }



  public boolean contains(int x, int y) {
    return internalFrame.contains(x, y);
  }



  public boolean contains(Point p) {
    return internalFrame.contains(p);
  }



  public int countComponents() {
    return internalFrame.countComponents();
  }



  public Image createImage(ImageProducer producer) {
    return internalFrame.createImage(producer);
  }



  public Image createImage(int width, int height) {
    return internalFrame.createImage(width, height);
  }



  public JToolTip createToolTip() {
    return internalFrame.createToolTip();
  }



  public VolatileImage createVolatileImage(int width, int height) {
    return internalFrame.createVolatileImage(width, height);
  }



  public VolatileImage createVolatileImage(int width, int height, ImageCapabilities caps)
      throws AWTException {
    return internalFrame.createVolatileImage(width, height, caps);
  }



  public void deliverEvent(Event e) {
    internalFrame.deliverEvent(e);
  }



  public void disable() {
    internalFrame.disable();
  }



  public final void dispatchEvent(AWTEvent e) {
    internalFrame.dispatchEvent(e);
  }



  public void dispose() {
    internalFrame.dispose();
  }



  public void doDefaultCloseAction() {
    internalFrame.doDefaultCloseAction();
  }



  public void doLayout() {
    internalFrame.doLayout();
  }



  public void enable() {
    internalFrame.enable();
  }



  public void enable(boolean b) {
    internalFrame.enable(b);
  }



  public void enableInputMethods(boolean enable) {
    internalFrame.enableInputMethods(enable);
  }



  @Override
  public boolean equals(Object obj) {
    return internalFrame.equals(obj);
  }



  public Component findComponentAt(int x, int y) {
    return internalFrame.findComponentAt(x, y);
  }



  public Component findComponentAt(Point p) {
    return internalFrame.findComponentAt(p);
  }



  public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    internalFrame.firePropertyChange(propertyName, oldValue, newValue);
  }



  public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    internalFrame.firePropertyChange(propertyName, oldValue, newValue);
  }



  public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    internalFrame.firePropertyChange(propertyName, oldValue, newValue);
  }



  public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    internalFrame.firePropertyChange(propertyName, oldValue, newValue);
  }



  public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    internalFrame.firePropertyChange(propertyName, oldValue, newValue);
  }



  public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    internalFrame.firePropertyChange(propertyName, oldValue, newValue);
  }



  public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    internalFrame.firePropertyChange(propertyName, oldValue, newValue);
  }



  public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    internalFrame.firePropertyChange(propertyName, oldValue, newValue);
  }



  public AccessibleContext getAccessibleContext() {
    return internalFrame.getAccessibleContext();
  }



  public ActionListener getActionForKeyStroke(KeyStroke aKeyStroke) {
    return internalFrame.getActionForKeyStroke(aKeyStroke);
  }



  public final ActionMap getActionMap() {
    return internalFrame.getActionMap();
  }



  public float getAlignmentX() {
    return internalFrame.getAlignmentX();
  }



  public float getAlignmentY() {
    return internalFrame.getAlignmentY();
  }



  public AncestorListener[] getAncestorListeners() {
    return internalFrame.getAncestorListeners();
  }



  public boolean getAutoscrolls() {
    return internalFrame.getAutoscrolls();
  }



  public Color getBackground() {
    return internalFrame.getBackground();
  }



  public int getBaseline(int width, int height) {
    return internalFrame.getBaseline(width, height);
  }



  public BaselineResizeBehavior getBaselineResizeBehavior() {
    return internalFrame.getBaselineResizeBehavior();
  }



  public Border getBorder() {
    return internalFrame.getBorder();
  }



  public Rectangle getBounds() {
    return internalFrame.getBounds();
  }



  public Rectangle getBounds(Rectangle rv) {
    return internalFrame.getBounds(rv);
  }



  public final Object getClientProperty(Object key) {
    return internalFrame.getClientProperty(key);
  }



  public ColorModel getColorModel() {
    return internalFrame.getColorModel();
  }



  public Component getComponent(int n) {
    return internalFrame.getComponent(n);
  }



  public Component getComponentAt(int x, int y) {
    return internalFrame.getComponentAt(x, y);
  }



  public Component getComponentAt(Point p) {
    return internalFrame.getComponentAt(p);
  }



  public int getComponentCount() {
    return internalFrame.getComponentCount();
  }



  public ComponentListener[] getComponentListeners() {
    return internalFrame.getComponentListeners();
  }



  public ComponentOrientation getComponentOrientation() {
    return internalFrame.getComponentOrientation();
  }



  public JPopupMenu getComponentPopupMenu() {
    return internalFrame.getComponentPopupMenu();
  }



  public Component[] getComponents() {
    return internalFrame.getComponents();
  }



  public int getComponentZOrder(Component comp) {
    return internalFrame.getComponentZOrder(comp);
  }



  public int getConditionForKeyStroke(KeyStroke aKeyStroke) {
    return internalFrame.getConditionForKeyStroke(aKeyStroke);
  }



  public ContainerListener[] getContainerListeners() {
    return internalFrame.getContainerListeners();
  }



  public Container getContentPane() {
    return internalFrame.getContentPane();
  }



  public Cursor getCursor() {
    return internalFrame.getCursor();
  }



  public int getDebugGraphicsOptions() {
    return internalFrame.getDebugGraphicsOptions();
  }



  public int getDefaultCloseOperation() {
    return internalFrame.getDefaultCloseOperation();
  }



  public JDesktopIcon getDesktopIcon() {
    return internalFrame.getDesktopIcon();
  }



  public JDesktopPane getDesktopPane() {
    return internalFrame.getDesktopPane();
  }



  public DropTarget getDropTarget() {
    return internalFrame.getDropTarget();
  }



  public final Container getFocusCycleRootAncestor() {
    return internalFrame.getFocusCycleRootAncestor();
  }



  public FocusListener[] getFocusListeners() {
    return internalFrame.getFocusListeners();
  }



  public Component getFocusOwner() {
    return internalFrame.getFocusOwner();
  }



  public Set<AWTKeyStroke> getFocusTraversalKeys(int id) {
    return internalFrame.getFocusTraversalKeys(id);
  }



  public boolean getFocusTraversalKeysEnabled() {
    return internalFrame.getFocusTraversalKeysEnabled();
  }



  public FocusTraversalPolicy getFocusTraversalPolicy() {
    return internalFrame.getFocusTraversalPolicy();
  }



  public Font getFont() {
    return internalFrame.getFont();
  }



  public FontMetrics getFontMetrics(Font font) {
    return internalFrame.getFontMetrics(font);
  }



  public Color getForeground() {
    return internalFrame.getForeground();
  }



  public Icon getFrameIcon() {
    return internalFrame.getFrameIcon();
  }



  public Component getGlassPane() {
    return internalFrame.getGlassPane();
  }



  public Graphics getGraphics() {
    return internalFrame.getGraphics();
  }



  public GraphicsConfiguration getGraphicsConfiguration() {
    return internalFrame.getGraphicsConfiguration();
  }



  public int getHeight() {
    return internalFrame.getHeight();
  }



  public HierarchyBoundsListener[] getHierarchyBoundsListeners() {
    return internalFrame.getHierarchyBoundsListeners();
  }



  public HierarchyListener[] getHierarchyListeners() {
    return internalFrame.getHierarchyListeners();
  }



  public boolean getIgnoreRepaint() {
    return internalFrame.getIgnoreRepaint();
  }



  public boolean getInheritsPopupMenu() {
    return internalFrame.getInheritsPopupMenu();
  }



  public InputContext getInputContext() {
    return internalFrame.getInputContext();
  }



  public final InputMap getInputMap() {
    return internalFrame.getInputMap();
  }



  public final InputMap getInputMap(int condition) {
    return internalFrame.getInputMap(condition);
  }



  public InputMethodListener[] getInputMethodListeners() {
    return internalFrame.getInputMethodListeners();
  }



  public InputMethodRequests getInputMethodRequests() {
    return internalFrame.getInputMethodRequests();
  }



  public InputVerifier getInputVerifier() {
    return internalFrame.getInputVerifier();
  }



  public Insets getInsets() {
    return internalFrame.getInsets();
  }



  public Insets getInsets(Insets insets) {
    return internalFrame.getInsets(insets);
  }



  public InternalFrameListener[] getInternalFrameListeners() {
    return internalFrame.getInternalFrameListeners();
  }



  public JMenuBar getJMenuBar() {
    return internalFrame.getJMenuBar();
  }



  public KeyListener[] getKeyListeners() {
    return internalFrame.getKeyListeners();
  }



  public Cursor getLastCursor() {
    return internalFrame.getLastCursor();
  }



  public int getLayer() {
    return internalFrame.getLayer();
  }



  public JLayeredPane getLayeredPane() {
    return internalFrame.getLayeredPane();
  }



  public LayoutManager getLayout() {
    return internalFrame.getLayout();
  }



  public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
    return internalFrame.getListeners(listenerType);
  }



  public Locale getLocale() {
    return internalFrame.getLocale();
  }



  public Point getLocation() {
    return internalFrame.getLocation();
  }



  public Point getLocation(Point rv) {
    return internalFrame.getLocation(rv);
  }



  public Point getLocationOnScreen() {
    return internalFrame.getLocationOnScreen();
  }



  public Dimension getMaximumSize() {
    return internalFrame.getMaximumSize();
  }



  public JMenuBar getMenuBar() {
    return internalFrame.getMenuBar();
  }



  public Dimension getMinimumSize() {
    return internalFrame.getMinimumSize();
  }



  public Component getMostRecentFocusOwner() {
    return internalFrame.getMostRecentFocusOwner();
  }



  public MouseListener[] getMouseListeners() {
    return internalFrame.getMouseListeners();
  }



  public MouseMotionListener[] getMouseMotionListeners() {
    return internalFrame.getMouseMotionListeners();
  }



  public Point getMousePosition() throws HeadlessException {
    return internalFrame.getMousePosition();
  }



  public Point getMousePosition(boolean allowChildren) throws HeadlessException {
    return internalFrame.getMousePosition(allowChildren);
  }



  public MouseWheelListener[] getMouseWheelListeners() {
    return internalFrame.getMouseWheelListeners();
  }



  public String getName() {
    return internalFrame.getName();
  }



  public Component getNextFocusableComponent() {
    return internalFrame.getNextFocusableComponent();
  }



  public Rectangle getNormalBounds() {
    return internalFrame.getNormalBounds();
  }



  public Container getParent() {
    return internalFrame.getParent();
  }



  public Point getPopupLocation(MouseEvent event) {
    return internalFrame.getPopupLocation(event);
  }



  public Dimension getPreferredSize() {
    return internalFrame.getPreferredSize();
  }



  public PropertyChangeListener[] getPropertyChangeListeners() {
    return internalFrame.getPropertyChangeListeners();
  }



  public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
    return internalFrame.getPropertyChangeListeners(propertyName);
  }



  public KeyStroke[] getRegisteredKeyStrokes() {
    return internalFrame.getRegisteredKeyStrokes();
  }



  public JRootPane getRootPane() {
    return internalFrame.getRootPane();
  }



  public Dimension getSize() {
    return internalFrame.getSize();
  }



  public Dimension getSize(Dimension rv) {
    return internalFrame.getSize(rv);
  }



  public String getTitle() {
    return internalFrame.getTitle();
  }



  public Toolkit getToolkit() {
    return internalFrame.getToolkit();
  }



  public Point getToolTipLocation(MouseEvent event) {
    return internalFrame.getToolTipLocation(event);
  }



  public String getToolTipText() {
    return internalFrame.getToolTipText();
  }



  public String getToolTipText(MouseEvent event) {
    return internalFrame.getToolTipText(event);
  }



  public Container getTopLevelAncestor() {
    return internalFrame.getTopLevelAncestor();
  }



  public TransferHandler getTransferHandler() {
    return internalFrame.getTransferHandler();
  }



  public final Object getTreeLock() {
    return internalFrame.getTreeLock();
  }



  public InternalFrameUI getUI() {
    return internalFrame.getUI();
  }



  public String getUIClassID() {
    return internalFrame.getUIClassID();
  }



  public boolean getVerifyInputWhenFocusTarget() {
    return internalFrame.getVerifyInputWhenFocusTarget();
  }



  public VetoableChangeListener[] getVetoableChangeListeners() {
    return internalFrame.getVetoableChangeListeners();
  }



  public Rectangle getVisibleRect() {
    return internalFrame.getVisibleRect();
  }



  public final String getWarningString() {
    return internalFrame.getWarningString();
  }



  public int getWidth() {
    return internalFrame.getWidth();
  }



  public int getX() {
    return internalFrame.getX();
  }



  public int getY() {
    return internalFrame.getY();
  }



  public boolean gotFocus(Event evt, Object what) {
    return internalFrame.gotFocus(evt, what);
  }



  public void grabFocus() {
    internalFrame.grabFocus();
  }



  public boolean handleEvent(Event evt) {
    return internalFrame.handleEvent(evt);
  }



  public boolean hasFocus() {
    return internalFrame.hasFocus();
  }



  @Override
  public int hashCode() {
    return internalFrame.hashCode();
  }



  public void hide() {
    internalFrame.hide();
  }



  public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
    return internalFrame.imageUpdate(img, infoflags, x, y, w, h);
  }



  public Insets insets() {
    return internalFrame.insets();
  }



  public boolean inside(int x, int y) {
    return internalFrame.inside(x, y);
  }



  public void invalidate() {
    internalFrame.invalidate();
  }



  public boolean isAncestorOf(Component c) {
    return internalFrame.isAncestorOf(c);
  }



  public boolean isBackgroundSet() {
    return internalFrame.isBackgroundSet();
  }



  public boolean isClosable() {
    return internalFrame.isClosable();
  }



  public boolean isClosed() {
    return internalFrame.isClosed();
  }



  public boolean isCursorSet() {
    return internalFrame.isCursorSet();
  }



  public boolean isDisplayable() {
    return internalFrame.isDisplayable();
  }



  public boolean isDoubleBuffered() {
    return internalFrame.isDoubleBuffered();
  }



  public boolean isEnabled() {
    return internalFrame.isEnabled();
  }



  public boolean isFocusable() {
    return internalFrame.isFocusable();
  }



  public final boolean isFocusCycleRoot() {
    return internalFrame.isFocusCycleRoot();
  }



  public boolean isFocusCycleRoot(Container container) {
    return internalFrame.isFocusCycleRoot(container);
  }



  public boolean isFocusOwner() {
    return internalFrame.isFocusOwner();
  }



  public boolean isFocusTraversable() {
    return internalFrame.isFocusTraversable();
  }



  public final boolean isFocusTraversalPolicyProvider() {
    return internalFrame.isFocusTraversalPolicyProvider();
  }



  public boolean isFocusTraversalPolicySet() {
    return internalFrame.isFocusTraversalPolicySet();
  }



  public boolean isFontSet() {
    return internalFrame.isFontSet();
  }



  public boolean isForegroundSet() {
    return internalFrame.isForegroundSet();
  }



  public boolean isIcon() {
    return internalFrame.isIcon();
  }



  public boolean isIconifiable() {
    return internalFrame.isIconifiable();
  }



  public boolean isLightweight() {
    return internalFrame.isLightweight();
  }



  public boolean isManagingFocus() {
    return internalFrame.isManagingFocus();
  }



  public boolean isMaximizable() {
    return internalFrame.isMaximizable();
  }



  public boolean isMaximum() {
    return internalFrame.isMaximum();
  }



  public boolean isMaximumSizeSet() {
    return internalFrame.isMaximumSizeSet();
  }



  public boolean isMinimumSizeSet() {
    return internalFrame.isMinimumSizeSet();
  }



  public boolean isOpaque() {
    return internalFrame.isOpaque();
  }



  public boolean isOptimizedDrawingEnabled() {
    return internalFrame.isOptimizedDrawingEnabled();
  }



  public final boolean isPaintingForPrint() {
    return internalFrame.isPaintingForPrint();
  }



  public boolean isPaintingTile() {
    return internalFrame.isPaintingTile();
  }



  public boolean isPreferredSizeSet() {
    return internalFrame.isPreferredSizeSet();
  }



  public boolean isRequestFocusEnabled() {
    return internalFrame.isRequestFocusEnabled();
  }



  public boolean isResizable() {
    return internalFrame.isResizable();
  }



  public boolean isSelected() {
    return internalFrame.isSelected();
  }



  public boolean isShowing() {
    return internalFrame.isShowing();
  }



  public boolean isValid() {
    return internalFrame.isValid();
  }



  public boolean isValidateRoot() {
    return internalFrame.isValidateRoot();
  }



  public boolean isVisible() {
    return internalFrame.isVisible();
  }



  public boolean keyDown(Event evt, int key) {
    return internalFrame.keyDown(evt, key);
  }



  public boolean keyUp(Event evt, int key) {
    return internalFrame.keyUp(evt, key);
  }



  public void layout() {
    internalFrame.layout();
  }



  public void list() {
    internalFrame.list();
  }



  public void list(PrintStream out) {
    internalFrame.list(out);
  }



  public void list(PrintStream out, int indent) {
    internalFrame.list(out, indent);
  }



  public void list(PrintWriter out) {
    internalFrame.list(out);
  }



  public void list(PrintWriter out, int indent) {
    internalFrame.list(out, indent);
  }



  public Component locate(int x, int y) {
    return internalFrame.locate(x, y);
  }



  public Point location() {
    return internalFrame.location();
  }



  public boolean lostFocus(Event evt, Object what) {
    return internalFrame.lostFocus(evt, what);
  }



  public Dimension minimumSize() {
    return internalFrame.minimumSize();
  }



  public boolean mouseDown(Event evt, int x, int y) {
    return internalFrame.mouseDown(evt, x, y);
  }



  public boolean mouseDrag(Event evt, int x, int y) {
    return internalFrame.mouseDrag(evt, x, y);
  }



  public boolean mouseEnter(Event evt, int x, int y) {
    return internalFrame.mouseEnter(evt, x, y);
  }



  public boolean mouseExit(Event evt, int x, int y) {
    return internalFrame.mouseExit(evt, x, y);
  }



  public boolean mouseMove(Event evt, int x, int y) {
    return internalFrame.mouseMove(evt, x, y);
  }



  public boolean mouseUp(Event evt, int x, int y) {
    return internalFrame.mouseUp(evt, x, y);
  }



  public void move(int x, int y) {
    internalFrame.move(x, y);
  }



  public void moveToBack() {
    internalFrame.moveToBack();
  }



  public void moveToFront() {
    internalFrame.moveToFront();
  }



  public void nextFocus() {
    internalFrame.nextFocus();
  }



  public void pack() {
    internalFrame.pack();
  }



  public void paint(Graphics g) {
    internalFrame.paint(g);
  }



  public void paintAll(Graphics g) {
    internalFrame.paintAll(g);
  }



  public void paintComponents(Graphics g) {
    internalFrame.paintComponents(g);
  }



  public void paintImmediately(int x, int y, int w, int h) {
    internalFrame.paintImmediately(x, y, w, h);
  }



  public void paintImmediately(Rectangle r) {
    internalFrame.paintImmediately(r);
  }



  public boolean postEvent(Event e) {
    return internalFrame.postEvent(e);
  }



  public Dimension preferredSize() {
    return internalFrame.preferredSize();
  }



  public boolean prepareImage(Image image, ImageObserver observer) {
    return internalFrame.prepareImage(image, observer);
  }



  public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
    return internalFrame.prepareImage(image, width, height, observer);
  }



  public void print(Graphics g) {
    internalFrame.print(g);
  }



  public void printAll(Graphics g) {
    internalFrame.printAll(g);
  }



  public void printComponents(Graphics g) {
    internalFrame.printComponents(g);
  }



  public final void putClientProperty(Object key, Object value) {
    internalFrame.putClientProperty(key, value);
  }



  public void registerKeyboardAction(ActionListener anAction, KeyStroke aKeyStroke, int aCondition) {
    internalFrame.registerKeyboardAction(anAction, aKeyStroke, aCondition);
  }



  public void registerKeyboardAction(ActionListener anAction, String aCommand, KeyStroke aKeyStroke,
      int aCondition) {
    internalFrame.registerKeyboardAction(anAction, aCommand, aKeyStroke, aCondition);
  }



  public void remove(Component comp) {
    internalFrame.remove(comp);
  }



  public void remove(int index) {
    internalFrame.remove(index);
  }



  public void remove(MenuComponent popup) {
    internalFrame.remove(popup);
  }



  public void removeAll() {
    internalFrame.removeAll();
  }



  public void removeAncestorListener(AncestorListener listener) {
    internalFrame.removeAncestorListener(listener);
  }



  public void removeComponentListener(ComponentListener l) {
    internalFrame.removeComponentListener(l);
  }



  public void removeContainerListener(ContainerListener l) {
    internalFrame.removeContainerListener(l);
  }



  public void removeFocusListener(FocusListener l) {
    internalFrame.removeFocusListener(l);
  }



  public void removeHierarchyBoundsListener(HierarchyBoundsListener l) {
    internalFrame.removeHierarchyBoundsListener(l);
  }



  public void removeHierarchyListener(HierarchyListener l) {
    internalFrame.removeHierarchyListener(l);
  }



  public void removeInputMethodListener(InputMethodListener l) {
    internalFrame.removeInputMethodListener(l);
  }



  public void removeInternalFrameListener(InternalFrameListener l) {
    internalFrame.removeInternalFrameListener(l);
  }



  public void removeKeyListener(KeyListener l) {
    internalFrame.removeKeyListener(l);
  }



  public void removeMouseListener(MouseListener l) {
    internalFrame.removeMouseListener(l);
  }



  public void removeMouseMotionListener(MouseMotionListener l) {
    internalFrame.removeMouseMotionListener(l);
  }



  public void removeMouseWheelListener(MouseWheelListener l) {
    internalFrame.removeMouseWheelListener(l);
  }



  public void removeNotify() {
    internalFrame.removeNotify();
  }



  public void removePropertyChangeListener(PropertyChangeListener listener) {
    internalFrame.removePropertyChangeListener(listener);
  }



  public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    internalFrame.removePropertyChangeListener(propertyName, listener);
  }



  public void removeVetoableChangeListener(VetoableChangeListener listener) {
    internalFrame.removeVetoableChangeListener(listener);
  }



  public void repaint() {
    internalFrame.repaint();
  }



  public void repaint(int x, int y, int width, int height) {
    internalFrame.repaint(x, y, width, height);
  }



  public void repaint(long tm) {
    internalFrame.repaint(tm);
  }



  public void repaint(long tm, int x, int y, int width, int height) {
    internalFrame.repaint(tm, x, y, width, height);
  }



  public void repaint(Rectangle r) {
    internalFrame.repaint(r);
  }



  public boolean requestDefaultFocus() {
    return internalFrame.requestDefaultFocus();
  }



  public void requestFocus() {
    internalFrame.requestFocus();
  }



  public boolean requestFocus(boolean temporary) {
    return internalFrame.requestFocus(temporary);
  }



  public void requestFocus(Cause cause) {
    internalFrame.requestFocus(cause);
  }



  public boolean requestFocusInWindow() {
    return internalFrame.requestFocusInWindow();
  }



  public boolean requestFocusInWindow(Cause cause) {
    return internalFrame.requestFocusInWindow(cause);
  }



  public void resetKeyboardActions() {
    internalFrame.resetKeyboardActions();
  }



  public void reshape(int x, int y, int width, int height) {
    internalFrame.reshape(x, y, width, height);
  }



  public void resize(Dimension d) {
    internalFrame.resize(d);
  }



  public void resize(int width, int height) {
    internalFrame.resize(width, height);
  }



  public void restoreSubcomponentFocus() {
    internalFrame.restoreSubcomponentFocus();
  }



  public void revalidate() {
    internalFrame.revalidate();
  }



  public void scrollRectToVisible(Rectangle aRect) {
    internalFrame.scrollRectToVisible(aRect);
  }



  public final void setActionMap(ActionMap am) {
    internalFrame.setActionMap(am);
  }



  public void setAlignmentX(float alignmentX) {
    internalFrame.setAlignmentX(alignmentX);
  }



  public void setAlignmentY(float alignmentY) {
    internalFrame.setAlignmentY(alignmentY);
  }



  public void setAutoscrolls(boolean autoscrolls) {
    internalFrame.setAutoscrolls(autoscrolls);
  }



  public void setBackground(Color bg) {
    internalFrame.setBackground(bg);
  }



  public void setBorder(Border border) {
    internalFrame.setBorder(border);
  }



  public void setBounds(int x, int y, int width, int height) {
    internalFrame.setBounds(x, y, width, height);
  }



  public void setBounds(Rectangle r) {
    internalFrame.setBounds(r);
  }



  public void setClosable(boolean b) {
    internalFrame.setClosable(b);
  }



  public void setClosed(boolean b) throws PropertyVetoException {
    internalFrame.setClosed(b);
  }



  public void setComponentOrientation(ComponentOrientation o) {
    internalFrame.setComponentOrientation(o);
  }



  public void setComponentPopupMenu(JPopupMenu popup) {
    internalFrame.setComponentPopupMenu(popup);
  }



  public void setComponentZOrder(Component comp, int index) {
    internalFrame.setComponentZOrder(comp, index);
  }



  public void setContentPane(Container c) {
    internalFrame.setContentPane(c);
  }



  public void setCursor(Cursor cursor) {
    internalFrame.setCursor(cursor);
  }



  public void setDebugGraphicsOptions(int debugOptions) {
    internalFrame.setDebugGraphicsOptions(debugOptions);
  }



  public void setDefaultCloseOperation(int operation) {
    internalFrame.setDefaultCloseOperation(operation);
  }



  public void setDesktopIcon(JDesktopIcon d) {
    internalFrame.setDesktopIcon(d);
  }



  public void setDoubleBuffered(boolean aFlag) {
    internalFrame.setDoubleBuffered(aFlag);
  }



  public void setDropTarget(DropTarget dt) {
    internalFrame.setDropTarget(dt);
  }



  public void setEnabled(boolean enabled) {
    internalFrame.setEnabled(enabled);
  }



  public void setFocusable(boolean focusable) {
    internalFrame.setFocusable(focusable);
  }



  public final void setFocusCycleRoot(boolean focusCycleRoot) {
    internalFrame.setFocusCycleRoot(focusCycleRoot);
  }



  public void setFocusTraversalKeys(int id, Set<? extends AWTKeyStroke> keystrokes) {
    internalFrame.setFocusTraversalKeys(id, keystrokes);
  }



  public void setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
    internalFrame.setFocusTraversalKeysEnabled(focusTraversalKeysEnabled);
  }



  public void setFocusTraversalPolicy(FocusTraversalPolicy policy) {
    internalFrame.setFocusTraversalPolicy(policy);
  }



  public final void setFocusTraversalPolicyProvider(boolean provider) {
    internalFrame.setFocusTraversalPolicyProvider(provider);
  }



  public void setFont(Font font) {
    internalFrame.setFont(font);
  }



  public void setForeground(Color fg) {
    internalFrame.setForeground(fg);
  }



  public void setFrameIcon(Icon icon) {
    internalFrame.setFrameIcon(icon);
  }



  public void setGlassPane(Component glass) {
    internalFrame.setGlassPane(glass);
  }



  public void setIcon(boolean b) throws PropertyVetoException {
    internalFrame.setIcon(b);
  }



  public void setIconifiable(boolean b) {
    internalFrame.setIconifiable(b);
  }



  public void setIgnoreRepaint(boolean ignoreRepaint) {
    internalFrame.setIgnoreRepaint(ignoreRepaint);
  }



  public void setInheritsPopupMenu(boolean value) {
    internalFrame.setInheritsPopupMenu(value);
  }



  public final void setInputMap(int condition, InputMap map) {
    internalFrame.setInputMap(condition, map);
  }



  public void setInputVerifier(InputVerifier inputVerifier) {
    internalFrame.setInputVerifier(inputVerifier);
  }



  public void setJMenuBar(JMenuBar m) {
    internalFrame.setJMenuBar(m);
  }



  @Override
  public void setLanguage(ISO639 code) {
    setLanguage(key, code);
  }



  /**
   * Die Sprache darf jederzeit geändert werden.
   *
   * @param key
   *                 der Schlüssel für das ausgewählte Kommando
   * @param language
   *                 der Text wird in dieser Sprache angezeigt
   */
  public void setLanguage(KEY key, ISO639 language) {
    if (key == null) throw new IllegalArgumentException("key ist null");
    if (language == null) throw new IllegalArgumentException("language ist null");
    this.key = key;
    COMMAND command = Multilingual.getInstance().getCommand(this.key);
    LANGUAGES languages = command.getLANGUAGES();
    if (languages == null) return;
    for (LANGUAGE tmp : languages.getLANGUAGE()) {
      if (tmp.getISO639() != language) continue;
      if (tmp.getTEXT() != null) {
        setTitle(tmp.getTEXT());
      }
      break;
    }
  }



  public void setLayer(int layer) {
    internalFrame.setLayer(layer);
  }



  public void setLayer(Integer layer) {
    internalFrame.setLayer(layer);
  }



  public void setLayeredPane(JLayeredPane layered) {
    internalFrame.setLayeredPane(layered);
  }



  public void setLayout(LayoutManager manager) {
    internalFrame.setLayout(manager);
  }



  public void setLocale(Locale l) {
    internalFrame.setLocale(l);
  }



  public void setLocation(int x, int y) {
    internalFrame.setLocation(x, y);
  }



  public void setLocation(Point p) {
    internalFrame.setLocation(p);
  }



  public void setMaximizable(boolean b) {
    internalFrame.setMaximizable(b);
  }



  public void setMaximum(boolean b) throws PropertyVetoException {
    internalFrame.setMaximum(b);
  }



  public void setMaximumSize(Dimension maximumSize) {
    internalFrame.setMaximumSize(maximumSize);
  }



  public void setMenuBar(JMenuBar m) {
    internalFrame.setMenuBar(m);
  }



  public void setMinimumSize(Dimension minimumSize) {
    internalFrame.setMinimumSize(minimumSize);
  }



  public void setMixingCutoutShape(Shape shape) {
    internalFrame.setMixingCutoutShape(shape);
  }



  public void setName(String name) {
    internalFrame.setName(name);
  }



  public void setNextFocusableComponent(Component aComponent) {
    internalFrame.setNextFocusableComponent(aComponent);
  }



  public void setNormalBounds(Rectangle r) {
    internalFrame.setNormalBounds(r);
  }



  public void setOpaque(boolean isOpaque) {
    internalFrame.setOpaque(isOpaque);
  }



  public void setPreferredSize(Dimension preferredSize) {
    internalFrame.setPreferredSize(preferredSize);
  }



  public void setRequestFocusEnabled(boolean requestFocusEnabled) {
    internalFrame.setRequestFocusEnabled(requestFocusEnabled);
  }



  public void setResizable(boolean b) {
    internalFrame.setResizable(b);
  }



  public void setSelected(boolean selected) throws PropertyVetoException {
    internalFrame.setSelected(selected);
  }



  public void setSize(Dimension d) {
    internalFrame.setSize(d);
  }



  public void setSize(int width, int height) {
    internalFrame.setSize(width, height);
  }



  public void setTitle(String title) {
    internalFrame.setTitle(title);
  }



  public void setToolTipText(String text) {
    internalFrame.setToolTipText(text);
  }



  public void setTransferHandler(TransferHandler newHandler) {
    internalFrame.setTransferHandler(newHandler);
  }



  public void setUI(InternalFrameUI ui) {
    internalFrame.setUI(ui);
  }



  public void setVerifyInputWhenFocusTarget(boolean verifyInputWhenFocusTarget) {
    internalFrame.setVerifyInputWhenFocusTarget(verifyInputWhenFocusTarget);
  }



  public void setVisible(boolean aFlag) {
    internalFrame.setVisible(aFlag);
  }



  public void show() {
    internalFrame.show();
  }



  public void show(boolean b) {
    internalFrame.show(b);
  }



  public Dimension size() {
    return internalFrame.size();
  }



  public void toBack() {
    internalFrame.toBack();
  }



  public void toFront() {
    internalFrame.toFront();
  }



  @Override
  public String toString() {
    return internalFrame.toString();
  }



  public void transferFocus() {
    internalFrame.transferFocus();
  }



  public void transferFocusBackward() {
    internalFrame.transferFocusBackward();
  }



  public void transferFocusDownCycle() {
    internalFrame.transferFocusDownCycle();
  }



  public void transferFocusUpCycle() {
    internalFrame.transferFocusUpCycle();
  }



  public void unregisterKeyboardAction(KeyStroke aKeyStroke) {
    internalFrame.unregisterKeyboardAction(aKeyStroke);
  }



  public void update(Graphics g) {
    internalFrame.update(g);
  }



  public void updateUI() {
    internalFrame.updateUI();
  }



  public void validate() {
    internalFrame.validate();
  }

}
