package net.javacomm.multilingual;

import static org.junit.jupiter.api.Assertions.assertNotNull;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.XMLConstants;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.xml.sax.SAXException;
import net.javacomm.multilingual.schema.COMMAND;
import net.javacomm.multilingual.schema.COMMANDS;
import net.javacomm.multilingual.schema.ISO639;
import net.javacomm.multilingual.schema.KEY;
import net.javacomm.multilingual.schema.LANGUAGE;
import net.javacomm.multilingual.schema.LANGUAGES;
import net.javacomm.multilingual.schema.MULTILINGUAL;
import net.javacomm.multilingual.schema.ObjectFactory;
import net.javacomm.multilingual.schema.VIRTUALKEY;



public class TestMultilingual {

  private final static Logger log = LogManager.getLogger(TestMultilingual.class);

  MULTILINGUAL multilingual;
  Path path;
  SchemaFactory schemafactory;
  StreamSource source;
  Schema schema;
  Path schemaFile;

  @Test
  @DisplayName("Standard-Multilingual-Xml-Datei")
  public void createXml() throws JAXBException, IOException, SAXException {

    COMMAND commandJavacomm = new COMMAND();
    commandJavacomm.setKEY(KEY.JAVACOMM);
    LANGUAGES languagesJavacomm = new LANGUAGES();

    LANGUAGE languageJavacommDE = new LANGUAGE();
    languageJavacommDE.setISO639(ISO639.DE);
    languageJavacommDE.setTEXT("JavaComm");
    languageJavacommDE.setSHORTCUT(VIRTUALKEY.VK_J);

    LANGUAGE languageJavacommEN = new LANGUAGE();
    languageJavacommEN.setISO639(ISO639.EN);
    languageJavacommEN.setTEXT("JavaComm");
    languageJavacommEN.setSHORTCUT(VIRTUALKEY.VK_J);

    LANGUAGE languageJavacommES = new LANGUAGE();
    languageJavacommES.setISO639(ISO639.ES);
    languageJavacommES.setTEXT("JavaComm");
    languageJavacommES.setSHORTCUT(VIRTUALKEY.VK_J);

    languagesJavacomm.getLANGUAGE().add(languageJavacommDE);
    languagesJavacomm.getLANGUAGE().add(languageJavacommEN);
    languagesJavacomm.getLANGUAGE().add(languageJavacommES);
    commandJavacomm.setLANGUAGES(languagesJavacomm);

    COMMAND commandRegistrieren = new COMMAND();
    commandRegistrieren.setKEY(KEY.REGISTRIEREN);
    LANGUAGES languagesRegistrieren = new LANGUAGES();

    LANGUAGE languageRegistrierenDE = new LANGUAGE();
    languageRegistrierenDE.setISO639(ISO639.DE);
    languageRegistrierenDE.setTEXT("Registrieren");

    LANGUAGE languageRegistrierenEN = new LANGUAGE();
    languageRegistrierenEN.setISO639(ISO639.EN);
    languageRegistrierenEN.setTEXT("Register");

    LANGUAGE languageRegistrierenES = new LANGUAGE();
    languageRegistrierenES.setISO639(ISO639.ES);
    languageRegistrierenES.setTEXT("Registrarse");

    languagesRegistrieren.getLANGUAGE().add(languageRegistrierenDE);
    languagesRegistrieren.getLANGUAGE().add(languageRegistrierenEN);
    languagesRegistrieren.getLANGUAGE().add(languageRegistrierenES);
    commandRegistrieren.setLANGUAGES(languagesRegistrieren);

    COMMAND commandAnmelden = new COMMAND();
    commandAnmelden.setKEY(KEY.ANMELDEN);
    LANGUAGES languagesAnmelden = new LANGUAGES();

    LANGUAGE languageAnmeldenDE = new LANGUAGE();
    languageAnmeldenDE.setISO639(ISO639.DE);
    languageAnmeldenDE.setTEXT("Anmelden");

    LANGUAGE languageAnmeldenEN = new LANGUAGE();
    languageAnmeldenEN.setISO639(ISO639.EN);
    languageAnmeldenEN.setTEXT("Login");

    LANGUAGE languageAnmeldenES = new LANGUAGE();
    languageAnmeldenES.setISO639(ISO639.ES);
    languageAnmeldenES.setTEXT("Iniciar sesión");

    languagesAnmelden.getLANGUAGE().add(languageAnmeldenDE);
    languagesAnmelden.getLANGUAGE().add(languageAnmeldenEN);
    languagesAnmelden.getLANGUAGE().add(languageAnmeldenES);
    commandAnmelden.setLANGUAGES(languagesAnmelden);

    COMMAND commandPasswort = new COMMAND();
    commandPasswort.setKEY(KEY.NEUES_PASSWORT_ANFORDERN);
    LANGUAGES languagesPasswort = new LANGUAGES();

    LANGUAGE languagePasswortDE = new LANGUAGE();
    languagePasswortDE.setISO639(ISO639.DE);
    languagePasswortDE.setTEXT("Neues Passwort anfordern");

    LANGUAGE languagePasswortEN = new LANGUAGE();
    languagePasswortEN.setISO639(ISO639.EN);
    languagePasswortEN.setTEXT("Request password");

    LANGUAGE languagePasswortES = new LANGUAGE();
    languagePasswortES.setISO639(ISO639.ES);
    languagePasswortES.setTEXT("Solicitar contraseña");

    languagesPasswort.getLANGUAGE().add(languagePasswortDE);
    languagesPasswort.getLANGUAGE().add(languagePasswortEN);
    languagesPasswort.getLANGUAGE().add(languagePasswortES);
    commandPasswort.setLANGUAGES(languagesPasswort);

    COMMAND commandAufWiedersehen = new COMMAND();
    commandAufWiedersehen.setKEY(KEY.AUF_WIEDERSEHEN);
    LANGUAGES languagesAufWiedersehen = new LANGUAGES();

    LANGUAGE languageAufWiedersehenDE = new LANGUAGE();
    languageAufWiedersehenDE.setISO639(ISO639.DE);
    languageAufWiedersehenDE.setTEXT("Auf Wiedersehen");

    LANGUAGE languageAufWiedersehenEN = new LANGUAGE();
    languageAufWiedersehenEN.setISO639(ISO639.EN);
    languageAufWiedersehenEN.setTEXT("Bye");

    LANGUAGE languageAufWiedersehenES = new LANGUAGE();
    languageAufWiedersehenES.setISO639(ISO639.ES);
    languageAufWiedersehenES.setTEXT("Hasta la próxima");

    languagesAufWiedersehen.getLANGUAGE().add(languageAufWiedersehenDE);
    languagesAufWiedersehen.getLANGUAGE().add(languageAufWiedersehenEN);
    languagesAufWiedersehen.getLANGUAGE().add(languageAufWiedersehenES);
    commandAufWiedersehen.setLANGUAGES(languagesAufWiedersehen);

    COMMANDS commands = new COMMANDS();
    multilingual.setCOMMANDS(commands);

    COMMAND commandKonto = new COMMAND();
    commandKonto.setKEY(KEY.KONTO);
    LANGUAGES kontoLanguages = new LANGUAGES();

    LANGUAGE kontoLanguageDE = new LANGUAGE();
    kontoLanguageDE.setISO639(ISO639.DE);
    kontoLanguageDE.setTEXT("Konto");
    kontoLanguageDE.setSHORTCUT(VIRTUALKEY.VK_K);

    LANGUAGE kontoLanguageEN = new LANGUAGE();
    kontoLanguageEN.setISO639(ISO639.EN);
    kontoLanguageEN.setTEXT("Account");
    kontoLanguageEN.setSHORTCUT(VIRTUALKEY.VK_A);

    LANGUAGE kontoLanguageES = new LANGUAGE();
    kontoLanguageES.setISO639(ISO639.ES);
    kontoLanguageES.setTEXT("Cuenta");
    kontoLanguageES.setSHORTCUT(VIRTUALKEY.VK_U);

    kontoLanguages.getLANGUAGE().add(kontoLanguageDE);
    kontoLanguages.getLANGUAGE().add(kontoLanguageEN);
    kontoLanguages.getLANGUAGE().add(kontoLanguageES);
    commandKonto.setLANGUAGES(kontoLanguages);

    COMMAND commandBearbeiten = new COMMAND();
    commandBearbeiten.setKEY(KEY.BERABEITEN);
    LANGUAGES bearbeitenLanguages = new LANGUAGES();

    LANGUAGE bearbeitenLanguageDE = new LANGUAGE();
    bearbeitenLanguageDE.setISO639(ISO639.DE);
    bearbeitenLanguageDE.setTEXT("Bearbeiten");

    LANGUAGE bearbeitenLanguageEN = new LANGUAGE();
    bearbeitenLanguageEN.setISO639(ISO639.EN);
    bearbeitenLanguageEN.setTEXT("Edit");

    LANGUAGE bearbeitenLanguageES = new LANGUAGE();
    bearbeitenLanguageES.setISO639(ISO639.ES);
    bearbeitenLanguageES.setTEXT("Editar");

    bearbeitenLanguages.getLANGUAGE().add(bearbeitenLanguageDE);
    bearbeitenLanguages.getLANGUAGE().add(bearbeitenLanguageEN);
    bearbeitenLanguages.getLANGUAGE().add(bearbeitenLanguageES);

    commandBearbeiten.setLANGUAGES(bearbeitenLanguages);

    COMMAND commandEis = new COMMAND();
    commandEis.setKEY(KEY.EIS);
    LANGUAGES languagesEis = new LANGUAGES();
    LANGUAGE eisDE = new LANGUAGE();
    eisDE.setISO639(ISO639.DE);
    eisDE.setTEXT("Farbschema");

    LANGUAGE eisEN = new LANGUAGE();
    eisEN.setISO639(ISO639.EN);
    eisEN.setTEXT("Theme");

    LANGUAGE eisES = new LANGUAGE();
    eisES.setISO639(ISO639.ES);
    eisES.setTEXT("Tema");

    COMMAND commandMokka = new COMMAND();
    commandMokka.setKEY(KEY.MOKKA);

    LANGUAGES languagesMokka = new LANGUAGES();
    LANGUAGE mokkaDE = new LANGUAGE();
    mokkaDE.setISO639(ISO639.DE);
    mokkaDE.setTEXT("Mokka");

    LANGUAGE mokkaEN = new LANGUAGE();
    mokkaEN.setISO639(ISO639.EN);
    mokkaEN.setTEXT("Mocha");

    LANGUAGE mokkaES = new LANGUAGE();
    mokkaES.setISO639(ISO639.ES);
    mokkaES.setTEXT("Mocca");

    languagesMokka.getLANGUAGE().add(mokkaDE);
    languagesMokka.getLANGUAGE().add(mokkaEN);
    languagesMokka.getLANGUAGE().add(mokkaES);
    commandMokka.setLANGUAGES(languagesMokka);

    languagesEis.getLANGUAGE().add(eisDE);
    languagesEis.getLANGUAGE().add(eisEN);
    languagesEis.getLANGUAGE().add(eisES);
    commandEis.setLANGUAGES(languagesEis);

    COMMAND commandVanille = new COMMAND();
    commandVanille.setKEY(KEY.VANILLE);
    LANGUAGES languagesVanille = new LANGUAGES();

    LANGUAGE vanilleDE = new LANGUAGE();
    vanilleDE.setISO639(ISO639.DE);
    vanilleDE.setTEXT("Vanille");

    LANGUAGE vanilleEN = new LANGUAGE();
    vanilleEN.setISO639(ISO639.EN);
    vanilleEN.setTEXT("Vanilla");

    LANGUAGE vanilleES = new LANGUAGE();
    vanilleES.setISO639(ISO639.ES);
    vanilleES.setTEXT("Vainilla");

    languagesVanille.getLANGUAGE().add(vanilleDE);
    languagesVanille.getLANGUAGE().add(vanilleEN);
    languagesVanille.getLANGUAGE().add(vanilleES);
    commandVanille.setLANGUAGES(languagesVanille);

    COMMAND commandJoghurt = new COMMAND();
    commandJoghurt.setKEY(KEY.JOGHURT);
    LANGUAGES languagesJoghurt = new LANGUAGES();

    LANGUAGE joghurtDE = new LANGUAGE();
    joghurtDE.setISO639(ISO639.DE);
    joghurtDE.setTEXT("Joghurt");

    LANGUAGE joghurtEN = new LANGUAGE();
    joghurtEN.setISO639(ISO639.EN);
    joghurtEN.setTEXT("Yogurt");

    LANGUAGE joghurtES = new LANGUAGE();
    joghurtES.setISO639(ISO639.ES);
    joghurtES.setTEXT("Yogur");

    languagesJoghurt.getLANGUAGE().add(joghurtDE);
    languagesJoghurt.getLANGUAGE().add(joghurtEN);
    languagesJoghurt.getLANGUAGE().add(joghurtES);

    commandJoghurt.setLANGUAGES(languagesJoghurt);

    COMMAND commandBlaubeere = new COMMAND();
    commandBlaubeere.setKEY(KEY.BLAUBEERE);
    LANGUAGES languagesBlaubeere = new LANGUAGES();

    LANGUAGE blaubeereDE = new LANGUAGE();
    blaubeereDE.setISO639(ISO639.DE);
    blaubeereDE.setTEXT("Blaubeere");

    LANGUAGE blaubeereEN = new LANGUAGE();
    blaubeereEN.setISO639(ISO639.EN);
    blaubeereEN.setTEXT("Blueberry");

    LANGUAGE blaubeereES = new LANGUAGE();
    blaubeereES.setISO639(ISO639.ES);
    blaubeereES.setTEXT("Arándano");

    languagesBlaubeere.getLANGUAGE().add(blaubeereDE);
    languagesBlaubeere.getLANGUAGE().add(blaubeereEN);
    languagesBlaubeere.getLANGUAGE().add(blaubeereES);

    commandBlaubeere.setLANGUAGES(languagesBlaubeere);

    COMMAND commandErdbeere = new COMMAND();
    LANGUAGES languagesErdbeere = new LANGUAGES();

    LANGUAGE erdbeereDE = new LANGUAGE();
    erdbeereDE.setISO639(ISO639.DE);
    erdbeereDE.setTEXT("Erdbeere");

    LANGUAGE erdbeereEN = new LANGUAGE();
    erdbeereEN.setISO639(ISO639.EN);
    erdbeereEN.setTEXT("Strawberry");

    LANGUAGE erdbeereES = new LANGUAGE();
    erdbeereES.setISO639(ISO639.ES);
    erdbeereES.setTEXT("Fresa");

    languagesErdbeere.getLANGUAGE().add(erdbeereDE);
    languagesErdbeere.getLANGUAGE().add(erdbeereEN);
    languagesErdbeere.getLANGUAGE().add(erdbeereES);

    commandErdbeere.setLANGUAGES(languagesErdbeere);
    commandErdbeere.setKEY(KEY.ERDBEERE);

    COMMAND commandChat = new COMMAND();
    commandChat.setKEY(KEY.CHAT);
    LANGUAGES languagesChat = new LANGUAGES();

    LANGUAGE languageChatDE = new LANGUAGE();
    languageChatDE.setISO639(ISO639.DE);
    languageChatDE.setTEXT("Chat");
    languageChatDE.setSHORTCUT(VIRTUALKEY.VK_C);

    LANGUAGE languageChatEN = new LANGUAGE();
    languageChatEN.setISO639(ISO639.EN);
    languageChatEN.setTEXT("Chat");
    languageChatEN.setSHORTCUT(VIRTUALKEY.VK_C);

    LANGUAGE languageChatES = new LANGUAGE();
    languageChatES.setISO639(ISO639.ES);
    languageChatES.setTEXT("Chat");
    languageChatES.setSHORTCUT(VIRTUALKEY.VK_C);

    languagesChat.getLANGUAGE().add(languageChatDE);
    languagesChat.getLANGUAGE().add(languageChatEN);
    languagesChat.getLANGUAGE().add(languageChatES);
    commandChat.setLANGUAGES(languagesChat);

    COMMAND commandAlleRauemeAnzeigen = new COMMAND();
    commandAlleRauemeAnzeigen.setKEY(KEY.ALLE_RAEUME_ANZEIGEN);
    LANGUAGES languagesAlleRaeumeAnzeigen = new LANGUAGES();

    LANGUAGE languageAlleRaeumeAnzeigenDE = new LANGUAGE();
    languageAlleRaeumeAnzeigenDE.setISO639(ISO639.DE);
    languageAlleRaeumeAnzeigenDE.setTEXT("Alle Räume anzeigen");

    LANGUAGE languageAlleRaeumeAnzeigenEN = new LANGUAGE();
    languageAlleRaeumeAnzeigenEN.setISO639(ISO639.EN);
    languageAlleRaeumeAnzeigenEN.setTEXT("Show All Rooms");

    LANGUAGE languageAlleRaeumeAnzeigenES = new LANGUAGE();
    languageAlleRaeumeAnzeigenES.setISO639(ISO639.ES);
    languageAlleRaeumeAnzeigenES.setTEXT("Mostrar todos los chats");

    languagesAlleRaeumeAnzeigen.getLANGUAGE().add(languageAlleRaeumeAnzeigenDE);
    languagesAlleRaeumeAnzeigen.getLANGUAGE().add(languageAlleRaeumeAnzeigenEN);
    languagesAlleRaeumeAnzeigen.getLANGUAGE().add(languageAlleRaeumeAnzeigenES);
    commandAlleRauemeAnzeigen.setLANGUAGES(languagesAlleRaeumeAnzeigen);

    COMMAND commandForum = new COMMAND();
    commandForum.setKEY(KEY.FORUM);
    LANGUAGES languagesForum = new LANGUAGES();

    LANGUAGE languageForumDE = new LANGUAGE();
    languageForumDE.setISO639(ISO639.DE);
    languageForumDE.setTEXT("Forum");

    LANGUAGE languageForumEN = new LANGUAGE();
    languageForumEN.setISO639(ISO639.EN);
    languageForumEN.setTEXT("Forum");

    LANGUAGE languageForumES = new LANGUAGE();
    languageForumES.setISO639(ISO639.ES);
    languageForumES.setTEXT("Foro");

    languagesForum.getLANGUAGE().add(languageForumDE);
    languagesForum.getLANGUAGE().add(languageForumEN);
    languagesForum.getLANGUAGE().add(languageForumES);
    commandForum.setLANGUAGES(languagesForum);

    COMMAND commandBesprechungsraeume = new COMMAND();
    commandBesprechungsraeume.setKEY(KEY.BESPRECHUNGSRAEUME_VERWALTEN);
    LANGUAGES languagesBesprechungsraeume = new LANGUAGES();

    LANGUAGE languagBesprechungsraeumeDE = new LANGUAGE();
    languagBesprechungsraeumeDE.setISO639(ISO639.DE);
    languagBesprechungsraeumeDE.setTEXT("Besprechungsräume verwalten");

    LANGUAGE languagBesprechungsraeumeEN = new LANGUAGE();
    languagBesprechungsraeumeEN.setISO639(ISO639.EN);
    languagBesprechungsraeumeEN.setTEXT("Manage Meeting Rooms");

    LANGUAGE languagBesprechungsraeumeES = new LANGUAGE();
    languagBesprechungsraeumeES.setISO639(ISO639.ES);
    languagBesprechungsraeumeES.setTEXT("Administrar salas de reuniones");

    languagesBesprechungsraeume.getLANGUAGE().add(languagBesprechungsraeumeDE);
    languagesBesprechungsraeume.getLANGUAGE().add(languagBesprechungsraeumeEN);
    languagesBesprechungsraeume.getLANGUAGE().add(languagBesprechungsraeumeES);
    commandBesprechungsraeume.setLANGUAGES(languagesBesprechungsraeume);

    COMMAND commandPausenraeume = new COMMAND();
    commandPausenraeume.setKEY(KEY.PAUSENRAEUME_VERWALTEN);
    LANGUAGES languagesPausenraeume = new LANGUAGES();

    LANGUAGE languagePausenraeumeDE = new LANGUAGE();
    languagePausenraeumeDE.setISO639(ISO639.DE);
    languagePausenraeumeDE.setTEXT("Pausenraum einrichten");

    LANGUAGE languagePausenraeumeEN = new LANGUAGE();
    languagePausenraeumeEN.setISO639(ISO639.EN);
    languagePausenraeumeEN.setTEXT("Create Break Room");

    LANGUAGE languagePausenraeumeES = new LANGUAGE();
    languagePausenraeumeES.setISO639(ISO639.ES);
    languagePausenraeumeES.setTEXT("Crear sala de descanso");

    languagesPausenraeume.getLANGUAGE().add(languagePausenraeumeDE);
    languagesPausenraeume.getLANGUAGE().add(languagePausenraeumeEN);
    languagesPausenraeume.getLANGUAGE().add(languagePausenraeumeES);

    commandPausenraeume.setLANGUAGES(languagesPausenraeume);

    COMMAND commandPrivatgespraech = new COMMAND();
    commandPrivatgespraech.setKEY(KEY.PRIVATGESPRAECH);
    LANGUAGES languagesPrivatgespraech = new LANGUAGES();

    LANGUAGE languagePrivatgespraechDE = new LANGUAGE();
    languagePrivatgespraechDE.setISO639(ISO639.DE);
    languagePrivatgespraechDE.setTEXT("1:1 Privatgespräch");

    LANGUAGE languagePrivatgespraechEN = new LANGUAGE();
    languagePrivatgespraechEN.setISO639(ISO639.EN);
    languagePrivatgespraechEN.setTEXT("1:1 Private Chat");

    LANGUAGE languagePrivatgespraechES = new LANGUAGE();
    languagePrivatgespraechES.setISO639(ISO639.ES);
    languagePrivatgespraechES.setTEXT("Chat privado 1 a 1");

    languagesPrivatgespraech.getLANGUAGE().add(languagePrivatgespraechDE);
    languagesPrivatgespraech.getLANGUAGE().add(languagePrivatgespraechEN);
    languagesPrivatgespraech.getLANGUAGE().add(languagePrivatgespraechES);
    commandPrivatgespraech.setLANGUAGES(languagesPrivatgespraech);

    COMMAND commandChatanfragenAblehnen = new COMMAND();
    commandChatanfragenAblehnen.setKEY(KEY.CHATANFRAGEN_ABLEHNEN);
    LANGUAGES languagesChatanfragen = new LANGUAGES();

    LANGUAGE languageChatanfragenDE = new LANGUAGE();
    languageChatanfragenDE.setISO639(ISO639.DE);
    languageChatanfragenDE.setTEXT("Chatanfragen ablehnen");

    LANGUAGE languageChatanfragenEN = new LANGUAGE();
    languageChatanfragenEN.setISO639(ISO639.EN);
    languageChatanfragenEN.setTEXT("Reject Chat Requests");

    LANGUAGE languageChatanfragenES = new LANGUAGE();
    languageChatanfragenES.setISO639(ISO639.ES);
    languageChatanfragenES.setTEXT("Rechazar solicitudes de chat");

    languagesChatanfragen.getLANGUAGE().add(languageChatanfragenDE);
    languagesChatanfragen.getLANGUAGE().add(languageChatanfragenEN);
    languagesChatanfragen.getLANGUAGE().add(languageChatanfragenES);

    commandChatanfragenAblehnen.setLANGUAGES(languagesChatanfragen);

    COMMAND commandOnlinetransfer = new COMMAND();
    commandOnlinetransfer.setKEY(KEY.ONLINETRANSFER);
    LANGUAGES languagesOnlinetransfer = new LANGUAGES();

    LANGUAGE languageOnlinetransferDE = new LANGUAGE();
    languageOnlinetransferDE.setISO639(ISO639.DE);
    languageOnlinetransferDE.setTEXT("Filesharing");
    languageOnlinetransferDE.setSHORTCUT(VIRTUALKEY.VK_F);

    LANGUAGE languageOnlinetransferEN = new LANGUAGE();
    languageOnlinetransferEN.setISO639(ISO639.EN);
    languageOnlinetransferEN.setTEXT("File Sharing");
    languageOnlinetransferEN.setSHORTCUT(VIRTUALKEY.VK_F);

    LANGUAGE languageOnlinetransferES = new LANGUAGE();
    languageOnlinetransferES.setISO639(ISO639.ES);
    languageOnlinetransferES.setTEXT("Compartir archivos");
    languageOnlinetransferES.setSHORTCUT(VIRTUALKEY.VK_M);

    languagesOnlinetransfer.getLANGUAGE().add(languageOnlinetransferDE);
    languagesOnlinetransfer.getLANGUAGE().add(languageOnlinetransferEN);
    languagesOnlinetransfer.getLANGUAGE().add(languageOnlinetransferES);
    commandOnlinetransfer.setLANGUAGES(languagesOnlinetransfer);

    COMMAND commandServerKonfigurieren = new COMMAND();
    commandServerKonfigurieren.setKEY(KEY.SERVER_KONFIGURIEREN);
    LANGUAGES languagesServerKonfigurieren = new LANGUAGES();

    LANGUAGE languageServerKonfigurierenDE = new LANGUAGE();
    languageServerKonfigurierenDE.setISO639(ISO639.DE);
    languageServerKonfigurierenDE.setTEXT("Server konfigurieren");

    LANGUAGE languageServerKonfigurierenEN = new LANGUAGE();
    languageServerKonfigurierenEN.setISO639(ISO639.EN);
    languageServerKonfigurierenEN.setTEXT("Server Settings");

    LANGUAGE languageServerKonfigurierenES = new LANGUAGE();
    languageServerKonfigurierenES.setISO639(ISO639.ES);
    languageServerKonfigurierenES.setTEXT("Configuración del servidor");

    languagesServerKonfigurieren.getLANGUAGE().add(languageServerKonfigurierenDE);
    languagesServerKonfigurieren.getLANGUAGE().add(languageServerKonfigurierenEN);
    languagesServerKonfigurieren.getLANGUAGE().add(languageServerKonfigurierenES);
    commandServerKonfigurieren.setLANGUAGES(languagesServerKonfigurieren);

    COMMAND commandHochladenHerunterladen = new COMMAND();
    commandHochladenHerunterladen.setKEY(KEY.HOCHLADEN_HERUNTERLADEN);
    LANGUAGES languagesHochladenHerunterladen = new LANGUAGES();

    LANGUAGE languageHochladenHerunterladenDE = new LANGUAGE();
    languageHochladenHerunterladenDE.setISO639(ISO639.DE);
    languageHochladenHerunterladenDE.setTEXT("Hochladen & Herunterladen");

    LANGUAGE languageHochladenHerunterladenEN = new LANGUAGE();
    languageHochladenHerunterladenEN.setISO639(ISO639.EN);
    languageHochladenHerunterladenEN.setTEXT("Upload & Downlaod");

    LANGUAGE languageHochladenHerunterladenES = new LANGUAGE();
    languageHochladenHerunterladenES.setISO639(ISO639.ES);
    languageHochladenHerunterladenES.setTEXT("Cargar y descargar");

    languagesHochladenHerunterladen.getLANGUAGE().add(languageHochladenHerunterladenDE);
    languagesHochladenHerunterladen.getLANGUAGE().add(languageHochladenHerunterladenEN);
    languagesHochladenHerunterladen.getLANGUAGE().add(languageHochladenHerunterladenES);
    commandHochladenHerunterladen.setLANGUAGES(languagesHochladenHerunterladen);

    COMMAND commandSchwarzeListe = new COMMAND();
    commandSchwarzeListe.setKEY(KEY.SCHWARZE_LISTE);
    LANGUAGES languagesSchwarzeListe = new LANGUAGES();

    LANGUAGE languageSchwarzeListeDE = new LANGUAGE();
    languageSchwarzeListeDE.setISO639(ISO639.DE);
    languageSchwarzeListeDE.setTEXT("Schwarze Liste");

    LANGUAGE languageSchwarzeListeEN = new LANGUAGE();
    languageSchwarzeListeEN.setISO639(ISO639.EN);
    languageSchwarzeListeEN.setTEXT("Blacklist");

    LANGUAGE languageSchwarzeListeES = new LANGUAGE();
    languageSchwarzeListeES.setISO639(ISO639.ES);
    languageSchwarzeListeES.setTEXT("Lista negra");

    languagesSchwarzeListe.getLANGUAGE().add(languageSchwarzeListeDE);
    languagesSchwarzeListe.getLANGUAGE().add(languageSchwarzeListeEN);
    languagesSchwarzeListe.getLANGUAGE().add(languageSchwarzeListeES);
    commandSchwarzeListe.setLANGUAGES(languagesSchwarzeListe);

    COMMAND commandMedienwiedergabe = new COMMAND();
    commandMedienwiedergabe.setKEY(KEY.MEDIENWIEDERGABE);
    LANGUAGES languagesMedienwiedergabe = new LANGUAGES();

    LANGUAGE languageMedienwiedergabeDE = new LANGUAGE();
    languageMedienwiedergabeDE.setISO639(ISO639.DE);
    languageMedienwiedergabeDE.setTEXT("Mediaplayer");
    languageMedienwiedergabeDE.setSHORTCUT(VIRTUALKEY.VK_M);

    LANGUAGE languageMedienwiedergabeEN = new LANGUAGE();
    languageMedienwiedergabeEN.setISO639(ISO639.EN);
    languageMedienwiedergabeEN.setTEXT("Media Player");
    languageMedienwiedergabeEN.setSHORTCUT(VIRTUALKEY.VK_M);

    LANGUAGE languageMedienwiedergabeES = new LANGUAGE();
    languageMedienwiedergabeES.setISO639(ISO639.ES);
    languageMedienwiedergabeES.setTEXT("Reproductor medios");
    languageMedienwiedergabeES.setSHORTCUT(VIRTUALKEY.VK_R);

    languagesMedienwiedergabe.getLANGUAGE().add(languageMedienwiedergabeDE);
    languagesMedienwiedergabe.getLANGUAGE().add(languageMedienwiedergabeEN);
    languagesMedienwiedergabe.getLANGUAGE().add(languageMedienwiedergabeES);
    commandMedienwiedergabe.setLANGUAGES(languagesMedienwiedergabe);

    COMMAND commandAdministrator = new COMMAND();
    commandAdministrator.setKEY(KEY.ADMINISTRATOR);
    LANGUAGES languagesAdministrator = new LANGUAGES();

    LANGUAGE languageAdministratorDE = new LANGUAGE();
    languageAdministratorDE.setISO639(ISO639.DE);
    languageAdministratorDE.setSHORTCUT(VIRTUALKEY.VK_A);
    languageAdministratorDE.setTEXT("Administrator");

    LANGUAGE languageAdministratorEN = new LANGUAGE();
    languageAdministratorEN.setISO639(ISO639.EN);
    languageAdministratorEN.setSHORTCUT(VIRTUALKEY.VK_D);
    languageAdministratorEN.setTEXT("Administrator");

    LANGUAGE languageAdministratorES = new LANGUAGE();
    languageAdministratorES.setISO639(ISO639.ES);
    languageAdministratorES.setSHORTCUT(VIRTUALKEY.VK_A);
    languageAdministratorES.setTEXT("Administrador");

    languagesAdministrator.getLANGUAGE().add(languageAdministratorDE);
    languagesAdministrator.getLANGUAGE().add(languageAdministratorEN);
    languagesAdministrator.getLANGUAGE().add(languageAdministratorES);
    commandAdministrator.setLANGUAGES(languagesAdministrator);

    COMMAND commandTelefon = new COMMAND();
    commandTelefon.setKEY(KEY.TELEFON);
    LANGUAGES languagesTelefon = new LANGUAGES();

    LANGUAGE languageTelefonDE = new LANGUAGE();
    languageTelefonDE.setISO639(ISO639.DE);
    languageTelefonDE.setSHORTCUT(VIRTUALKEY.VK_T);
    languageTelefonDE.setTEXT("Telefonie");

    LANGUAGE languageTelefonEN = new LANGUAGE();
    languageTelefonEN.setISO639(ISO639.EN);
    languageTelefonEN.setSHORTCUT(VIRTUALKEY.VK_T);
    languageTelefonEN.setTEXT("Telephony");

    LANGUAGE languageTelefonES = new LANGUAGE();
    languageTelefonES.setISO639(ISO639.ES);
    languageTelefonES.setSHORTCUT(VIRTUALKEY.VK_T);
    languageTelefonES.setTEXT("Telefonía");

    languagesTelefon.getLANGUAGE().add(languageTelefonDE);
    languagesTelefon.getLANGUAGE().add(languageTelefonEN);
    languagesTelefon.getLANGUAGE().add(languageTelefonES);
    commandTelefon.setLANGUAGES(languagesTelefon);

    COMMAND commandInfo = new COMMAND();
    commandInfo.setKEY(KEY.INFO);
    LANGUAGES languagesInfo = new LANGUAGES();

    LANGUAGE languageInfoDE = new LANGUAGE();
    languageInfoDE.setISO639(ISO639.DE);
    languageInfoDE.setSHORTCUT(VIRTUALKEY.VK_N);
    languageInfoDE.setTEXT("Info");

    LANGUAGE languageInfoEN = new LANGUAGE();
    languageInfoEN.setISO639(ISO639.EN);
    languageInfoEN.setSHORTCUT(VIRTUALKEY.VK_N);
    languageInfoEN.setTEXT("Info");

    LANGUAGE languageInfoES = new LANGUAGE();
    languageInfoES.setISO639(ISO639.ES);
    languageInfoES.setSHORTCUT(VIRTUALKEY.VK_N);
    languageInfoES.setTEXT("Información");

    languagesInfo.getLANGUAGE().add(languageInfoDE);
    languagesInfo.getLANGUAGE().add(languageInfoEN);
    languagesInfo.getLANGUAGE().add(languageInfoES);
    commandInfo.setLANGUAGES(languagesInfo);

    COMMAND commandBildschirmuebertragung = new COMMAND();
    commandBildschirmuebertragung.setKEY(KEY.BILDSCHIRM);
    LANGUAGES languagesBildschirmuebertragung = new LANGUAGES();

    LANGUAGE languageBildschirmuebertragungDE = new LANGUAGE();
    languageBildschirmuebertragungDE.setISO639(ISO639.DE);
    languageBildschirmuebertragungDE.setSHORTCUT(VIRTUALKEY.VK_B);
    languageBildschirmuebertragungDE.setTEXT("Bildschirmfreigabe");

    LANGUAGE languageBildschirmuebertragungEN = new LANGUAGE();
    languageBildschirmuebertragungEN.setISO639(ISO639.EN);
    languageBildschirmuebertragungEN.setSHORTCUT(VIRTUALKEY.VK_S);
    languageBildschirmuebertragungEN.setTEXT("Screen Sharing");

    LANGUAGE languageBildschirmuebertragungES = new LANGUAGE();
    languageBildschirmuebertragungES.setISO639(ISO639.ES);
    languageBildschirmuebertragungES.setSHORTCUT(VIRTUALKEY.VK_P);
    languageBildschirmuebertragungES.setTEXT("Pantalla compartida");

    languagesBildschirmuebertragung.getLANGUAGE().add(languageBildschirmuebertragungDE);
    languagesBildschirmuebertragung.getLANGUAGE().add(languageBildschirmuebertragungEN);
    languagesBildschirmuebertragung.getLANGUAGE().add(languageBildschirmuebertragungES);
    commandBildschirmuebertragung.setLANGUAGES(languagesBildschirmuebertragung);

    COMMAND commandIPTV = new COMMAND();
    commandIPTV.setKEY(KEY.STREAMS);
    LANGUAGES languagesIPTV = new LANGUAGES();

    LANGUAGE languageIptvDE = new LANGUAGE();
    languageIptvDE.setISO639(ISO639.DE);
    languageIptvDE.setSHORTCUT(VIRTUALKEY.VK_S);
    languageIptvDE.setTEXT("Streams");

    LANGUAGE languageIptvEN = new LANGUAGE();
    languageIptvEN.setISO639(ISO639.EN);
    languageIptvEN.setSHORTCUT(VIRTUALKEY.VK_E);
    languageIptvEN.setTEXT("Streams");

    LANGUAGE languageIptvES = new LANGUAGE();
    languageIptvES.setISO639(ISO639.ES);
    languageIptvES.setSHORTCUT(VIRTUALKEY.VK_S);
    languageIptvES.setTEXT("Streams");

    languagesIPTV.getLANGUAGE().add(languageIptvDE);
    languagesIPTV.getLANGUAGE().add(languageIptvEN);
    languagesIPTV.getLANGUAGE().add(languageIptvES);
    commandIPTV.setLANGUAGES(languagesIPTV);

    COMMAND commandBildschirmEmpfangen = new COMMAND();
    commandBildschirmEmpfangen.setKEY(KEY.BILDSCHIRM_EMPFANGEN);

    LANGUAGES languagesBildschirmEmpfangen = new LANGUAGES();

    LANGUAGE languageBildschirmEmpfangenDE = new LANGUAGE();
    languageBildschirmEmpfangenDE.setISO639(ISO639.DE);
    languageBildschirmEmpfangenDE.setTEXT("Einwilligung");

    LANGUAGE languageBildschirmEmpfangenEN = new LANGUAGE();
    languageBildschirmEmpfangenEN.setISO639(ISO639.EN);
    languageBildschirmEmpfangenEN.setTEXT("Consent");

    LANGUAGE languageBildschirmEmpfangenES = new LANGUAGE();
    languageBildschirmEmpfangenES.setISO639(ISO639.ES);
    languageBildschirmEmpfangenES.setTEXT("Consentimiento");

    languagesBildschirmEmpfangen.getLANGUAGE().add(languageBildschirmEmpfangenDE);
    languagesBildschirmEmpfangen.getLANGUAGE().add(languageBildschirmEmpfangenEN);
    languagesBildschirmEmpfangen.getLANGUAGE().add(languageBildschirmEmpfangenES);
    commandBildschirmEmpfangen.setLANGUAGES(languagesBildschirmEmpfangen);

    COMMAND commandTV = new COMMAND();
    commandTV.setKEY(KEY.TV);
    LANGUAGES languagesBildschirmSenden = new LANGUAGES();

    LANGUAGE languageBildschirmSendenDE = new LANGUAGE();
    languageBildschirmSendenDE.setISO639(ISO639.DE);
    languageBildschirmSendenDE.setTEXT("Streams");

    LANGUAGE languageBildschirmSendenEN = new LANGUAGE();
    languageBildschirmSendenEN.setISO639(ISO639.EN);
    languageBildschirmSendenEN.setTEXT("Streams");

    LANGUAGE languageBildschirmSendenES = new LANGUAGE();
    languageBildschirmSendenES.setISO639(ISO639.ES);
    languageBildschirmSendenES.setTEXT("Streams");

    languagesBildschirmSenden.getLANGUAGE().add(languageBildschirmSendenDE);
    languagesBildschirmSenden.getLANGUAGE().add(languageBildschirmSendenEN);
    languagesBildschirmSenden.getLANGUAGE().add(languageBildschirmSendenES);
    commandTV.setLANGUAGES(languagesBildschirmSenden);

    COMMAND commandBildschirmUebertragen = new COMMAND();
    commandBildschirmUebertragen.setKEY(KEY.BILDSCHIRM_UEBERTRAGEN);
    LANGUAGES languagesBildschirmUebertragen = new LANGUAGES();

    LANGUAGE languageBildschirmUebertragenDE = new LANGUAGE();
    languageBildschirmUebertragenDE.setISO639(ISO639.DE);
    languageBildschirmUebertragenDE.setTEXT("Teilen");

    LANGUAGE languageBildschirmUebertragenEN = new LANGUAGE();
    languageBildschirmUebertragenEN.setISO639(ISO639.EN);
    languageBildschirmUebertragenEN.setTEXT("Share");

    LANGUAGE languageBildschirmUebertragenES = new LANGUAGE();
    languageBildschirmUebertragenES.setISO639(ISO639.ES);
    languageBildschirmUebertragenES.setTEXT("Compartir");

    languagesBildschirmUebertragen.getLANGUAGE().add(languageBildschirmUebertragenDE);
    languagesBildschirmUebertragen.getLANGUAGE().add(languageBildschirmUebertragenEN);
    languagesBildschirmUebertragen.getLANGUAGE().add(languageBildschirmUebertragenES);
    commandBildschirmUebertragen.setLANGUAGES(languagesBildschirmUebertragen);

    COMMAND commandTelefonEinrichten = new COMMAND();
    commandTelefonEinrichten.setKEY(KEY.TELEFON_EINRICHTEN);
    LANGUAGES languagesTelefonEinrichten = new LANGUAGES();

    LANGUAGE languageTelefonEinrichtenDE = new LANGUAGE();
    languageTelefonEinrichtenDE.setISO639(ISO639.DE);
    languageTelefonEinrichtenDE.setTEXT("Telefonie einrichten");

    LANGUAGE languageTelefonEinrichtenEN = new LANGUAGE();
    languageTelefonEinrichtenEN.setISO639(ISO639.EN);
    languageTelefonEinrichtenEN.setTEXT("Telephony Settings");

    LANGUAGE languageTelefonEinrichtenES = new LANGUAGE();
    languageTelefonEinrichtenES.setISO639(ISO639.ES);
    languageTelefonEinrichtenES.setTEXT("Ajustes de telefonía");

    languagesTelefonEinrichten.getLANGUAGE().add(languageTelefonEinrichtenDE);
    languagesTelefonEinrichten.getLANGUAGE().add(languageTelefonEinrichtenEN);
    languagesTelefonEinrichten.getLANGUAGE().add(languageTelefonEinrichtenES);
    commandTelefonEinrichten.setLANGUAGES(languagesTelefonEinrichten);

    COMMAND commandTelefonAnrufen = new COMMAND();
    commandTelefonAnrufen.setKEY(KEY.TELEFON_ANRUFEN);
    LANGUAGES languagesTelefonAnrufen = new LANGUAGES();

    LANGUAGE languageTelefonAnrufenDE = new LANGUAGE();
    languageTelefonAnrufenDE.setISO639(ISO639.DE);
    languageTelefonAnrufenDE.setTEXT("AnrufenXXX");

    LANGUAGE languageTelefonAnrufenEN = new LANGUAGE();
    languageTelefonAnrufenEN.setISO639(ISO639.EN);
    languageTelefonAnrufenEN.setTEXT("CallXXX");

    LANGUAGE languageTelefonAnrufenES = new LANGUAGE();
    languageTelefonAnrufenES.setISO639(ISO639.ES);
    languageTelefonAnrufenES.setTEXT("LlamarXXX");

    languagesTelefonAnrufen.getLANGUAGE().add(languageTelefonAnrufenDE);
    languagesTelefonAnrufen.getLANGUAGE().add(languageTelefonAnrufenEN);
    languagesTelefonAnrufen.getLANGUAGE().add(languageTelefonAnrufenES);

    commandTelefonAnrufen.setLANGUAGES(languagesTelefonAnrufen);

    COMMAND commandTelefonateAblehnen = new COMMAND();
    commandTelefonateAblehnen.setKEY(KEY.TELEFONATE_ABLEHNEN);
    LANGUAGES languagesTelefonateAblehnen = new LANGUAGES();

    LANGUAGE languageTelefonateAblehnenDE = new LANGUAGE();
    languageTelefonateAblehnenDE.setISO639(ISO639.DE);
    languageTelefonateAblehnenDE.setTEXT("Telefonate ablehnen");

    LANGUAGE languageTelefonateAblehnenEN = new LANGUAGE();
    languageTelefonateAblehnenEN.setISO639(ISO639.EN);
    languageTelefonateAblehnenEN.setTEXT("Reject Calls");

    LANGUAGE languageTelefonateAblehnenES = new LANGUAGE();
    languageTelefonateAblehnenES.setISO639(ISO639.ES);
    languageTelefonateAblehnenES.setTEXT("Rechazar llamadas");

    languagesTelefonateAblehnen.getLANGUAGE().add(languageTelefonateAblehnenDE);
    languagesTelefonateAblehnen.getLANGUAGE().add(languageTelefonateAblehnenEN);
    languagesTelefonateAblehnen.getLANGUAGE().add(languageTelefonateAblehnenES);

    commandTelefonateAblehnen.setLANGUAGES(languagesTelefonateAblehnen);

    COMMAND commandLizenz = new COMMAND();
    commandLizenz.setKEY(KEY.LIZENZ);
    LANGUAGES languagesLizenz = new LANGUAGES();

    LANGUAGE languageLizenzDE = new LANGUAGE();
    languageLizenzDE.setISO639(ISO639.DE);
    languageLizenzDE.setTEXT("Lizenz");

    LANGUAGE languageLizenzEN = new LANGUAGE();
    languageLizenzEN.setISO639(ISO639.EN);
    languageLizenzEN.setTEXT("License");

    LANGUAGE languageLizenzES = new LANGUAGE();
    languageLizenzES.setISO639(ISO639.ES);
    languageLizenzES.setTEXT("Licencia");

    languagesLizenz.getLANGUAGE().add(languageLizenzDE);
    languagesLizenz.getLANGUAGE().add(languageLizenzEN);
    languagesLizenz.getLANGUAGE().add(languageLizenzES);
    commandLizenz.setLANGUAGES(languagesLizenz);

    COMMAND commandAdministratorVerwalten = new COMMAND();
    commandAdministratorVerwalten.setKEY(KEY.ADMINISTRATOR_VERWALTEN);
    LANGUAGES languagesAdministratorVerwalten = new LANGUAGES();
    LANGUAGE languageAdministratorVerwaltenDE = new LANGUAGE();
    languageAdministratorVerwaltenDE.setISO639(ISO639.DE);
    languageAdministratorVerwaltenDE.setSHORTCUT(VIRTUALKEY.VK_V);
    languageAdministratorVerwaltenDE.setTEXT("Verwalten");

    LANGUAGE languageAdministratorVerwaltenEN = new LANGUAGE();
    languageAdministratorVerwaltenEN.setISO639(ISO639.EN);
    languageAdministratorVerwaltenEN.setSHORTCUT(VIRTUALKEY.VK_M);
    languageAdministratorVerwaltenEN.setTEXT("Manage");

    LANGUAGE languageAdministratorVerwaltenES = new LANGUAGE();
    languageAdministratorVerwaltenES.setISO639(ISO639.ES);
    languageAdministratorVerwaltenES.setSHORTCUT(VIRTUALKEY.VK_G);
    languageAdministratorVerwaltenES.setTEXT("Gestionar");

    languagesAdministratorVerwalten.getLANGUAGE().add(languageAdministratorVerwaltenDE);
    languagesAdministratorVerwalten.getLANGUAGE().add(languageAdministratorVerwaltenEN);
    languagesAdministratorVerwalten.getLANGUAGE().add(languageAdministratorVerwaltenES);
    commandAdministratorVerwalten.setLANGUAGES(languagesAdministratorVerwalten);

    COMMAND commandTitel = new COMMAND();
    commandTitel.setKEY(KEY.TITEL);
    LANGUAGES languagesTitel = new LANGUAGES();

    LANGUAGE languageTitelDE = new LANGUAGE();
    languageTitelDE.setISO639(ISO639.DE);
    languageTitelDE.setTEXT("Titel");

    LANGUAGE languageTitelEN = new LANGUAGE();
    languageTitelEN.setISO639(ISO639.EN);
    languageTitelEN.setTEXT("Title");

    LANGUAGE languageTitelES = new LANGUAGE();
    languageTitelES.setISO639(ISO639.ES);
    languageTitelES.setTEXT("Título");

    languagesTitel.getLANGUAGE().add(languageTitelDE);
    languagesTitel.getLANGUAGE().add(languageTitelEN);
    languagesTitel.getLANGUAGE().add(languageTitelES);
    commandTitel.setLANGUAGES(languagesTitel);

    COMMAND commandSpielliste = new COMMAND();
    commandSpielliste.setKEY(KEY.SPIELLISTE);
    LANGUAGES languagesSpielliste = new LANGUAGES();

    LANGUAGE languageSpiellisteDE = new LANGUAGE();
    languageSpiellisteDE.setISO639(ISO639.DE);
    languageSpiellisteDE.setTEXT("Zufallswiedergabe (Ordner)");

    LANGUAGE languageSpiellisteEN = new LANGUAGE();
    languageSpiellisteEN.setISO639(ISO639.EN);
    languageSpiellisteEN.setTEXT("Random Folder Playback");

    LANGUAGE languageSpiellisteES = new LANGUAGE();
    languageSpiellisteES.setISO639(ISO639.ES);
    languageSpiellisteES.setTEXT("Reproducción aleatoria (carpeta)");

    languagesSpielliste.getLANGUAGE().add(languageSpiellisteDE);
    languagesSpielliste.getLANGUAGE().add(languageSpiellisteEN);
    languagesSpielliste.getLANGUAGE().add(languageSpiellisteES);
    commandSpielliste.setLANGUAGES(languagesSpielliste);

    COMMAND commandMusikkiste = new COMMAND();
    commandMusikkiste.setKEY(KEY.MUSIKKISTE);
    LANGUAGES languagesMusikkiste = new LANGUAGES();
    LANGUAGE languageMusikkisteDE = new LANGUAGE();
    languageMusikkisteDE.setISO639(ISO639.DE);
    languageMusikkisteDE.setTEXT("Musiksammlungen");

    LANGUAGE languageMusikkisteEN = new LANGUAGE();
    languageMusikkisteEN.setISO639(ISO639.EN);
    languageMusikkisteEN.setTEXT("Music Collections");

    LANGUAGE languageMusikkisteES = new LANGUAGE();
    languageMusikkisteES.setISO639(ISO639.ES);
    languageMusikkisteES.setTEXT("Colecciones de música");

    languagesMusikkiste.getLANGUAGE().add(languageMusikkisteDE);
    languagesMusikkiste.getLANGUAGE().add(languageMusikkisteEN);
    languagesMusikkiste.getLANGUAGE().add(languageMusikkisteES);
    commandMusikkiste.setLANGUAGES(languagesMusikkiste);

    COMMAND commandMusikkisteLeeren = new COMMAND();
    commandMusikkisteLeeren.setKEY(KEY.MUSIKKISTE_LEEREN);
    LANGUAGES languagesMusikkisteLeeren = new LANGUAGES();

    LANGUAGE languageMusikkisteLeerenDE = new LANGUAGE();
    languageMusikkisteLeerenDE.setISO639(ISO639.DE);
    languageMusikkisteLeerenDE.setTEXT("Alle Musiksammlungen löschen");

    LANGUAGE languageMusikkisteLeerenEN = new LANGUAGE();
    languageMusikkisteLeerenEN.setISO639(ISO639.EN);
    languageMusikkisteLeerenEN.setTEXT("Delete All Music Collections");

    LANGUAGE languageMusikkisteLeerenES = new LANGUAGE();
    languageMusikkisteLeerenES.setISO639(ISO639.ES);
    languageMusikkisteLeerenES.setTEXT("Eliminar todas las colecciones de música");

    languagesMusikkisteLeeren.getLANGUAGE().add(languageMusikkisteLeerenDE);
    languagesMusikkisteLeeren.getLANGUAGE().add(languageMusikkisteLeerenEN);
    languagesMusikkisteLeeren.getLANGUAGE().add(languageMusikkisteLeerenES);

    commandMusikkisteLeeren.setLANGUAGES(languagesMusikkisteLeeren);

    COMMAND commandDVD = new COMMAND();
    commandDVD.setKEY(KEY.DVD);
    LANGUAGES languagesDVD = new LANGUAGES();

    LANGUAGE languageDVDDE = new LANGUAGE();
    languageDVDDE.setISO639(ISO639.DE);
    languageDVDDE.setTEXT("DVD / Blu-ray");

    LANGUAGE languageDVDEN = new LANGUAGE();
    languageDVDEN.setISO639(ISO639.EN);
    languageDVDEN.setTEXT("DVD / Blu-ray");

    LANGUAGE languageDVDES = new LANGUAGE();
    languageDVDES.setISO639(ISO639.ES);
    languageDVDES.setTEXT("DVD / Blu-ray");

    languagesDVD.getLANGUAGE().add(languageDVDDE);
    languagesDVD.getLANGUAGE().add(languageDVDEN);
    languagesDVD.getLANGUAGE().add(languageDVDES);

    commandDVD.setLANGUAGES(languagesDVD);

    COMMAND commandInhaltsverzeichnis = new COMMAND();
    commandInhaltsverzeichnis.setKEY(KEY.INHALSVERZEICHNIS);
    LANGUAGES languagesInhaltsverzeichnis = new LANGUAGES();

    LANGUAGE languageInhaltsverzeichnisDE = new LANGUAGE();
    languageInhaltsverzeichnisDE.setISO639(ISO639.DE);
    languageInhaltsverzeichnisDE.setTEXT("Inhaltsverzeichnis");

    LANGUAGE languageInhaltsverzeichnisEN = new LANGUAGE();
    languageInhaltsverzeichnisEN.setISO639(ISO639.EN);
    languageInhaltsverzeichnisEN.setTEXT("Table Of Contents");

    LANGUAGE languageInhaltsverzeichnisES = new LANGUAGE();
    languageInhaltsverzeichnisES.setISO639(ISO639.ES);
    languageInhaltsverzeichnisES.setTEXT("Tabla de contenidos");

    languagesInhaltsverzeichnis.getLANGUAGE().add(languageInhaltsverzeichnisDE);
    languagesInhaltsverzeichnis.getLANGUAGE().add(languageInhaltsverzeichnisEN);
    languagesInhaltsverzeichnis.getLANGUAGE().add(languageInhaltsverzeichnisES);
    commandInhaltsverzeichnis.setLANGUAGES(languagesInhaltsverzeichnis);

    COMMAND commandFilmsprache = new COMMAND();
    commandFilmsprache.setKEY(KEY.FILMSPRACHE);
    LANGUAGES languagesFilmsprache = new LANGUAGES();

    LANGUAGE languageFilmspracheDE = new LANGUAGE();
    languageFilmspracheDE.setISO639(ISO639.DE);
    languageFilmspracheDE.setTEXT("Filmsprache");

    LANGUAGE languageFilmspracheEN = new LANGUAGE();
    languageFilmspracheEN.setISO639(ISO639.EN);
    languageFilmspracheEN.setTEXT("Movie Language");

    LANGUAGE languageFilmspracheES = new LANGUAGE();
    languageFilmspracheES.setISO639(ISO639.ES);
    languageFilmspracheES.setTEXT("Idioma de la película");

    languagesFilmsprache.getLANGUAGE().add(languageFilmspracheDE);
    languagesFilmsprache.getLANGUAGE().add(languageFilmspracheEN);
    languagesFilmsprache.getLANGUAGE().add(languageFilmspracheES);

    commandFilmsprache.setLANGUAGES(languagesFilmsprache);

    COMMAND commandVollbildmodus = new COMMAND();
    commandVollbildmodus.setKEY(KEY.VOLLBILDMODUS);
    LANGUAGES languagesVollbildmodus = new LANGUAGES();

    LANGUAGE languagesVollbildmodusDE = new LANGUAGE();
    languagesVollbildmodusDE.setISO639(ISO639.DE);
    languagesVollbildmodusDE.setTEXT("Vollbildmodus");

    LANGUAGE languagesVollbildmodusEN = new LANGUAGE();
    languagesVollbildmodusEN.setISO639(ISO639.EN);
    languagesVollbildmodusEN.setTEXT("Full Screen Mode");

    LANGUAGE languagesVollbildmodusES = new LANGUAGE();
    languagesVollbildmodusES.setISO639(ISO639.ES);
    languagesVollbildmodusES.setTEXT("Modo de pantalla completa");

    languagesVollbildmodus.getLANGUAGE().add(languagesVollbildmodusDE);
    languagesVollbildmodus.getLANGUAGE().add(languagesVollbildmodusEN);
    languagesVollbildmodus.getLANGUAGE().add(languagesVollbildmodusES);
    commandVollbildmodus.setLANGUAGES(languagesVollbildmodus);

    COMMAND commandFensterImHintergrundHalten = new COMMAND();
    commandFensterImHintergrundHalten.setKEY(KEY.FENSTER_IM_HINTERGRUND_HALTEN);
    LANGUAGES languagesFensterImHintergrundHalten = new LANGUAGES();

    LANGUAGE languagesFensterImHintergrundHaltenDE = new LANGUAGE();
    languagesFensterImHintergrundHaltenDE.setISO639(ISO639.DE);
    languagesFensterImHintergrundHaltenDE.setTEXT("Fenster im Hintergrund halten");

    LANGUAGE languagesFensterImHintergrundHaltenEN = new LANGUAGE();
    languagesFensterImHintergrundHaltenEN.setISO639(ISO639.EN);
    languagesFensterImHintergrundHaltenEN.setTEXT("Keep Window in the Background");

    LANGUAGE languagesFensterImHintergrundHaltenES = new LANGUAGE();
    languagesFensterImHintergrundHaltenES.setISO639(ISO639.ES);
    languagesFensterImHintergrundHaltenES.setTEXT("Mantener la ventana en segundo plano");

    languagesFensterImHintergrundHalten.getLANGUAGE().add(languagesFensterImHintergrundHaltenDE);
    languagesFensterImHintergrundHalten.getLANGUAGE().add(languagesFensterImHintergrundHaltenEN);
    languagesFensterImHintergrundHalten.getLANGUAGE().add(languagesFensterImHintergrundHaltenES);
    commandFensterImHintergrundHalten.setLANGUAGES(languagesFensterImHintergrundHalten);

    COMMAND commandSprache = new COMMAND();
    commandSprache.setKEY(KEY.SPRACHE);
    LANGUAGES languagesSprache = new LANGUAGES();

    LANGUAGE languagesSpracheDE = new LANGUAGE();
    languagesSpracheDE.setISO639(ISO639.DE);
    languagesSpracheDE.setPathToImage("net/javacomm/multilingual/germany_39x26.png");

    LANGUAGE languagesSpracheEN = new LANGUAGE();
    languagesSpracheEN.setISO639(ISO639.EN);
    languagesSpracheEN.setPathToImage("net/javacomm/multilingual/union-jack_39x26.png");

    LANGUAGE languagesSpracheES = new LANGUAGE();
    languagesSpracheES.setISO639(ISO639.ES);
    languagesSpracheES.setPathToImage("net/javacomm/multilingual/spain_39x26.png");

    languagesSprache.getLANGUAGE().add(languagesSpracheDE);
    languagesSprache.getLANGUAGE().add(languagesSpracheEN);
    languagesSprache.getLANGUAGE().add(languagesSpracheES);
    commandSprache.setLANGUAGES(languagesSprache);

    COMMAND commandTapete = new COMMAND();
    commandTapete.setKEY(KEY.TAPETE);
    LANGUAGES languagesTapete = new LANGUAGES();

    LANGUAGE languagesTapeteDE = new LANGUAGE();
    languagesTapeteDE.setISO639(ISO639.DE);
    languagesTapeteDE.setSHORTCUT(VIRTUALKEY.VK_H);
    languagesTapeteDE.setTEXT("Hintergrundbild");

    LANGUAGE languagesTapeteEN = new LANGUAGE();
    languagesTapeteEN.setISO639(ISO639.EN);
    languagesTapeteEN.setSHORTCUT(VIRTUALKEY.VK_W);
    languagesTapeteEN.setTEXT("Wallpaper");

    LANGUAGE languagesTapeteES = new LANGUAGE();
    languagesTapeteES.setISO639(ISO639.ES);
    languagesTapeteES.setSHORTCUT(VIRTUALKEY.VK_F);
    languagesTapeteES.setTEXT("Fondo de pantalla");

    languagesTapete.getLANGUAGE().add(languagesTapeteDE);
    languagesTapete.getLANGUAGE().add(languagesTapeteEN);
    languagesTapete.getLANGUAGE().add(languagesTapeteES);
    commandTapete.setLANGUAGES(languagesTapete);

    COMMAND commandTapeteAbreissen = new COMMAND();
    commandTapeteAbreissen.setKEY(KEY.TAPETE_ABREISSEN);
    LANGUAGES languagesTapeteAbreissen = new LANGUAGES();

    LANGUAGE languagesTapeteAbreissenDE = new LANGUAGE();
    languagesTapeteAbreissenDE.setISO639(ISO639.DE);
    languagesTapeteAbreissenDE.setTEXT("Löschen");

    LANGUAGE languagesTapeteAbreissenEN = new LANGUAGE();
    languagesTapeteAbreissenEN.setISO639(ISO639.EN);
    languagesTapeteAbreissenEN.setTEXT("Remove");

    LANGUAGE languagesTapeteAbreissenES = new LANGUAGE();
    languagesTapeteAbreissenES.setISO639(ISO639.ES);
    languagesTapeteAbreissenES.setTEXT("Borrar");

    languagesTapeteAbreissen.getLANGUAGE().add(languagesTapeteAbreissenDE);
    languagesTapeteAbreissen.getLANGUAGE().add(languagesTapeteAbreissenEN);
    languagesTapeteAbreissen.getLANGUAGE().add(languagesTapeteAbreissenES);
    commandTapeteAbreissen.setLANGUAGES(languagesTapeteAbreissen);

    LANGUAGES languagesTapeteAnkleben = new LANGUAGES();
    LANGUAGE languageTapeteAnklebenDE = new LANGUAGE();
    languageTapeteAnklebenDE.setISO639(ISO639.DE);
    languageTapeteAnklebenDE.setTEXT("Einblenden");

    LANGUAGE languageTapeteAnklebenEN = new LANGUAGE();
    languageTapeteAnklebenEN.setISO639(ISO639.EN);
    languageTapeteAnklebenEN.setTEXT("Display");

    LANGUAGE languageTapeteAnklebenES = new LANGUAGE();
    languageTapeteAnklebenES.setISO639(ISO639.ES);
    languageTapeteAnklebenES.setTEXT("Mostrar");

    languagesTapeteAnkleben.getLANGUAGE().add(languageTapeteAnklebenDE);
    languagesTapeteAnkleben.getLANGUAGE().add(languageTapeteAnklebenEN);
    languagesTapeteAnkleben.getLANGUAGE().add(languageTapeteAnklebenES);

    COMMAND commandTapeteAnkleben = new COMMAND();
    commandTapeteAnkleben.setKEY(KEY.TAPETE_ANKLEBEN);
    commandTapeteAnkleben.setLANGUAGES(languagesTapeteAnkleben);

    COMMAND commandButtonAnmelden = new COMMAND();
    commandButtonAnmelden.setKEY(KEY.BUTTON_ANMELDEN);
    LANGUAGES languagesButtonAnmelden = new LANGUAGES();

    LANGUAGE languageButtonAnmeldenDE = new LANGUAGE();
    languageButtonAnmeldenDE.setISO639(ISO639.DE);
    languageButtonAnmeldenDE.setSHORTCUT(VIRTUALKEY.VK_A);
    languageButtonAnmeldenDE.setTEXT("Anmelden");

    LANGUAGE languageButtonAnmeldenEN = new LANGUAGE();
    languageButtonAnmeldenEN.setISO639(ISO639.EN);
    languageButtonAnmeldenEN.setSHORTCUT(VIRTUALKEY.VK_L);
    languageButtonAnmeldenEN.setTEXT("Log In");

    LANGUAGE languageButtonAnmeldenES = new LANGUAGE();
    languageButtonAnmeldenES.setISO639(ISO639.ES);
    languageButtonAnmeldenES.setSHORTCUT(VIRTUALKEY.VK_E);
    languageButtonAnmeldenES.setTEXT("Entrar");

    languagesButtonAnmelden.getLANGUAGE().add(languageButtonAnmeldenDE);
    languagesButtonAnmelden.getLANGUAGE().add(languageButtonAnmeldenEN);
    languagesButtonAnmelden.getLANGUAGE().add(languageButtonAnmeldenES);
    commandButtonAnmelden.setLANGUAGES(languagesButtonAnmelden);

    COMMAND commandButtonAbbrechen = new COMMAND();
    commandButtonAbbrechen.setKEY(KEY.BUTTON_ABBRECHEN);
    LANGUAGES languagesAbbrechen = new LANGUAGES();

    LANGUAGE languageButtonAbbrechenDE = new LANGUAGE();
    languageButtonAbbrechenDE.setISO639(ISO639.DE);
    languageButtonAbbrechenDE.setSHORTCUT(VIRTUALKEY.VK_B);
    languageButtonAbbrechenDE.setTEXT("Abbrechen");

    LANGUAGE languageButtonAbbrechenEN = new LANGUAGE();
    languageButtonAbbrechenEN.setISO639(ISO639.EN);
    languageButtonAbbrechenEN.setSHORTCUT(VIRTUALKEY.VK_C);
    languageButtonAbbrechenEN.setTEXT("Cancel");

    LANGUAGE languageButtonAbbrechenES = new LANGUAGE();
    languageButtonAbbrechenES.setISO639(ISO639.ES);
    languageButtonAbbrechenES.setSHORTCUT(VIRTUALKEY.VK_C);
    languageButtonAbbrechenES.setTEXT("Cancelar");

    languagesAbbrechen.getLANGUAGE().add(languageButtonAbbrechenDE);
    languagesAbbrechen.getLANGUAGE().add(languageButtonAbbrechenEN);
    languagesAbbrechen.getLANGUAGE().add(languageButtonAbbrechenES);
    commandButtonAbbrechen.setLANGUAGES(languagesAbbrechen);

    COMMAND commandLabelSprache = new COMMAND();
    commandLabelSprache.setKEY(KEY.LABEL_SPRACHE);
    LANGUAGES languagesLabelSprache = new LANGUAGES();

    LANGUAGE languageLabelSpracheDE = new LANGUAGE();
    languageLabelSpracheDE.setISO639(ISO639.DE);
    languageLabelSpracheDE.setTEXT("Sprache");

    LANGUAGE languageLabelSpracheEN = new LANGUAGE();
    languageLabelSpracheEN.setISO639(ISO639.EN);
    languageLabelSpracheEN.setTEXT("Language");

    LANGUAGE languageLabelSpracheES = new LANGUAGE();
    languageLabelSpracheES.setISO639(ISO639.ES);
    languageLabelSpracheES.setTEXT("Idioma");

    languagesLabelSprache.getLANGUAGE().add(languageLabelSpracheDE);
    languagesLabelSprache.getLANGUAGE().add(languageLabelSpracheEN);
    languagesLabelSprache.getLANGUAGE().add(languageLabelSpracheES);
    commandLabelSprache.setLANGUAGES(languagesLabelSprache);

    COMMAND commandLabelDomain = new COMMAND();
    commandLabelDomain.setKEY(KEY.LABEL_DOMAENE);
    LANGUAGES languagesLabelDomain = new LANGUAGES();

    LANGUAGE languageLabelDomainDE = new LANGUAGE();
    languageLabelDomainDE.setISO639(ISO639.DE);
    languageLabelDomainDE.setTEXT("Domäne");

    LANGUAGE languageLabelDomainEN = new LANGUAGE();
    languageLabelDomainEN.setISO639(ISO639.EN);
    languageLabelDomainEN.setTEXT("Domain");

    LANGUAGE languageLabelDomainES = new LANGUAGE();
    languageLabelDomainES.setISO639(ISO639.ES);
    languageLabelDomainES.setTEXT("Dominio");

    languagesLabelDomain.getLANGUAGE().add(languageLabelDomainDE);
    languagesLabelDomain.getLANGUAGE().add(languageLabelDomainEN);
    languagesLabelDomain.getLANGUAGE().add(languageLabelDomainES);
    commandLabelDomain.setLANGUAGES(languagesLabelDomain);

    COMMAND commandLabelPasswort = new COMMAND();
    commandLabelPasswort.setKEY(KEY.LABEL_PASSWORT);
    LANGUAGES languagesLabelPasswort = new LANGUAGES();

    LANGUAGE languageLabelPasswortDE = new LANGUAGE();
    languageLabelPasswortDE.setISO639(ISO639.DE);
    languageLabelPasswortDE.setTEXT("Passwort");

    LANGUAGE languageLabelPasswortEN = new LANGUAGE();
    languageLabelPasswortEN.setISO639(ISO639.EN);
    languageLabelPasswortEN.setTEXT("Password");

    LANGUAGE languageLabelPasswortES = new LANGUAGE();
    languageLabelPasswortES.setISO639(ISO639.ES);
    languageLabelPasswortES.setTEXT("Contraseña");

    languagesLabelPasswort.getLANGUAGE().add(languageLabelPasswortDE);
    languagesLabelPasswort.getLANGUAGE().add(languageLabelPasswortEN);
    languagesLabelPasswort.getLANGUAGE().add(languageLabelPasswortES);
    commandLabelPasswort.setLANGUAGES(languagesLabelPasswort);

    COMMAND commandLabelEmail = new COMMAND();
    commandLabelEmail.setKEY(KEY.LABEL_EMAIL);
    LANGUAGES languagesLabelEmail = new LANGUAGES();

    LANGUAGE languageLabelEmailDE = new LANGUAGE();
    languageLabelEmailDE.setISO639(ISO639.DE);
    languageLabelEmailDE.setTEXT("E-Mail oder User ID");

    LANGUAGE languageLabelEmailEN = new LANGUAGE();
    languageLabelEmailEN.setISO639(ISO639.EN);
    languageLabelEmailEN.setTEXT("Email or User ID");

    LANGUAGE languageLabelEmailES = new LANGUAGE();
    languageLabelEmailES.setISO639(ISO639.ES);
    languageLabelEmailES.setTEXT("Correo o ID de usuario");

    languagesLabelEmail.getLANGUAGE().add(languageLabelEmailDE);
    languagesLabelEmail.getLANGUAGE().add(languageLabelEmailEN);
    languagesLabelEmail.getLANGUAGE().add(languageLabelEmailES);
    commandLabelEmail.setLANGUAGES(languagesLabelEmail);

    COMMAND commandLabelTimeout = new COMMAND();
    commandLabelTimeout.setKEY(KEY.LABEL_TIMEOUT);
    LANGUAGES languagesLabelTimeout = new LANGUAGES();

    LANGUAGE languageLabelTimeoutDE = new LANGUAGE();
    languageLabelTimeoutDE.setISO639(ISO639.DE);
    languageLabelTimeoutDE.setTEXT("Auszeit:");

    LANGUAGE languageLabelTimeoutEN = new LANGUAGE();
    languageLabelTimeoutEN.setISO639(ISO639.EN);
    languageLabelTimeoutEN.setTEXT("Timeout:");

    LANGUAGE languageLabelTimeoutES = new LANGUAGE();
    languageLabelTimeoutES.setISO639(ISO639.ES);
    languageLabelTimeoutES.setTEXT("Tiempo restante:");

    languagesLabelTimeout.getLANGUAGE().add(languageLabelTimeoutDE);
    languagesLabelTimeout.getLANGUAGE().add(languageLabelTimeoutEN);
    languagesLabelTimeout.getLANGUAGE().add(languageLabelTimeoutES);
    commandLabelTimeout.setLANGUAGES(languagesLabelTimeout);

    COMMAND commandLabelRSA = new COMMAND();
    commandLabelRSA.setKEY(KEY.LABEL_RSA);
    LANGUAGES languagesLabelRSA = new LANGUAGES();

    LANGUAGE languageLabelRSA_DE = new LANGUAGE();
    languageLabelRSA_DE.setISO639(ISO639.DE);
    languageLabelRSA_DE.setTEXT("Gespräche bleiben vertaulich.");

    LANGUAGE languageLabelRSA_EN = new LANGUAGE();
    languageLabelRSA_EN.setISO639(ISO639.EN);
    languageLabelRSA_EN.setTEXT("Your conversations will remain confidential.");

    LANGUAGE languageLabelRSA_ES = new LANGUAGE();
    languageLabelRSA_ES.setISO639(ISO639.ES);
    languageLabelRSA_ES.setTEXT("Tus conversaciones se mantendrán confidenciales.");

    languagesLabelRSA.getLANGUAGE().add(languageLabelRSA_DE);
    languagesLabelRSA.getLANGUAGE().add(languageLabelRSA_EN);
    languagesLabelRSA.getLANGUAGE().add(languageLabelRSA_ES);
    commandLabelRSA.setLANGUAGES(languagesLabelRSA);

    COMMAND commandButtonRegistrieren = new COMMAND();
    commandButtonRegistrieren.setKEY(KEY.BUTTON_RIGISTRATE);
    LANGUAGES languagesButtonRegistrieren = new LANGUAGES();

    LANGUAGE languageButtonRegistrierenDE = new LANGUAGE();
    languageButtonRegistrierenDE.setISO639(ISO639.DE);
    languageButtonRegistrierenDE.setSHORTCUT(VIRTUALKEY.VK_R);
    languageButtonRegistrierenDE.setTEXT("Registrieren");

    LANGUAGE languageButtonRegistrierenEN = new LANGUAGE();
    languageButtonRegistrierenEN.setISO639(ISO639.EN);
    languageButtonRegistrierenEN.setSHORTCUT(VIRTUALKEY.VK_R);
    languageButtonRegistrierenEN.setTEXT("Register");

    LANGUAGE languageButtonRegistrierenES = new LANGUAGE();
    languageButtonRegistrierenES.setISO639(ISO639.ES);
    languageButtonRegistrierenES.setSHORTCUT(VIRTUALKEY.VK_R);
    languageButtonRegistrierenES.setTEXT("Registrarse");

    languagesButtonRegistrieren.getLANGUAGE().add(languageButtonRegistrierenDE);
    languagesButtonRegistrieren.getLANGUAGE().add(languageButtonRegistrierenEN);
    languagesButtonRegistrieren.getLANGUAGE().add(languageButtonRegistrierenES);
    commandButtonRegistrieren.setLANGUAGES(languagesButtonRegistrieren);

    COMMAND commandButtonWeiterOhneRegistrierung = new COMMAND();
    commandButtonWeiterOhneRegistrierung.setKEY(KEY.BUTTON_WEITER_OHNE_REGISTRIERUNG);
    LANGUAGES languagesButtonWeiterOhneRegistrierung = new LANGUAGES();

    LANGUAGE languageButtonWeiterOhneRegistrierungDE = new LANGUAGE();
    languageButtonWeiterOhneRegistrierungDE.setISO639(ISO639.DE);
    languageButtonWeiterOhneRegistrierungDE.setSHORTCUT(VIRTUALKEY.VK_W);
    languageButtonWeiterOhneRegistrierungDE.setTEXT("Weiter ohne Registrierung");

    LANGUAGE languageButtonWeiterOhneRegistrierungEN = new LANGUAGE();
    languageButtonWeiterOhneRegistrierungEN.setISO639(ISO639.EN);
    languageButtonWeiterOhneRegistrierungEN.setSHORTCUT(VIRTUALKEY.VK_N);
    languageButtonWeiterOhneRegistrierungEN.setTEXT("Continue without registration");

    LANGUAGE languageButtonWeiterOhneRegistrierungES = new LANGUAGE();
    languageButtonWeiterOhneRegistrierungES.setISO639(ISO639.ES);
    languageButtonWeiterOhneRegistrierungES.setSHORTCUT(VIRTUALKEY.VK_S);
    languageButtonWeiterOhneRegistrierungES.setTEXT("Continuar sin registrarse");

    languagesButtonWeiterOhneRegistrierung.getLANGUAGE().add(languageButtonWeiterOhneRegistrierungDE);
    languagesButtonWeiterOhneRegistrierung.getLANGUAGE().add(languageButtonWeiterOhneRegistrierungEN);
    languagesButtonWeiterOhneRegistrierung.getLANGUAGE().add(languageButtonWeiterOhneRegistrierungES);
    commandButtonWeiterOhneRegistrierung.setLANGUAGES(languagesButtonWeiterOhneRegistrierung);

    COMMAND commandFrameLogin = new COMMAND();
    commandFrameLogin.setKEY(KEY.FRAME_LOGIN);
    LANGUAGES languagesFrameLogin = new LANGUAGES();

    LANGUAGE languageFrameLoginDE = new LANGUAGE();
    languageFrameLoginDE.setISO639(ISO639.DE);
    languageFrameLoginDE.setTEXT("Anmeldung");

    LANGUAGE languageFrameLoginEN = new LANGUAGE();
    languageFrameLoginEN.setISO639(ISO639.EN);
    languageFrameLoginEN.setTEXT("Login");

    LANGUAGE languageFrameLoginES = new LANGUAGE();
    languageFrameLoginES.setISO639(ISO639.ES);
    languageFrameLoginES.setTEXT("Iniciar sesión");

    languagesFrameLogin.getLANGUAGE().add(languageFrameLoginDE);
    languagesFrameLogin.getLANGUAGE().add(languageFrameLoginEN);
    languagesFrameLogin.getLANGUAGE().add(languageFrameLoginES);
    commandFrameLogin.setLANGUAGES(languagesFrameLogin);

    COMMAND commandLabelNichtAngemeldet = new COMMAND();
    commandLabelNichtAngemeldet.setKEY(KEY.LABEL_NICHT_ANGEMELDET);
    LANGUAGES languagesLabelNichtAngemeldet = new LANGUAGES();

    LANGUAGE languageLabelNichtAngemeldetDE = new LANGUAGE();
    languageLabelNichtAngemeldetDE.setISO639(ISO639.DE);
    languageLabelNichtAngemeldetDE.setTEXT("Du bist nicht angemeldet.");

    LANGUAGE languageLabelNichtAngemeldetEN = new LANGUAGE();
    languageLabelNichtAngemeldetEN.setISO639(ISO639.EN);
    languageLabelNichtAngemeldetEN.setTEXT("You are not logged in.");

    LANGUAGE languageLabelNichtAngemeldetES = new LANGUAGE();
    languageLabelNichtAngemeldetES.setISO639(ISO639.ES);
    languageLabelNichtAngemeldetES.setTEXT("No has iniciado sesión.");

    languagesLabelNichtAngemeldet.getLANGUAGE().add(languageLabelNichtAngemeldetDE);
    languagesLabelNichtAngemeldet.getLANGUAGE().add(languageLabelNichtAngemeldetEN);
    languagesLabelNichtAngemeldet.getLANGUAGE().add(languageLabelNichtAngemeldetES);

    commandLabelNichtAngemeldet.setLANGUAGES(languagesLabelNichtAngemeldet);

    COMMAND commandLabelAnmeldungFehlgeschlagen = new COMMAND();
    commandLabelAnmeldungFehlgeschlagen.setKEY(KEY.LABEL_ANMELDUNG_FEHLGESCHLAGEN);
    LANGUAGES languagesAnmeldungFehlgeschlagen = new LANGUAGES();

    LANGUAGE languageAnmeldungFehlgeschlagenDE = new LANGUAGE();
    languageAnmeldungFehlgeschlagenDE.setISO639(ISO639.DE);
    languageAnmeldungFehlgeschlagenDE.setTEXT("Die Anmeldung ist fehlgeschlagen.");

    LANGUAGE languageAnmeldungFehlgeschlagenEN = new LANGUAGE();
    languageAnmeldungFehlgeschlagenEN.setISO639(ISO639.EN);
    languageAnmeldungFehlgeschlagenEN.setTEXT("The login has failed.");

    LANGUAGE languageAnmeldungFehlgeschlagenES = new LANGUAGE();
    languageAnmeldungFehlgeschlagenES.setISO639(ISO639.ES);
    languageAnmeldungFehlgeschlagenES.setTEXT("El inicio de sesión ha fallado.");

    languagesAnmeldungFehlgeschlagen.getLANGUAGE().add(languageAnmeldungFehlgeschlagenDE);
    languagesAnmeldungFehlgeschlagen.getLANGUAGE().add(languageAnmeldungFehlgeschlagenEN);
    languagesAnmeldungFehlgeschlagen.getLANGUAGE().add(languageAnmeldungFehlgeschlagenES);
    commandLabelAnmeldungFehlgeschlagen.setLANGUAGES(languagesAnmeldungFehlgeschlagen);

    COMMAND commandLabelAnmeldungErfolgreich = new COMMAND();
    commandLabelAnmeldungErfolgreich.setKEY(KEY.LABEL_ERFOLGREICH_ANGEMELDET);
    LANGUAGES languagesAnmeldungErfolgreich = new LANGUAGES();

    LANGUAGE languageAnmeldungErfolgreichDE = new LANGUAGE();
    languageAnmeldungErfolgreichDE.setISO639(ISO639.DE);
    languageAnmeldungErfolgreichDE.setTEXT("Die Anmeldung war erfolgreich!");

    LANGUAGE languageAnmeldungErfolgreichEN = new LANGUAGE();
    languageAnmeldungErfolgreichEN.setISO639(ISO639.EN);
    languageAnmeldungErfolgreichEN.setTEXT("The login was successful!");

    LANGUAGE languageAnmeldungErfolgreichES = new LANGUAGE();
    languageAnmeldungErfolgreichES.setISO639(ISO639.ES);
    languageAnmeldungErfolgreichES.setTEXT("El inicio de sesión fue exitoso.");

    languagesAnmeldungErfolgreich.getLANGUAGE().add(languageAnmeldungErfolgreichDE);
    languagesAnmeldungErfolgreich.getLANGUAGE().add(languageAnmeldungErfolgreichEN);
    languagesAnmeldungErfolgreich.getLANGUAGE().add(languageAnmeldungErfolgreichES);
    commandLabelAnmeldungErfolgreich.setLANGUAGES(languagesAnmeldungErfolgreich);

    COMMAND commandButtonSchliessen = new COMMAND();
    commandButtonSchliessen.setKEY(KEY.BUTTON_SCHLIESSEN);
    LANGUAGES languagesButtonSchliessen = new LANGUAGES();

    LANGUAGE languageButtonSchliessenDE = new LANGUAGE();
    languageButtonSchliessenDE.setISO639(ISO639.DE);
    languageButtonSchliessenDE.setTEXT("Schließen");

    LANGUAGE languageButtonSchliessenEN = new LANGUAGE();
    languageButtonSchliessenEN.setISO639(ISO639.EN);
    languageButtonSchliessenEN.setTEXT("Close");

    LANGUAGE languageButtonSchliessenES = new LANGUAGE();
    languageButtonSchliessenES.setISO639(ISO639.ES);
    languageButtonSchliessenES.setTEXT("Cerrar");

    languagesButtonSchliessen.getLANGUAGE().add(languageButtonSchliessenDE);
    languagesButtonSchliessen.getLANGUAGE().add(languageButtonSchliessenEN);
    languagesButtonSchliessen.getLANGUAGE().add(languageButtonSchliessenES);
    commandButtonSchliessen.setLANGUAGES(languagesButtonSchliessen);

    COMMAND commandLabelForum = new COMMAND();
    commandLabelForum.setKEY(KEY.LABEL_FORUM);
    LANGUAGES languagesLabelForum = new LANGUAGES();

    LANGUAGE languageLabelForumDE = new LANGUAGE();
    languageLabelForumDE.setISO639(ISO639.DE);
    languageLabelForumDE.setTEXT(
        "<html>Ein Forum ist ein allgemeiner Chatraum, der nicht von einem Benutzer erstellt und verwaltet werden kann. "
            + "Ein öffentlicher Pausenraum wird nach <b>XXX</b> Minuten in ein Forum umgewandelt.</html>"
    );

    LANGUAGE languageLabelForumEN = new LANGUAGE();
    languageLabelForumEN.setISO639(ISO639.EN);
    languageLabelForumEN.setTEXT(
        "<html>A forum is a general chat room that cannot be created and managed by a user. "
            + "A public break room is transformed into a forum after <b>XXX</b> minutes.</html>"
    );

    LANGUAGE languageLabelForumES = new LANGUAGE();
    languageLabelForumES.setISO639(ISO639.ES);
    languageLabelForumES.setTEXT(
        "<html>Un foro es una sala de chat general que no puede ser creada y gestionada por un usuario. "
            + "Una sala de descanso pública se transforma en un foro después de <b>XXX</b> minutos.</html>"
    );

    languagesLabelForum.getLANGUAGE().add(languageLabelForumDE);
    languagesLabelForum.getLANGUAGE().add(languageLabelForumEN);
    languagesLabelForum.getLANGUAGE().add(languageLabelForumES);
    commandLabelForum.setLANGUAGES(languagesLabelForum);
    COMMAND commandFrameLauncher = new COMMAND();
    commandFrameLauncher.setKEY(KEY.FRAME_LAUNCHER);
    LANGUAGES languagesFrameLauncher = new LANGUAGES();

    LANGUAGE languageFrameLauncherDE = new LANGUAGE();
    languageFrameLauncherDE.setISO639(ISO639.DE);
    languageFrameLauncherDE.setTEXT("Chaträume");

    LANGUAGE languageFrameLauncherEN = new LANGUAGE();
    languageFrameLauncherEN.setISO639(ISO639.EN);
    languageFrameLauncherEN.setTEXT("Chat Rooms");

    LANGUAGE languageFrameLauncherES = new LANGUAGE();
    languageFrameLauncherES.setISO639(ISO639.ES);
    languageFrameLauncherES.setTEXT("Salas de Chat");

    languagesFrameLauncher.getLANGUAGE().add(languageFrameLauncherDE);
    languagesFrameLauncher.getLANGUAGE().add(languageFrameLauncherEN);
    languagesFrameLauncher.getLANGUAGE().add(languageFrameLauncherES);
    commandFrameLauncher.setLANGUAGES(languagesFrameLauncher);

    COMMAND commandMenuAnzeige = new COMMAND();
    commandMenuAnzeige.setKEY(KEY.CHECK_BOX_MENU_ITEM_ANZEIGE);
    LANGUAGES languagesMenuAnzeige = new LANGUAGES();

    LANGUAGE languageMenuAnzeigeDE = new LANGUAGE();
    languageMenuAnzeigeDE.setISO639(ISO639.DE);
    languageMenuAnzeigeDE.setTEXT("Anzeige");

    LANGUAGE languageMenuAnzeigeEN = new LANGUAGE();
    languageMenuAnzeigeEN.setISO639(ISO639.EN);
    languageMenuAnzeigeEN.setTEXT("View options");

    LANGUAGE languageMenuAnzeigeES = new LANGUAGE();
    languageMenuAnzeigeES.setISO639(ISO639.ES);
    languageMenuAnzeigeES.setTEXT("Opciones de visualización");

    languagesMenuAnzeige.getLANGUAGE().add(languageMenuAnzeigeDE);
    languagesMenuAnzeige.getLANGUAGE().add(languageMenuAnzeigeEN);
    languagesMenuAnzeige.getLANGUAGE().add(languageMenuAnzeigeES);
    commandMenuAnzeige.setLANGUAGES(languagesMenuAnzeige);

    COMMAND commandCheckboxDatum = new COMMAND();
    commandCheckboxDatum.setKEY(KEY.CHECK_BOX_MENU_ITEM_DATUM);
    LANGUAGES languagesCheckboxDatum = new LANGUAGES();

    LANGUAGE languageCheckboxDatumDE = new LANGUAGE();
    languageCheckboxDatumDE.setISO639(ISO639.DE);
    languageCheckboxDatumDE.setSHORTCUT(VIRTUALKEY.VK_D);
    languageCheckboxDatumDE.setTEXT("Datum");

    LANGUAGE languageCheckboxDatumEN = new LANGUAGE();
    languageCheckboxDatumEN.setISO639(ISO639.EN);
    languageCheckboxDatumEN.setSHORTCUT(VIRTUALKEY.VK_D);
    languageCheckboxDatumEN.setTEXT("Date");

    LANGUAGE languageCheckboxDatumES = new LANGUAGE();
    languageCheckboxDatumES.setISO639(ISO639.ES);
    languageCheckboxDatumES.setSHORTCUT(VIRTUALKEY.VK_F);
    languageCheckboxDatumES.setTEXT("Fecha");

    languagesCheckboxDatum.getLANGUAGE().add(languageCheckboxDatumDE);
    languagesCheckboxDatum.getLANGUAGE().add(languageCheckboxDatumEN);
    languagesCheckboxDatum.getLANGUAGE().add(languageCheckboxDatumES);

    commandCheckboxDatum.setLANGUAGES(languagesCheckboxDatum);

    COMMAND commandCheckboxUhrzeit = new COMMAND();
    commandCheckboxUhrzeit.setKEY(KEY.CHECK_BOX_MENU_ITEM_UHRZEIT);
    LANGUAGES languagesCheckboxUhrzeit = new LANGUAGES();

    LANGUAGE languageCheckboxUhrzeitDE = new LANGUAGE();
    languageCheckboxUhrzeitDE.setISO639(ISO639.DE);
    languageCheckboxUhrzeitDE.setSHORTCUT(VIRTUALKEY.VK_U);
    languageCheckboxUhrzeitDE.setTEXT("Uhrzeit");

    LANGUAGE languageCheckboxUhrzeitEN = new LANGUAGE();
    languageCheckboxUhrzeitEN.setISO639(ISO639.EN);
    languageCheckboxUhrzeitEN.setSHORTCUT(VIRTUALKEY.VK_T);
    languageCheckboxUhrzeitEN.setTEXT("Time");

    LANGUAGE languageCheckboxUhrzeitES = new LANGUAGE();
    languageCheckboxUhrzeitES.setISO639(ISO639.ES);
    languageCheckboxUhrzeitES.setSHORTCUT(VIRTUALKEY.VK_H);
    languageCheckboxUhrzeitES.setTEXT("Hora");

    languagesCheckboxUhrzeit.getLANGUAGE().add(languageCheckboxUhrzeitDE);
    languagesCheckboxUhrzeit.getLANGUAGE().add(languageCheckboxUhrzeitEN);
    languagesCheckboxUhrzeit.getLANGUAGE().add(languageCheckboxUhrzeitES);

    commandCheckboxUhrzeit.setLANGUAGES(languagesCheckboxUhrzeit);

    COMMAND commandButtonAuswerfen = new COMMAND();
    commandButtonAuswerfen.setKEY(KEY.BUTTON_AUSWERFEN);
    LANGUAGES languagesButtonAuswerfen = new LANGUAGES();

    LANGUAGE languageButtonAuswerfenDE = new LANGUAGE();
    languageButtonAuswerfenDE.setISO639(ISO639.DE);
    languageButtonAuswerfenDE.setSHORTCUT(VIRTUALKEY.VK_A);
    languageButtonAuswerfenDE.setTEXT("Auswerfen");

    LANGUAGE languageButtonAuswerfenEN = new LANGUAGE();
    languageButtonAuswerfenEN.setISO639(ISO639.EN);
    languageButtonAuswerfenEN.setSHORTCUT(VIRTUALKEY.VK_E);
    languageButtonAuswerfenEN.setTEXT("Eject");

    LANGUAGE languageButtonAuswerfenES = new LANGUAGE();
    languageButtonAuswerfenES.setISO639(ISO639.ES);
    languageButtonAuswerfenES.setSHORTCUT(VIRTUALKEY.VK_E);
    languageButtonAuswerfenES.setTEXT("Expulsar");

    languagesButtonAuswerfen.getLANGUAGE().add(languageButtonAuswerfenDE);
    languagesButtonAuswerfen.getLANGUAGE().add(languageButtonAuswerfenEN);
    languagesButtonAuswerfen.getLANGUAGE().add(languageButtonAuswerfenES);

    commandButtonAuswerfen.setLANGUAGES(languagesButtonAuswerfen);

    COMMAND commandLabelLaut = new COMMAND();
    commandLabelLaut.setKEY(KEY.LABEL_LAUT);
    LANGUAGES languagesLabelLaut = new LANGUAGES();

    LANGUAGE languageLabelLautDE = new LANGUAGE();
    languageLabelLautDE.setISO639(ISO639.DE);
    languageLabelLautDE.setTEXT("<html>laut</html>");

    LANGUAGE languageLabelLautEN = new LANGUAGE();
    languageLabelLautEN.setISO639(ISO639.EN);
    languageLabelLautEN.setTEXT("<html>loud</html>");

    LANGUAGE languageLabelLautES = new LANGUAGE();
    languageLabelLautES.setISO639(ISO639.ES);
    languageLabelLautES.setTEXT("<html>alto</html>");

    languagesLabelLaut.getLANGUAGE().add(languageLabelLautDE);
    languagesLabelLaut.getLANGUAGE().add(languageLabelLautEN);
    languagesLabelLaut.getLANGUAGE().add(languageLabelLautES);
    commandLabelLaut.setLANGUAGES(languagesLabelLaut);

    COMMAND commandLabelLautlos = new COMMAND();
    commandLabelLautlos.setKEY(KEY.LABEL_LAUTLOS);
    LANGUAGES languagesLabelLautlos = new LANGUAGES();

    LANGUAGE languageLabelLautlosDE = new LANGUAGE();
    languageLabelLautlosDE.setISO639(ISO639.DE);
    languageLabelLautlosDE.setTEXT("<html>lautlos</html>");

    LANGUAGE languageLabelLautlosEN = new LANGUAGE();
    languageLabelLautlosEN.setISO639(ISO639.EN);
    languageLabelLautlosEN.setTEXT("<html>mute</html>");

    LANGUAGE languageLabelLautlosES = new LANGUAGE();
    languageLabelLautlosES.setISO639(ISO639.ES);
    languageLabelLautlosES.setTEXT("<html>mudo</html>");

    languagesLabelLautlos.getLANGUAGE().add(languageLabelLautlosDE);
    languagesLabelLautlos.getLANGUAGE().add(languageLabelLautlosEN);
    languagesLabelLautlos.getLANGUAGE().add(languageLabelLautlosES);
    commandLabelLautlos.setLANGUAGES(languagesLabelLautlos);

    LANGUAGES languagesLabelLeise = new LANGUAGES();
    LANGUAGE languageLabelLeiseDE = new LANGUAGE();
    languageLabelLeiseDE.setISO639(ISO639.DE);
    languageLabelLeiseDE.setTEXT("<html>leise</html>");

    LANGUAGE languageLabelLeiseEN = new LANGUAGE();
    languageLabelLeiseEN.setISO639(ISO639.EN);
    languageLabelLeiseEN.setTEXT("<html>quiet</html>");

    LANGUAGE languageLabelLeiseES = new LANGUAGE();
    languageLabelLeiseES.setISO639(ISO639.ES);
    languageLabelLeiseES.setTEXT("<html>bajo</html>");

    languagesLabelLeise.getLANGUAGE().add(languageLabelLeiseDE);
    languagesLabelLeise.getLANGUAGE().add(languageLabelLeiseEN);
    languagesLabelLeise.getLANGUAGE().add(languageLabelLeiseES);

    COMMAND commandLabelLeise = new COMMAND();
    commandLabelLeise.setKEY(KEY.LABEL_LEISE);
    commandLabelLeise.setLANGUAGES(languagesLabelLeise);

    COMMAND commandLabelNormal = new COMMAND();
    commandLabelNormal.setKEY(KEY.LABEL_NORMAL);
    LANGUAGES languagesLabelNormal = new LANGUAGES();

    LANGUAGE languageLabelNormalDE = new LANGUAGE();
    languageLabelNormalDE.setISO639(ISO639.DE);
    languageLabelNormalDE.setTEXT("normal");

    LANGUAGE languageLabelNormalEN = new LANGUAGE();
    languageLabelNormalEN.setISO639(ISO639.EN);
    languageLabelNormalEN.setTEXT("normal");

    LANGUAGE languageLabelNormalES = new LANGUAGE();
    languageLabelNormalES.setISO639(ISO639.ES);
    languageLabelNormalES.setTEXT("normal");

    languagesLabelNormal.getLANGUAGE().add(languageLabelNormalDE);
    languagesLabelNormal.getLANGUAGE().add(languageLabelNormalEN);
    languagesLabelNormal.getLANGUAGE().add(languageLabelNormalES);
    commandLabelNormal.setLANGUAGES(languagesLabelNormal);

    COMMAND commandFrameProfil = new COMMAND();
    commandFrameProfil.setKEY(KEY.FRAME_UPDATE_PROFIL);
    LANGUAGES languagesFrameProfil = new LANGUAGES();

    LANGUAGE languageFrameProfilDE = new LANGUAGE();
    languageFrameProfilDE.setISO639(ISO639.DE);
    languageFrameProfilDE.setTEXT("Konto bearbeiten");

    LANGUAGE languageFrameProfilEN = new LANGUAGE();
    languageFrameProfilEN.setISO639(ISO639.EN);
    languageFrameProfilEN.setTEXT("Edit account");

    LANGUAGE languageFrameProfilES = new LANGUAGE();
    languageFrameProfilES.setISO639(ISO639.ES);
    languageFrameProfilES.setTEXT("Editar cuenta");

    languagesFrameProfil.getLANGUAGE().add(languageFrameProfilDE);
    languagesFrameProfil.getLANGUAGE().add(languageFrameProfilEN);
    languagesFrameProfil.getLANGUAGE().add(languageFrameProfilES);
    commandFrameProfil.setLANGUAGES(languagesFrameProfil);

    COMMAND commandButtonSave = new COMMAND();
    commandButtonSave.setKEY(KEY.BUTTON_SPEICHERN);
    LANGUAGES languagesButtonSpeichern = new LANGUAGES();

    LANGUAGE languageButtonSpeichernDE = new LANGUAGE();
    languageButtonSpeichernDE.setISO639(ISO639.DE);
    languageButtonSpeichernDE.setTEXT("Speichern");

    LANGUAGE languageButtonSpeichernEN = new LANGUAGE();
    languageButtonSpeichernEN.setISO639(ISO639.EN);
    languageButtonSpeichernEN.setTEXT("Save");

    LANGUAGE languageButtonSpeichernES = new LANGUAGE();
    languageButtonSpeichernES.setISO639(ISO639.ES);
    languageButtonSpeichernES.setTEXT("Guardar");

    languagesButtonSpeichern.getLANGUAGE().add(languageButtonSpeichernDE);
    languagesButtonSpeichern.getLANGUAGE().add(languageButtonSpeichernEN);
    languagesButtonSpeichern.getLANGUAGE().add(languageButtonSpeichernES);

    commandButtonSave.setLANGUAGES(languagesButtonSpeichern);

    COMMAND commandButtonSave_Close = new COMMAND();
    commandButtonSave_Close.setKEY(KEY.BUTTON_SPEICHERN_SCHLIESSEN);
    LANGUAGES languagesButtonSpeichernSchliessen = new LANGUAGES();

    LANGUAGE languageButtonSpeichernSchliessenDE = new LANGUAGE();
    languageButtonSpeichernSchliessenDE.setISO639(ISO639.DE);
    languageButtonSpeichernSchliessenDE.setSHORTCUT(VIRTUALKEY.VK_P);
    languageButtonSpeichernSchliessenDE.setTEXT("Speichern & Schließen");

    LANGUAGE languageButtonSpeichernSchliessenEN = new LANGUAGE();
    languageButtonSpeichernSchliessenEN.setISO639(ISO639.EN);
    languageButtonSpeichernSchliessenEN.setSHORTCUT(VIRTUALKEY.VK_V);
    languageButtonSpeichernSchliessenEN.setTEXT("Save & Close");

    LANGUAGE languageButtonSpeichernSchliessenES = new LANGUAGE();
    languageButtonSpeichernSchliessenES.setISO639(ISO639.ES);
    languageButtonSpeichernSchliessenES.setSHORTCUT(VIRTUALKEY.VK_U);
    languageButtonSpeichernSchliessenES.setTEXT("Guardar & Cerrar");

    languagesButtonSpeichernSchliessen.getLANGUAGE().add(languageButtonSpeichernSchliessenDE);
    languagesButtonSpeichernSchliessen.getLANGUAGE().add(languageButtonSpeichernSchliessenEN);
    languagesButtonSpeichernSchliessen.getLANGUAGE().add(languageButtonSpeichernSchliessenES);

    commandButtonSave_Close.setLANGUAGES(languagesButtonSpeichernSchliessen);

    COMMAND commandLabelPasswortConfirm = new COMMAND();
    commandLabelPasswortConfirm.setKEY(KEY.LABEL_PASSWORT_BESTAETIGEN);
    LANGUAGES languagesLabelPasswortBestaetigen = new LANGUAGES();

    LANGUAGE languageLabelPasswortBestaetigenDE = new LANGUAGE();
    languageLabelPasswortBestaetigenDE.setISO639(ISO639.DE);
    languageLabelPasswortBestaetigenDE.setTEXT("Passwort bestätigen");

    LANGUAGE languageLabelPasswortBestaetigenEN = new LANGUAGE();
    languageLabelPasswortBestaetigenEN.setISO639(ISO639.EN);
    languageLabelPasswortBestaetigenEN.setTEXT("Password confirmation");

    LANGUAGE languageLabelPasswortBestaetigenES = new LANGUAGE();
    languageLabelPasswortBestaetigenES.setISO639(ISO639.ES);
    languageLabelPasswortBestaetigenES.setTEXT("Confirmación de contraseña");

    languagesLabelPasswortBestaetigen.getLANGUAGE().add(languageLabelPasswortBestaetigenDE);
    languagesLabelPasswortBestaetigen.getLANGUAGE().add(languageLabelPasswortBestaetigenEN);
    languagesLabelPasswortBestaetigen.getLANGUAGE().add(languageLabelPasswortBestaetigenES);
    commandLabelPasswortConfirm.setLANGUAGES(languagesLabelPasswortBestaetigen);

    COMMAND commandLabelBenutzerid = new COMMAND();
    commandLabelBenutzerid.setKEY(KEY.LABEL_BENUTZER_ID);
    LANGUAGES languagesLabelBenutzerid = new LANGUAGES();

    LANGUAGE languageLabelBenutzeridDE = new LANGUAGE();
    languageLabelBenutzeridDE.setISO639(ISO639.DE);
    languageLabelBenutzeridDE.setTEXT("Benutzer-ID");

    LANGUAGE languageLabelBenutzeridEN = new LANGUAGE();
    languageLabelBenutzeridEN.setISO639(ISO639.EN);
    languageLabelBenutzeridEN.setTEXT("User ID");

    LANGUAGE languageLabelBenutzeridES = new LANGUAGE();
    languageLabelBenutzeridES.setISO639(ISO639.ES);
    languageLabelBenutzeridES.setTEXT("ID de usuario");

    languagesLabelBenutzerid.getLANGUAGE().add(languageLabelBenutzeridDE);
    languagesLabelBenutzerid.getLANGUAGE().add(languageLabelBenutzeridEN);
    languagesLabelBenutzerid.getLANGUAGE().add(languageLabelBenutzeridES);

    commandLabelBenutzerid.setLANGUAGES(languagesLabelBenutzerid);

    COMMAND commandLabelSpitzname = new COMMAND();
    commandLabelSpitzname.setKEY(KEY.LABEL_SPITZNAME);
    LANGUAGES languagesLabelSpitzname = new LANGUAGES();

    LANGUAGE languageLabelSpitznameDE = new LANGUAGE();
    languageLabelSpitznameDE.setISO639(ISO639.DE);
    languageLabelSpitznameDE.setTEXT("Nickname");

    LANGUAGE languageLabelSpitznameEN = new LANGUAGE();
    languageLabelSpitznameEN.setISO639(ISO639.EN);
    languageLabelSpitznameEN.setTEXT("Nickname");

    LANGUAGE languageLabelSpitznameES = new LANGUAGE();
    languageLabelSpitznameES.setISO639(ISO639.ES);
    languageLabelSpitznameES.setTEXT("Alias");

    languagesLabelSpitzname.getLANGUAGE().add(languageLabelSpitznameDE);
    languagesLabelSpitzname.getLANGUAGE().add(languageLabelSpitznameEN);
    languagesLabelSpitzname.getLANGUAGE().add(languageLabelSpitznameES);
    commandLabelSpitzname.setLANGUAGES(languagesLabelSpitzname);

    COMMAND commandTitledBorderVordergrundfarbe = new COMMAND();
    commandTitledBorderVordergrundfarbe.setKEY(KEY.TITLED_BORDER_VORDERGRUNDFARBE);
    LANGUAGES languagesTitledBorderVordergrundfarbe = new LANGUAGES();

    LANGUAGE languageTitledBorderVordergrundfarbeDE = new LANGUAGE();
    languageTitledBorderVordergrundfarbeDE.setISO639(ISO639.DE);
    languageTitledBorderVordergrundfarbeDE.setTEXT("Vordergrundfarbe");

    LANGUAGE languageTitledBorderVordergrundfarbeEN = new LANGUAGE();
    languageTitledBorderVordergrundfarbeEN.setISO639(ISO639.EN);
    languageTitledBorderVordergrundfarbeEN.setTEXT("Foreground Color");

    LANGUAGE languageTitledBorderVordergrundfarbeES = new LANGUAGE();
    languageTitledBorderVordergrundfarbeES.setISO639(ISO639.ES);
    languageTitledBorderVordergrundfarbeES.setTEXT("Color de primer plano");

    languagesTitledBorderVordergrundfarbe.getLANGUAGE().add(languageTitledBorderVordergrundfarbeDE);
    languagesTitledBorderVordergrundfarbe.getLANGUAGE().add(languageTitledBorderVordergrundfarbeEN);
    languagesTitledBorderVordergrundfarbe.getLANGUAGE().add(languageTitledBorderVordergrundfarbeES);
    commandTitledBorderVordergrundfarbe.setLANGUAGES(languagesTitledBorderVordergrundfarbe);

    COMMAND commandTitledBorderHintergrundfarbe = new COMMAND();
    commandTitledBorderHintergrundfarbe.setKEY(KEY.TITLED_BORDER_HINTERGRUNDFARBE);
    LANGUAGES languagesTitledBorderHintergrundfarbe = new LANGUAGES();

    LANGUAGE languageTitledBorderHintergrundfarbeDE = new LANGUAGE();
    languageTitledBorderHintergrundfarbeDE.setISO639(ISO639.DE);
    languageTitledBorderHintergrundfarbeDE.setTEXT("Hintergrundfarbe");

    LANGUAGE languageTitledBorderHintergrundfarbeEN = new LANGUAGE();
    languageTitledBorderHintergrundfarbeEN.setISO639(ISO639.EN);
    languageTitledBorderHintergrundfarbeEN.setTEXT("Background color");

    LANGUAGE languageTitledBorderHintergrundfarbeES = new LANGUAGE();
    languageTitledBorderHintergrundfarbeES.setISO639(ISO639.ES);
    languageTitledBorderHintergrundfarbeES.setTEXT("Color de fondo");

    languagesTitledBorderHintergrundfarbe.getLANGUAGE().add(languageTitledBorderHintergrundfarbeDE);
    languagesTitledBorderHintergrundfarbe.getLANGUAGE().add(languageTitledBorderHintergrundfarbeEN);
    languagesTitledBorderHintergrundfarbe.getLANGUAGE().add(languageTitledBorderHintergrundfarbeES);

    commandTitledBorderHintergrundfarbe.setLANGUAGES(languagesTitledBorderHintergrundfarbe);

    COMMAND commandButtonStartService = new COMMAND();
    commandButtonStartService.setKEY(KEY.BUTTON_START_SERVICE);
    LANGUAGES languagesButtonStartService = new LANGUAGES();

    LANGUAGE languageButtonStartServiceDE = new LANGUAGE();
    languageButtonStartServiceDE.setISO639(ISO639.DE);
    languageButtonStartServiceDE.setTEXT("Service starten");

    LANGUAGE languageButtonStartServiceEN = new LANGUAGE();
    languageButtonStartServiceEN.setISO639(ISO639.EN);
    languageButtonStartServiceEN.setTEXT("Start service");

    LANGUAGE languageButtonStartServiceES = new LANGUAGE();
    languageButtonStartServiceES.setISO639(ISO639.ES);
    languageButtonStartServiceES.setTEXT("Iniciar servicio");

    languagesButtonStartService.getLANGUAGE().add(languageButtonStartServiceDE);
    languagesButtonStartService.getLANGUAGE().add(languageButtonStartServiceEN);
    languagesButtonStartService.getLANGUAGE().add(languageButtonStartServiceES);

    commandButtonStartService.setLANGUAGES(languagesButtonStartService);

    COMMAND commandButtonStopService = new COMMAND();
    commandButtonStopService.setKEY(KEY.BUTTON_STOP_SERVICE);
    LANGUAGES languagesButtonStopService = new LANGUAGES();

    LANGUAGE languageButtonStopServiceDE = new LANGUAGE();
    languageButtonStopServiceDE.setISO639(ISO639.DE);
    languageButtonStopServiceDE.setTEXT("Service anhalten");

    LANGUAGE languageButtonStopServiceEN = new LANGUAGE();
    languageButtonStopServiceEN.setISO639(ISO639.EN);
    languageButtonStopServiceEN.setTEXT("Stop service");

    LANGUAGE languageButtonStopServiceES = new LANGUAGE();
    languageButtonStopServiceES.setISO639(ISO639.ES);
    languageButtonStopServiceES.setTEXT("Detener el servicio");

    languagesButtonStopService.getLANGUAGE().add(languageButtonStopServiceDE);
    languagesButtonStopService.getLANGUAGE().add(languageButtonStopServiceEN);
    languagesButtonStopService.getLANGUAGE().add(languageButtonStopServiceES);
    commandButtonStopService.setLANGUAGES(languagesButtonStopService);

    COMMAND commandFrameServerKonfigurieren = new COMMAND();
    commandFrameServerKonfigurieren.setKEY(KEY.FRAME_SERVER_KONFIGURIEREN);
    LANGUAGES languagesFrameServerKonfigurieren = new LANGUAGES();

    LANGUAGE languageFrameServerKonfigurierenDE = new LANGUAGE();
    languageFrameServerKonfigurierenDE.setISO639(ISO639.DE);
    languageFrameServerKonfigurierenDE.setTEXT("Server konfigurieren");

    LANGUAGE languageFrameServerKonfigurierenEN = new LANGUAGE();
    languageFrameServerKonfigurierenEN.setISO639(ISO639.EN);
    languageFrameServerKonfigurierenEN.setTEXT("Server settings");

    LANGUAGE languageFrameServerKonfigurierenES = new LANGUAGE();
    languageFrameServerKonfigurierenES.setISO639(ISO639.ES);
    languageFrameServerKonfigurierenES.setTEXT("Configuración del servidor");

    languagesFrameServerKonfigurieren.getLANGUAGE().add(languageFrameServerKonfigurierenDE);
    languagesFrameServerKonfigurieren.getLANGUAGE().add(languageFrameServerKonfigurierenEN);
    languagesFrameServerKonfigurieren.getLANGUAGE().add(languageFrameServerKonfigurierenES);
    commandFrameServerKonfigurieren.setLANGUAGES(languagesFrameServerKonfigurieren);

    COMMAND commandLabelLautsprecher = new COMMAND();
    commandLabelLautsprecher.setKEY(null);
    LANGUAGES languagesLabelLautsprecher = new LANGUAGES();

    LANGUAGE languageLabelLautsprecherDE = new LANGUAGE();
    languageLabelLautsprecherDE.setISO639(ISO639.DE);
    languageLabelLautsprecherDE.setTEXT("Mein Lautsprecher ist");

    LANGUAGE languageLabelLautsprecherEN = new LANGUAGE();
    languageLabelLautsprecherEN.setISO639(ISO639.EN);
    languageLabelLautsprecherEN.setTEXT("My speaker is");

    LANGUAGE languageLabelLautsprecherES = new LANGUAGE();
    languageLabelLautsprecherES.setISO639(ISO639.ES);
    languageLabelLautsprecherES.setTEXT("Mi altavoz es");

    languagesLabelLautsprecher.getLANGUAGE().add(languageLabelLautsprecherDE);
    languagesLabelLautsprecher.getLANGUAGE().add(languageLabelLautsprecherEN);
    languagesLabelLautsprecher.getLANGUAGE().add(languageLabelLautsprecherES);

    commandLabelLautsprecher.setLANGUAGES(languagesLabelLautsprecher);
    commandLabelLautsprecher.setKEY(KEY.LABEL_LAUTSPRECHER);

    COMMAND commandLabelMeinMikrofonIst = new COMMAND();
    commandLabelMeinMikrofonIst.setKEY(KEY.LABEL_MIKROFONAUFNAHME);
    LANGUAGES languagesLabelMeinMikrofonIst = new LANGUAGES();

    LANGUAGE languageLabelMeinMikrofonIstDE = new LANGUAGE();
    languageLabelMeinMikrofonIstDE.setISO639(ISO639.DE);
    languageLabelMeinMikrofonIstDE.setTEXT("Mein Mikrofon ist");

    LANGUAGE languageLabelMeinMikrofonIstEN = new LANGUAGE();
    languageLabelMeinMikrofonIstEN.setISO639(ISO639.EN);
    languageLabelMeinMikrofonIstEN.setTEXT("My microphone is");

    LANGUAGE languageLabelMeinMikrofonIstES = new LANGUAGE();
    languageLabelMeinMikrofonIstES.setISO639(ISO639.ES);
    languageLabelMeinMikrofonIstES.setTEXT("Mi micrófono es");

    languagesLabelMeinMikrofonIst.getLANGUAGE().add(languageLabelMeinMikrofonIstDE);
    languagesLabelMeinMikrofonIst.getLANGUAGE().add(languageLabelMeinMikrofonIstEN);
    languagesLabelMeinMikrofonIst.getLANGUAGE().add(languageLabelMeinMikrofonIstES);
    commandLabelMeinMikrofonIst.setLANGUAGES(languagesLabelMeinMikrofonIst);

    COMMAND commandLabelDieAbtastrate = new COMMAND();
    commandLabelDieAbtastrate.setKEY(KEY.LABEL_SPRACHQUALITAET);
    LANGUAGES languagesLabelDieAbtastrate = new LANGUAGES();

    LANGUAGE languageLabelDieAbtastrateDE = new LANGUAGE();
    languageLabelDieAbtastrateDE.setISO639(ISO639.DE);
    languageLabelDieAbtastrateDE.setTEXT("Die Abtastrate ist");

    LANGUAGE languageLabelDieAbtastrateEN = new LANGUAGE();
    languageLabelDieAbtastrateEN.setISO639(ISO639.EN);
    languageLabelDieAbtastrateEN.setTEXT("The sampling rate is");

    LANGUAGE languageLabelDieAbtastrateES = new LANGUAGE();
    languageLabelDieAbtastrateES.setISO639(ISO639.ES);
    languageLabelDieAbtastrateES.setTEXT("La frecuencia de muestreo es de");

    languagesLabelDieAbtastrate.getLANGUAGE().add(languageLabelDieAbtastrateDE);
    languagesLabelDieAbtastrate.getLANGUAGE().add(languageLabelDieAbtastrateEN);
    languagesLabelDieAbtastrate.getLANGUAGE().add(languageLabelDieAbtastrateES);
    commandLabelDieAbtastrate.setLANGUAGES(languagesLabelDieAbtastrate);

    COMMAND commandLabelStereo = new COMMAND();
    commandLabelStereo.setKEY(KEY.LABEL_STEREO);
    LANGUAGES languagesLabelStereo = new LANGUAGES();

    LANGUAGE languageLabelStereoDE = new LANGUAGE();
    languageLabelStereoDE.setISO639(ISO639.DE);
    languageLabelStereoDE.setTEXT("Stereo für die Mikrofonaufnahme.");

    LANGUAGE languageLabelStereoEN = new LANGUAGE();
    languageLabelStereoEN.setISO639(ISO639.EN);
    languageLabelStereoEN.setTEXT("stereo for microphone recording.");

    LANGUAGE languageLabelStereoES = new LANGUAGE();
    languageLabelStereoES.setISO639(ISO639.ES);
    languageLabelStereoES.setTEXT("estéreo para la grabación con micrófono.");

    languagesLabelStereo.getLANGUAGE().add(languageLabelStereoDE);
    languagesLabelStereo.getLANGUAGE().add(languageLabelStereoEN);
    languagesLabelStereo.getLANGUAGE().add(languageLabelStereoES);
    commandLabelStereo.setLANGUAGES(languagesLabelStereo);

    COMMAND commandButtonDial = new COMMAND();
    commandButtonDial.setKEY(KEY.BUTTON_DIAL);
    LANGUAGES languagesButtonDial = new LANGUAGES();

    LANGUAGE languageButtonDialDE = new LANGUAGE();
    languageButtonDialDE.setISO639(ISO639.DE);
    languageButtonDialDE.setTEXT("Wählen");
    languageButtonDialDE.setSHORTCUT(VIRTUALKEY.VK_W);

    LANGUAGE languageButtonDialEN = new LANGUAGE();
    languageButtonDialEN.setISO639(ISO639.EN);
    languageButtonDialEN.setTEXT("Dial");
    languageButtonDialEN.setSHORTCUT(VIRTUALKEY.VK_D);

    LANGUAGE languageButtonDialES = new LANGUAGE();
    languageButtonDialES.setISO639(ISO639.ES);
    languageButtonDialES.setTEXT("Marcar");
    languageButtonDialES.setSHORTCUT(VIRTUALKEY.VK_M);

    languagesButtonDial.getLANGUAGE().add(languageButtonDialDE);
    languagesButtonDial.getLANGUAGE().add(languageButtonDialEN);
    languagesButtonDial.getLANGUAGE().add(languageButtonDialES);
    commandButtonDial.setLANGUAGES(languagesButtonDial);

    COMMAND commandButtonTelefonAbnehmen = new COMMAND();
    commandButtonTelefonAbnehmen.setKEY(KEY.BUTTON_HOERER_ABNEHMEN);
    LANGUAGES languagesTelefonAbnehmen = new LANGUAGES();

    LANGUAGE languageButtonTelefonAbnehmenDE = new LANGUAGE();
    languageButtonTelefonAbnehmenDE.setISO639(ISO639.DE);
    languageButtonTelefonAbnehmenDE.setSHORTCUT(VIRTUALKEY.VK_A);
    languageButtonTelefonAbnehmenDE.setTEXT("Abnehmen");

    LANGUAGE languageButtonTelefonAbnehmenEN = new LANGUAGE();
    languageButtonTelefonAbnehmenEN.setISO639(ISO639.EN);
    languageButtonTelefonAbnehmenEN.setSHORTCUT(VIRTUALKEY.VK_P);
    languageButtonTelefonAbnehmenEN.setTEXT("Pick up");

    LANGUAGE languageButtonTelefonAbnehmenES = new LANGUAGE();
    languageButtonTelefonAbnehmenES.setISO639(ISO639.ES);
    languageButtonTelefonAbnehmenES.setSHORTCUT(VIRTUALKEY.VK_D);
    languageButtonTelefonAbnehmenES.setTEXT("Descolgar");

    languagesTelefonAbnehmen.getLANGUAGE().add(languageButtonTelefonAbnehmenDE);
    languagesTelefonAbnehmen.getLANGUAGE().add(languageButtonTelefonAbnehmenEN);
    languagesTelefonAbnehmen.getLANGUAGE().add(languageButtonTelefonAbnehmenES);
    commandButtonTelefonAbnehmen.setLANGUAGES(languagesTelefonAbnehmen);

    COMMAND commandButtonTelefonAuflegen = new COMMAND();
    commandButtonTelefonAuflegen.setKEY(KEY.BUTTON_HOERER_AUFLEGEN);
    LANGUAGES languagesTelefonAuflegen = new LANGUAGES();

    LANGUAGE languageButtonTelefonAuflegenDE = new LANGUAGE();
    languageButtonTelefonAuflegenDE.setISO639(ISO639.DE);
    languageButtonTelefonAuflegenDE.setSHORTCUT(VIRTUALKEY.VK_U);
    languageButtonTelefonAuflegenDE.setTEXT("Auflegen");

    LANGUAGE languageButtonTelefonAuflegenEN = new LANGUAGE();
    languageButtonTelefonAuflegenEN.setISO639(ISO639.EN);
    languageButtonTelefonAuflegenEN.setSHORTCUT(VIRTUALKEY.VK_H);
    languageButtonTelefonAuflegenEN.setTEXT("Hang up");

    LANGUAGE languageButtonTelefonAuflegenES = new LANGUAGE();
    languageButtonTelefonAuflegenES.setISO639(ISO639.ES);
    languageButtonTelefonAuflegenES.setSHORTCUT(VIRTUALKEY.VK_O);
    languageButtonTelefonAuflegenES.setTEXT("Colgar");

    languagesTelefonAuflegen.getLANGUAGE().add(languageButtonTelefonAuflegenDE);
    languagesTelefonAuflegen.getLANGUAGE().add(languageButtonTelefonAuflegenEN);
    languagesTelefonAuflegen.getLANGUAGE().add(languageButtonTelefonAuflegenES);
    commandButtonTelefonAuflegen.setLANGUAGES(languagesTelefonAuflegen);

    COMMAND commandLabelPersonenSindOnline = new COMMAND();
    commandLabelPersonenSindOnline.setKEY(KEY.LABEL_DIESE_PERSONEN_SIND_ONLINE);
    LANGUAGES languagesPersonenSindOnline = new LANGUAGES();

    LANGUAGE languageLabelPersonenSindOnlineDE = new LANGUAGE();
    languageLabelPersonenSindOnlineDE.setISO639(ISO639.DE);
    languageLabelPersonenSindOnlineDE.setTEXT("Diese Benutzer sind online");

    LANGUAGE languageLabelPersonenSindOnlineEN = new LANGUAGE();
    languageLabelPersonenSindOnlineEN.setISO639(ISO639.EN);
    languageLabelPersonenSindOnlineEN.setTEXT("These users are online");

    LANGUAGE languageLabelPersonenSindOnlineES = new LANGUAGE();
    languageLabelPersonenSindOnlineES.setISO639(ISO639.ES);
    languageLabelPersonenSindOnlineES.setTEXT("Estos usuarios están en línea");

    languagesPersonenSindOnline.getLANGUAGE().add(languageLabelPersonenSindOnlineDE);
    languagesPersonenSindOnline.getLANGUAGE().add(languageLabelPersonenSindOnlineEN);
    languagesPersonenSindOnline.getLANGUAGE().add(languageLabelPersonenSindOnlineES);
    commandLabelPersonenSindOnline.setLANGUAGES(languagesPersonenSindOnline);

    COMMAND commandButtonTrefferliste = new COMMAND();
    commandButtonTrefferliste.setKEY(KEY.BUTTON_TREFFERLISTE);
    LANGUAGES languagesButtonTrefferliste = new LANGUAGES();

    LANGUAGE languageButtonTrefferlisteDE = new LANGUAGE();
    languageButtonTrefferlisteDE.setISO639(ISO639.DE);
    languageButtonTrefferlisteDE.setSHORTCUT(VIRTUALKEY.VK_A);
    languageButtonTrefferlisteDE.setTEXT("Aktualisiere Trefferliste");

    LANGUAGE languageButtonTrefferlisteEN = new LANGUAGE();
    languageButtonTrefferlisteEN.setISO639(ISO639.EN);
    languageButtonTrefferlisteEN.setSHORTCUT(VIRTUALKEY.VK_R);
    languageButtonTrefferlisteEN.setTEXT("Refresh Search Results");

    LANGUAGE languageButtonTrefferlisteES = new LANGUAGE();
    languageButtonTrefferlisteES.setISO639(ISO639.ES);
    languageButtonTrefferlisteES.setSHORTCUT(VIRTUALKEY.VK_A);
    languageButtonTrefferlisteES.setTEXT("Actualizar lista de resultados");

    languagesButtonTrefferliste.getLANGUAGE().add(languageButtonTrefferlisteDE);
    languagesButtonTrefferliste.getLANGUAGE().add(languageButtonTrefferlisteEN);
    languagesButtonTrefferliste.getLANGUAGE().add(languageButtonTrefferlisteES);
    commandButtonTrefferliste.setLANGUAGES(languagesButtonTrefferliste);

    COMMAND commandButtonPublish = new COMMAND();
    commandButtonPublish.setKEY(KEY.BUTTON_PUBLISH);
    LANGUAGES languagesButtonPublish = new LANGUAGES();

    LANGUAGE languageButtonPublishDE = new LANGUAGE();
    languageButtonPublishDE.setISO639(ISO639.DE);
    languageButtonPublishDE.setSHORTCUT(VIRTUALKEY.VK_V);
    languageButtonPublishDE.setTEXT("Veröffentlichen");

    LANGUAGE languageButtonPublishEN = new LANGUAGE();
    languageButtonPublishEN.setISO639(ISO639.EN);
    languageButtonPublishEN.setSHORTCUT(VIRTUALKEY.VK_P);
    languageButtonPublishEN.setTEXT("Publish");

    LANGUAGE languageButtonPublishES = new LANGUAGE();
    languageButtonPublishES.setISO639(ISO639.ES);
    languageButtonPublishES.setSHORTCUT(VIRTUALKEY.VK_P);
    languageButtonPublishES.setTEXT("Publicar");

    languagesButtonPublish.getLANGUAGE().add(languageButtonPublishDE);
    languagesButtonPublish.getLANGUAGE().add(languageButtonPublishEN);
    languagesButtonPublish.getLANGUAGE().add(languageButtonPublishES);
    commandButtonPublish.setLANGUAGES(languagesButtonPublish);

    COMMAND commandLabelSuchenNach = new COMMAND();
    commandLabelSuchenNach.setKEY(KEY.LABEL_SUCHEN_NACH);
    LANGUAGES languagesButtonSuchenNach = new LANGUAGES();

    LANGUAGE languageButtonSuchenNachDE = new LANGUAGE();
    languageButtonSuchenNachDE.setISO639(ISO639.DE);
    languageButtonSuchenNachDE.setTEXT("Suchen nach...");

    LANGUAGE languageButtonSuchenNachEN = new LANGUAGE();
    languageButtonSuchenNachEN.setISO639(ISO639.EN);
    languageButtonSuchenNachEN.setTEXT("Search for Files...");

    LANGUAGE languageButtonSuchenNachES = new LANGUAGE();
    languageButtonSuchenNachES.setISO639(ISO639.ES);
    languageButtonSuchenNachES.setTEXT("Buscar archivos...");

    languagesButtonSuchenNach.getLANGUAGE().add(languageButtonSuchenNachDE);
    languagesButtonSuchenNach.getLANGUAGE().add(languageButtonSuchenNachEN);
    languagesButtonSuchenNach.getLANGUAGE().add(languageButtonSuchenNachES);
    commandLabelSuchenNach.setLANGUAGES(languagesButtonSuchenNach);

    COMMAND commandButtonSuchmusterAnlegen = new COMMAND();
    commandButtonSuchmusterAnlegen.setKEY(KEY.BUTTON_SUCHMUSTER_ANLEGEN);
    LANGUAGES languagesButtonSuchmusterAnlegen = new LANGUAGES();

    LANGUAGE languageButtonSuchmusterAnlegenDE = new LANGUAGE();
    languageButtonSuchmusterAnlegenDE.setISO639(ISO639.DE);
    languageButtonSuchmusterAnlegenDE.setSHORTCUT(VIRTUALKEY.VK_U);
    languageButtonSuchmusterAnlegenDE.setTEXT("Suchmuster anlegen");

    LANGUAGE languageButtonSuchmusterAnlegenEN = new LANGUAGE();
    languageButtonSuchmusterAnlegenEN.setISO639(ISO639.EN);
    languageButtonSuchmusterAnlegenEN.setSHORTCUT(VIRTUALKEY.VK_S);
    languageButtonSuchmusterAnlegenEN.setTEXT("Create Search Pattern");

    LANGUAGE languageButtonSuchmusterAnlegenES = new LANGUAGE();
    languageButtonSuchmusterAnlegenES.setISO639(ISO639.ES);
    languageButtonSuchmusterAnlegenES.setSHORTCUT(VIRTUALKEY.VK_B);
    languageButtonSuchmusterAnlegenES.setTEXT("Crear patrón de búsqueda");

    languagesButtonSuchmusterAnlegen.getLANGUAGE().add(languageButtonSuchmusterAnlegenDE);
    languagesButtonSuchmusterAnlegen.getLANGUAGE().add(languageButtonSuchmusterAnlegenEN);
    languagesButtonSuchmusterAnlegen.getLANGUAGE().add(languageButtonSuchmusterAnlegenES);
    commandButtonSuchmusterAnlegen.setLANGUAGES(languagesButtonSuchmusterAnlegen);

    COMMAND commandButtonSuchmusterEntfernen = new COMMAND();
    commandButtonSuchmusterEntfernen.setKEY(KEY.BUTTON_SUCHMUSTER_ENTFERNEN);
    LANGUAGES languagesButtonSuchmusterEntfernen = new LANGUAGES();
    commandButtonSuchmusterEntfernen.setLANGUAGES(languagesButtonSuchmusterEntfernen);

    LANGUAGE languageButtonSuchmusterEntfernenDE = new LANGUAGE();
    languageButtonSuchmusterEntfernenDE.setISO639(ISO639.DE);
    languageButtonSuchmusterEntfernenDE.setSHORTCUT(VIRTUALKEY.VK_E);
    languageButtonSuchmusterEntfernenDE.setTEXT("Entferne Suchmuster");

    LANGUAGE languageButtonSuchmusterEntfernenEN = new LANGUAGE();
    languageButtonSuchmusterEntfernenEN.setISO639(ISO639.EN);
    languageButtonSuchmusterEntfernenEN.setSHORTCUT(VIRTUALKEY.VK_R);
    languageButtonSuchmusterEntfernenEN.setTEXT("Remove Search Pattern");

    LANGUAGE languageButtonSuchmusterEntfernenES = new LANGUAGE();
    languageButtonSuchmusterEntfernenES.setISO639(ISO639.ES);
    languageButtonSuchmusterEntfernenES.setSHORTCUT(VIRTUALKEY.VK_E);
    languageButtonSuchmusterEntfernenES.setTEXT("Eliminar patrón de búsqueda");

    languagesButtonSuchmusterEntfernen.getLANGUAGE().add(languageButtonSuchmusterEntfernenDE);
    languagesButtonSuchmusterEntfernen.getLANGUAGE().add(languageButtonSuchmusterEntfernenEN);
    languagesButtonSuchmusterEntfernen.getLANGUAGE().add(languageButtonSuchmusterEntfernenES);

    COMMAND commandTitledBorderTrefferliste = new COMMAND();
    commandTitledBorderTrefferliste.setKEY(KEY.TITLED_BORDER_TREFFERLISTE);
    LANGUAGES languagesTitledBorder = new LANGUAGES();

    LANGUAGE languageTitledBorderTrefferlisteDE = new LANGUAGE();
    languageTitledBorderTrefferlisteDE.setISO639(ISO639.DE);
    languageTitledBorderTrefferlisteDE.setTEXT("Trefferliste");

    LANGUAGE languageTitledBorderTrefferlisteEN = new LANGUAGE();
    languageTitledBorderTrefferlisteEN.setISO639(ISO639.EN);
    languageTitledBorderTrefferlisteEN.setTEXT("Results List");

    LANGUAGE languageTitledBorderTrefferlisteES = new LANGUAGE();
    languageTitledBorderTrefferlisteES.setISO639(ISO639.ES);
    languageTitledBorderTrefferlisteES.setTEXT("Lista de resultados");

    languagesTitledBorder.getLANGUAGE().add(languageTitledBorderTrefferlisteDE);
    languagesTitledBorder.getLANGUAGE().add(languageTitledBorderTrefferlisteEN);
    languagesTitledBorder.getLANGUAGE().add(languageTitledBorderTrefferlisteES);
    commandTitledBorderTrefferliste.setLANGUAGES(languagesTitledBorder);

    COMMAND commandButtonTrennen = new COMMAND();
    commandButtonTrennen.setKEY(KEY.BUTTON_TRENNEN);
    LANGUAGES languagesButtonTrennen = new LANGUAGES();

    LANGUAGE languageButtonTrennenDE = new LANGUAGE();
    languageButtonTrennenDE.setISO639(ISO639.DE);
    languageButtonTrennenDE.setTEXT("Trennen");

    LANGUAGE languageButtonTrennenEN = new LANGUAGE();
    languageButtonTrennenEN.setISO639(ISO639.EN);
    languageButtonTrennenEN.setTEXT("Disconnect");

    LANGUAGE languageButtonTrennenES = new LANGUAGE();
    languageButtonTrennenES.setISO639(ISO639.ES);
    languageButtonTrennenES.setTEXT("Desconectar");

    languagesButtonTrennen.getLANGUAGE().add(languageButtonTrennenDE);
    languagesButtonTrennen.getLANGUAGE().add(languageButtonTrennenEN);
    languagesButtonTrennen.getLANGUAGE().add(languageButtonTrennenES);

    commandButtonTrennen.setLANGUAGES(languagesButtonTrennen);

    COMMAND commandStringDownload = new COMMAND();
    commandStringDownload.setKEY(KEY.STRING_DOWNLOAD);
    LANGUAGES languagesStringDownload = new LANGUAGES();

    LANGUAGE languageStringDownloadDE = new LANGUAGE();
    languageStringDownloadDE.setISO639(ISO639.DE);
    languageStringDownloadDE.setTEXT("Download");

    LANGUAGE languageStringDownloadEN = new LANGUAGE();
    languageStringDownloadEN.setISO639(ISO639.EN);
    languageStringDownloadEN.setTEXT("Download");

    LANGUAGE languageStringDownloadES = new LANGUAGE();
    languageStringDownloadES.setISO639(ISO639.ES);
    languageStringDownloadES.setTEXT("Descargar");

    languagesStringDownload.getLANGUAGE().add(languageStringDownloadDE);
    languagesStringDownload.getLANGUAGE().add(languageStringDownloadEN);
    languagesStringDownload.getLANGUAGE().add(languageStringDownloadES);

    commandStringDownload.setLANGUAGES(languagesStringDownload);

    COMMAND commandLabelDatei = new COMMAND();
    commandLabelDatei.setKEY(KEY.LABEL_DATEI);
    LANGUAGES languagesLabelDatei = new LANGUAGES();

    LANGUAGE languageLabelDateiDE = new LANGUAGE();
    languageLabelDateiDE.setISO639(ISO639.DE);
    languageLabelDateiDE.setTEXT("Datei");

    LANGUAGE languageLabelDateiEN = new LANGUAGE();
    languageLabelDateiEN.setISO639(ISO639.EN);
    languageLabelDateiEN.setTEXT("File");

    LANGUAGE languageLabelDateiES = new LANGUAGE();
    languageLabelDateiES.setISO639(ISO639.ES);
    languageLabelDateiES.setTEXT("Archivo");

    languagesLabelDatei.getLANGUAGE().add(languageLabelDateiDE);
    languagesLabelDatei.getLANGUAGE().add(languageLabelDateiEN);
    languagesLabelDatei.getLANGUAGE().add(languageLabelDateiES);
    commandLabelDatei.setLANGUAGES(languagesLabelDatei);

    COMMAND commandStringSchliessen = new COMMAND();
    commandStringSchliessen.setKEY(KEY.STRING_SCHLIESSEN);
    LANGUAGES languagesStringSchliessen = new LANGUAGES();

    LANGUAGE languageStringSchliessenDE = new LANGUAGE();
    languageStringSchliessenDE.setISO639(ISO639.DE);
    languageStringSchliessenDE.setTEXT("Schließen");

    LANGUAGE languageStringSchliessenEN = new LANGUAGE();
    languageStringSchliessenEN.setISO639(ISO639.EN);
    languageStringSchliessenEN.setTEXT("Close");

    LANGUAGE languageStringSchliessenES = new LANGUAGE();
    languageStringSchliessenES.setISO639(ISO639.ES);
    languageStringSchliessenES.setTEXT("Cerrer");

    languagesStringSchliessen.getLANGUAGE().add(languageStringSchliessenDE);
    languagesStringSchliessen.getLANGUAGE().add(languageStringSchliessenEN);
    languagesStringSchliessen.getLANGUAGE().add(languageStringSchliessenES);
    commandStringSchliessen.setLANGUAGES(languagesStringSchliessen);

    COMMAND commandStringSpeichern = new COMMAND();
    commandStringSpeichern.setKEY(KEY.STRING_SPEICHERN);
    LANGUAGES languagesStringSpeichern = new LANGUAGES();

    LANGUAGE languageStringSpeichernDE = new LANGUAGE();
    languageStringSpeichernDE.setISO639(ISO639.DE);
    languageStringSpeichernDE.setTEXT("Speichern");

    LANGUAGE languageStringSpeichernEN = new LANGUAGE();
    languageStringSpeichernEN.setISO639(ISO639.EN);
    languageStringSpeichernEN.setTEXT("Save");

    LANGUAGE languageStringSpeichernES = new LANGUAGE();
    languageStringSpeichernES.setISO639(ISO639.ES);
    languageStringSpeichernES.setTEXT("Guardar");

    languagesStringSpeichern.getLANGUAGE().add(languageStringSpeichernDE);
    languagesStringSpeichern.getLANGUAGE().add(languageStringSpeichernEN);
    languagesStringSpeichern.getLANGUAGE().add(languageStringSpeichernES);
    commandStringSpeichern.setLANGUAGES(languagesStringSpeichern);

    COMMAND commandStringJoker = new COMMAND();
    commandStringJoker.setKEY(KEY.STRING_JOKER);
    LANGUAGES languagesStringJoker = new LANGUAGES();

    LANGUAGE languageStringJokerDE = new LANGUAGE();
    languageStringJokerDE.setISO639(ISO639.DE);
    languageStringJokerDE.setTEXT("Ein Suchmuster ohne Jokerzeichen eintragen");

    LANGUAGE languageStringJokerEN = new LANGUAGE();
    languageStringJokerEN.setISO639(ISO639.EN);
    languageStringJokerEN.setTEXT("Enter a search pattern without wildcards");

    LANGUAGE languageStringJokerES = new LANGUAGE();
    languageStringJokerES.setISO639(ISO639.ES);
    languageStringJokerES.setTEXT("Introduce un patrón de búsqueda sin comodines");

    languagesStringJoker.getLANGUAGE().add(languageStringJokerDE);
    languagesStringJoker.getLANGUAGE().add(languageStringJokerEN);
    languagesStringJoker.getLANGUAGE().add(languageStringJokerES);
    commandStringJoker.setLANGUAGES(languagesStringJoker);

    COMMAND commandStringSuchmuster = new COMMAND();
    commandStringSuchmuster.setKEY(KEY.STRING_SUCHMUSTER);
    LANGUAGES languagesStringSuchmuster = new LANGUAGES();

    LANGUAGE languageStringSuchmusterDE = new LANGUAGE();
    languageStringSuchmusterDE.setISO639(ISO639.DE);
    languageStringSuchmusterDE.setTEXT("Suchmuster");

    LANGUAGE languageStringSuchmusterEN = new LANGUAGE();
    languageStringSuchmusterEN.setISO639(ISO639.EN);
    languageStringSuchmusterEN.setTEXT("Search pattern");

    LANGUAGE languageStringSuchmusterES = new LANGUAGE();
    languageStringSuchmusterES.setISO639(ISO639.ES);
    languageStringSuchmusterES.setTEXT("Patrón de búsqueda");

    languagesStringSuchmuster.getLANGUAGE().add(languageStringSuchmusterDE);
    languagesStringSuchmuster.getLANGUAGE().add(languageStringSuchmusterEN);
    languagesStringSuchmuster.getLANGUAGE().add(languageStringSuchmusterES);
    commandStringSuchmuster.setLANGUAGES(languagesStringSuchmuster);

    COMMAND commandStringChannel = new COMMAND();
    commandStringChannel.setKEY(KEY.STRING_CHANNEL);
    LANGUAGES languagesStringChannel = new LANGUAGES();

    LANGUAGE languageStringChannelDE = new LANGUAGE();
    languageStringChannelDE.setISO639(ISO639.DE);
    languageStringChannelDE.setTEXT("Übertragungskanal");

    LANGUAGE languageStringChannelEN = new LANGUAGE();
    languageStringChannelEN.setISO639(ISO639.EN);
    languageStringChannelEN.setTEXT("Transfer Channel");

    LANGUAGE languageStringChannelES = new LANGUAGE();
    languageStringChannelES.setISO639(ISO639.ES);
    languageStringChannelES.setTEXT("Canal de transferencia");

    languagesStringChannel.getLANGUAGE().add(languageStringChannelDE);
    languagesStringChannel.getLANGUAGE().add(languageStringChannelEN);
    languagesStringChannel.getLANGUAGE().add(languageStringChannelES);
    commandStringChannel.setLANGUAGES(languagesStringChannel);

    COMMAND commandLabelSchwarzeListe = new COMMAND();
    commandLabelSchwarzeListe.setKEY(KEY.LABEL_SCHWARZE_LISTE);
    LANGUAGES languagesLabelSchwarzeListe = new LANGUAGES();

    LANGUAGE languageLabelSchwarzeListeDE = new LANGUAGE();
    languageLabelSchwarzeListeDE.setISO639(ISO639.DE);
    languageLabelSchwarzeListeDE.setTEXT(
        "<html>" + "<body style=\"margin:6px\">"
            + "Alle markierten Dateitypen werden nicht auf andere Computer übertragen und sind für andere Benutzer nicht sichtbar."
            + "</body>"
            + "</html>"
    );

    LANGUAGE languageLabelSchwarzeListeEN = new LANGUAGE();
    languageLabelSchwarzeListeEN.setISO639(ISO639.EN);
    languageLabelSchwarzeListeEN.setTEXT(
        "<html>" + "<body style=\"margin:6px\">"
            + "All marked file types are not transferred to other computers and are not visible to other users."
            + "</body>"
            + "</html>"
    );

    LANGUAGE languageLabelSchwarzeListeES = new LANGUAGE();
    languageLabelSchwarzeListeES.setISO639(ISO639.ES);
    languageLabelSchwarzeListeES.setTEXT(
        "<html>" + "<body style=\"margin:6px\">"
            + "Todos los tipos de archivos marcados no se transfieren a otros ordenadores y no son visibles para otros usuarios."
            + "</body>"
            + "</html>"
    );

    languagesLabelSchwarzeListe.getLANGUAGE().add(languageLabelSchwarzeListeDE);
    languagesLabelSchwarzeListe.getLANGUAGE().add(languageLabelSchwarzeListeEN);
    languagesLabelSchwarzeListe.getLANGUAGE().add(languageLabelSchwarzeListeES);
    commandLabelSchwarzeListe.setLANGUAGES(languagesLabelSchwarzeListe);

    COMMAND commandFrameInfo = new COMMAND();
    commandFrameInfo.setKEY(KEY.FRAME_INFO);
    LANGUAGES languagesFrameInfo = new LANGUAGES();

    LANGUAGE languageFrameInfoDE = new LANGUAGE();
    languageFrameInfoDE.setISO639(ISO639.DE);
    languageFrameInfoDE.setTEXT("Lizenz");

    LANGUAGE languageFrameInfoEN = new LANGUAGE();
    languageFrameInfoEN.setISO639(ISO639.EN);
    languageFrameInfoEN.setTEXT("License");

    LANGUAGE languageFrameInfoES = new LANGUAGE();
    languageFrameInfoES.setISO639(ISO639.ES);
    languageFrameInfoES.setTEXT("Licencia");

    languagesFrameInfo.getLANGUAGE().add(languageFrameInfoDE);
    languagesFrameInfo.getLANGUAGE().add(languageFrameInfoEN);
    languagesFrameInfo.getLANGUAGE().add(languageFrameInfoES);
    commandFrameInfo.setLANGUAGES(languagesFrameInfo);

    COMMAND commandCheckBoxEmpfang = new COMMAND();
    commandCheckBoxEmpfang.setKEY(KEY.CHECK_BOX_EMPFANG);
    LANGUAGES languagesCheckBoxEmpfang = new LANGUAGES();

    LANGUAGE languageCheckBoxEmpfangDE = new LANGUAGE();
    languageCheckBoxEmpfangDE.setISO639(ISO639.DE);
    languageCheckBoxEmpfangDE.setTEXT("Ich erlaube den Bildschirmempfang.");

    LANGUAGE languageCheckBoxEmpfangEN = new LANGUAGE();
    languageCheckBoxEmpfangEN.setISO639(ISO639.EN);
    languageCheckBoxEmpfangEN.setTEXT("I consent to others transferring their screen to my computer.");

    LANGUAGE languageCheckBoxEmpfangES = new LANGUAGE();
    languageCheckBoxEmpfangES.setISO639(ISO639.ES);
    languageCheckBoxEmpfangES
        .setTEXT("<html>Consiento que otros transfieran su pantalla a mi ordenador.</html>");

    languagesCheckBoxEmpfang.getLANGUAGE().add(languageCheckBoxEmpfangDE);
    languagesCheckBoxEmpfang.getLANGUAGE().add(languageCheckBoxEmpfangEN);
    languagesCheckBoxEmpfang.getLANGUAGE().add(languageCheckBoxEmpfangES);
    commandCheckBoxEmpfang.setLANGUAGES(languagesCheckBoxEmpfang);

    COMMAND commandFrameBildschirmempfang = new COMMAND();
    commandFrameBildschirmempfang.setKEY(KEY.FRAME_BILDSCHIRMEMPFANG);
    LANGUAGES languagesFrameBildschirmempfang = new LANGUAGES();

    LANGUAGE languageBildschirmempfangDE = new LANGUAGE();
    languageBildschirmempfangDE.setISO639(ISO639.DE);
    languageBildschirmempfangDE.setTEXT("Teilen");

    LANGUAGE languageBildschirmempfangEN = new LANGUAGE();
    languageBildschirmempfangEN.setISO639(ISO639.EN);
    languageBildschirmempfangEN.setTEXT("Share");

    LANGUAGE languageBildschirmempfangES = new LANGUAGE();
    languageBildschirmempfangES.setISO639(ISO639.ES);
    languageBildschirmempfangES.setTEXT("Compartir");

    languagesFrameBildschirmempfang.getLANGUAGE().add(languageBildschirmempfangDE);
    languagesFrameBildschirmempfang.getLANGUAGE().add(languageBildschirmempfangEN);
    languagesFrameBildschirmempfang.getLANGUAGE().add(languageBildschirmempfangES);
    commandFrameBildschirmempfang.setLANGUAGES(languagesFrameBildschirmempfang);

    COMMAND commandLabelFuerDenEmpfang = new COMMAND();
    commandLabelFuerDenEmpfang.setKEY(KEY.LABEL_FUER_DEN_EMPFANG);
    LANGUAGES languagesLabelFuerDenEmpfang = new LANGUAGES();

    LANGUAGE languageLabelFuerDenEmpfangDE = new LANGUAGE();
    languageLabelFuerDenEmpfangDE.setISO639(ISO639.DE);
    languageLabelFuerDenEmpfangDE
        .setTEXT("<html>Für den Empfang von Bildschirmdaten muss eine Einwilligung vorliegen.</html>");

    LANGUAGE languageLabelFuerDenEmpfangEN = new LANGUAGE();
    languageLabelFuerDenEmpfangEN.setISO639(ISO639.EN);
    languageLabelFuerDenEmpfangEN.setTEXT("<html>Consent must be given to receive screen data.</html>");

    LANGUAGE languageLabelFuerDenEmpfangES = new LANGUAGE();
    languageLabelFuerDenEmpfangES.setISO639(ISO639.ES);
    languageLabelFuerDenEmpfangES
        .setTEXT("<html>Se debe dar el consentimiento para recibir los datos de la pantalla.</html>");

    languagesLabelFuerDenEmpfang.getLANGUAGE().add(languageLabelFuerDenEmpfangDE);
    languagesLabelFuerDenEmpfang.getLANGUAGE().add(languageLabelFuerDenEmpfangEN);
    languagesLabelFuerDenEmpfang.getLANGUAGE().add(languageLabelFuerDenEmpfangES);

    commandLabelFuerDenEmpfang.setLANGUAGES(languagesLabelFuerDenEmpfang);

    COMMAND commandButtonStarten = new COMMAND();
    commandButtonStarten.setKEY(KEY.BUTTON_STARTEN);
    LANGUAGES languagesButtonStarten = new LANGUAGES();

    LANGUAGE languageButtonStartenDE = new LANGUAGE();
    languageButtonStartenDE.setISO639(ISO639.DE);
    languageButtonStartenDE.setSHORTCUT(VIRTUALKEY.VK_S);
    languageButtonStartenDE.setTEXT("Starten");

    LANGUAGE languageButtonStartenEN = new LANGUAGE();
    languageButtonStartenEN.setISO639(ISO639.EN);
    languageButtonStartenEN.setSHORTCUT(VIRTUALKEY.VK_S);
    languageButtonStartenEN.setTEXT("Start");

    LANGUAGE languageButtonStartenES = new LANGUAGE();
    languageButtonStartenES.setISO639(ISO639.ES);
    languageButtonStartenES.setSHORTCUT(VIRTUALKEY.VK_I);
    languageButtonStartenES.setTEXT("Iniciar");

    languagesButtonStarten.getLANGUAGE().add(languageButtonStartenDE);
    languagesButtonStarten.getLANGUAGE().add(languageButtonStartenEN);
    languagesButtonStarten.getLANGUAGE().add(languageButtonStartenES);
    commandButtonStarten.setLANGUAGES(languagesButtonStarten);

    COMMAND commandLabelAnWenSoll = new COMMAND();
    commandLabelAnWenSoll.setKEY(KEY.LABEL_AN_WEN_SOLL_DER);
    LANGUAGES languagesLabelAnWenSoll = new LANGUAGES();

    LANGUAGE languageLabelAnWenSollDE = new LANGUAGE();
    languageLabelAnWenSollDE.setISO639(ISO639.DE);
    languageLabelAnWenSollDE.setTEXT("An wen soll der Bildschirm übertragen werden?");

    LANGUAGE languageLabelAnWenSollEN = new LANGUAGE();
    languageLabelAnWenSollEN.setISO639(ISO639.EN);
    languageLabelAnWenSollEN.setTEXT("To whom should the screen be transmitted?");

    LANGUAGE languageLabelAnWenSollES = new LANGUAGE();
    languageLabelAnWenSollES.setISO639(ISO639.ES);
    languageLabelAnWenSollES.setTEXT("¿A quién debe transmitirse la pantalla?");

    languagesLabelAnWenSoll.getLANGUAGE().add(languageLabelAnWenSollDE);
    languagesLabelAnWenSoll.getLANGUAGE().add(languageLabelAnWenSollEN);
    languagesLabelAnWenSoll.getLANGUAGE().add(languageLabelAnWenSollES);
    commandLabelAnWenSoll.setLANGUAGES(languagesLabelAnWenSoll);

    COMMAND commandLabelUebertragungsrateProSekunde = new COMMAND();
    commandLabelUebertragungsrateProSekunde.setKEY(KEY.LABEL_UEBERTRAGUNGSRATE);
    LANGUAGES languagesLabelUebertragungsrate = new LANGUAGES();
    LANGUAGE languageLabelUebertragungsrateDE = new LANGUAGE();
    languageLabelUebertragungsrateDE.setISO639(ISO639.DE);
    languageLabelUebertragungsrateDE.setTEXT("Die Übertragungsrate beträgt XXX FPS.");

    LANGUAGE languageLabelUebertragungsrateEN = new LANGUAGE();
    languageLabelUebertragungsrateEN.setISO639(ISO639.EN);
    languageLabelUebertragungsrateEN.setTEXT("The frame rate over the network is XXX FPS.");

    LANGUAGE languageLabelUebertragungsrateES = new LANGUAGE();
    languageLabelUebertragungsrateES.setISO639(ISO639.ES);
    languageLabelUebertragungsrateES.setTEXT("La tasa de fotogramas transmitida es de XXX FPS.");

    languagesLabelUebertragungsrate.getLANGUAGE().add(languageLabelUebertragungsrateDE);
    languagesLabelUebertragungsrate.getLANGUAGE().add(languageLabelUebertragungsrateEN);
    languagesLabelUebertragungsrate.getLANGUAGE().add(languageLabelUebertragungsrateES);

    commandLabelUebertragungsrateProSekunde.setLANGUAGES(languagesLabelUebertragungsrate);

    COMMAND commandLabelBildschirmdatenAufzeichnen = new COMMAND();
    commandLabelBildschirmdatenAufzeichnen.setKEY(KEY.LABEL_BILDSCHIRMDATEN_AUFZEICHNEN);
    LANGUAGES languagesLabelBildschirmdatenAufzeichnen = new LANGUAGES();

    LANGUAGE languageLabelBildschirmdatenDE = new LANGUAGE();
    languageLabelBildschirmdatenDE.setISO639(ISO639.DE);
    languageLabelBildschirmdatenDE
        .setTEXT("<html>Für das Aufzeichnen von Bildschirmdaten muss ein Service gestartet werden.</html>");

    LANGUAGE languageLabelBildschirmdatenEN = new LANGUAGE();
    languageLabelBildschirmdatenEN.setISO639(ISO639.EN);
    languageLabelBildschirmdatenEN
        .setTEXT("<html>A service must be started to record the screen data.</html>");

    LANGUAGE languageLabelBildschirmdatenES = new LANGUAGE();
    languageLabelBildschirmdatenES.setISO639(ISO639.ES);
    languageLabelBildschirmdatenES
        .setTEXT("<html>Debe iniciarse un servicio para registrar los datos de la pantalla.</html>");

    languagesLabelBildschirmdatenAufzeichnen.getLANGUAGE().add(languageLabelBildschirmdatenDE);
    languagesLabelBildschirmdatenAufzeichnen.getLANGUAGE().add(languageLabelBildschirmdatenEN);
    languagesLabelBildschirmdatenAufzeichnen.getLANGUAGE().add(languageLabelBildschirmdatenES);
    commandLabelBildschirmdatenAufzeichnen.setLANGUAGES(languagesLabelBildschirmdatenAufzeichnen);

    COMMAND commandLabelService = new COMMAND();
    commandLabelService.setKEY(KEY.LABEL_SERVICE);
    LANGUAGES languagesLabelService = new LANGUAGES();

    LANGUAGE languageLabelServiceDE = new LANGUAGE();
    languageLabelServiceDE.setISO639(ISO639.DE);
    languageLabelServiceDE.setTEXT("Serverstatus:");

    LANGUAGE languageLabelServiceEN = new LANGUAGE();
    languageLabelServiceEN.setISO639(ISO639.EN);
    languageLabelServiceEN.setTEXT("Server status:");

    LANGUAGE languageLabelServiceES = new LANGUAGE();
    languageLabelServiceES.setISO639(ISO639.ES);
    languageLabelServiceES.setTEXT("Estado del servicio:");

    languagesLabelService.getLANGUAGE().add(languageLabelServiceDE);
    languagesLabelService.getLANGUAGE().add(languageLabelServiceEN);
    languagesLabelService.getLANGUAGE().add(languageLabelServiceES);
    commandLabelService.setLANGUAGES(languagesLabelService);

    COMMAND commandLabelServerstatus = new COMMAND();
    commandLabelServerstatus.setKEY(KEY.LABEL_SERVERSTATUS);
    LANGUAGES languagesLabelServerstatus = new LANGUAGES();

    LANGUAGE languageLabelServerstatusDE = new LANGUAGE();
    languageLabelServerstatusDE.setISO639(ISO639.DE);
    languageLabelServerstatusDE.setTEXT("angehalten");

    LANGUAGE languageLabelServerstatusEN = new LANGUAGE();
    languageLabelServerstatusEN.setISO639(ISO639.EN);
    languageLabelServerstatusEN.setTEXT("stopped");

    LANGUAGE languageLabelServerstatusES = new LANGUAGE();
    languageLabelServerstatusES.setISO639(ISO639.ES);
    languageLabelServerstatusES.setTEXT("detenido");

    languagesLabelServerstatus.getLANGUAGE().add(languageLabelServerstatusDE);
    languagesLabelServerstatus.getLANGUAGE().add(languageLabelServerstatusEN);
    languagesLabelServerstatus.getLANGUAGE().add(languageLabelServerstatusES);

    commandLabelServerstatus.setLANGUAGES(languagesLabelServerstatus);

    COMMAND commandLabelTcpPort = new COMMAND();
    commandLabelTcpPort.setKEY(KEY.LABEL_ON_TCP_PORT);
    LANGUAGES languagesLabelTcpPort = new LANGUAGES();

    LANGUAGE languageLabelTcpPortDE = new LANGUAGE();
    languageLabelTcpPortDE.setISO639(ISO639.DE);
    languageLabelTcpPortDE.setTEXT("auf TCP-Port:");

    LANGUAGE languageLabelTcpPortEN = new LANGUAGE();
    languageLabelTcpPortEN.setISO639(ISO639.EN);
    languageLabelTcpPortEN.setTEXT("on TCP-Port:");

    LANGUAGE languageLabelTcpPortES = new LANGUAGE();
    languageLabelTcpPortES.setISO639(ISO639.ES);
    languageLabelTcpPortES.setTEXT("en el puerto TCP:");

    languagesLabelTcpPort.getLANGUAGE().add(languageLabelTcpPortDE);
    languagesLabelTcpPort.getLANGUAGE().add(languageLabelTcpPortEN);
    languagesLabelTcpPort.getLANGUAGE().add(languageLabelTcpPortES);
    commandLabelTcpPort.setLANGUAGES(languagesLabelTcpPort);

    COMMAND commandFrameTeilnehmer = new COMMAND();
    commandFrameTeilnehmer.setKEY(KEY.FRAME_EINWILLIGUNG);
    LANGUAGES languagesFrameTeilnehmer = new LANGUAGES();

    LANGUAGE languageFrameTeilnehmerDE = new LANGUAGE();
    languageFrameTeilnehmerDE.setISO639(ISO639.DE);
    languageFrameTeilnehmerDE.setTEXT("Einwilligung");

    LANGUAGE languageFrameTeilnehmerEN = new LANGUAGE();
    languageFrameTeilnehmerEN.setISO639(ISO639.EN);
    languageFrameTeilnehmerEN.setTEXT("Consent");

    LANGUAGE languageFrameTeilnehmerES = new LANGUAGE();
    languageFrameTeilnehmerES.setISO639(ISO639.ES);
    languageFrameTeilnehmerES.setTEXT("Consentimiento");

    languagesFrameTeilnehmer.getLANGUAGE().add(languageFrameTeilnehmerDE);
    languagesFrameTeilnehmer.getLANGUAGE().add(languageFrameTeilnehmerEN);
    languagesFrameTeilnehmer.getLANGUAGE().add(languageFrameTeilnehmerES);
    commandFrameTeilnehmer.setLANGUAGES(languagesFrameTeilnehmer);

    COMMAND commandLabelStatus = new COMMAND();
    commandLabelStatus.setKEY(KEY.LABEL_STATUS);
    LANGUAGES languagesLabelStatus = new LANGUAGES();

    LANGUAGE languageLabelStatusDE = new LANGUAGE();
    languageLabelStatusDE.setISO639(ISO639.DE);
    languageLabelStatusDE.setTEXT("Status");

    LANGUAGE languageLabelStatusEN = new LANGUAGE();
    languageLabelStatusEN.setISO639(ISO639.EN);
    languageLabelStatusEN.setTEXT("Status");

    LANGUAGE languageLabelStatusES = new LANGUAGE();
    languageLabelStatusES.setISO639(ISO639.ES);
    languageLabelStatusES.setTEXT("Estado");

    languagesLabelStatus.getLANGUAGE().add(languageLabelStatusDE);
    languagesLabelStatus.getLANGUAGE().add(languageLabelStatusEN);
    languagesLabelStatus.getLANGUAGE().add(languageLabelStatusES);
    commandLabelStatus.setLANGUAGES(languagesLabelStatus);

    COMMAND commandLabelOnline = new COMMAND();
    commandLabelOnline.setKEY(KEY.LABEL_ONLINE);
    LANGUAGES languagesLabelOnline = new LANGUAGES();

    LANGUAGE languageLabelOnlineDE = new LANGUAGE();
    languageLabelOnlineDE.setISO639(ISO639.DE);
    languageLabelOnlineDE.setTEXT("Online");

    LANGUAGE languageLabelOnlineEN = new LANGUAGE();
    languageLabelOnlineEN.setISO639(ISO639.EN);
    languageLabelOnlineEN.setTEXT("Online");

    LANGUAGE languageLabelOnlineES = new LANGUAGE();
    languageLabelOnlineES.setISO639(ISO639.ES);
    languageLabelOnlineES.setTEXT("En línea");

    languagesLabelOnline.getLANGUAGE().add(languageLabelOnlineDE);
    languagesLabelOnline.getLANGUAGE().add(languageLabelOnlineES);
    languagesLabelOnline.getLANGUAGE().add(languageLabelOnlineEN);
    commandLabelOnline.setLANGUAGES(languagesLabelOnline);

    COMMAND commandStringStatus = new COMMAND();
    commandStringStatus.setKEY(KEY.STRING_FIELD_STATUS);
    LANGUAGES languagesStringStatus = new LANGUAGES();

    LANGUAGE languageStringStatusDE = new LANGUAGE();
    languageStringStatusDE.setISO639(ISO639.DE);
    languageStringStatusDE.setTEXT("Du hast niemanden zum Chatten ausgewählt.");

    LANGUAGE languageStringStatusEN = new LANGUAGE();
    languageStringStatusEN.setISO639(ISO639.EN);
    languageStringStatusEN.setTEXT("You have not selected anyone to chat with.");

    LANGUAGE languageStringStatusES = new LANGUAGE();
    languageStringStatusES.setISO639(ISO639.ES);
    languageStringStatusES.setTEXT("No has seleccionado a ninguna persona para chatear.");

    languagesStringStatus.getLANGUAGE().add(languageStringStatusDE);
    languagesStringStatus.getLANGUAGE().add(languageStringStatusEN);
    languagesStringStatus.getLANGUAGE().add(languageStringStatusES);
    commandStringStatus.setLANGUAGES(languagesStringStatus);

    COMMAND commandButtonConfirm = new COMMAND();
    commandButtonConfirm.setKEY(KEY.BUTTON_CONFIRM);
    LANGUAGES languagesButtonCommit = new LANGUAGES();

    LANGUAGE languageButtonCoonfirmDE = new LANGUAGE();
    languageButtonCoonfirmDE.setISO639(ISO639.DE);
    languageButtonCoonfirmDE.setSHORTCUT(VIRTUALKEY.VK_B);
    languageButtonCoonfirmDE.setTEXT("Bestätigen");

    LANGUAGE languageButtonConfirmEN = new LANGUAGE();
    languageButtonConfirmEN.setISO639(ISO639.EN);
    languageButtonConfirmEN.setSHORTCUT(VIRTUALKEY.VK_O);
    languageButtonConfirmEN.setTEXT("Confirm");

    LANGUAGE languageButtonConfirmES = new LANGUAGE();
    languageButtonConfirmES.setISO639(ISO639.ES);
    languageButtonConfirmES.setSHORTCUT(VIRTUALKEY.VK_O);
    languageButtonConfirmES.setTEXT("Confirmar");

    languagesButtonCommit.getLANGUAGE().add(languageButtonCoonfirmDE);
    languagesButtonCommit.getLANGUAGE().add(languageButtonConfirmEN);
    languagesButtonCommit.getLANGUAGE().add(languageButtonConfirmES);
    commandButtonConfirm.setLANGUAGES(languagesButtonCommit);

    COMMAND commandButtonAbschicken = new COMMAND();
    commandButtonAbschicken.setKEY(KEY.BUTTON_ABSCHICKEN);
    LANGUAGES languagesButtonAbschicken = new LANGUAGES();

    LANGUAGE languageButtonAbschickenDE = new LANGUAGE();
    languageButtonAbschickenDE.setISO639(ISO639.DE);
    languageButtonAbschickenDE.setSHORTCUT(VIRTUALKEY.VK_A);
    languageButtonAbschickenDE.setTEXT("Abschicken");
    languageButtonAbschickenDE.setPathToImage("net/javacomm/multilingual/radio_wireless_tower_21x25.png");

    LANGUAGE languageButtonAbschickenEN = new LANGUAGE();
    languageButtonAbschickenEN.setISO639(ISO639.EN);
    languageButtonAbschickenEN.setSHORTCUT(VIRTUALKEY.VK_S);
    languageButtonAbschickenEN.setTEXT("Send");
    languageButtonAbschickenEN.setPathToImage("net/javacomm/multilingual/radio_wireless_tower_21x25.png");

    LANGUAGE languageButtonAbschickenES = new LANGUAGE();
    languageButtonAbschickenES.setISO639(ISO639.ES);
    languageButtonAbschickenES.setSHORTCUT(VIRTUALKEY.VK_E);
    languageButtonAbschickenES.setTEXT("Enviar");
    languageButtonAbschickenES.setPathToImage("net/javacomm/multilingual/radio_wireless_tower_21x25.png");

    languagesButtonAbschicken.getLANGUAGE().add(languageButtonAbschickenDE);
    languagesButtonAbschicken.getLANGUAGE().add(languageButtonAbschickenEN);
    languagesButtonAbschicken.getLANGUAGE().add(languageButtonAbschickenES);
    commandButtonAbschicken.setLANGUAGES(languagesButtonAbschicken);

    COMMAND commandButtonAnfang = new COMMAND();
    commandButtonAnfang.setKEY(KEY.BUTTON_ANFANG);
    LANGUAGES languagesButtonAnfang = new LANGUAGES();

    LANGUAGE languageButtonAnfangDE = new LANGUAGE();
    languageButtonAnfangDE.setISO639(ISO639.DE);
    languageButtonAnfangDE.setTEXT("Anfang");

    LANGUAGE languageButtonAnfangEN = new LANGUAGE();
    languageButtonAnfangEN.setISO639(ISO639.EN);
    languageButtonAnfangEN.setTEXT("Beginning");

    LANGUAGE languageButtonAnfangES = new LANGUAGE();
    languageButtonAnfangES.setISO639(ISO639.ES);
    languageButtonAnfangES.setTEXT("Inicio");

    languagesButtonAnfang.getLANGUAGE().add(languageButtonAnfangDE);
    languagesButtonAnfang.getLANGUAGE().add(languageButtonAnfangEN);
    languagesButtonAnfang.getLANGUAGE().add(languageButtonAnfangES);
    commandButtonAnfang.setLANGUAGES(languagesButtonAnfang);

    COMMAND commandButtonHoch = new COMMAND();
    commandButtonHoch.setKEY(KEY.BUTTON_HOCH);
    LANGUAGES languagesButtonHoch = new LANGUAGES();

    LANGUAGE languageButtonHochDE = new LANGUAGE();
    languageButtonHochDE.setISO639(ISO639.DE);
    languageButtonHochDE.setTEXT("Hoch");

    LANGUAGE languageButtonHochEN = new LANGUAGE();
    languageButtonHochEN.setISO639(ISO639.EN);
    languageButtonHochEN.setTEXT("Up");

    LANGUAGE languageButtonHochES = new LANGUAGE();
    languageButtonHochES.setISO639(ISO639.ES);
    languageButtonHochES.setTEXT("Arriba");

    languagesButtonHoch.getLANGUAGE().add(languageButtonHochDE);
    languagesButtonHoch.getLANGUAGE().add(languageButtonHochEN);
    languagesButtonHoch.getLANGUAGE().add(languageButtonHochES);
    commandButtonHoch.setLANGUAGES(languagesButtonHoch);

    COMMAND commandButtonEnde = new COMMAND();
    commandButtonEnde.setKEY(KEY.BUTTON_ENDE);
    LANGUAGES languagesButtonEnde = new LANGUAGES();

    LANGUAGE languageButtonEndeDE = new LANGUAGE();
    languageButtonEndeDE.setISO639(ISO639.DE);
    languageButtonEndeDE.setTEXT("Ende");

    LANGUAGE languageButtonEndeEN = new LANGUAGE();
    languageButtonEndeEN.setISO639(ISO639.EN);
    languageButtonEndeEN.setTEXT("End");

    LANGUAGE languageButtonEndeES = new LANGUAGE();
    languageButtonEndeES.setISO639(ISO639.ES);
    languageButtonEndeES.setTEXT("Final");

    languagesButtonEnde.getLANGUAGE().add(languageButtonEndeDE);
    languagesButtonEnde.getLANGUAGE().add(languageButtonEndeEN);
    languagesButtonEnde.getLANGUAGE().add(languageButtonEndeES);
    commandButtonEnde.setLANGUAGES(languagesButtonEnde);

    COMMAND commandButtonRunter = new COMMAND();
    commandButtonRunter.setKEY(KEY.BUTTON_RUNTER);
    LANGUAGES languagesButtonRunter = new LANGUAGES();

    LANGUAGE languageButtonRunterDE = new LANGUAGE();
    languageButtonRunterDE.setISO639(ISO639.DE);
    languageButtonRunterDE.setTEXT("Runter");

    LANGUAGE languageButtonRunterEN = new LANGUAGE();
    languageButtonRunterEN.setISO639(ISO639.EN);
    languageButtonRunterEN.setTEXT("Down");

    LANGUAGE languageButtonRunterES = new LANGUAGE();
    languageButtonRunterES.setISO639(ISO639.ES);
    languageButtonRunterES.setTEXT("Abajo");

    languagesButtonRunter.getLANGUAGE().add(languageButtonRunterDE);
    languagesButtonRunter.getLANGUAGE().add(languageButtonRunterEN);
    languagesButtonRunter.getLANGUAGE().add(languageButtonRunterES);
    commandButtonRunter.setLANGUAGES(languagesButtonRunter);

    COMMAND commandStringOnline = new COMMAND();
    commandStringOnline.setKEY(KEY.STRING_ONLINE);
    LANGUAGES languagesStringOnline = new LANGUAGES();

    LANGUAGE languageStringOnlineDE = new LANGUAGE();
    languageStringOnlineDE.setISO639(ISO639.DE);
    languageStringOnlineDE.setTEXT("Online");

    LANGUAGE languageStringOnlineEN = new LANGUAGE();
    languageStringOnlineEN.setISO639(ISO639.EN);
    languageStringOnlineEN.setTEXT("Online");

    LANGUAGE languageStringOnlineES = new LANGUAGE();
    languageStringOnlineES.setISO639(ISO639.ES);
    languageStringOnlineES.setTEXT("En línea");

    languagesStringOnline.getLANGUAGE().add(languageStringOnlineDE);
    languagesStringOnline.getLANGUAGE().add(languageStringOnlineEN);
    languagesStringOnline.getLANGUAGE().add(languageStringOnlineES);
    commandStringOnline.setLANGUAGES(languagesStringOnline);

    COMMAND commandStringRaum = new COMMAND();
    commandStringRaum.setKEY(KEY.STRING_RAUM);
    LANGUAGES languagesStringRaum = new LANGUAGES();

    LANGUAGE languageStringRaumDE = new LANGUAGE();
    languageStringRaumDE.setISO639(ISO639.DE);
    languageStringRaumDE.setTEXT("Raum");

    LANGUAGE languageStringRaumEN = new LANGUAGE();
    languageStringRaumEN.setISO639(ISO639.EN);
    languageStringRaumEN.setTEXT("Room");

    LANGUAGE languageStringRaumES = new LANGUAGE();
    languageStringRaumES.setISO639(ISO639.ES);
    languageStringRaumES.setTEXT("Sala");

    languagesStringRaum.getLANGUAGE().add(languageStringRaumDE);
    languagesStringRaum.getLANGUAGE().add(languageStringRaumEN);
    languagesStringRaum.getLANGUAGE().add(languageStringRaumES);
    commandStringRaum.setLANGUAGES(languagesStringRaum);

    COMMAND commandStringLebenszeit = new COMMAND();
    commandStringLebenszeit.setKEY(KEY.STRING_LEBENSZEIT);
    LANGUAGES languagesStringLebenszeit = new LANGUAGES();

    LANGUAGE languageStringLebenszeitDE = new LANGUAGE();
    languageStringLebenszeitDE.setISO639(ISO639.DE);
    languageStringLebenszeitDE.setTEXT("Lebensdauer");

    LANGUAGE languageStringLebenszeitEN = new LANGUAGE();
    languageStringLebenszeitEN.setISO639(ISO639.EN);
    languageStringLebenszeitEN.setTEXT("Life");

    LANGUAGE languageStringLebenszeitES = new LANGUAGE();
    languageStringLebenszeitES.setISO639(ISO639.ES);
    languageStringLebenszeitES.setTEXT("Vida");

    languagesStringLebenszeit.getLANGUAGE().add(languageStringLebenszeitDE);
    languagesStringLebenszeit.getLANGUAGE().add(languageStringLebenszeitEN);
    languagesStringLebenszeit.getLANGUAGE().add(languageStringLebenszeitES);
    commandStringLebenszeit.setLANGUAGES(languagesStringLebenszeit);

    COMMAND commandStringOrt = new COMMAND();
    commandStringOrt.setKEY(KEY.STRING_ORT);
    LANGUAGES languagesStringOrt = new LANGUAGES();

    LANGUAGE languageStringOrtDE = new LANGUAGE();
    languageStringOrtDE.setISO639(ISO639.DE);
    languageStringOrtDE.setTEXT("Ort");

    LANGUAGE languageStringOrtEN = new LANGUAGE();
    languageStringOrtEN.setISO639(ISO639.EN);
    languageStringOrtEN.setTEXT("Place");

    LANGUAGE languageStringOrtES = new LANGUAGE();
    languageStringOrtES.setISO639(ISO639.ES);
    languageStringOrtES.setTEXT("Lugar");

    languagesStringOrt.getLANGUAGE().add(languageStringOrtDE);
    languagesStringOrt.getLANGUAGE().add(languageStringOrtEN);
    languagesStringOrt.getLANGUAGE().add(languageStringOrtES);
    commandStringOrt.setLANGUAGES(languagesStringOrt);

    COMMAND commandStringEigentuemer = new COMMAND();
    commandStringEigentuemer.setKEY(KEY.STRING_EIGENTUEMER);
    LANGUAGES languagesStringEiegentuemer = new LANGUAGES();

    LANGUAGE languageStringEigentuemerDE = new LANGUAGE();
    languageStringEigentuemerDE.setISO639(ISO639.DE);
    languageStringEigentuemerDE.setTEXT("Besitzer");

    LANGUAGE languageStringEigentuemerEN = new LANGUAGE();
    languageStringEigentuemerEN.setISO639(ISO639.EN);
    languageStringEigentuemerEN.setTEXT("Owner");

    LANGUAGE languageStringEigentuemerES = new LANGUAGE();
    languageStringEigentuemerES.setISO639(ISO639.ES);
    languageStringEigentuemerES.setTEXT("Propietario");

    languagesStringEiegentuemer.getLANGUAGE().add(languageStringEigentuemerDE);
    languagesStringEiegentuemer.getLANGUAGE().add(languageStringEigentuemerEN);
    languagesStringEiegentuemer.getLANGUAGE().add(languageStringEigentuemerES);
    commandStringEigentuemer.setLANGUAGES(languagesStringEiegentuemer);

    COMMAND commandStringZutritt = new COMMAND();
    commandStringZutritt.setKEY(KEY.STRING_ZUTRITT);
    LANGUAGES languagesStringZutritt = new LANGUAGES();

    LANGUAGE languageStringZutrittDE = new LANGUAGE();
    languageStringZutrittDE.setISO639(ISO639.DE);
    languageStringZutrittDE.setTEXT("Zutritt");

    LANGUAGE languageStringZutrittEN = new LANGUAGE();
    languageStringZutrittEN.setISO639(ISO639.EN);
    languageStringZutrittEN.setTEXT("Access");

    LANGUAGE languageStringZutrittES = new LANGUAGE();
    languageStringZutrittES.setISO639(ISO639.ES);
    languageStringZutrittES.setTEXT("Acceso");

    languagesStringZutritt.getLANGUAGE().add(languageStringZutrittDE);
    languagesStringZutritt.getLANGUAGE().add(languageStringZutrittEN);
    languagesStringZutritt.getLANGUAGE().add(languageStringZutrittES);
    commandStringZutritt.setLANGUAGES(languagesStringZutritt);

    COMMAND commandButtonRaumErstellen = new COMMAND();
    commandButtonRaumErstellen.setKEY(KEY.BUTTON_RAUM_ERSTELLEN);
    LANGUAGES languagesButtonRaumErstellen = new LANGUAGES();

    LANGUAGE languageButtonRaumErstellenDE = new LANGUAGE();
    languageButtonRaumErstellenDE.setISO639(ISO639.DE);
    languageButtonRaumErstellenDE.setTEXT("Raum erstellen");

    LANGUAGE languageButtonRaumErstellenEN = new LANGUAGE();
    languageButtonRaumErstellenEN.setISO639(ISO639.EN);
    languageButtonRaumErstellenEN.setTEXT("Create room");

    LANGUAGE languageButtonRaumErstellenES = new LANGUAGE();
    languageButtonRaumErstellenES.setISO639(ISO639.ES);
    languageButtonRaumErstellenES.setTEXT("Crear sala");

    languagesButtonRaumErstellen.getLANGUAGE().add(languageButtonRaumErstellenDE);
    languagesButtonRaumErstellen.getLANGUAGE().add(languageButtonRaumErstellenEN);
    languagesButtonRaumErstellen.getLANGUAGE().add(languageButtonRaumErstellenES);
    commandButtonRaumErstellen.setLANGUAGES(languagesButtonRaumErstellen);

    COMMAND commandButtonRaumLoeschen = new COMMAND();
    commandButtonRaumLoeschen.setKEY(KEY.BUTTON_RAUM_LOESCHEN);
    LANGUAGES languagesButtonRaumLoeschen = new LANGUAGES();

    LANGUAGE languageButtonRaumLoeschenDE = new LANGUAGE();
    languageButtonRaumLoeschenDE.setISO639(ISO639.DE);
    languageButtonRaumLoeschenDE.setTEXT("Raum löschen");

    LANGUAGE languageButtonRaumLoeschenEN = new LANGUAGE();
    languageButtonRaumLoeschenEN.setISO639(ISO639.EN);
    languageButtonRaumLoeschenEN.setTEXT("Delete room");

    LANGUAGE languageButtonRaumLoeschenES = new LANGUAGE();
    languageButtonRaumLoeschenES.setISO639(ISO639.ES);
    languageButtonRaumLoeschenES.setTEXT("Eliminar sala");

    languagesButtonRaumLoeschen.getLANGUAGE().add(languageButtonRaumLoeschenDE);
    languagesButtonRaumLoeschen.getLANGUAGE().add(languageButtonRaumLoeschenEN);
    languagesButtonRaumLoeschen.getLANGUAGE().add(languageButtonRaumLoeschenES);
    commandButtonRaumLoeschen.setLANGUAGES(languagesButtonRaumLoeschen);

    COMMAND commandLabelBenutzer = new COMMAND();
    commandLabelBenutzer.setKEY(KEY.LABEL_BENUTZER);
    LANGUAGES languagesLabelBenutzer = new LANGUAGES();

    LANGUAGE languageLabelBenutzerDE = new LANGUAGE();
    languageLabelBenutzerDE.setISO639(ISO639.DE);
    languageLabelBenutzerDE.setTEXT("Benutzer");

    LANGUAGE languageLabelBenutzerEN = new LANGUAGE();
    languageLabelBenutzerEN.setISO639(ISO639.EN);
    languageLabelBenutzerEN.setTEXT("Users");

    LANGUAGE languageLabelBenutzerES = new LANGUAGE();
    languageLabelBenutzerES.setISO639(ISO639.ES);
    languageLabelBenutzerES.setTEXT("Usuarios");

    languagesLabelBenutzer.getLANGUAGE().add(languageLabelBenutzerDE);
    languagesLabelBenutzer.getLANGUAGE().add(languageLabelBenutzerEN);
    languagesLabelBenutzer.getLANGUAGE().add(languageLabelBenutzerES);
    commandLabelBenutzer.setLANGUAGES(languagesLabelBenutzer);

    COMMAND commandLabelMitglieder = new COMMAND();
    commandLabelMitglieder.setKEY(KEY.LABEL_MITGLIEDER);
    LANGUAGES languagesLabelMitglieder = new LANGUAGES();
    LANGUAGE languageLabelMitgliederDE = new LANGUAGE();
    languageLabelMitgliederDE.setISO639(ISO639.DE);
    languageLabelMitgliederDE.setTEXT("Teilnehmer");

    LANGUAGE languageLabelMitgliederEN = new LANGUAGE();
    languageLabelMitgliederEN.setISO639(ISO639.EN);
    languageLabelMitgliederEN.setTEXT("Participants");

    LANGUAGE languageLabelMitgliederES = new LANGUAGE();
    languageLabelMitgliederES.setISO639(ISO639.ES);
    languageLabelMitgliederES.setTEXT("Participantes");

    languagesLabelMitglieder.getLANGUAGE().add(languageLabelMitgliederDE);
    languagesLabelMitglieder.getLANGUAGE().add(languageLabelMitgliederEN);
    languagesLabelMitglieder.getLANGUAGE().add(languageLabelMitgliederES);
    commandLabelMitglieder.setLANGUAGES(languagesLabelMitglieder);

    COMMAND commandLabelMeineBesprechungsraeume = new COMMAND();
    commandLabelMeineBesprechungsraeume.setKEY(KEY.LABEL_MEINE_BESPRECHUNGSRAEUME);
    LANGUAGES languagesLabelMeineBesprechungsRaeume = new LANGUAGES();

    LANGUAGE languageLabelMeineBesprechungsraeumeDE = new LANGUAGE();
    languageLabelMeineBesprechungsraeumeDE.setISO639(ISO639.DE);
    languageLabelMeineBesprechungsraeumeDE.setTEXT("Besprechungsräume einrichten oder löschen");

    LANGUAGE languageLabelMeineBesprechungsraeumeEN = new LANGUAGE();
    languageLabelMeineBesprechungsraeumeEN.setISO639(ISO639.EN);
    languageLabelMeineBesprechungsraeumeEN.setTEXT("Create or delete meeting rooms");

    LANGUAGE languageLabelMeineBesprechungsraeumeES = new LANGUAGE();
    languageLabelMeineBesprechungsraeumeES.setISO639(ISO639.ES);
    languageLabelMeineBesprechungsraeumeES.setTEXT("Crear o eliminar salas de reuniones");

    languagesLabelMeineBesprechungsRaeume.getLANGUAGE().add(languageLabelMeineBesprechungsraeumeDE);
    languagesLabelMeineBesprechungsRaeume.getLANGUAGE().add(languageLabelMeineBesprechungsraeumeEN);
    languagesLabelMeineBesprechungsRaeume.getLANGUAGE().add(languageLabelMeineBesprechungsraeumeES);
    commandLabelMeineBesprechungsraeume.setLANGUAGES(languagesLabelMeineBesprechungsRaeume);

    COMMAND commandFrameBesprechungsraeume = new COMMAND();
    commandFrameBesprechungsraeume.setKEY(KEY.FRAME_BESPRECHUNGSRAEUME);
    LANGUAGES languagesFrameBesprechungsraeume = new LANGUAGES();

    LANGUAGE languageFrameBesprechungsraeumeDE = new LANGUAGE();
    languageFrameBesprechungsraeumeDE.setISO639(ISO639.DE);
    languageFrameBesprechungsraeumeDE.setTEXT("Besprechungsräume verwalten");

    LANGUAGE languageFrameBesprechungsraeumeEN = new LANGUAGE();
    languageFrameBesprechungsraeumeEN.setISO639(ISO639.EN);
    languageFrameBesprechungsraeumeEN.setTEXT("Manage meeting rooms");

    LANGUAGE languageFrameBesprechungsraeumeES = new LANGUAGE();
    languageFrameBesprechungsraeumeES.setISO639(ISO639.ES);
    languageFrameBesprechungsraeumeES.setTEXT("Gestionar las Salas de Reuniones");

    languagesFrameBesprechungsraeume.getLANGUAGE().add(languageFrameBesprechungsraeumeDE);
    languagesFrameBesprechungsraeume.getLANGUAGE().add(languageFrameBesprechungsraeumeEN);
    languagesFrameBesprechungsraeume.getLANGUAGE().add(languageFrameBesprechungsraeumeES);
    commandFrameBesprechungsraeume.setLANGUAGES(languagesFrameBesprechungsraeume);

    COMMAND commandLabelWerEinen = new COMMAND();
    commandLabelWerEinen.setKEY(KEY.LABEL_WER_EINEN);
    LANGUAGES languagesLabelWerEinen = new LANGUAGES();
    LANGUAGE languageLabelWerEinenDE = new LANGUAGE();
    languageLabelWerEinenDE.setISO639(ISO639.DE);
    languageLabelWerEinenDE.setTEXT(
        "Wer einen Besprechnugsraum einrichtet, entscheidet wer ihn betreten darf und wer nicht. "
            + "Über Besprechnusgräume können Dateien hochgeladen und abgerufen werden. "
            + "Nur der Eigentümer kann den Raum löschen."
    );

    LANGUAGE languageLabelWerEinenEN = new LANGUAGE();
    languageLabelWerEinenEN.setISO639(ISO639.EN);
    languageLabelWerEinenEN.setTEXT(
        "Whoever sets up a meeting room decides who can and cannot enter it. "
            + "Files can be uploaded and retrieved via meeting rooms. "
            + "Only the owner can delete the room."
    );

    LANGUAGE languageLabelWerEinenES = new LANGUAGE();
    languageLabelWerEinenES.setISO639(ISO639.ES);
    languageLabelWerEinenES.setTEXT(
        "El que monta una sala de reuniones decide quién puede entrar en ella y quién no. "
            + "Se pueden cargar archivos y acceder a ellos a través de las salas de reuniones. "
            + "Sólo el propietario puede eliminar la sala."
    );

    languagesLabelWerEinen.getLANGUAGE().add(languageLabelWerEinenDE);
    languagesLabelWerEinen.getLANGUAGE().add(languageLabelWerEinenEN);
    languagesLabelWerEinen.getLANGUAGE().add(languageLabelWerEinenES);
    commandLabelWerEinen.setLANGUAGES(languagesLabelWerEinen);

    COMMAND commandLabelRoboter = new COMMAND();
    commandLabelRoboter.setKEY(KEY.LABEL_ROBOTER);
    LANGUAGES languagesLabelRoboter = new LANGUAGES();

    LANGUAGE languageLabelRoboterDE = new LANGUAGE();
    languageLabelRoboterDE.setISO639(ISO639.DE);
    languageLabelRoboterDE.setTEXT(
        "<html>" + "<p>"
            + "Hört sich die Sprache für dein Gegenüber roboterhaft an, verringere die Abtastrate!"
            + "</p>"
            + "</html>"
    );

    LANGUAGE languageLabelRoboterEN = new LANGUAGE();
    languageLabelRoboterEN.setISO639(ISO639.EN);
    languageLabelRoboterEN.setTEXT(
        "<html><p>If the speech sounds distorted to your counterpart, reduce the sampling rate!</p></html>"
    );

    LANGUAGE languageLabelRoboterES = new LANGUAGE();
    languageLabelRoboterES.setISO639(ISO639.ES);
    languageLabelRoboterES.setTEXT(
        "<html><p>¡Si el discurso suena distorsionado para tu interlocutor, reduce la frecuencia de muestreo!</p></html>"
    );

    languagesLabelRoboter.getLANGUAGE().add(languageLabelRoboterDE);
    languagesLabelRoboter.getLANGUAGE().add(languageLabelRoboterEN);
    languagesLabelRoboter.getLANGUAGE().add(languageLabelRoboterES);
    commandLabelRoboter.setLANGUAGES(languagesLabelRoboter);

    COMMAND commandLabelDerLautsprecher = new COMMAND();
    commandLabelDerLautsprecher.setKEY(KEY.LABEL_LAUTSPRECHEREMPFANG);
    LANGUAGES languagesLabelLautsprecherEmpfang = new LANGUAGES();

    LANGUAGE languageLabelLautsprecherEmpfangDE = new LANGUAGE();
    languageLabelLautsprecherEmpfangDE.setISO639(ISO639.DE);
    languageLabelLautsprecherEmpfangDE.setTEXT(
        "<html>" + "<p>"
            + "Der Lautsprecher wird beim Empfänger auf <b>XXX</b> Hz Stereo eingestellt."
            + "<br>"
            + "Die Abtastraten sind Sollwerte, die von der verbauten Hardware übersteuert<br>"
            + " werden könnten."
            + "</p>"
            + "</html>"
    );

    LANGUAGE languageLabelLautsprecherEmpfangEN = new LANGUAGE();
    languageLabelLautsprecherEmpfangEN.setISO639(ISO639.EN);
    languageLabelLautsprecherEmpfangEN.setTEXT(
        "<html>" + "<p>"
            + "The speaker is set to <b>XXX</b> Hz stereo at the receiver."
            + "<br>"
            + "The sampling rates are set values that could be overridden by the installed<br>"
            + "hardware."
            + "</p>"
            + "</html>"
    );

    LANGUAGE languageLabelLautsprecherEmpfangES = new LANGUAGE();
    languageLabelLautsprecherEmpfangES.setISO639(ISO639.ES);
    languageLabelLautsprecherEmpfangES.setTEXT(
        "<html><p>" + "El altavoz está ajustado a <b>XXX</b> Hz estéreo en el receptor."
            + "<br>"
            + "Las frecuencias de muestreo son valores establecidos que pueden ser<br>"
            + "anulados por el hardware instalado."
            + "</p>"
            + "</html>"
    );

    languagesLabelLautsprecherEmpfang.getLANGUAGE().add(languageLabelLautsprecherEmpfangDE);
    languagesLabelLautsprecherEmpfang.getLANGUAGE().add(languageLabelLautsprecherEmpfangEN);
    languagesLabelLautsprecherEmpfang.getLANGUAGE().add(languageLabelLautsprecherEmpfangES);
    commandLabelDerLautsprecher.setLANGUAGES(languagesLabelLautsprecherEmpfang);

    COMMAND commandFrameTelefonEinrichten = new COMMAND();
    commandFrameTelefonEinrichten.setKEY(KEY.FRAME_TELEFON_EINRICHTEN);
    LANGUAGES languagesFrameTelefonEinrichten = new LANGUAGES();

    LANGUAGE languageFrameTelefonEinrichtenDE = new LANGUAGE();
    languageFrameTelefonEinrichtenDE.setISO639(ISO639.DE);
    languageFrameTelefonEinrichtenDE.setTEXT("Telefonie einrichten");

    LANGUAGE languageFrameTelefonEinrichtenEN = new LANGUAGE();
    languageFrameTelefonEinrichtenEN.setISO639(ISO639.EN);
    languageFrameTelefonEinrichtenEN.setTEXT("Telephony Settings");

    LANGUAGE languageFrameTelefonEinrichtenES = new LANGUAGE();
    languageFrameTelefonEinrichtenES.setISO639(ISO639.ES);
    languageFrameTelefonEinrichtenES.setTEXT("Ajustes de telefonía");

    languagesFrameTelefonEinrichten.getLANGUAGE().add(languageFrameTelefonEinrichtenDE);
    languagesFrameTelefonEinrichten.getLANGUAGE().add(languageFrameTelefonEinrichtenEN);
    languagesFrameTelefonEinrichten.getLANGUAGE().add(languageFrameTelefonEinrichtenES);
    commandFrameTelefonEinrichten.setLANGUAGES(languagesFrameTelefonEinrichten);

    COMMAND commandFrameSchwarzeListe = new COMMAND();
    commandFrameSchwarzeListe.setKEY(KEY.FRAME_SCHWARZE_LISTE);
    LANGUAGES languagesFrameSchwarzeListe = new LANGUAGES();

    LANGUAGE languageFrameSchwarzeListeDE = new LANGUAGE();
    languageFrameSchwarzeListeDE.setISO639(ISO639.DE);
    languageFrameSchwarzeListeDE.setTEXT("Schwarze Liste");

    LANGUAGE languageFrameSchwarzeListeEN = new LANGUAGE();
    languageFrameSchwarzeListeEN.setISO639(ISO639.EN);
    languageFrameSchwarzeListeEN.setTEXT("Blacklist");

    LANGUAGE languageFrameSchwarzeListeES = new LANGUAGE();
    languageFrameSchwarzeListeES.setISO639(ISO639.ES);
    languageFrameSchwarzeListeES.setTEXT("Lista negra");

    languagesFrameSchwarzeListe.getLANGUAGE().add(languageFrameSchwarzeListeDE);
    languagesFrameSchwarzeListe.getLANGUAGE().add(languageFrameSchwarzeListeEN);
    languagesFrameSchwarzeListe.getLANGUAGE().add(languageFrameSchwarzeListeES);
    commandFrameSchwarzeListe.setLANGUAGES(languagesFrameSchwarzeListe);

    COMMAND commandFrameProjektor = new COMMAND();
    commandFrameProjektor.setKEY(KEY.FRAME_PROJEKTOR);
    LANGUAGES languagesFrameProjektor = new LANGUAGES();
    LANGUAGE languageFrameProjektorDE = new LANGUAGE();
    languageFrameProjektorDE.setISO639(ISO639.DE);
    languageFrameProjektorDE.setTEXT("Projektor");

    LANGUAGE languageFrameProjektorEN = new LANGUAGE();
    languageFrameProjektorEN.setISO639(ISO639.EN);
    languageFrameProjektorEN.setTEXT("Projector");

    LANGUAGE languageFrameProjektorES = new LANGUAGE();
    languageFrameProjektorES.setISO639(ISO639.ES);
    languageFrameProjektorES.setTEXT("Proyector");

    languagesFrameProjektor.getLANGUAGE().add(languageFrameProjektorDE);
    languagesFrameProjektor.getLANGUAGE().add(languageFrameProjektorEN);
    languagesFrameProjektor.getLANGUAGE().add(languageFrameProjektorES);
    commandFrameProjektor.setLANGUAGES(languagesFrameProjektor);

    COMMAND commandStringBeschreibung = new COMMAND();
    commandStringBeschreibung.setKEY(KEY.STRING_BESCHREIBUNG);
    LANGUAGES languagesStringBeschreibung = new LANGUAGES();

    LANGUAGE languageStringBeschreibungDE = new LANGUAGE();
    languageStringBeschreibungDE.setISO639(ISO639.DE);
    languageStringBeschreibungDE.setTEXT("Beschreibung");

    LANGUAGE languageStringBeschreibungEN = new LANGUAGE();
    languageStringBeschreibungEN.setISO639(ISO639.EN);
    languageStringBeschreibungEN.setTEXT("Description");

    LANGUAGE languageStringBeschreibungES = new LANGUAGE();
    languageStringBeschreibungES.setISO639(ISO639.ES);
    languageStringBeschreibungES.setTEXT("Descripción");

    languagesStringBeschreibung.getLANGUAGE().add(languageStringBeschreibungDE);
    languagesStringBeschreibung.getLANGUAGE().add(languageStringBeschreibungEN);
    languagesStringBeschreibung.getLANGUAGE().add(languageStringBeschreibungES);
    commandStringBeschreibung.setLANGUAGES(languagesStringBeschreibung);

    COMMAND commandStringGesperrt = new COMMAND();
    commandStringGesperrt.setKEY(KEY.STRING_GESPERRT);
    LANGUAGES languagesStringGesperrt = new LANGUAGES();

    LANGUAGE languageGesperrtDE = new LANGUAGE();
    languageGesperrtDE.setISO639(ISO639.DE);
    languageGesperrtDE.setTEXT("Gesperrt");

    LANGUAGE languageGesperrtEN = new LANGUAGE();
    languageGesperrtEN.setISO639(ISO639.EN);
    languageGesperrtEN.setTEXT("Denied");

    LANGUAGE languageGesperrtES = new LANGUAGE();
    languageGesperrtES.setISO639(ISO639.ES);
    languageGesperrtES.setTEXT("Denegado");

    languagesStringGesperrt.getLANGUAGE().add(languageGesperrtDE);
    languagesStringGesperrt.getLANGUAGE().add(languageGesperrtEN);
    languagesStringGesperrt.getLANGUAGE().add(languageGesperrtES);
    commandStringGesperrt.setLANGUAGES(languagesStringGesperrt);

    COMMAND commandStringSuffix = new COMMAND();
    commandStringSuffix.setKEY(KEY.STRING_SUFFIX);
    LANGUAGES languagesStringSuffix = new LANGUAGES();

    LANGUAGE languageStringSuffixDE = new LANGUAGE();
    languageStringSuffixDE.setISO639(ISO639.DE);
    languageStringSuffixDE.setTEXT("Suffix");

    LANGUAGE languageStringSuffixEN = new LANGUAGE();
    languageStringSuffixEN.setISO639(ISO639.EN);
    languageStringSuffixEN.setTEXT("Suffix");

    LANGUAGE languageStringSuffixES = new LANGUAGE();
    languageStringSuffixES.setISO639(ISO639.ES);
    languageStringSuffixES.setTEXT("Sufijo");

    languagesStringSuffix.getLANGUAGE().add(languageStringSuffixDE);
    languagesStringSuffix.getLANGUAGE().add(languageStringSuffixEN);
    languagesStringSuffix.getLANGUAGE().add(languageStringSuffixES);
    commandStringSuffix.setLANGUAGES(languagesStringSuffix);

    COMMAND commandLabelRaeume = new COMMAND();
    commandLabelRaeume.setKEY(KEY.LABEL_RAEUME);
    LANGUAGES languagesLabelRaeume = new LANGUAGES();

    LANGUAGE languageLabelRaeumeDE = new LANGUAGE();
    languageLabelRaeumeDE.setISO639(ISO639.DE);
    languageLabelRaeumeDE.setTEXT("Raum");

    LANGUAGE languageLabelRaeumeEN = new LANGUAGE();
    languageLabelRaeumeEN.setISO639(ISO639.EN);
    languageLabelRaeumeEN.setTEXT("Room");

    LANGUAGE languageLabelRaeumeES = new LANGUAGE();
    languageLabelRaeumeES.setISO639(ISO639.ES);
    languageLabelRaeumeES.setTEXT("Sala");

    languagesLabelRaeume.getLANGUAGE().add(languageLabelRaeumeDE);
    languagesLabelRaeume.getLANGUAGE().add(languageLabelRaeumeEN);
    languagesLabelRaeume.getLANGUAGE().add(languageLabelRaeumeES);
    commandLabelRaeume.setLANGUAGES(languagesLabelRaeume);

    COMMAND commandLabelZutritt = new COMMAND();
    commandLabelZutritt.setKEY(KEY.LABEL_ZUTRITT);
    LANGUAGES languagesLabelZutritt = new LANGUAGES();
    LANGUAGE languageLabeZutrittDE = new LANGUAGE();
    languageLabeZutrittDE.setISO639(ISO639.DE);
    languageLabeZutrittDE.setTEXT("Zutritt");

    LANGUAGE languageLabeZutrittEN = new LANGUAGE();
    languageLabeZutrittEN.setISO639(ISO639.EN);
    languageLabeZutrittEN.setTEXT("Access");

    LANGUAGE languageLabeZutrittES = new LANGUAGE();
    languageLabeZutrittES.setISO639(ISO639.ES);
    languageLabeZutrittES.setTEXT("Acceso");

    languagesLabelZutritt.getLANGUAGE().add(languageLabeZutrittDE);
    languagesLabelZutritt.getLANGUAGE().add(languageLabeZutrittEN);
    languagesLabelZutritt.getLANGUAGE().add(languageLabeZutrittES);
    commandLabelZutritt.setLANGUAGES(languagesLabelZutritt);

    COMMAND commandRadioButtonProtected = new COMMAND();
    commandRadioButtonProtected.setKEY(KEY.RADIO_BUTTON_PROTECTED);
    LANGUAGES languagesRadioButtonProtected = new LANGUAGES();

    LANGUAGE languageRadioButtonProtectedDE = new LANGUAGE();
    languageRadioButtonProtectedDE.setISO639(ISO639.DE);
    languageRadioButtonProtectedDE.setTEXT(
        "<html>" + "privat - Du kannst einen neuen Raum einrichten, den nur Freunde betreten dürfen. "
            + "Deine Freunde dürfen ihrerseits Freunde in diesen Raum einladen."
            + "</html>"
    );

    LANGUAGE languageRadioButtonProtectedEN = new LANGUAGE();
    languageRadioButtonProtectedEN.setISO639(ISO639.EN);
    languageRadioButtonProtectedEN.setTEXT(
        "<html>" + "private - You can create a new room that only your friends can enter. "
            + "Your friends can invite their friends to this room.</html>"
    );

    LANGUAGE languageRadioButtonProtectedES = new LANGUAGE();
    languageRadioButtonProtectedES.setISO639(ISO639.ES);
    languageRadioButtonProtectedES.setTEXT(
        "<html>" + "privado - Puedes crear una sala nueva a la que sólo puedan entrar tus amigos. "
            + "Tus amigos pueden invitar a sus amigos a esta sala."
            + "</html>"
    );

    languagesRadioButtonProtected.getLANGUAGE().add(languageRadioButtonProtectedDE);
    languagesRadioButtonProtected.getLANGUAGE().add(languageRadioButtonProtectedEN);
    languagesRadioButtonProtected.getLANGUAGE().add(languageRadioButtonProtectedES);
    commandRadioButtonProtected.setLANGUAGES(languagesRadioButtonProtected);

    COMMAND commandRadioButtonPublic = new COMMAND();
    commandRadioButtonPublic.setKEY(KEY.RADIO_BUTTON_PUBLIC);
    LANGUAGES languagesRadioButtonPublic = new LANGUAGES();

    LANGUAGE languageRadioButtonPublicDE = new LANGUAGE();
    languageRadioButtonPublicDE.setISO639(ISO639.DE);
    languageRadioButtonPublicDE.setTEXT(
        "<html>öffentlich - Du kannst einen neuen Raum einrichten, den jeder betreten darf. "
            + "Der Raum wird nach XXX Minuten in ein Forum umgewandelt, "
            + "wenn noch mindestens 1 Person im Raum sitzt.</html>"
    );

    LANGUAGE languageRadioButtonPublicEN = new LANGUAGE();
    languageRadioButtonPublicEN.setISO639(ISO639.EN);
    languageRadioButtonPublicEN.setTEXT(
        "<html>public - You can set up a new room that anyone can enter. "
            + "The room will turn into a forum after XXX minutes if there is still at least 1 person in the room.</html>"
    );

    LANGUAGE languageRadioButtonPublicES = new LANGUAGE();
    languageRadioButtonPublicES.setISO639(ISO639.ES);
    languageRadioButtonPublicES.setTEXT(
        "<html>" + "público - Puedes crear una sala nueva en la que pueda entrar cualquiera. "
            + "La sala se convierte en un foro después de XXX minutos si todavía hay al menos 1 persona en la sala."
            + "</html>"
    );

    languagesRadioButtonPublic.getLANGUAGE().add(languageRadioButtonPublicDE);
    languagesRadioButtonPublic.getLANGUAGE().add(languageRadioButtonPublicEN);
    languagesRadioButtonPublic.getLANGUAGE().add(languageRadioButtonPublicES);

    commandRadioButtonPublic.setLANGUAGES(languagesRadioButtonPublic);

    COMMAND commandLabelLicht = new COMMAND();
    commandLabelLicht.setKEY(KEY.LABEL_LICHT);
    LANGUAGES languagesLabelLicht = new LANGUAGES();

    LANGUAGE languageLabelLichtDE = new LANGUAGE();
    languageLabelLichtDE.setISO639(ISO639.DE);
    languageLabelLichtDE.setTEXT(
        "Ein Pausenraum ist auf XXX Minuten begrenzt. Danach wird er in ein Forum umgewandelt. "
            + "Verlassen alle Personen vor XXX Minuten den Pausenraum, wird er sofort gelöscht."
    );

    LANGUAGE languageLabelLichtEN = new LANGUAGE();
    languageLabelLichtEN.setISO639(ISO639.EN);
    languageLabelLichtEN.setTEXT(
        "A break room is limited to XXX minutes. After that, it is converted into a forum. "
            + "If all people leave the break room before XXX minutes, it will be deleted immediately."
    );

    LANGUAGE languageLabelLichtES = new LANGUAGE();
    languageLabelLichtES.setISO639(ISO639.ES);
    languageLabelLichtES.setTEXT(
        "La sala de descanso está limitada a XXX minutos. Después, se convierte en un foro. "
            + "Si todo el mundo abandona la sala de descanso antes de XXX minutos, se borra inmediatamente."
    );

    languagesLabelLicht.getLANGUAGE().add(languageLabelLichtDE);
    languagesLabelLicht.getLANGUAGE().add(languageLabelLichtEN);
    languagesLabelLicht.getLANGUAGE().add(languageLabelLichtES);
    commandLabelLicht.setLANGUAGES(languagesLabelLicht);

    COMMAND commandFramePausenraum = new COMMAND();
    commandFramePausenraum.setKEY(KEY.FRAME_PAUSENRAUM);
    LANGUAGES languagesFramePausenraum = new LANGUAGES();

    LANGUAGE languageFramePausenraumDE = new LANGUAGE();
    languageFramePausenraumDE.setISO639(ISO639.DE);
    languageFramePausenraumDE.setTEXT("Pausenraum einrichten");

    LANGUAGE languageFramePausenraumEN = new LANGUAGE();
    languageFramePausenraumEN.setISO639(ISO639.EN);
    languageFramePausenraumEN.setTEXT("Create break room");

    LANGUAGE languageFramePausenraumES = new LANGUAGE();
    languageFramePausenraumES.setISO639(ISO639.ES);
    languageFramePausenraumES.setTEXT("Crear sala de descanso");

    languagesFramePausenraum.getLANGUAGE().add(languageFramePausenraumDE);
    languagesFramePausenraum.getLANGUAGE().add(languageFramePausenraumEN);
    languagesFramePausenraum.getLANGUAGE().add(languageFramePausenraumES);
    commandFramePausenraum.setLANGUAGES(languagesFramePausenraum);

    COMMAND commandLabelFreunde = new COMMAND();
    commandLabelFreunde.setKEY(KEY.LABEL_FREUNDE);
    LANGUAGES languagesLabelFreunde = new LANGUAGES();

    LANGUAGE languageLabelFreundeDE = new LANGUAGE();
    languageLabelFreundeDE.setISO639(ISO639.DE);
    languageLabelFreundeDE.setTEXT("Freunde");

    LANGUAGE languageLabelFreundeEN = new LANGUAGE();
    languageLabelFreundeEN.setISO639(ISO639.EN);
    languageLabelFreundeEN.setTEXT("Friends");

    LANGUAGE languageLabelFreundeES = new LANGUAGE();
    languageLabelFreundeES.setISO639(ISO639.ES);
    languageLabelFreundeES.setTEXT("Amigos");

    languagesLabelFreunde.getLANGUAGE().add(languageLabelFreundeDE);
    languagesLabelFreunde.getLANGUAGE().add(languageLabelFreundeEN);
    languagesLabelFreunde.getLANGUAGE().add(languageLabelFreundeES);
    commandLabelFreunde.setLANGUAGES(languagesLabelFreunde);

    COMMAND commandStringDatei = new COMMAND();
    commandStringDatei.setKEY(KEY.STRING_DATEI);
    LANGUAGES languagesStringDatei = new LANGUAGES();
    LANGUAGE languageStringDateiDE = new LANGUAGE();
    languageStringDateiDE.setISO639(ISO639.DE);
    languageStringDateiDE.setTEXT("Datei");

    LANGUAGE languageStringDateiEN = new LANGUAGE();
    languageStringDateiEN.setISO639(ISO639.EN);
    languageStringDateiEN.setTEXT("File");

    LANGUAGE languageStringDateiES = new LANGUAGE();
    languageStringDateiES.setISO639(ISO639.ES);
    languageStringDateiES.setTEXT("Archivo");

    languagesStringDatei.getLANGUAGE().add(languageStringDateiDE);
    languagesStringDatei.getLANGUAGE().add(languageStringDateiEN);
    languagesStringDatei.getLANGUAGE().add(languageStringDateiES);
    commandStringDatei.setLANGUAGES(languagesStringDatei);

    COMMAND commandStringWurdeAbgebrochen = new COMMAND();
    commandStringWurdeAbgebrochen.setKEY(KEY.STRING_WURDE_ABGEBROCHEN);
    LANGUAGES languagesStringWurdeAbgebrochen = new LANGUAGES();

    LANGUAGE languagesStringWurdeAbgebrochenDE = new LANGUAGE();
    languagesStringWurdeAbgebrochenDE.setISO639(ISO639.DE);
    languagesStringWurdeAbgebrochenDE.setTEXT("Dei Dateiübertragung wurde abgebrochen.");

    LANGUAGE languagesStringWurdeAbgebrochenEN = new LANGUAGE();
    languagesStringWurdeAbgebrochenEN.setISO639(ISO639.EN);
    languagesStringWurdeAbgebrochenEN.setTEXT("The file transfer was canceled.");

    LANGUAGE languagesStringWurdeAbgebrochenES = new LANGUAGE();
    languagesStringWurdeAbgebrochenES.setISO639(ISO639.ES);
    languagesStringWurdeAbgebrochenES.setTEXT("La transferencia de archivos fue cancelado.");

    languagesStringWurdeAbgebrochen.getLANGUAGE().add(languagesStringWurdeAbgebrochenDE);
    languagesStringWurdeAbgebrochen.getLANGUAGE().add(languagesStringWurdeAbgebrochenEN);
    languagesStringWurdeAbgebrochen.getLANGUAGE().add(languagesStringWurdeAbgebrochenES);
    commandStringWurdeAbgebrochen.setLANGUAGES(languagesStringWurdeAbgebrochen);

    COMMAND commandStringWurdeErfolgreich = new COMMAND();
    commandStringWurdeErfolgreich.setKEY(KEY.STRING_WURDE_ERFOLGREICH);
    LANGUAGES languagesStringWurdeErfolgreich = new LANGUAGES();

    LANGUAGE languagesStringWurdeErfolgreichDE = new LANGUAGE();
    languagesStringWurdeErfolgreichDE.setISO639(ISO639.DE);
    languagesStringWurdeErfolgreichDE.setTEXT("Die Übertragung wurde erfolgreich abgeschlossen.");

    LANGUAGE languagesStringWurdeErfolgreichEN = new LANGUAGE();
    languagesStringWurdeErfolgreichEN.setISO639(ISO639.EN);
    languagesStringWurdeErfolgreichEN.setTEXT("The transfer was completed successfully.");

    LANGUAGE languagesStringWurdeErfolgreichES = new LANGUAGE();
    languagesStringWurdeErfolgreichES.setISO639(ISO639.ES);
    languagesStringWurdeErfolgreichES.setTEXT("La transferencia de archivos se ha completado con éxito.");

    languagesStringWurdeErfolgreich.getLANGUAGE().add(languagesStringWurdeErfolgreichDE);
    languagesStringWurdeErfolgreich.getLANGUAGE().add(languagesStringWurdeErfolgreichEN);
    languagesStringWurdeErfolgreich.getLANGUAGE().add(languagesStringWurdeErfolgreichES);
    commandStringWurdeErfolgreich.setLANGUAGES(languagesStringWurdeErfolgreich);

    COMMAND commandLabelVeralteteProgrammversion = new COMMAND();
    commandLabelVeralteteProgrammversion.setKEY(KEY.LABEL_VERALTETE_PROGRAMMVERSION);
    LANGUAGES languagesLabelVeralteteProgrammversion = new LANGUAGES();
    LANGUAGE languagesLabelVeralteteProgrammversionDE = new LANGUAGE();
    languagesLabelVeralteteProgrammversionDE.setISO639(ISO639.DE);
    languagesLabelVeralteteProgrammversionDE.setTEXT(
        "<html>Deine Programmversion <b>XXX</b> ist nicht mehr aktuell. "
            + "Der Funktionsumfang<br>ist geringer und es könnten nicht korrigierte Fehler enthalten sein.</html>"
    );

    LANGUAGE languagesLabelVeralteteProgrammversionEN = new LANGUAGE();
    languagesLabelVeralteteProgrammversionEN.setISO639(ISO639.EN);
    languagesLabelVeralteteProgrammversionEN.setTEXT(
        "<html>Your program version <b>XXX</b> is out of date.<br>"
            + "The functionality is less and it may contain uncorrected errors.</html>"
    );

    LANGUAGE languagesLabelVeralteteProgrammversionES = new LANGUAGE();
    languagesLabelVeralteteProgrammversionES.setISO639(ISO639.ES);
    languagesLabelVeralteteProgrammversionES.setTEXT(
        "<html>La versión <b>XXX</b> de tu programa ya no está actualizada.<br> "
            + "La gama de funciones es menor y puede contener errores no corregidos.</html>"
    );

    languagesLabelVeralteteProgrammversion.getLANGUAGE().add(languagesLabelVeralteteProgrammversionDE);
    languagesLabelVeralteteProgrammversion.getLANGUAGE().add(languagesLabelVeralteteProgrammversionEN);
    languagesLabelVeralteteProgrammversion.getLANGUAGE().add(languagesLabelVeralteteProgrammversionES);
    commandLabelVeralteteProgrammversion.setLANGUAGES(languagesLabelVeralteteProgrammversion);

    COMMAND commandStringVersionsPruefung = new COMMAND();
    commandStringVersionsPruefung.setKEY(KEY.STRING_VERSIONSPRUEFUNG);
    LANGUAGES languagesStringVersionsPruefung = new LANGUAGES();

    LANGUAGE languagesLabelVersionsPruefungDE = new LANGUAGE();
    languagesLabelVersionsPruefungDE.setISO639(ISO639.DE);
    languagesLabelVersionsPruefungDE.setTEXT("Versionsprüfung");

    LANGUAGE languagesLabelVersionsPruefungEN = new LANGUAGE();
    languagesLabelVersionsPruefungEN.setISO639(ISO639.EN);
    languagesLabelVersionsPruefungEN.setTEXT("Version check");

    LANGUAGE languagesLabelVersionsPruefungES = new LANGUAGE();
    languagesLabelVersionsPruefungES.setISO639(ISO639.ES);
    languagesLabelVersionsPruefungES.setTEXT("Comprobación de la versión");

    languagesStringVersionsPruefung.getLANGUAGE().add(languagesLabelVersionsPruefungDE);
    languagesStringVersionsPruefung.getLANGUAGE().add(languagesLabelVersionsPruefungEN);
    languagesStringVersionsPruefung.getLANGUAGE().add(languagesLabelVersionsPruefungES);
    commandStringVersionsPruefung.setLANGUAGES(languagesStringVersionsPruefung);

    COMMAND commandFrameAnrufen = new COMMAND();
    commandFrameAnrufen.setKEY(KEY.FRAME_ANRUFEN);
    LANGUAGES languagesFrameAnrufen = new LANGUAGES();

    LANGUAGE languagesFrameAnrufenDE = new LANGUAGE();
    languagesFrameAnrufenDE.setISO639(ISO639.DE);
    languagesFrameAnrufenDE.setTEXT("Anrufen");

    LANGUAGE languagesFrameAnrufenEN = new LANGUAGE();
    languagesFrameAnrufenEN.setISO639(ISO639.EN);
    languagesFrameAnrufenEN.setTEXT("Call");

    LANGUAGE languagesFrameAnrufenES = new LANGUAGE();
    languagesFrameAnrufenES.setISO639(ISO639.ES);
    languagesFrameAnrufenES.setTEXT("Llamar");

    languagesFrameAnrufen.getLANGUAGE().add(languagesFrameAnrufenDE);
    languagesFrameAnrufen.getLANGUAGE().add(languagesFrameAnrufenEN);
    languagesFrameAnrufen.getLANGUAGE().add(languagesFrameAnrufenES);
    commandFrameAnrufen.setLANGUAGES(languagesFrameAnrufen);

    COMMAND commandStringCommandMikrofonIstAusgeschaltet = new COMMAND();
    commandStringCommandMikrofonIstAusgeschaltet.setKEY(KEY.STRING_MIKROFON_IST_NICHT_EINGESCHALTET);
    LANGUAGES languagesStringMikrofonIstNichtEingeschaltet = new LANGUAGES();

    LANGUAGE languagesStringMikrofonIstNichtEingeschaltetDE = new LANGUAGE();
    languagesStringMikrofonIstNichtEingeschaltetDE.setISO639(ISO639.DE);
    languagesStringMikrofonIstNichtEingeschaltetDE.setTEXT("Das Mikrofon ist nicht eingeschaltet.");

    LANGUAGE languagesStringMikrofonIstNichtEingeschaltetEN = new LANGUAGE();
    languagesStringMikrofonIstNichtEingeschaltetEN.setISO639(ISO639.EN);
    languagesStringMikrofonIstNichtEingeschaltetEN.setTEXT("The microphone is not switched on.");

    LANGUAGE languagesStringMikrofonIstNichtEingeschaltetES = new LANGUAGE();
    languagesStringMikrofonIstNichtEingeschaltetES.setISO639(ISO639.ES);
    languagesStringMikrofonIstNichtEingeschaltetES.setTEXT("El micrófono no está encendido.");

    languagesStringMikrofonIstNichtEingeschaltet.getLANGUAGE()
        .add(languagesStringMikrofonIstNichtEingeschaltetDE);
    languagesStringMikrofonIstNichtEingeschaltet.getLANGUAGE()
        .add(languagesStringMikrofonIstNichtEingeschaltetEN);
    languagesStringMikrofonIstNichtEingeschaltet.getLANGUAGE()
        .add(languagesStringMikrofonIstNichtEingeschaltetES);
    commandStringCommandMikrofonIstAusgeschaltet.setLANGUAGES(languagesStringMikrofonIstNichtEingeschaltet);

    COMMAND commandStringEinMikrofonFehlt = new COMMAND();
    commandStringEinMikrofonFehlt.setKEY(KEY.STRING_EIN_MIKROFON_FEHLT);
    LANGUAGES languagesStringEinMikronfehlt = new LANGUAGES();

    LANGUAGE languagesStringEinMikronfehltDE = new LANGUAGE();
    languagesStringEinMikronfehltDE.setISO639(ISO639.DE);
    languagesStringEinMikronfehltDE.setTEXT("Ein Mikrofon fehlt oder das Mikrofon ist nicht eingeschaltet.");

    LANGUAGE languagesStringEinMikronfehltEN = new LANGUAGE();
    languagesStringEinMikronfehltEN.setISO639(ISO639.EN);
    languagesStringEinMikronfehltEN.setTEXT("A microphone is missing or the microphone is not switched on.");

    LANGUAGE languagesStringEinMikronfehltES = new LANGUAGE();
    languagesStringEinMikronfehltES.setISO639(ISO639.ES);
    languagesStringEinMikronfehltES.setTEXT("Falta un micrófono o el micrófono no está encendido.");

    languagesStringEinMikronfehlt.getLANGUAGE().add(languagesStringEinMikronfehltDE);
    languagesStringEinMikronfehlt.getLANGUAGE().add(languagesStringEinMikronfehltEN);
    languagesStringEinMikronfehlt.getLANGUAGE().add(languagesStringEinMikronfehltES);
    commandStringEinMikrofonFehlt.setLANGUAGES(languagesStringEinMikronfehlt);

    COMMAND commandStringTelefonierenIstNichtMoeglich = new COMMAND();
    commandStringTelefonierenIstNichtMoeglich.setKEY(KEY.STRING_TELEFONIEREN_IST_NICHT_MOEGLICH);
    LANGUAGES languagesStringTelefonierenIstNichtMoeglich = new LANGUAGES();
    LANGUAGE languagesStringTelefonierenIstNichtMoeglichDE = new LANGUAGE();
    languagesStringTelefonierenIstNichtMoeglichDE.setISO639(ISO639.DE);
    languagesStringTelefonierenIstNichtMoeglichDE.setTEXT("Telefonieren ist nicht möglich");

    LANGUAGE languagesStringTelefonierenIstNichtMoeglichEN = new LANGUAGE();
    languagesStringTelefonierenIstNichtMoeglichEN.setISO639(ISO639.EN);
    languagesStringTelefonierenIstNichtMoeglichEN.setTEXT("Telephone calls are not possible.");

    LANGUAGE languagesStringTelefonierenIstNichtMoeglichES = new LANGUAGE();
    languagesStringTelefonierenIstNichtMoeglichES.setISO639(ISO639.ES);
    languagesStringTelefonierenIstNichtMoeglichES.setTEXT("Las llamadas telefónicas no son posibles.");

    languagesStringTelefonierenIstNichtMoeglich.getLANGUAGE()
        .add(languagesStringTelefonierenIstNichtMoeglichDE);
    languagesStringTelefonierenIstNichtMoeglich.getLANGUAGE()
        .add(languagesStringTelefonierenIstNichtMoeglichEN);
    languagesStringTelefonierenIstNichtMoeglich.getLANGUAGE()
        .add(languagesStringTelefonierenIstNichtMoeglichES);
    commandStringTelefonierenIstNichtMoeglich.setLANGUAGES(languagesStringTelefonierenIstNichtMoeglich);

    COMMAND commandStringEinLautsprecherIst = new COMMAND();
    commandStringEinLautsprecherIst.setKEY(KEY.STRING_EIN_LAUTSPRECHER_IST);
    LANGUAGES languagesStringEinLautsprecherIst = new LANGUAGES();

    LANGUAGE languagesStringEinLautsprecherIstDE = new LANGUAGE();
    languagesStringEinLautsprecherIstDE.setISO639(ISO639.DE);
    languagesStringEinLautsprecherIstDE.setTEXT("Ein Lautsprecher ist nicht angeschlossen.");

    LANGUAGE languagesStringEinLautsprecherIstEN = new LANGUAGE();
    languagesStringEinLautsprecherIstEN.setISO639(ISO639.EN);
    languagesStringEinLautsprecherIstEN.setTEXT("A loudspeaker is not connected.");

    LANGUAGE languagesStringEinLautsprecherIstES = new LANGUAGE();
    languagesStringEinLautsprecherIstES.setISO639(ISO639.ES);
    languagesStringEinLautsprecherIstES.setTEXT("El altavoz no está conectado.");

    languagesStringEinLautsprecherIst.getLANGUAGE().add(languagesStringEinLautsprecherIstDE);
    languagesStringEinLautsprecherIst.getLANGUAGE().add(languagesStringEinLautsprecherIstEN);
    languagesStringEinLautsprecherIst.getLANGUAGE().add(languagesStringEinLautsprecherIstES);
    commandStringEinLautsprecherIst.setLANGUAGES(languagesStringEinLautsprecherIst);

    COMMAND commandStringBisherWurde = new COMMAND();
    commandStringBisherWurde.setKEY(KEY.STRING_BISHER_WURDE_KEIN);
    LANGUAGES languagesStringBisherWurde = new LANGUAGES();

    LANGUAGE languagesStringBisherWurdeDE = new LANGUAGE();
    languagesStringBisherWurdeDE.setISO639(ISO639.DE);
    languagesStringBisherWurdeDE.setTEXT(
        "<html>" + "Bisher wurde kein Mikrofon ausgewählt und gespeichert.<br>"
            + "Wähle den Menupunkt <b>Telefon</b> > <b>Einrichten</b> aus.<br>"
            + "Speichere ein Mikrofon aus der Auswahlliste <b>'Mein Mikrofon ist'</b> ab."
            + "</html>"
    );

    LANGUAGE languagesStringBisherWurdeEN = new LANGUAGE();
    languagesStringBisherWurdeEN.setISO639(ISO639.EN);
    languagesStringBisherWurdeEN.setTEXT(
        "<html>" + "No microphone has been selected and saved yet.<br>"
            + "Wähle den Menupunkt <b>Phone</b> > <b>Settings</b> aus.<br>"
            + "Save a microphone from the <b>'My microphone is'</b> selection list."
            + "</html>"
    );

    LANGUAGE languagesStringBisherWurdeES = new LANGUAGE();
    languagesStringBisherWurdeES.setISO639(ISO639.ES);
    languagesStringBisherWurdeES.setTEXT(
        "<html>" + "Todavía no se ha seleccionado y guardado ningún micrófono.<br>"
            + "Selecciona la opción de menú <b>Teléfono</b> > <b>Ajustes del teléfono</b>.<br>"
            + "Guardar un micrófono de la lista de selección <b>'Mi micrófono es'</b>."
            + "</html>"
    );

    languagesStringBisherWurde.getLANGUAGE().add(languagesStringBisherWurdeDE);
    languagesStringBisherWurde.getLANGUAGE().add(languagesStringBisherWurdeEN);
    languagesStringBisherWurde.getLANGUAGE().add(languagesStringBisherWurdeES);
    commandStringBisherWurde.setLANGUAGES(languagesStringBisherWurde);

    COMMAND commandStringAktualisieren = new COMMAND();
    commandStringAktualisieren.setKEY(KEY.LABEL_ICH_NEHME_EINE_AKTUALISIERUNG);
    LANGUAGES languagesLabelAktualisierung = new LANGUAGES();

    LANGUAGE languagesLabelAktualisierungDE = new LANGUAGE();
    languagesLabelAktualisierungDE.setISO639(ISO639.DE);
    languagesLabelAktualisierungDE.setTEXT(
        "<html>" + "Deine Programmversion <b>XXX</b> ist nicht mehr aktuell. "
            + "Der Funktionsumfang<br>ist geringer und es könnten nicht korrigierte Fehler enthalten sein.<br>"
            + " Ich nehme eine Aktualisierung vor und melde mich für weitere Schritte."
            + "</html>"
    );

    LANGUAGE languagesLabelAktualisierungEN = new LANGUAGE();
    languagesLabelAktualisierungEN.setISO639(ISO639.EN);
    languagesLabelAktualisierungEN.setTEXT(
        "<html>" + "Your program version <b>XXX</b> is out of date.<br>"
            + "The functionality is less and it may contain uncorrected errors.<br>"
            + "I will do an update and contact you for further actions."
            + "</html>"
    );

    LANGUAGE languagesLabelAktualisierungES = new LANGUAGE();
    languagesLabelAktualisierungES.setISO639(ISO639.ES);
    languagesLabelAktualisierungES.setTEXT(
        "<html>" + "La versión <b>XXX</b> de tu programa ya no está actualizada.<br> "
            + "La gama de funciones es menor y puede contener errores no corregidos.<br>"
            + "Haré una actualización y me pondré en contacto contigo para tomar nuevas medidas."
            + "</html>"
    );

    languagesLabelAktualisierung.getLANGUAGE().add(languagesLabelAktualisierungDE);
    languagesLabelAktualisierung.getLANGUAGE().add(languagesLabelAktualisierungEN);
    languagesLabelAktualisierung.getLANGUAGE().add(languagesLabelAktualisierungES);

    commandStringAktualisieren.setLANGUAGES(languagesLabelAktualisierung);

    COMMAND commandStringJa = new COMMAND();
    commandStringJa.setKEY(KEY.STRING_JA);
    LANGUAGES languagesStringJa = new LANGUAGES();

    LANGUAGE languagesStringJaDE = new LANGUAGE();
    languagesStringJaDE.setISO639(ISO639.DE);
    languagesStringJaDE.setTEXT("Ja");
    languagesStringJaDE.setSHORTCUT(VIRTUALKEY.VK_J);

    LANGUAGE languagesStringJaEN = new LANGUAGE();
    languagesStringJaEN.setISO639(ISO639.EN);
    languagesStringJaEN.setTEXT("Yes");
    languagesStringJaEN.setSHORTCUT(VIRTUALKEY.VK_Y);

    LANGUAGE languagesStringJaES = new LANGUAGE();
    languagesStringJaES.setISO639(ISO639.ES);
    languagesStringJaES.setTEXT("Sí");
    languagesStringJaES.setSHORTCUT(VIRTUALKEY.VK_S);

    languagesStringJa.getLANGUAGE().add(languagesStringJaDE);
    languagesStringJa.getLANGUAGE().add(languagesStringJaEN);
    languagesStringJa.getLANGUAGE().add(languagesStringJaES);
    commandStringJa.setLANGUAGES(languagesStringJa);

    COMMAND commandStringNein = new COMMAND();
    commandStringNein.setKEY(KEY.STRING_NEIN);
    LANGUAGES languagesStringNein = new LANGUAGES();

    LANGUAGE languagesStringNeinDE = new LANGUAGE();
    languagesStringNeinDE.setISO639(ISO639.DE);
    languagesStringNeinDE.setSHORTCUT(VIRTUALKEY.VK_N);
    languagesStringNeinDE.setTEXT("Nein");

    LANGUAGE languagesStringNeinEN = new LANGUAGE();
    languagesStringNeinEN.setISO639(ISO639.EN);
    languagesStringNeinEN.setSHORTCUT(VIRTUALKEY.VK_N);
    languagesStringNeinEN.setTEXT("No");

    LANGUAGE languagesStringNeinES = new LANGUAGE();
    languagesStringNeinES.setISO639(ISO639.ES);
    languagesStringNeinES.setSHORTCUT(VIRTUALKEY.VK_N);
    languagesStringNeinES.setTEXT("No");

    languagesStringNein.getLANGUAGE().add(languagesStringNeinDE);
    languagesStringNein.getLANGUAGE().add(languagesStringNeinEN);
    languagesStringNein.getLANGUAGE().add(languagesStringNeinES);
    commandStringNein.setLANGUAGES(languagesStringNein);

    COMMAND commandStringProgrammende = new COMMAND();
    commandStringProgrammende.setKEY(KEY.STRING_PROGRAMMENDE);
    LANGUAGES languagesStringProgrammende = new LANGUAGES();

    LANGUAGE languagesStringProgrammendeDE = new LANGUAGE();
    languagesStringProgrammendeDE.setISO639(ISO639.DE);
    languagesStringProgrammendeDE.setTEXT("Programmende");

    LANGUAGE languagesStringProgrammendeEN = new LANGUAGE();
    languagesStringProgrammendeEN.setISO639(ISO639.EN);
    languagesStringProgrammendeEN.setTEXT("Terminate program");

    LANGUAGE languagesStringProgrammendeES = new LANGUAGE();
    languagesStringProgrammendeES.setISO639(ISO639.ES);
    languagesStringProgrammendeES.setTEXT("Terminar el programa");

    languagesStringProgrammende.getLANGUAGE().add(languagesStringProgrammendeDE);
    languagesStringProgrammende.getLANGUAGE().add(languagesStringProgrammendeEN);
    languagesStringProgrammende.getLANGUAGE().add(languagesStringProgrammendeES);
    commandStringProgrammende.setLANGUAGES(languagesStringProgrammende);

    COMMAND commandStringSollDieLaufende = new COMMAND();
    commandStringSollDieLaufende.setKEY(KEY.STRING_SOLL_DIE_LAUFENDE);
    LANGUAGES languagesStringSollDieLaufende = new LANGUAGES();

    LANGUAGE languagesStringSollDieLaufendeDE = new LANGUAGE();
    languagesStringSollDieLaufendeDE.setISO639(ISO639.DE);
    languagesStringSollDieLaufendeDE.setTEXT("Soll die laufende Aktualisierung abgebrochen werden?");

    LANGUAGE languagesStringSollDieLaufendeEN = new LANGUAGE();
    languagesStringSollDieLaufendeEN.setISO639(ISO639.EN);
    languagesStringSollDieLaufendeEN.setTEXT("Should the current update be canceled?");

    LANGUAGE languagesStringSollDieLaufendeES = new LANGUAGE();
    languagesStringSollDieLaufendeES.setISO639(ISO639.ES);
    languagesStringSollDieLaufendeES.setTEXT("¿Debe cancelarse la actualización actual?");

    languagesStringSollDieLaufende.getLANGUAGE().add(languagesStringSollDieLaufendeDE);
    languagesStringSollDieLaufende.getLANGUAGE().add(languagesStringSollDieLaufendeEN);
    languagesStringSollDieLaufende.getLANGUAGE().add(languagesStringSollDieLaufendeES);
    commandStringSollDieLaufende.setLANGUAGES(languagesStringSollDieLaufende);

    COMMAND commandStringDieVersionWurde = new COMMAND();
    commandStringDieVersionWurde.setKEY(KEY.STRING_DIE_VERSION_WURDE);
    LANGUAGES languagesStringDieVersionWurde = new LANGUAGES();

    LANGUAGE languagesStringDieVersionWurdeDE = new LANGUAGE();
    languagesStringDieVersionWurdeDE.setISO639(ISO639.DE);
    languagesStringDieVersionWurdeDE.setTEXT(
        "<html>" + "Die Version <b>XXX</b> wurde erfolgreich von <b>domain</b> heruntergeladen.<br>"
            + "Wenn du JavaComm schließt, wird die Aktualisierung vervollständigt."
            + "</html>"
    );

    LANGUAGE languagesStringDieVersionWurdeEN = new LANGUAGE();
    languagesStringDieVersionWurdeEN.setISO639(ISO639.EN);
    languagesStringDieVersionWurdeEN.setTEXT(
        "<html>" + "Version <b>XXX</b> has been successfully downloaded from <b>domain</b>.<br>"
            + "When you exit JavaComm, the update will be completed."
            + "</html>"
    );

    LANGUAGE languagesStringDieVersionWurdeES = new LANGUAGE();
    languagesStringDieVersionWurdeES.setISO639(ISO639.ES);
    languagesStringDieVersionWurdeES.setTEXT(
        "<html>" + "La versión <b>XXX</b> se ha descargado con éxito de <b>domain</b>.<br>"
            + "Cuando sal de JavaComm, la actualización se habrá completado."
            + "</html>"
    );

    languagesStringDieVersionWurde.getLANGUAGE().add(languagesStringDieVersionWurdeDE);
    languagesStringDieVersionWurde.getLANGUAGE().add(languagesStringDieVersionWurdeEN);
    languagesStringDieVersionWurde.getLANGUAGE().add(languagesStringDieVersionWurdeES);

    commandStringDieVersionWurde.setLANGUAGES(languagesStringDieVersionWurde);

    COMMAND commandStringProgrammaktualisierung = new COMMAND();
    commandStringProgrammaktualisierung.setKEY(KEY.STRING_PROGRAMMAKTUALISIERUNG);
    LANGUAGES languagesStringProgrammaktualisierung = new LANGUAGES();

    LANGUAGE languagesStringProgrammaktualisierungDE = new LANGUAGE();
    languagesStringProgrammaktualisierungDE.setISO639(ISO639.DE);
    languagesStringProgrammaktualisierungDE.setTEXT("Programmaktualisierung");

    LANGUAGE languagesStringProgrammaktualisierungEN = new LANGUAGE();
    languagesStringProgrammaktualisierungEN.setISO639(ISO639.EN);
    languagesStringProgrammaktualisierungEN.setTEXT("Update program");

    LANGUAGE languagesStringProgrammaktualisierungES = new LANGUAGE();
    languagesStringProgrammaktualisierungES.setISO639(ISO639.ES);
    languagesStringProgrammaktualisierungES.setTEXT("Programa de actualización");

    languagesStringProgrammaktualisierung.getLANGUAGE().add(languagesStringProgrammaktualisierungDE);
    languagesStringProgrammaktualisierung.getLANGUAGE().add(languagesStringProgrammaktualisierungEN);
    languagesStringProgrammaktualisierung.getLANGUAGE().add(languagesStringProgrammaktualisierungES);
    commandStringProgrammaktualisierung.setLANGUAGES(languagesStringProgrammaktualisierung);

    COMMAND commandLabelVersion = new COMMAND();
    commandLabelVersion.setKEY(KEY.LABEL_VERSION);
    LANGUAGES languagesLabelVersion = new LANGUAGES();

    LANGUAGE languagesLabelVersionDE = new LANGUAGE();
    languagesLabelVersionDE.setISO639(ISO639.DE);
    languagesLabelVersionDE.setTEXT("Version: XXX");

    LANGUAGE languagesLabelVersionEN = new LANGUAGE();
    languagesLabelVersionEN.setISO639(ISO639.EN);
    languagesLabelVersionEN.setTEXT("Version: XXX");

    LANGUAGE languagesLabelVersionES = new LANGUAGE();
    languagesLabelVersionES.setISO639(ISO639.ES);
    languagesLabelVersionES.setTEXT("Versión: XXX");

    languagesLabelVersion.getLANGUAGE().add(languagesLabelVersionDE);
    languagesLabelVersion.getLANGUAGE().add(languagesLabelVersionEN);
    languagesLabelVersion.getLANGUAGE().add(languagesLabelVersionES);
    commandLabelVersion.setLANGUAGES(languagesLabelVersion);

    COMMAND commandStringLautsprecherEinrichten = new COMMAND();
    commandStringLautsprecherEinrichten.setKEY(KEY.STRING_LAUTSPRECHER_EINRICHTEN);
    LANGUAGES languagesStringLautsprecherEinrichten = new LANGUAGES();

    LANGUAGE languagesStringLautsprecherEinrichtenDE = new LANGUAGE();
    languagesStringLautsprecherEinrichtenDE.setISO639(ISO639.DE);
    languagesStringLautsprecherEinrichtenDE.setTEXT("Lautsprecher einrichten");

    LANGUAGE languagesStringLautsprecherEinrichtenEN = new LANGUAGE();
    languagesStringLautsprecherEinrichtenEN.setISO639(ISO639.EN);
    languagesStringLautsprecherEinrichtenEN.setTEXT("Speaker setup");

    LANGUAGE languagesStringLautsprecherEinrichtenES = new LANGUAGE();
    languagesStringLautsprecherEinrichtenES.setISO639(ISO639.ES);
    languagesStringLautsprecherEinrichtenES.setTEXT("Configurar el altavoz");

    languagesStringLautsprecherEinrichten.getLANGUAGE().add(languagesStringLautsprecherEinrichtenDE);
    languagesStringLautsprecherEinrichten.getLANGUAGE().add(languagesStringLautsprecherEinrichtenEN);
    languagesStringLautsprecherEinrichten.getLANGUAGE().add(languagesStringLautsprecherEinrichtenES);
    commandStringLautsprecherEinrichten.setLANGUAGES(languagesStringLautsprecherEinrichten);

    COMMAND commandStringKeinMixer = new COMMAND();
    commandStringKeinMixer.setKEY(KEY.STRING_KEIN_MIXER);
    LANGUAGES languagesStringKeinMixer = new LANGUAGES();

    LANGUAGE languagesStringKeinMixerDE = new LANGUAGE();
    languagesStringKeinMixerDE.setISO639(ISO639.DE);
    languagesStringKeinMixerDE.setTEXT(
        "Für den Lautsprecher wurde kein Mixer gefunden.<br><br>" + "Wähle einen anderen Lautsprecher aus."
    );

    LANGUAGE languagesStringKeinMixerEN = new LANGUAGE();
    languagesStringKeinMixerEN.setISO639(ISO639.EN);
    languagesStringKeinMixerEN.setTEXT("No mixer was found for the speaker.<br><br>Select another speaker.");

    LANGUAGE languagesStringKeinMixerES = new LANGUAGE();
    languagesStringKeinMixerES.setISO639(ISO639.ES);
    languagesStringKeinMixerES
        .setTEXT("No se ha encontrado ningún mezclador para el altavoz.<br><br>Selecciona otro altavoz.");

    languagesStringKeinMixer.getLANGUAGE().add(languagesStringKeinMixerDE);
    languagesStringKeinMixer.getLANGUAGE().add(languagesStringKeinMixerEN);
    languagesStringKeinMixer.getLANGUAGE().add(languagesStringKeinMixerES);
    commandStringKeinMixer.setLANGUAGES(languagesStringKeinMixer);

    COMMAND commandStringTelefonformatFalsch = new COMMAND();
    commandStringTelefonformatFalsch.setKEY(KEY.STRING_TELFONFORMAT_FALSCH);
    LANGUAGES languagesStringTelefonformatFalsch = new LANGUAGES();

    LANGUAGE languagesStringTelefonformatFalschDE = new LANGUAGE();
    languagesStringTelefonformatFalschDE.setISO639(ISO639.DE);
    languagesStringTelefonformatFalschDE.setTEXT("Für den Lautsprecher ist das Telefonformat ungültig.");

    LANGUAGE languagesStringTelefonformatFalschEN = new LANGUAGE();
    languagesStringTelefonformatFalschEN.setISO639(ISO639.EN);
    languagesStringTelefonformatFalschEN.setTEXT("The phone format is invalid for the speaker.");

    LANGUAGE languagesStringTelefonformatFalschES = new LANGUAGE();
    languagesStringTelefonformatFalschES.setISO639(ISO639.ES);
    languagesStringTelefonformatFalschES.setTEXT("El formato del teléfono no es válido para el altavoz.");

    languagesStringTelefonformatFalsch.getLANGUAGE().add(languagesStringTelefonformatFalschDE);
    languagesStringTelefonformatFalsch.getLANGUAGE().add(languagesStringTelefonformatFalschEN);
    languagesStringTelefonformatFalsch.getLANGUAGE().add(languagesStringTelefonformatFalschES);
    commandStringTelefonformatFalsch.setLANGUAGES(languagesStringTelefonformatFalsch);

    COMMAND commandStringMikrofonnameIst_Unbekannt = new COMMAND();
    commandStringMikrofonnameIst_Unbekannt.setKEY(KEY.STRING_DER_MIKROFONNAME_IST_UNBEKANNT);
    LANGUAGES languagesStringMikrofonnameIstUnbekannt = new LANGUAGES();
    LANGUAGE languagesStringMikrofonnameIstUnbekanntDE = new LANGUAGE();
    languagesStringMikrofonnameIstUnbekanntDE.setISO639(ISO639.DE);
    languagesStringMikrofonnameIstUnbekanntDE.setTEXT("der Mikrofonname ist unbekannt.");

    LANGUAGE languagesStringMikrofonnameIstUnbekanntEN = new LANGUAGE();
    languagesStringMikrofonnameIstUnbekanntEN.setISO639(ISO639.EN);
    languagesStringMikrofonnameIstUnbekanntEN.setTEXT("the microphone name is unknown.");

    LANGUAGE languagesStringMikrofonnameIstUnbekanntES = new LANGUAGE();
    languagesStringMikrofonnameIstUnbekanntES.setISO639(ISO639.ES);
    languagesStringMikrofonnameIstUnbekanntES.setTEXT("el nombre del micrófono es desconocido.");

    languagesStringMikrofonnameIstUnbekannt.getLANGUAGE().add(languagesStringMikrofonnameIstUnbekanntDE);
    languagesStringMikrofonnameIstUnbekannt.getLANGUAGE().add(languagesStringMikrofonnameIstUnbekanntEN);
    languagesStringMikrofonnameIstUnbekannt.getLANGUAGE().add(languagesStringMikrofonnameIstUnbekanntES);
    commandStringMikrofonnameIst_Unbekannt.setLANGUAGES(languagesStringMikrofonnameIstUnbekannt);

    COMMAND commandStringBluetooth = new COMMAND();
    commandStringBluetooth.setKEY(KEY.STRING_BLUETOOTH);
    LANGUAGES languagesStringBluetooth = new LANGUAGES();

    LANGUAGE languagesStringBluetoothDE = new LANGUAGE();
    languagesStringBluetoothDE.setISO639(ISO639.DE);
    languagesStringBluetoothDE.setTEXT(
        "Dieser Fehler tritt häufig bei <b>Bluetooth-Mikrofone</b> auf, die zwischenzeitlich entkoppelt sind.<br><br>"
            + "Überprüfe die Bluetooth-Verbindung, wenn du ein Bluetooth-Mikrofon hast.<br><br>"
            + "Wähle anschließend den Menupunkt <b>Telefon</b> > <b>Einrichten</b> aus.<br>"
            + "Speichere ein Mikrofon aus der Auswahlliste <b>'Mein Mikrofon ist'</b> ab."
    );

    LANGUAGE languagesStringBluetoothEN = new LANGUAGE();
    languagesStringBluetoothEN.setISO639(ISO639.EN);
    languagesStringBluetoothEN.setTEXT(
        "This error often occurs with <b>Bluetooth microphones</b> that have been disconnected in the meantime.<br><br>"
            + "Check the Bluetooth connection if you have a Bluetooth microphone.<br><br>"
            + "Wähle anschließend den Menupunkt <b>Telefon</b> > <b>Einrichten</b> aus.<br>"
            + "Speichere ein Mikrofon aus der Auswahlliste <b>'Mein Mikrofon ist'</b> ab."
    );

    LANGUAGE languagesStringBluetoothES = new LANGUAGE();
    languagesStringBluetoothES.setISO639(ISO639.ES);
    languagesStringBluetoothES.setTEXT(
        "Este error suele producirse con los <b>micrófonos Bluetooth</b> que se han desconectado entretanto.<br><br>"
            + "Comprueba la conexión Bluetooth si tienes un micrófono Bluetooth.<br><br>"
            + "A continuación, selecciona la opción de menú <b>Teléfono</b> > <b>Configuración</b>.<br>"
            + "Guarda un micrófono de la lista desplegable <b>Mi micrófono es</b>."
    );

    languagesStringBluetooth.getLANGUAGE().add(languagesStringBluetoothDE);
    languagesStringBluetooth.getLANGUAGE().add(languagesStringBluetoothEN);
    languagesStringBluetooth.getLANGUAGE().add(languagesStringBluetoothES);
    commandStringBluetooth.setLANGUAGES(languagesStringBluetooth);

    COMMAND commandStringMikrofonEinrichten = new COMMAND();
    commandStringMikrofonEinrichten.setKEY(KEY.STRING_MIKROFON_EINRICHTEN);
    LANGUAGES languagesStringMikrofonEinrichten = new LANGUAGES();

    LANGUAGE languagesStringMikrofonEinrichtenDE = new LANGUAGE();
    languagesStringMikrofonEinrichtenDE.setISO639(ISO639.DE);
    languagesStringMikrofonEinrichtenDE.setTEXT("Mikrofon einrichten");

    LANGUAGE languagesStringMikrofonEinrichtenEN = new LANGUAGE();
    languagesStringMikrofonEinrichtenEN.setISO639(ISO639.EN);
    languagesStringMikrofonEinrichtenEN.setTEXT("Set up microphone");

    LANGUAGE languagesStringMikrofonEinrichtenES = new LANGUAGE();
    languagesStringMikrofonEinrichtenES.setISO639(ISO639.ES);
    languagesStringMikrofonEinrichtenES.setTEXT("Configurar el micrófono");

    languagesStringMikrofonEinrichten.getLANGUAGE().add(languagesStringMikrofonEinrichtenDE);
    languagesStringMikrofonEinrichten.getLANGUAGE().add(languagesStringMikrofonEinrichtenEN);
    languagesStringMikrofonEinrichten.getLANGUAGE().add(languagesStringMikrofonEinrichtenES);
    commandStringMikrofonEinrichten.setLANGUAGES(languagesStringMikrofonEinrichten);

    COMMAND commandStringHatEinMikrofonproblem = new COMMAND();
    commandStringHatEinMikrofonproblem.setKEY(KEY.STRING_HAT_EIN_MIKROFONPROBLEM);
    LANGUAGES languagesStringHatEinMikrofonproblem = new LANGUAGES();
    LANGUAGE languagesStringMikrofonHatEinMikrofonproblemDE = new LANGUAGE();
    languagesStringMikrofonHatEinMikrofonproblemDE.setISO639(ISO639.DE);
    languagesStringMikrofonHatEinMikrofonproblemDE.setTEXT(" hat ein Mikrofonproblem.");

    LANGUAGE languagesStringMikrofonHatEinMikrofonproblemEN = new LANGUAGE();
    languagesStringMikrofonHatEinMikrofonproblemEN.setISO639(ISO639.EN);
    languagesStringMikrofonHatEinMikrofonproblemEN.setTEXT(" has a microphone problem.");

    LANGUAGE languagesStringMikrofonHatEinMikrofonproblemES = new LANGUAGE();
    languagesStringMikrofonHatEinMikrofonproblemES.setISO639(ISO639.ES);
    languagesStringMikrofonHatEinMikrofonproblemES.setTEXT(" tiene un problema con el micrófono.");

    languagesStringHatEinMikrofonproblem.getLANGUAGE().add(languagesStringMikrofonHatEinMikrofonproblemDE);
    languagesStringHatEinMikrofonproblem.getLANGUAGE().add(languagesStringMikrofonHatEinMikrofonproblemEN);
    languagesStringHatEinMikrofonproblem.getLANGUAGE().add(languagesStringMikrofonHatEinMikrofonproblemES);
    commandStringHatEinMikrofonproblem.setLANGUAGES(languagesStringHatEinMikrofonproblem);

    COMMAND commandStringBegrenzt = new COMMAND();
    commandStringBegrenzt.setKEY(KEY.STRING_LEBENSDAUER_BEGRENZT);
    LANGUAGES languagesStringBegrenzt = new LANGUAGES();

    LANGUAGE languagesStringBegrenztDE = new LANGUAGE();
    languagesStringBegrenztDE.setISO639(ISO639.DE);
    languagesStringBegrenztDE.setTEXT("begrenzt");

    LANGUAGE languagesStringBegrenztEN = new LANGUAGE();
    languagesStringBegrenztEN.setISO639(ISO639.EN);
    languagesStringBegrenztEN.setTEXT("limited");

    LANGUAGE languagesStringBegrenztES = new LANGUAGE();
    languagesStringBegrenztES.setISO639(ISO639.ES);
    languagesStringBegrenztES.setTEXT("limitida");

    languagesStringBegrenzt.getLANGUAGE().add(languagesStringBegrenztDE);
    languagesStringBegrenzt.getLANGUAGE().add(languagesStringBegrenztEN);
    languagesStringBegrenzt.getLANGUAGE().add(languagesStringBegrenztES);
    commandStringBegrenzt.setLANGUAGES(languagesStringBegrenzt);

    COMMAND commandStringUnbegrenzt = new COMMAND();
    commandStringUnbegrenzt.setKEY(KEY.STRING_LEBENSDAUER_UNBEGRENZT);
    LANGUAGES languagesStringUnbegrenzt = new LANGUAGES();

    LANGUAGE languagesStringUnbegrenztDE = new LANGUAGE();
    languagesStringUnbegrenztDE.setISO639(ISO639.DE);
    languagesStringUnbegrenztDE.setTEXT("unbegrenzt");

    LANGUAGE languagesStringUnbegrenztEN = new LANGUAGE();
    languagesStringUnbegrenztEN.setISO639(ISO639.EN);
    languagesStringUnbegrenztEN.setTEXT("indefinite");

    LANGUAGE languagesStringUnbegrenztES = new LANGUAGE();
    languagesStringUnbegrenztES.setISO639(ISO639.ES);
    languagesStringUnbegrenztES.setTEXT("indefinida");

    languagesStringUnbegrenzt.getLANGUAGE().add(languagesStringUnbegrenztDE);
    languagesStringUnbegrenzt.getLANGUAGE().add(languagesStringUnbegrenztEN);
    languagesStringUnbegrenzt.getLANGUAGE().add(languagesStringUnbegrenztES);

    commandStringUnbegrenzt.setLANGUAGES(languagesStringUnbegrenzt);

    COMMAND commandStringDieSpalten = new COMMAND();
    commandStringDieSpalten.setKEY(KEY.STRING_DIE_SPALTEN_KOENNEN);
    LANGUAGES languagesStringDieSpalten = new LANGUAGES();

    LANGUAGE languagesStringDieSpaltenDE = new LANGUAGE();
    languagesStringDieSpaltenDE.setISO639(ISO639.DE);
    languagesStringDieSpaltenDE.setTEXT(
        "Die Spalten können verschoben und vergrößert werden.<br>"
            + "Mit einem Doppelklick oder der Taste <b>&crarr;</b> wird der Raum geöffnet."
    );

    LANGUAGE languagesStringDieSpaltenEN = new LANGUAGE();
    languagesStringDieSpaltenEN.setISO639(ISO639.EN);
    languagesStringDieSpaltenEN.setTEXT(
        "The columns can be moved and enlarged.<br>"
            + "With a double click or the <b>&crarr;</b> key the room is opened."
    );

    LANGUAGE languagesStringDieSpaltenES = new LANGUAGE();
    languagesStringDieSpaltenES.setISO639(ISO639.ES);
    languagesStringDieSpaltenES.setTEXT(
        "Las columnas pueden moverse y ampliarse.<br>"
            + "Haz doble clic en la tecla <b>&crarr;</b> para abrir la sala."
    );

    languagesStringDieSpalten.getLANGUAGE().add(languagesStringDieSpaltenDE);
    languagesStringDieSpalten.getLANGUAGE().add(languagesStringDieSpaltenEN);
    languagesStringDieSpalten.getLANGUAGE().add(languagesStringDieSpaltenES);
    commandStringDieSpalten.setLANGUAGES(languagesStringDieSpalten);

    COMMAND commandStringHaken = new COMMAND();
    commandStringHaken.setKEY(KEY.STRING_HAKEN);
    LANGUAGES languagesStringHaken = new LANGUAGES();
    LANGUAGE languagesStringHakenDE = new LANGUAGE();
    languagesStringHakenDE.setISO639(ISO639.DE);
    languagesStringHakenDE
        .setTEXT("Den Haken setzen, wenn das Passwort auf dem Computer gespeichert werden soll.");

    LANGUAGE languagesStringHakenEN = new LANGUAGE();
    languagesStringHakenEN.setISO639(ISO639.EN);
    languagesStringHakenEN.setTEXT("Check the box if the password is to be saved on the computer.");

    LANGUAGE languagesStringHakenES = new LANGUAGE();
    languagesStringHakenES.setISO639(ISO639.ES);
    languagesStringHakenES.setTEXT("Marque la casilla si la contraseña debe guardarse en el ordenador.");

    languagesStringHaken.getLANGUAGE().add(languagesStringHakenDE);
    languagesStringHaken.getLANGUAGE().add(languagesStringHakenEN);
    languagesStringHaken.getLANGUAGE().add(languagesStringHakenES);
    commandStringHaken.setLANGUAGES(languagesStringHaken);

    COMMAND commandStringHakenMail = new COMMAND();
    commandStringHakenMail.setKEY(KEY.STRING_HAKEN_MAIL);
    LANGUAGES languagesStringHakenMail = new LANGUAGES();

    LANGUAGE languagesStringHakenMailDE = new LANGUAGE();
    languagesStringHakenMailDE.setISO639(ISO639.DE);
    languagesStringHakenMailDE
        .setTEXT("Den Haken setzen, wenn die E-Mail auf dem Computer gespeichert werden soll.");

    LANGUAGE languagesStringHakenMailEN = new LANGUAGE();
    languagesStringHakenMailEN.setISO639(ISO639.EN);
    languagesStringHakenMailEN.setTEXT("Check the box if the email is to be saved on the computer.");

    LANGUAGE languagesStringHakenMailES = new LANGUAGE();
    languagesStringHakenMailES.setISO639(ISO639.ES);
    languagesStringHakenMailES
        .setTEXT("Marque la casilla si el correo electrónico debe guardarse en el ordenador.");

    languagesStringHakenMail.getLANGUAGE().add(languagesStringHakenMailDE);
    languagesStringHakenMail.getLANGUAGE().add(languagesStringHakenMailEN);
    languagesStringHakenMail.getLANGUAGE().add(languagesStringHakenMailES);
    commandStringHakenMail.setLANGUAGES(languagesStringHakenMail);

    COMMAND commandStringBenutzerID = new COMMAND();
    commandStringBenutzerID.setKEY(KEY.STRING_BENUTZER_ID);
    LANGUAGES languagesStringBenutzerid = new LANGUAGES();
    LANGUAGE languagesStringBenutzeridDE = new LANGUAGE();
    languagesStringBenutzeridDE.setISO639(ISO639.DE);
    languagesStringBenutzeridDE.setTEXT("Die Benutzer-ID ist unveränderbar.");

    LANGUAGE languagesStringBenutzeridEN = new LANGUAGE();
    languagesStringBenutzeridEN.setISO639(ISO639.EN);
    languagesStringBenutzeridEN.setTEXT("The user ID is unchangeable.");

    LANGUAGE languagesStringBenutzeridES = new LANGUAGE();
    languagesStringBenutzeridES.setISO639(ISO639.ES);
    languagesStringBenutzeridES.setTEXT("La identificación del usuario no se puede cambiar.");

    languagesStringBenutzerid.getLANGUAGE().add(languagesStringBenutzeridDE);
    languagesStringBenutzerid.getLANGUAGE().add(languagesStringBenutzeridEN);
    languagesStringBenutzerid.getLANGUAGE().add(languagesStringBenutzeridES);
    commandStringBenutzerID.setLANGUAGES(languagesStringBenutzerid);

    COMMAND commandStringPasswoerterStimmen = new COMMAND();
    commandStringPasswoerterStimmen.setKEY(KEY.STRING_PASSWOERTER_STIMMEN);
    LANGUAGES languagesStringPasswoerterStimmen = new LANGUAGES();
    LANGUAGE languagesStringPasswoerterStimmenDE = new LANGUAGE();
    languagesStringPasswoerterStimmenDE.setISO639(ISO639.DE);
    languagesStringPasswoerterStimmenDE.setTEXT("Die Passwörter stimmen nicht überein.");

    LANGUAGE languagesStringPasswoerterStimmenEN = new LANGUAGE();
    languagesStringPasswoerterStimmenEN.setISO639(ISO639.EN);
    languagesStringPasswoerterStimmenEN.setTEXT("The passwords do not match.");

    LANGUAGE languagesStringPasswoerterStimmenES = new LANGUAGE();
    languagesStringPasswoerterStimmenES.setISO639(ISO639.ES);
    languagesStringPasswoerterStimmenES.setTEXT("Las contraseñas no coinciden.");

    languagesStringPasswoerterStimmen.getLANGUAGE().add(languagesStringPasswoerterStimmenDE);
    languagesStringPasswoerterStimmen.getLANGUAGE().add(languagesStringPasswoerterStimmenEN);
    languagesStringPasswoerterStimmen.getLANGUAGE().add(languagesStringPasswoerterStimmenES);
    commandStringPasswoerterStimmen.setLANGUAGES(languagesStringPasswoerterStimmen);

    COMMAND commandStringPasswort = new COMMAND();
    commandStringPasswort.setKEY(KEY.STRING_PASSWORT);
    LANGUAGES languagesStringPasswort = new LANGUAGES();

    LANGUAGE languagesStringPasswortDE = new LANGUAGE();
    languagesStringPasswortDE.setISO639(ISO639.DE);
    languagesStringPasswortDE.setTEXT("Passwort");

    LANGUAGE languagesStringPasswortEN = new LANGUAGE();
    languagesStringPasswortEN.setISO639(ISO639.EN);
    languagesStringPasswortEN.setTEXT("Password");

    LANGUAGE languagesStringPasswortES = new LANGUAGE();
    languagesStringPasswortES.setISO639(ISO639.ES);
    languagesStringPasswortES.setTEXT("Contraseña");

    languagesStringPasswort.getLANGUAGE().add(languagesStringPasswortDE);
    languagesStringPasswort.getLANGUAGE().add(languagesStringPasswortEN);
    languagesStringPasswort.getLANGUAGE().add(languagesStringPasswortES);
    commandStringPasswort.setLANGUAGES(languagesStringPasswort);

    COMMAND commandStringDerSpitzname = new COMMAND();
    commandStringDerSpitzname.setKEY(KEY.STRING_DER_SPITZNAME_IST);
    LANGUAGES languagesStringDerSpitzname = new LANGUAGES();

    LANGUAGE languagesStringDerSpitznameDE = new LANGUAGE();
    languagesStringDerSpitznameDE.setISO639(ISO639.DE);
    languagesStringDerSpitznameDE.setTEXT("Der Nickname ist für andere Benutzer sichtbar.");

    LANGUAGE languagesStringDerSpitznameEN = new LANGUAGE();
    languagesStringDerSpitznameEN.setISO639(ISO639.EN);
    languagesStringDerSpitznameEN.setTEXT("The nickname is visible to other users.");

    LANGUAGE languagesStringDerSpitznameES = new LANGUAGE();
    languagesStringDerSpitznameES.setISO639(ISO639.ES);
    languagesStringDerSpitznameES.setTEXT("El alias es visible para otros usuarios.");

    languagesStringDerSpitzname.getLANGUAGE().add(languagesStringDerSpitznameDE);
    languagesStringDerSpitzname.getLANGUAGE().add(languagesStringDerSpitznameEN);
    languagesStringDerSpitzname.getLANGUAGE().add(languagesStringDerSpitznameES);
    commandStringDerSpitzname.setLANGUAGES(languagesStringDerSpitzname);

    COMMAND commandStringSpitznameLang = new COMMAND();
    commandStringSpitznameLang.setKEY(KEY.STRING_SPITZNAME_LANG);
    LANGUAGES languagesStringSpitznameLang = new LANGUAGES();

    LANGUAGE languagesStringSpitznameLangDE = new LANGUAGE();
    languagesStringSpitznameLangDE.setISO639(ISO639.DE);
    languagesStringSpitznameLangDE.setTEXT("Der Nickname darf nicht mehr als XXX Zeichen lang sein.");

    LANGUAGE languagesStringSpitznameLangEN = new LANGUAGE();
    languagesStringSpitznameLangEN.setISO639(ISO639.EN);
    languagesStringSpitznameLangEN.setTEXT("The nickname must not be more than XXX characters long.");

    LANGUAGE languagesStringSpitznameLangES = new LANGUAGE();
    languagesStringSpitznameLangES.setISO639(ISO639.ES);
    languagesStringSpitznameLangES.setTEXT("El alias no debe tener más de XXX caracteres.");

    languagesStringSpitznameLang.getLANGUAGE().add(languagesStringSpitznameLangDE);
    languagesStringSpitznameLang.getLANGUAGE().add(languagesStringSpitznameLangEN);
    languagesStringSpitznameLang.getLANGUAGE().add(languagesStringSpitznameLangES);
    commandStringSpitznameLang.setLANGUAGES(languagesStringSpitznameLang);

    COMMAND commandStringGespraechBeginnen = new COMMAND();
    commandStringGespraechBeginnen.setKEY(KEY.STRING_GESPRAECH_BEGINNEN);
    LANGUAGES languagesStringGespraechBeginnen = new LANGUAGES();

    LANGUAGE languagesStringGespraechBeginnenDE = new LANGUAGE();
    languagesStringGespraechBeginnenDE.setISO639(ISO639.DE);
    languagesStringGespraechBeginnenDE.setTEXT("Gespräch beginnen");

    LANGUAGE languagesStringGespraechBeginnenEN = new LANGUAGE();
    languagesStringGespraechBeginnenEN.setISO639(ISO639.EN);
    languagesStringGespraechBeginnenEN.setTEXT("Start conversation");

    LANGUAGE languagesStringGespraechBeginnenES = new LANGUAGE();
    languagesStringGespraechBeginnenES.setISO639(ISO639.ES);
    languagesStringGespraechBeginnenES.setTEXT("Iniciar conversación");

    languagesStringGespraechBeginnen.getLANGUAGE().add(languagesStringGespraechBeginnenDE);
    languagesStringGespraechBeginnen.getLANGUAGE().add(languagesStringGespraechBeginnenEN);
    languagesStringGespraechBeginnen.getLANGUAGE().add(languagesStringGespraechBeginnenES);

    commandStringGespraechBeginnen.setLANGUAGES(languagesStringGespraechBeginnen);

    COMMAND commandStringBenutzerEinladen = new COMMAND();
    commandStringBenutzerEinladen.setKEY(KEY.STRING_BENUTZER_EINLADEN);
    LANGUAGES languagesStringBenutzerEinladen = new LANGUAGES();
    LANGUAGE languagesStringBenutzerEinladenDE = new LANGUAGE();
    languagesStringBenutzerEinladenDE.setISO639(ISO639.DE);
    languagesStringBenutzerEinladenDE.setTEXT("Benutzer markieren und in die Freundesliste übertragen.");

    LANGUAGE languagesStringBenutzerEinladenEN = new LANGUAGE();
    languagesStringBenutzerEinladenEN.setISO639(ISO639.EN);
    languagesStringBenutzerEinladenEN.setTEXT("Mark user and transfer to the friends list.");

    LANGUAGE languagesStringBenutzerEinladenES = new LANGUAGE();
    languagesStringBenutzerEinladenES.setISO639(ISO639.ES);
    languagesStringBenutzerEinladenES.setTEXT("Marcar el usuario y transferirlo a la lista de amigos.");

    languagesStringBenutzerEinladen.getLANGUAGE().add(languagesStringBenutzerEinladenDE);
    languagesStringBenutzerEinladen.getLANGUAGE().add(languagesStringBenutzerEinladenEN);
    languagesStringBenutzerEinladen.getLANGUAGE().add(languagesStringBenutzerEinladenES);
    commandStringBenutzerEinladen.setLANGUAGES(languagesStringBenutzerEinladen);

    COMMAND commandStringBenutzerInDieTeilnehmerliste = new COMMAND();
    commandStringBenutzerInDieTeilnehmerliste.setKEY(KEY.STRING_BENUTZER_IN_DIE_TEILNEHMERLISTE);
    LANGUAGES languagesBenutzerInDieTeilnehmerliste = new LANGUAGES();

    LANGUAGE languagesBenutzerInDieTeilnehmerlisteDE = new LANGUAGE();
    languagesBenutzerInDieTeilnehmerlisteDE.setISO639(ISO639.DE);
    languagesBenutzerInDieTeilnehmerlisteDE.setTEXT("Benutzer in die Teilnehmerliste eintragen.");

    LANGUAGE languagesBenutzerInDieTeilnehmerlisteEN = new LANGUAGE();
    languagesBenutzerInDieTeilnehmerlisteEN.setISO639(ISO639.EN);
    languagesBenutzerInDieTeilnehmerlisteEN.setTEXT("Add user to the list of participants.");

    LANGUAGE languagesBenutzerInDieTeilnehmerlisteES = new LANGUAGE();
    languagesBenutzerInDieTeilnehmerlisteES.setISO639(ISO639.ES);
    languagesBenutzerInDieTeilnehmerlisteES.setTEXT("Introduce el usuario en la lista de participantes.");

    languagesBenutzerInDieTeilnehmerliste.getLANGUAGE().add(languagesBenutzerInDieTeilnehmerlisteDE);
    languagesBenutzerInDieTeilnehmerliste.getLANGUAGE().add(languagesBenutzerInDieTeilnehmerlisteEN);
    languagesBenutzerInDieTeilnehmerliste.getLANGUAGE().add(languagesBenutzerInDieTeilnehmerlisteES);
    commandStringBenutzerInDieTeilnehmerliste.setLANGUAGES(languagesBenutzerInDieTeilnehmerliste);

    COMMAND commandStringBenutzerAusDerTeilnehmerliste = new COMMAND();
    commandStringBenutzerAusDerTeilnehmerliste.setKEY(KEY.STRING_BENUTZER_AUS_DER_TEILNEHMERLISTE);
    LANGUAGES languagesStringBenutzerAusDerTeilnehmerliste = new LANGUAGES();
    LANGUAGE languagesStringBenutzerAusDerTeilnehmerlisteDE = new LANGUAGE();
    languagesStringBenutzerAusDerTeilnehmerlisteDE.setISO639(ISO639.DE);
    languagesStringBenutzerAusDerTeilnehmerlisteDE.setTEXT("Benutzer aus der Teilnehmerliste streichen");

    LANGUAGE languagesStringBenutzerAusDerTeilnehmerlisteEN = new LANGUAGE();
    languagesStringBenutzerAusDerTeilnehmerlisteEN.setISO639(ISO639.EN);
    languagesStringBenutzerAusDerTeilnehmerlisteEN.setTEXT("Delete user from the participant list");

    LANGUAGE languagesStringBenutzerAusDerTeilnehmerlisteES = new LANGUAGE();
    languagesStringBenutzerAusDerTeilnehmerlisteES.setISO639(ISO639.ES);
    languagesStringBenutzerAusDerTeilnehmerlisteES.setTEXT("Borrar usuario de la lista de participantes");

    languagesStringBenutzerAusDerTeilnehmerliste.getLANGUAGE()
        .add(languagesStringBenutzerAusDerTeilnehmerlisteDE);
    languagesStringBenutzerAusDerTeilnehmerliste.getLANGUAGE()
        .add(languagesStringBenutzerAusDerTeilnehmerlisteEN);
    languagesStringBenutzerAusDerTeilnehmerliste.getLANGUAGE()
        .add(languagesStringBenutzerAusDerTeilnehmerlisteES);
    commandStringBenutzerAusDerTeilnehmerliste.setLANGUAGES(languagesStringBenutzerAusDerTeilnehmerliste);

    COMMAND commandStringWaehleEineDatei = new COMMAND();
    commandStringWaehleEineDatei.setKEY(KEY.STRING_WAEHLE_EINE_DATEI);
    LANGUAGES languagesStringWaehleEineDatei = new LANGUAGES();
    LANGUAGE languagesStringWaehleEineDateiDE = new LANGUAGE();
    languagesStringWaehleEineDateiDE.setISO639(ISO639.DE);
    languagesStringWaehleEineDateiDE
        .setTEXT("Wähle eine Datei aus und ziehe sie in einen Übertragungskanal.");

    LANGUAGE languagesStringWaehleEineDateiEN = new LANGUAGE();
    languagesStringWaehleEineDateiEN.setISO639(ISO639.EN);
    languagesStringWaehleEineDateiEN.setTEXT("Select a file and drag it to a transfer channel.");

    LANGUAGE languagesStringWaehleEineDateiES = new LANGUAGE();
    languagesStringWaehleEineDateiES.setISO639(ISO639.ES);
    languagesStringWaehleEineDateiES
        .setTEXT("Selecciona un archivo y arrástralo a un canal de transferencia.");

    languagesStringWaehleEineDatei.getLANGUAGE().add(languagesStringWaehleEineDateiDE);
    languagesStringWaehleEineDatei.getLANGUAGE().add(languagesStringWaehleEineDateiEN);
    languagesStringWaehleEineDatei.getLANGUAGE().add(languagesStringWaehleEineDateiES);
    commandStringWaehleEineDatei.setLANGUAGES(languagesStringWaehleEineDatei);

    COMMAND commandStringUploadButton = new COMMAND();
    commandStringUploadButton.setKEY(KEY.STRING_UPLOAD_DIRECTORY);
    LANGUAGES languagesStringUploadButton = new LANGUAGES();
    LANGUAGE languagesStringUploadButtonDE = new LANGUAGE();
    languagesStringUploadButtonDE.setISO639(ISO639.DE);
    languagesStringUploadButtonDE.setTEXT("Verzeichnis zum Hochloaden");

    LANGUAGE languagesStringUploadButtonEN = new LANGUAGE();
    languagesStringUploadButtonEN.setISO639(ISO639.EN);
    languagesStringUploadButtonEN.setTEXT("Upload directory");

    LANGUAGE languagesStringUploadButtonES = new LANGUAGE();
    languagesStringUploadButtonES.setISO639(ISO639.ES);
    languagesStringUploadButtonES.setTEXT("Cargar directorio");

    languagesStringUploadButton.getLANGUAGE().add(languagesStringUploadButtonDE);
    languagesStringUploadButton.getLANGUAGE().add(languagesStringUploadButtonEN);
    languagesStringUploadButton.getLANGUAGE().add(languagesStringUploadButtonES);
    commandStringUploadButton.setLANGUAGES(languagesStringUploadButton);

    COMMAND commandStringDownloadButton = new COMMAND();
    commandStringDownloadButton.setKEY(KEY.STRING_DOWNLOAD_DIRECTORY);
    LANGUAGES languagesStringDownloadButton = new LANGUAGES();
    LANGUAGE languagesStringDownloadButtonDE = new LANGUAGE();
    languagesStringDownloadButtonDE.setISO639(ISO639.DE);
    languagesStringDownloadButtonDE.setTEXT("Verzeichnis zum Herunterladen");

    LANGUAGE languagesStringDownloadButtonEN = new LANGUAGE();
    languagesStringDownloadButtonEN.setISO639(ISO639.EN);
    languagesStringDownloadButtonEN.setTEXT("Download directory");

    LANGUAGE languagesStringDownloadButtonES = new LANGUAGE();
    languagesStringDownloadButtonES.setISO639(ISO639.ES);
    languagesStringDownloadButtonES.setTEXT("Descargar directorio");

    languagesStringDownloadButton.getLANGUAGE().add(languagesStringDownloadButtonDE);
    languagesStringDownloadButton.getLANGUAGE().add(languagesStringDownloadButtonEN);
    languagesStringDownloadButton.getLANGUAGE().add(languagesStringDownloadButtonES);
    commandStringDownloadButton.setLANGUAGES(languagesStringDownloadButton);

    COMMAND commandStringInDiesesVerzeichnis = new COMMAND();
    commandStringInDiesesVerzeichnis.setKEY(KEY.STRING_DOWNLOAD_VERZEICHNIS);
    LANGUAGES languagesStringInDiesesVerzeichnis = new LANGUAGES();

    LANGUAGE languagesStringInDiesesVerzeichnisDE = new LANGUAGE();
    languagesStringInDiesesVerzeichnisDE.setISO639(ISO639.DE);
    languagesStringInDiesesVerzeichnisDE.setTEXT("In dieses Verzeichnis werden Dateien kopiert.");

    LANGUAGE languagesStringInDiesesVerzeichnisEN = new LANGUAGE();
    languagesStringInDiesesVerzeichnisEN.setISO639(ISO639.EN);
    languagesStringInDiesesVerzeichnisEN.setTEXT("Files are copied to this directory.");

    LANGUAGE languagesStringInDiesesVerzeichnisES = new LANGUAGE();
    languagesStringInDiesesVerzeichnisES.setISO639(ISO639.ES);
    languagesStringInDiesesVerzeichnisES.setTEXT("Los archivos se copian en este directorio.");

    languagesStringInDiesesVerzeichnis.getLANGUAGE().add(languagesStringInDiesesVerzeichnisDE);
    languagesStringInDiesesVerzeichnis.getLANGUAGE().add(languagesStringInDiesesVerzeichnisEN);
    languagesStringInDiesesVerzeichnis.getLANGUAGE().add(languagesStringInDiesesVerzeichnisES);
    commandStringInDiesesVerzeichnis.setLANGUAGES(languagesStringInDiesesVerzeichnis);

    COMMAND commandStringAusDiesemVerzeichnis = new COMMAND();
    commandStringAusDiesemVerzeichnis.setKEY(KEY.STRING_UPLOAD_VERZEICHNIS);
    LANGUAGES languagesStringAusDiesemVerzeichnis = new LANGUAGES();
    LANGUAGE languagesStringAusDiesemVerzeichnisDE = new LANGUAGE();
    languagesStringAusDiesemVerzeichnisDE.setISO639(ISO639.DE);
    languagesStringAusDiesemVerzeichnisDE.setTEXT(
        "<html>Aus diesem Verzeichnis werden Dateien übertragen.<br>Beachte die Schwarze Liste.</html>"
    );

    LANGUAGE languagesStringAusDiesemVerzeichnisEN = new LANGUAGE();
    languagesStringAusDiesemVerzeichnisEN.setISO639(ISO639.EN);
    languagesStringAusDiesemVerzeichnisEN
        .setTEXT("<html>Files are transferred from this directory.<br>Note the blacklist.</html>");

    LANGUAGE languagesStringAusDiesemVerzeichnisES = new LANGUAGE();
    languagesStringAusDiesemVerzeichnisES.setISO639(ISO639.ES);
    languagesStringAusDiesemVerzeichnisES.setTEXT(
        "<html>Los archivos se transfieren desde este directorio.<br>Observe la lista negra.</html>"
    );

    languagesStringAusDiesemVerzeichnis.getLANGUAGE().add(languagesStringAusDiesemVerzeichnisDE);
    languagesStringAusDiesemVerzeichnis.getLANGUAGE().add(languagesStringAusDiesemVerzeichnisEN);
    languagesStringAusDiesemVerzeichnis.getLANGUAGE().add(languagesStringAusDiesemVerzeichnisES);
    commandStringAusDiesemVerzeichnis.setLANGUAGES(languagesStringAusDiesemVerzeichnis);

    COMMAND commandStringDerServerMuss = new COMMAND();
    commandStringDerServerMuss.setKEY(KEY.STRING_DER_SERVER_MUSS);
    LANGUAGES languagesStringStringDerServerMuss = new LANGUAGES();

    LANGUAGE languagesStringStringDerServerMussDE = new LANGUAGE();
    languagesStringStringDerServerMussDE.setISO639(ISO639.DE);
    languagesStringStringDerServerMussDE.setTEXT("<html>Der Server muss noch gestartet werden.</html>");

    LANGUAGE languagesStringStringDerServerMussEN = new LANGUAGE();
    languagesStringStringDerServerMussEN.setISO639(ISO639.EN);
    languagesStringStringDerServerMussEN.setTEXT("<html>The server must still be started.</html>");

    LANGUAGE languagesStringStringDerServerMussES = new LANGUAGE();
    languagesStringStringDerServerMussES.setISO639(ISO639.ES);
    languagesStringStringDerServerMussES.setTEXT("<html>El servidor aún debe estar iniciado.</html>");

    languagesStringStringDerServerMuss.getLANGUAGE().add(languagesStringStringDerServerMussDE);
    languagesStringStringDerServerMuss.getLANGUAGE().add(languagesStringStringDerServerMussEN);
    languagesStringStringDerServerMuss.getLANGUAGE().add(languagesStringStringDerServerMussES);
    commandStringDerServerMuss.setLANGUAGES(languagesStringStringDerServerMuss);

    COMMAND commandStringKeineAbspielbarenLieder = new COMMAND();
    commandStringKeineAbspielbarenLieder.setKEY(KEY.STRING_KEINE_ABSPIELBAREN_LIEDER);
    LANGUAGES languagesStringKeineAbspielbarenLieder = new LANGUAGES();

    LANGUAGE languagesStringKeineAbspielbarenLiederDE = new LANGUAGE();
    languagesStringKeineAbspielbarenLiederDE.setISO639(ISO639.DE);
    languagesStringKeineAbspielbarenLiederDE.setTEXT("Keine abspielbaren Medien gefunden.");

    LANGUAGE languagesStringKeineAbspielbarenLiederEN = new LANGUAGE();
    languagesStringKeineAbspielbarenLiederEN.setISO639(ISO639.EN);
    languagesStringKeineAbspielbarenLiederEN.setTEXT("No playable media found.");

    LANGUAGE languagesStringKeineAbspielbarenLiederES = new LANGUAGE();
    languagesStringKeineAbspielbarenLiederES.setISO639(ISO639.ES);
    languagesStringKeineAbspielbarenLiederES.setTEXT("No se ha encontrado ningún medio reproducible.");

    languagesStringKeineAbspielbarenLieder.getLANGUAGE().add(languagesStringKeineAbspielbarenLiederDE);
    languagesStringKeineAbspielbarenLieder.getLANGUAGE().add(languagesStringKeineAbspielbarenLiederEN);
    languagesStringKeineAbspielbarenLieder.getLANGUAGE().add(languagesStringKeineAbspielbarenLiederES);
    commandStringKeineAbspielbarenLieder.setLANGUAGES(languagesStringKeineAbspielbarenLieder);

    COMMAND commandStringDerZufallsmodus = new COMMAND();
    commandStringDerZufallsmodus.setKEY(KEY.STRING_DER_ZUFALLSMODUS_WIRD_ABGESCHALTET);
    LANGUAGES languagesStringDerZufallsmodus = new LANGUAGES();
    LANGUAGE languagesStringDerZufallsmodusDE = new LANGUAGE();
    languagesStringDerZufallsmodusDE.setISO639(ISO639.DE);
    languagesStringDerZufallsmodusDE.setTEXT("Der Zufallsmodus wurde abgeschaltet.");

    LANGUAGE languagesStringDerZufallsmodusEN = new LANGUAGE();
    languagesStringDerZufallsmodusEN.setISO639(ISO639.EN);
    languagesStringDerZufallsmodusEN.setTEXT("The random mode has been turned off.");

    LANGUAGE languagesStringDerZufallsmodusES = new LANGUAGE();
    languagesStringDerZufallsmodusES.setISO639(ISO639.ES);
    languagesStringDerZufallsmodusES.setTEXT("El modo aleatorio se ha desactivado.");

    languagesStringDerZufallsmodus.getLANGUAGE().add(languagesStringDerZufallsmodusDE);
    languagesStringDerZufallsmodus.getLANGUAGE().add(languagesStringDerZufallsmodusEN);
    languagesStringDerZufallsmodus.getLANGUAGE().add(languagesStringDerZufallsmodusES);
    commandStringDerZufallsmodus.setLANGUAGES(languagesStringDerZufallsmodus);

    COMMAND commandStringAlleMusikstuecke = new COMMAND();
    commandStringAlleMusikstuecke.setKEY(KEY.STRING_ALLE_MUSIKSTUECKE);
    LANGUAGES languagesStringAlleMusikstuecke = new LANGUAGES();

    LANGUAGE languagesStringAlleMusikstueckeDE = new LANGUAGE();
    languagesStringAlleMusikstueckeDE.setISO639(ISO639.DE);
    languagesStringAlleMusikstueckeDE.setTEXT("Alle Musikstücke wurden abgespielt.");

    LANGUAGE languagesStringAlleMusikstueckeEN = new LANGUAGE();
    languagesStringAlleMusikstueckeEN.setISO639(ISO639.EN);
    languagesStringAlleMusikstueckeEN.setTEXT("All pieces of music were played.");

    LANGUAGE languagesStringAlleMusikstueckeES = new LANGUAGE();
    languagesStringAlleMusikstueckeES.setISO639(ISO639.ES);
    languagesStringAlleMusikstueckeES.setTEXT("Toda la música fue tocada.");

    languagesStringAlleMusikstuecke.getLANGUAGE().add(languagesStringAlleMusikstueckeDE);
    languagesStringAlleMusikstuecke.getLANGUAGE().add(languagesStringAlleMusikstueckeEN);
    languagesStringAlleMusikstuecke.getLANGUAGE().add(languagesStringAlleMusikstueckeES);
    commandStringAlleMusikstuecke.setLANGUAGES(languagesStringAlleMusikstuecke);

    COMMAND commandStringMusikkisteIstLeer = new COMMAND();
    commandStringMusikkisteIstLeer.setKEY(KEY.STRING_DIE_MUSIKKISTE_IST_LEER);
    LANGUAGES languagesStringMusikkisteIstLeer = new LANGUAGES();
    LANGUAGE languagesStringMusikkisteIstLeerDE = new LANGUAGE();
    languagesStringMusikkisteIstLeerDE.setISO639(ISO639.DE);
    languagesStringMusikkisteIstLeerDE.setTEXT("Die Musikbox ist leer");

    LANGUAGE languagesStringMusikkisteIstLeerEN = new LANGUAGE();
    languagesStringMusikkisteIstLeerEN.setISO639(ISO639.EN);
    languagesStringMusikkisteIstLeerEN.setTEXT("The music box is empty.");

    LANGUAGE languagesStringMusikkisteIstLeerES = new LANGUAGE();
    languagesStringMusikkisteIstLeerES.setISO639(ISO639.ES);
    languagesStringMusikkisteIstLeerES.setTEXT("La caja de música está vacía.");

    languagesStringMusikkisteIstLeer.getLANGUAGE().add(languagesStringMusikkisteIstLeerDE);
    languagesStringMusikkisteIstLeer.getLANGUAGE().add(languagesStringMusikkisteIstLeerEN);
    languagesStringMusikkisteIstLeer.getLANGUAGE().add(languagesStringMusikkisteIstLeerES);
    commandStringMusikkisteIstLeer.setLANGUAGES(languagesStringMusikkisteIstLeer);

    COMMAND commandStringAlleWiedergabelisten = new COMMAND();
    commandStringAlleWiedergabelisten.setKEY(KEY.STRING_ALLE_WIEDERGABELISTEN);
    LANGUAGES languagesStringAlleWiedergabelisten = new LANGUAGES();
    LANGUAGE languagesStringAlleWiedergabelistenDE = new LANGUAGE();
    languagesStringAlleWiedergabelistenDE.setISO639(ISO639.DE);
    languagesStringAlleWiedergabelistenDE.setTEXT("Alle Wiedergabelisten löschen");

    LANGUAGE languagesStringAlleWiedergabelistenEN = new LANGUAGE();
    languagesStringAlleWiedergabelistenEN.setISO639(ISO639.EN);
    languagesStringAlleWiedergabelistenEN.setTEXT("Remove all playlists");

    LANGUAGE languagesStringAlleWiedergabelistenES = new LANGUAGE();
    languagesStringAlleWiedergabelistenES.setISO639(ISO639.ES);
    languagesStringAlleWiedergabelistenES.setTEXT("Eliminar todas las Listas de reproducción");

    languagesStringAlleWiedergabelisten.getLANGUAGE().add(languagesStringAlleWiedergabelistenDE);
    languagesStringAlleWiedergabelisten.getLANGUAGE().add(languagesStringAlleWiedergabelistenEN);
    languagesStringAlleWiedergabelisten.getLANGUAGE().add(languagesStringAlleWiedergabelistenES);
    commandStringAlleWiedergabelisten.setLANGUAGES(languagesStringAlleWiedergabelisten);

    COMMAND commandLabelStartmodus = new COMMAND();
    commandLabelStartmodus.setKEY(KEY.LABEL_STARTMODUS);
    LANGUAGES languagesLabelStartmodus = new LANGUAGES();

    LANGUAGE languagesLabelStartmodusDE = new LANGUAGE();
    languagesLabelStartmodusDE.setISO639(ISO639.DE);
    languagesLabelStartmodusDE.setTEXT("Startmodus:");

    LANGUAGE languagesLabelStartmodusEN = new LANGUAGE();
    languagesLabelStartmodusEN.setISO639(ISO639.EN);
    languagesLabelStartmodusEN.setTEXT("Startup Mode:");

    LANGUAGE languagesLabelStartmodusES = new LANGUAGE();
    languagesLabelStartmodusES.setISO639(ISO639.ES);
    languagesLabelStartmodusES.setTEXT("Modo de inicio:");

    languagesLabelStartmodus.getLANGUAGE().add(languagesLabelStartmodusDE);
    languagesLabelStartmodus.getLANGUAGE().add(languagesLabelStartmodusEN);
    languagesLabelStartmodus.getLANGUAGE().add(languagesLabelStartmodusES);
    commandLabelStartmodus.setLANGUAGES(languagesLabelStartmodus);

    COMMAND commandLabelServiceStatus = new COMMAND();
    commandLabelServiceStatus.setKEY(KEY.LABEL_SERVICE_STATUS);
    LANGUAGES languagesLabelServiceStatus = new LANGUAGES();

    LANGUAGE languagesLabelServiceStatusDE = new LANGUAGE();
    languagesLabelServiceStatusDE.setISO639(ISO639.DE);
    languagesLabelServiceStatusDE.setTEXT("Der Service");

    LANGUAGE languagesLabelServiceStatusEN = new LANGUAGE();
    languagesLabelServiceStatusEN.setISO639(ISO639.EN);
    languagesLabelServiceStatusEN.setTEXT("The Service");

    LANGUAGE languagesLabelServiceStatusES = new LANGUAGE();
    languagesLabelServiceStatusES.setISO639(ISO639.ES);
    languagesLabelServiceStatusES.setTEXT("El servicio");

    languagesLabelServiceStatus.getLANGUAGE().add(languagesLabelServiceStatusDE);
    languagesLabelServiceStatus.getLANGUAGE().add(languagesLabelServiceStatusEN);
    languagesLabelServiceStatus.getLANGUAGE().add(languagesLabelServiceStatusES);
    commandLabelServiceStatus.setLANGUAGES(languagesLabelServiceStatus);

    COMMAND commandLabelAngehalten = new COMMAND();
    commandLabelAngehalten.setKEY(KEY.LABEL_ANGEHALTEN);
    LANGUAGES languagesLabelAngehalten = new LANGUAGES();

    LANGUAGE languagesLabelAngehaltenDE = new LANGUAGE();
    languagesLabelAngehaltenDE.setISO639(ISO639.DE);
    languagesLabelAngehaltenDE.setTEXT("wurde angehalten");

    LANGUAGE languagesLabelAngehaltenEN = new LANGUAGE();
    languagesLabelAngehaltenEN.setISO639(ISO639.EN);
    languagesLabelAngehaltenEN.setTEXT("has stopped");

    LANGUAGE languagesLabelAngehaltenES = new LANGUAGE();
    languagesLabelAngehaltenES.setISO639(ISO639.ES);
    languagesLabelAngehaltenES.setTEXT("se ha detenido");

    languagesLabelAngehalten.getLANGUAGE().add(languagesLabelAngehaltenDE);
    languagesLabelAngehalten.getLANGUAGE().add(languagesLabelAngehaltenEN);
    languagesLabelAngehalten.getLANGUAGE().add(languagesLabelAngehaltenES);
    commandLabelAngehalten.setLANGUAGES(languagesLabelAngehalten);

    COMMAND commandLabelAufport = new COMMAND();
    commandLabelAufport.setKEY(KEY.LABEL_AUF_PORT);
    LANGUAGES languagesLabelAufport = new LANGUAGES();

    LANGUAGE languagesLabelAufportDE = new LANGUAGE();
    languagesLabelAufportDE.setISO639(ISO639.DE);
    languagesLabelAufportDE.setTEXT("auf Port");

    LANGUAGE languagesLabelAufportEN = new LANGUAGE();
    languagesLabelAufportEN.setISO639(ISO639.EN);
    languagesLabelAufportEN.setTEXT("on port");

    LANGUAGE languagesLabelAufportES = new LANGUAGE();
    languagesLabelAufportES.setISO639(ISO639.ES);
    languagesLabelAufportES.setTEXT("en el puerto");

    languagesLabelAufport.getLANGUAGE().add(languagesLabelAufportDE);
    languagesLabelAufport.getLANGUAGE().add(languagesLabelAufportEN);
    languagesLabelAufport.getLANGUAGE().add(languagesLabelAufportES);

    commandLabelAufport.setLANGUAGES(languagesLabelAufport);

    COMMAND commandLabelGestartet = new COMMAND();
    commandLabelGestartet.setKEY(KEY.LABEL_GESTARTET);
    LANGUAGES languagesLabelGestartet = new LANGUAGES();

    LANGUAGE languagesLabelGestartetDE = new LANGUAGE();
    languagesLabelGestartetDE.setISO639(ISO639.DE);
    languagesLabelGestartetDE.setTEXT("wurde gestartet");

    LANGUAGE languagesLabelGestartetEN = new LANGUAGE();
    languagesLabelGestartetEN.setISO639(ISO639.EN);
    languagesLabelGestartetEN.setTEXT("has started");

    LANGUAGE languagesLabelGestartetES = new LANGUAGE();
    languagesLabelGestartetES.setISO639(ISO639.ES);
    languagesLabelGestartetES.setTEXT("se ha iniciado");

    languagesLabelGestartet.getLANGUAGE().add(languagesLabelGestartetDE);
    languagesLabelGestartet.getLANGUAGE().add(languagesLabelGestartetEN);
    languagesLabelGestartet.getLANGUAGE().add(languagesLabelGestartetES);
    commandLabelGestartet.setLANGUAGES(languagesLabelGestartet);

    COMMAND commandStringVonHandAus = new COMMAND();
    commandStringVonHandAus.setKEY(KEY.STRING_VON_HAND_AUS_STARTEN);
    LANGUAGES languagesStringVonHandAus = new LANGUAGES();
    LANGUAGE languagesStringVonHandAusDE = new LANGUAGE();
    languagesStringVonHandAusDE.setISO639(ISO639.DE);
    languagesStringVonHandAusDE.setTEXT("von Hand aus starten");

    LANGUAGE languagesStringVonHandAusEN = new LANGUAGE();
    languagesStringVonHandAusEN.setISO639(ISO639.EN);
    languagesStringVonHandAusEN.setTEXT("start manually");

    LANGUAGE languagesStringVonHandAusES = new LANGUAGE();
    languagesStringVonHandAusES.setISO639(ISO639.ES);
    languagesStringVonHandAusES.setTEXT("iniciar manualmente");

    languagesStringVonHandAus.getLANGUAGE().add(languagesStringVonHandAusDE);
    languagesStringVonHandAus.getLANGUAGE().add(languagesStringVonHandAusEN);
    languagesStringVonHandAus.getLANGUAGE().add(languagesStringVonHandAusES);
    commandStringVonHandAus.setLANGUAGES(languagesStringVonHandAus);

    COMMAND commandStringAutomatischStarten = new COMMAND();
    commandStringAutomatischStarten.setKEY(KEY.STRING_AUTOMATISCH_NACH_JEDEM_PROGRAMMSTART);
    LANGUAGES languagesStringAutomatischStarten = new LANGUAGES();
    LANGUAGE languagesStringAutomatischStartenDE = new LANGUAGE();
    languagesStringAutomatischStartenDE.setISO639(ISO639.DE);
    languagesStringAutomatischStartenDE.setTEXT("automatisch nach jedem Programmstart");

    LANGUAGE languagesStringAutomatischStartenEN = new LANGUAGE();
    languagesStringAutomatischStartenEN.setISO639(ISO639.EN);
    languagesStringAutomatischStartenEN.setTEXT("automatically after each program start");

    LANGUAGE languagesStringAutomatischStartenES = new LANGUAGE();
    languagesStringAutomatischStartenES.setISO639(ISO639.ES);
    languagesStringAutomatischStartenES.setTEXT("automáticamente después de cada inicio del programa");

    languagesStringAutomatischStarten.getLANGUAGE().add(languagesStringAutomatischStartenDE);
    languagesStringAutomatischStarten.getLANGUAGE().add(languagesStringAutomatischStartenEN);
    languagesStringAutomatischStarten.getLANGUAGE().add(languagesStringAutomatischStartenES);
    commandStringAutomatischStarten.setLANGUAGES(languagesStringAutomatischStarten);

    COMMAND commandFrameFileSharing = new COMMAND();
    commandFrameFileSharing.setKEY(KEY.FRAME_FILESHARING);
    LANGUAGES languagesFrameFileSharing = new LANGUAGES();
    LANGUAGE languagesFrameFileSharingDE = new LANGUAGE();
    languagesFrameFileSharingDE.setISO639(ISO639.DE);
    languagesFrameFileSharingDE.setTEXT("Filesharing");

    LANGUAGE languagesFrameFileSharingEN = new LANGUAGE();
    languagesFrameFileSharingEN.setISO639(ISO639.EN);
    languagesFrameFileSharingEN.setTEXT("File Sharing");

    LANGUAGE languagesFrameFileSharingES = new LANGUAGE();
    languagesFrameFileSharingES.setISO639(ISO639.ES);
    languagesFrameFileSharingES.setTEXT("Compartir archivos");

    languagesFrameFileSharing.getLANGUAGE().add(languagesFrameFileSharingDE);
    languagesFrameFileSharing.getLANGUAGE().add(languagesFrameFileSharingEN);
    languagesFrameFileSharing.getLANGUAGE().add(languagesFrameFileSharingES);
    commandFrameFileSharing.setLANGUAGES(languagesFrameFileSharing);

    COMMAND commandGruppenraeume = new COMMAND();
    commandGruppenraeume.setKEY(KEY.GRUPPENRAUM_EINRICHTEN);
    LANGUAGES languagesMenuItemGruppenraeume = new LANGUAGES();
    LANGUAGE languagesMenuItemGruppenraeumeDE = new LANGUAGE();
    languagesMenuItemGruppenraeumeDE.setISO639(ISO639.DE);
    languagesMenuItemGruppenraeumeDE.setTEXT("Gruppenraum einrichten");

    LANGUAGE languagesMenuItemGruppenraeumeEN = new LANGUAGE();
    languagesMenuItemGruppenraeumeEN.setISO639(ISO639.EN);
    languagesMenuItemGruppenraeumeEN.setTEXT("Create Group Room");

    LANGUAGE languagesMenuItemGruppenraeumeES = new LANGUAGE();
    languagesMenuItemGruppenraeumeES.setISO639(ISO639.ES);
    languagesMenuItemGruppenraeumeES.setTEXT("Crear sala de grupo");

    languagesMenuItemGruppenraeume.getLANGUAGE().add(languagesMenuItemGruppenraeumeDE);
    languagesMenuItemGruppenraeume.getLANGUAGE().add(languagesMenuItemGruppenraeumeEN);
    languagesMenuItemGruppenraeume.getLANGUAGE().add(languagesMenuItemGruppenraeumeES);
    commandGruppenraeume.setLANGUAGES(languagesMenuItemGruppenraeume);

    COMMAND commandServerProfilGespeichert = new COMMAND();
    commandServerProfilGespeichert.setKEY(KEY.SERVER_PROFIL_GESPEICHERT);
    LANGUAGES languagesProfilGespeichert = new LANGUAGES();
    LANGUAGE languagesProfilGespeichertDE = new LANGUAGE();
    languagesProfilGespeichertDE.setISO639(ISO639.DE);
    languagesProfilGespeichertDE.setTEXT("Deine Daten wurden gespeichert.");

    LANGUAGE languagesProfilGespeichertEN = new LANGUAGE();
    languagesProfilGespeichertEN.setISO639(ISO639.EN);
    languagesProfilGespeichertEN.setTEXT("Your data has been saved.");

    LANGUAGE languagesProfilGespeichertES = new LANGUAGE();
    languagesProfilGespeichertES.setISO639(ISO639.ES);
    languagesProfilGespeichertES.setTEXT("Tus datos han sido guardados.");

    languagesProfilGespeichert.getLANGUAGE().add(languagesProfilGespeichertDE);
    languagesProfilGespeichert.getLANGUAGE().add(languagesProfilGespeichertEN);
    languagesProfilGespeichert.getLANGUAGE().add(languagesProfilGespeichertES);
    commandServerProfilGespeichert.setLANGUAGES(languagesProfilGespeichert);

    COMMAND commandServerProfilNichtGespeichert = new COMMAND();
    commandServerProfilNichtGespeichert.setKEY(KEY.SERVER_PROFIL_NICHT_GESPEICHERT);
    LANGUAGES languagesProfilNichtGespeichert = new LANGUAGES();

    LANGUAGE languagesProfilNichtGespeichertDE = new LANGUAGE();
    languagesProfilNichtGespeichertDE.setISO639(ISO639.DE);
    languagesProfilNichtGespeichertDE.setTEXT("Deine Daten wurden nicht gespeichert.");

    LANGUAGE languagesProfilNichtGespeichertEN = new LANGUAGE();
    languagesProfilNichtGespeichertEN.setISO639(ISO639.EN);
    languagesProfilNichtGespeichertEN.setTEXT("Your data has not been saved.");

    LANGUAGE languagesProfilNichtGespeichertES = new LANGUAGE();
    languagesProfilNichtGespeichertES.setISO639(ISO639.ES);
    languagesProfilNichtGespeichertES.setTEXT("Tus datos no se han sido guardados.");

    languagesProfilNichtGespeichert.getLANGUAGE().add(languagesProfilNichtGespeichertDE);
    languagesProfilNichtGespeichert.getLANGUAGE().add(languagesProfilNichtGespeichertEN);
    languagesProfilNichtGespeichert.getLANGUAGE().add(languagesProfilNichtGespeichertES);
    commandServerProfilNichtGespeichert.setLANGUAGES(languagesProfilNichtGespeichert);

    COMMAND commandServerKontodaten = new COMMAND();
    commandServerKontodaten.setKEY(KEY.SERVER_KONTODATEN);
    LANGUAGES languagesKontodaten = new LANGUAGES();
    LANGUAGE languagesKontodatenDE = new LANGUAGE();
    languagesKontodatenDE.setISO639(ISO639.DE);
    languagesKontodatenDE.setTEXT("Kontodaten");

    LANGUAGE languagesKontodatenEN = new LANGUAGE();
    languagesKontodatenEN.setISO639(ISO639.EN);
    languagesKontodatenEN.setTEXT("Account data");

    LANGUAGE languagesKontodatenES = new LANGUAGE();
    languagesKontodatenES.setISO639(ISO639.ES);
    languagesKontodatenES.setTEXT("Datos de la cuenta");

    languagesKontodaten.getLANGUAGE().add(languagesKontodatenDE);
    languagesKontodaten.getLANGUAGE().add(languagesKontodatenEN);
    languagesKontodaten.getLANGUAGE().add(languagesKontodatenES);
    commandServerKontodaten.setLANGUAGES(languagesKontodaten);

    COMMAND commandServerEmailInvalid = new COMMAND();
    commandServerEmailInvalid.setKEY(KEY.SERVER_EMAIL_INVALID);
    LANGUAGES languagesEmailInvalid = new LANGUAGES();
    LANGUAGE languagesEmailInvalidDE = new LANGUAGE();
    languagesEmailInvalidDE.setISO639(ISO639.DE);
    languagesEmailInvalidDE.setTEXT("Deine E-Mail Adresse ist ungültig.");

    languagesEmailInvalid.getLANGUAGE().add(languagesEmailInvalidDE);

    LANGUAGE languagesEmailInvalidEN = new LANGUAGE();
    languagesEmailInvalidEN.setISO639(ISO639.EN);
    languagesEmailInvalidEN.setTEXT("Your email address is invalid.");
    languagesEmailInvalid.getLANGUAGE().add(languagesEmailInvalidEN);

    LANGUAGE languagesEmailInvalidES = new LANGUAGE();
    languagesEmailInvalidES.setISO639(ISO639.ES);
    languagesEmailInvalidES.setTEXT("Tu dirección de correo electrónico no es válida.");
    languagesEmailInvalid.getLANGUAGE().add(languagesEmailInvalidES);
    commandServerEmailInvalid.setLANGUAGES(languagesEmailInvalid);

    COMMAND commandServerNeuesPassword = new COMMAND();
    commandServerNeuesPassword.setKEY(KEY.SERVER_NEUES_PASSWORT);
    LANGUAGES languagesNeuesPasswort = new LANGUAGES();
    LANGUAGE languageNeuesPasswortDE = new LANGUAGE();
    languageNeuesPasswortDE.setISO639(ISO639.DE);
    languageNeuesPasswortDE.setTEXT(
        "Wir haben dir ein neues Passwort geschickt. Schaue in deinem Postfach nach und bestätige das Passwort. Solange du das neue Passwort nicht bestätigst, bleibt dein altes Passwort gültig."
    );
    LANGUAGE languageNeuesPasswortEN = new LANGUAGE();
    languageNeuesPasswortEN.setISO639(ISO639.EN);
    languageNeuesPasswortEN.setTEXT(
        "We have sent you a new password. Check your inbox and confirm the password. As long as you do not confirm the new password, your old password will remain valid."
    );

    LANGUAGE languageNeuesPasswortES = new LANGUAGE();
    languageNeuesPasswortES.setISO639(ISO639.ES);
    languageNeuesPasswortES.setTEXT(
        "Te hemos enviado una nueva contraseña. Compruebe tu buzón y confirma la contraseña. "
            + "Mientras no confirmes la nueva contraseña, tu antigua contraseña seguirá siendo válida."
    );

    languagesNeuesPasswort.getLANGUAGE().add(languageNeuesPasswortDE);
    languagesNeuesPasswort.getLANGUAGE().add(languageNeuesPasswortEN);
    languagesNeuesPasswort.getLANGUAGE().add(languageNeuesPasswortES);
    commandServerNeuesPassword.setLANGUAGES(languagesNeuesPasswort);

    COMMAND commandServerWebconfirmPassword = new COMMAND();
    commandServerWebconfirmPassword.setKEY(KEY.SERVER_WEBCONFIRM_PASSWORT);
    LANGUAGES languagesWebconfirmPasswort = new LANGUAGES();
    LANGUAGE languageWebconfirmPasswortDE = new LANGUAGE();
    languageWebconfirmPasswortDE.setISO639(ISO639.DE);
    languageWebconfirmPasswortDE.setTEXT(
        "Eine E-Mail mit einem Passwort ist unterwegs. Überprüfe deinen Eingangsordner. Falls nichts angekommen ist, schaue im Papierkorb nach."
    );

    LANGUAGE languageWebconfirmPasswortEN = new LANGUAGE();
    languageWebconfirmPasswortEN.setISO639(ISO639.EN);
    languageWebconfirmPasswortEN.setTEXT(
        "An email with a password is on the way. Check your inbox folder. If nothing has arrived, check the trash."
    );
    LANGUAGE languageWebconfirmPasswortES = new LANGUAGE();
    languageWebconfirmPasswortES.setISO639(ISO639.ES);
    languageWebconfirmPasswortES.setTEXT(
        "Un correo electrónico con una contraseña está en camino. Comprueba tu carpeta de entrada. Si no ha llegado nada, revisa la basura."
    );
    languagesWebconfirmPasswort.getLANGUAGE().add(languageWebconfirmPasswortDE);
    languagesWebconfirmPasswort.getLANGUAGE().add(languageWebconfirmPasswortEN);
    languagesWebconfirmPasswort.getLANGUAGE().add(languageWebconfirmPasswortES);
    commandServerWebconfirmPassword.setLANGUAGES(languagesWebconfirmPasswort);

    COMMAND commandServerConfirmPassword = new COMMAND();
    commandServerConfirmPassword.setKEY(KEY.SERVER_CONFIRM_PASSWORT);
    LANGUAGES languagesConfirmPasswort = new LANGUAGES();
    LANGUAGE languageConfirmPasswortDE = new LANGUAGE();
    languageConfirmPasswortDE.setISO639(ISO639.DE);
    languageConfirmPasswortDE.setTEXT(
        "Eine E-Mail mit einem Passwort ist unterwegs. " + "Überprüfe deinen Eingangsordner. "
            + "Falls nichts angekommen ist, schaue im Papierkorb nach. "
            + "Wenn du im nächsten Schritt auf 'Abbrechen' klickst, wirst du automatisch angemeldet. "
            + "Ändere als nächstes dein Passwort über das Menu 'Konto/Berabeiten'."
    );

    LANGUAGE languageConfirmPasswortEN = new LANGUAGE();
    languageConfirmPasswortEN.setISO639(ISO639.EN);
    languageConfirmPasswortEN.setTEXT(
        "An email with a password is on the way. "
            + "Check your inbox folder. If nothing has arrived, check the trash. "
            + "If you click on 'Cancel' in the next step, you will be logged in automatically. "
            + "Next, change your password via the menu 'Account/Edit'."
    );

    LANGUAGE languageConfirmPasswortES = new LANGUAGE();
    languageConfirmPasswortES.setISO639(ISO639.ES);
    languageConfirmPasswortES.setTEXT(
        "Un correo electrónico con una contraseña está en camino. "
            + "Comprueba tu carpeta de entrada. Si no ha llegado nada, revisa la basura. "
            + "Si hace clic en 'Cancelar' en el siguiente paso, se registrará automáticamente. "
            + "A continuación, cambia tu contraseña a través del menú 'Cuenta/Editar'."
    );

    languagesConfirmPasswort.getLANGUAGE().add(languageConfirmPasswortDE);
    languagesConfirmPasswort.getLANGUAGE().add(languageConfirmPasswortEN);
    languagesConfirmPasswort.getLANGUAGE().add(languageConfirmPasswortES);
    commandServerConfirmPassword.setLANGUAGES(languagesConfirmPasswort);

    COMMAND commandStringEsgehtGleichWeiter = new COMMAND();
    commandStringEsgehtGleichWeiter.setKEY(KEY.STRING_ES_GEHT_GLEICH_WEITER);
    LANGUAGES languagesEsGehtGleichWeiter = new LANGUAGES();
    LANGUAGE languageEsGehtGleichWeiterDE = new LANGUAGE();
    languageEsGehtGleichWeiterDE.setISO639(ISO639.DE);
    languageEsGehtGleichWeiterDE.setTEXT("Es geht gleich weiter...");

    LANGUAGE languageEsGehtGleichWeiterEN = new LANGUAGE();
    languageEsGehtGleichWeiterEN.setISO639(ISO639.EN);
    languageEsGehtGleichWeiterEN.setTEXT("Continues in a moment...");

    LANGUAGE languageEsGehtGleichWeiterES = new LANGUAGE();
    languageEsGehtGleichWeiterES.setISO639(ISO639.ES);
    languageEsGehtGleichWeiterES.setTEXT("Continúa en un momento...");

    languagesEsGehtGleichWeiter.getLANGUAGE().add(languageEsGehtGleichWeiterDE);
    languagesEsGehtGleichWeiter.getLANGUAGE().add(languageEsGehtGleichWeiterEN);
    languagesEsGehtGleichWeiter.getLANGUAGE().add(languageEsGehtGleichWeiterES);
    commandStringEsgehtGleichWeiter.setLANGUAGES(languagesEsGehtGleichWeiter);

    COMMAND commandStringPasswortAnfordern = new COMMAND();
    commandStringPasswortAnfordern.setKEY(KEY.STRING_PASSWORT_ANFORDERN);
    LANGUAGES languagesPasswortAnfordern = new LANGUAGES();
    LANGUAGE languagePasswortAnfordernDE = new LANGUAGE();
    languagePasswortAnfordernDE.setISO639(ISO639.DE);
    languagePasswortAnfordernDE.setTEXT("Passwort anfordern");

    LANGUAGE languagePasswortAnfordernEN = new LANGUAGE();
    languagePasswortAnfordernEN.setISO639(ISO639.EN);
    languagePasswortAnfordernEN.setTEXT("Request password");

    LANGUAGE languagePasswortAnfordernES = new LANGUAGE();
    languagePasswortAnfordernES.setISO639(ISO639.ES);
    languagePasswortAnfordernES.setTEXT("Solicitar contraseña");

    languagesPasswortAnfordern.getLANGUAGE().add(languagePasswortAnfordernDE);
    languagesPasswortAnfordern.getLANGUAGE().add(languagePasswortAnfordernEN);
    languagesPasswortAnfordern.getLANGUAGE().add(languagePasswortAnfordernES);
    commandStringPasswortAnfordern.setLANGUAGES(languagesPasswortAnfordern);

    COMMAND commandServerErstanmeldung = new COMMAND();
    commandServerErstanmeldung.setKEY(KEY.SERVER_MAIL_ERSTANMELDUNG);
    LANGUAGES languagesMailErstanmeldung = new LANGUAGES();

    LANGUAGE languageMailErstanmeldungDE = new LANGUAGE();
    languageMailErstanmeldungDE.setISO639(ISO639.DE);
    languageMailErstanmeldungDE.setTEXT(
        "\r\n" + "Benutzer-ID und Passwort beginnen nach dem Doppelpunkt."
            + "\r\n"
            + "\r\n"
            + "Benutzer-ID:XXX"
            + "\r\n"
            + "Passwort:YYY"
    );

    LANGUAGE languageMailErstanmeldungEN = new LANGUAGE();
    languageMailErstanmeldungEN.setISO639(ISO639.EN);
    languageMailErstanmeldungEN.setTEXT(
        "\r\n" + "User ID and password start after the colon."
            + "\r\n"
            + "\r\n"
            + "User ID:XXX"
            + "\r\n"
            + "Password:YYY"
    );

    LANGUAGE languageMailErstanmeldungES = new LANGUAGE();
    languageMailErstanmeldungES.setISO639(ISO639.ES);
    languageMailErstanmeldungES.setTEXT(
        "\r\n" + "El ID de usuario y la contraseña comienzan después de los dos puntos."
            + "\r\n"
            + "\r\n"
            + "ID de usuario:XXX"
            + "\r\n"
            + "Contraseña:YYY"
    );

    languagesMailErstanmeldung.getLANGUAGE().add(languageMailErstanmeldungDE);
    languagesMailErstanmeldung.getLANGUAGE().add(languageMailErstanmeldungEN);
    languagesMailErstanmeldung.getLANGUAGE().add(languageMailErstanmeldungES);
    commandServerErstanmeldung.setLANGUAGES(languagesMailErstanmeldung);

    COMMAND commandServerMailBetreff = new COMMAND();
    commandServerMailBetreff.setKEY(KEY.SERVER_MAIL_BETREFF);
    LANGUAGES languagesServerMailBetreff = new LANGUAGES();
    LANGUAGE languageServerMailBetreffDE = new LANGUAGE();
    languageServerMailBetreffDE.setISO639(ISO639.DE);
    languageServerMailBetreffDE.setTEXT("JavaComm Registrierung");

    LANGUAGE languageServerMailBetreffEN = new LANGUAGE();
    languageServerMailBetreffEN.setISO639(ISO639.EN);
    languageServerMailBetreffEN.setTEXT("JavaComm Registration");

    LANGUAGE languageServerMailBetreffES = new LANGUAGE();
    languageServerMailBetreffES.setISO639(ISO639.ES);
    languageServerMailBetreffES.setTEXT("JavaComm Registrarse");

    languagesServerMailBetreff.getLANGUAGE().add(languageServerMailBetreffDE);
    languagesServerMailBetreff.getLANGUAGE().add(languageServerMailBetreffEN);
    languagesServerMailBetreff.getLANGUAGE().add(languageServerMailBetreffES);
    commandServerMailBetreff.setLANGUAGES(languagesServerMailBetreff);

    COMMAND commandServerDasNeuePasswort = new COMMAND();
    commandServerDasNeuePasswort.setKEY(KEY.SERVER_MAIL_DAS_NEUE_PASSWORT);
    LANGUAGES languagesServerDasNeuePasswort = new LANGUAGES();
    LANGUAGE languageServerDasNeuePasswortDE = new LANGUAGE();
    languageServerDasNeuePasswortDE.setISO639(ISO639.DE);
    languageServerDasNeuePasswortDE
        .setTEXT("Das neue Passwort wird mit einem Klick auf die nachfolgende Adresse bestätigt.");

    LANGUAGE languageServerDasNeuePasswortEN = new LANGUAGE();
    languageServerDasNeuePasswortEN.setISO639(ISO639.EN);
    languageServerDasNeuePasswortEN
        .setTEXT("The new password is confirmed by clicking on the address below.");

    LANGUAGE languageServerDasNeuePasswortES = new LANGUAGE();
    languageServerDasNeuePasswortES.setISO639(ISO639.ES);
    languageServerDasNeuePasswortES
        .setTEXT("La nueva contraseña se confirma haciendo clic en la dirección de abajo.");

    languagesServerDasNeuePasswort.getLANGUAGE().add(languageServerDasNeuePasswortDE);
    languagesServerDasNeuePasswort.getLANGUAGE().add(languageServerDasNeuePasswortEN);
    languagesServerDasNeuePasswort.getLANGUAGE().add(languageServerDasNeuePasswortES);
    commandServerDasNeuePasswort.setLANGUAGES(languagesServerDasNeuePasswort);

    COMMAND commandServerDasAltePasswort = new COMMAND();
    commandServerDasAltePasswort.setKEY(KEY.SERVER_MAIL_DAS_ALTE_PASSWORT);
    LANGUAGES languagesServerDasAltePasswort = new LANGUAGES();
    LANGUAGE languageServerDasAltePasswortDE = new LANGUAGE();
    languageServerDasAltePasswortDE.setISO639(ISO639.DE);
    languageServerDasAltePasswortDE.setTEXT(
        "Das alte Passwort bleibt erhalten, wenn auf den Link nicht innerhalb der nächsten Stunde geklickt wird."
    );

    languagesServerDasAltePasswort.getLANGUAGE().add(languageServerDasAltePasswortDE);
    LANGUAGE languageServerDasAltePasswortEN = new LANGUAGE();
    languageServerDasAltePasswortEN
        .setTEXT("The old password will be retained if the link is not clicked within the next hour.");
    languageServerDasAltePasswortEN.setISO639(ISO639.EN);

    languagesServerDasAltePasswort.getLANGUAGE().add(languageServerDasAltePasswortEN);
    LANGUAGE languageServerDasAltePasswortES = new LANGUAGE();
    languageServerDasAltePasswortES.setISO639(ISO639.ES);
    languageServerDasAltePasswortES
        .setTEXT("La antigua contraseña se conservará si no se hace clic en el enlace en la siguiente hora.");

    languagesServerDasAltePasswort.getLANGUAGE().add(languageServerDasAltePasswortES);
    commandServerDasAltePasswort.setLANGUAGES(languagesServerDasAltePasswort);

    COMMAND commandStringMitgliedschaft = new COMMAND();
    commandStringMitgliedschaft.setKEY(KEY.STRING_MITGLIEDSCHAFT_WIRD_BAERABEITET);
    LANGUAGES languagesStringMitgliedschaft = new LANGUAGES();
    LANGUAGE languageStringMitgliedschaftDE = new LANGUAGE();
    languageStringMitgliedschaftDE.setISO639(ISO639.DE);
    languageStringMitgliedschaftDE.setTEXT("Deine Mitgliedschaft wird bearbeitet.");

    LANGUAGE languageStringMitgliedschaftEN = new LANGUAGE();
    languageStringMitgliedschaftEN.setISO639(ISO639.EN);
    languageStringMitgliedschaftEN.setTEXT("Your membership is processed.");

    LANGUAGE languageStringMitgliedschaftES = new LANGUAGE();
    languageStringMitgliedschaftES.setISO639(ISO639.ES);
    languageStringMitgliedschaftES.setTEXT("Se está procesando tu afilicatión.");

    languagesStringMitgliedschaft.getLANGUAGE().add(languageStringMitgliedschaftDE);
    languagesStringMitgliedschaft.getLANGUAGE().add(languageStringMitgliedschaftEN);
    languagesStringMitgliedschaft.getLANGUAGE().add(languageStringMitgliedschaftES);
    commandStringMitgliedschaft.setLANGUAGES(languagesStringMitgliedschaft);

    COMMAND commandStringMitgliedschaftBestaetigt = new COMMAND();
    commandStringMitgliedschaftBestaetigt.setKEY(KEY.STRING_MITGLIEDSCHAFT_BESTAETIGT);
    LANGUAGES languagesMitgliedschaftBestaetigt = new LANGUAGES();
    LANGUAGE languageStringMitgliedschaftBestaetigtDE = new LANGUAGE();
    languageStringMitgliedschaftBestaetigtDE.setISO639(ISO639.DE);
    languageStringMitgliedschaftBestaetigtDE
        .setTEXT("Deine Mitgliedschaft ist bestätigt. Du bekommst in Kürze eine EMail mit den Zugangsdaten.");

    LANGUAGE languageStringMitgliedschaftBestaetigtEN = new LANGUAGE();
    languageStringMitgliedschaftBestaetigtEN.setISO639(ISO639.EN);
    languageStringMitgliedschaftBestaetigtEN
        .setTEXT("Your membership is confirmed. You will receive an email with the access data shortly.");

    LANGUAGE languageStringMitgliedschaftBestaetigtES = new LANGUAGE();
    languageStringMitgliedschaftBestaetigtES.setISO639(ISO639.ES);
    languageStringMitgliedschaftBestaetigtES.setTEXT(
        "Tu afiliación está confirmada. En breve recibrás un correo electronico con tus datos de accesso."
    );

    languagesMitgliedschaftBestaetigt.getLANGUAGE().add(languageStringMitgliedschaftBestaetigtDE);
    languagesMitgliedschaftBestaetigt.getLANGUAGE().add(languageStringMitgliedschaftBestaetigtEN);
    languagesMitgliedschaftBestaetigt.getLANGUAGE().add(languageStringMitgliedschaftBestaetigtES);
    commandStringMitgliedschaftBestaetigt.setLANGUAGES(languagesMitgliedschaftBestaetigt);

    COMMAND commandStringMitgliedschaftAbgelehnt = new COMMAND();
    commandStringMitgliedschaftAbgelehnt.setKEY(KEY.STRING_MITGLIEDSCHAFT_WURDE_ABGELEHNT);
    LANGUAGES languagesMitgliedschaftAbgelehnt = new LANGUAGES();
    LANGUAGE languageStringMitgliedschaftAbgelehntDE = new LANGUAGE();
    languageStringMitgliedschaftAbgelehntDE.setISO639(ISO639.DE);
    languageStringMitgliedschaftAbgelehntDE.setTEXT("Deine Mitgliedschaft wurde abgelehnt.");

    LANGUAGE languageStringMitgliedschaftAbgelehntEN = new LANGUAGE();
    languageStringMitgliedschaftAbgelehntEN.setISO639(ISO639.EN);
    languageStringMitgliedschaftAbgelehntEN.setTEXT("Your membership was declined.");

    LANGUAGE languageStringMitgliedschaftAbgelehntES = new LANGUAGE();
    languageStringMitgliedschaftAbgelehntES.setISO639(ISO639.ES);
    languageStringMitgliedschaftAbgelehntES.setTEXT("Tu afiliación fue rechazada.");

    languagesMitgliedschaftAbgelehnt.getLANGUAGE().add(languageStringMitgliedschaftAbgelehntDE);
    languagesMitgliedschaftAbgelehnt.getLANGUAGE().add(languageStringMitgliedschaftAbgelehntEN);
    languagesMitgliedschaftAbgelehnt.getLANGUAGE().add(languageStringMitgliedschaftAbgelehntES);
    commandStringMitgliedschaftAbgelehnt.setLANGUAGES(languagesMitgliedschaftAbgelehnt);

    COMMAND commandStringKontoGesperrt = new COMMAND();
    commandStringKontoGesperrt.setKEY(KEY.STRING_KONTO_GESPERRT);
    LANGUAGES languagesStringKOntoGesperrt = new LANGUAGES();

    LANGUAGE languageStringKontoGesperrtDE = new LANGUAGE();
    languageStringKontoGesperrtDE.setISO639(ISO639.DE);
    languageStringKontoGesperrtDE.setTEXT(
        "Dein Konto ist vorübergehend gesperrt. Die Sperre wird sofort aufgehoben, wenn du dich mit deinem bisherigen Passwort anmeldest."
    );

    LANGUAGE languageStringKontoGesperrtEN = new LANGUAGE();
    languageStringKontoGesperrtEN.setISO639(ISO639.EN);
    languageStringKontoGesperrtEN.setTEXT(
        "Your account is temporarily locked. The lock will be lifted immediately when you log in with your previous password."
    );

    LANGUAGE languageStringKontoGesperrtES = new LANGUAGE();
    languageStringKontoGesperrtES.setISO639(ISO639.ES);
    languageStringKontoGesperrtES.setTEXT(
        "Tu cuenta está temporalmente bloqueada. El bloqueo se levantará inmediatamente si te conectas con tu contraseña actual."
    );

    languagesStringKOntoGesperrt.getLANGUAGE().add(languageStringKontoGesperrtDE);
    languagesStringKOntoGesperrt.getLANGUAGE().add(languageStringKontoGesperrtEN);
    languagesStringKOntoGesperrt.getLANGUAGE().add(languageStringKontoGesperrtES);
    commandStringKontoGesperrt.setLANGUAGES(languagesStringKOntoGesperrt);

    COMMAND commandMitgliederlisteWurdeAngepasst = new COMMAND();
    commandMitgliederlisteWurdeAngepasst.setKEY(KEY.STRING_MITGLIEDERLISTE_WURDE_ANGEPASST);
    LANGUAGES languagesMitgliederlisteAngepasst = new LANGUAGES();

    LANGUAGE languageMitgliederlisteAngepasstDE = new LANGUAGE();
    languageMitgliederlisteAngepasstDE.setTEXT("Die Mitgliederliste wurde angepasst.");
    languageMitgliederlisteAngepasstDE.setISO639(ISO639.DE);

    LANGUAGE languageMitgliederlisteAngepasstEN = new LANGUAGE();
    languageMitgliederlisteAngepasstEN.setTEXT("The list of members was adjusted.");
    languageMitgliederlisteAngepasstEN.setISO639(ISO639.EN);

    LANGUAGE languageMitgliederlisteAngepasstES = new LANGUAGE();
    languageMitgliederlisteAngepasstES.setTEXT("Se ajustó la lista de miembros.");
    languageMitgliederlisteAngepasstES.setISO639(ISO639.ES);

    languagesMitgliederlisteAngepasst.getLANGUAGE().add(languageMitgliederlisteAngepasstDE);
    languagesMitgliederlisteAngepasst.getLANGUAGE().add(languageMitgliederlisteAngepasstEN);
    languagesMitgliederlisteAngepasst.getLANGUAGE().add(languageMitgliederlisteAngepasstES);
    commandMitgliederlisteWurdeAngepasst.setLANGUAGES(languagesMitgliederlisteAngepasst);

    COMMAND commandLabelGruppenraumBeschreibung = new COMMAND();
    commandLabelGruppenraumBeschreibung.setKEY(KEY.LABEL_GRUPPENRAUM_BESCHREIBUNG);
    LANGUAGES languagesGruppenraumBeschreibung = new LANGUAGES();

    LANGUAGE languageGruppenraumBeschreibungDE = new LANGUAGE();
    languageGruppenraumBeschreibungDE.setISO639(ISO639.DE);
    languageGruppenraumBeschreibungDE.setTEXT(
        "Du kannst einen Gruppenraum einrichten oder weitere Freunde einladen. "
            + "Nur Freunde dürfen den Gruppenraum betreten. "
            + "Deine Freunde dürfen ihrerseits Freunde in diesen Raum einladen. "
            + "Der Raum wird gelöscht, wenn der Letzte den Raum verlässt."
    );

    LANGUAGE languageGruppenraumBeschreibungEN = new LANGUAGE();
    languageGruppenraumBeschreibungEN.setISO639(ISO639.EN);
    languageGruppenraumBeschreibungEN.setTEXT(
        "You can create a group room or invite more friends. "
            + "Only friends are allowed to enter the group room. "
            + "Your friends, in turn, may invite friends to that room. "
            + "The room is cleared when the last person leaves the room."
    );

    LANGUAGE languageGruppenraumBeschreibungES = new LANGUAGE();
    languageGruppenraumBeschreibungES.setISO639(ISO639.ES);
    languageGruppenraumBeschreibungES.setTEXT(
        "Puedes crear una sala de grupo o invitar a más amigos. "
            + "Sólo los amigos pueden entrar en la sala de grupo. "
            + "Tus amigos pueden, a su vez, invitar a amigos a esta sala. "
            + "La sala se despeja cuando la última persona abandona la sala."
    );

    languagesGruppenraumBeschreibung.getLANGUAGE().add(languageGruppenraumBeschreibungDE);
    languagesGruppenraumBeschreibung.getLANGUAGE().add(languageGruppenraumBeschreibungEN);
    languagesGruppenraumBeschreibung.getLANGUAGE().add(languageGruppenraumBeschreibungES);
    commandLabelGruppenraumBeschreibung.setLANGUAGES(languagesGruppenraumBeschreibung);

    COMMAND commandStringFreundeslisteErweitert = new COMMAND();
    commandStringFreundeslisteErweitert.setKEY(KEY.STRING_FREUNDESLISTE_ERWEITERT);
    LANGUAGES languagesStringFreundeslisteErweitert = new LANGUAGES();

    LANGUAGE languageFreundeslisteErweitertDE = new LANGUAGE();
    languageFreundeslisteErweitertDE.setISO639(ISO639.DE);
    languageFreundeslisteErweitertDE.setTEXT("Die Freundesliste wurde erweitert.");

    LANGUAGE languageFreundeslisteErweitertEN = new LANGUAGE();
    languageFreundeslisteErweitertEN.setISO639(ISO639.EN);
    languageFreundeslisteErweitertEN.setTEXT("The friends list has been expanded.");

    LANGUAGE languageFreundeslisteErweitertES = new LANGUAGE();
    languageFreundeslisteErweitertES.setISO639(ISO639.ES);
    languageFreundeslisteErweitertES.setTEXT("La lista de amigos se ha ampliado.");

    languagesStringFreundeslisteErweitert.getLANGUAGE().add(languageFreundeslisteErweitertDE);
    languagesStringFreundeslisteErweitert.getLANGUAGE().add(languageFreundeslisteErweitertEN);
    languagesStringFreundeslisteErweitert.getLANGUAGE().add(languageFreundeslisteErweitertES);
    commandStringFreundeslisteErweitert.setLANGUAGES(languagesStringFreundeslisteErweitert);

    COMMAND commandServerChatraumVorhanden = new COMMAND();
    commandServerChatraumVorhanden.setKEY(KEY.SERVER_DER_CHATRAUM_IST_VORHANDEN);
    LANGUAGES languagesChatraumVorhanden = new LANGUAGES();

    LANGUAGE languageChatraumVorhandenDE = new LANGUAGE();
    languageChatraumVorhandenDE.setISO639(ISO639.DE);
    languageChatraumVorhandenDE.setTEXT("Der Chatraum XXX ist schon vorhanden.");

    LANGUAGE languageChatraumVorhandenEN = new LANGUAGE();
    languageChatraumVorhandenEN.setISO639(ISO639.EN);
    languageChatraumVorhandenEN.setTEXT("The chat room XXX already exists.");

    LANGUAGE languageChatraumVorhandenES = new LANGUAGE();
    languageChatraumVorhandenES.setISO639(ISO639.ES);
    languageChatraumVorhandenES.setTEXT("La sala de chat XXX ya existe.");

    languagesChatraumVorhanden.getLANGUAGE().add(languageChatraumVorhandenDE);
    languagesChatraumVorhanden.getLANGUAGE().add(languageChatraumVorhandenEN);
    languagesChatraumVorhanden.getLANGUAGE().add(languageChatraumVorhandenES);
    commandServerChatraumVorhanden.setLANGUAGES(languagesChatraumVorhanden);

    COMMAND commandServerZuKurzerRaumname = new COMMAND();
    commandServerZuKurzerRaumname.setKEY(KEY.SERVER_ZU_KURZER_RAUMNAME);
    LANGUAGES languagesServerZuKurzerRaumname = new LANGUAGES();

    LANGUAGE languageServerZuKurzerRaumnameDE = new LANGUAGE();
    languageServerZuKurzerRaumnameDE.setISO639(ISO639.DE);
    languageServerZuKurzerRaumnameDE.setTEXT("Der Raumname XXX muss mindestens 2 Zeichen lang sein.");

    LANGUAGE languageServerZuKurzerRaumnameEN = new LANGUAGE();
    languageServerZuKurzerRaumnameEN.setISO639(ISO639.EN);
    languageServerZuKurzerRaumnameEN.setTEXT("The room name XXX must be at least 2 characters long.");

    LANGUAGE languageServerZuKurzerRaumnameES = new LANGUAGE();
    languageServerZuKurzerRaumnameES.setISO639(ISO639.ES);
    languageServerZuKurzerRaumnameES.setTEXT("El nombre de la sala XXX debe tener al menos 2 caracteres.");

    languagesServerZuKurzerRaumname.getLANGUAGE().add(languageServerZuKurzerRaumnameDE);
    languagesServerZuKurzerRaumname.getLANGUAGE().add(languageServerZuKurzerRaumnameEN);
    languagesServerZuKurzerRaumname.getLANGUAGE().add(languageServerZuKurzerRaumnameES);
    commandServerZuKurzerRaumname.setLANGUAGES(languagesServerZuKurzerRaumname);

    COMMAND commandServerChatnameNichtErlaubt = new COMMAND();
    commandServerChatnameNichtErlaubt.setKEY(KEY.SERVER_DER_CHATNAME_IST_NICHT_ERLAUBT);
    LANGUAGES languagesServerChatnameNichtErlaubt = new LANGUAGES();

    LANGUAGE languageServerChatnameNichtErlaubtDE = new LANGUAGE();
    languageServerChatnameNichtErlaubtDE.setISO639(ISO639.DE);
    languageServerChatnameNichtErlaubtDE.setTEXT("Der Chatname XXX ist nicht erlaubt.");

    LANGUAGE languageServerChatnameNichtErlaubtEN = new LANGUAGE();
    languageServerChatnameNichtErlaubtEN.setISO639(ISO639.EN);
    languageServerChatnameNichtErlaubtEN.setTEXT("The chat name XXX is not allowed.");

    LANGUAGE languageServerChatnameNichtErlaubtES = new LANGUAGE();
    languageServerChatnameNichtErlaubtES.setISO639(ISO639.ES);
    languageServerChatnameNichtErlaubtES.setTEXT("El nombre de chat XXX no está permitido.");

    languagesServerChatnameNichtErlaubt.getLANGUAGE().add(languageServerChatnameNichtErlaubtDE);
    languagesServerChatnameNichtErlaubt.getLANGUAGE().add(languageServerChatnameNichtErlaubtEN);
    languagesServerChatnameNichtErlaubt.getLANGUAGE().add(languageServerChatnameNichtErlaubtES);
    commandServerChatnameNichtErlaubt.setLANGUAGES(languagesServerChatnameNichtErlaubt);

    COMMAND commandServerDerChatraumWurdeAngelegt = new COMMAND();
    commandServerDerChatraumWurdeAngelegt.setKEY(KEY.SERVER_DER_CHATRAUM_WURDE_ANGELEGT);
    LANGUAGES languagesChatraumWurdeAngelegt = new LANGUAGES();

    LANGUAGE languageServerChatraumWurdeAngelegtDE = new LANGUAGE();
    languageServerChatraumWurdeAngelegtDE.setISO639(ISO639.DE);
    languageServerChatraumWurdeAngelegtDE.setTEXT("Der Chatraum XXX wurde angelegt.");

    LANGUAGE languageServerChatraumWurdeAngelegtEN = new LANGUAGE();
    languageServerChatraumWurdeAngelegtEN.setISO639(ISO639.EN);
    languageServerChatraumWurdeAngelegtEN.setTEXT("The chatroom XXX was created.");

    LANGUAGE languageServerChatraumWurdeAngelegtES = new LANGUAGE();
    languageServerChatraumWurdeAngelegtES.setISO639(ISO639.ES);
    languageServerChatraumWurdeAngelegtES.setTEXT("La sala de chat XXX fue creada.");

    languagesChatraumWurdeAngelegt.getLANGUAGE().add(languageServerChatraumWurdeAngelegtDE);
    languagesChatraumWurdeAngelegt.getLANGUAGE().add(languageServerChatraumWurdeAngelegtEN);
    languagesChatraumWurdeAngelegt.getLANGUAGE().add(languageServerChatraumWurdeAngelegtES);
    commandServerDerChatraumWurdeAngelegt.setLANGUAGES(languagesChatraumWurdeAngelegt);

    COMMAND commandStringIstAmTelefonieren = new COMMAND();
    commandStringIstAmTelefonieren.setKEY(KEY.STRING_IST_AM_TELEFONIEREN);
    LANGUAGES languagesIstAmTelefonieren = new LANGUAGES();

    LANGUAGE languageIstAmTelefonierenDE = new LANGUAGE();
    languageIstAmTelefonierenDE.setISO639(ISO639.DE);
    languageIstAmTelefonierenDE.setTEXT(" ist am telefonieren.");

    LANGUAGE languageIstAmTelefonierenEN = new LANGUAGE();
    languageIstAmTelefonierenEN.setISO639(ISO639.EN);
    languageIstAmTelefonierenEN.setTEXT(" is on the phone.");

    LANGUAGE languageIstAmTelefonierenES = new LANGUAGE();
    languageIstAmTelefonierenES.setISO639(ISO639.ES);
    languageIstAmTelefonierenES.setTEXT(" está al teléfono.");

    languagesIstAmTelefonieren.getLANGUAGE().add(languageIstAmTelefonierenDE);
    languagesIstAmTelefonieren.getLANGUAGE().add(languageIstAmTelefonierenEN);
    languagesIstAmTelefonieren.getLANGUAGE().add(languageIstAmTelefonierenES);
    commandStringIstAmTelefonieren.setLANGUAGES(languagesIstAmTelefonieren);

    COMMAND commandStringNimmtKeineAnrufeEntgegen = new COMMAND();
    commandStringNimmtKeineAnrufeEntgegen.setKEY(KEY.STRING_NIMMT_KEINE_ANRUFE_ENTGEGEN);
    LANGUAGES languagesNimmtKeineAnrufeEntgegen = new LANGUAGES();
    LANGUAGE languageNimmtKeineAnrufeEntgegenDE = new LANGUAGE();
    languageNimmtKeineAnrufeEntgegenDE.setISO639(ISO639.DE);
    languageNimmtKeineAnrufeEntgegenDE.setTEXT(" nimmt keine Anrufe entgegen");

    LANGUAGE languageNimmtKeineAnrufeEntgegenEN = new LANGUAGE();
    languageNimmtKeineAnrufeEntgegenEN.setISO639(ISO639.EN);
    languageNimmtKeineAnrufeEntgegenEN.setTEXT(" does not take calls.");

    LANGUAGE languageNimmtKeineAnrufeEntgegenES = new LANGUAGE();
    languageNimmtKeineAnrufeEntgegenES.setISO639(ISO639.ES);
    languageNimmtKeineAnrufeEntgegenES.setTEXT(" no está atendiendo ninguna llamada.");

    languagesNimmtKeineAnrufeEntgegen.getLANGUAGE().add(languageNimmtKeineAnrufeEntgegenDE);
    languagesNimmtKeineAnrufeEntgegen.getLANGUAGE().add(languageNimmtKeineAnrufeEntgegenEN);
    languagesNimmtKeineAnrufeEntgegen.getLANGUAGE().add(languageNimmtKeineAnrufeEntgegenES);
    commandStringNimmtKeineAnrufeEntgegen.setLANGUAGES(languagesNimmtKeineAnrufeEntgegen);

    COMMAND commandStringIstNichtErreichbar = new COMMAND();
    commandStringIstNichtErreichbar.setKEY(KEY.STRING_IST_NICHT_ERREICHBAR);
    LANGUAGES languagesIstNichtErreichbar = new LANGUAGES();
    LANGUAGE languageIstNichtErreichbarDE = new LANGUAGE();
    languageIstNichtErreichbarDE.setISO639(ISO639.DE);
    languageIstNichtErreichbarDE.setTEXT(" ist nicht erreichbar.");

    LANGUAGE languageIstNichtErreichbarEN = new LANGUAGE();
    languageIstNichtErreichbarEN.setISO639(ISO639.EN);
    languageIstNichtErreichbarEN.setTEXT(" cannot be reached.");

    LANGUAGE languageIstNichtErreichbarES = new LANGUAGE();
    languageIstNichtErreichbarES.setISO639(ISO639.ES);
    languageIstNichtErreichbarES.setTEXT("No se puede contactar con ");

    languagesIstNichtErreichbar.getLANGUAGE().add(languageIstNichtErreichbarDE);
    languagesIstNichtErreichbar.getLANGUAGE().add(languageIstNichtErreichbarEN);
    languagesIstNichtErreichbar.getLANGUAGE().add(languageIstNichtErreichbarES);
    commandStringIstNichtErreichbar.setLANGUAGES(languagesIstNichtErreichbar);

    COMMAND commandStringTelefonieren = new COMMAND();
    commandStringTelefonieren.setKEY(KEY.STRING_TELEFONIEREN);
    LANGUAGES languagesStringTelefonieren = new LANGUAGES();
    LANGUAGE languageStringTelefonierenDE = new LANGUAGE();
    languageStringTelefonierenDE.setISO639(ISO639.DE);
    languageStringTelefonierenDE.setTEXT("Ein Telefonat führen");

    LANGUAGE languageStringTelefonierenEN = new LANGUAGE();
    languageStringTelefonierenEN.setISO639(ISO639.EN);
    languageStringTelefonierenEN.setTEXT("Making a phone call");

    LANGUAGE languageStringTelefonierenES = new LANGUAGE();
    languageStringTelefonierenES.setISO639(ISO639.ES);
    languageStringTelefonierenES.setTEXT("Hacer una llamada telefónica");

    languagesStringTelefonieren.getLANGUAGE().add(languageStringTelefonierenDE);
    languagesStringTelefonieren.getLANGUAGE().add(languageStringTelefonierenEN);
    languagesStringTelefonieren.getLANGUAGE().add(languageStringTelefonierenES);
    commandStringTelefonieren.setLANGUAGES(languagesStringTelefonieren);

    COMMAND commandStringAnrufer = new COMMAND();
    commandStringAnrufer.setKEY(KEY.FRAME_ABNEHMEN);
    LANGUAGES languagesAnrufer = new LANGUAGES();
    LANGUAGE languageStringAnruferDE = new LANGUAGE();
    languageStringAnruferDE.setISO639(ISO639.DE);
    languageStringAnruferDE.setTEXT("AnruferXXX");

    LANGUAGE languageStringAnruferEN = new LANGUAGE();
    languageStringAnruferEN.setISO639(ISO639.EN);
    languageStringAnruferEN.setTEXT("CallerXXX");

    LANGUAGE languageStringAnruferES = new LANGUAGE();
    languageStringAnruferES.setISO639(ISO639.ES);
    languageStringAnruferES.setTEXT("LlamadorXXX");

    languagesAnrufer.getLANGUAGE().add(languageStringAnruferDE);
    languagesAnrufer.getLANGUAGE().add(languageStringAnruferEN);
    languagesAnrufer.getLANGUAGE().add(languageStringAnruferES);
    commandStringAnrufer.setLANGUAGES(languagesAnrufer);

    COMMAND commandStringIstNichtMehrOnline = new COMMAND();
    commandStringIstNichtMehrOnline.setKEY(KEY.STRING_IST_NICHT_MEHR_ONLINE);
    LANGUAGES languagesIstNichtMehrOnline = new LANGUAGES();

    LANGUAGE languageIstNichtMehrOnlneDE = new LANGUAGE();
    languageIstNichtMehrOnlneDE.setISO639(ISO639.DE);
    languageIstNichtMehrOnlneDE.setTEXT(" ist nicht mehr online.");

    LANGUAGE languageIstNichtMehrOnlneEN = new LANGUAGE();
    languageIstNichtMehrOnlneEN.setISO639(ISO639.EN);
    languageIstNichtMehrOnlneEN.setTEXT(" is no longer online.");

    LANGUAGE languageIstNichtMehrOnlneES = new LANGUAGE();
    languageIstNichtMehrOnlneES.setISO639(ISO639.ES);
    languageIstNichtMehrOnlneES.setTEXT(" ya no está en línea.");

    languagesIstNichtMehrOnline.getLANGUAGE().add(languageIstNichtMehrOnlneDE);
    languagesIstNichtMehrOnline.getLANGUAGE().add(languageIstNichtMehrOnlneEN);
    languagesIstNichtMehrOnline.getLANGUAGE().add(languageIstNichtMehrOnlneES);
    commandStringIstNichtMehrOnline.setLANGUAGES(languagesIstNichtMehrOnline);

    COMMAND commandStringHatAufgelegt = new COMMAND();
    commandStringHatAufgelegt.setKEY(KEY.STRING_HAT_AUFGELEGT);
    LANGUAGES languagesHatAufGelegt = new LANGUAGES();

    LANGUAGE languageHatAufgelegtDE = new LANGUAGE();
    languageHatAufgelegtDE.setISO639(ISO639.DE);
    languageHatAufgelegtDE.setTEXT(" hat aufgelegt.");

    LANGUAGE languageHatAufgelegtEN = new LANGUAGE();
    languageHatAufgelegtEN.setISO639(ISO639.EN);
    languageHatAufgelegtEN.setTEXT(" hung up.");

    LANGUAGE languageHatAufgelegtES = new LANGUAGE();
    languageHatAufgelegtES.setISO639(ISO639.ES);
    languageHatAufgelegtES.setTEXT(" colgó.");

    languagesHatAufGelegt.getLANGUAGE().add(languageHatAufgelegtDE);
    languagesHatAufGelegt.getLANGUAGE().add(languageHatAufgelegtEN);
    languagesHatAufGelegt.getLANGUAGE().add(languageHatAufgelegtES);
    commandStringHatAufgelegt.setLANGUAGES(languagesHatAufGelegt);

    COMMAND commandStringZeit = new COMMAND();
    commandStringZeit.setKEY(KEY.STRING_ZEIT);
    LANGUAGES languagesZeit = new LANGUAGES();
    LANGUAGE languageZeitDE = new LANGUAGE();
    languageZeitDE.setISO639(ISO639.DE);
    languageZeitDE.setTEXT("Zeit");

    LANGUAGE languageZeitEN = new LANGUAGE();
    languageZeitEN.setISO639(ISO639.EN);
    languageZeitEN.setTEXT("Time");

    LANGUAGE languageZeitES = new LANGUAGE();
    languageZeitES.setISO639(ISO639.ES);
    languageZeitES.setTEXT("Tiempo");

    languagesZeit.getLANGUAGE().add(languageZeitDE);
    languagesZeit.getLANGUAGE().add(languageZeitEN);
    languagesZeit.getLANGUAGE().add(languageZeitES);
    commandStringZeit.setLANGUAGES(languagesZeit);

    COMMAND commandStringNachricht = new COMMAND();
    commandStringNachricht.setKEY(KEY.STRING_NACHRICHT);
    LANGUAGES languagesNachricht = new LANGUAGES();
    LANGUAGE languageNachrichtDE = new LANGUAGE();
    languageNachrichtDE.setISO639(ISO639.DE);
    languageNachrichtDE.setTEXT("Nachricht");

    LANGUAGE languageNachrichtEN = new LANGUAGE();
    languageNachrichtEN.setISO639(ISO639.EN);
    languageNachrichtEN.setTEXT("Message");

    LANGUAGE languageNachrichtES = new LANGUAGE();
    languageNachrichtES.setISO639(ISO639.ES);
    languageNachrichtES.setTEXT("Mensaje");

    languagesNachricht.getLANGUAGE().add(languageNachrichtDE);
    languagesNachricht.getLANGUAGE().add(languageNachrichtEN);
    languagesNachricht.getLANGUAGE().add(languageNachrichtES);
    commandStringNachricht.setLANGUAGES(languagesNachricht);

    COMMAND commandStringZwischenablage = new COMMAND();
    commandStringZwischenablage.setKEY(KEY.STRING_ZWISCHENABLAGE);
    LANGUAGES languagesZwischenablage = new LANGUAGES();
    LANGUAGE languageZwischenablageDE = new LANGUAGE();
    languageZwischenablageDE.setISO639(ISO639.DE);
    languageZwischenablageDE.setTEXT("In die Zwischenablage kopieren");

    LANGUAGE languageZwischenablageEN = new LANGUAGE();
    languageZwischenablageEN.setISO639(ISO639.EN);
    languageZwischenablageEN.setTEXT("Copy to clipboard");

    LANGUAGE languageZwischenablageES = new LANGUAGE();
    languageZwischenablageES.setISO639(ISO639.ES);
    languageZwischenablageES.setTEXT("Copiar al portapapeles");

    languagesZwischenablage.getLANGUAGE().add(languageZwischenablageDE);
    languagesZwischenablage.getLANGUAGE().add(languageZwischenablageEN);
    languagesZwischenablage.getLANGUAGE().add(languageZwischenablageES);
    commandStringZwischenablage.setLANGUAGES(languagesZwischenablage);

    COMMAND commandStringEmailIstErforderlich = new COMMAND();
    commandStringEmailIstErforderlich.setKEY(KEY.STRING_EMAIL_IST_ERFORDERLICH);
    LANGUAGES languagesEmailIstErforderlich = new LANGUAGES();
    LANGUAGE languageStringEmailIstErforderlichDE = new LANGUAGE();
    languageStringEmailIstErforderlichDE.setISO639(ISO639.DE);
    languageStringEmailIstErforderlichDE.setTEXT("Eine E-Mail-Adresse ist erforderlich.");

    LANGUAGE languageStringEmailIstErforderlichEN = new LANGUAGE();
    languageStringEmailIstErforderlichEN.setISO639(ISO639.EN);
    languageStringEmailIstErforderlichEN.setTEXT("An email address is required.");

    LANGUAGE languageStringEmailIstErforderlichES = new LANGUAGE();
    languageStringEmailIstErforderlichES.setISO639(ISO639.ES);
    languageStringEmailIstErforderlichES.setTEXT("Se requiere una dirección de correo electrónico.");

    languagesEmailIstErforderlich.getLANGUAGE().add(languageStringEmailIstErforderlichDE);
    languagesEmailIstErforderlich.getLANGUAGE().add(languageStringEmailIstErforderlichEN);
    languagesEmailIstErforderlich.getLANGUAGE().add(languageStringEmailIstErforderlichES);

    commandStringEmailIstErforderlich.setLANGUAGES(languagesEmailIstErforderlich);

    COMMAND commandPopupPaste = new COMMAND();
    commandPopupPaste.setKEY(KEY.POPUP_PASTE);
    LANGUAGES languagesPaste = new LANGUAGES();
    LANGUAGE languagePopupPasteDE = new LANGUAGE();
    languagePopupPasteDE.setISO639(ISO639.DE);
    languagePopupPasteDE.setTEXT("Einfügen aus der Zwischenablage");

    LANGUAGE languagePopupPasteEN = new LANGUAGE();
    languagePopupPasteEN.setISO639(ISO639.EN);
    languagePopupPasteEN.setTEXT("Paste from clipboard");

    LANGUAGE languagePopupPasteES = new LANGUAGE();
    languagePopupPasteES.setISO639(ISO639.ES);
    languagePopupPasteES.setTEXT("Pegar desde el portapapeles");

    languagesPaste.getLANGUAGE().add(languagePopupPasteDE);
    languagesPaste.getLANGUAGE().add(languagePopupPasteEN);
    languagesPaste.getLANGUAGE().add(languagePopupPasteES);
    commandPopupPaste.setLANGUAGES(languagesPaste);

    COMMAND commandPopupZeilenumbruch = new COMMAND();
    commandPopupZeilenumbruch.setKEY(KEY.POPUP_ZEILENUMBRUCH);
    LANGUAGES languagesZeilenumbruch = new LANGUAGES();
    LANGUAGE languagePopupZeilenumbruchDE = new LANGUAGE();
    languagePopupZeilenumbruchDE.setISO639(ISO639.DE);
    languagePopupZeilenumbruchDE.setTEXT("Zeilenumbruch <SHIFT> + <ENTER>");

    LANGUAGE languagePopupZeilenumbruchEN = new LANGUAGE();
    languagePopupZeilenumbruchEN.setISO639(ISO639.EN);
    languagePopupZeilenumbruchEN.setTEXT("Line break <SHIFT> + <ENTER>");

    LANGUAGE languagePopupZeilenumbruchES = new LANGUAGE();
    languagePopupZeilenumbruchES.setISO639(ISO639.ES);
    languagePopupZeilenumbruchES.setTEXT("Salto de línea <SHIFT> + <ENTER>");

    languagesZeilenumbruch.getLANGUAGE().add(languagePopupZeilenumbruchDE);
    languagesZeilenumbruch.getLANGUAGE().add(languagePopupZeilenumbruchEN);
    languagesZeilenumbruch.getLANGUAGE().add(languagePopupZeilenumbruchES);
    commandPopupZeilenumbruch.setLANGUAGES(languagesZeilenumbruch);

    COMMAND commandPopupTooltip = new COMMAND();
    commandPopupTooltip.setKEY(KEY.POPUP_TOOLTIP);
    LANGUAGES languagesPopupTooltip = new LANGUAGES();
    LANGUAGE languagePopupTooltipDE = new LANGUAGE();
    languagePopupTooltipDE.setISO639(ISO639.DE);
    languagePopupTooltipDE.setTEXT("Tooltipp ausblenden");

    LANGUAGE languagePopupTooltipEN = new LANGUAGE();
    languagePopupTooltipEN.setISO639(ISO639.EN);
    languagePopupTooltipEN.setTEXT("Hide tooltip");

    LANGUAGE languagePopupTooltipES = new LANGUAGE();
    languagePopupTooltipES.setISO639(ISO639.ES);
    languagePopupTooltipES.setTEXT("Ocultar la información sobre la herramienta");

    languagesPopupTooltip.getLANGUAGE().add(languagePopupTooltipDE);
    languagesPopupTooltip.getLANGUAGE().add(languagePopupTooltipEN);
    languagesPopupTooltip.getLANGUAGE().add(languagePopupTooltipES);

    commandPopupTooltip.setLANGUAGES(languagesPopupTooltip);

    COMMAND commandTooltipTicker = new COMMAND();
    commandTooltipTicker.setKEY(KEY.TOOLTIP_TICKER);
    LANGUAGES languagesTooltipTicker = new LANGUAGES();
    LANGUAGE languageTooltipTickerDE = new LANGUAGE();
    languageTooltipTickerDE.setISO639(ISO639.DE);
    languageTooltipTickerDE.setTEXT(
        "Du kannst die Nachricht mit einem Doppelklick markieren<br>und mit der rechten Maustaste in die Zwischenablage kopieren."
    );

    LANGUAGE languageTooltipTickerEN = new LANGUAGE();
    languageTooltipTickerEN.setISO639(ISO639.EN);
    languageTooltipTickerEN.setTEXT(
        "You can mark the message with a double click<br>and copy it to the clipboard with the right mouse button."
    );

    LANGUAGE languageTooltipTickerES = new LANGUAGE();
    languageTooltipTickerES.setISO639(ISO639.ES);
    languageTooltipTickerES.setTEXT(
        "Puedes marcar el mensaje con un doble clic<br>y copiarlo en el portapapeles con el botón derecho del ratón."
    );

    languagesTooltipTicker.getLANGUAGE().add(languageTooltipTickerDE);
    languagesTooltipTicker.getLANGUAGE().add(languageTooltipTickerEN);
    languagesTooltipTicker.getLANGUAGE().add(languageTooltipTickerES);
    commandTooltipTicker.setLANGUAGES(languagesTooltipTicker);

    COMMAND commandTooltipInput = new COMMAND();
    commandTooltipInput.setKEY(KEY.TOOLTIP_INPUT);
    LANGUAGES languagesTooltipInput = new LANGUAGES();
    LANGUAGE languageTooltipInputDE = new LANGUAGE();
    languageTooltipInputDE.setISO639(ISO639.DE);
    languageTooltipInputDE.setTEXT(
        "Die rechte Maustaste drücken und einen Text aus der Zwischenablage einfügen"
            + "<br> oder diesen Tooltip ausblenden."
    );

    LANGUAGE languageTooltipInputEN = new LANGUAGE();
    languageTooltipInputEN.setISO639(ISO639.EN);
    languageTooltipInputEN
        .setTEXT("Press the right mouse button and paste a text from the clipboard<br>or hide this tooltip.");

    LANGUAGE languageTooltipInputES = new LANGUAGE();
    languageTooltipInputES.setISO639(ISO639.ES);
    languageTooltipInputES.setTEXT(
        "Pulsa el botón derecho del ratón y pega un texto del portapapeles"
            + "<br>u ocultar información sobre herramientas."
    );

    languagesTooltipInput.getLANGUAGE().add(languageTooltipInputDE);
    languagesTooltipInput.getLANGUAGE().add(languageTooltipInputEN);
    languagesTooltipInput.getLANGUAGE().add(languageTooltipInputES);

    commandTooltipInput.setLANGUAGES(languagesTooltipInput);

    COMMAND commandStringAnhang = new COMMAND();
    commandStringAnhang.setKEY(KEY.STRING_ANHANG);
    LANGUAGES languagesStringAnhang = new LANGUAGES();
    LANGUAGE languageStringAnhangDE = new LANGUAGE();
    languageStringAnhangDE.setISO639(ISO639.DE);
    languageStringAnhangDE.setTEXT("Datei anhängen");
    languageStringAnhangDE.setPathToImage("net/javacomm/multilingual/goldpaperclip_19x26.png");

    LANGUAGE languageStringAnhangEN = new LANGUAGE();
    languageStringAnhangEN.setISO639(ISO639.EN);
    languageStringAnhangEN.setTEXT("Attach File");
    languageStringAnhangEN.setPathToImage("net/javacomm/multilingual/goldpaperclip_19x26.png");

    LANGUAGE languageStringAnhangES = new LANGUAGE();
    languageStringAnhangES.setISO639(ISO639.ES);
    languageStringAnhangES.setTEXT("Adjuntar archivo");
    languageStringAnhangES.setPathToImage("net/javacomm/multilingual/goldpaperclip_19x26.png");

    languagesStringAnhang.getLANGUAGE().add(languageStringAnhangDE);
    languagesStringAnhang.getLANGUAGE().add(languageStringAnhangEN);
    languagesStringAnhang.getLANGUAGE().add(languageStringAnhangES);
    commandStringAnhang.setLANGUAGES(languagesStringAnhang);

    COMMAND commandStringOpen = new COMMAND();
    commandStringOpen.setKEY(KEY.STRING_OPEN);
    LANGUAGES languagesStringOpen = new LANGUAGES();
    LANGUAGE languageStringOpenDE = new LANGUAGE();
    languageStringOpenDE.setISO639(ISO639.DE);
    languageStringOpenDE.setTEXT("Öffnen");

    LANGUAGE languageStringOpenEN = new LANGUAGE();
    languageStringOpenEN.setISO639(ISO639.EN);
    languageStringOpenEN.setTEXT("Open");

    LANGUAGE languageStringOpenES = new LANGUAGE();
    languageStringOpenES.setISO639(ISO639.ES);
    languageStringOpenES.setTEXT("Abrir");

    languagesStringOpen.getLANGUAGE().add(languageStringOpenDE);
    languagesStringOpen.getLANGUAGE().add(languageStringOpenEN);
    languagesStringOpen.getLANGUAGE().add(languageStringOpenES);
    commandStringOpen.setLANGUAGES(languagesStringOpen);

    COMMAND commandStringAlleFormate = new COMMAND();
    commandStringAlleFormate.setKEY(KEY.STRING_ALLE_FORMATE);
    LANGUAGES languagesStringAlleFormate = new LANGUAGES();
    LANGUAGE languageStringAlleFormateDE = new LANGUAGE();
    languageStringAlleFormateDE.setISO639(ISO639.DE);
    languageStringAlleFormateDE.setTEXT("Alle Formate (*.*)");

    LANGUAGE languageStringAlleFormateEN = new LANGUAGE();
    languageStringAlleFormateEN.setISO639(ISO639.EN);
    languageStringAlleFormateEN.setTEXT("All formats (*.*)");

    LANGUAGE languageStringAlleFormateES = new LANGUAGE();
    languageStringAlleFormateES.setISO639(ISO639.ES);
    languageStringAlleFormateES.setTEXT("Todos los formatos (*.*)");

    languagesStringAlleFormate.getLANGUAGE().add(languageStringAlleFormateDE);
    languagesStringAlleFormate.getLANGUAGE().add(languageStringAlleFormateEN);
    languagesStringAlleFormate.getLANGUAGE().add(languageStringAlleFormateES);

    commandStringAlleFormate.setLANGUAGES(languagesStringAlleFormate);

    COMMAND commandStringTitelMarkieren = new COMMAND();
    commandStringTitelMarkieren.setKEY(KEY.STRING_TITEL_MARKIEREN);
    LANGUAGES languagesStringTitelMarkieren = new LANGUAGES();
    LANGUAGE languageStringTitelMarkierenDE = new LANGUAGE();
    languageStringTitelMarkierenDE.setISO639(ISO639.DE);
    languageStringTitelMarkierenDE.setTEXT("Titel markieren");

    LANGUAGE languageStringTitelMarkierenEN = new LANGUAGE();
    languageStringTitelMarkierenEN.setISO639(ISO639.EN);
    languageStringTitelMarkierenEN.setTEXT("Choose a title");

    LANGUAGE languageStringTitelMarkierenES = new LANGUAGE();
    languageStringTitelMarkierenES.setISO639(ISO639.ES);
    languageStringTitelMarkierenES.setTEXT("Elige un título");

    languagesStringTitelMarkieren.getLANGUAGE().add(languageStringTitelMarkierenDE);
    languagesStringTitelMarkieren.getLANGUAGE().add(languageStringTitelMarkierenEN);
    languagesStringTitelMarkieren.getLANGUAGE().add(languageStringTitelMarkierenES);
    commandStringTitelMarkieren.setLANGUAGES(languagesStringTitelMarkieren);

    COMMAND commandStringDerKanalIstBelegt = new COMMAND();
    commandStringDerKanalIstBelegt.setKEY(KEY.STRING_DER_KANAL_IST_BELEGT);
    LANGUAGES languagesDerKanalIstBelegt = new LANGUAGES();

    LANGUAGE languageDerKanalIstBelegtDE = new LANGUAGE();
    languageDerKanalIstBelegtDE.setISO639(ISO639.DE);
    languageDerKanalIstBelegtDE.setTEXT("Der Kanal ist belegt.");

    LANGUAGE languageDerKanalIstBelegtEN = new LANGUAGE();
    languageDerKanalIstBelegtEN.setISO639(ISO639.EN);
    languageDerKanalIstBelegtEN.setTEXT("The channel is busy.");

    LANGUAGE languageDerKanalIstBelegtES = new LANGUAGE();
    languageDerKanalIstBelegtES.setISO639(ISO639.ES);
    languageDerKanalIstBelegtES.setTEXT("El canal está ocupado.");

    languagesDerKanalIstBelegt.getLANGUAGE().add(languageDerKanalIstBelegtDE);
    languagesDerKanalIstBelegt.getLANGUAGE().add(languageDerKanalIstBelegtEN);
    languagesDerKanalIstBelegt.getLANGUAGE().add(languageDerKanalIstBelegtES);

    commandStringDerKanalIstBelegt.setLANGUAGES(languagesDerKanalIstBelegt);

    COMMAND commandStringAlleKanaeleSindBelegt = new COMMAND();
    commandStringAlleKanaeleSindBelegt.setKEY(KEY.STRING_ALLE_KANAELE_SIND_BELEGT);
    LANGUAGES languagesAlleKanaeleSindBelegt = new LANGUAGES();
    LANGUAGE languageAlleKanaeleSindBelegtDE = new LANGUAGE();
    languageAlleKanaeleSindBelegtDE.setISO639(ISO639.DE);
    languageAlleKanaeleSindBelegtDE.setTEXT("Alle Kanäle sind belegt.");

    LANGUAGE languageAlleKanaeleSindBelegtEN = new LANGUAGE();
    languageAlleKanaeleSindBelegtEN.setISO639(ISO639.EN);
    languageAlleKanaeleSindBelegtEN.setTEXT("All channels are busy.");

    LANGUAGE languageAlleKanaeleSindBelegtES = new LANGUAGE();
    languageAlleKanaeleSindBelegtES.setISO639(ISO639.ES);
    languageAlleKanaeleSindBelegtES.setTEXT("Todos los canales están ocupados.");

    languagesAlleKanaeleSindBelegt.getLANGUAGE().add(languageAlleKanaeleSindBelegtDE);
    languagesAlleKanaeleSindBelegt.getLANGUAGE().add(languageAlleKanaeleSindBelegtEN);
    languagesAlleKanaeleSindBelegt.getLANGUAGE().add(languageAlleKanaeleSindBelegtES);

    commandStringAlleKanaeleSindBelegt.setLANGUAGES(languagesAlleKanaeleSindBelegt);

    COMMAND commandStringDateiname = new COMMAND();
    commandStringDateiname.setKEY(KEY.STRING_DATEINAME);
    LANGUAGES languagesStringDateiname = new LANGUAGES();
    LANGUAGE languageDateinameDE = new LANGUAGE();
    languageDateinameDE.setISO639(ISO639.DE);
    languageDateinameDE.setTEXT("Dateiname");

    LANGUAGE languageDateinameEN = new LANGUAGE();
    languageDateinameEN.setISO639(ISO639.EN);
    languageDateinameEN.setTEXT("Filename");

    LANGUAGE languageDateinameES = new LANGUAGE();
    languageDateinameES.setISO639(ISO639.ES);
    languageDateinameES.setTEXT("Nombre de archivo");

    languagesStringDateiname.getLANGUAGE().add(languageDateinameDE);
    languagesStringDateiname.getLANGUAGE().add(languageDateinameEN);
    languagesStringDateiname.getLANGUAGE().add(languageDateinameES);
    commandStringDateiname.setLANGUAGES(languagesStringDateiname);

    COMMAND commandStringDateityp = new COMMAND();
    commandStringDateityp.setKEY(KEY.STRING_DATEITYP);
    LANGUAGES languagesStringDateityp = new LANGUAGES();

    LANGUAGE languageDateitypDE = new LANGUAGE();
    languageDateitypDE.setISO639(ISO639.DE);
    languageDateitypDE.setTEXT("Dateityp");

    LANGUAGE languageDateitypEN = new LANGUAGE();
    languageDateitypEN.setISO639(ISO639.EN);
    languageDateitypEN.setTEXT("Filetype");

    LANGUAGE languageDateitypES = new LANGUAGE();
    languageDateitypES.setISO639(ISO639.ES);
    languageDateitypES.setTEXT("Tipo de archivo");

    languagesStringDateityp.getLANGUAGE().add(languageDateitypDE);
    languagesStringDateityp.getLANGUAGE().add(languageDateitypEN);
    languagesStringDateityp.getLANGUAGE().add(languageDateitypES);

    commandStringDateityp.setLANGUAGES(languagesStringDateityp);

    COMMAND commandStringCommandAbgeschlossen = new COMMAND();
    commandStringCommandAbgeschlossen.setKEY(KEY.STRING_DOWNLOAD_ABGESCHLOSSEN);
    LANGUAGES languagesDownloadAbgeschlossen = new LANGUAGES();
    LANGUAGE languageDownloadAbgeschlossenDE = new LANGUAGE();
    languageDownloadAbgeschlossenDE.setISO639(ISO639.DE);
    languageDownloadAbgeschlossenDE.setTEXT("Download abgeschlossen");

    LANGUAGE languageDownloadAbgeschlossenEN = new LANGUAGE();
    languageDownloadAbgeschlossenEN.setISO639(ISO639.EN);
    languageDownloadAbgeschlossenEN.setTEXT("Download completed");

    LANGUAGE languageDownloadAbgeschlossenES = new LANGUAGE();
    languageDownloadAbgeschlossenES.setISO639(ISO639.ES);
    languageDownloadAbgeschlossenES.setTEXT("Descarga completada");

    languagesDownloadAbgeschlossen.getLANGUAGE().add(languageDownloadAbgeschlossenDE);
    languagesDownloadAbgeschlossen.getLANGUAGE().add(languageDownloadAbgeschlossenEN);
    languagesDownloadAbgeschlossen.getLANGUAGE().add(languageDownloadAbgeschlossenES);
    commandStringCommandAbgeschlossen.setLANGUAGES(languagesDownloadAbgeschlossen);

    COMMAND commandServerDieDateiIst = new COMMAND();
    commandServerDieDateiIst.setKEY(KEY.SERVER_DIE_DATEI_IST);
    LANGUAGES languagesDieDateiIst = new LANGUAGES();
    LANGUAGE languageDieDateiIstDE = new LANGUAGE();
    languageDieDateiIstDE.setISO639(ISO639.DE);
    languageDieDateiIstDE.setTEXT(" ist größer als XXXMB.");

    LANGUAGE languageDieDateiIstEN = new LANGUAGE();
    languageDieDateiIstEN.setISO639(ISO639.EN);
    languageDieDateiIstEN.setTEXT(" is larger than XXXMB.");

    LANGUAGE languageDieDateiIstES = new LANGUAGE();
    languageDieDateiIstES.setISO639(ISO639.ES);
    languageDieDateiIstES.setTEXT(" es mayor de XXXMB.");

    languagesDieDateiIst.getLANGUAGE().add(languageDieDateiIstDE);
    languagesDieDateiIst.getLANGUAGE().add(languageDieDateiIstEN);
    languagesDieDateiIst.getLANGUAGE().add(languageDieDateiIstES);
    commandServerDieDateiIst.setLANGUAGES(languagesDieDateiIst);

    COMMAND commandDasMedienformatWirdNicht = new COMMAND();
    commandDasMedienformatWirdNicht.setKEY(KEY.STRING_DAS_MEDIENFORMAT_WIRD_NICHT);
    LANGUAGES languagesStringDasMedienformatWirdNicht = new LANGUAGES();
    LANGUAGE languageDasMedienformatWirdNichtDE = new LANGUAGE();
    languageDasMedienformatWirdNichtDE.setISO639(ISO639.DE);
    languageDasMedienformatWirdNichtDE.setTEXT("Das Medienformat wird nicht unterstützt.");

    LANGUAGE languageDasMedienformatWirdNichtEN = new LANGUAGE();
    languageDasMedienformatWirdNichtEN.setISO639(ISO639.EN);
    languageDasMedienformatWirdNichtEN.setTEXT("The media format is not supported.");

    LANGUAGE languageDasMedienformatWirdNichtES = new LANGUAGE();
    languageDasMedienformatWirdNichtES.setISO639(ISO639.ES);
    languageDasMedienformatWirdNichtES.setTEXT("El formato de los medios no es compatible.");

    languagesStringDasMedienformatWirdNicht.getLANGUAGE().add(languageDasMedienformatWirdNichtDE);
    languagesStringDasMedienformatWirdNicht.getLANGUAGE().add(languageDasMedienformatWirdNichtEN);
    languagesStringDasMedienformatWirdNicht.getLANGUAGE().add(languageDasMedienformatWirdNichtES);
    commandDasMedienformatWirdNicht.setLANGUAGES(languagesStringDasMedienformatWirdNicht);

    COMMAND commandStringMedienwiedergabe = new COMMAND();
    commandStringMedienwiedergabe.setKEY(KEY.STRING_MEDIENWIEDERGABE);
    LANGUAGES languagesStringMedienwiedergabe = new LANGUAGES();
    LANGUAGE languageStringMedienwiedergabeDE = new LANGUAGE();
    languageStringMedienwiedergabeDE.setISO639(ISO639.DE);
    languageStringMedienwiedergabeDE.setTEXT("Medienwiedergabe");

    LANGUAGE languageStringMedienwiedergabeEN = new LANGUAGE();
    languageStringMedienwiedergabeEN.setISO639(ISO639.EN);
    languageStringMedienwiedergabeEN.setTEXT("Media playback");

    LANGUAGE languageStringMedienwiedergabeES = new LANGUAGE();
    languageStringMedienwiedergabeES.setISO639(ISO639.ES);
    languageStringMedienwiedergabeES.setTEXT("Reproducción de medios");

    languagesStringMedienwiedergabe.getLANGUAGE().add(languageStringMedienwiedergabeDE);
    languagesStringMedienwiedergabe.getLANGUAGE().add(languageStringMedienwiedergabeEN);
    languagesStringMedienwiedergabe.getLANGUAGE().add(languageStringMedienwiedergabeES);
    commandStringMedienwiedergabe.setLANGUAGES(languagesStringMedienwiedergabe);

    COMMAND commandServerDerEmpfaengerIstVerschwunden = new COMMAND();
    commandServerDerEmpfaengerIstVerschwunden.setKEY(KEY.SERVER_DER_EMPFAENGER_IST_VERSCHWUNDEN);
    LANGUAGES languagesDerEmpfaengerIstVerschwunden = new LANGUAGES();
    LANGUAGE languageDerEmpfaengerIstVerschwundenDE = new LANGUAGE();
    languageDerEmpfaengerIstVerschwundenDE.setISO639(ISO639.DE);
    languageDerEmpfaengerIstVerschwundenDE.setTEXT("Der Empfänger <b>XXX</b> ist verschwunden.");

    LANGUAGE languageDerEmpfaengerIstVerschwundenEN = new LANGUAGE();
    languageDerEmpfaengerIstVerschwundenEN.setISO639(ISO639.EN);
    languageDerEmpfaengerIstVerschwundenEN.setTEXT("The recipient <b>XXX</b> has disappeared.");

    LANGUAGE languageDerEmpfaengerIstVerschwundenES = new LANGUAGE();
    languageDerEmpfaengerIstVerschwundenES.setISO639(ISO639.ES);
    languageDerEmpfaengerIstVerschwundenES.setTEXT("El receptor <b>XXX</b> ha desaparecido.");

    languagesDerEmpfaengerIstVerschwunden.getLANGUAGE().add(languageDerEmpfaengerIstVerschwundenDE);
    languagesDerEmpfaengerIstVerschwunden.getLANGUAGE().add(languageDerEmpfaengerIstVerschwundenEN);
    languagesDerEmpfaengerIstVerschwunden.getLANGUAGE().add(languageDerEmpfaengerIstVerschwundenES);
    commandServerDerEmpfaengerIstVerschwunden.setLANGUAGES(languagesDerEmpfaengerIstVerschwunden);

    COMMAND commandServerLehntUebertragungenAb = new COMMAND();
    commandServerLehntUebertragungenAb.setKEY(KEY.SERVER_LEHNT_UEBERTRAGUNGEN_AB);
    LANGUAGES languagesLehntUebertragungenAb = new LANGUAGES();

    LANGUAGE languageLehntUebertragungenAbDE = new LANGUAGE();
    languageLehntUebertragungenAbDE.setISO639(ISO639.DE);
    languageLehntUebertragungenAbDE.setTEXT("<b>XXX</b> lehnt Übertragungen ab.");

    LANGUAGE languageLehntUebertragungenAbEN = new LANGUAGE();
    languageLehntUebertragungenAbEN.setISO639(ISO639.EN);
    languageLehntUebertragungenAbEN.setTEXT("<b>XXX</b> rejects transfers.");

    LANGUAGE languageLehntUebertragungenAbES = new LANGUAGE();
    languageLehntUebertragungenAbES.setISO639(ISO639.ES);
    languageLehntUebertragungenAbES.setTEXT("<b>XXX</b> rechaza las transmisiones.");

    languagesLehntUebertragungenAb.getLANGUAGE().add(languageLehntUebertragungenAbDE);

    languagesLehntUebertragungenAb.getLANGUAGE().add(languageLehntUebertragungenAbEN);
    languagesLehntUebertragungenAb.getLANGUAGE().add(languageLehntUebertragungenAbES);
    commandServerLehntUebertragungenAb.setLANGUAGES(languagesLehntUebertragungenAb);

    COMMAND commandServerProjektorAusschalten = new COMMAND();
    commandServerProjektorAusschalten.setKEY(KEY.SERVER_MUSS_NOCH_SEINEN_PROJEKTOR_AUSSCHALTEN);
    LANGUAGES languagesMussNochSeinenProjektorAusschalten = new LANGUAGES();
    LANGUAGE languageMussNochProjektorAusschaltenDE = new LANGUAGE();
    languageMussNochProjektorAusschaltenDE.setISO639(ISO639.DE);
    languageMussNochProjektorAusschaltenDE.setTEXT("<b>XXX</b> muss seinen Projektor ausschalten.");

    LANGUAGE languageMussNochProjektorAusschaltenEN = new LANGUAGE();
    languageMussNochProjektorAusschaltenEN.setISO639(ISO639.EN);
    languageMussNochProjektorAusschaltenEN.setTEXT("<b>XXX</b> has to switch off his projector.");

    LANGUAGE languageMussNochProjektorAusschaltenES = new LANGUAGE();
    languageMussNochProjektorAusschaltenES.setISO639(ISO639.ES);
    languageMussNochProjektorAusschaltenES.setTEXT("<b>XXX</b> tiene que apagar su proyector..");

    languagesMussNochSeinenProjektorAusschalten.getLANGUAGE().add(languageMussNochProjektorAusschaltenDE);
    languagesMussNochSeinenProjektorAusschalten.getLANGUAGE().add(languageMussNochProjektorAusschaltenEN);
    languagesMussNochSeinenProjektorAusschalten.getLANGUAGE().add(languageMussNochProjektorAusschaltenES);
    commandServerProjektorAusschalten.setLANGUAGES(languagesMussNochSeinenProjektorAusschalten);

    COMMAND commandStringMailserver = new COMMAND();
    commandStringMailserver.setKEY(KEY.STRING_MAILSERVER);
    LANGUAGES languagesStringMailServer = new LANGUAGES();
    LANGUAGE lanaguageStringMailserverDE = new LANGUAGE();
    lanaguageStringMailserverDE.setISO639(ISO639.DE);
    lanaguageStringMailserverDE.setTEXT("Mailserver");

    LANGUAGE lanaguageStringMailserverEN = new LANGUAGE();
    lanaguageStringMailserverEN.setISO639(ISO639.EN);
    lanaguageStringMailserverEN.setTEXT("Mailserver");

    LANGUAGE lanaguageStringMailserverES = new LANGUAGE();
    lanaguageStringMailserverES.setISO639(ISO639.ES);
    lanaguageStringMailserverES.setTEXT("Servidor de correo");

    languagesStringMailServer.getLANGUAGE().add(lanaguageStringMailserverDE);
    languagesStringMailServer.getLANGUAGE().add(lanaguageStringMailserverEN);
    languagesStringMailServer.getLANGUAGE().add(lanaguageStringMailserverES);

    commandStringMailserver.setLANGUAGES(languagesStringMailServer);

    COMMAND commandStringBenutzerantraege = new COMMAND();
    commandStringBenutzerantraege.setKEY(KEY.STRING_BENUTZERANTRAEGE);
    LANGUAGES languagesBenutzerantrage = new LANGUAGES();
    LANGUAGE lanaguageStringBenutzerantraegeDE = new LANGUAGE();
    lanaguageStringBenutzerantraegeDE.setISO639(ISO639.DE);
    lanaguageStringBenutzerantraegeDE.setTEXT("Benutzeranträge");

    LANGUAGE lanaguageStringBenutzerantraegeEN = new LANGUAGE();
    lanaguageStringBenutzerantraegeEN.setISO639(ISO639.EN);
    lanaguageStringBenutzerantraegeEN.setTEXT("Requests for user registration");

    LANGUAGE lanaguageStringBenutzerantraegeES = new LANGUAGE();
    lanaguageStringBenutzerantraegeES.setISO639(ISO639.ES);
    lanaguageStringBenutzerantraegeES.setTEXT("Solicitudes de registro de usuarios");

    languagesBenutzerantrage.getLANGUAGE().add(lanaguageStringBenutzerantraegeDE);
    languagesBenutzerantrage.getLANGUAGE().add(lanaguageStringBenutzerantraegeEN);
    languagesBenutzerantrage.getLANGUAGE().add(lanaguageStringBenutzerantraegeES);

    commandStringBenutzerantraege.setLANGUAGES(languagesBenutzerantrage);

    COMMAND commandStringRaumfilter = new COMMAND();
    commandStringRaumfilter.setKEY(KEY.STRING_RAUMFILTER);
    LANGUAGES languagesRaumfilter = new LANGUAGES();
    LANGUAGE lanaguageStringRaumfilterDE = new LANGUAGE();
    lanaguageStringRaumfilterDE.setISO639(ISO639.DE);
    lanaguageStringRaumfilterDE.setTEXT("Raumfilter");

    LANGUAGE lanaguageStringRaumfilterEN = new LANGUAGE();
    lanaguageStringRaumfilterEN.setISO639(ISO639.EN);
    lanaguageStringRaumfilterEN.setTEXT("Room filters");

    LANGUAGE lanaguageStringRaumfilterES = new LANGUAGE();
    lanaguageStringRaumfilterES.setISO639(ISO639.ES);
    lanaguageStringRaumfilterES.setTEXT("Filtros de sala");

    languagesRaumfilter.getLANGUAGE().add(lanaguageStringRaumfilterDE);
    languagesRaumfilter.getLANGUAGE().add(lanaguageStringRaumfilterEN);
    languagesRaumfilter.getLANGUAGE().add(lanaguageStringRaumfilterES);
    commandStringRaumfilter.setLANGUAGES(languagesRaumfilter);

    COMMAND commandStringProgrammversionen = new COMMAND();
    commandStringProgrammversionen.setKEY(KEY.STRING_PROGRAMMVERSIONEN);
    LANGUAGES languagesProgrammversionen = new LANGUAGES();
    LANGUAGE lanaguageProgrammversionenDE = new LANGUAGE();
    lanaguageProgrammversionenDE.setISO639(ISO639.DE);
    lanaguageProgrammversionenDE.setTEXT("Programmversionen");

    LANGUAGE lanaguageProgrammversionenEN = new LANGUAGE();
    lanaguageProgrammversionenEN.setISO639(ISO639.EN);
    lanaguageProgrammversionenEN.setTEXT("Program versions");

    LANGUAGE lanaguageProgrammversionenES = new LANGUAGE();
    lanaguageProgrammversionenES.setISO639(ISO639.ES);
    lanaguageProgrammversionenES.setTEXT("Versiones de programas");

    languagesProgrammversionen.getLANGUAGE().add(lanaguageProgrammversionenDE);
    languagesProgrammversionen.getLANGUAGE().add(lanaguageProgrammversionenEN);
    languagesProgrammversionen.getLANGUAGE().add(lanaguageProgrammversionenES);
    commandStringProgrammversionen.setLANGUAGES(languagesProgrammversionen);

    COMMAND commandStringSpitzname = new COMMAND();
    commandStringSpitzname.setKEY(KEY.STRING_SPITZNAME);
    LANGUAGES languagesSpitzname = new LANGUAGES();
    LANGUAGE lanaguageStringSpitznameDE = new LANGUAGE();
    lanaguageStringSpitznameDE.setISO639(ISO639.DE);
    lanaguageStringSpitznameDE.setTEXT("Nickanmes");

    LANGUAGE lanaguageStringSpitznameEN = new LANGUAGE();
    lanaguageStringSpitznameEN.setISO639(ISO639.EN);
    lanaguageStringSpitznameEN.setTEXT("Nicknames");

    LANGUAGE lanaguageStringSpitznameES = new LANGUAGE();
    lanaguageStringSpitznameES.setISO639(ISO639.ES);
    lanaguageStringSpitznameES.setTEXT("Alias");

    languagesSpitzname.getLANGUAGE().add(lanaguageStringSpitznameDE);
    languagesSpitzname.getLANGUAGE().add(lanaguageStringSpitznameEN);
    languagesSpitzname.getLANGUAGE().add(lanaguageStringSpitznameES);
    commandStringSpitzname.setLANGUAGES(languagesSpitzname);

    COMMAND commandAufMeinerDomaene = new COMMAND();
    commandAufMeinerDomaene.setKEY(KEY.LABEL_AUF_MEINER_DOMAENE);
    LANGUAGES languagesAufMeinerDomaene = new LANGUAGES();
    LANGUAGE lanaguageAufMeinerDomaeneDE = new LANGUAGE();
    lanaguageAufMeinerDomaeneDE.setISO639(ISO639.DE);
    lanaguageAufMeinerDomaeneDE.setTEXT("Auf meiner Domäne");

    LANGUAGE lanaguageAufMeinerDomaeneEN = new LANGUAGE();
    lanaguageAufMeinerDomaeneEN.setISO639(ISO639.EN);
    lanaguageAufMeinerDomaeneEN.setTEXT("On my domain");

    LANGUAGE lanaguageAufMeinerDomaeneES = new LANGUAGE();
    lanaguageAufMeinerDomaeneES.setISO639(ISO639.ES);
    lanaguageAufMeinerDomaeneES.setTEXT("En mi dominio");

    languagesAufMeinerDomaene.getLANGUAGE().add(lanaguageAufMeinerDomaeneDE);
    languagesAufMeinerDomaene.getLANGUAGE().add(lanaguageAufMeinerDomaeneEN);
    languagesAufMeinerDomaene.getLANGUAGE().add(lanaguageAufMeinerDomaeneES);
    commandAufMeinerDomaene.setLANGUAGES(languagesAufMeinerDomaene);

    COMMAND commandOffeneDomaene = new COMMAND();
    commandOffeneDomaene.setKEY(KEY.RADIO_BUTTON_OFFENE_DOMAENE);
    LANGUAGES languagesOffeneDomaene = new LANGUAGES();
    LANGUAGE lanaguageOffeneDomaeneDE = new LANGUAGE();
    lanaguageOffeneDomaeneDE.setISO639(ISO639.DE);
    lanaguageOffeneDomaeneDE.setTEXT("darf jedermann ein Konto einrichten und loslegen.");

    LANGUAGE lanaguageOffeneDomaeneEN = new LANGUAGE();
    lanaguageOffeneDomaeneEN.setISO639(ISO639.EN);
    lanaguageOffeneDomaeneEN.setTEXT("anyone can create an account and get started.");

    LANGUAGE lanaguageOffeneDomaeneES = new LANGUAGE();
    lanaguageOffeneDomaeneES.setISO639(ISO639.ES);
    lanaguageOffeneDomaeneES.setTEXT("cualquiera puede crear una cuenta y empezar.");

    languagesOffeneDomaene.getLANGUAGE().add(lanaguageOffeneDomaeneDE);
    languagesOffeneDomaene.getLANGUAGE().add(lanaguageOffeneDomaeneEN);
    languagesOffeneDomaene.getLANGUAGE().add(lanaguageOffeneDomaeneES);
    commandOffeneDomaene.setLANGUAGES(languagesOffeneDomaene);

    COMMAND commandGeschlosseneDomaene = new COMMAND();
    commandGeschlosseneDomaene.setKEY(KEY.RADIO_BUTTON_GESCHLOSSENE_DOMAENE);
    LANGUAGES languagesGeschlosseneDomaene = new LANGUAGES();
    LANGUAGE lanaguageGeschlosseneDomeaneDE = new LANGUAGE();
    lanaguageGeschlosseneDomeaneDE.setISO639(ISO639.DE);
    lanaguageGeschlosseneDomeaneDE.setTEXT("muss ein Administrator das neue Konto freischalten.");
    languagesGeschlosseneDomaene.getLANGUAGE().add(lanaguageGeschlosseneDomeaneDE);

    LANGUAGE lanaguageGeschlosseneDomeaneEN = new LANGUAGE();
    lanaguageGeschlosseneDomeaneEN.setISO639(ISO639.EN);
    lanaguageGeschlosseneDomeaneEN.setTEXT("an administrator must to activate the new account.");
    languagesGeschlosseneDomaene.getLANGUAGE().add(lanaguageGeschlosseneDomeaneEN);

    LANGUAGE lanaguageGeschlosseneDomeaneES = new LANGUAGE();
    lanaguageGeschlosseneDomeaneES.setISO639(ISO639.ES);
    lanaguageGeschlosseneDomeaneES.setTEXT("un administrador tiene que activar la nueva cuenta.");
    languagesGeschlosseneDomaene.getLANGUAGE().add(lanaguageGeschlosseneDomeaneES);

    languagesGeschlosseneDomaene.getLANGUAGE().add(lanaguageGeschlosseneDomeaneEN);
    languagesGeschlosseneDomaene.getLANGUAGE().add(lanaguageGeschlosseneDomeaneES);
    commandGeschlosseneDomaene.setLANGUAGES(languagesGeschlosseneDomaene);

    COMMAND commandKonfigurationseinstellungen_Speichern = new COMMAND();
    commandKonfigurationseinstellungen_Speichern.setKEY(KEY.STRING_KONFIGURATIONSEINSTELLUNGEN_SPEICHERN);
    LANGUAGES languagesKonfigurationseinstellungenSpeichern = new LANGUAGES();
    LANGUAGE lanaguageKonfigurationseinstellungenSpeichernDE = new LANGUAGE();
    lanaguageKonfigurationseinstellungenSpeichernDE.setISO639(ISO639.DE);
    lanaguageKonfigurationseinstellungenSpeichernDE
        .setTEXT("Die Konfigurationseinstellungen wurden gespeichert.");

    LANGUAGE lanaguageKonfigurationseinstellungenSpeichernEN = new LANGUAGE();
    lanaguageKonfigurationseinstellungenSpeichernEN.setISO639(ISO639.EN);
    lanaguageKonfigurationseinstellungenSpeichernEN.setTEXT("he configuration settings have been saved.");

    LANGUAGE lanaguageKonfigurationseinstellungenSpeichernES = new LANGUAGE();
    lanaguageKonfigurationseinstellungenSpeichernES.setISO639(ISO639.ES);
    lanaguageKonfigurationseinstellungenSpeichernES.setTEXT("Los ajustes de configuración se han guardado.");

    languagesKonfigurationseinstellungenSpeichern.getLANGUAGE()
        .add(lanaguageKonfigurationseinstellungenSpeichernDE);
    languagesKonfigurationseinstellungenSpeichern.getLANGUAGE()
        .add(lanaguageKonfigurationseinstellungenSpeichernEN);
    languagesKonfigurationseinstellungenSpeichern.getLANGUAGE()
        .add(lanaguageKonfigurationseinstellungenSpeichernES);
    commandKonfigurationseinstellungen_Speichern.setLANGUAGES(languagesKonfigurationseinstellungenSpeichern);

    COMMAND commandKonfigurationseinstellungen_Nicht_Speichern = new COMMAND();
    commandKonfigurationseinstellungen_Nicht_Speichern
        .setKEY(KEY.STRING_KONFIGURATIONSEINSTELLUNGEN_NICHT_SPEICHERN);
    LANGUAGES languagesKonfigurationseinstellungenNichtSpeichern = new LANGUAGES();
    LANGUAGE lanaguageKonfigurationseinstellungenNichtSpeichernDE = new LANGUAGE();
    lanaguageKonfigurationseinstellungenNichtSpeichernDE.setISO639(ISO639.DE);
    lanaguageKonfigurationseinstellungenNichtSpeichernDE
        .setTEXT("Die Konfigurationseinstellungen wurden nicht gespeichert.");

    LANGUAGE lanaguageKonfigurationseinstellungenNichtSpeichernEN = new LANGUAGE();
    lanaguageKonfigurationseinstellungenNichtSpeichernEN.setISO639(ISO639.EN);
    lanaguageKonfigurationseinstellungenNichtSpeichernEN
        .setTEXT("The configuration settings were not saved.");

    LANGUAGE lanaguageKonfigurationseinstellungenNichtSpeichernES = new LANGUAGE();
    lanaguageKonfigurationseinstellungenNichtSpeichernES.setISO639(ISO639.ES);
    lanaguageKonfigurationseinstellungenNichtSpeichernES
        .setTEXT("Los ajustes de configuración no se han guardado.");

    languagesKonfigurationseinstellungenNichtSpeichern.getLANGUAGE()
        .add(lanaguageKonfigurationseinstellungenNichtSpeichernDE);
    languagesKonfigurationseinstellungenNichtSpeichern.getLANGUAGE()
        .add(lanaguageKonfigurationseinstellungenNichtSpeichernEN);
    languagesKonfigurationseinstellungenNichtSpeichern.getLANGUAGE()
        .add(lanaguageKonfigurationseinstellungenNichtSpeichernES);
    commandKonfigurationseinstellungen_Nicht_Speichern
        .setLANGUAGES(languagesKonfigurationseinstellungenNichtSpeichern);

    COMMAND commandSpeichernFehlgeschlagen = new COMMAND();
    commandSpeichernFehlgeschlagen.setKEY(KEY.STRING_SPEICHERN_FEHLGESCHALGEN);
    LANGUAGES languagesSpeichernFehlgeschlagen = new LANGUAGES();
    LANGUAGE lanaguageSpeichernFehlgeschalgenDE = new LANGUAGE();
    lanaguageSpeichernFehlgeschalgenDE.setISO639(ISO639.DE);
    lanaguageSpeichernFehlgeschalgenDE.setTEXT("Speichern fehlgeschlagen");

    LANGUAGE lanaguageSpeichernFehlgeschalgenEN = new LANGUAGE();
    lanaguageSpeichernFehlgeschalgenEN.setISO639(ISO639.EN);
    lanaguageSpeichernFehlgeschalgenEN.setTEXT("Save failed");

    LANGUAGE lanaguageSpeichernFehlgeschalgenES = new LANGUAGE();
    lanaguageSpeichernFehlgeschalgenES.setISO639(ISO639.ES);
    lanaguageSpeichernFehlgeschalgenES.setTEXT("Guardar falló");

    languagesSpeichernFehlgeschlagen.getLANGUAGE().add(lanaguageSpeichernFehlgeschalgenDE);
    languagesSpeichernFehlgeschlagen.getLANGUAGE().add(lanaguageSpeichernFehlgeschalgenEN);
    languagesSpeichernFehlgeschlagen.getLANGUAGE().add(lanaguageSpeichernFehlgeschalgenES);
    commandSpeichernFehlgeschlagen.setLANGUAGES(languagesSpeichernFehlgeschlagen);

    COMMAND commandUeberDenMailserver = new COMMAND();
    commandUeberDenMailserver.setKEY(KEY.STRING_UEBER_DEN_MAILSERVER);
    LANGUAGES languagesUeberDenMailserver = new LANGUAGES();
    LANGUAGE lanaguageUserberDenMailserverDE = new LANGUAGE();
    lanaguageUserberDenMailserverDE.setISO639(ISO639.DE);
    lanaguageUserberDenMailserverDE.setTEXT(
        "Über den Mailserver erhalten die Anwender Benachrichtigungen aller Art.<br>Kontoaktivitäten werden dem Administrator über das Administratorpostfach zugestellt."
    );
    languagesUeberDenMailserver.getLANGUAGE().add(lanaguageUserberDenMailserverDE);
    LANGUAGE lanaguageUserberDenMailserverEN = new LANGUAGE();
    lanaguageUserberDenMailserverEN.setISO639(ISO639.EN);
    lanaguageUserberDenMailserverEN.setTEXT(
        "Users receive notifications of all kinds via the mail server.<br>Account activities are delivered to the administrator via the administrator mailbox."
    );

    languagesUeberDenMailserver.getLANGUAGE().add(lanaguageUserberDenMailserverEN);
    LANGUAGE lanaguageUserberDenMailserverES = new LANGUAGE();
    lanaguageUserberDenMailserverES.setISO639(ISO639.ES);
    lanaguageUserberDenMailserverES.setTEXT(
        "Los usuarios reciben notificaciones de todo tipo a través del servidor de correo.<br>Las actividades de la cuenta se entregan al administrador a través del buzón del administrador."
    );

    languagesUeberDenMailserver.getLANGUAGE().add(lanaguageUserberDenMailserverES);
    commandUeberDenMailserver.setLANGUAGES(languagesUeberDenMailserver);

    COMMAND commandLabelPostausgangsserver = new COMMAND();
    commandLabelPostausgangsserver.setKEY(KEY.LABEL_PORT_AUSGANGSSERVER);
    LANGUAGES languagesPostAusgangsserver = new LANGUAGES();
    LANGUAGE lanaguagePostausgangserverDE = new LANGUAGE();
    lanaguagePostausgangserverDE.setISO639(ISO639.DE);
    lanaguagePostausgangserverDE.setTEXT("<html>Der Port vom Postausgangserver</html>");

    LANGUAGE lanaguagePostausgangserverEN = new LANGUAGE();
    lanaguagePostausgangserverEN.setISO639(ISO639.EN);
    lanaguagePostausgangserverEN.setTEXT("<html>Outgoing mail server port</html>");

    LANGUAGE lanaguagePostausgangserverES = new LANGUAGE();
    lanaguagePostausgangserverES.setISO639(ISO639.ES);
    lanaguagePostausgangserverES.setTEXT("<html>Puerto del servidor de correo saliente</html>");

    languagesPostAusgangsserver.getLANGUAGE().add(lanaguagePostausgangserverDE);
    languagesPostAusgangsserver.getLANGUAGE().add(lanaguagePostausgangserverEN);
    languagesPostAusgangsserver.getLANGUAGE().add(lanaguagePostausgangserverES);
    commandLabelPostausgangsserver.setLANGUAGES(languagesPostAusgangsserver);

    COMMAND commandLabelBenutzernamePostausgang = new COMMAND();
    commandLabelBenutzernamePostausgang.setKEY(KEY.LABEL_BENUTZERNAME_POSTAUSGANG);
    LANGUAGES languagesBenutzernamePostausgang = new LANGUAGES();
    LANGUAGE lanaguageBenutzernamePostausgangDE = new LANGUAGE();
    lanaguageBenutzernamePostausgangDE.setISO639(ISO639.DE);
    lanaguageBenutzernamePostausgangDE.setTEXT("Der Benutzername für den Postausgangserver");

    LANGUAGE lanaguageBenutzernamePostausgangEN = new LANGUAGE();
    lanaguageBenutzernamePostausgangEN.setISO639(ISO639.EN);
    lanaguageBenutzernamePostausgangEN.setTEXT("Username for the outgoing mail server");

    LANGUAGE lanaguageBenutzernamePostausgangES = new LANGUAGE();
    lanaguageBenutzernamePostausgangES.setISO639(ISO639.ES);
    lanaguageBenutzernamePostausgangES.setTEXT("El nombre de usuario para el servidor de correo saliente");

    languagesBenutzernamePostausgang.getLANGUAGE().add(lanaguageBenutzernamePostausgangDE);
    languagesBenutzernamePostausgang.getLANGUAGE().add(lanaguageBenutzernamePostausgangEN);
    languagesBenutzernamePostausgang.getLANGUAGE().add(lanaguageBenutzernamePostausgangES);
    commandLabelBenutzernamePostausgang.setLANGUAGES(languagesBenutzernamePostausgang);

    COMMAND commandLabelPostausgangserverMailversand = new COMMAND();
    commandLabelPostausgangserverMailversand.setKEY(KEY.LABEL_POSTAUSGANGSERVER_MAILVERSAND);
    LANGUAGES languagesPostausgangserverMailversand = new LANGUAGES();
    LANGUAGE lanaguagePostausgangserverMailversandDE = new LANGUAGE();
    lanaguagePostausgangserverMailversandDE.setISO639(ISO639.DE);
    lanaguagePostausgangserverMailversandDE.setTEXT("Der Postausgangserver für den Mailversand");

    LANGUAGE lanaguagePostausgangserverMailversandEN = new LANGUAGE();
    lanaguagePostausgangserverMailversandEN.setISO639(ISO639.EN);
    lanaguagePostausgangserverMailversandEN.setTEXT("Outgoing mail server");

    LANGUAGE lanaguagePostausgangserverMailversandES = new LANGUAGE();
    lanaguagePostausgangserverMailversandES.setISO639(ISO639.ES);
    lanaguagePostausgangserverMailversandES.setTEXT("El servidor de correo saliente para el envío de correo");

    languagesPostausgangserverMailversand.getLANGUAGE().add(lanaguagePostausgangserverMailversandDE);
    languagesPostausgangserverMailversand.getLANGUAGE().add(lanaguagePostausgangserverMailversandEN);
    languagesPostausgangserverMailversand.getLANGUAGE().add(lanaguagePostausgangserverMailversandES);
    commandLabelPostausgangserverMailversand.setLANGUAGES(languagesPostausgangserverMailversand);

    COMMAND commandLabelPasswortPostausgangserver = new COMMAND();
    commandLabelPasswortPostausgangserver.setKEY(KEY.LABEL_PASSWORT_POSTAUSGANGSERVER);
    LANGUAGES languagesPasswortPostausgangserver = new LANGUAGES();
    LANGUAGE lanaguagePasswortPostausgangserverDE = new LANGUAGE();
    lanaguagePasswortPostausgangserverDE.setISO639(ISO639.DE);
    lanaguagePasswortPostausgangserverDE.setTEXT("Das Passwort für den Postausgangserver");

    LANGUAGE lanaguagePasswortPostausgangserverEN = new LANGUAGE();
    lanaguagePasswortPostausgangserverEN.setISO639(ISO639.EN);
    lanaguagePasswortPostausgangserverEN.setTEXT("Password for the outgoing mail server");

    LANGUAGE lanaguagePasswortPostausgangserverES = new LANGUAGE();
    lanaguagePasswortPostausgangserverES.setISO639(ISO639.ES);
    lanaguagePasswortPostausgangserverES.setTEXT("La contraseña del servidor de correo saliente");

    languagesPasswortPostausgangserver.getLANGUAGE().add(lanaguagePasswortPostausgangserverDE);
    languagesPasswortPostausgangserver.getLANGUAGE().add(lanaguagePasswortPostausgangserverEN);
    languagesPasswortPostausgangserver.getLANGUAGE().add(lanaguagePasswortPostausgangserverES);
    commandLabelPasswortPostausgangserver.setLANGUAGES(languagesPasswortPostausgangserver);

    COMMAND commandLabelAdministratorpostfach = new COMMAND();
    LANGUAGES languagesAdministratorpostfach = new LANGUAGES();
    LANGUAGE lanaguageAdministratorpostfachDE = new LANGUAGE();
    lanaguageAdministratorpostfachDE.setISO639(ISO639.DE);
    lanaguageAdministratorpostfachDE.setTEXT("Das Administratorpostfach für Benachrichtigungen");

    LANGUAGE lanaguageAdministratorpostfachEN = new LANGUAGE();
    lanaguageAdministratorpostfachEN.setISO639(ISO639.EN);
    lanaguageAdministratorpostfachEN.setTEXT("Administrator mailbox for notifications");

    LANGUAGE lanaguageAdministratorpostfachES = new LANGUAGE();
    lanaguageAdministratorpostfachES.setISO639(ISO639.ES);
    lanaguageAdministratorpostfachES.setTEXT("El buzón del administrador para las notificaciones");

    languagesAdministratorpostfach.getLANGUAGE().add(lanaguageAdministratorpostfachDE);
    languagesAdministratorpostfach.getLANGUAGE().add(lanaguageAdministratorpostfachEN);
    languagesAdministratorpostfach.getLANGUAGE().add(lanaguageAdministratorpostfachES);
    commandLabelAdministratorpostfach.setLANGUAGES(languagesAdministratorpostfach);
    commandLabelAdministratorpostfach.setKEY(KEY.LABEL_ADMINISTRATORPOSTFACH);

    COMMAND commandButtonTestmail = new COMMAND();
    commandButtonTestmail.setKEY(KEY.BUTTON_TESTMAIL);
    LANGUAGES languagesTestmail = new LANGUAGES();
    LANGUAGE lanaguageTestmailDE = new LANGUAGE();
    lanaguageTestmailDE.setISO639(ISO639.DE);
    lanaguageTestmailDE.setTEXT("Testmail");

    LANGUAGE lanaguageTestmailEN = new LANGUAGE();
    lanaguageTestmailEN.setISO639(ISO639.EN);
    lanaguageTestmailEN.setTEXT("Testmail");

    LANGUAGE lanaguageTestmailES = new LANGUAGE();
    lanaguageTestmailES.setISO639(ISO639.ES);
    lanaguageTestmailES.setTEXT("Testmail");

    languagesTestmail.getLANGUAGE().add(lanaguageTestmailDE);
    languagesTestmail.getLANGUAGE().add(lanaguageTestmailEN);
    languagesTestmail.getLANGUAGE().add(lanaguageTestmailES);
    commandButtonTestmail.setLANGUAGES(languagesTestmail);

    COMMAND commandButtonEineTestmail = new COMMAND();
    commandButtonEineTestmail.setKEY(KEY.STRING_EINE_TESTMAIL_WURDE);
    LANGUAGES languagesEineTestmailWurde = new LANGUAGES();
    LANGUAGE lanaguageEineTestmailWurdeDE = new LANGUAGE();
    lanaguageEineTestmailWurdeDE.setISO639(ISO639.DE);
    lanaguageEineTestmailWurdeDE.setTEXT("Eine Testmail wurde gesendet an ");

    lanaguageEineTestmailWurdeDE.setTEXT(
        "<html>" + "<p style='text-align:center'>Eine Testmail wurde gesendet an</p>"
            + "<p style='text-align:center'><b> XXX </b></p>"
            + "<p style='text-align:center'> YYY </p>"
            + "</html>"
    );

    LANGUAGE lanaguageEineTestmailWurdeEN = new LANGUAGE();
    lanaguageEineTestmailWurdeEN.setISO639(ISO639.EN);
    lanaguageEineTestmailWurdeEN.setTEXT(
        "<html>" + "<p style='text-align:center'>A test email was sent to</p>"
            + "<p style='text-align:center'><b> XXX </b></p>"
            + "<p style='text-align:center'> YYY </p>"
            + "</html>"
    );

    LANGUAGE lanaguageEineTestmailWurdeES = new LANGUAGE();
    lanaguageEineTestmailWurdeES.setISO639(ISO639.ES);
    lanaguageEineTestmailWurdeES.setTEXT(
        "<html>" + "<p style='text-align:center'>Se ha enviado un correo electrónico de prueba a</p>"
            + "<p style='text-align:center'><b> XXX </b></p>"
            + "<p style='text-align:center'> YYY </p>"
            + "</html>"
    );

    languagesEineTestmailWurde.getLANGUAGE().add(lanaguageEineTestmailWurdeDE);
    languagesEineTestmailWurde.getLANGUAGE().add(lanaguageEineTestmailWurdeEN);
    languagesEineTestmailWurde.getLANGUAGE().add(lanaguageEineTestmailWurdeES);
    commandButtonEineTestmail.setLANGUAGES(languagesEineTestmailWurde);

    COMMAND commandUeberprufe_Das = new COMMAND();
    commandUeberprufe_Das.setKEY(KEY.STRING_UEBERPRUEFE_DAS);
    LANGUAGES languagesUeberpruefeDas = new LANGUAGES();
    LANGUAGE lanaguageUeberpruefeDasDE = new LANGUAGE();
    lanaguageUeberpruefeDasDE.setISO639(ISO639.DE);
    lanaguageUeberpruefeDasDE.setTEXT("Überprüfe das Adminpostfach, ob die Testmail angekommen ist.");

    LANGUAGE lanaguageUeberpruefeDasEN = new LANGUAGE();
    lanaguageUeberpruefeDasEN.setISO639(ISO639.EN);
    lanaguageUeberpruefeDasEN.setTEXT("Check the admin mailbox to see if the test mail has arrived.");

    LANGUAGE lanaguageUeberpruefeDasES = new LANGUAGE();
    lanaguageUeberpruefeDasES.setISO639(ISO639.ES);
    lanaguageUeberpruefeDasES
        .setTEXT("Compruebe el buzón del administrador para ver si el correo de prueba ha llegado.");

    languagesUeberpruefeDas.getLANGUAGE().add(lanaguageUeberpruefeDasDE);
    languagesUeberpruefeDas.getLANGUAGE().add(lanaguageUeberpruefeDasEN);
    languagesUeberpruefeDas.getLANGUAGE().add(lanaguageUeberpruefeDasES);
    commandUeberprufe_Das.setLANGUAGES(languagesUeberpruefeDas);

    COMMAND commandDerSchwellenwert = new COMMAND();
    commandDerSchwellenwert.setKEY(KEY.LABEL_DER_SCHWELLENWERT);
    LANGUAGES languagesDerSchwellenwert = new LANGUAGES();
    LANGUAGE lanaguageDerSchwellenwertDE = new LANGUAGE();
    lanaguageDerSchwellenwertDE.setISO639(ISO639.DE);
    lanaguageDerSchwellenwertDE.setTEXT(
        "<html>Der Schwellenwert für einen öffentlichen Pausenraum,<br>bevor er in ein Forum umgewandelt wird.</html>"
    );

    LANGUAGE lanaguageDerSchwellenwertEN = new LANGUAGE();
    lanaguageDerSchwellenwertEN.setISO639(ISO639.EN);
    lanaguageDerSchwellenwertEN
        .setTEXT("The threshold for a public break room before it is converted to a forum.");

    LANGUAGE lanaguageDerSchwellenwertES = new LANGUAGE();
    lanaguageDerSchwellenwertES.setISO639(ISO639.ES);
    lanaguageDerSchwellenwertES
        .setTEXT("El umbral de una sala de descanso pública antes de convertirse en un foro.");

    languagesDerSchwellenwert.getLANGUAGE().add(lanaguageDerSchwellenwertDE);
    languagesDerSchwellenwert.getLANGUAGE().add(lanaguageDerSchwellenwertEN);
    languagesDerSchwellenwert.getLANGUAGE().add(lanaguageDerSchwellenwertES);
    commandDerSchwellenwert.setLANGUAGES(languagesDerSchwellenwert);

    COMMAND commandLabelMinuten = new COMMAND();
    commandLabelMinuten.setKEY(KEY.LABEL_MINUTEN);
    LANGUAGES languagesMinuten = new LANGUAGES();
    LANGUAGE lanaguageMinutenDE = new LANGUAGE();
    lanaguageMinutenDE.setISO639(ISO639.DE);
    lanaguageMinutenDE.setTEXT("<html>Minuten</html>");

    LANGUAGE lanaguageMinutenEN = new LANGUAGE();
    lanaguageMinutenEN.setISO639(ISO639.EN);
    lanaguageMinutenEN.setTEXT("<html>Minutes</html>");

    LANGUAGE lanaguageMinutenES = new LANGUAGE();
    lanaguageMinutenES.setISO639(ISO639.ES);
    lanaguageMinutenES.setTEXT("<html>Minutos</html>");

    languagesMinuten.getLANGUAGE().add(lanaguageMinutenDE);
    languagesMinuten.getLANGUAGE().add(lanaguageMinutenEN);
    languagesMinuten.getLANGUAGE().add(lanaguageMinutenES);
    commandLabelMinuten.setLANGUAGES(languagesMinuten);

    COMMAND commandLabelEinChatfilterSchlaegt = new COMMAND();
    commandLabelEinChatfilterSchlaegt.setKEY(KEY.LABEL_EIN_CHATFILTER_SCHLAEGT);
    LANGUAGES languagesEinChatfilterSchlaegt = new LANGUAGES();
    LANGUAGE lanaguageEinChatfilterSchlaegtDE = new LANGUAGE();
    lanaguageEinChatfilterSchlaegtDE.setISO639(ISO639.DE);
    lanaguageEinChatfilterSchlaegtDE.setTEXT(
        "<html>Ein Raumfilter schlägt an, wenn eine bestimmte Zeichenfolge im Chatnamen enthalten ist. Zwischen Großschreibung und Kleinschreibung wird nicht unterschieden.</html>"
    );
    LANGUAGE lanaguageEinChatfilterSchlaegtEN = new LANGUAGE();
    lanaguageEinChatfilterSchlaegtEN.setISO639(ISO639.EN);
    lanaguageEinChatfilterSchlaegtEN.setTEXT(
        "<html>A room filter is triggered if the string is included in the room name. There is no distinction between upper and lower case.</html>"
    );

    LANGUAGE lanaguageEinChatfilterSchlaegtES = new LANGUAGE();
    lanaguageEinChatfilterSchlaegtES.setISO639(ISO639.ES);
    lanaguageEinChatfilterSchlaegtES.setTEXT(
        "<html>Un filtro de sala se activa si la cadena está incluida en el nombre de la sala. No se hace distinción entre mayúsculas y minúsculas.</html>"
    );

    languagesEinChatfilterSchlaegt.getLANGUAGE().add(lanaguageEinChatfilterSchlaegtDE);
    languagesEinChatfilterSchlaegt.getLANGUAGE().add(lanaguageEinChatfilterSchlaegtEN);
    languagesEinChatfilterSchlaegt.getLANGUAGE().add(lanaguageEinChatfilterSchlaegtES);

    commandLabelEinChatfilterSchlaegt.setLANGUAGES(languagesEinChatfilterSchlaegt);

    COMMAND commandFilterHinzufuegen = new COMMAND();
    commandFilterHinzufuegen.setKEY(KEY.BUTTON_FILTER_HINZUFUEGEN);
    LANGUAGES languagesFilterHinzufuegen = new LANGUAGES();
    LANGUAGE lanaguageFilterHinzufuegenDE = new LANGUAGE();
    lanaguageFilterHinzufuegenDE.setISO639(ISO639.DE);
    lanaguageFilterHinzufuegenDE.setTEXT("Filter hinzufügen");

    LANGUAGE lanaguageFilterHinzufuegenEN = new LANGUAGE();
    lanaguageFilterHinzufuegenEN.setISO639(ISO639.EN);
    lanaguageFilterHinzufuegenEN.setTEXT("Add filter");

    LANGUAGE lanaguageFilterHinzufuegenES = new LANGUAGE();
    lanaguageFilterHinzufuegenES.setISO639(ISO639.ES);
    lanaguageFilterHinzufuegenES.setTEXT("Añadir filtro");

    languagesFilterHinzufuegen.getLANGUAGE().add(lanaguageFilterHinzufuegenDE);
    languagesFilterHinzufuegen.getLANGUAGE().add(lanaguageFilterHinzufuegenEN);
    languagesFilterHinzufuegen.getLANGUAGE().add(lanaguageFilterHinzufuegenES);
    commandFilterHinzufuegen.setLANGUAGES(languagesFilterHinzufuegen);

    COMMAND commandFilterEntfernen = new COMMAND();
    commandFilterEntfernen.setKEY(KEY.BUTTON_FILTER_ENTFERNEN);
    LANGUAGES languagesFilterEntfernen = new LANGUAGES();
    LANGUAGE lanaguageFilterEntfernenDE = new LANGUAGE();
    lanaguageFilterEntfernenDE.setISO639(ISO639.DE);
    lanaguageFilterEntfernenDE.setTEXT("Filter entfernen");

    LANGUAGE lanaguageFilterEntfernenEN = new LANGUAGE();
    lanaguageFilterEntfernenEN.setISO639(ISO639.EN);
    lanaguageFilterEntfernenEN.setTEXT("Remove filters");

    LANGUAGE lanaguageFilterEntfernenES = new LANGUAGE();
    lanaguageFilterEntfernenES.setISO639(ISO639.ES);
    lanaguageFilterEntfernenES.setTEXT("Eliminar filtros");

    languagesFilterEntfernen.getLANGUAGE().add(lanaguageFilterEntfernenDE);
    languagesFilterEntfernen.getLANGUAGE().add(lanaguageFilterEntfernenEN);
    languagesFilterEntfernen.getLANGUAGE().add(lanaguageFilterEntfernenES);
    commandFilterEntfernen.setLANGUAGES(languagesFilterEntfernen);

    COMMAND commandDieTestmailKonnte = new COMMAND();
    commandDieTestmailKonnte.setKEY(KEY.STRING_DIE_TESTMAIL_KONNTE);
    LANGUAGES languagesDieTestmailKonnte = new LANGUAGES();
    LANGUAGE lanaguageDieTestmailKonnteDE = new LANGUAGE();
    lanaguageDieTestmailKonnteDE.setISO639(ISO639.DE);
    lanaguageDieTestmailKonnteDE.setTEXT("Die Testmail konnte nicht gesendet werden an <b>");

    LANGUAGE lanaguageDieTestmailKonnteEN = new LANGUAGE();
    lanaguageDieTestmailKonnteEN.setISO639(ISO639.EN);
    lanaguageDieTestmailKonnteEN.setTEXT("The test mail could not be sent to <b>");

    LANGUAGE lanaguageDieTestmailKonnteES = new LANGUAGE();
    lanaguageDieTestmailKonnteES.setISO639(ISO639.ES);
    lanaguageDieTestmailKonnteES.setTEXT("El correo de prueba no pudo ser enviado a <b>");

    languagesDieTestmailKonnte.getLANGUAGE().add(lanaguageDieTestmailKonnteDE);
    languagesDieTestmailKonnte.getLANGUAGE().add(lanaguageDieTestmailKonnteEN);
    languagesDieTestmailKonnte.getLANGUAGE().add(lanaguageDieTestmailKonnteES);
    commandDieTestmailKonnte.setLANGUAGES(languagesDieTestmailKonnte);

    COMMAND commandTestmailNichtGesendet = new COMMAND();
    commandTestmailNichtGesendet.setKEY(KEY.STRING_TESTMAIL_NICHT_GESENDET);
    LANGUAGES languagesTestmailNichtGesendet = new LANGUAGES();
    LANGUAGE lanaguageTestmailNichtGesendetDE = new LANGUAGE();
    lanaguageTestmailNichtGesendetDE.setISO639(ISO639.DE);
    lanaguageTestmailNichtGesendetDE.setTEXT(" - Testmail nicht gesendet");

    LANGUAGE lanaguageTestmailNichtGesendetEN = new LANGUAGE();
    lanaguageTestmailNichtGesendetEN.setISO639(ISO639.EN);
    lanaguageTestmailNichtGesendetEN.setTEXT(" - Test mail not sent");

    LANGUAGE lanaguageTestmailNichtGesendetES = new LANGUAGE();
    lanaguageTestmailNichtGesendetES.setISO639(ISO639.ES);
    lanaguageTestmailNichtGesendetES.setTEXT(" - Correo de prueba no enviado");

    languagesTestmailNichtGesendet.getLANGUAGE().add(lanaguageTestmailNichtGesendetDE);
    languagesTestmailNichtGesendet.getLANGUAGE().add(lanaguageTestmailNichtGesendetEN);
    languagesTestmailNichtGesendet.getLANGUAGE().add(lanaguageTestmailNichtGesendetES);
    commandTestmailNichtGesendet.setLANGUAGES(languagesTestmailNichtGesendet);

    COMMAND commandStringBenutzerstatus = new COMMAND();
    commandStringBenutzerstatus.setKEY(KEY.STRING_BENUTZERSTATUS);
    LANGUAGES languagesStringBenutzerstatus = new LANGUAGES();
    LANGUAGE lanaguageBenutzerstatusDE = new LANGUAGE();
    lanaguageBenutzerstatusDE.setISO639(ISO639.DE);
    lanaguageBenutzerstatusDE.setTEXT("Benutzerstatus");

    LANGUAGE lanaguageBenutzerstatusEN = new LANGUAGE();
    lanaguageBenutzerstatusEN.setISO639(ISO639.EN);
    lanaguageBenutzerstatusEN.setTEXT("User status");

    LANGUAGE lanaguageBenutzerstatusES = new LANGUAGE();
    lanaguageBenutzerstatusES.setISO639(ISO639.ES);
    lanaguageBenutzerstatusES.setTEXT("Estado del usuario");

    languagesStringBenutzerstatus.getLANGUAGE().add(lanaguageBenutzerstatusDE);
    languagesStringBenutzerstatus.getLANGUAGE().add(lanaguageBenutzerstatusEN);
    languagesStringBenutzerstatus.getLANGUAGE().add(lanaguageBenutzerstatusES);
    commandStringBenutzerstatus.setLANGUAGES(languagesStringBenutzerstatus);

    COMMAND commandStringMail = new COMMAND();
    commandStringMail.setKEY(KEY.STRING_MAIL);
    LANGUAGES languagesMail = new LANGUAGES();
    LANGUAGE lanaguageMailDE = new LANGUAGE();
    lanaguageMailDE.setISO639(ISO639.DE);
    lanaguageMailDE.setTEXT("E-Mail");

    LANGUAGE lanaguageMailEN = new LANGUAGE();
    lanaguageMailEN.setISO639(ISO639.EN);
    lanaguageMailEN.setTEXT("email");

    LANGUAGE lanaguageMailES = new LANGUAGE();
    lanaguageMailES.setISO639(ISO639.ES);
    lanaguageMailES.setTEXT("Correo electrónico");

    languagesMail.getLANGUAGE().add(lanaguageMailDE);
    languagesMail.getLANGUAGE().add(lanaguageMailEN);
    languagesMail.getLANGUAGE().add(lanaguageMailES);
    commandStringMail.setLANGUAGES(languagesMail);

    COMMAND commandStringVeralteteVersionen = new COMMAND();
    commandStringVeralteteVersionen.setKEY(KEY.LABEL_VERALTETE_VERSIONEN);
    LANGUAGES languagesVeralteteVersionen = new LANGUAGES();
    LANGUAGE lanaguageVeralteteVersionenDE = new LANGUAGE();
    lanaguageVeralteteVersionenDE.setISO639(ISO639.DE);
    lanaguageVeralteteVersionenDE.setTEXT("veraltete Versionen");

    LANGUAGE lanaguageVeralteteVersionenEN = new LANGUAGE();
    lanaguageVeralteteVersionenEN.setISO639(ISO639.EN);
    lanaguageVeralteteVersionenEN.setTEXT("Outdated versions");

    LANGUAGE lanaguageVeralteteVersionenES = new LANGUAGE();
    lanaguageVeralteteVersionenES.setISO639(ISO639.ES);
    lanaguageVeralteteVersionenES.setTEXT("Versiones obsoletas");

    languagesVeralteteVersionen.getLANGUAGE().add(lanaguageVeralteteVersionenDE);
    languagesVeralteteVersionen.getLANGUAGE().add(lanaguageVeralteteVersionenEN);
    languagesVeralteteVersionen.getLANGUAGE().add(lanaguageVeralteteVersionenES);
    commandStringVeralteteVersionen.setLANGUAGES(languagesVeralteteVersionen);

    COMMAND commandVeralteteVersion = new COMMAND();
    commandVeralteteVersion.setKEY(KEY.STRING_VERALTETE_VERSION);
    LANGUAGES languagesVeralteteVersion = new LANGUAGES();
    LANGUAGE lanaguageVeralteteVersionDE = new LANGUAGE();
    lanaguageVeralteteVersionDE.setISO639(ISO639.DE);
    lanaguageVeralteteVersionDE.setTEXT("Veraltete Version");

    LANGUAGE lanaguageVeralteteVersionEN = new LANGUAGE();
    lanaguageVeralteteVersionEN.setISO639(ISO639.EN);
    lanaguageVeralteteVersionEN.setTEXT("Outdated version");

    LANGUAGE lanaguageVeralteteVersionES = new LANGUAGE();
    lanaguageVeralteteVersionES.setISO639(ISO639.ES);
    lanaguageVeralteteVersionES.setTEXT("Versión obsoleta");

    languagesVeralteteVersion.getLANGUAGE().add(lanaguageVeralteteVersionDE);
    languagesVeralteteVersion.getLANGUAGE().add(lanaguageVeralteteVersionEN);
    languagesVeralteteVersion.getLANGUAGE().add(lanaguageVeralteteVersionES);
    commandVeralteteVersion.setLANGUAGES(languagesVeralteteVersion);

    COMMAND commandVersion = new COMMAND();
    commandVersion.setKEY(KEY.STRING_VERSION);
    LANGUAGES languagesStringVersion = new LANGUAGES();
    LANGUAGE lanaguageStringVersionDE = new LANGUAGE();
    lanaguageStringVersionDE.setISO639(ISO639.DE);
    lanaguageStringVersionDE.setTEXT("Version");

    LANGUAGE lanaguageStringVersionEN = new LANGUAGE();
    lanaguageStringVersionEN.setISO639(ISO639.EN);
    lanaguageStringVersionEN.setTEXT("Version");

    LANGUAGE lanaguageStringVersionES = new LANGUAGE();
    lanaguageStringVersionES.setISO639(ISO639.ES);
    lanaguageStringVersionES.setTEXT("Versión");

    languagesStringVersion.getLANGUAGE().add(lanaguageStringVersionDE);
    languagesStringVersion.getLANGUAGE().add(lanaguageStringVersionEN);
    languagesStringVersion.getLANGUAGE().add(lanaguageStringVersionES);
    commandVersion.setLANGUAGES(languagesStringVersion);

    COMMAND commandVerboteneSpitznamen = new COMMAND();
    commandVerboteneSpitznamen.setKEY(KEY.LABEL_VERBOTENE_SPITZNAMEN);
    LANGUAGES languagesVerboteneSpitznamen = new LANGUAGES();
    LANGUAGE lanaguageVerboteneSpitznamenDE = new LANGUAGE();
    lanaguageVerboteneSpitznamenDE.setISO639(ISO639.DE);
    lanaguageVerboteneSpitznamenDE.setTEXT("verbotene Nicknames");

    LANGUAGE lanaguageVerboteneSpitznamenEN = new LANGUAGE();
    lanaguageVerboteneSpitznamenEN.setISO639(ISO639.EN);
    lanaguageVerboteneSpitznamenEN.setTEXT("prohibited nicknames");

    LANGUAGE lanaguageVerboteneSpitznamenES = new LANGUAGE();
    lanaguageVerboteneSpitznamenES.setISO639(ISO639.ES);
    lanaguageVerboteneSpitznamenES.setTEXT("alias prohibidos");

    languagesVerboteneSpitznamen.getLANGUAGE().add(lanaguageVerboteneSpitznamenDE);
    languagesVerboteneSpitznamen.getLANGUAGE().add(lanaguageVerboteneSpitznamenEN);
    languagesVerboteneSpitznamen.getLANGUAGE().add(lanaguageVerboteneSpitznamenES);
    commandVerboteneSpitznamen.setLANGUAGES(languagesVerboteneSpitznamen);

    COMMAND commandSpitznameHinzufuegen = new COMMAND();
    commandSpitznameHinzufuegen.setKEY(KEY.BUTTON_SPITZNAME_HINZUFUEGEN);
    LANGUAGES languagesSpitznameHinzufuegen = new LANGUAGES();
    LANGUAGE lanaguageSpitznameHinzufuegenDE = new LANGUAGE();
    lanaguageSpitznameHinzufuegenDE.setISO639(ISO639.DE);
    lanaguageSpitznameHinzufuegenDE.setTEXT("Nickname hinzufügen");

    LANGUAGE lanaguageSpitznameHinzufuegenEN = new LANGUAGE();
    lanaguageSpitznameHinzufuegenEN.setISO639(ISO639.EN);
    lanaguageSpitznameHinzufuegenEN.setTEXT("Add nickname");

    LANGUAGE lanaguageSpitznameHinzufuegenES = new LANGUAGE();
    lanaguageSpitznameHinzufuegenES.setISO639(ISO639.ES);
    lanaguageSpitznameHinzufuegenES.setTEXT("Añadir alias");

    languagesSpitznameHinzufuegen.getLANGUAGE().add(lanaguageSpitznameHinzufuegenDE);
    languagesSpitznameHinzufuegen.getLANGUAGE().add(lanaguageSpitznameHinzufuegenEN);
    languagesSpitznameHinzufuegen.getLANGUAGE().add(lanaguageSpitznameHinzufuegenES);
    commandSpitznameHinzufuegen.setLANGUAGES(languagesSpitznameHinzufuegen);

    COMMAND commandSpitznameEntfernen = new COMMAND();
    commandSpitznameEntfernen.setKEY(KEY.BUTTON_SPITZNAME_ENTFERNEN);
    LANGUAGES languagesSpitznameEntfernen = new LANGUAGES();
    LANGUAGE lanaguageSpitznameEntfernenDE = new LANGUAGE();
    lanaguageSpitznameEntfernenDE.setISO639(ISO639.DE);
    lanaguageSpitznameEntfernenDE.setTEXT("Nicknames entfernen");

    LANGUAGE lanaguageSpitznameEntfernenEN = new LANGUAGE();
    lanaguageSpitznameEntfernenEN.setISO639(ISO639.EN);
    lanaguageSpitznameEntfernenEN.setTEXT("Remove Nicknames");

    LANGUAGE lanaguageSpitznameEntfernenES = new LANGUAGE();
    lanaguageSpitznameEntfernenES.setISO639(ISO639.ES);
    lanaguageSpitznameEntfernenES.setTEXT("Eliminar alias");

    languagesSpitznameEntfernen.getLANGUAGE().add(lanaguageSpitznameEntfernenDE);
    languagesSpitznameEntfernen.getLANGUAGE().add(lanaguageSpitznameEntfernenEN);
    languagesSpitznameEntfernen.getLANGUAGE().add(lanaguageSpitznameEntfernenES);
    commandSpitznameEntfernen.setLANGUAGES(languagesSpitznameEntfernen);

    COMMAND commandLabelEinVerbotenerSpitzname = new COMMAND();
    commandLabelEinVerbotenerSpitzname.setKEY(KEY.LABEL_EIN_VERBOTENER_SPITZNAME);
    LANGUAGES languagesLABEL_EIN_VERBOTENER_SPITZNAME = new LANGUAGES();
    LANGUAGE lanaguageLabelEinVerbotenerSpitznameDE = new LANGUAGE();
    lanaguageLabelEinVerbotenerSpitznameDE.setISO639(ISO639.DE);
    lanaguageLabelEinVerbotenerSpitznameDE.setTEXT(
        "<html>Ein verbotener Nickname ist ein Filter. Er schlägt an, wenn das Kürzel im ausgeschriebenen Nickname enthalten ist. "
            + "Zwischen Großschreibung und Kleinschreibung wird nicht unterschieden.</html>"
    );

    LANGUAGE lanaguageLabelEinVerbotenerSpitznameEN = new LANGUAGE();
    lanaguageLabelEinVerbotenerSpitznameEN.setISO639(ISO639.EN);
    lanaguageLabelEinVerbotenerSpitznameEN.setTEXT(
        "<html>A forbidden nickname is a filter. It strikes if the abbreviation is contained in the written nickname. "
            + "There is no distinction between upper and lower case.</html>"
    );

    LANGUAGE lanaguageLabelEinVerbotenerSpitznameES = new LANGUAGE();
    lanaguageLabelEinVerbotenerSpitznameES.setISO639(ISO639.ES);
    lanaguageLabelEinVerbotenerSpitznameES.setTEXT(
        "<html>Un alias prohibido es un filtro. Se golpea si la abreviatura está contenida en el alias escrito. "
            + "No se distingue entre mayúsculas y minúsculas.</html>"
    );

    languagesLABEL_EIN_VERBOTENER_SPITZNAME.getLANGUAGE().add(lanaguageLabelEinVerbotenerSpitznameDE);
    languagesLABEL_EIN_VERBOTENER_SPITZNAME.getLANGUAGE().add(lanaguageLabelEinVerbotenerSpitznameEN);
    languagesLABEL_EIN_VERBOTENER_SPITZNAME.getLANGUAGE().add(lanaguageLabelEinVerbotenerSpitznameES);
    commandLabelEinVerbotenerSpitzname.setLANGUAGES(languagesLABEL_EIN_VERBOTENER_SPITZNAME);

    COMMAND commandStringVerbotenerSpitzname = new COMMAND();
    commandStringVerbotenerSpitzname.setKEY(KEY.STRING_VERBOTENER_SPITZNAME);
    LANGUAGES languagesVerbotenerSpitzname = new LANGUAGES();
    LANGUAGE lanaguageStringVerbotenerSpitznameDE = new LANGUAGE();
    lanaguageStringVerbotenerSpitznameDE.setISO639(ISO639.DE);
    lanaguageStringVerbotenerSpitznameDE.setTEXT("Verbotener Nickname");

    LANGUAGE lanaguageStringVerbotenerSpitznameEN = new LANGUAGE();
    lanaguageStringVerbotenerSpitznameEN.setISO639(ISO639.EN);
    lanaguageStringVerbotenerSpitznameEN.setTEXT("Forbidden nickname");

    LANGUAGE lanaguageStringVerbotenerSpitznameES = new LANGUAGE();
    lanaguageStringVerbotenerSpitznameES.setISO639(ISO639.ES);
    lanaguageStringVerbotenerSpitznameES.setTEXT("Prohibido alias");

    languagesVerbotenerSpitzname.getLANGUAGE().add(lanaguageStringVerbotenerSpitznameDE);
    languagesVerbotenerSpitzname.getLANGUAGE().add(lanaguageStringVerbotenerSpitznameEN);
    languagesVerbotenerSpitzname.getLANGUAGE().add(lanaguageStringVerbotenerSpitznameES);
    commandStringVerbotenerSpitzname.setLANGUAGES(languagesVerbotenerSpitzname);

    COMMAND commandStringAlleVerbotenenSpitznamen = new COMMAND();
    commandStringAlleVerbotenenSpitznamen.setKEY(KEY.STRING_ALLE_VERBOTENEN_SPITZNAMEN);
    LANGUAGES languagesStringAlleVerbotenenSpitznamen = new LANGUAGES();
    LANGUAGE lanaguageStringAlleVerbotenenSpitznamenDE = new LANGUAGE();
    lanaguageStringAlleVerbotenenSpitznamenDE.setISO639(ISO639.DE);
    lanaguageStringAlleVerbotenenSpitznamenDE.setTEXT("Alle verbotenen Nicknames wurden gespeichert.");

    LANGUAGE lanaguageStringAlleVerbotenenSpitznamenEN = new LANGUAGE();
    lanaguageStringAlleVerbotenenSpitznamenEN.setISO639(ISO639.EN);
    lanaguageStringAlleVerbotenenSpitznamenEN.setTEXT("All prohibited nicknames Have Been Saved.");

    LANGUAGE lanaguageStringAlleVerbotenenSpitznamenES = new LANGUAGE();
    lanaguageStringAlleVerbotenenSpitznamenES.setISO639(ISO639.ES);
    lanaguageStringAlleVerbotenenSpitznamenES.setTEXT("Todos los alias prohibidos se han guardado.");

    languagesStringAlleVerbotenenSpitznamen.getLANGUAGE().add(lanaguageStringAlleVerbotenenSpitznamenDE);
    languagesStringAlleVerbotenenSpitznamen.getLANGUAGE().add(lanaguageStringAlleVerbotenenSpitznamenEN);
    languagesStringAlleVerbotenenSpitznamen.getLANGUAGE().add(lanaguageStringAlleVerbotenenSpitznamenES);
    commandStringAlleVerbotenenSpitznamen.setLANGUAGES(languagesStringAlleVerbotenenSpitznamen);

    COMMAND commandDieSpitznamenKonntenNicht = new COMMAND();
    commandDieSpitznamenKonntenNicht.setKEY(KEY.STRING_DIE_SPITZNAMEN_KONNTEN_NICHT);
    LANGUAGES languagesDieSpitznamenKonntenNicht = new LANGUAGES();
    LANGUAGE lanaguageDieSpitznamenKonntenNichtDE = new LANGUAGE();
    lanaguageDieSpitznamenKonntenNichtDE.setISO639(ISO639.DE);
    lanaguageDieSpitznamenKonntenNichtDE.setTEXT("Die Nicknames konnten nicht gespeichert werden.");

    LANGUAGE lanaguageDieSpitznamenKonntenNichtEN = new LANGUAGE();
    lanaguageDieSpitznamenKonntenNichtEN.setISO639(ISO639.EN);
    lanaguageDieSpitznamenKonntenNichtEN.setTEXT("Nicknames could not be saved.");

    LANGUAGE lanaguageDieSpitznamenKonntenNichtES = new LANGUAGE();
    lanaguageDieSpitznamenKonntenNichtES.setISO639(ISO639.ES);
    lanaguageDieSpitznamenKonntenNichtES.setTEXT("No se pudieron guardar los alias.");

    languagesDieSpitznamenKonntenNicht.getLANGUAGE().add(lanaguageDieSpitznamenKonntenNichtDE);
    languagesDieSpitznamenKonntenNicht.getLANGUAGE().add(lanaguageDieSpitznamenKonntenNichtEN);
    languagesDieSpitznamenKonntenNicht.getLANGUAGE().add(lanaguageDieSpitznamenKonntenNichtES);
    commandDieSpitznamenKonntenNicht.setLANGUAGES(languagesDieSpitznamenKonntenNicht);

    COMMAND commandMoechteMitgliedWerden = new COMMAND();
    commandMoechteMitgliedWerden.setKEY(KEY.STRING_MOECHTE_MITGLIED_WERDEN);
    LANGUAGES languagesMoechteMitgliedWerden = new LANGUAGES();
    LANGUAGE lanaguageMoechteMitgliedWerdenDE = new LANGUAGE();
    lanaguageMoechteMitgliedWerdenDE.setISO639(ISO639.DE);
    lanaguageMoechteMitgliedWerdenDE.setTEXT("möchte Mitglied werden");

    LANGUAGE lanaguageMoechteMitgliedWerdenEN = new LANGUAGE();
    lanaguageMoechteMitgliedWerdenEN.setISO639(ISO639.DE);
    lanaguageMoechteMitgliedWerdenEN.setTEXT("wants to become a member");

    LANGUAGE lanaguageMoechteMitgliedWerdenES = new LANGUAGE();
    lanaguageMoechteMitgliedWerdenES.setISO639(ISO639.ES);
    lanaguageMoechteMitgliedWerdenES.setTEXT("quiere ser miembro");

    languagesMoechteMitgliedWerden.getLANGUAGE().add(lanaguageMoechteMitgliedWerdenDE);
    languagesMoechteMitgliedWerden.getLANGUAGE().add(lanaguageMoechteMitgliedWerdenEN);
    languagesMoechteMitgliedWerden.getLANGUAGE().add(lanaguageMoechteMitgliedWerdenES);
    commandMoechteMitgliedWerden.setLANGUAGES(languagesMoechteMitgliedWerden);

    COMMAND commandMembershipConfirmed = new COMMAND();
    commandMembershipConfirmed.setKEY(KEY.STRING_MEMBERSHIP_CONFIRMED);
    LANGUAGES languagesSTRING_MEMBERSHIP_CONFIRMED = new LANGUAGES();
    LANGUAGE lanaguageMembershipConfirmedDE = new LANGUAGE();
    lanaguageMembershipConfirmedDE.setISO639(ISO639.DE);
    lanaguageMembershipConfirmedDE.setTEXT("Mitgliedschaft bestätigt");

    LANGUAGE lanaguageMembershipConfirmedEN = new LANGUAGE();
    lanaguageMembershipConfirmedEN.setISO639(ISO639.EN);
    lanaguageMembershipConfirmedEN.setTEXT("Membership confirms");

    LANGUAGE lanaguageMembershipConfirmedES = new LANGUAGE();
    lanaguageMembershipConfirmedES.setISO639(ISO639.ES);
    lanaguageMembershipConfirmedES.setTEXT("Pertenencia confirma");

    languagesSTRING_MEMBERSHIP_CONFIRMED.getLANGUAGE().add(lanaguageMembershipConfirmedDE);
    languagesSTRING_MEMBERSHIP_CONFIRMED.getLANGUAGE().add(lanaguageMembershipConfirmedEN);
    languagesSTRING_MEMBERSHIP_CONFIRMED.getLANGUAGE().add(lanaguageMembershipConfirmedES);
    commandMembershipConfirmed.setLANGUAGES(languagesSTRING_MEMBERSHIP_CONFIRMED);

    COMMAND commandStringMitgliedschaftAbegelehnt = new COMMAND();
    commandStringMitgliedschaftAbegelehnt.setKEY(KEY.STRING_MITGLIEDSCHAFT_ABGELEHNT);
    LANGUAGES languagesStringMitgliedschaftAbgelehnt = new LANGUAGES();
    LANGUAGE lanaguageStringMitgliedschaftAbgelehntDE = new LANGUAGE();
    lanaguageStringMitgliedschaftAbgelehntDE.setISO639(ISO639.DE);
    lanaguageStringMitgliedschaftAbgelehntDE.setTEXT("Mitgliedschaft abgelehnt");

    LANGUAGE lanaguageStringMitgliedschaftAbgelehntEN = new LANGUAGE();
    lanaguageStringMitgliedschaftAbgelehntEN.setISO639(ISO639.EN);
    lanaguageStringMitgliedschaftAbgelehntEN.setTEXT("Membership refused");

    LANGUAGE lanaguageStringMitgliedschaftAbgelehntES = new LANGUAGE();
    lanaguageStringMitgliedschaftAbgelehntES.setISO639(ISO639.ES);
    lanaguageStringMitgliedschaftAbgelehntES.setTEXT("Pertencia denegada");

    languagesStringMitgliedschaftAbgelehnt.getLANGUAGE().add(lanaguageStringMitgliedschaftAbgelehntDE);
    languagesStringMitgliedschaftAbgelehnt.getLANGUAGE().add(lanaguageStringMitgliedschaftAbgelehntEN);
    languagesStringMitgliedschaftAbgelehnt.getLANGUAGE().add(lanaguageStringMitgliedschaftAbgelehntES);
    commandStringMitgliedschaftAbegelehnt.setLANGUAGES(languagesStringMitgliedschaftAbgelehnt);

    COMMAND commandButtonVersionHinzufuegen = new COMMAND();
    commandButtonVersionHinzufuegen.setKEY(KEY.BUTTON_VERSION_HINZUFUEGEN);
    LANGUAGES languagesButtonVersionHinzufuegen = new LANGUAGES();
    LANGUAGE lanaguageVersionHinzufuegenDE = new LANGUAGE();
    lanaguageVersionHinzufuegenDE.setISO639(ISO639.DE);
    lanaguageVersionHinzufuegenDE.setTEXT("Version hinzufügen");

    LANGUAGE lanaguageVersionHinzufuegenEN = new LANGUAGE();
    lanaguageVersionHinzufuegenEN.setISO639(ISO639.EN);
    lanaguageVersionHinzufuegenEN.setTEXT("Add version");

    LANGUAGE lanaguageVersionHinzufuegenES = new LANGUAGE();
    lanaguageVersionHinzufuegenES.setISO639(ISO639.ES);
    lanaguageVersionHinzufuegenES.setTEXT("Añadir versión");

    languagesButtonVersionHinzufuegen.getLANGUAGE().add(lanaguageVersionHinzufuegenDE);
    languagesButtonVersionHinzufuegen.getLANGUAGE().add(lanaguageVersionHinzufuegenEN);
    languagesButtonVersionHinzufuegen.getLANGUAGE().add(lanaguageVersionHinzufuegenES);

    commandButtonVersionHinzufuegen.setLANGUAGES(languagesButtonVersionHinzufuegen);

    COMMAND commandButtonVersionEntfernen = new COMMAND();
    commandButtonVersionEntfernen.setKEY(KEY.BUTTON_VERSION_ENTFERNEN);
    LANGUAGES languagesButtonVersionEntfernen = new LANGUAGES();
    LANGUAGE lanaguageVersionEntfernenDE = new LANGUAGE();
    lanaguageVersionEntfernenDE.setTEXT("Version entfernen");
    lanaguageVersionEntfernenDE.setISO639(ISO639.DE);

    LANGUAGE lanaguageVersionEntfernenEN = new LANGUAGE();
    lanaguageVersionEntfernenEN.setTEXT("Remove version");
    lanaguageVersionEntfernenEN.setISO639(ISO639.EN);

    LANGUAGE lanaguageVersionEntfernenES = new LANGUAGE();
    lanaguageVersionEntfernenES.setTEXT("Eliminar versión");
    lanaguageVersionEntfernenES.setISO639(ISO639.ES);

    languagesButtonVersionEntfernen.getLANGUAGE().add(lanaguageVersionEntfernenDE);
    languagesButtonVersionEntfernen.getLANGUAGE().add(lanaguageVersionEntfernenEN);
    languagesButtonVersionEntfernen.getLANGUAGE().add(lanaguageVersionEntfernenES);
    commandButtonVersionEntfernen.setLANGUAGES(languagesButtonVersionEntfernen);

    COMMAND commandTooltipAnlage = new COMMAND();
    commandTooltipAnlage.setKEY(KEY.TOOLTIP_ANLAGE);
    LANGUAGES languagesTooltipAnlage = new LANGUAGES();
    LANGUAGE lanaguageTolltipAnlageDE = new LANGUAGE();
    lanaguageTolltipAnlageDE.setISO639(ISO639.DE);
    lanaguageTolltipAnlageDE.setTEXT("Mit der linken Maustaste klicken und die Datei herunterladen.");

    LANGUAGE lanaguageTolltipAnlageEN = new LANGUAGE();
    lanaguageTolltipAnlageEN.setISO639(ISO639.EN);
    lanaguageTolltipAnlageEN.setTEXT("Click with the left mouse button and download the file.");

    LANGUAGE lanaguageTolltipAnlageES = new LANGUAGE();
    lanaguageTolltipAnlageES.setISO639(ISO639.ES);
    lanaguageTolltipAnlageES.setTEXT("Haga clic con el botón izquierdo del ratón y descargue el archivo.");

    languagesTooltipAnlage.getLANGUAGE().add(lanaguageTolltipAnlageDE);
    languagesTooltipAnlage.getLANGUAGE().add(lanaguageTolltipAnlageEN);
    languagesTooltipAnlage.getLANGUAGE().add(lanaguageTolltipAnlageES);
    commandTooltipAnlage.setLANGUAGES(languagesTooltipAnlage);

    COMMAND commandStringAlleVeralteten = new COMMAND();
    commandStringAlleVeralteten.setKEY(KEY.STRING_ALLE_VERALTETEN);
    LANGUAGES languagesAlleVeralteten = new LANGUAGES();
    LANGUAGE lanaguageAlleVeraltetenDE = new LANGUAGE();
    lanaguageAlleVeraltetenDE.setISO639(ISO639.DE);
    lanaguageAlleVeraltetenDE.setTEXT("Alle veralteten Programmversionen wurden gespeichert.");

    LANGUAGE lanaguageAlleVeraltetenEN = new LANGUAGE();
    lanaguageAlleVeraltetenEN.setISO639(ISO639.EN);
    lanaguageAlleVeraltetenEN.setTEXT("All obsolete program versions have been saved.");

    LANGUAGE lanaguageAlleVeraltetenES = new LANGUAGE();
    lanaguageAlleVeraltetenES.setISO639(ISO639.ES);
    lanaguageAlleVeraltetenES.setTEXT("Se han guardado todas las versiones obsoletas del programa.");

    languagesAlleVeralteten.getLANGUAGE().add(lanaguageAlleVeraltetenDE);
    languagesAlleVeralteten.getLANGUAGE().add(lanaguageAlleVeraltetenEN);
    languagesAlleVeralteten.getLANGUAGE().add(lanaguageAlleVeraltetenES);
    commandStringAlleVeralteten.setLANGUAGES(languagesAlleVeralteten);

    COMMAND commandStringDieProgrammversionen = new COMMAND();
    commandStringDieProgrammversionen.setKEY(KEY.STRING_DIE_PROGRAMMVERSIONEN);
    LANGUAGES languagesDieProgrammversionen = new LANGUAGES();
    LANGUAGE lanaguageDieProgrammversionenDE = new LANGUAGE();
    lanaguageDieProgrammversionenDE.setISO639(ISO639.DE);
    lanaguageDieProgrammversionenDE.setTEXT("Die Programmversionen konnten nicht gespeichert werden.");

    LANGUAGE lanaguageDieProgrammversionenEN = new LANGUAGE();
    lanaguageDieProgrammversionenEN.setISO639(ISO639.EN);
    lanaguageDieProgrammversionenEN.setTEXT("The program versions could not be saved.");

    LANGUAGE lanaguageDieProgrammversionenES = new LANGUAGE();
    lanaguageDieProgrammversionenES.setISO639(ISO639.ES);
    lanaguageDieProgrammversionenES.setTEXT("Las versiones del programa no pudieron ser guardadas.");

    languagesDieProgrammversionen.getLANGUAGE().add(lanaguageDieProgrammversionenDE);
    languagesDieProgrammversionen.getLANGUAGE().add(lanaguageDieProgrammversionenEN);
    languagesDieProgrammversionen.getLANGUAGE().add(lanaguageDieProgrammversionenES);

    commandStringDieProgrammversionen.setLANGUAGES(languagesDieProgrammversionen);

    COMMAND commandStringLauter = new COMMAND();
    commandStringLauter.setKEY(KEY.STRING_LAUTER);
    LANGUAGES languagesStringLauter = new LANGUAGES();
    LANGUAGE lanaguageStringLauterDE = new LANGUAGE();
    lanaguageStringLauterDE.setISO639(ISO639.DE);
    lanaguageStringLauterDE.setTEXT("Lauter");

    LANGUAGE lanaguageStringLauterEN = new LANGUAGE();
    lanaguageStringLauterEN.setISO639(ISO639.EN);
    lanaguageStringLauterEN.setTEXT("Louder");

    LANGUAGE lanaguageStringLauterES = new LANGUAGE();
    lanaguageStringLauterES.setISO639(ISO639.ES);
    lanaguageStringLauterES.setTEXT("Más alto");

    languagesStringLauter.getLANGUAGE().add(lanaguageStringLauterDE);
    languagesStringLauter.getLANGUAGE().add(lanaguageStringLauterEN);
    languagesStringLauter.getLANGUAGE().add(lanaguageStringLauterES);
    commandStringLauter.setLANGUAGES(languagesStringLauter);

    COMMAND commandStringLeiser = new COMMAND();
    commandStringLeiser.setKEY(KEY.STRING_LEISER);
    LANGUAGES languagesStringLeiser = new LANGUAGES();
    LANGUAGE lanaguageStringLeiserDE = new LANGUAGE();
    lanaguageStringLeiserDE.setISO639(ISO639.DE);
    lanaguageStringLeiserDE.setTEXT("Leiser");

    LANGUAGE lanaguageStringLeiserEN = new LANGUAGE();
    lanaguageStringLeiserEN.setISO639(ISO639.EN);
    lanaguageStringLeiserEN.setTEXT("Quieter");

    LANGUAGE lanaguageStringLeiserES = new LANGUAGE();
    lanaguageStringLeiserES.setISO639(ISO639.ES);
    lanaguageStringLeiserES.setTEXT("Más bajo");

    languagesStringLeiser.getLANGUAGE().add(lanaguageStringLeiserDE);
    languagesStringLeiser.getLANGUAGE().add(lanaguageStringLeiserEN);
    languagesStringLeiser.getLANGUAGE().add(lanaguageStringLeiserES);
    commandStringLeiser.setLANGUAGES(languagesStringLeiser);

    // Der Veranstalter muss einen Schlüssel generieren, mit dem sich die Teilnehmer
    // einwählen können.
    // Der Schlüssel hat eine Ablaufzeit. Wenn die Zeit verstrichen ist, können
    // keine Teilnehmer mehr beitreten.
    // Der Schlüssel wird online und über E-Mail an die Teilnehmer übertragen.

    // avanzar = Forward

    COMMAND commandDerVeranstalterMuss = new COMMAND();
    commandDerVeranstalterMuss.setKEY(KEY.LABEL_DER_VERANSTALTER_MUSS);
    LANGUAGES languagesDerVeranstalterMuss = new LANGUAGES();
    LANGUAGE lanaguageDerVeranstalterMussDE = new LANGUAGE();
    lanaguageDerVeranstalterMussDE.setISO639(ISO639.DE);
    lanaguageDerVeranstalterMussDE.setTEXT(
        "<html>Für die Telko wird ein Schlüssel generiert, mit dem sich die Teilnehmer einwählen können. "
            + "Der Schlüssel hat eine Ablaufzeit. Wenn die Zeit verstrichen ist, können keine Teilnehmer mehr beitreten. "
            + "Der Schlüssel wird online und über E-Mail an die Teilnehmer übertragen.</html>"
    );

    LANGUAGE lanaguageDerVeranstalterMussEN = new LANGUAGE();
    lanaguageDerVeranstalterMussEN.setISO639(ISO639.EN);
    lanaguageDerVeranstalterMussEN.setTEXT(
        "<html>A key is generated for the conference call, with which the participants can dial in. "
            + "The key has an expiration time. When the time has elapsed, no more participants can join. "
            + "The key is transmitted online and via email to the participants.</html>"
    );

    LANGUAGE lanaguageDerVeranstalterMussES = new LANGUAGE();
    lanaguageDerVeranstalterMussES.setISO639(ISO639.ES);
    lanaguageDerVeranstalterMussES.setTEXT(
        "<html>Se genera una clave para la conferencia telefónica con la que los participantes pueden marcar. "
            + "La clave tiene un tiempo de caducidad. Una vez transcurrido este tiempo, no podrán marcar más participantes. "
            + "La clave se envía a los participantes en línea y por correo electrónico.</html>"
    );

    languagesDerVeranstalterMuss.getLANGUAGE().add(lanaguageDerVeranstalterMussDE);
    languagesDerVeranstalterMuss.getLANGUAGE().add(lanaguageDerVeranstalterMussEN);
    languagesDerVeranstalterMuss.getLANGUAGE().add(lanaguageDerVeranstalterMussES);
    commandDerVeranstalterMuss.setLANGUAGES(languagesDerVeranstalterMuss);

    COMMAND commandLabelAblaufdatum = new COMMAND();
    commandLabelAblaufdatum.setKEY(KEY.LABEL_ABLAUFDATUM);
    LANGUAGES languagesLabelAblaufdatum = new LANGUAGES();
    LANGUAGE lanaguageAblaufdatumDE = new LANGUAGE();
    lanaguageAblaufdatumDE.setISO639(ISO639.DE);
    lanaguageAblaufdatumDE.setTEXT("Verfallsdatum");

    LANGUAGE lanaguageAblaufdatumEN = new LANGUAGE();
    lanaguageAblaufdatumEN.setISO639(ISO639.EN);
    lanaguageAblaufdatumEN.setTEXT("Expiry Date");

    LANGUAGE lanaguageAblaufdatumES = new LANGUAGE();
    lanaguageAblaufdatumES.setISO639(ISO639.ES);
    lanaguageAblaufdatumES.setTEXT("Fecha de caducidad");

    languagesLabelAblaufdatum.getLANGUAGE().add(lanaguageAblaufdatumDE);
    languagesLabelAblaufdatum.getLANGUAGE().add(lanaguageAblaufdatumEN);
    languagesLabelAblaufdatum.getLANGUAGE().add(lanaguageAblaufdatumES);
    commandLabelAblaufdatum.setLANGUAGES(languagesLabelAblaufdatum);

    COMMAND commandWeitereTeilnehmer = new COMMAND();
    commandWeitereTeilnehmer.setKEY(KEY.STRING_WEITERE_TEILNEHMER);
    LANGUAGES languagesWeitereTeilnehmer = new LANGUAGES();
    LANGUAGE lanaguageWeitereTeilnehmerDE = new LANGUAGE();
    lanaguageWeitereTeilnehmerDE.setISO639(ISO639.DE);
    lanaguageWeitereTeilnehmerDE.setTEXT("weitere Teilnehmer");

    LANGUAGE lanaguageWeitereTeilnehmerEN = new LANGUAGE();
    lanaguageWeitereTeilnehmerEN.setISO639(ISO639.EN);
    lanaguageWeitereTeilnehmerEN.setTEXT("Further participants");

    LANGUAGE lanaguageWeitereTeilnehmerES = new LANGUAGE();
    lanaguageWeitereTeilnehmerES.setISO639(ISO639.ES);
    lanaguageWeitereTeilnehmerES.setTEXT("Más lejos participantes");

    languagesWeitereTeilnehmer.getLANGUAGE().add(lanaguageWeitereTeilnehmerDE);
    languagesWeitereTeilnehmer.getLANGUAGE().add(lanaguageWeitereTeilnehmerEN);
    languagesWeitereTeilnehmer.getLANGUAGE().add(lanaguageWeitereTeilnehmerES);
    commandWeitereTeilnehmer.setLANGUAGES(languagesWeitereTeilnehmer);

    COMMAND commandLabelKonfernzname = new COMMAND();
    commandLabelKonfernzname.setKEY(KEY.LABEL_KONFERENZNAME);
    LANGUAGES languagesLabelKonferenzname = new LANGUAGES();
    LANGUAGE lanaguageKonferenznameDE = new LANGUAGE();
    lanaguageKonferenznameDE.setISO639(ISO639.DE);
    lanaguageKonferenznameDE.setTEXT("Konferenzname");

    LANGUAGE lanaguageKonferenznameEN = new LANGUAGE();
    lanaguageKonferenznameEN.setISO639(ISO639.EN);
    lanaguageKonferenznameEN.setTEXT("Conference name");

    LANGUAGE lanaguageKonferenznameES = new LANGUAGE();
    lanaguageKonferenznameES.setISO639(ISO639.ES);
    lanaguageKonferenznameES.setTEXT("Nombre de la conferencia");

    languagesLabelKonferenzname.getLANGUAGE().add(lanaguageKonferenznameDE);
    languagesLabelKonferenzname.getLANGUAGE().add(lanaguageKonferenznameEN);
    languagesLabelKonferenzname.getLANGUAGE().add(lanaguageKonferenznameES);

    commandLabelKonfernzname.setLANGUAGES(languagesLabelKonferenzname);

    COMMAND commandLabelErstelleUeber = new COMMAND();
    commandLabelErstelleUeber.setKEY(KEY.LABEL_ERSTELLE_UEBER);
    LANGUAGES languagesLabelErstelleUeber = new LANGUAGES();
    LANGUAGE lanaguageErstelleUeberDE = new LANGUAGE();
    lanaguageErstelleUeberDE.setISO639(ISO639.DE);
    lanaguageErstelleUeberDE.setTEXT(
        "<html>Erstelle über das Feld <b>Konferenzname</b> eine neue Konferenz oder lade weitere Teilnehmer in die ausgewählte Konferenz ein.</html>"
    );
    LANGUAGE lanaguageErstelleUeberEN = new LANGUAGE();
    lanaguageErstelleUeberEN.setISO639(ISO639.EN);
    lanaguageErstelleUeberEN.setTEXT(
        "<html>Use the <b>Conference name</b> field to create a new conference or invite more participants to the selected conference.</html>"
    );
    LANGUAGE lanaguageErstelleUeberES = new LANGUAGE();
    lanaguageErstelleUeberES.setISO639(ISO639.ES);
    lanaguageErstelleUeberES.setTEXT(
        "<html>Utiliza el campo <b>Nombre de la conferencia</b> para crear una nueva conferencia o invitar a participantes adicionales a la conferencia seleccionada.</html>"
    );

    languagesLabelErstelleUeber.getLANGUAGE().add(lanaguageErstelleUeberDE);
    languagesLabelErstelleUeber.getLANGUAGE().add(lanaguageErstelleUeberEN);
    languagesLabelErstelleUeber.getLANGUAGE().add(lanaguageErstelleUeberES);

    commandLabelErstelleUeber.setLANGUAGES(languagesLabelErstelleUeber);

    COMMAND commandServerDieTestmail = new COMMAND();
    commandServerDieTestmail.setKEY(KEY.SERVER_DIE_TESTMAIL_KONNTE);
    LANGUAGES languagesServerDieTestmailMuss = new LANGUAGES();
    LANGUAGE languagesServerDieTestmailMussDE = new LANGUAGE();
    languagesServerDieTestmailMussDE.setISO639(ISO639.DE);
    languagesServerDieTestmailMussDE
        .setTEXT("Die Testmail konnte nicht an den Administrator gesendet werden.");

    LANGUAGE languagesServerDieTestmailMussEN = new LANGUAGE();
    languagesServerDieTestmailMussEN.setISO639(ISO639.EN);
    languagesServerDieTestmailMussEN.setTEXT("The test mail could not be sent to the administrator.");

    LANGUAGE languagesServerDieTestmailMussES = new LANGUAGE();
    languagesServerDieTestmailMussES.setISO639(ISO639.ES);
    languagesServerDieTestmailMussES.setTEXT("No se ha podido enviar el correo de prueba al administrador.");

    languagesServerDieTestmailMuss.getLANGUAGE().add(languagesServerDieTestmailMussES);
    languagesServerDieTestmailMuss.getLANGUAGE().add(languagesServerDieTestmailMussDE);
    languagesServerDieTestmailMuss.getLANGUAGE().add(languagesServerDieTestmailMussEN);

    commandServerDieTestmail.setLANGUAGES(languagesServerDieTestmailMuss);

    COMMAND commandStringContextXml = new COMMAND();
    commandStringContextXml.setKEY(KEY.STRING_IST_IN_DER_CONTEXT);
    LANGUAGES languagesContextXml = new LANGUAGES();

    LANGUAGE languagesContextxmlDE = new LANGUAGE();
    languagesContextxmlDE.setISO639(ISO639.DE);
    languagesContextxmlDE.setTEXT("ist in der context.xml hinterlegt.");

    LANGUAGE languagesContextxmlEN = new LANGUAGE();
    languagesContextxmlEN.setISO639(ISO639.EN);
    languagesContextxmlEN.setTEXT("is stored in context.xml.");

    LANGUAGE languagesContextxmlES = new LANGUAGE();
    languagesContextxmlES.setISO639(ISO639.ES);
    languagesContextxmlES.setTEXT("se almacena en context.xml.");

    languagesContextXml.getLANGUAGE().add(languagesContextxmlDE);
    languagesContextXml.getLANGUAGE().add(languagesContextxmlEN);
    languagesContextXml.getLANGUAGE().add(languagesContextxmlES);

    commandStringContextXml.setLANGUAGES(languagesContextXml);

    commands.getCOMMAND().add(commandStringContextXml);
    commands.getCOMMAND().add(commandServerDieTestmail);
    commands.getCOMMAND().add(commandLabelErstelleUeber);
    commands.getCOMMAND().add(commandLabelKonfernzname);
    commands.getCOMMAND().add(commandWeitereTeilnehmer);
    commands.getCOMMAND().add(commandLabelAblaufdatum);
    commands.getCOMMAND().add(commandDerVeranstalterMuss);
    commands.getCOMMAND().add(commandStringLeiser);
    commands.getCOMMAND().add(commandStringLauter);
    commands.getCOMMAND().add(commandStringDieProgrammversionen);
    commands.getCOMMAND().add(commandStringAlleVeralteten);
    commands.getCOMMAND().add(commandTooltipAnlage);
    commands.getCOMMAND().add(commandButtonVersionEntfernen);
    commands.getCOMMAND().add(commandButtonVersionHinzufuegen);
    commands.getCOMMAND().add(commandStringMitgliedschaftAbegelehnt);
    commands.getCOMMAND().add(commandMembershipConfirmed);
    commands.getCOMMAND().add(commandMoechteMitgliedWerden);
    commands.getCOMMAND().add(commandDieSpitznamenKonntenNicht);
    commands.getCOMMAND().add(commandStringAlleVerbotenenSpitznamen);
    commands.getCOMMAND().add(commandStringVerbotenerSpitzname);
    commands.getCOMMAND().add(commandLabelEinVerbotenerSpitzname);
    commands.getCOMMAND().add(commandSpitznameEntfernen);
    commands.getCOMMAND().add(commandSpitznameHinzufuegen);
    commands.getCOMMAND().add(commandVerboteneSpitznamen);
    commands.getCOMMAND().add(commandVersion);
    commands.getCOMMAND().add(commandVeralteteVersion);
    commands.getCOMMAND().add(commandStringVeralteteVersionen);
    commands.getCOMMAND().add(commandStringMail);
    commands.getCOMMAND().add(commandStringBenutzerstatus);
    commands.getCOMMAND().add(commandTestmailNichtGesendet);
    commands.getCOMMAND().add(commandJavacomm);
    commands.getCOMMAND().add(commandRegistrieren);
    commands.getCOMMAND().add(commandAnmelden);
    commands.getCOMMAND().add(commandPasswort);
    commands.getCOMMAND().add(commandAufWiedersehen);
    commands.getCOMMAND().add(commandKonto);
    commands.getCOMMAND().add(commandBearbeiten);
    commands.getCOMMAND().add(commandEis);
    commands.getCOMMAND().add(commandMokka);
    commands.getCOMMAND().add(commandVanille);
    commands.getCOMMAND().add(commandJoghurt);
    commands.getCOMMAND().add(commandBlaubeere);
    commands.getCOMMAND().add(commandErdbeere);
    commands.getCOMMAND().add(commandChat);
    commands.getCOMMAND().add(commandAlleRauemeAnzeigen);
    commands.getCOMMAND().add(commandForum);
    commands.getCOMMAND().add(commandBesprechungsraeume);
    commands.getCOMMAND().add(commandGruppenraeume);
    commands.getCOMMAND().add(commandPausenraeume);
    commands.getCOMMAND().add(commandPrivatgespraech);
    commands.getCOMMAND().add(commandChatanfragenAblehnen);
    commands.getCOMMAND().add(commandOnlinetransfer);
    commands.getCOMMAND().add(commandServerKonfigurieren);
    commands.getCOMMAND().add(commandHochladenHerunterladen);
    commands.getCOMMAND().add(commandSchwarzeListe);
    commands.getCOMMAND().add(commandMedienwiedergabe);
    commands.getCOMMAND().add(commandAdministrator);
    commands.getCOMMAND().add(commandTelefon);
    commands.getCOMMAND().add(commandInfo);
    commands.getCOMMAND().add(commandBildschirmuebertragung);
    commands.getCOMMAND().add(commandIPTV);
    commands.getCOMMAND().add(commandBildschirmEmpfangen);
    commands.getCOMMAND().add(commandBildschirmUebertragen);
    commands.getCOMMAND().add(commandTV);
    commands.getCOMMAND().add(commandTelefonEinrichten);
    commands.getCOMMAND().add(commandTelefonAnrufen);
    commands.getCOMMAND().add(commandTelefonateAblehnen);
    commands.getCOMMAND().add(commandLizenz);
    commands.getCOMMAND().add(commandAdministratorVerwalten);
    commands.getCOMMAND().add(commandTitel);
    commands.getCOMMAND().add(commandSpielliste);
    commands.getCOMMAND().add(commandMusikkiste);
    commands.getCOMMAND().add(commandMusikkisteLeeren);
    commands.getCOMMAND().add(commandDVD);
    commands.getCOMMAND().add(commandInhaltsverzeichnis);
    commands.getCOMMAND().add(commandFilmsprache);
    commands.getCOMMAND().add(commandVollbildmodus);
    commands.getCOMMAND().add(commandFensterImHintergrundHalten);
    commands.getCOMMAND().add(commandSprache);
    commands.getCOMMAND().add(commandTapete);
    commands.getCOMMAND().add(commandTapeteAbreissen);
    commands.getCOMMAND().add(commandTapeteAnkleben);
    commands.getCOMMAND().add(commandButtonAnmelden);
    commands.getCOMMAND().add(commandButtonAbbrechen);
    commands.getCOMMAND().add(commandLabelSprache);
    commands.getCOMMAND().add(commandLabelDomain);
    commands.getCOMMAND().add(commandLabelPasswort);
    commands.getCOMMAND().add(commandLabelEmail);
    commands.getCOMMAND().add(commandLabelTimeout);
    commands.getCOMMAND().add(commandLabelRSA);
    commands.getCOMMAND().add(commandButtonRegistrieren);
    commands.getCOMMAND().add(commandButtonWeiterOhneRegistrierung);
    commands.getCOMMAND().add(commandFrameLogin);
    commands.getCOMMAND().add(commandLabelNichtAngemeldet);
    commands.getCOMMAND().add(commandLabelAnmeldungFehlgeschlagen);
    commands.getCOMMAND().add(commandLabelAnmeldungErfolgreich);
    commands.getCOMMAND().add(commandButtonSchliessen);
    commands.getCOMMAND().add(commandLabelForum);
    commands.getCOMMAND().add(commandFrameLauncher);
    commands.getCOMMAND().add(commandMenuAnzeige);
    commands.getCOMMAND().add(commandCheckboxDatum);
    commands.getCOMMAND().add(commandCheckboxUhrzeit);
    commands.getCOMMAND().add(commandButtonAuswerfen);
    commands.getCOMMAND().add(commandLabelLaut);
    commands.getCOMMAND().add(commandLabelLautlos);
    commands.getCOMMAND().add(commandLabelLeise);
    commands.getCOMMAND().add(commandLabelNormal);
    commands.getCOMMAND().add(commandFrameProfil);
    commands.getCOMMAND().add(commandButtonSave);
    commands.getCOMMAND().add(commandButtonSave_Close);
    commands.getCOMMAND().add(commandLabelPasswortConfirm);
    commands.getCOMMAND().add(commandLabelBenutzerid);
    commands.getCOMMAND().add(commandLabelSpitzname);
    commands.getCOMMAND().add(commandTitledBorderVordergrundfarbe);
    commands.getCOMMAND().add(commandTitledBorderHintergrundfarbe);
    commands.getCOMMAND().add(commandButtonStartService);
    commands.getCOMMAND().add(commandButtonStopService);
    commands.getCOMMAND().add(commandFrameServerKonfigurieren);
    commands.getCOMMAND().add(commandLabelLautsprecher);
    commands.getCOMMAND().add(commandLabelMeinMikrofonIst);
    commands.getCOMMAND().add(commandLabelDieAbtastrate);
    commands.getCOMMAND().add(commandLabelStereo);
    commands.getCOMMAND().add(commandButtonDial);
    commands.getCOMMAND().add(commandButtonTelefonAbnehmen);
    commands.getCOMMAND().add(commandButtonTelefonAuflegen);
    commands.getCOMMAND().add(commandLabelPersonenSindOnline);
    commands.getCOMMAND().add(commandButtonTrefferliste);
    commands.getCOMMAND().add(commandButtonPublish);
    commands.getCOMMAND().add(commandLabelSuchenNach);
    commands.getCOMMAND().add(commandButtonSuchmusterAnlegen);
    commands.getCOMMAND().add(commandButtonSuchmusterEntfernen);
    commands.getCOMMAND().add(commandTitledBorderTrefferliste);
    commands.getCOMMAND().add(commandButtonTrennen);
    commands.getCOMMAND().add(commandStringDownload);
    commands.getCOMMAND().add(commandLabelDatei);
    commands.getCOMMAND().add(commandStringSchliessen);
    commands.getCOMMAND().add(commandStringSpeichern);
    commands.getCOMMAND().add(commandStringJoker);
    commands.getCOMMAND().add(commandStringSuchmuster);
    commands.getCOMMAND().add(commandStringChannel);
    commands.getCOMMAND().add(commandLabelSchwarzeListe);
    commands.getCOMMAND().add(commandFrameInfo);
    commands.getCOMMAND().add(commandCheckBoxEmpfang);
    commands.getCOMMAND().add(commandFrameBildschirmempfang);
    commands.getCOMMAND().add(commandLabelFuerDenEmpfang);
    commands.getCOMMAND().add(commandButtonStarten);
    commands.getCOMMAND().add(commandLabelAnWenSoll);
    commands.getCOMMAND().add(commandLabelUebertragungsrateProSekunde);
    commands.getCOMMAND().add(commandLabelBildschirmdatenAufzeichnen);
    commands.getCOMMAND().add(commandLabelService);
    commands.getCOMMAND().add(commandLabelServerstatus);
    commands.getCOMMAND().add(commandLabelTcpPort);
    commands.getCOMMAND().add(commandFrameTeilnehmer);
    commands.getCOMMAND().add(commandLabelStatus);
    commands.getCOMMAND().add(commandLabelOnline);
    commands.getCOMMAND().add(commandStringStatus);
    commands.getCOMMAND().add(commandButtonConfirm);
    commands.getCOMMAND().add(commandButtonAbschicken);
    commands.getCOMMAND().add(commandButtonAnfang);
    commands.getCOMMAND().add(commandButtonHoch);
    commands.getCOMMAND().add(commandButtonEnde);
    commands.getCOMMAND().add(commandButtonRunter);
    commands.getCOMMAND().add(commandStringOnline);
    commands.getCOMMAND().add(commandStringRaum);
    commands.getCOMMAND().add(commandStringLebenszeit);
    commands.getCOMMAND().add(commandStringOrt);
    commands.getCOMMAND().add(commandStringEigentuemer);
    commands.getCOMMAND().add(commandStringZutritt);
    commands.getCOMMAND().add(commandButtonRaumErstellen);
    commands.getCOMMAND().add(commandButtonRaumLoeschen);
    commands.getCOMMAND().add(commandLabelBenutzer);
    commands.getCOMMAND().add(commandLabelMitglieder);
    commands.getCOMMAND().add(commandLabelMeineBesprechungsraeume);
    commands.getCOMMAND().add(commandFrameBesprechungsraeume);
    commands.getCOMMAND().add(commandLabelWerEinen);
    commands.getCOMMAND().add(commandLabelRoboter);
    commands.getCOMMAND().add(commandLabelDerLautsprecher);
    commands.getCOMMAND().add(commandFrameTelefonEinrichten);
    commands.getCOMMAND().add(commandFrameSchwarzeListe);
    commands.getCOMMAND().add(commandFrameProjektor);
    commands.getCOMMAND().add(commandStringBeschreibung);
    commands.getCOMMAND().add(commandStringGesperrt);
    commands.getCOMMAND().add(commandStringSuffix);
    commands.getCOMMAND().add(commandLabelRaeume);
    commands.getCOMMAND().add(commandLabelZutritt);
    commands.getCOMMAND().add(commandRadioButtonProtected);
    commands.getCOMMAND().add(commandRadioButtonPublic);
    commands.getCOMMAND().add(commandLabelLicht);
    commands.getCOMMAND().add(commandFramePausenraum);
    commands.getCOMMAND().add(commandLabelFreunde);
    commands.getCOMMAND().add(commandStringDatei);
    commands.getCOMMAND().add(commandStringWurdeAbgebrochen);
    commands.getCOMMAND().add(commandStringWurdeErfolgreich);
    commands.getCOMMAND().add(commandLabelVeralteteProgrammversion);
    commands.getCOMMAND().add(commandStringVersionsPruefung);
    commands.getCOMMAND().add(commandFrameAnrufen);
    commands.getCOMMAND().add(commandStringCommandMikrofonIstAusgeschaltet);
    commands.getCOMMAND().add(commandStringEinMikrofonFehlt);
    commands.getCOMMAND().add(commandStringTelefonierenIstNichtMoeglich);
    commands.getCOMMAND().add(commandStringEinLautsprecherIst);
    commands.getCOMMAND().add(commandStringBisherWurde);
    commands.getCOMMAND().add(commandStringAktualisieren);
    commands.getCOMMAND().add(commandStringJa);
    commands.getCOMMAND().add(commandStringNein);
    commands.getCOMMAND().add(commandStringProgrammende);
    commands.getCOMMAND().add(commandStringSollDieLaufende);
    commands.getCOMMAND().add(commandStringDieVersionWurde);
    commands.getCOMMAND().add(commandStringProgrammaktualisierung);
    commands.getCOMMAND().add(commandLabelVersion);
    commands.getCOMMAND().add(commandStringLautsprecherEinrichten);
    commands.getCOMMAND().add(commandStringKeinMixer);
    commands.getCOMMAND().add(commandStringTelefonformatFalsch);
    commands.getCOMMAND().add(commandStringMikrofonnameIst_Unbekannt);
    commands.getCOMMAND().add(commandStringBluetooth);
    commands.getCOMMAND().add(commandStringMikrofonEinrichten);
    commands.getCOMMAND().add(commandStringHatEinMikrofonproblem);
    commands.getCOMMAND().add(commandStringBegrenzt);
    commands.getCOMMAND().add(commandStringUnbegrenzt);
    commands.getCOMMAND().add(commandStringDieSpalten);
    commands.getCOMMAND().add(commandStringHaken);
    commands.getCOMMAND().add(commandStringHakenMail);
    commands.getCOMMAND().add(commandStringBenutzerID);
    commands.getCOMMAND().add(commandStringPasswoerterStimmen);
    commands.getCOMMAND().add(commandStringPasswort);
    commands.getCOMMAND().add(commandStringDerSpitzname);
    commands.getCOMMAND().add(commandStringSpitznameLang);
    commands.getCOMMAND().add(commandStringGespraechBeginnen);
    commands.getCOMMAND().add(commandStringBenutzerEinladen);
    commands.getCOMMAND().add(commandStringBenutzerInDieTeilnehmerliste);
    commands.getCOMMAND().add(commandStringBenutzerAusDerTeilnehmerliste);
    commands.getCOMMAND().add(commandStringWaehleEineDatei);
    commands.getCOMMAND().add(commandStringUploadButton);
    commands.getCOMMAND().add(commandStringDownloadButton);
    commands.getCOMMAND().add(commandStringInDiesesVerzeichnis);
    commands.getCOMMAND().add(commandStringAusDiesemVerzeichnis);
    commands.getCOMMAND().add(commandStringDerServerMuss);
    commands.getCOMMAND().add(commandStringKeineAbspielbarenLieder);
    commands.getCOMMAND().add(commandStringDerZufallsmodus);
    commands.getCOMMAND().add(commandStringAlleMusikstuecke);
    commands.getCOMMAND().add(commandStringMusikkisteIstLeer);
    commands.getCOMMAND().add(commandStringAlleWiedergabelisten);
    commands.getCOMMAND().add(commandLabelStartmodus);
    commands.getCOMMAND().add(commandLabelServiceStatus);
    commands.getCOMMAND().add(commandLabelAngehalten);
    commands.getCOMMAND().add(commandLabelAufport);
    commands.getCOMMAND().add(commandLabelGestartet);
    commands.getCOMMAND().add(commandStringVonHandAus);
    commands.getCOMMAND().add(commandStringAutomatischStarten);
    commands.getCOMMAND().add(commandFrameFileSharing);
    commands.getCOMMAND().add(commandServerProfilGespeichert);
    commands.getCOMMAND().add(commandServerProfilNichtGespeichert);
    commands.getCOMMAND().add(commandServerKontodaten);
    commands.getCOMMAND().add(commandServerEmailInvalid);
    commands.getCOMMAND().add(commandServerNeuesPassword);
    commands.getCOMMAND().add(commandServerConfirmPassword);
    commands.getCOMMAND().add(commandServerWebconfirmPassword);
    commands.getCOMMAND().add(commandStringEsgehtGleichWeiter);
    commands.getCOMMAND().add(commandStringPasswortAnfordern);
    commands.getCOMMAND().add(commandServerErstanmeldung);
    commands.getCOMMAND().add(commandServerMailBetreff);
    commands.getCOMMAND().add(commandServerDasNeuePasswort);
    commands.getCOMMAND().add(commandServerDasAltePasswort);
    commands.getCOMMAND().add(commandStringMitgliedschaft);
    commands.getCOMMAND().add(commandStringMitgliedschaftBestaetigt);
    commands.getCOMMAND().add(commandStringMitgliedschaftAbgelehnt);
    commands.getCOMMAND().add(commandStringKontoGesperrt);
    commands.getCOMMAND().add(commandMitgliederlisteWurdeAngepasst);
    commands.getCOMMAND().add(commandLabelGruppenraumBeschreibung);
    commands.getCOMMAND().add(commandStringFreundeslisteErweitert);
    commands.getCOMMAND().add(commandServerChatraumVorhanden);
    commands.getCOMMAND().add(commandServerZuKurzerRaumname);
    commands.getCOMMAND().add(commandServerChatnameNichtErlaubt);
    commands.getCOMMAND().add(commandServerDerChatraumWurdeAngelegt);
    commands.getCOMMAND().add(commandStringIstAmTelefonieren);
    commands.getCOMMAND().add(commandStringNimmtKeineAnrufeEntgegen);
    commands.getCOMMAND().add(commandStringIstNichtErreichbar);
    commands.getCOMMAND().add(commandStringTelefonieren);
    commands.getCOMMAND().add(commandStringAnrufer);
    commands.getCOMMAND().add(commandStringIstNichtMehrOnline);
    commands.getCOMMAND().add(commandStringHatAufgelegt);
    commands.getCOMMAND().add(commandStringZeit);
    commands.getCOMMAND().add(commandStringNachricht);
    commands.getCOMMAND().add(commandStringZwischenablage);
    commands.getCOMMAND().add(commandStringEmailIstErforderlich);
    commands.getCOMMAND().add(commandPopupPaste);
    commands.getCOMMAND().add(commandPopupZeilenumbruch);
    commands.getCOMMAND().add(commandPopupTooltip);
    commands.getCOMMAND().add(commandTooltipTicker);
    commands.getCOMMAND().add(commandTooltipInput);
    commands.getCOMMAND().add(commandStringAnhang);
    commands.getCOMMAND().add(commandStringOpen);
    commands.getCOMMAND().add(commandStringAlleFormate);
    commands.getCOMMAND().add(commandStringTitelMarkieren);
    commands.getCOMMAND().add(commandStringDerKanalIstBelegt);
    commands.getCOMMAND().add(commandStringAlleKanaeleSindBelegt);
    commands.getCOMMAND().add(commandStringDateiname);
    commands.getCOMMAND().add(commandStringDateityp);
    commands.getCOMMAND().add(commandStringCommandAbgeschlossen);
    commands.getCOMMAND().add(commandServerDieDateiIst);
    commands.getCOMMAND().add(commandDasMedienformatWirdNicht);
    commands.getCOMMAND().add(commandStringMedienwiedergabe);
    commands.getCOMMAND().add(commandServerDerEmpfaengerIstVerschwunden);
    commands.getCOMMAND().add(commandServerLehntUebertragungenAb);
    commands.getCOMMAND().add(commandServerProjektorAusschalten);
    commands.getCOMMAND().add(commandStringMailserver);
    commands.getCOMMAND().add(commandStringBenutzerantraege);
    commands.getCOMMAND().add(commandStringRaumfilter);
    commands.getCOMMAND().add(commandStringProgrammversionen);
    commands.getCOMMAND().add(commandStringSpitzname);
    commands.getCOMMAND().add(commandAufMeinerDomaene);
    commands.getCOMMAND().add(commandOffeneDomaene);
    commands.getCOMMAND().add(commandGeschlosseneDomaene);
    commands.getCOMMAND().add(commandKonfigurationseinstellungen_Speichern);
    commands.getCOMMAND().add(commandKonfigurationseinstellungen_Nicht_Speichern);
    commands.getCOMMAND().add(commandSpeichernFehlgeschlagen);
    commands.getCOMMAND().add(commandUeberDenMailserver);
    commands.getCOMMAND().add(commandLabelPostausgangsserver);
    commands.getCOMMAND().add(commandLabelBenutzernamePostausgang);
    commands.getCOMMAND().add(commandLabelPostausgangserverMailversand);
    commands.getCOMMAND().add(commandLabelPasswortPostausgangserver);
    commands.getCOMMAND().add(commandLabelAdministratorpostfach);
    commands.getCOMMAND().add(commandButtonTestmail);
    commands.getCOMMAND().add(commandButtonEineTestmail);
    commands.getCOMMAND().add(commandUeberprufe_Das);
    commands.getCOMMAND().add(commandDerSchwellenwert);
    commands.getCOMMAND().add(commandLabelMinuten);
    commands.getCOMMAND().add(commandLabelEinChatfilterSchlaegt);
    commands.getCOMMAND().add(commandFilterHinzufuegen);
    commands.getCOMMAND().add(commandFilterEntfernen);
    commands.getCOMMAND().add(commandDieTestmailKonnte);

    createXml2(multilingual);

    // write(multilingual);
  }



  public void createXml2(MULTILINGUAL multilingual) throws JAXBException, IOException, SAXException {
    COMMANDS commands = multilingual.getCOMMANDS();

    COMMAND commandButtonNotify = new COMMAND();
    commandButtonNotify.setKEY(KEY.BUTTON_NOTIFY);
    LANGUAGES languagesNotify = new LANGUAGES();
    LANGUAGE lanaguageNotifyDE = new LANGUAGE();
    lanaguageNotifyDE.setISO639(ISO639.DE);
    lanaguageNotifyDE.setTEXT("Benachrichtigen");
    lanaguageNotifyDE.setSHORTCUT(VIRTUALKEY.VK_N);

    LANGUAGE lanaguageNotifyEN = new LANGUAGE();
    lanaguageNotifyEN.setISO639(ISO639.EN);
    lanaguageNotifyEN.setTEXT("Notify");
    lanaguageNotifyEN.setSHORTCUT(VIRTUALKEY.VK_N);

    LANGUAGE lanaguageNotifyES = new LANGUAGE();
    lanaguageNotifyES.setISO639(ISO639.ES);
    lanaguageNotifyES.setTEXT("Notificar");
    lanaguageNotifyES.setSHORTCUT(VIRTUALKEY.VK_N);

    languagesNotify.getLANGUAGE().add(lanaguageNotifyDE);
    languagesNotify.getLANGUAGE().add(lanaguageNotifyEN);
    languagesNotify.getLANGUAGE().add(lanaguageNotifyES);
    commandButtonNotify.setLANGUAGES(languagesNotify);

    COMMAND commandStringOrganize = new COMMAND();
    commandStringOrganize.setKEY(KEY.STRING_ORGANISIEREN);
    LANGUAGES languagesStringOrganize = new LANGUAGES();
    LANGUAGE lanaguageOrganizeDE = new LANGUAGE();
    lanaguageOrganizeDE.setISO639(ISO639.DE);
    lanaguageOrganizeDE.setTEXT("Telefonkonferenz bearbeiten");

    LANGUAGE lanaguageOrganizeEN = new LANGUAGE();
    lanaguageOrganizeEN.setISO639(ISO639.EN);
    lanaguageOrganizeEN.setTEXT("Edit Conference Call");

    LANGUAGE lanaguageOrganizeES = new LANGUAGE();
    lanaguageOrganizeES.setISO639(ISO639.ES);
    lanaguageOrganizeES.setTEXT("Editar conferencia telefónica");

    languagesStringOrganize.getLANGUAGE().add(lanaguageOrganizeDE);
    languagesStringOrganize.getLANGUAGE().add(lanaguageOrganizeEN);
    languagesStringOrganize.getLANGUAGE().add(lanaguageOrganizeES);
    commandStringOrganize.setLANGUAGES(languagesStringOrganize);

    COMMAND commandStringCreate = new COMMAND();
    commandStringCreate.setKEY(KEY.STRING_CREATE);
    LANGUAGES languagesStringCreate = new LANGUAGES();
    LANGUAGE lanaguageCreateDE = new LANGUAGE();
    lanaguageCreateDE.setISO639(ISO639.DE);
    lanaguageCreateDE.setTEXT("Erstellen...");
    lanaguageCreateDE.setSHORTCUT(VIRTUALKEY.VK_E);

    LANGUAGE lanaguageCreateEN = new LANGUAGE();
    lanaguageCreateEN.setISO639(ISO639.EN);
    lanaguageCreateEN.setTEXT("Create...");
    lanaguageCreateEN.setSHORTCUT(VIRTUALKEY.VK_C);

    LANGUAGE lanaguageCreateES = new LANGUAGE();
    lanaguageCreateES.setISO639(ISO639.ES);
    lanaguageCreateES.setTEXT("Crear...");
    lanaguageCreateES.setSHORTCUT(VIRTUALKEY.VK_C);

    languagesStringCreate.getLANGUAGE().add(lanaguageCreateDE);
    languagesStringCreate.getLANGUAGE().add(lanaguageCreateEN);
    languagesStringCreate.getLANGUAGE().add(lanaguageCreateES);
    commandStringCreate.setLANGUAGES(languagesStringCreate);

    COMMAND commandStringTeilnehmen = new COMMAND();
    commandStringTeilnehmen.setKEY(KEY.STRING_TEILNEHMEN);
    LANGUAGES languagesStringTeilnehmen = new LANGUAGES();
    LANGUAGE lanaguageTeilnehmenDE = new LANGUAGE();
    lanaguageTeilnehmenDE.setISO639(ISO639.DE);
    lanaguageTeilnehmenDE.setTEXT("Telefonkonferenz teilnehmen");

    LANGUAGE lanaguageTeilnehmenEN = new LANGUAGE();
    lanaguageTeilnehmenEN.setISO639(ISO639.EN);
    lanaguageTeilnehmenEN.setTEXT("Join Conference Call");

    LANGUAGE lanaguageTeilnehmenES = new LANGUAGE();
    lanaguageTeilnehmenES.setISO639(ISO639.ES);
    lanaguageTeilnehmenES.setTEXT("Unirse a la conferencia telefónica");

    languagesStringTeilnehmen.getLANGUAGE().add(lanaguageTeilnehmenDE);
    languagesStringTeilnehmen.getLANGUAGE().add(lanaguageTeilnehmenEN);
    languagesStringTeilnehmen.getLANGUAGE().add(lanaguageTeilnehmenES);
    commandStringTeilnehmen.setLANGUAGES(languagesStringTeilnehmen);

    COMMAND commandFrameTelefonkonferenzErstellen = new COMMAND();
    commandFrameTelefonkonferenzErstellen.setKEY(KEY.FRAME_TELEFONKONFERENZ_ERSTELLEN);
    LANGUAGES languagesTelefonkonferenzErstellen = new LANGUAGES();
    LANGUAGE lanaguageTelefonkonferenzErstellenDE = new LANGUAGE();
    lanaguageTelefonkonferenzErstellenDE.setISO639(ISO639.DE);
    lanaguageTelefonkonferenzErstellenDE.setTEXT("Telefonkonferenz erstellen");

    LANGUAGE lanaguageTelefonkonferenzErstellenEN = new LANGUAGE();
    lanaguageTelefonkonferenzErstellenEN.setISO639(ISO639.EN);
    lanaguageTelefonkonferenzErstellenEN.setTEXT("Create Conference Call");

    LANGUAGE lanaguageTelefonkonferenzErstellenES = new LANGUAGE();
    lanaguageTelefonkonferenzErstellenES.setISO639(ISO639.ES);
    lanaguageTelefonkonferenzErstellenES.setTEXT("Crear conferencia telefónica");

    languagesTelefonkonferenzErstellen.getLANGUAGE().add(lanaguageTelefonkonferenzErstellenDE);
    languagesTelefonkonferenzErstellen.getLANGUAGE().add(lanaguageTelefonkonferenzErstellenEN);
    languagesTelefonkonferenzErstellen.getLANGUAGE().add(lanaguageTelefonkonferenzErstellenES);

    commandFrameTelefonkonferenzErstellen.setLANGUAGES(languagesTelefonkonferenzErstellen);

    COMMAND commandStringNaechsterTitel = new COMMAND();
    commandStringNaechsterTitel.setKEY(KEY.STRING_NAECHSTER_TITEL);
    LANGUAGES languagesNaechsterTitel = new LANGUAGES();
    LANGUAGE lanaguageNaechsterTitelDE = new LANGUAGE();
    lanaguageNaechsterTitelDE.setISO639(ISO639.DE);
    lanaguageNaechsterTitelDE.setTEXT("Nächster Titel");

    LANGUAGE lanaguageNaechsterTitelEN = new LANGUAGE();
    lanaguageNaechsterTitelEN.setISO639(ISO639.EN);
    lanaguageNaechsterTitelEN.setTEXT("Next title");

    LANGUAGE lanaguageNaechsterTitelES = new LANGUAGE();
    lanaguageNaechsterTitelES.setISO639(ISO639.ES);
    lanaguageNaechsterTitelES.setTEXT("Siguiente título");

    languagesNaechsterTitel.getLANGUAGE().add(lanaguageNaechsterTitelDE);
    languagesNaechsterTitel.getLANGUAGE().add(lanaguageNaechsterTitelEN);
    languagesNaechsterTitel.getLANGUAGE().add(lanaguageNaechsterTitelES);
    commandStringNaechsterTitel.setLANGUAGES(languagesNaechsterTitel);

    COMMAND commandServerLehntChatanfragenAb = new COMMAND();
    commandServerLehntChatanfragenAb.setKEY(KEY.SERVER_LEHNT_CHATANFRAGEN_AB);
    LANGUAGES languagesServerLehntChatanfragenAb = new LANGUAGES();
    LANGUAGE lanaguageServerLehntChatanfragenAbDE = new LANGUAGE();
    lanaguageServerLehntChatanfragenAbDE.setISO639(ISO639.DE);
    lanaguageServerLehntChatanfragenAbDE.setTEXT("XXX lehnt Chatanfragen ab.");

    LANGUAGE lanaguageServerLehntChatanfragenAbEN = new LANGUAGE();
    lanaguageServerLehntChatanfragenAbEN.setISO639(ISO639.EN);
    lanaguageServerLehntChatanfragenAbEN.setTEXT("XXX rejects chat requests.");

    LANGUAGE lanaguageServerLehntChatanfragenAbES = new LANGUAGE();
    lanaguageServerLehntChatanfragenAbES.setISO639(ISO639.ES);
    lanaguageServerLehntChatanfragenAbES.setTEXT("XXX rechaza las solicitudes de chat.");

    languagesServerLehntChatanfragenAb.getLANGUAGE().add(lanaguageServerLehntChatanfragenAbDE);
    languagesServerLehntChatanfragenAb.getLANGUAGE().add(lanaguageServerLehntChatanfragenAbEN);
    languagesServerLehntChatanfragenAb.getLANGUAGE().add(lanaguageServerLehntChatanfragenAbES);

    commandServerLehntChatanfragenAb.setLANGUAGES(languagesServerLehntChatanfragenAb);

    COMMAND commandStringChattenAbgelehnt = new COMMAND();
    commandStringChattenAbgelehnt.setKEY(KEY.STRING_CHATTEN_ABGELEHNT);
    LANGUAGES languagesStringChattenAbgelehnt = new LANGUAGES();
    LANGUAGE lanaguageChattenAbgelehntDE = new LANGUAGE();
    lanaguageChattenAbgelehntDE.setISO639(ISO639.DE);
    lanaguageChattenAbgelehntDE.setTEXT("Chat abgelehnt");

    LANGUAGE lanaguageChattenAbgelehntEN = new LANGUAGE();
    lanaguageChattenAbgelehntEN.setISO639(ISO639.EN);
    lanaguageChattenAbgelehntEN.setTEXT("Chat refused");

    LANGUAGE lanaguageChattenAbgelehntES = new LANGUAGE();
    lanaguageChattenAbgelehntES.setISO639(ISO639.ES);
    lanaguageChattenAbgelehntES.setTEXT("Chat rechazado");

    languagesStringChattenAbgelehnt.getLANGUAGE().add(lanaguageChattenAbgelehntDE);
    languagesStringChattenAbgelehnt.getLANGUAGE().add(lanaguageChattenAbgelehntEN);
    languagesStringChattenAbgelehnt.getLANGUAGE().add(lanaguageChattenAbgelehntES);

    commandStringChattenAbgelehnt.setLANGUAGES(languagesStringChattenAbgelehnt);

    COMMAND commandLabelDieBeschreibungWird = new COMMAND();
    commandLabelDieBeschreibungWird.setKEY(KEY.LABEL_DIE_BESCHREIBUNG_WIRD);
    LANGUAGES languagesLabelDieBescreibungWird = new LANGUAGES();
    LANGUAGE lanaguageDieBeschreibungWirdDE = new LANGUAGE();
    lanaguageDieBeschreibungWirdDE.setISO639(ISO639.DE);
    lanaguageDieBeschreibungWirdDE.setTEXT(
        "<html>Die Beschreibung wird den Teilnehmern angezeigt. Sie kann auch weggelassen werden.</html>"
    );

    LANGUAGE lanaguageDieBeschreibungWirdEN = new LANGUAGE();
    lanaguageDieBeschreibungWirdEN.setISO639(ISO639.EN);
    lanaguageDieBeschreibungWirdEN
        .setTEXT("<html>The description is displayed to the participants. It can also be omitted.</html>");

    LANGUAGE lanaguageDieBeschreibungWirdES = new LANGUAGE();
    lanaguageDieBeschreibungWirdES.setISO639(ISO639.ES);
    lanaguageDieBeschreibungWirdES
        .setTEXT("<html>La descripción se muestra a los participantes. También se puede omitir.</html>");

    languagesLabelDieBescreibungWird.getLANGUAGE().add(lanaguageDieBeschreibungWirdDE);
    languagesLabelDieBescreibungWird.getLANGUAGE().add(lanaguageDieBeschreibungWirdEN);
    languagesLabelDieBescreibungWird.getLANGUAGE().add(lanaguageDieBeschreibungWirdES);

    commandLabelDieBeschreibungWird.setLANGUAGES(languagesLabelDieBescreibungWird);

    COMMAND commandStringForward = new COMMAND();
    commandStringForward.setKEY(KEY.STRING_FORWARD);
    LANGUAGES languagesStringForward = new LANGUAGES();
    LANGUAGE lanaguageForwardDE = new LANGUAGE();
    lanaguageForwardDE.setISO639(ISO639.DE);
    lanaguageForwardDE.setTEXT("Vorspulen");

    LANGUAGE lanaguageForwardEN = new LANGUAGE();
    lanaguageForwardEN.setISO639(ISO639.EN);
    lanaguageForwardEN.setTEXT("Forward");

    LANGUAGE lanaguageForwardES = new LANGUAGE();
    lanaguageForwardES.setISO639(ISO639.ES);
    lanaguageForwardES.setTEXT("Avanzar");

    languagesStringForward.getLANGUAGE().add(lanaguageForwardDE);
    languagesStringForward.getLANGUAGE().add(lanaguageForwardEN);
    languagesStringForward.getLANGUAGE().add(lanaguageForwardES);
    commandStringForward.setLANGUAGES(languagesStringForward);

    COMMAND commandStringBackward = new COMMAND();
    commandStringBackward.setKEY(KEY.STRING_BACKWARD);
    LANGUAGES languagesStringBackward = new LANGUAGES();
    LANGUAGE lanaguageBackwardDE = new LANGUAGE();
    lanaguageBackwardDE.setISO639(ISO639.DE);
    lanaguageBackwardDE.setTEXT("Zurückspulen");

    LANGUAGE lanaguageBackwardEN = new LANGUAGE();
    lanaguageBackwardEN.setISO639(ISO639.EN);
    lanaguageBackwardEN.setTEXT("Rewind");

    LANGUAGE lanaguageBackwardES = new LANGUAGE();
    lanaguageBackwardES.setISO639(ISO639.ES);
    lanaguageBackwardES.setTEXT("Rebobinar");

    languagesStringBackward.getLANGUAGE().add(lanaguageBackwardDE);
    languagesStringBackward.getLANGUAGE().add(lanaguageBackwardEN);
    languagesStringBackward.getLANGUAGE().add(lanaguageBackwardES);

    commandStringBackward.setLANGUAGES(languagesStringBackward);

    COMMAND commandLabelMeineKonferenzenOrganisieren = new COMMAND();
    commandLabelMeineKonferenzenOrganisieren.setKEY(KEY.LABEL_MEINE_KONFERENZEN_ORGANISIEREN);
    LANGUAGES languagesMeineKonferenzenOrganisieren = new LANGUAGES();
    LANGUAGE lanaguageMeineKonferenzenOranisierenDE = new LANGUAGE();
    lanaguageMeineKonferenzenOranisierenDE.setISO639(ISO639.DE);
    lanaguageMeineKonferenzenOranisierenDE.setTEXT("Meine Konferenzen organisieren");

    LANGUAGE lanaguageMeineKonferenzenOranisierenEN = new LANGUAGE();
    lanaguageMeineKonferenzenOranisierenEN.setISO639(ISO639.EN);
    lanaguageMeineKonferenzenOranisierenEN.setTEXT("Organize my conferences");

    LANGUAGE lanaguageMeineKonferenzenOranisierenES = new LANGUAGE();
    lanaguageMeineKonferenzenOranisierenES.setISO639(ISO639.ES);
    lanaguageMeineKonferenzenOranisierenES.setTEXT("Organizar mis conferencias");

    languagesMeineKonferenzenOrganisieren.getLANGUAGE().add(lanaguageMeineKonferenzenOranisierenDE);
    languagesMeineKonferenzenOrganisieren.getLANGUAGE().add(lanaguageMeineKonferenzenOranisierenEN);
    languagesMeineKonferenzenOrganisieren.getLANGUAGE().add(lanaguageMeineKonferenzenOranisierenES);

    commandLabelMeineKonferenzenOrganisieren.setLANGUAGES(languagesMeineKonferenzenOrganisieren);

    COMMAND commandButtonEinladen = new COMMAND();
    commandButtonEinladen.setKEY(KEY.BUTTON_EINLADEN);
    LANGUAGES languagesButtonEinladen = new LANGUAGES();
    LANGUAGE lanaguageEinladenDE = new LANGUAGE();
    lanaguageEinladenDE.setISO639(ISO639.DE);
    lanaguageEinladenDE.setTEXT("Änderungen Speichern");

    LANGUAGE lanaguageEinladenEN = new LANGUAGE();
    lanaguageEinladenEN.setISO639(ISO639.EN);
    lanaguageEinladenEN.setTEXT("Save Changes");

    LANGUAGE lanaguageEinladenES = new LANGUAGE();
    lanaguageEinladenES.setISO639(ISO639.ES);
    lanaguageEinladenES.setTEXT("Guardar Cambios");

    languagesButtonEinladen.getLANGUAGE().add(lanaguageEinladenDE);
    languagesButtonEinladen.getLANGUAGE().add(lanaguageEinladenEN);
    languagesButtonEinladen.getLANGUAGE().add(lanaguageEinladenES);
    commandButtonEinladen.setLANGUAGES(languagesButtonEinladen);

    COMMAND commandStringAnDenAnfang = new COMMAND();
    commandStringAnDenAnfang.setKEY(KEY.STRING_AN_DEN_ANFANG);
    LANGUAGES languagesAnDenAnfang = new LANGUAGES();
    LANGUAGE lanaguageAnDenAnfangDE = new LANGUAGE();
    lanaguageAnDenAnfangDE.setISO639(ISO639.DE);
    lanaguageAnDenAnfangDE.setTEXT("An den Anfang");

    LANGUAGE lanaguageAnDenAnfangEN = new LANGUAGE();
    lanaguageAnDenAnfangEN.setISO639(ISO639.EN);
    lanaguageAnDenAnfangEN.setTEXT("Rewind to the beginning");

    LANGUAGE lanaguageAnDenAnfangES = new LANGUAGE();
    lanaguageAnDenAnfangES.setISO639(ISO639.ES);
    lanaguageAnDenAnfangES.setTEXT("Rebobinar al principio");

    languagesAnDenAnfang.getLANGUAGE().add(lanaguageAnDenAnfangDE);
    languagesAnDenAnfang.getLANGUAGE().add(lanaguageAnDenAnfangEN);
    languagesAnDenAnfang.getLANGUAGE().add(lanaguageAnDenAnfangES);

    commandStringAnDenAnfang.setLANGUAGES(languagesAnDenAnfang);

    COMMAND commandStringPauseFortsetzen = new COMMAND();
    commandStringPauseFortsetzen.setKEY(KEY.STRING_PAUSE_FORTSETZEN);
    LANGUAGES languagesPauseFortsetzen = new LANGUAGES();
    LANGUAGE lanaguagePauseFortsetzenDE = new LANGUAGE();
    lanaguagePauseFortsetzenDE.setISO639(ISO639.DE);
    lanaguagePauseFortsetzenDE.setTEXT("Pause / Fortsetzen");

    LANGUAGE lanaguagePauseFortsetzenEN = new LANGUAGE();
    lanaguagePauseFortsetzenEN.setISO639(ISO639.EN);
    lanaguagePauseFortsetzenEN.setTEXT("Pause / Continue");

    LANGUAGE lanaguagePauseFortsetzenES = new LANGUAGE();
    lanaguagePauseFortsetzenES.setISO639(ISO639.ES);
    lanaguagePauseFortsetzenES.setTEXT("Pausar / Continuar");

    languagesPauseFortsetzen.getLANGUAGE().add(lanaguagePauseFortsetzenDE);
    languagesPauseFortsetzen.getLANGUAGE().add(lanaguagePauseFortsetzenEN);
    languagesPauseFortsetzen.getLANGUAGE().add(lanaguagePauseFortsetzenES);

    commandStringPauseFortsetzen.setLANGUAGES(languagesPauseFortsetzen);

    COMMAND commandStringZeitspanne = new COMMAND();
    commandStringZeitspanne.setKEY(KEY.STRING_ZEITSPANNE);
    LANGUAGES languagesZeitspanne = new LANGUAGES();
    LANGUAGE lanaguageZeitspanneDE = new LANGUAGE();
    lanaguageZeitspanneDE.setISO639(ISO639.DE);
    lanaguageZeitspanneDE.setTEXT("Zeitspanne");

    LANGUAGE lanaguageZeitspanneEN = new LANGUAGE();
    lanaguageZeitspanneEN.setISO639(ISO639.EN);
    lanaguageZeitspanneEN.setTEXT("Time range");

    LANGUAGE lanaguageZeitspanneES = new LANGUAGE();
    lanaguageZeitspanneES.setISO639(ISO639.ES);
    lanaguageZeitspanneES.setTEXT("Intervalo de tiempo");

    languagesZeitspanne.getLANGUAGE().add(lanaguageZeitspanneDE);
    languagesZeitspanne.getLANGUAGE().add(lanaguageZeitspanneEN);
    languagesZeitspanne.getLANGUAGE().add(lanaguageZeitspanneES);
    commandStringZeitspanne.setLANGUAGES(languagesZeitspanne);

    COMMAND commandStringMarkieren = new COMMAND();
    commandStringMarkieren.setKEY(KEY.STRING_MARKIEREN);
    LANGUAGES languagesStringMarkieren = new LANGUAGES();
    LANGUAGE lanaguageMarkierenDE = new LANGUAGE();
    lanaguageMarkierenDE.setISO639(ISO639.DE);
    lanaguageMarkierenDE.setTEXT("Markieren");

    LANGUAGE lanaguageMarkierenEN = new LANGUAGE();
    lanaguageMarkierenEN.setISO639(ISO639.EN);
    lanaguageMarkierenEN.setTEXT("Mark");

    LANGUAGE lanaguageMarkierenES = new LANGUAGE();
    lanaguageMarkierenES.setISO639(ISO639.ES);
    lanaguageMarkierenES.setTEXT("Marcar");

    languagesStringMarkieren.getLANGUAGE().add(lanaguageMarkierenDE);
    languagesStringMarkieren.getLANGUAGE().add(lanaguageMarkierenEN);
    languagesStringMarkieren.getLANGUAGE().add(lanaguageMarkierenES);

    commandStringMarkieren.setLANGUAGES(languagesStringMarkieren);

    COMMAND commandButtonAendern = new COMMAND();
    commandButtonAendern.setKEY(KEY.BUTTON_AENDERN);
    LANGUAGES languagesButtonAendern = new LANGUAGES();
    LANGUAGE lanaguageAendernDE = new LANGUAGE();
    lanaguageAendernDE.setISO639(ISO639.DE);
    lanaguageAendernDE.setTEXT("Ändern");

    LANGUAGE lanaguageAendernEN = new LANGUAGE();
    lanaguageAendernEN.setISO639(ISO639.EN);
    lanaguageAendernEN.setTEXT("Modify");

    LANGUAGE lanaguageAendernES = new LANGUAGE();
    lanaguageAendernES.setISO639(ISO639.ES);
    lanaguageAendernES.setTEXT("Modificar");

    languagesButtonAendern.getLANGUAGE().add(lanaguageAendernDE);
    languagesButtonAendern.getLANGUAGE().add(lanaguageAendernEN);
    languagesButtonAendern.getLANGUAGE().add(lanaguageAendernES);
    commandButtonAendern.setLANGUAGES(languagesButtonAendern);

    COMMAND commandLabelVerfallsdatum = new COMMAND();
    commandLabelVerfallsdatum.setKEY(KEY.LABEL_VERFALLSDATUM);
    LANGUAGES languagesLabelVerfallsdatum = new LANGUAGES();
    LANGUAGE lanaguageLabelVerfallsdatumDE = new LANGUAGE();
    lanaguageLabelVerfallsdatumDE.setISO639(ISO639.DE);
    lanaguageLabelVerfallsdatumDE.setTEXT(
        "<html>"
            + "Das Verfallsdatum gibt die Zeitspanne von jetzt bis wann an, in der telefoniert werden kann. "
            + "Wenn die Zeit verstrichen ist, können keine neuen Teilnehmer mehr beitreten. "
            + "Du kannst das Verfallsdatum verlängern.</html>"
    );

    LANGUAGE lanaguageLabelVerfallsdatumEN = new LANGUAGE();
    lanaguageLabelVerfallsdatumEN.setISO639(ISO639.EN);
    lanaguageLabelVerfallsdatumEN.setTEXT(
        "<html>The expiration date indicates the period of time from now until when phone calls can be made. "
            + "When the time has passed, no new participants can join. "
            + "You can extend the expiration date.</html>"
    );

    LANGUAGE lanaguageLabelVerfallsdatumES = new LANGUAGE();
    lanaguageLabelVerfallsdatumES.setISO639(ISO639.ES);
    lanaguageLabelVerfallsdatumES.setTEXT(
        "<html>La fecha de caducidad indica el periodo de tiempo durante el cual se pueden realizar llamadas, desde ahora hasta cuando. "
            + "Una vez transcurrido el tiempo, no podrán incorporarse nuevos participantes. "
            + "Puedes ampliar la fecha de caducidad.</html>"
    );

    languagesLabelVerfallsdatum.getLANGUAGE().add(lanaguageLabelVerfallsdatumDE);
    languagesLabelVerfallsdatum.getLANGUAGE().add(lanaguageLabelVerfallsdatumEN);
    languagesLabelVerfallsdatum.getLANGUAGE().add(lanaguageLabelVerfallsdatumES);

    commandLabelVerfallsdatum.setLANGUAGES(languagesLabelVerfallsdatum);

    COMMAND commandServerLeitungUnterbrochen = new COMMAND();
    commandServerLeitungUnterbrochen.setKEY(KEY.SERVER_LEITUNG_UNTERBROCHEN);
    LANGUAGES languagesServerLeitungUnterbrochen = new LANGUAGES();
    LANGUAGE lanaguageServerLeitungUnterbrochenDE = new LANGUAGE();
    lanaguageServerLeitungUnterbrochenDE.setISO639(ISO639.DE);
    lanaguageServerLeitungUnterbrochenDE.setTEXT("Die Verbindung ist unterbrochen.");

    LANGUAGE lanaguageServerLeitungUnterbrochenEN = new LANGUAGE();
    lanaguageServerLeitungUnterbrochenEN.setISO639(ISO639.EN);
    lanaguageServerLeitungUnterbrochenEN.setTEXT("The connection is broken.");

    LANGUAGE lanaguageServerLeitungUnterbrochenES = new LANGUAGE();
    lanaguageServerLeitungUnterbrochenES.setISO639(ISO639.ES);
    lanaguageServerLeitungUnterbrochenES.setTEXT("La conexión está rota.");

    languagesServerLeitungUnterbrochen.getLANGUAGE().add(lanaguageServerLeitungUnterbrochenDE);
    languagesServerLeitungUnterbrochen.getLANGUAGE().add(lanaguageServerLeitungUnterbrochenEN);
    languagesServerLeitungUnterbrochen.getLANGUAGE().add(lanaguageServerLeitungUnterbrochenES);

    commandServerLeitungUnterbrochen.setLANGUAGES(languagesServerLeitungUnterbrochen);

    COMMAND commandServerVerbindungsproblem = new COMMAND();
    commandServerVerbindungsproblem.setKEY(KEY.SERVER_VERBINDUNGSPROBLEM);
    LANGUAGES languagesServerVerbindungsproblem = new LANGUAGES();
    LANGUAGE lanaguageServerVerbindungsproblemDE = new LANGUAGE();
    lanaguageServerVerbindungsproblemDE.setISO639(ISO639.DE);
    lanaguageServerVerbindungsproblemDE.setTEXT("Verbindungsproblem");

    LANGUAGE lanaguageServerVerbindungsproblemEN = new LANGUAGE();
    lanaguageServerVerbindungsproblemEN.setISO639(ISO639.EN);
    lanaguageServerVerbindungsproblemEN.setTEXT("Connection problem");

    LANGUAGE lanaguageServerVerbindungsproblemES = new LANGUAGE();
    lanaguageServerVerbindungsproblemES.setISO639(ISO639.ES);
    lanaguageServerVerbindungsproblemES.setTEXT("Problema de conexión");

    languagesServerVerbindungsproblem.getLANGUAGE().add(lanaguageServerVerbindungsproblemDE);
    languagesServerVerbindungsproblem.getLANGUAGE().add(lanaguageServerVerbindungsproblemEN);
    languagesServerVerbindungsproblem.getLANGUAGE().add(lanaguageServerVerbindungsproblemES);
    commandServerVerbindungsproblem.setLANGUAGES(languagesServerVerbindungsproblem);

    COMMAND commandLabelAnwesend = new COMMAND();
    commandLabelAnwesend.setKEY(KEY.LABEL_ANWESEND);
    LANGUAGES languagesLabelAnwesend = new LANGUAGES();
    LANGUAGE lanaguageLabelAnwesendDE = new LANGUAGE();
    lanaguageLabelAnwesendDE.setISO639(ISO639.DE);
    lanaguageLabelAnwesendDE.setTEXT("Anwesend");

    LANGUAGE lanaguageLabelAnwesendEN = new LANGUAGE();
    lanaguageLabelAnwesendEN.setISO639(ISO639.EN);
    lanaguageLabelAnwesendEN.setTEXT("Present");

    LANGUAGE lanaguageLabelAnwesendES = new LANGUAGE();
    lanaguageLabelAnwesendES.setISO639(ISO639.ES);
    lanaguageLabelAnwesendES.setTEXT("Presente");

    languagesLabelAnwesend.getLANGUAGE().add(lanaguageLabelAnwesendDE);
    languagesLabelAnwesend.getLANGUAGE().add(lanaguageLabelAnwesendEN);
    languagesLabelAnwesend.getLANGUAGE().add(lanaguageLabelAnwesendES);
    commandLabelAnwesend.setLANGUAGES(languagesLabelAnwesend);

    COMMAND commandLabelAusente = new COMMAND();
    commandLabelAusente.setKEY(KEY.LABEL_ABWESEND);
    LANGUAGES languagesLabelAbwesend = new LANGUAGES();
    LANGUAGE lanaguageLabelAbwesendDE = new LANGUAGE();
    lanaguageLabelAbwesendDE.setISO639(ISO639.DE);
    lanaguageLabelAbwesendDE.setTEXT("Abwesend");

    LANGUAGE lanaguageLabelAbwesendEN = new LANGUAGE();
    lanaguageLabelAbwesendEN.setISO639(ISO639.EN);
    lanaguageLabelAbwesendEN.setTEXT("Absent");

    LANGUAGE lanaguageLabelAbwesendES = new LANGUAGE();
    lanaguageLabelAbwesendES.setISO639(ISO639.ES);
    lanaguageLabelAbwesendES.setTEXT("Ausente");

    languagesLabelAbwesend.getLANGUAGE().add(lanaguageLabelAbwesendDE);
    languagesLabelAbwesend.getLANGUAGE().add(lanaguageLabelAbwesendEN);
    languagesLabelAbwesend.getLANGUAGE().add(lanaguageLabelAbwesendES);

    commandLabelAusente.setLANGUAGES(languagesLabelAbwesend);

    COMMAND commandLabelOrganisator = new COMMAND();
    commandLabelOrganisator.setKEY(KEY.LABEL_ORGANISATOR);
    LANGUAGES languagesLabelOrganisator = new LANGUAGES();
    LANGUAGE lanaguageLabelOrganisatorDE = new LANGUAGE();
    lanaguageLabelOrganisatorDE.setISO639(ISO639.DE);
    lanaguageLabelOrganisatorDE.setTEXT("Organisator");

    LANGUAGE lanaguageLabelOrganisatorEN = new LANGUAGE();
    lanaguageLabelOrganisatorEN.setISO639(ISO639.EN);
    lanaguageLabelOrganisatorEN.setTEXT("Organizator");

    LANGUAGE lanaguageLabelOrganisatorES = new LANGUAGE();
    lanaguageLabelOrganisatorES.setISO639(ISO639.ES);
    lanaguageLabelOrganisatorES.setTEXT("Organizador");

    languagesLabelOrganisator.getLANGUAGE().add(lanaguageLabelOrganisatorDE);
    languagesLabelOrganisator.getLANGUAGE().add(lanaguageLabelOrganisatorEN);
    languagesLabelOrganisator.getLANGUAGE().add(lanaguageLabelOrganisatorES);
    commandLabelOrganisator.setLANGUAGES(languagesLabelOrganisator);

    COMMAND commandStringTelefonkonferenz = new COMMAND();
    commandStringTelefonkonferenz.setKEY(KEY.STRING_TELEFONKONFERENZ);
    LANGUAGES languagesStringTelefonkonferenz = new LANGUAGES();
    LANGUAGE lanaguageStringTelefonkonferenzDE = new LANGUAGE();
    lanaguageStringTelefonkonferenzDE.setISO639(ISO639.DE);
    lanaguageStringTelefonkonferenzDE.setTEXT("Telefonkonferenz");

    LANGUAGE lanaguageStringTelefonkonferenzEN = new LANGUAGE();
    lanaguageStringTelefonkonferenzEN.setISO639(ISO639.EN);
    lanaguageStringTelefonkonferenzEN.setTEXT("Conference call");

    LANGUAGE lanaguageStringTelefonkonferenzES = new LANGUAGE();
    lanaguageStringTelefonkonferenzES.setISO639(ISO639.ES);
    lanaguageStringTelefonkonferenzES.setTEXT("Llamada de conferencia");

    languagesStringTelefonkonferenz.getLANGUAGE().add(lanaguageStringTelefonkonferenzDE);
    languagesStringTelefonkonferenz.getLANGUAGE().add(lanaguageStringTelefonkonferenzEN);
    languagesStringTelefonkonferenz.getLANGUAGE().add(lanaguageStringTelefonkonferenzES);
    commandStringTelefonkonferenz.setLANGUAGES(languagesStringTelefonkonferenz);

    COMMAND commandStringEntferneAnhang = new COMMAND();
    commandStringEntferneAnhang.setKEY(KEY.STRING_ENTFERNE_ANHANG);
    LANGUAGES languagesStringEnferneAnhang = new LANGUAGES();
    LANGUAGE lanaguageStringEntfereneAnhangDE = new LANGUAGE();
    lanaguageStringEntfereneAnhangDE.setISO639(ISO639.DE);
    lanaguageStringEntfereneAnhangDE.setTEXT("Anlage entfernen");

    LANGUAGE lanaguageStringEntfereneAnhangEN = new LANGUAGE();
    lanaguageStringEntfereneAnhangEN.setISO639(ISO639.EN);
    lanaguageStringEntfereneAnhangEN.setTEXT("Remove attachment");

    LANGUAGE lanaguageStringEntfereneAnhangES = new LANGUAGE();
    lanaguageStringEntfereneAnhangES.setISO639(ISO639.ES);
    lanaguageStringEntfereneAnhangES.setTEXT("Quitar datos adjuntos");

    languagesStringEnferneAnhang.getLANGUAGE().add(lanaguageStringEntfereneAnhangDE);
    languagesStringEnferneAnhang.getLANGUAGE().add(lanaguageStringEntfereneAnhangEN);
    languagesStringEnferneAnhang.getLANGUAGE().add(lanaguageStringEntfereneAnhangES);

    commandStringEntferneAnhang.setLANGUAGES(languagesStringEnferneAnhang);

    COMMAND commandClickFileOrDirectory = new COMMAND();
    commandClickFileOrDirectory.setKEY(KEY.STRING_CLICK_FILE_OR_DIRECTORY);
    LANGUAGES languagesClickFileOrDirectory = new LANGUAGES();
    LANGUAGE lanaguageClickFileOrDirectoryDE = new LANGUAGE();
    lanaguageClickFileOrDirectoryDE.setISO639(ISO639.DE);
    lanaguageClickFileOrDirectoryDE.setTEXT("Datei oder Verzeichnis klicken");

    LANGUAGE lanaguageClickFileOrDirectoryEN = new LANGUAGE();
    lanaguageClickFileOrDirectoryEN.setISO639(ISO639.EN);
    lanaguageClickFileOrDirectoryEN.setTEXT("Click file or directory");

    LANGUAGE lanaguageClickFileOrDirectoryES = new LANGUAGE();
    lanaguageClickFileOrDirectoryES.setISO639(ISO639.ES);
    lanaguageClickFileOrDirectoryES.setTEXT("Haz clic en archivo o directorio");

    languagesClickFileOrDirectory.getLANGUAGE().add(lanaguageClickFileOrDirectoryDE);
    languagesClickFileOrDirectory.getLANGUAGE().add(lanaguageClickFileOrDirectoryEN);
    languagesClickFileOrDirectory.getLANGUAGE().add(lanaguageClickFileOrDirectoryES);
    commandClickFileOrDirectory.setLANGUAGES(languagesClickFileOrDirectory);

    COMMAND commandConfirmDirectory = new COMMAND();
    commandConfirmDirectory.setKEY(KEY.STRING_CONFIRM_DIRECTORY);
    LANGUAGES languagesConfirmDirectory = new LANGUAGES();
    LANGUAGE lanaguageConfirmDirectoryDE = new LANGUAGE();
    lanaguageConfirmDirectoryDE.setISO639(ISO639.DE);
    lanaguageConfirmDirectoryDE.setTEXT("Verzeichnis bestätigen");

    LANGUAGE lanaguageConfirmDirectoryEN = new LANGUAGE();
    lanaguageConfirmDirectoryEN.setISO639(ISO639.EN);
    lanaguageConfirmDirectoryEN.setTEXT("Confirm directory");

    LANGUAGE lanaguageConfirmDirectoryES = new LANGUAGE();
    lanaguageConfirmDirectoryES.setISO639(ISO639.ES);
    lanaguageConfirmDirectoryES.setTEXT("Confirmar directorio");

    languagesConfirmDirectory.getLANGUAGE().add(lanaguageConfirmDirectoryDE);
    languagesConfirmDirectory.getLANGUAGE().add(lanaguageConfirmDirectoryEN);
    languagesConfirmDirectory.getLANGUAGE().add(lanaguageConfirmDirectoryES);

    commandConfirmDirectory.setLANGUAGES(languagesConfirmDirectory);

    COMMAND commandOdx = new COMMAND();
    commandOdx.setKEY(KEY.ODX_220);
    LANGUAGES languagesODX = new LANGUAGES();
    LANGUAGE lanaguageOdxDE = new LANGUAGE();
    lanaguageOdxDE.setISO639(ISO639.DE);
    lanaguageOdxDE.setTEXT("ODX 2.2.0");
    lanaguageOdxDE.setSHORTCUT(VIRTUALKEY.VK_O);

    LANGUAGE lanaguageOdxEN = new LANGUAGE();
    lanaguageOdxEN.setISO639(ISO639.EN);
    lanaguageOdxEN.setTEXT("ODX 2.2.0");
    lanaguageOdxEN.setSHORTCUT(VIRTUALKEY.VK_O);

    LANGUAGE lanaguageOdxES = new LANGUAGE();
    lanaguageOdxES.setISO639(ISO639.ES);
    lanaguageOdxES.setTEXT("ODX 2.2.0");
    lanaguageOdxES.setSHORTCUT(VIRTUALKEY.VK_O);

    languagesODX.getLANGUAGE().add(lanaguageOdxDE);
    languagesODX.getLANGUAGE().add(lanaguageOdxEN);
    languagesODX.getLANGUAGE().add(lanaguageOdxES);

    commandOdx.setLANGUAGES(languagesODX);

    COMMAND commandImport = new COMMAND();
    commandImport.setKEY(KEY.IMPORT);
    LANGUAGES languagesImport = new LANGUAGES();
    LANGUAGE lanaguageImportDE = new LANGUAGE();
    lanaguageImportDE.setISO639(ISO639.DE);
    lanaguageImportDE.setTEXT("BasisPDX bearbeiten");

    LANGUAGE lanaguageImportEN = new LANGUAGE();
    lanaguageImportEN.setISO639(ISO639.EN);
    lanaguageImportEN.setTEXT("Edit base pdx");

    LANGUAGE lanaguageImportES = new LANGUAGE();
    lanaguageImportES.setISO639(ISO639.ES);
    lanaguageImportES.setTEXT("Editar base de pdx");

    languagesImport.getLANGUAGE().add(lanaguageImportDE);
    languagesImport.getLANGUAGE().add(lanaguageImportEN);
    languagesImport.getLANGUAGE().add(lanaguageImportES);
    commandImport.setLANGUAGES(languagesImport);

    COMMAND commandSearchIn = new COMMAND();
    commandSearchIn.setKEY(KEY.STRING_SEARCH_IN);
    LANGUAGES languagesSearchIn = new LANGUAGES();
    LANGUAGE lanaguageSearchInDE = new LANGUAGE();
    lanaguageSearchInDE.setISO639(ISO639.DE);
    lanaguageSearchInDE.setTEXT("Suchen in:");
    lanaguageSearchInDE.setSHORTCUT(VIRTUALKEY.VK_I);

    LANGUAGE lanaguageSearchInEN = new LANGUAGE();
    lanaguageSearchInEN.setISO639(ISO639.EN);
    lanaguageSearchInEN.setTEXT("Search in:");
    lanaguageSearchInEN.setSHORTCUT(VIRTUALKEY.VK_I);

    LANGUAGE lanaguageSearchInES = new LANGUAGE();
    lanaguageSearchInES.setISO639(ISO639.ES);
    lanaguageSearchInES.setTEXT("Buscar en:");
    lanaguageSearchInES.setSHORTCUT(VIRTUALKEY.VK_E);

    languagesSearchIn.getLANGUAGE().add(lanaguageSearchInDE);
    languagesSearchIn.getLANGUAGE().add(lanaguageSearchInEN);
    languagesSearchIn.getLANGUAGE().add(lanaguageSearchInES);

    commandSearchIn.setLANGUAGES(languagesSearchIn);

    COMMAND commandModul = new COMMAND();
    commandModul.setKEY(KEY.STRING_MODUL);
    LANGUAGES languagesModul = new LANGUAGES();
    LANGUAGE lanaguageModulDE = new LANGUAGE();
    lanaguageModulDE.setISO639(ISO639.DE);
    lanaguageModulDE.setTEXT("Module");

    LANGUAGE lanaguageModulEN = new LANGUAGE();
    lanaguageModulEN.setISO639(ISO639.EN);
    lanaguageModulEN.setTEXT("Modules");

    LANGUAGE lanaguageModulES = new LANGUAGE();
    lanaguageModulES.setISO639(ISO639.ES);
    lanaguageModulES.setTEXT("Módulos");

    languagesModul.getLANGUAGE().add(lanaguageModulDE);
    languagesModul.getLANGUAGE().add(lanaguageModulEN);
    languagesModul.getLANGUAGE().add(lanaguageModulES);

    commandModul.setLANGUAGES(languagesModul);

    COMMAND commandEinGesetzterHaken = new COMMAND();
    commandEinGesetzterHaken.setKEY(KEY.LABEL_EIN_GESETZTER_HAKEN);
    LANGUAGES languagesEinGesetzterHaken = new LANGUAGES();
    LANGUAGE lanaguageGesetzterHakenDE = new LANGUAGE();
    lanaguageGesetzterHakenDE.setISO639(ISO639.DE);
    lanaguageGesetzterHakenDE
        .setTEXT("<html>Ein gesetzter Haken zeigt die Berechtigung für ein Modul an.</html>");

    LANGUAGE lanaguageGesetzterHakenEN = new LANGUAGE();
    lanaguageGesetzterHakenEN.setISO639(ISO639.EN);
    lanaguageGesetzterHakenEN
        .setTEXT("<html>A set check mark indicates the authorization for a module.</html>");

    LANGUAGE lanaguageGesetzterHakenES = new LANGUAGE();
    lanaguageGesetzterHakenES.setISO639(ISO639.ES);
    lanaguageGesetzterHakenES.setTEXT("<html>Una marca indica la autorización para un módulo.</html>");

    languagesEinGesetzterHaken.getLANGUAGE().add(lanaguageGesetzterHakenDE);
    languagesEinGesetzterHaken.getLANGUAGE().add(lanaguageGesetzterHakenEN);
    languagesEinGesetzterHaken.getLANGUAGE().add(lanaguageGesetzterHakenES);

    commandEinGesetzterHaken.setLANGUAGES(languagesEinGesetzterHaken);

    COMMAND commandCheckboxIndex = new COMMAND();
    commandCheckboxIndex.setKEY(KEY.CHECK_BOX_SPEICHERN_INDEX);
    LANGUAGES languagesCheckboxSpeichernIndex = new LANGUAGES();

    LANGUAGE lanaguageCheckboxSpeichernIndexDE = new LANGUAGE();
    lanaguageCheckboxSpeichernIndexDE.setISO639(ISO639.DE);
    lanaguageCheckboxSpeichernIndexDE.setTEXT("Beim Speichern die Katalogdatei (index.xml) neu erstellen.");

    LANGUAGE lanaguageCheckboxSpeichernIndexEN = new LANGUAGE();
    lanaguageCheckboxSpeichernIndexEN.setISO639(ISO639.EN);
    lanaguageCheckboxSpeichernIndexEN.setTEXT("When saving, recreate the catalog file (index.xml).");

    LANGUAGE lanaguageCheckboxSpeichernIndexES = new LANGUAGE();
    lanaguageCheckboxSpeichernIndexES.setISO639(ISO639.ES);
    lanaguageCheckboxSpeichernIndexES
        .setTEXT("Al guardar, vuelve a crear el archivo del catálogo (index.xml).");

    languagesCheckboxSpeichernIndex.getLANGUAGE().add(lanaguageCheckboxSpeichernIndexDE);
    languagesCheckboxSpeichernIndex.getLANGUAGE().add(lanaguageCheckboxSpeichernIndexEN);
    languagesCheckboxSpeichernIndex.getLANGUAGE().add(lanaguageCheckboxSpeichernIndexES);

    commandCheckboxIndex.setLANGUAGES(languagesCheckboxSpeichernIndex);

    COMMAND commandCheckboxDiagnosevorgaben = new COMMAND();
    commandCheckboxDiagnosevorgaben.setKEY(KEY.CHECKBOX_DIAGNOSEVORGABEN);
    LANGUAGES languagesCheckboxSpeichernDiagnosevorgaben = new LANGUAGES();
    LANGUAGE lanaguageCheckboxDiagnosevorgabenDE = new LANGUAGE();
    lanaguageCheckboxDiagnosevorgabenDE.setISO639(ISO639.DE);
    lanaguageCheckboxDiagnosevorgabenDE.setTEXT("Diagnosevorgaben in das PDX übernehmen.");

    LANGUAGE lanaguageCheckboxDiagnosevorgabenEN = new LANGUAGE();
    lanaguageCheckboxDiagnosevorgabenEN.setISO639(ISO639.EN);
    lanaguageCheckboxDiagnosevorgabenEN.setTEXT("Apply diagnostic presets to PDX.");

    LANGUAGE lanaguageCheckboxDiagnosevorgabenES = new LANGUAGE();
    lanaguageCheckboxDiagnosevorgabenES.setISO639(ISO639.ES);
    lanaguageCheckboxDiagnosevorgabenES.setTEXT("Aplicar preajustes de diagnóstico en PDX.");

    languagesCheckboxSpeichernDiagnosevorgaben.getLANGUAGE().add(lanaguageCheckboxDiagnosevorgabenDE);
    languagesCheckboxSpeichernDiagnosevorgaben.getLANGUAGE().add(lanaguageCheckboxDiagnosevorgabenEN);
    languagesCheckboxSpeichernDiagnosevorgaben.getLANGUAGE().add(lanaguageCheckboxDiagnosevorgabenES);
    commandCheckboxDiagnosevorgaben.setLANGUAGES(languagesCheckboxSpeichernDiagnosevorgaben);

    COMMAND commandButtonPruefen = new COMMAND();
    commandButtonPruefen.setKEY(KEY.BUTTON_PRUEFEN_GEN_D);
    LANGUAGES languagesButtonPruefen = new LANGUAGES();
    LANGUAGE lanaguageButtonPruefenDE = new LANGUAGE();
    lanaguageButtonPruefenDE.setISO639(ISO639.DE);
    lanaguageButtonPruefenDE.setTEXT("Prüfen GenD");

    LANGUAGE lanaguageButtonPruefenEN = new LANGUAGE();
    lanaguageButtonPruefenEN.setISO639(ISO639.EN);
    lanaguageButtonPruefenEN.setTEXT("Check GenD");

    LANGUAGE lanaguageButtonPruefenES = new LANGUAGE();
    lanaguageButtonPruefenES.setISO639(ISO639.ES);
    lanaguageButtonPruefenES.setTEXT("Comprobar GenD");

    languagesButtonPruefen.getLANGUAGE().add(lanaguageButtonPruefenDE);
    languagesButtonPruefen.getLANGUAGE().add(lanaguageButtonPruefenEN);
    languagesButtonPruefen.getLANGUAGE().add(lanaguageButtonPruefenES);

    commandButtonPruefen.setLANGUAGES(languagesButtonPruefen);
//

    COMMAND commandButtonPruefenGenB = new COMMAND();
    commandButtonPruefenGenB.setKEY(KEY.BUTTON_PRUEFEN_GEN_B);

    LANGUAGES languagesButtonPruefenGenB = new LANGUAGES();
    commandButtonPruefenGenB.setLANGUAGES(languagesButtonPruefenGenB);
    LANGUAGE lanaguageButtonPruefenGenB_DE = new LANGUAGE();
    lanaguageButtonPruefenGenB_DE.setISO639(ISO639.DE);
    lanaguageButtonPruefenGenB_DE.setTEXT("Prüfen GenB");

    LANGUAGE lanaguageButtonPruefenGenB_EN = new LANGUAGE();
    lanaguageButtonPruefenGenB_EN.setISO639(ISO639.EN);
    lanaguageButtonPruefenGenB_EN.setTEXT("Check GenB");

    LANGUAGE lanaguageButtonPruefenGenB_ES = new LANGUAGE();
    lanaguageButtonPruefenGenB_ES.setISO639(ISO639.ES);
    lanaguageButtonPruefenGenB_ES.setTEXT("Comprobar GenB");

    languagesButtonPruefenGenB.getLANGUAGE().add(lanaguageButtonPruefenGenB_DE);
    languagesButtonPruefenGenB.getLANGUAGE().add(lanaguageButtonPruefenGenB_EN);
    languagesButtonPruefenGenB.getLANGUAGE().add(lanaguageButtonPruefenGenB_ES);

    commandButtonPruefen.setLANGUAGES(languagesButtonPruefen);

    COMMAND commandAlleSpeicherOptionen = new COMMAND();
    commandAlleSpeicherOptionen.setKEY(KEY.LABEL_ALLE_SPEICHEROPTIONEN);
    LANGUAGES languagesAlleSpeicheroptionen = new LANGUAGES();
    LANGUAGE lanaguageAlleSpeicheroptionenDE = new LANGUAGE();
    lanaguageAlleSpeicheroptionenDE.setISO639(ISO639.DE);
    lanaguageAlleSpeicheroptionenDE.setTEXT(
        "<html>" + "<p style='text-align:center'>Das Archiv wurde gespeichert. Die Datei liegt unter</p><br>"
            + "<p style='text-align:center'><b> XXX </b></p>"
            + "<p style='text-align:center'><b> YYY </b></p><br>"
            + "<p style='text-align:center'> ZZZ </p>"
            + "</html>"
    );

    LANGUAGE lanaguageAlleSpeicheroptionenEN = new LANGUAGE();
    lanaguageAlleSpeicheroptionenEN.setISO639(ISO639.EN);
    lanaguageAlleSpeicheroptionenEN.setTEXT(
        "<html>" + "<p style='text-align:center'>The archive <b>XXX</b> has been saved.</p><br>"
            + "<p style='text-align:center'><b> XXX </b></p>"
            + "<p style='text-align:center'><b> YYY </b></p><br>"
            + "<p style='text-align:center'> ZZZ </p>"
            + "</html>"
    );

    LANGUAGE lanaguageAlleSpeicheroptionenES = new LANGUAGE();
    lanaguageAlleSpeicheroptionenES.setISO639(ISO639.ES);
    lanaguageAlleSpeicheroptionenES.setTEXT(
        "<html>" + "<p style='text-align:center'>El archivo <b>XXX</b> se ha guardado.</p><br>"
            + "<p style='text-align:center'><b> XXX </b></p>"
            + "<p style='text-align:center'><b> YYY </b></p><br>"
            + "<p style='text-align:center'> ZZZ </p>"
            + "</html>"
    );

    languagesAlleSpeicheroptionen.getLANGUAGE().add(lanaguageAlleSpeicheroptionenDE);
    languagesAlleSpeicheroptionen.getLANGUAGE().add(lanaguageAlleSpeicheroptionenEN);
    languagesAlleSpeicheroptionen.getLANGUAGE().add(lanaguageAlleSpeicheroptionenES);
    commandAlleSpeicherOptionen.setLANGUAGES(languagesAlleSpeicheroptionen);

    COMMAND commandStringMoveAndSort = new COMMAND();
    commandStringMoveAndSort.setKEY(KEY.STRING_MOVE_AND_SORT);
    LANGUAGES languagesStringMoveAndSort = new LANGUAGES();
    LANGUAGE lanaguageStringMoveAndSortDE = new LANGUAGE();
    lanaguageStringMoveAndSortDE.setISO639(ISO639.DE);
    lanaguageStringMoveAndSortDE.setTEXT("Sortieren und Verschieben");

    LANGUAGE lanaguageStringMoveAndSortEN = new LANGUAGE();
    lanaguageStringMoveAndSortEN.setISO639(ISO639.EN);
    lanaguageStringMoveAndSortEN.setTEXT("Sort and Move");

    LANGUAGE lanaguageStringMoveAndSortES = new LANGUAGE();
    lanaguageStringMoveAndSortES.setISO639(ISO639.ES);
    lanaguageStringMoveAndSortES.setTEXT("Ordenar y Mover");

    languagesStringMoveAndSort.getLANGUAGE().add(lanaguageStringMoveAndSortDE);
    languagesStringMoveAndSort.getLANGUAGE().add(lanaguageStringMoveAndSortEN);
    languagesStringMoveAndSort.getLANGUAGE().add(lanaguageStringMoveAndSortES);

    commandStringMoveAndSort.setLANGUAGES(languagesStringMoveAndSort);

    COMMAND commandLabelKeineFehlerGefunden = new COMMAND();
    commandLabelKeineFehlerGefunden.setKEY(KEY.LABEL_KEINE_FEHLER_GEFUNDEN);
    LANGUAGES languagesLabelKeineFehlerGefunden = new LANGUAGES();
    LANGUAGE lanaguageLabelKeineFehlerGefundenDE = new LANGUAGE();
    lanaguageLabelKeineFehlerGefundenDE.setISO639(ISO639.DE);
    lanaguageLabelKeineFehlerGefundenDE.setTEXT(
        "<html>" + "<p style='text-align:center'>Keine Fehler gefunden. Der Prüfbericht liegt unter</p><br>"
            + "<p style='text-align:center'><b> XXX </b></p>"
            + "<p style='text-align:center'><b> YYY </b></p>"
            + "</html>"
    );

    LANGUAGE lanaguageLabelKeineFehlerGefundenEN = new LANGUAGE();
    lanaguageLabelKeineFehlerGefundenEN.setISO639(ISO639.EN);
    lanaguageLabelKeineFehlerGefundenEN.setTEXT(
        "<html>" + "<p style='text-align:center'>No errors found. The report is located at</p><br>"
            + "<p style='text-align:center'><b> XXX </b></p>"
            + "<p style='text-align:center'><b> YYY </b></p>"
            + "</html>"
    );

    LANGUAGE lanaguageLabelKeineFehlerGefundenES = new LANGUAGE();
    lanaguageLabelKeineFehlerGefundenES.setISO639(ISO639.ES);

    lanaguageLabelKeineFehlerGefundenES.setTEXT(
        "<html>"
            + "<p style='text-align:center'>No se han encontrado errores. El informe de la prueba se encuentra en</p><br>"
            + "<p style='text-align:center'><b> XXX </b></p>"
            + "<p style='text-align:center'><b> YYY </b></p>"
            + "</html>"
    );

    languagesLabelKeineFehlerGefunden.getLANGUAGE().add(lanaguageLabelKeineFehlerGefundenDE);
    languagesLabelKeineFehlerGefunden.getLANGUAGE().add(lanaguageLabelKeineFehlerGefundenEN);
    languagesLabelKeineFehlerGefunden.getLANGUAGE().add(lanaguageLabelKeineFehlerGefundenES);
    commandLabelKeineFehlerGefunden.setLANGUAGES(languagesLabelKeineFehlerGefunden);

    COMMAND commandCheckboxBackup = new COMMAND();
    commandCheckboxBackup.setKEY(KEY.CHECKBOX_BACKUP);
    LANGUAGES languagesCheckboxBackup = new LANGUAGES();
    LANGUAGE lanaguageCheckboxBackupDE = new LANGUAGE();
    lanaguageCheckboxBackupDE.setISO639(ISO639.DE);
    lanaguageCheckboxBackupDE.setTEXT("Die Ursprungs-PDX als Backup (*.bak) speichern.");

    LANGUAGE lanaguageCheckboxBackupEN = new LANGUAGE();
    lanaguageCheckboxBackupEN.setISO639(ISO639.EN);
    lanaguageCheckboxBackupEN.setTEXT("Save the original PDX as backup (*.bak).");

    LANGUAGE lanaguageCheckboxBackupES = new LANGUAGE();
    lanaguageCheckboxBackupES.setISO639(ISO639.ES);
    lanaguageCheckboxBackupES.setTEXT("Guarda el pdx original como backup (*.bak).");

    languagesCheckboxBackup.getLANGUAGE().add(lanaguageCheckboxBackupDE);
    languagesCheckboxBackup.getLANGUAGE().add(lanaguageCheckboxBackupEN);
    languagesCheckboxBackup.getLANGUAGE().add(lanaguageCheckboxBackupES);
    commandCheckboxBackup.setLANGUAGES(languagesCheckboxBackup);

    COMMAND commandReport = new COMMAND();
    commandReport.setKEY(KEY.FRAME_REPORT);
    LANGUAGES languagesStringReport = new LANGUAGES();
    LANGUAGE lanaguageStringReportDE = new LANGUAGE();
    lanaguageStringReportDE.setISO639(ISO639.DE);
    lanaguageStringReportDE.setTEXT("Bericht - XXX");

    LANGUAGE lanaguageStringReportEN = new LANGUAGE();
    lanaguageStringReportEN.setISO639(ISO639.EN);
    lanaguageStringReportEN.setTEXT("Report - XXX");

    LANGUAGE lanaguageStringReportES = new LANGUAGE();
    lanaguageStringReportES.setISO639(ISO639.ES);
    lanaguageStringReportES.setTEXT("Informe - XXX");

    languagesStringReport.getLANGUAGE().add(lanaguageStringReportDE);
    languagesStringReport.getLANGUAGE().add(lanaguageStringReportEN);
    languagesStringReport.getLANGUAGE().add(lanaguageStringReportES);

    commandReport.setLANGUAGES(languagesStringReport);

    COMMAND commandStringLine = new COMMAND();
    commandStringLine.setKEY(KEY.STRING_LINE);
    LANGUAGES languagesStringLine = new LANGUAGES();
    LANGUAGE lanaguageStringLineDE = new LANGUAGE();
    lanaguageStringLineDE.setISO639(ISO639.DE);
    lanaguageStringLineDE.setTEXT("Zeile");

    LANGUAGE lanaguageStringLineEN = new LANGUAGE();
    lanaguageStringLineEN.setISO639(ISO639.EN);
    lanaguageStringLineEN.setTEXT("Line");

    LANGUAGE lanaguageStringLineES = new LANGUAGE();
    lanaguageStringLineES.setISO639(ISO639.ES);
    lanaguageStringLineES.setTEXT("Línea");

    languagesStringLine.getLANGUAGE().add(lanaguageStringLineDE);
    languagesStringLine.getLANGUAGE().add(lanaguageStringLineEN);
    languagesStringLine.getLANGUAGE().add(lanaguageStringLineES);
    commandStringLine.setLANGUAGES(languagesStringLine);

    COMMAND commandStringSnippet = new COMMAND();
    commandStringSnippet.setKEY(KEY.STRING_SNIPPET);
    LANGUAGES languagesStringSnippet = new LANGUAGES();
    LANGUAGE lanaguageStringSnippetDE = new LANGUAGE();
    lanaguageStringSnippetDE.setISO639(ISO639.DE);
    lanaguageStringSnippetDE.setTEXT("Fragment");

    LANGUAGE lanaguageStringSnippetEN = new LANGUAGE();
    lanaguageStringSnippetEN.setISO639(ISO639.EN);
    lanaguageStringSnippetEN.setTEXT("Snippet");

    LANGUAGE lanaguageStringSnippetES = new LANGUAGE();
    lanaguageStringSnippetES.setISO639(ISO639.ES);
    lanaguageStringSnippetES.setTEXT("Fragmento");

    languagesStringSnippet.getLANGUAGE().add(lanaguageStringSnippetDE);
    languagesStringSnippet.getLANGUAGE().add(lanaguageStringSnippetEN);
    languagesStringSnippet.getLANGUAGE().add(lanaguageStringSnippetES);
    commandStringSnippet.setLANGUAGES(languagesStringSnippet);

    COMMAND commandStringError = new COMMAND();
    commandStringError.setKEY(KEY.STRING_ERROR);
    LANGUAGES languagesStringError = new LANGUAGES();
    LANGUAGE lanaguageStringErrorDE = new LANGUAGE();
    lanaguageStringErrorDE.setISO639(ISO639.DE);
    lanaguageStringErrorDE.setTEXT("Fehler");

    LANGUAGE lanaguageStringErrorEN = new LANGUAGE();
    lanaguageStringErrorEN.setISO639(ISO639.EN);
    lanaguageStringErrorEN.setTEXT("Error");

    LANGUAGE lanaguageStringErrorES = new LANGUAGE();
    lanaguageStringErrorES.setISO639(ISO639.ES);
    lanaguageStringErrorES.setTEXT("Error");

    languagesStringError.getLANGUAGE().add(lanaguageStringErrorDE);
    languagesStringError.getLANGUAGE().add(lanaguageStringErrorEN);
    languagesStringError.getLANGUAGE().add(lanaguageStringErrorES);
    commandStringError.setLANGUAGES(languagesStringError);

    COMMAND commandStringHinweis = new COMMAND();
    commandStringHinweis.setKEY(KEY.STRING_HINWEIS);
    LANGUAGES languagesStringHinweis = new LANGUAGES();
    LANGUAGE lanaguageStringHinweisDE = new LANGUAGE();
    lanaguageStringHinweisDE.setISO639(ISO639.DE);
    lanaguageStringHinweisDE.setTEXT("Hinweis");

    LANGUAGE lanaguageStringHinweisEN = new LANGUAGE();
    lanaguageStringHinweisEN.setISO639(ISO639.EN);
    lanaguageStringHinweisEN.setTEXT("Note");

    LANGUAGE lanaguageStringHinweisES = new LANGUAGE();
    lanaguageStringHinweisES.setISO639(ISO639.ES);
    lanaguageStringHinweisES.setTEXT("Nota");

    languagesStringHinweis.getLANGUAGE().add(lanaguageStringHinweisDE);
    languagesStringHinweis.getLANGUAGE().add(lanaguageStringHinweisEN);
    languagesStringHinweis.getLANGUAGE().add(lanaguageStringHinweisES);
    commandStringHinweis.setLANGUAGES(languagesStringHinweis);

    COMMAND commandStringDieDatei = new COMMAND();
    commandStringDieDatei.setKEY(KEY.STRING_DIE_DATEI);
    LANGUAGES languagesStringDieDatei = new LANGUAGES();
    LANGUAGE lanaguageStringDieDateiDE = new LANGUAGE();
    lanaguageStringDieDateiDE.setISO639(ISO639.DE);
    lanaguageStringDieDateiDE.setTEXT("Diese Datei muss noch geprüft werden.");

    LANGUAGE lanaguageStringDieDateiEN = new LANGUAGE();
    lanaguageStringDieDateiEN.setISO639(ISO639.EN);
    lanaguageStringDieDateiEN.setTEXT("This file still needs to be checked.");

    LANGUAGE lanaguageStringDieDateiES = new LANGUAGE();
    lanaguageStringDieDateiES.setISO639(ISO639.ES);
    lanaguageStringDieDateiES.setTEXT("Todavía hay que comprobar este archivo.");

    languagesStringDieDatei.getLANGUAGE().add(lanaguageStringDieDateiDE);
    languagesStringDieDatei.getLANGUAGE().add(lanaguageStringDieDateiEN);
    languagesStringDieDatei.getLANGUAGE().add(lanaguageStringDieDateiES);
    commandStringDieDatei.setLANGUAGES(languagesStringDieDatei);

    COMMAND commandButtonOdxPlus = new COMMAND();
    commandButtonOdxPlus.setKEY(KEY.BUTTON_ODX_PLUS);
    LANGUAGES languagesButtonOdxPlus = new LANGUAGES();
    LANGUAGE languageButtonOdxPlusDE = new LANGUAGE();
    languageButtonOdxPlusDE.setISO639(ISO639.DE);
    languageButtonOdxPlusDE.setTEXT("");

    LANGUAGE languageButtonOdxPlusEN = new LANGUAGE();
    languageButtonOdxPlusEN.setISO639(ISO639.EN);
    languageButtonOdxPlusEN.setTEXT("");

    LANGUAGE languageButtonOdxPlusES = new LANGUAGE();
    languageButtonOdxPlusES.setISO639(ISO639.ES);
    languageButtonOdxPlusES.setTEXT("");

    languagesButtonOdxPlus.getLANGUAGE().add(languageButtonOdxPlusDE);
    languagesButtonOdxPlus.getLANGUAGE().add(languageButtonOdxPlusEN);
    languagesButtonOdxPlus.getLANGUAGE().add(languageButtonOdxPlusES);
    commandButtonOdxPlus.setLANGUAGES(languagesButtonOdxPlus);

    COMMAND commandButtonOdxMinus = new COMMAND();
    commandButtonOdxMinus.setKEY(KEY.BUTTON_ODX_MINUS);
    LANGUAGES languagesButtonOdxMinus = new LANGUAGES();

    LANGUAGE languageButtonOdxMinusDE = new LANGUAGE();
    languageButtonOdxMinusDE.setISO639(ISO639.DE);
    languageButtonOdxMinusDE.setTEXT("");

    LANGUAGE languageButtonOdxMinusEN = new LANGUAGE();
    languageButtonOdxMinusEN.setISO639(ISO639.EN);
    languageButtonOdxMinusEN.setTEXT("");

    LANGUAGE languageButtonOdxMinusES = new LANGUAGE();
    languageButtonOdxMinusES.setISO639(ISO639.ES);
    languageButtonOdxMinusES.setTEXT("");

    languagesButtonOdxMinus.getLANGUAGE().add(languageButtonOdxMinusDE);
    languagesButtonOdxMinus.getLANGUAGE().add(languageButtonOdxMinusEN);
    languagesButtonOdxMinus.getLANGUAGE().add(languageButtonOdxMinusES);
    commandButtonOdxMinus.setLANGUAGES(languagesButtonOdxMinus);

    COMMAND commandButtonMerge = new COMMAND();
    commandButtonMerge.setKEY(KEY.BUTTON_MERGE);
    LANGUAGES languagesButtonMerge = new LANGUAGES();
    LANGUAGE languageButtonMergeDE = new LANGUAGE();
    languageButtonMergeDE.setISO639(ISO639.DE);
    languageButtonMergeDE.setTEXT("Mischen");

    LANGUAGE languageButtonMergeEN = new LANGUAGE();
    languageButtonMergeEN.setISO639(ISO639.EN);
    languageButtonMergeEN.setTEXT("Merge");

    LANGUAGE languageButtonMergeES = new LANGUAGE();
    languageButtonMergeES.setISO639(ISO639.ES);
    languageButtonMergeES.setTEXT("Combinar");

    languagesButtonMerge.getLANGUAGE().add(languageButtonMergeDE);
    languagesButtonMerge.getLANGUAGE().add(languageButtonMergeEN);
    languagesButtonMerge.getLANGUAGE().add(languageButtonMergeES);

    commandButtonMerge.setLANGUAGES(languagesButtonMerge);

    COMMAND commandStringVerzeichnis = new COMMAND();
    commandStringVerzeichnis.setKEY(KEY.STRING_VERZEICHNIS);
    LANGUAGES languagesStringVerzeichnis = new LANGUAGES();
    LANGUAGE languageStringVerzeichnisDE = new LANGUAGE();
    languageStringVerzeichnisDE.setISO639(ISO639.DE);
    languageStringVerzeichnisDE.setTEXT("Verzeichnis");

    LANGUAGE languageStringVerzeichnisEN = new LANGUAGE();
    languageStringVerzeichnisEN.setISO639(ISO639.EN);
    languageStringVerzeichnisEN.setTEXT("Directory");

    LANGUAGE languageStringVerzeichnisES = new LANGUAGE();
    languageStringVerzeichnisES.setISO639(ISO639.ES);
    languageStringVerzeichnisES.setTEXT("Directorio");

    languagesStringVerzeichnis.getLANGUAGE().add(languageStringVerzeichnisDE);
    languagesStringVerzeichnis.getLANGUAGE().add(languageStringVerzeichnisEN);
    languagesStringVerzeichnis.getLANGUAGE().add(languageStringVerzeichnisES);
    commandStringVerzeichnis.setLANGUAGES(languagesStringVerzeichnis);

    COMMAND commandFrameSchemapruefung = new COMMAND();
    commandFrameSchemapruefung.setKEY(KEY.FRAME_SCHEMAPRUEFUNG);
    LANGUAGES languagesFrameSchempruefung = new LANGUAGES();
    LANGUAGE languageFrameSchemaprefungDE = new LANGUAGE();
    languageFrameSchemaprefungDE.setISO639(ISO639.DE);
    languageFrameSchemaprefungDE.setTEXT("Schemaprüfung - XXX");

    LANGUAGE languageFrameSchemaprefungEN = new LANGUAGE();
    languageFrameSchemaprefungEN.setISO639(ISO639.EN);
    languageFrameSchemaprefungEN.setTEXT("Scheme check - XXX");

    LANGUAGE languageFrameSchemaprefungES = new LANGUAGE();
    languageFrameSchemaprefungES.setISO639(ISO639.ES);
    languageFrameSchemaprefungES.setTEXT("Comprobación del sistema - XXX");

    languagesFrameSchempruefung.getLANGUAGE().add(languageFrameSchemaprefungDE);
    languagesFrameSchempruefung.getLANGUAGE().add(languageFrameSchemaprefungEN);
    languagesFrameSchempruefung.getLANGUAGE().add(languageFrameSchemaprefungES);
    commandFrameSchemapruefung.setLANGUAGES(languagesFrameSchempruefung);

    COMMAND commandStringBemerkung = new COMMAND();
    commandStringBemerkung.setKEY(KEY.STRING_BEMERKUNG);
    LANGUAGES languagesStringBemerkung = new LANGUAGES();
    LANGUAGE languageStringBemerkungDE = new LANGUAGE();
    languageStringBemerkungDE.setISO639(ISO639.DE);
    languageStringBemerkungDE.setTEXT("Bemerkung");

    LANGUAGE languageStringBemerkungEN = new LANGUAGE();
    languageStringBemerkungEN.setISO639(ISO639.EN);
    languageStringBemerkungEN.setTEXT("Comment");

    LANGUAGE languageStringBemerkungES = new LANGUAGE();
    languageStringBemerkungES.setISO639(ISO639.ES);
    languageStringBemerkungES.setTEXT("Comentario");

    languagesStringBemerkung.getLANGUAGE().add(languageStringBemerkungDE);
    languagesStringBemerkung.getLANGUAGE().add(languageStringBemerkungEN);
    languagesStringBemerkung.getLANGUAGE().add(languageStringBemerkungES);

    commandStringBemerkung.setLANGUAGES(languagesStringBemerkung);

    COMMAND commandLabelSchemadatei = new COMMAND();
    commandLabelSchemadatei.setKEY(KEY.LABEL_ODX_220_DATEI);
    LANGUAGES languagesLabelODX220Datei = new LANGUAGES();
    LANGUAGE languageLabelODX220DateiDE = new LANGUAGE();
    languageLabelODX220DateiDE.setISO639(ISO639.DE);
    languageLabelODX220DateiDE.setTEXT(
        "<html>"
            + "<p style='text-align:center'>Die Datei ist nicht ZZZ konform. Der Prüfbericht liegt unter</p><br>"
            + "<p style='text-align:center'><b> XXX </b></p>"
            + "<p style='text-align:center'><b> YYY </b></p>"
            + "</html>"
    );

    LANGUAGE languageLabelODX220DateiEN = new LANGUAGE();
    languageLabelODX220DateiEN.setISO639(ISO639.EN);
    languageLabelODX220DateiEN.setTEXT(
        "<html>"
            + "<p style='text-align:center'>The file is not ZZZ compliant. The report is located at</p><br>"
            + "<p style='text-align:center'><b> XXX </b></p>"
            + "<p style='text-align:center'><b> YYY </b></p>"
            + "</html>"
    );

    LANGUAGE languageLabelODX220DateiES = new LANGUAGE();
    languageLabelODX220DateiES.setISO639(ISO639.ES);
    languageLabelODX220DateiES.setTEXT(
        "<html>"
            + "<p style='text-align:center'>El archivo no es compatible con ZZZ. El informe de la prueba se encuentra en</p><br>"
            + "<p style='text-align:center'><b> XXX </b></p>"
            + "<p style='text-align:center'><b> YYY </b></p>"
            + "</html>"
    );

    languagesLabelODX220Datei.getLANGUAGE().add(languageLabelODX220DateiDE);
    languagesLabelODX220Datei.getLANGUAGE().add(languageLabelODX220DateiEN);
    languagesLabelODX220Datei.getLANGUAGE().add(languageLabelODX220DateiES);

    commandLabelSchemadatei.setLANGUAGES(languagesLabelODX220Datei);

    COMMAND commandButtonValidieren = new COMMAND();
    commandButtonValidieren.setKEY(KEY.BUTTON_VALIDIEREN);
    LANGUAGES languagesButtonValidieren = new LANGUAGES();
    LANGUAGE languageButtonValidierenDE = new LANGUAGE();
    languageButtonValidierenDE.setISO639(ISO639.DE);
    languageButtonValidierenDE.setTEXT("Prüfen");

    LANGUAGE languageButtonValidierenEN = new LANGUAGE();
    languageButtonValidierenEN.setISO639(ISO639.EN);
    languageButtonValidierenEN.setTEXT("Check");

    LANGUAGE languageButtonValidierenES = new LANGUAGE();
    languageButtonValidierenES.setISO639(ISO639.ES);
    languageButtonValidierenES.setTEXT("Comprobar");

    languagesButtonValidieren.getLANGUAGE().add(languageButtonValidierenDE);
    languagesButtonValidieren.getLANGUAGE().add(languageButtonValidierenEN);
    languagesButtonValidieren.getLANGUAGE().add(languageButtonValidierenES);
    commandButtonValidieren.setLANGUAGES(languagesButtonValidieren);

    COMMAND commandStringKorrupteDateien = new COMMAND();
    commandStringKorrupteDateien.setKEY(KEY.STRING_KORRUPTE_DATEIEN);
    LANGUAGES languagesKorrupteDateien = new LANGUAGES();
    LANGUAGE languageStringKorrupteDateienDE = new LANGUAGE();
    languageStringKorrupteDateienDE.setISO639(ISO639.DE);
    languageStringKorrupteDateienDE.setTEXT("Beschädigte Dateien werden nicht neu gemischt.");

    LANGUAGE languageStringKorrupteDateienEN = new LANGUAGE();
    languageStringKorrupteDateienEN.setISO639(ISO639.EN);
    languageStringKorrupteDateienEN.setTEXT("Corrupt files are not shuffled.");

    LANGUAGE languageStringKorrupteDateienES = new LANGUAGE();
    languageStringKorrupteDateienES.setISO639(ISO639.ES);
    languageStringKorrupteDateienES.setTEXT("Los archivos corruptos no se barajan.");

    languagesKorrupteDateien.getLANGUAGE().add(languageStringKorrupteDateienDE);
    languagesKorrupteDateien.getLANGUAGE().add(languageStringKorrupteDateienEN);
    languagesKorrupteDateien.getLANGUAGE().add(languageStringKorrupteDateienES);

    commandStringKorrupteDateien.setLANGUAGES(languagesKorrupteDateien);

    COMMAND commandStringMindestens2Dateien = new COMMAND();
    commandStringMindestens2Dateien.setKEY(KEY.STRING_MINDESTENS_2_DATEIEN);
    LANGUAGES languagesMindesten2Dateien = new LANGUAGES();
    LANGUAGE languageStringMindestens2DateienDE = new LANGUAGE();
    languageStringMindestens2DateienDE.setISO639(ISO639.DE);
    languageStringMindestens2DateienDE.setTEXT("Mindestens 2 Dateien müssen gemischt werden.");

    LANGUAGE languageStringMindestens2DateienEN = new LANGUAGE();
    languageStringMindestens2DateienEN.setISO639(ISO639.EN);
    languageStringMindestens2DateienEN.setTEXT("At least 2 files must be merged.");

    LANGUAGE languageStringMindestens2DateienES = new LANGUAGE();
    languageStringMindestens2DateienES.setISO639(ISO639.ES);
    languageStringMindestens2DateienES.setTEXT("Deben mezclarse al menos 2 archivos.");

    languagesMindesten2Dateien.getLANGUAGE().add(languageStringMindestens2DateienDE);
    languagesMindesten2Dateien.getLANGUAGE().add(languageStringMindestens2DateienEN);
    languagesMindesten2Dateien.getLANGUAGE().add(languageStringMindestens2DateienES);

    commandStringMindestens2Dateien.setLANGUAGES(languagesMindesten2Dateien);

    COMMAND commandStringAddFiles = new COMMAND();
    commandStringAddFiles.setKEY(KEY.STRING_ADD_FILES);
    LANGUAGES languagesAddFiles = new LANGUAGES();
    LANGUAGE languageStringAddFilesDE = new LANGUAGE();
    languageStringAddFilesDE.setISO639(ISO639.DE);
    languageStringAddFilesDE.setTEXT("Dateien hinzufügen");

    LANGUAGE languageStringAddFilesEN = new LANGUAGE();
    languageStringAddFilesEN.setISO639(ISO639.EN);
    languageStringAddFilesEN.setTEXT("Add files");

    LANGUAGE languageStringAddFilesES = new LANGUAGE();
    languageStringAddFilesES.setISO639(ISO639.ES);
    languageStringAddFilesES.setTEXT("Agregar archivos");

    languagesAddFiles.getLANGUAGE().add(languageStringAddFilesDE);
    languagesAddFiles.getLANGUAGE().add(languageStringAddFilesEN);
    languagesAddFiles.getLANGUAGE().add(languageStringAddFilesES);

    commandStringAddFiles.setLANGUAGES(languagesAddFiles);

    COMMAND commandStringRemoveFiles = new COMMAND();
    commandStringRemoveFiles.setKEY(KEY.STRING_REMOVE_FILES);
    LANGUAGES languagesRemoveFiles = new LANGUAGES();
    LANGUAGE languageStringRemoveFileDE = new LANGUAGE();
    languageStringRemoveFileDE.setISO639(ISO639.DE);
    languageStringRemoveFileDE.setTEXT("Dateien entfernen");

    LANGUAGE languageStringRemoveFileEN = new LANGUAGE();
    languageStringRemoveFileEN.setISO639(ISO639.EN);
    languageStringRemoveFileEN.setTEXT("Remove files");

    LANGUAGE languageStringRemoveFileES = new LANGUAGE();
    languageStringRemoveFileES.setISO639(ISO639.ES);
    languageStringRemoveFileES.setTEXT("Eliminar archivos");

    languagesRemoveFiles.getLANGUAGE().add(languageStringRemoveFileDE);
    languagesRemoveFiles.getLANGUAGE().add(languageStringRemoveFileEN);
    languagesRemoveFiles.getLANGUAGE().add(languageStringRemoveFileES);

    commandStringRemoveFiles.setLANGUAGES(languagesRemoveFiles);

    COMMAND commandStringAnwender = new COMMAND();
    commandStringAnwender.setKEY(KEY.STRING_ANWENDER);
    LANGUAGES languagesStringAnwneder = new LANGUAGES();
    LANGUAGE languageStringAnwenderDE = new LANGUAGE();
    languageStringAnwenderDE.setISO639(ISO639.DE);
    languageStringAnwenderDE.setTEXT("Anwender");

    LANGUAGE languageStringAnwenderEN = new LANGUAGE();
    languageStringAnwenderEN.setISO639(ISO639.EN);
    languageStringAnwenderEN.setTEXT("Users");

    LANGUAGE languageStringAnwenderES = new LANGUAGE();
    languageStringAnwenderES.setISO639(ISO639.ES);
    languageStringAnwenderES.setTEXT("Usuarios");

    languagesStringAnwneder.getLANGUAGE().add(languageStringAnwenderDE);
    languagesStringAnwneder.getLANGUAGE().add(languageStringAnwenderEN);
    languagesStringAnwneder.getLANGUAGE().add(languageStringAnwenderES);
    commandStringAnwender.setLANGUAGES(languagesStringAnwneder);

    COMMAND commandStringDeinKontoWurde = new COMMAND();
    commandStringDeinKontoWurde.setKEY(KEY.STRING_KONTO_DEAKTIVIERT);
    LANGUAGES languagesKontoDeaktiviert = new LANGUAGES();
    LANGUAGE languageKontoDeaktiviertDE = new LANGUAGE();
    languageKontoDeaktiviertDE.setISO639(ISO639.DE);
    languageKontoDeaktiviertDE
        .setTEXT("Dein Konto wurde deaktiviert. Ein Administrator muss die Sperre aufheben.");

    LANGUAGE languageKontoDeaktiviertEN = new LANGUAGE();
    languageKontoDeaktiviertEN.setISO639(ISO639.EN);
    languageKontoDeaktiviertEN
        .setTEXT("Your account has been disabled. An administrator needs to unlock it.");

    LANGUAGE languageKontoDeaktiviertES = new LANGUAGE();
    languageKontoDeaktiviertES.setISO639(ISO639.ES);
    languageKontoDeaktiviertES
        .setTEXT("Tu cuenta ha sido desactivada. Un administrador debe desbloquear la cuenta.");

    languagesKontoDeaktiviert.getLANGUAGE().add(languageKontoDeaktiviertDE);
    languagesKontoDeaktiviert.getLANGUAGE().add(languageKontoDeaktiviertEN);
    languagesKontoDeaktiviert.getLANGUAGE().add(languageKontoDeaktiviertES);

    commandStringDeinKontoWurde.setLANGUAGES(languagesKontoDeaktiviert);

    // Ein Benutzer kann sich nicht mehr anmelden, wenn sein Konto logisch gelöscht
    // ist.

    COMMAND commandStringKontoAnmelden = new COMMAND();
    LANGUAGES languagesKontoAnmelden = new LANGUAGES();
    LANGUAGE languageKontoAnmeldenDE = new LANGUAGE();
    languageKontoAnmeldenDE.setISO639(ISO639.DE);
    languageKontoAnmeldenDE
        .setTEXT("Ein Benutzer kann sich nicht mehr anmelden, wenn sein Konto logisch gelöscht ist.");

    LANGUAGE languageKontoAnmeldenEN = new LANGUAGE();
    languageKontoAnmeldenEN.setISO639(ISO639.EN);
    languageKontoAnmeldenEN.setTEXT("A user can no longer log in if his account is logically deleted.");

    LANGUAGE languageKontoAnmeldenES = new LANGUAGE();
    languageKontoAnmeldenES.setISO639(ISO639.ES);
    languageKontoAnmeldenES.setTEXT("Un usuario ya no puede conectarse si su cuenta se elimina lógicamente.");

    languagesKontoAnmelden.getLANGUAGE().add(languageKontoAnmeldenDE);
    languagesKontoAnmelden.getLANGUAGE().add(languageKontoAnmeldenEN);
    languagesKontoAnmelden.getLANGUAGE().add(languageKontoAnmeldenES);

    commandStringKontoAnmelden.setKEY(KEY.STRING_KONTO_ANMELDEN);
    commandStringKontoAnmelden.setLANGUAGES(languagesKontoAnmelden);

    COMMAND commandStringLogischGeloescht = new COMMAND();
    commandStringLogischGeloescht.setKEY(KEY.STRING_LOGISCH_GELOESCHT);
    LANGUAGES languagesLogischGeleoescht = new LANGUAGES();
    LANGUAGE languageLogischGeloeschtDE = new LANGUAGE();
    languageLogischGeloeschtDE.setISO639(ISO639.DE);
    languageLogischGeloeschtDE.setTEXT("Logisch gelöscht");

    LANGUAGE languageLogischGeloeschtEN = new LANGUAGE();
    languageLogischGeloeschtEN.setISO639(ISO639.EN);
    languageLogischGeloeschtEN.setTEXT("Logically deleted");

    LANGUAGE languageLogischGeloeschtES = new LANGUAGE();
    languageLogischGeloeschtES.setISO639(ISO639.ES);
    languageLogischGeloeschtES.setTEXT("Lógicamente eliminado");

    languagesLogischGeleoescht.getLANGUAGE().add(languageLogischGeloeschtDE);
    languagesLogischGeleoescht.getLANGUAGE().add(languageLogischGeloeschtEN);
    languagesLogischGeleoescht.getLANGUAGE().add(languageLogischGeloeschtES);
    commandStringLogischGeloescht.setLANGUAGES(languagesLogischGeleoescht);

    COMMAND commandStringAblaufdatum = new COMMAND();
    commandStringAblaufdatum.setKEY(KEY.STRING_ABLAUFDATUM);
    LANGUAGES languagesStringAblaufdatum = new LANGUAGES();
    LANGUAGE languageAblaufdatumDE = new LANGUAGE();
    languageAblaufdatumDE.setISO639(ISO639.DE);
    languageAblaufdatumDE.setTEXT("Ablaufdatum");

    LANGUAGE languageAblaufdatumEN = new LANGUAGE();
    languageAblaufdatumEN.setISO639(ISO639.EN);
    languageAblaufdatumEN.setTEXT("Expiry Date");

    LANGUAGE languageAblaufdatumES = new LANGUAGE();
    languageAblaufdatumES.setISO639(ISO639.ES);
    languageAblaufdatumES.setTEXT("Fecha de expiración");

    languagesStringAblaufdatum.getLANGUAGE().add(languageAblaufdatumDE);
    languagesStringAblaufdatum.getLANGUAGE().add(languageAblaufdatumEN);
    languagesStringAblaufdatum.getLANGUAGE().add(languageAblaufdatumES);
    commandStringAblaufdatum.setLANGUAGES(languagesStringAblaufdatum);

    COMMAND commandStringDasBenutzerkonto = new COMMAND();
    commandStringDasBenutzerkonto.setKEY(KEY.STRING_DAS_BENUTZERKONTO);
    LANGUAGES languagesDasBenutzerkonto = new LANGUAGES();
    LANGUAGE languageDasBenutzerkontoDE = new LANGUAGE();
    languageDasBenutzerkontoDE.setISO639(ISO639.DE);
    languageDasBenutzerkontoDE.setTEXT("Das Benutzerkonto wurde logisch gelöscht.");

    LANGUAGE languageDasBenutzerkontoEN = new LANGUAGE();
    languageDasBenutzerkontoEN.setISO639(ISO639.EN);
    languageDasBenutzerkontoEN.setTEXT("The user account was logically deleted.");

    LANGUAGE languageDasBenutzerkontoES = new LANGUAGE();
    languageDasBenutzerkontoES.setISO639(ISO639.ES);
    languageDasBenutzerkontoES.setTEXT("La cuenta de usuario se ha eliminado lógicamente.");

    languagesDasBenutzerkonto.getLANGUAGE().add(languageDasBenutzerkontoDE);
    languagesDasBenutzerkonto.getLANGUAGE().add(languageDasBenutzerkontoEN);
    languagesDasBenutzerkonto.getLANGUAGE().add(languageDasBenutzerkontoES);
    commandStringDasBenutzerkonto.setLANGUAGES(languagesDasBenutzerkonto);

    COMMAND commandStringBenutzerkontoAktiviert = new COMMAND();
    commandStringBenutzerkontoAktiviert.setKEY(KEY.STRING_BENUTZERKONTO_AKTIVIERT);
    LANGUAGES languagesBenutzerkontoAktiviert = new LANGUAGES();
    LANGUAGE languageBenutzerkontoAktiviertDE = new LANGUAGE();
    languageBenutzerkontoAktiviertDE.setISO639(ISO639.DE);
    languageBenutzerkontoAktiviertDE.setTEXT("Das Benutzerkonto wurde wieder aktiviert.");

    LANGUAGE languageBenutzerkontoAktiviertEN = new LANGUAGE();
    languageBenutzerkontoAktiviertEN.setISO639(ISO639.EN);
    languageBenutzerkontoAktiviertEN.setTEXT("The user account has been reactivated.");

    LANGUAGE languageBenutzerkontoAktiviertES = new LANGUAGE();
    languageBenutzerkontoAktiviertES.setISO639(ISO639.ES);
    languageBenutzerkontoAktiviertES.setTEXT("La cuenta de usuario ha sido reactivada.");

    languagesBenutzerkontoAktiviert.getLANGUAGE().add(languageBenutzerkontoAktiviertDE);
    languagesBenutzerkontoAktiviert.getLANGUAGE().add(languageBenutzerkontoAktiviertEN);
    languagesBenutzerkontoAktiviert.getLANGUAGE().add(languageBenutzerkontoAktiviertES);

    commandStringBenutzerkontoAktiviert.setLANGUAGES(languagesBenutzerkontoAktiviert);

    COMMAND commandStringTeilnehmerliste = new COMMAND();
    commandStringTeilnehmerliste.setKEY(KEY.STRING_TEILNEHMERLISTE);
    LANGUAGES languagesTeilnehmerliste = new LANGUAGES();
    LANGUAGE languageTeilnehmerlisteDE = new LANGUAGE();
    languageTeilnehmerlisteDE.setISO639(ISO639.DE);
    languageTeilnehmerlisteDE.setTEXT("Die Teilnehmerliste wurde verändert.");

    LANGUAGE languageTeilnehmerlisteEN = new LANGUAGE();
    languageTeilnehmerlisteEN.setISO639(ISO639.EN);
    languageTeilnehmerlisteEN.setTEXT("The list of participants has been changed.");

    LANGUAGE languageTeilnehmerlisteES = new LANGUAGE();
    languageTeilnehmerlisteES.setISO639(ISO639.ES);
    languageTeilnehmerlisteES.setTEXT("Se ha modificado la lista de participantes.");

    languagesTeilnehmerliste.getLANGUAGE().add(languageTeilnehmerlisteDE);
    languagesTeilnehmerliste.getLANGUAGE().add(languageTeilnehmerlisteEN);
    languagesTeilnehmerliste.getLANGUAGE().add(languageTeilnehmerlisteES);
    commandStringTeilnehmerliste.setLANGUAGES(languagesTeilnehmerliste);

    COMMAND commandStringApply = new COMMAND();
    commandStringApply.setKEY(KEY.STRING_APPLY);
    LANGUAGES languagesStringApply = new LANGUAGES();
    LANGUAGE languageStringApplyDE = new LANGUAGE();
    languageStringApplyDE.setISO639(ISO639.DE);
    languageStringApplyDE.setTEXT("Übernehmen");

    LANGUAGE languageStringApplyEN = new LANGUAGE();
    languageStringApplyEN.setISO639(ISO639.EN);
    languageStringApplyEN.setTEXT("Apply");

    LANGUAGE languageStringApplyES = new LANGUAGE();
    languageStringApplyES.setISO639(ISO639.ES);
    languageStringApplyES.setTEXT("Aplicar");

    languagesStringApply.getLANGUAGE().add(languageStringApplyDE);
    languagesStringApply.getLANGUAGE().add(languageStringApplyEN);
    languagesStringApply.getLANGUAGE().add(languageStringApplyES);
    commandStringApply.setLANGUAGES(languagesStringApply);

    COMMAND commandStringBack = new COMMAND();
    commandStringBack.setKEY(KEY.STRING_BACK);
    LANGUAGES languagesStringBack = new LANGUAGES();
    LANGUAGE languageStringBackDE = new LANGUAGE();
    languageStringBackDE.setISO639(ISO639.DE);
    languageStringBackDE.setTEXT("Zurück");

    LANGUAGE languageStringBackEN = new LANGUAGE();
    languageStringBackEN.setISO639(ISO639.EN);
    languageStringBackEN.setTEXT("Back");

    LANGUAGE languageStringBackES = new LANGUAGE();
    languageStringBackES.setISO639(ISO639.ES);
    languageStringBackES.setTEXT("Volver");

    languagesStringBack.getLANGUAGE().add(languageStringBackDE);
    languagesStringBack.getLANGUAGE().add(languageStringBackEN);
    languagesStringBack.getLANGUAGE().add(languageStringBackES);

    commandStringBack.setLANGUAGES(languagesStringBack);

    COMMAND commandStringUpload = new COMMAND();
    commandStringUpload.setKEY(KEY.STRING_UPLOAD);
    LANGUAGES languagesStringUpload = new LANGUAGES();
    LANGUAGE languageStringUploadDE = new LANGUAGE();
    languageStringUploadDE.setISO639(ISO639.DE);
    languageStringUploadDE.setTEXT("Hochladen");

    LANGUAGE languageStringUploadEN = new LANGUAGE();
    languageStringUploadEN.setISO639(ISO639.EN);
    languageStringUploadEN.setTEXT("Upload");

    LANGUAGE languageStringUploadES = new LANGUAGE();
    languageStringUploadES.setISO639(ISO639.ES);
    languageStringUploadES.setTEXT("Cargar");

    languagesStringUpload.getLANGUAGE().add(languageStringUploadDE);
    languagesStringUpload.getLANGUAGE().add(languageStringUploadEN);
    languagesStringUpload.getLANGUAGE().add(languageStringUploadES);

    commandStringUpload.setLANGUAGES(languagesStringUpload);

    COMMAND commandStringName = new COMMAND();
    commandStringName.setKEY(KEY.STRING_NAME);
    LANGUAGES languagesStringName = new LANGUAGES();
    LANGUAGE lanaguageStringNameDE = new LANGUAGE();
    lanaguageStringNameDE.setISO639(ISO639.DE);
    lanaguageStringNameDE.setTEXT("Name");

    LANGUAGE lanaguageStringNameEN = new LANGUAGE();
    lanaguageStringNameEN.setISO639(ISO639.EN);
    lanaguageStringNameEN.setTEXT("Name");

    LANGUAGE lanaguageStringNameES = new LANGUAGE();
    lanaguageStringNameES.setISO639(ISO639.ES);
    lanaguageStringNameES.setTEXT("Nombre");

    languagesStringName.getLANGUAGE().add(lanaguageStringNameDE);
    languagesStringName.getLANGUAGE().add(lanaguageStringNameEN);
    languagesStringName.getLANGUAGE().add(lanaguageStringNameES);
    commandStringName.setLANGUAGES(languagesStringName);

    COMMAND commandStringSize = new COMMAND();
    commandStringSize.setKEY(KEY.STRING_SIZE);
    LANGUAGES languagesStringSize = new LANGUAGES();
    LANGUAGE lanaguageStringSizeDE = new LANGUAGE();
    lanaguageStringSizeDE.setISO639(ISO639.DE);
    lanaguageStringSizeDE.setTEXT("Größe");

    LANGUAGE lanaguageStringSizeEN = new LANGUAGE();
    lanaguageStringSizeEN.setISO639(ISO639.EN);
    lanaguageStringSizeEN.setTEXT("Size");

    LANGUAGE lanaguageStringSizeES = new LANGUAGE();
    lanaguageStringSizeES.setISO639(ISO639.ES);
    lanaguageStringSizeES.setTEXT("Tamaño");

    languagesStringSize.getLANGUAGE().add(lanaguageStringSizeDE);
    languagesStringSize.getLANGUAGE().add(lanaguageStringSizeEN);
    languagesStringSize.getLANGUAGE().add(lanaguageStringSizeES);
    commandStringSize.setLANGUAGES(languagesStringSize);

    COMMAND commandStringType = new COMMAND();
    commandStringType.setKEY(KEY.STRING_TYPE);
    LANGUAGES languagesStringType = new LANGUAGES();
    LANGUAGE lanaguageStringTypeDE = new LANGUAGE();
    lanaguageStringTypeDE.setISO639(ISO639.DE);
    lanaguageStringTypeDE.setTEXT("Typ");

    LANGUAGE lanaguageStringTypeEN = new LANGUAGE();
    lanaguageStringTypeEN.setISO639(ISO639.EN);
    lanaguageStringTypeEN.setTEXT("Type");

    LANGUAGE lanaguageStringTypeES = new LANGUAGE();
    lanaguageStringTypeES.setISO639(ISO639.ES);
    lanaguageStringTypeES.setTEXT("Tipo");

    languagesStringType.getLANGUAGE().add(lanaguageStringTypeDE);
    languagesStringType.getLANGUAGE().add(lanaguageStringTypeEN);
    languagesStringType.getLANGUAGE().add(lanaguageStringTypeES);

    commandStringType.setLANGUAGES(languagesStringType);

    COMMAND commandStringModified = new COMMAND();
    commandStringModified.setKEY(KEY.STRING_MODIFIED);
    LANGUAGES languagesStringModified = new LANGUAGES();
    LANGUAGE lanaguageStringModifiedDE = new LANGUAGE();
    lanaguageStringModifiedDE.setISO639(ISO639.DE);
    lanaguageStringModifiedDE.setTEXT("Geändert");

    LANGUAGE lanaguageStringModifiedEN = new LANGUAGE();
    lanaguageStringModifiedEN.setISO639(ISO639.EN);
    lanaguageStringModifiedEN.setTEXT("Modified");

    LANGUAGE lanaguageStringModifiedES = new LANGUAGE();
    lanaguageStringModifiedES.setISO639(ISO639.ES);
    lanaguageStringModifiedES.setTEXT("Modificado");

    languagesStringModified.getLANGUAGE().add(lanaguageStringModifiedDE);
    languagesStringModified.getLANGUAGE().add(lanaguageStringModifiedEN);
    languagesStringModified.getLANGUAGE().add(lanaguageStringModifiedES);

    commandStringModified.setLANGUAGES(languagesStringModified);

    COMMAND commandMenuGaming = new COMMAND();
    commandMenuGaming.setKEY(KEY.GAMING);
    LANGUAGES languagesMenuGaming = new LANGUAGES();
    LANGUAGE lanaguageMenuGamingDE = new LANGUAGE();
    lanaguageMenuGamingDE.setISO639(ISO639.DE);
    lanaguageMenuGamingDE.setTEXT("Spiele");
    lanaguageMenuGamingDE.setSHORTCUT(VIRTUALKEY.VK_S);

    LANGUAGE lanaguageMenuGamingEN = new LANGUAGE();
    lanaguageMenuGamingEN.setISO639(ISO639.EN);
    lanaguageMenuGamingEN.setTEXT("Gaming");
    lanaguageMenuGamingEN.setSHORTCUT(VIRTUALKEY.VK_G);

    LANGUAGE lanaguageMenuGamingES = new LANGUAGE();
    lanaguageMenuGamingES.setISO639(ISO639.ES);
    lanaguageMenuGamingES.setTEXT("Juegos");
    lanaguageMenuGamingES.setSHORTCUT(VIRTUALKEY.VK_U);

    languagesMenuGaming.getLANGUAGE().add(lanaguageMenuGamingDE);
    languagesMenuGaming.getLANGUAGE().add(lanaguageMenuGamingEN);
    languagesMenuGaming.getLANGUAGE().add(lanaguageMenuGamingES);
    commandMenuGaming.setLANGUAGES(languagesMenuGaming);

    COMMAND commandFrameMastermind = new COMMAND();
    commandFrameMastermind.setKEY(KEY.FRAME_MASTERMIND);
    LANGUAGES languagesFrameMastermind = new LANGUAGES();
    LANGUAGE lanaguageFrameMastermindDE = new LANGUAGE();
    lanaguageFrameMastermindDE.setISO639(ISO639.DE);
    lanaguageFrameMastermindDE.setTEXT("Mastermind");

    LANGUAGE lanaguageFrameMastermindEN = new LANGUAGE();
    lanaguageFrameMastermindEN.setISO639(ISO639.EN);
    lanaguageFrameMastermindEN.setTEXT("Mastermind");

    LANGUAGE lanaguageFrameMastermindES = new LANGUAGE();
    lanaguageFrameMastermindES.setISO639(ISO639.ES);
    lanaguageFrameMastermindES.setTEXT("Mente maestra");

    languagesFrameMastermind.getLANGUAGE().add(lanaguageFrameMastermindDE);
    languagesFrameMastermind.getLANGUAGE().add(lanaguageFrameMastermindEN);
    languagesFrameMastermind.getLANGUAGE().add(lanaguageFrameMastermindES);

    commandFrameMastermind.setLANGUAGES(languagesFrameMastermind);

    COMMAND commandButtonAnleitung = new COMMAND();
    commandButtonAnleitung.setKEY(KEY.BUTTON_ANLEITUNG);
    LANGUAGES languagesButtonAnleitung = new LANGUAGES();
    LANGUAGE lanaguageButtonAnleitungDE = new LANGUAGE();
    lanaguageButtonAnleitungDE.setISO639(ISO639.DE);
    lanaguageButtonAnleitungDE.setTEXT("Anleitung");

    LANGUAGE lanaguageButtonAnleitungEN = new LANGUAGE();
    lanaguageButtonAnleitungEN.setISO639(ISO639.EN);
    lanaguageButtonAnleitungEN.setTEXT("Instruction");

    LANGUAGE lanaguageButtonAnleitungES = new LANGUAGE();
    lanaguageButtonAnleitungES.setISO639(ISO639.ES);
    lanaguageButtonAnleitungES.setTEXT("Instrucciones");

    languagesButtonAnleitung.getLANGUAGE().add(lanaguageButtonAnleitungDE);
    languagesButtonAnleitung.getLANGUAGE().add(lanaguageButtonAnleitungEN);
    languagesButtonAnleitung.getLANGUAGE().add(lanaguageButtonAnleitungES);
    commandButtonAnleitung.setLANGUAGES(languagesButtonAnleitung);

    COMMAND commandNeuesSpiel = new COMMAND();
    commandNeuesSpiel.setKEY(KEY.BUTTON_NEUES_SPIEL);
    LANGUAGES languagesButtonNeuesSpiel = new LANGUAGES();
    LANGUAGE lanaguagesNeuesSpielDE = new LANGUAGE();
    lanaguagesNeuesSpielDE.setISO639(ISO639.DE);
    lanaguagesNeuesSpielDE.setTEXT("Neues Spiel");

    LANGUAGE lanaguagesNeuesSpielEN = new LANGUAGE();
    lanaguagesNeuesSpielEN.setISO639(ISO639.EN);
    lanaguagesNeuesSpielEN.setTEXT("New Game");

    LANGUAGE lanaguagesNeuesSpielES = new LANGUAGE();
    lanaguagesNeuesSpielES.setISO639(ISO639.ES);
    lanaguagesNeuesSpielES.setTEXT("Nuevo Juego");

    languagesButtonNeuesSpiel.getLANGUAGE().add(lanaguagesNeuesSpielDE);
    languagesButtonNeuesSpiel.getLANGUAGE().add(lanaguagesNeuesSpielEN);
    languagesButtonNeuesSpiel.getLANGUAGE().add(lanaguagesNeuesSpielES);
    commandNeuesSpiel.setLANGUAGES(languagesButtonNeuesSpiel);

    COMMAND commandSpielStarten = new COMMAND();
    commandSpielStarten.setKEY(KEY.BUTTON_SPIEL_STARTEN);
    LANGUAGES languagesSpielStarten = new LANGUAGES();
    LANGUAGE lanaguagesSpielStartenDE = new LANGUAGE();
    lanaguagesSpielStartenDE.setISO639(ISO639.DE);
    lanaguagesSpielStartenDE.setTEXT("Spiel starten");

    LANGUAGE lanaguagesSpielStartenEN = new LANGUAGE();
    lanaguagesSpielStartenEN.setISO639(ISO639.EN);
    lanaguagesSpielStartenEN.setTEXT("Start Game");

    LANGUAGE lanaguagesSpielStartenES = new LANGUAGE();
    lanaguagesSpielStartenES.setISO639(ISO639.ES);
    lanaguagesSpielStartenES.setTEXT("Iniciar juego");

    languagesSpielStarten.getLANGUAGE().add(lanaguagesSpielStartenDE);
    languagesSpielStarten.getLANGUAGE().add(lanaguagesSpielStartenEN);
    languagesSpielStarten.getLANGUAGE().add(lanaguagesSpielStartenES);
    commandSpielStarten.setLANGUAGES(languagesSpielStarten);

    COMMAND commandStringSolution = new COMMAND();
    commandStringSolution.setKEY(KEY.STRING_SOLUTION);
    LANGUAGES languagesStringSolution = new LANGUAGES();
    LANGUAGE lanaguagesStringSolutionDE = new LANGUAGE();
    lanaguagesStringSolutionDE.setISO639(ISO639.DE);
    lanaguagesStringSolutionDE.setTEXT("Lösung");

    LANGUAGE lanaguagesStringSolutionEN = new LANGUAGE();
    lanaguagesStringSolutionEN.setISO639(ISO639.EN);
    lanaguagesStringSolutionEN.setTEXT("Solution");

    LANGUAGE lanaguagesStringSolutionES = new LANGUAGE();
    lanaguagesStringSolutionES.setISO639(ISO639.ES);
    lanaguagesStringSolutionES.setTEXT("Solución");

    languagesStringSolution.getLANGUAGE().add(lanaguagesStringSolutionDE);
    languagesStringSolution.getLANGUAGE().add(lanaguagesStringSolutionEN);
    languagesStringSolution.getLANGUAGE().add(lanaguagesStringSolutionES);
    commandStringSolution.setLANGUAGES(languagesStringSolution);

    COMMAND commandLabelSchwierigkeitsgrad = new COMMAND();
    commandLabelSchwierigkeitsgrad.setKEY(KEY.LABEL_SCHWIERIGKEITSGRAD);
    LANGUAGES languagesLabelSchwierigkeitsgrad = new LANGUAGES();
    LANGUAGE lanaguagesLabelSchweierigkeisgradDE = new LANGUAGE();
    lanaguagesLabelSchweierigkeisgradDE.setISO639(ISO639.DE);
    lanaguagesLabelSchweierigkeisgradDE.setTEXT("Schwierigkeitsgrad");

    LANGUAGE lanaguagesLabelSchweierigkeisgradEN = new LANGUAGE();
    lanaguagesLabelSchweierigkeisgradEN.setISO639(ISO639.EN);
    lanaguagesLabelSchweierigkeisgradEN.setTEXT("Difficulty");

    LANGUAGE lanaguagesLabelSchweierigkeisgradES = new LANGUAGE();
    lanaguagesLabelSchweierigkeisgradES.setISO639(ISO639.ES);
    lanaguagesLabelSchweierigkeisgradES.setTEXT("Dificultad");

    languagesLabelSchwierigkeitsgrad.getLANGUAGE().add(lanaguagesLabelSchweierigkeisgradDE);
    languagesLabelSchwierigkeitsgrad.getLANGUAGE().add(lanaguagesLabelSchweierigkeisgradEN);
    languagesLabelSchwierigkeitsgrad.getLANGUAGE().add(lanaguagesLabelSchweierigkeisgradES);
    commandLabelSchwierigkeitsgrad.setLANGUAGES(languagesLabelSchwierigkeitsgrad);

//    Im Suchmuster darf dieselbe Farbe mehrmals vorkommen.
    // Den Haken setzen, wenn gleiche Farben im Muster erlaubt sind.

    COMMAND commandCheckboxFarbmuster = new COMMAND();
    commandCheckboxFarbmuster.setKEY(KEY.CHECKBOX_FARBMUSTER);
    LANGUAGES languagesCheckboxFarbmuster = new LANGUAGES();
    LANGUAGE lanaguagesCheckboxFarbmusterDE = new LANGUAGE();
    lanaguagesCheckboxFarbmusterDE.setISO639(ISO639.DE);
    lanaguagesCheckboxFarbmusterDE
        .setTEXT("<html>Den Haken setzen, wenn gleiche<br>Farben im Muster erlaubt sind.</html>");

    LANGUAGE lanaguagesCheckboxFarbmusterEN = new LANGUAGE();
    lanaguagesCheckboxFarbmusterEN.setISO639(ISO639.EN);
    lanaguagesCheckboxFarbmusterEN
        .setTEXT("<html>Check the box if the same colors<br>are allowed in the pattern.</html>");

    LANGUAGE lanaguagesCheckboxFarbmusterES = new LANGUAGE();
    lanaguagesCheckboxFarbmusterES.setISO639(ISO639.ES);
    lanaguagesCheckboxFarbmusterES
        .setTEXT("<html>Marqua la casilla si se permiten<br>los mismos colores en el patrón.</html>");

    languagesCheckboxFarbmuster.getLANGUAGE().add(lanaguagesCheckboxFarbmusterDE);
    languagesCheckboxFarbmuster.getLANGUAGE().add(lanaguagesCheckboxFarbmusterEN);
    languagesCheckboxFarbmuster.getLANGUAGE().add(lanaguagesCheckboxFarbmusterES);

    commandCheckboxFarbmuster.setLANGUAGES(languagesCheckboxFarbmuster);

    COMMAND commandStringBenutzerfehler = new COMMAND();
    commandStringBenutzerfehler.setKEY(KEY.STRING_BENUTZERFEHLER);
    LANGUAGES languagesStringBenutzerfehler = new LANGUAGES();
    LANGUAGE lanaguageStringBenutzerfehlerDE = new LANGUAGE();
    lanaguageStringBenutzerfehlerDE.setISO639(ISO639.DE);
    lanaguageStringBenutzerfehlerDE.setTEXT("Benutzerfehler");

    LANGUAGE lanaguageStringBenutzerfehlerEN = new LANGUAGE();
    lanaguageStringBenutzerfehlerEN.setISO639(ISO639.EN);
    lanaguageStringBenutzerfehlerEN.setTEXT("User error");

    LANGUAGE lanaguageStringBenutzerfehlerES = new LANGUAGE();
    lanaguageStringBenutzerfehlerES.setISO639(ISO639.ES);
    lanaguageStringBenutzerfehlerES.setTEXT("Error de usuario");

    languagesStringBenutzerfehler.getLANGUAGE().add(lanaguageStringBenutzerfehlerDE);
    languagesStringBenutzerfehler.getLANGUAGE().add(lanaguageStringBenutzerfehlerEN);
    languagesStringBenutzerfehler.getLANGUAGE().add(lanaguageStringBenutzerfehlerES);

    commandStringBenutzerfehler.setLANGUAGES(languagesStringBenutzerfehler);

    COMMAND commandStringEsWurdeNicht = new COMMAND();
    commandStringEsWurdeNicht.setKEY(KEY.STRING_ES_WURDE_NICHT);
    LANGUAGES languagesEsWurdeNicht = new LANGUAGES();
    LANGUAGE lanaguageEsWurdeNichtDE = new LANGUAGE();
    lanaguageEsWurdeNichtDE.setISO639(ISO639.DE);
    lanaguageEsWurdeNichtDE.setTEXT("<html>Es wurde nicht auf <b>'Spiel starten'</b> gedrückt.</html>");

    LANGUAGE lanaguageEsWurdeNichtEN = new LANGUAGE();
    lanaguageEsWurdeNichtEN.setISO639(ISO639.EN);
    lanaguageEsWurdeNichtEN.setTEXT("<html><b>'Start Game'</b> was not pressed.<html>");

    LANGUAGE lanaguageEsWurdeNichtES = new LANGUAGE();
    lanaguageEsWurdeNichtES.setISO639(ISO639.ES);
    lanaguageEsWurdeNichtES.setTEXT("<html><b>'Iniciar juego'</b> no fue presionada.</html>");

    languagesEsWurdeNicht.getLANGUAGE().add(lanaguageEsWurdeNichtDE);
    languagesEsWurdeNicht.getLANGUAGE().add(lanaguageEsWurdeNichtEN);
    languagesEsWurdeNicht.getLANGUAGE().add(lanaguageEsWurdeNichtES);
    commandStringEsWurdeNicht.setLANGUAGES(languagesEsWurdeNicht);

    COMMAND commandStringGameIsRunning = new COMMAND();
    commandStringGameIsRunning.setKEY(KEY.LABEL_SCARED);
    LANGUAGES languagesGameIsRunning = new LANGUAGES();
    LANGUAGE lanaguageGameIsRunningDE = new LANGUAGE();
    lanaguageGameIsRunningDE.setISO639(ISO639.DE);
    lanaguageGameIsRunningDE.setTEXT("Spiel läuft gerade...");

    LANGUAGE lanaguageGameIsRunningEN = new LANGUAGE();
    lanaguageGameIsRunningEN.setISO639(ISO639.EN);
    lanaguageGameIsRunningEN.setTEXT("Game is running...");

    LANGUAGE lanaguageGameIsRunningES = new LANGUAGE();
    lanaguageGameIsRunningES.setISO639(ISO639.ES);
    lanaguageGameIsRunningES.setTEXT("El juego se está ejecutando...");

    languagesGameIsRunning.getLANGUAGE().add(lanaguageGameIsRunningDE);
    languagesGameIsRunning.getLANGUAGE().add(lanaguageGameIsRunningEN);
    languagesGameIsRunning.getLANGUAGE().add(lanaguageGameIsRunningES);

    commandStringGameIsRunning.setLANGUAGES(languagesGameIsRunning);

    COMMAND commandStringUnderConstruction = new COMMAND();
    commandStringUnderConstruction.setKEY(KEY.STRING_UNDER_CONSTRUCTION);
    LANGUAGES languagesStringUnderConstruction = new LANGUAGES();
    LANGUAGE lanaguageUnderConstructionDE = new LANGUAGE();
    lanaguageUnderConstructionDE.setISO639(ISO639.DE);
    lanaguageUnderConstructionDE.setTEXT("befindet sich im Bau");

    LANGUAGE lanaguageUnderConstructionEN = new LANGUAGE();
    lanaguageUnderConstructionEN.setISO639(ISO639.EN);
    lanaguageUnderConstructionEN.setTEXT("Under construction");

    LANGUAGE lanaguageUnderConstructionES = new LANGUAGE();
    lanaguageUnderConstructionES.setISO639(ISO639.ES);
    lanaguageUnderConstructionES.setTEXT("En construcción");

    languagesStringUnderConstruction.getLANGUAGE().add(lanaguageUnderConstructionDE);
    languagesStringUnderConstruction.getLANGUAGE().add(lanaguageUnderConstructionEN);
    languagesStringUnderConstruction.getLANGUAGE().add(lanaguageUnderConstructionES);

    commandStringUnderConstruction.setLANGUAGES(languagesStringUnderConstruction);

    COMMAND commandWeiterspielenOderAbbrechen = new COMMAND();
    commandWeiterspielenOderAbbrechen.setKEY(KEY.STRING_WEITERSPIELEN_ODER_ABBRECHEN);
    LANGUAGES languagesWeiterspielenOderAbbrechen = new LANGUAGES();
    LANGUAGE languageWeiterspielenOderAbbrechenDE = new LANGUAGE();
    languageWeiterspielenOderAbbrechenDE.setISO639(ISO639.DE);
    languageWeiterspielenOderAbbrechenDE.setTEXT("Weiterspielen oder aufgeben?");

    LANGUAGE languageWeiterspielenOderAbbrechenEN = new LANGUAGE();
    languageWeiterspielenOderAbbrechenEN.setISO639(ISO639.EN);
    languageWeiterspielenOderAbbrechenEN.setTEXT("Continue playing or abort?");

    LANGUAGE languageWeiterspielenOderAbbrechenES = new LANGUAGE();
    languageWeiterspielenOderAbbrechenES.setISO639(ISO639.ES);
    languageWeiterspielenOderAbbrechenES.setTEXT("¿Continuar jugando o abortar?");

    languagesWeiterspielenOderAbbrechen.getLANGUAGE().add(languageWeiterspielenOderAbbrechenDE);
    languagesWeiterspielenOderAbbrechen.getLANGUAGE().add(languageWeiterspielenOderAbbrechenEN);
    languagesWeiterspielenOderAbbrechen.getLANGUAGE().add(languageWeiterspielenOderAbbrechenES);

    commandWeiterspielenOderAbbrechen.setLANGUAGES(languagesWeiterspielenOderAbbrechen);

    COMMAND commandStringSpiel = new COMMAND();
    commandStringSpiel.setKEY(KEY.STRING_SPIEL);
    LANGUAGES languagesSpiel = new LANGUAGES();

    LANGUAGE languageSpielDE = new LANGUAGE();
    languageSpielDE.setISO639(ISO639.DE);
    languageSpielDE.setTEXT("Spiel");

    LANGUAGE languageSpielEN = new LANGUAGE();
    languageSpielEN.setISO639(ISO639.EN);
    languageSpielEN.setTEXT("Game");

    LANGUAGE languageSpielES = new LANGUAGE();
    languageSpielES.setISO639(ISO639.ES);
    languageSpielES.setTEXT("Juego");

    languagesSpiel.getLANGUAGE().add(languageSpielDE);
    languagesSpiel.getLANGUAGE().add(languageSpielEN);
    languagesSpiel.getLANGUAGE().add(languageSpielES);

    commandStringSpiel.setLANGUAGES(languagesSpiel);

    COMMAND commandStringFortsetzen = new COMMAND();
    commandStringFortsetzen.setKEY(KEY.STRING_FORTSETZEN);
    LANGUAGES languagesStringFortsetzen = new LANGUAGES();
    LANGUAGE languageStringFortsetzenDE = new LANGUAGE();
    languageStringFortsetzenDE.setISO639(ISO639.DE);
    languageStringFortsetzenDE.setTEXT("Fortsetzen");

    LANGUAGE languageStringFortsetzenEN = new LANGUAGE();
    languageStringFortsetzenEN.setISO639(ISO639.EN);
    languageStringFortsetzenEN.setTEXT("Continue");

    LANGUAGE languageStringFortsetzenES = new LANGUAGE();
    languageStringFortsetzenES.setISO639(ISO639.ES);
    languageStringFortsetzenES.setTEXT("Continuar");

    languagesStringFortsetzen.getLANGUAGE().add(languageStringFortsetzenDE);
    languagesStringFortsetzen.getLANGUAGE().add(languageStringFortsetzenEN);
    languagesStringFortsetzen.getLANGUAGE().add(languageStringFortsetzenES);
    commandStringFortsetzen.setLANGUAGES(languagesStringFortsetzen);

    COMMAND commandSpielAbbrechen = new COMMAND();
    commandSpielAbbrechen.setKEY(KEY.STRING_ABORT);
    LANGUAGES languagesSpielAbbrechen = new LANGUAGES();
    LANGUAGE languageSpielAbbrechenDE = new LANGUAGE();
    languageSpielAbbrechenDE.setISO639(ISO639.DE);
    languageSpielAbbrechenDE.setTEXT("Aufgeben");

    LANGUAGE languageSpielAbbrechenEN = new LANGUAGE();
    languageSpielAbbrechenEN.setISO639(ISO639.EN);
    languageSpielAbbrechenEN.setTEXT("Abort");

    LANGUAGE languageSpielAbbrechenES = new LANGUAGE();
    languageSpielAbbrechenES.setISO639(ISO639.ES);
    languageSpielAbbrechenES.setTEXT("Abortar");

    languagesSpielAbbrechen.getLANGUAGE().add(languageSpielAbbrechenDE);
    languagesSpielAbbrechen.getLANGUAGE().add(languageSpielAbbrechenEN);
    languagesSpielAbbrechen.getLANGUAGE().add(languageSpielAbbrechenES);

    commandSpielAbbrechen.setLANGUAGES(languagesSpielAbbrechen);

    COMMAND commandGameHasStarted = new COMMAND();
    commandGameHasStarted.setKEY(KEY.STRING_AFOOT);
    LANGUAGES languagesGameHasStarted = new LANGUAGES();
    LANGUAGE languageGameHasStartedDE = new LANGUAGE();
    languageGameHasStartedDE.setISO639(ISO639.DE);
    languageGameHasStartedDE.setTEXT("Das Spiel läuft.");

    LANGUAGE languageGameHasStartedEN = new LANGUAGE();
    languageGameHasStartedEN.setISO639(ISO639.EN);
    languageGameHasStartedEN.setTEXT("Game has afoot.");

    LANGUAGE languageGameHasStartedES = new LANGUAGE();
    languageGameHasStartedES.setISO639(ISO639.ES);
    languageGameHasStartedES.setTEXT("El juego está en marcha.");

    languagesGameHasStarted.getLANGUAGE().add(languageGameHasStartedDE);
    languagesGameHasStarted.getLANGUAGE().add(languageGameHasStartedEN);
    languagesGameHasStarted.getLANGUAGE().add(languageGameHasStartedES);

    commandGameHasStarted.setLANGUAGES(languagesGameHasStarted);

    COMMAND commandDerSchwierigkeitsgrad = new COMMAND();
    commandDerSchwierigkeitsgrad.setKEY(KEY.STRING_DER_SCHWIERIGKEITSGRAD);
    LANGUAGES languagesDerSchwierigkeitsgrad = new LANGUAGES();
    LANGUAGE languageDerSchwierigkeitsgradDE = new LANGUAGE();
    languageDerSchwierigkeitsgradDE.setISO639(ISO639.DE);
    languageDerSchwierigkeitsgradDE
        .setTEXT("Der Schwierigkeitsgrad kann während des Spiels nicht geändert werden.");

    LANGUAGE languageDerSchwierigkeitsgradEN = new LANGUAGE();
    languageDerSchwierigkeitsgradEN.setISO639(ISO639.EN);
    languageDerSchwierigkeitsgradEN.setTEXT("The difficulty level cannot be changed during the game.");

    LANGUAGE languageDerSchwierigkeitsgradES = new LANGUAGE();
    languageDerSchwierigkeitsgradES.setISO639(ISO639.ES);
    languageDerSchwierigkeitsgradES.setTEXT("El nivel de dificultad no se puede cambiar durante el juego.");

    languagesDerSchwierigkeitsgrad.getLANGUAGE().add(languageDerSchwierigkeitsgradDE);
    languagesDerSchwierigkeitsgrad.getLANGUAGE().add(languageDerSchwierigkeitsgradEN);
    languagesDerSchwierigkeitsgrad.getLANGUAGE().add(languageDerSchwierigkeitsgradES);

    commandDerSchwierigkeitsgrad.setLANGUAGES(languagesDerSchwierigkeitsgrad);

    COMMAND commandColoringByConditions = new COMMAND();
    commandColoringByConditions.setKEY(KEY.STRING_COLORING_BY_CONDITIONS);
    LANGUAGES languagesColoringByConditions = new LANGUAGES();
    LANGUAGE languageColoringByConditionsDE = new LANGUAGE();
    languageColoringByConditionsDE.setISO639(ISO639.DE);
    languageColoringByConditionsDE.setTEXT("Färbung nach Bedingungen");

    LANGUAGE languageColoringByConditionsEN = new LANGUAGE();
    languageColoringByConditionsEN.setISO639(ISO639.EN);
    languageColoringByConditionsEN.setTEXT("Coloring by Conditions");

    LANGUAGE languageColoringByConditionsES = new LANGUAGE();
    languageColoringByConditionsES.setISO639(ISO639.ES);
    languageColoringByConditionsES.setTEXT("Colorear por condiciones");

    languagesColoringByConditions.getLANGUAGE().add(languageColoringByConditionsDE);
    languagesColoringByConditions.getLANGUAGE().add(languageColoringByConditionsEN);
    languagesColoringByConditions.getLANGUAGE().add(languageColoringByConditionsES);

    commandColoringByConditions.setLANGUAGES(languagesColoringByConditions);

    COMMAND commandColoringConditions = new COMMAND();
    commandColoringConditions.setKEY(KEY.STRING_COLORING_CONDITIONS);
    LANGUAGES languagesColoringConditions = new LANGUAGES();

    LANGUAGE languageColoringConditionsDE = new LANGUAGE();
    languageColoringConditionsDE.setISO639(ISO639.DE);
    languageColoringConditionsDE
        .setTEXT("Die Farbbedingungen können während des Spiels nicht geändert werden.");
    languagesColoringConditions.getLANGUAGE().add(languageColoringConditionsDE);

    LANGUAGE languageColoringConditionsEN = new LANGUAGE();
    languageColoringConditionsEN.setISO639(ISO639.EN);
    languageColoringConditionsEN.setTEXT("The color conditions cannot be changed during the game.");

    languagesColoringConditions.getLANGUAGE().add(languageColoringConditionsEN);

    LANGUAGE languageColoringConditionsES = new LANGUAGE();
    languageColoringConditionsES.setISO639(ISO639.ES);
    languageColoringConditionsES.setTEXT("Las condiciones de color no se pueden cambiar durante el juego.");
    languagesColoringConditions.getLANGUAGE().add(languageColoringConditionsES);

    commandColoringConditions.setLANGUAGES(languagesColoringConditions);

    COMMAND commandLabelDuBistInRunde = new COMMAND();
    commandLabelDuBistInRunde.setKEY(KEY.LABEL_DU_BIST_IN_RUNDE);
    LANGUAGES languagesLabelDuBistInRunde = new LANGUAGES();
    LANGUAGE languageLabelDuBistInRundeDE = new LANGUAGE();
    languageLabelDuBistInRundeDE.setISO639(ISO639.DE);
    languageLabelDuBistInRundeDE.setTEXT("Du bist in Runde ");

    LANGUAGE languageLabelDuBistInRundeEN = new LANGUAGE();
    languageLabelDuBistInRundeEN.setISO639(ISO639.EN);
    languageLabelDuBistInRundeEN.setTEXT("You are in round ");

    LANGUAGE languageLabelDuBistInRundeES = new LANGUAGE();
    languageLabelDuBistInRundeES.setISO639(ISO639.ES);
    languageLabelDuBistInRundeES.setTEXT("Estás en la ronda ");

    languagesLabelDuBistInRunde.getLANGUAGE().add(languageLabelDuBistInRundeDE);
    languagesLabelDuBistInRunde.getLANGUAGE().add(languageLabelDuBistInRundeEN);
    languagesLabelDuBistInRunde.getLANGUAGE().add(languageLabelDuBistInRundeES);

    commandLabelDuBistInRunde.setLANGUAGES(languagesLabelDuBistInRunde);

    COMMAND commandStringDieRundeIst = new COMMAND();
    commandStringDieRundeIst.setKEY(KEY.STRING_DIE_RUNDE_IST);
    LANGUAGES languagesDieRundeIst = new LANGUAGES();
    LANGUAGE languageDieRundeIstDE = new LANGUAGE();
    languageDieRundeIstDE.setISO639(ISO639.DE);
    languageDieRundeIstDE.setTEXT("Die Runde ist noch nicht zu Ende.");

    LANGUAGE languageDieRundeIstEN = new LANGUAGE();
    languageDieRundeIstEN.setISO639(ISO639.EN);
    languageDieRundeIstEN.setTEXT("The round is not over yet.");

    LANGUAGE languageDieRundeIstES = new LANGUAGE();
    languageDieRundeIstES.setISO639(ISO639.ES);
    languageDieRundeIstES.setTEXT("La ronda aún no ha terminado.");

    languagesDieRundeIst.getLANGUAGE().add(languageDieRundeIstDE);
    languagesDieRundeIst.getLANGUAGE().add(languageDieRundeIstEN);
    languagesDieRundeIst.getLANGUAGE().add(languageDieRundeIstES);

    commandStringDieRundeIst.setLANGUAGES(languagesDieRundeIst);

    COMMAND commandStringRunde = new COMMAND();
    commandStringRunde.setKEY(KEY.STRING_RUNDE);
    LANGUAGES languagesStringRunde = new LANGUAGES();
    LANGUAGE languageStringRundeDE = new LANGUAGE();
    languageStringRundeDE.setISO639(ISO639.DE);
    languageStringRundeDE.setTEXT("Runde");

    LANGUAGE languageStringRundeEN = new LANGUAGE();
    languageStringRundeEN.setISO639(ISO639.EN);
    languageStringRundeEN.setTEXT("Round");

    LANGUAGE languageStringRundeES = new LANGUAGE();
    languageStringRundeES.setISO639(ISO639.ES);
    languageStringRundeES.setTEXT("Ronda");

    languagesStringRunde.getLANGUAGE().add(languageStringRundeDE);
    languagesStringRunde.getLANGUAGE().add(languageStringRundeEN);
    languagesStringRunde.getLANGUAGE().add(languageStringRundeES);
    commandStringRunde.setLANGUAGES(languagesStringRunde);

    COMMAND commandLabelDuHastGewonnen = new COMMAND();
    commandLabelDuHastGewonnen.setKEY(KEY.LABEL_DU_HAST_GEWONNEN);
    LANGUAGES languagesLabelDuHastGewonnen = new LANGUAGES();
    LANGUAGE languageLabelDuHastGewonnenDE = new LANGUAGE();
    languageLabelDuHastGewonnenDE.setISO639(ISO639.DE);
    languageLabelDuHastGewonnenDE.setTEXT("<html>Du hast gewonnen. Auf <b>'Neues Spiel'</b> drücken.</html>");

    LANGUAGE languageLabelDuHastGewonnenEN = new LANGUAGE();
    languageLabelDuHastGewonnenEN.setISO639(ISO639.EN);
    languageLabelDuHastGewonnenEN.setTEXT("<html>You have won. Press <b>'New Game'</b>.</html>");

    LANGUAGE languageLabelDuHastGewonnenES = new LANGUAGE();
    languageLabelDuHastGewonnenES.setISO639(ISO639.ES);
    languageLabelDuHastGewonnenES.setTEXT("<html>Has ganado la victoria. Pulsa <b>'Nuevo Juego'</b>.</html>");

    languagesLabelDuHastGewonnen.getLANGUAGE().add(languageLabelDuHastGewonnenDE);
    languagesLabelDuHastGewonnen.getLANGUAGE().add(languageLabelDuHastGewonnenEN);
    languagesLabelDuHastGewonnen.getLANGUAGE().add(languageLabelDuHastGewonnenES);

    commandLabelDuHastGewonnen.setLANGUAGES(languagesLabelDuHastGewonnen);

    COMMAND commandStringWederNoch = new COMMAND();
    commandStringWederNoch.setKEY(KEY.STRING_WEDER_NOCH);
    LANGUAGES languagesStringWederNoch = new LANGUAGES();
    LANGUAGE languageStringWederNochDE = new LANGUAGE();
    languageStringWederNochDE.setISO639(ISO639.DE);
    languageStringWederNochDE.setTEXT("<html>mittel</html>");

    LANGUAGE languageStringWederNochEN = new LANGUAGE();
    languageStringWederNochEN.setISO639(ISO639.EN);
    languageStringWederNochEN.setTEXT("<html>normal</html>");

    LANGUAGE languageStringWederNochES = new LANGUAGE();
    languageStringWederNochES.setISO639(ISO639.ES);
    languageStringWederNochES.setTEXT("<html>normal</html>");

    languagesStringWederNoch.getLANGUAGE().add(languageStringWederNochDE);
    languagesStringWederNoch.getLANGUAGE().add(languageStringWederNochEN);
    languagesStringWederNoch.getLANGUAGE().add(languageStringWederNochES);

    commandStringWederNoch.setLANGUAGES(languagesStringWederNoch);

    COMMAND commandLabelEinfach = new COMMAND();
    commandLabelEinfach.setKEY(KEY.LABEL_EINFACH);
    LANGUAGES languagesLabelEinfach = new LANGUAGES();

    LANGUAGE languageLabelEinfachDE = new LANGUAGE();
    languageLabelEinfachDE.setISO639(ISO639.DE);
    languageLabelEinfachDE.setTEXT("einfach");

    LANGUAGE languageLabelEinfachEN = new LANGUAGE();
    languageLabelEinfachEN.setISO639(ISO639.EN);
    languageLabelEinfachEN.setTEXT("easy");

    LANGUAGE languageLabelEinfachES = new LANGUAGE();
    languageLabelEinfachES.setISO639(ISO639.ES);
    languageLabelEinfachES.setTEXT("fácil");

    languagesLabelEinfach.getLANGUAGE().add(languageLabelEinfachDE);
    languagesLabelEinfach.getLANGUAGE().add(languageLabelEinfachEN);
    languagesLabelEinfach.getLANGUAGE().add(languageLabelEinfachES);

    commandLabelEinfach.setKEY(KEY.LABEL_EINFACH);
    commandLabelEinfach.setLANGUAGES(languagesLabelEinfach);

    COMMAND commandLabelSchwierig = new COMMAND();
    commandLabelSchwierig.setKEY(KEY.LABEL_SCHWIERIG);
    LANGUAGES languagesLabelSchwierig = new LANGUAGES();
    LANGUAGE languageLabelSchwierigDE = new LANGUAGE();
    languageLabelSchwierigDE.setISO639(ISO639.DE);
    languageLabelSchwierigDE.setTEXT("schwierig");

    LANGUAGE languageLabelSchwierigEN = new LANGUAGE();
    languageLabelSchwierigEN.setISO639(ISO639.EN);
    languageLabelSchwierigEN.setTEXT("hard");

    LANGUAGE languageLabelSchwierigES = new LANGUAGE();
    languageLabelSchwierigES.setISO639(ISO639.ES);
    languageLabelSchwierigES.setTEXT("difícil");

    languagesLabelSchwierig.getLANGUAGE().add(languageLabelSchwierigDE);
    languagesLabelSchwierig.getLANGUAGE().add(languageLabelSchwierigEN);
    languagesLabelSchwierig.getLANGUAGE().add(languageLabelSchwierigES);
    commandLabelSchwierig.setLANGUAGES(languagesLabelSchwierig);

    COMMAND commandLabelDuHastVerloren = new COMMAND();
    commandLabelDuHastVerloren.setKEY(KEY.LABEL_DU_HAST_VERLOREN);
    LANGUAGES languagesLabelDuHastVerloren = new LANGUAGES();
    LANGUAGE languageLabelDuHastVerlorenDE = new LANGUAGE();
    languageLabelDuHastVerlorenDE.setISO639(ISO639.DE);
    languageLabelDuHastVerlorenDE.setTEXT("<html>Du hast verloren. Auf <b>'Neues Spiel'</b> drücken.</html>");

    LANGUAGE languageLabelDuHastVerlorenEN = new LANGUAGE();
    languageLabelDuHastVerlorenEN.setISO639(ISO639.EN);
    languageLabelDuHastVerlorenEN.setTEXT("<html>You have lost. Press <b>'New Game'</b>.</html>");

    LANGUAGE languageLabelDuHastVerlorenES = new LANGUAGE();
    languageLabelDuHastVerlorenES.setISO639(ISO639.ES);
    languageLabelDuHastVerlorenES.setTEXT("<html>Has perdido. Pulsa <b>'Nuevo Juego'</b>.</html>");

    languagesLabelDuHastVerloren.getLANGUAGE().add(languageLabelDuHastVerlorenDE);
    languagesLabelDuHastVerloren.getLANGUAGE().add(languageLabelDuHastVerlorenEN);
    languagesLabelDuHastVerloren.getLANGUAGE().add(languageLabelDuHastVerlorenES);
    commandLabelDuHastVerloren.setLANGUAGES(languagesLabelDuHastVerloren);

    COMMAND commandStringChatModule = new COMMAND();
    commandStringChatModule.setKEY(KEY.STRING_CHAT_MODULE);
    LANGUAGES languagesStringChatModule = new LANGUAGES();
    LANGUAGE languageStringChatModuleDE = new LANGUAGE();
    languageStringChatModuleDE.setISO639(ISO639.DE);
    languageStringChatModuleDE.setTEXT("Chatmodul");

    LANGUAGE languageStringChatModuleEN = new LANGUAGE();
    languageStringChatModuleEN.setISO639(ISO639.EN);
    languageStringChatModuleEN.setTEXT("Chat module");

    LANGUAGE languageStringChatModuleES = new LANGUAGE();
    languageStringChatModuleES.setISO639(ISO639.ES);
    languageStringChatModuleES.setTEXT("Módulo de chat");

    languagesStringChatModule.getLANGUAGE().add(languageStringChatModuleDE);
    languagesStringChatModule.getLANGUAGE().add(languageStringChatModuleEN);
    languagesStringChatModule.getLANGUAGE().add(languageStringChatModuleES);
    commandStringChatModule.setLANGUAGES(languagesStringChatModule);

    COMMAND commandLabelChatStunden = new COMMAND();
    commandLabelChatStunden.setKEY(KEY.LABEL_CHAT_STUNDEN);
    LANGUAGES languagesLabelChatStunden = new LANGUAGES();
    LANGUAGE languageLabelChatStundenDE = new LANGUAGE();
    languageLabelChatStundenDE.setISO639(ISO639.DE);
    languageLabelChatStundenDE.setTEXT("Nach wie vielen Stunden wird eine Nachricht spätestens gelöscht?");

    LANGUAGE languageLabelChatStundenEN = new LANGUAGE();
    languageLabelChatStundenEN.setISO639(ISO639.EN);
    languageLabelChatStundenEN.setTEXT("After how many hours at the latest will a message be deleted?");

    LANGUAGE languageLabelChatStundenES = new LANGUAGE();
    languageLabelChatStundenES.setISO639(ISO639.ES);
    languageLabelChatStundenES.setTEXT("¿Después de cuántas horas como máximo se borrará un mensaje?");

    languagesLabelChatStunden.getLANGUAGE().add(languageLabelChatStundenDE);
    languagesLabelChatStunden.getLANGUAGE().add(languageLabelChatStundenEN);
    languagesLabelChatStunden.getLANGUAGE().add(languageLabelChatStundenES);
    commandLabelChatStunden.setLANGUAGES(languagesLabelChatStunden);

    COMMAND commandButtonReport = new COMMAND();
    commandButtonReport.setKEY(KEY.BUTTON_REPORT);
    LANGUAGES languagesButtonReport = new LANGUAGES();
    LANGUAGE languageButtonReportDE = new LANGUAGE();
    languageButtonReportDE.setISO639(ISO639.DE);
    languageButtonReportDE.setTEXT("Bericht");

    LANGUAGE languageButtonReportEN = new LANGUAGE();
    languageButtonReportEN.setISO639(ISO639.EN);
    languageButtonReportEN.setTEXT("Report");

    LANGUAGE languageButtonReportES = new LANGUAGE();
    languageButtonReportES.setISO639(ISO639.ES);
    languageButtonReportES.setTEXT("Informe");

    languagesButtonReport.getLANGUAGE().add(languageButtonReportDE);
    languagesButtonReport.getLANGUAGE().add(languageButtonReportEN);
    languagesButtonReport.getLANGUAGE().add(languageButtonReportES);
    commandButtonReport.setLANGUAGES(languagesButtonReport);

    COMMAND commandIstInEinerKonferenz = new COMMAND();
    commandIstInEinerKonferenz.setKEY(KEY.STRING_IST_IN_EINER_KONFERENZ);
    LANGUAGES languagesIstInEinerKonferenz = new LANGUAGES();

    LANGUAGE languageIstInEinerKonferenzDE = new LANGUAGE();
    languageIstInEinerKonferenzDE.setISO639(ISO639.DE);
    languageIstInEinerKonferenzDE.setTEXT(" ist in einer Konferenz.");

    LANGUAGE languageIstInEinerKonferenzEN = new LANGUAGE();
    languageIstInEinerKonferenzEN.setISO639(ISO639.EN);
    languageIstInEinerKonferenzEN.setTEXT(" is in a conference.");

    LANGUAGE languageIstInEinerKonferenzES = new LANGUAGE();
    languageIstInEinerKonferenzES.setISO639(ISO639.ES);
    languageIstInEinerKonferenzES.setTEXT(" está en una conferencia.");

    languagesIstInEinerKonferenz.getLANGUAGE().add(languageIstInEinerKonferenzDE);
    languagesIstInEinerKonferenz.getLANGUAGE().add(languageIstInEinerKonferenzEN);
    languagesIstInEinerKonferenz.getLANGUAGE().add(languageIstInEinerKonferenzES);

    commandIstInEinerKonferenz.setLANGUAGES(languagesIstInEinerKonferenz);

    COMMAND commandAufzeichnen = new COMMAND();
    commandAufzeichnen.setKEY(KEY.BUTTON_AUFZEICHNEN);
    LANGUAGES languagesButtonAufzeichnen = new LANGUAGES();
    LANGUAGE languageButtonAufzeichnenDE = new LANGUAGE();
    languageButtonAufzeichnenDE.setISO639(ISO639.DE);
    languageButtonAufzeichnenDE.setTEXT("Stummschalten");

    LANGUAGE languageButtonAufzeichnenEN = new LANGUAGE();
    languageButtonAufzeichnenEN.setISO639(ISO639.EN);
    languageButtonAufzeichnenEN.setTEXT("Mute");

    LANGUAGE languageButtonAufzeichnenES = new LANGUAGE();
    languageButtonAufzeichnenES.setISO639(ISO639.ES);
    languageButtonAufzeichnenES.setTEXT("Silenciar");

    languagesButtonAufzeichnen.getLANGUAGE().add(languageButtonAufzeichnenDE);
    languagesButtonAufzeichnen.getLANGUAGE().add(languageButtonAufzeichnenEN);
    languagesButtonAufzeichnen.getLANGUAGE().add(languageButtonAufzeichnenES);

    commandAufzeichnen.setLANGUAGES(languagesButtonAufzeichnen);

    COMMAND commandIstNichtVorhanden = new COMMAND();
    commandIstNichtVorhanden.setKEY(KEY.STRING_IST_NICHT_VORHANDEN);
    LANGUAGES languagesIstNichtVorhanden = new LANGUAGES();
    LANGUAGE languageIstNichtVorhandenDE = new LANGUAGE();
    languageIstNichtVorhandenDE.setISO639(ISO639.DE);
    languageIstNichtVorhandenDE.setTEXT("ist nicht vorhanden.");

    LANGUAGE languageIstNichtVorhandenEN = new LANGUAGE();
    languageIstNichtVorhandenEN.setISO639(ISO639.EN);
    languageIstNichtVorhandenEN.setTEXT("does not exist.");

    LANGUAGE languageIstNichtVorhandenES = new LANGUAGE();
    languageIstNichtVorhandenES.setISO639(ISO639.ES);
    languageIstNichtVorhandenES.setTEXT("no existe.");

    languagesIstNichtVorhanden.getLANGUAGE().add(languageIstNichtVorhandenDE);
    languagesIstNichtVorhanden.getLANGUAGE().add(languageIstNichtVorhandenEN);
    languagesIstNichtVorhanden.getLANGUAGE().add(languageIstNichtVorhandenES);
    commandIstNichtVorhanden.setLANGUAGES(languagesIstNichtVorhanden);

    COMMAND commandVerzeichnisname = new COMMAND();
    commandVerzeichnisname.setKEY(KEY.STRING_VERZEICHNISNAME);
    LANGUAGES languagesVerzeichnisname = new LANGUAGES();
    LANGUAGE languageVerzeichnisnameDE = new LANGUAGE();
    languageVerzeichnisnameDE.setISO639(ISO639.DE);
    languageVerzeichnisnameDE.setTEXT("Verzeichnisname");
    languageVerzeichnisnameDE.setSHORTCUT(VIRTUALKEY.VK_V);

    LANGUAGE languageVerzeichnisnameEN = new LANGUAGE();
    languageVerzeichnisnameEN.setISO639(ISO639.EN);
    languageVerzeichnisnameEN.setTEXT("Directory");
    languageVerzeichnisnameEN.setSHORTCUT(VIRTUALKEY.VK_D);

    LANGUAGE languageVerzeichnisnameES = new LANGUAGE();
    languageVerzeichnisnameES.setISO639(ISO639.ES);
    languageVerzeichnisnameES.setTEXT("Nombre de directorio");
    languageVerzeichnisnameES.setSHORTCUT(VIRTUALKEY.VK_N);

    languagesVerzeichnisname.getLANGUAGE().add(languageVerzeichnisnameDE);
    languagesVerzeichnisname.getLANGUAGE().add(languageVerzeichnisnameEN);
    languagesVerzeichnisname.getLANGUAGE().add(languageVerzeichnisnameES);
    commandVerzeichnisname.setLANGUAGES(languagesVerzeichnisname);

    COMMAND commandSerververbindung = new COMMAND();
    commandSerververbindung.setKEY(KEY.STRING_SERVERVERBINDUNG);
    LANGUAGES languagesSerververbindung = new LANGUAGES();
    LANGUAGE languageSerververbindungDE = new LANGUAGE();
    languageSerververbindungDE.setISO639(ISO639.DE);
    languageSerververbindungDE.setTEXT("Die Serverbindung ist unterbrochen. Du musst dich erneut anmelden.");

    LANGUAGE languageSerververbindungEN = new LANGUAGE();
    languageSerververbindungEN.setISO639(ISO639.EN);
    languageSerververbindungEN.setTEXT("The server connection is broken. You must log in again.");

    LANGUAGE languageSerververbindungES = new LANGUAGE();
    languageSerververbindungES.setISO639(ISO639.ES);
    languageSerververbindungES
        .setTEXT("La conexión con el servidor está interrumpida. Tienes que volver a conectarte.");

    languagesSerververbindung.getLANGUAGE().add(languageSerververbindungDE);
    languagesSerververbindung.getLANGUAGE().add(languageSerververbindungEN);
    languagesSerververbindung.getLANGUAGE().add(languageSerververbindungES);
    commandSerververbindung.setLANGUAGES(languagesSerververbindung);

    COMMAND commandTeilen = new COMMAND();
    commandTeilen.setKEY(KEY.BUTTON_SHARE);
    LANGUAGES languagesTeilen = new LANGUAGES();
    LANGUAGE languageTeilenDE = new LANGUAGE();
    languageTeilenDE.setISO639(ISO639.DE);
    languageTeilenDE.setTEXT("Teilen");

    LANGUAGE languageTeilenEN = new LANGUAGE();
    languageTeilenEN.setISO639(ISO639.EN);
    languageTeilenEN.setTEXT("Share");

    LANGUAGE languageTeilenES = new LANGUAGE();
    languageTeilenES.setISO639(ISO639.ES);
    languageTeilenES.setTEXT("Compartir");

    languagesTeilen.getLANGUAGE().add(languageTeilenDE);
    languagesTeilen.getLANGUAGE().add(languageTeilenEN);
    languagesTeilen.getLANGUAGE().add(languageTeilenES);

    commandTeilen.setLANGUAGES(languagesTeilen);

    COMMAND commandSeelen = new COMMAND();
    commandSeelen.setKEY(KEY.STRING_EINSAME_SEELEN);
    LANGUAGES languagesStringSeelen = new LANGUAGES();
    LANGUAGE languageSeelenDE = new LANGUAGE();
    languageSeelenDE.setISO639(ISO639.DE);
    languageSeelenDE.setTEXT("Ich kann nicht mit mir selbst plaudern!");

    LANGUAGE languageSeelenEN = new LANGUAGE();
    languageSeelenEN.setISO639(ISO639.EN);
    languageSeelenEN.setTEXT("I can't even chat with myself!");

    LANGUAGE languageSeelenES = new LANGUAGE();
    languageSeelenES.setISO639(ISO639.ES);
    languageSeelenES.setTEXT("¡No puedo ni chatear conmigo mismo!");

    languagesStringSeelen.getLANGUAGE().add(languageSeelenDE);
    languagesStringSeelen.getLANGUAGE().add(languageSeelenEN);
    languagesStringSeelen.getLANGUAGE().add(languageSeelenES);

    commandSeelen.setLANGUAGES(languagesStringSeelen);

    COMMAND commandChatIsRunning = new COMMAND();
    commandChatIsRunning.setKEY(KEY.SERVER_DER_CHAT_LAEUFT_BEREITS);
    LANGUAGES languagesChatIsRunning = new LANGUAGES();
    LANGUAGE languageChatIsRunningDE = new LANGUAGE();
    languageChatIsRunningDE.setISO639(ISO639.DE);
    languageChatIsRunningDE.setTEXT("Der Chat läuft bereits...");

    LANGUAGE languageChatIsRunningEN = new LANGUAGE();
    languageChatIsRunningEN.setISO639(ISO639.EN);
    languageChatIsRunningEN.setTEXT("The chat is already running...");

    LANGUAGE languageChatIsRunningES = new LANGUAGE();
    languageChatIsRunningES.setISO639(ISO639.ES);
    languageChatIsRunningES.setTEXT("El chat ya está en marcha...");

    languagesChatIsRunning.getLANGUAGE().add(languageChatIsRunningDE);
    languagesChatIsRunning.getLANGUAGE().add(languageChatIsRunningEN);
    languagesChatIsRunning.getLANGUAGE().add(languageChatIsRunningES);

    commandChatIsRunning.setLANGUAGES(languagesChatIsRunning);

    COMMAND commandStringHatKeineBerechtigung = new COMMAND();
    commandStringHatKeineBerechtigung.setKEY(KEY.STRING_HAT_KEINE_BERECHTIGUNG);
    LANGUAGES languagesHatKeineBerechtigung = new LANGUAGES();

    LANGUAGE languagesHatKeineBerechtigungDE = new LANGUAGE();
    languagesHatKeineBerechtigungDE.setISO639(ISO639.DE);
    languagesHatKeineBerechtigungDE.setTEXT(" hat keine Berechtigung.");

    LANGUAGE languagesHatKeineBerechtigungEN = new LANGUAGE();
    languagesHatKeineBerechtigungEN.setISO639(ISO639.EN);
    languagesHatKeineBerechtigungEN.setTEXT(" has no authorization.");

    LANGUAGE languagesHatKeineBerechtigungES = new LANGUAGE();
    languagesHatKeineBerechtigungES.setISO639(ISO639.ES);
    languagesHatKeineBerechtigungES.setTEXT(" no tiene autorización.");

    languagesHatKeineBerechtigung.getLANGUAGE().add(languagesHatKeineBerechtigungDE);
    languagesHatKeineBerechtigung.getLANGUAGE().add(languagesHatKeineBerechtigungEN);
    languagesHatKeineBerechtigung.getLANGUAGE().add(languagesHatKeineBerechtigungES);

    commandStringHatKeineBerechtigung.setLANGUAGES(languagesHatKeineBerechtigung);

    COMMAND commandChatExhausted = new COMMAND();
    commandChatExhausted.setKEY(KEY.SERVER_CHAT_EXHAUSTED);
    LANGUAGES languagesChatExhausted = new LANGUAGES();
    LANGUAGE languageChatExhaustedDE = new LANGUAGE();
    languageChatExhaustedDE.setISO639(ISO639.DE);
    languageChatExhaustedDE.setTEXT(" kann keine weiteren Chats entgegennehmen.");

    LANGUAGE languageChatExhaustedEN = new LANGUAGE();
    languageChatExhaustedEN.setISO639(ISO639.EN);
    languageChatExhaustedEN.setTEXT(" cannot accept any more chats.");

    LANGUAGE languageChatExhaustedES = new LANGUAGE();
    languageChatExhaustedES.setISO639(ISO639.ES);
    languageChatExhaustedES.setTEXT(" no puede aceptar más chats.");

    languagesChatExhausted.getLANGUAGE().add(languageChatExhaustedDE);
    languagesChatExhausted.getLANGUAGE().add(languageChatExhaustedEN);
    languagesChatExhausted.getLANGUAGE().add(languageChatExhaustedES);

    commandChatExhausted.setLANGUAGES(languagesChatExhausted);

    COMMAND commandZitrone = new COMMAND();
    commandZitrone.setKEY(KEY.ZITRONE);
    LANGUAGES languagesZitrone = new LANGUAGES();
    LANGUAGE languageZitroneDE = new LANGUAGE();
    languageZitroneDE.setISO639(ISO639.DE);
    languageZitroneDE.setTEXT("Zitrone");

    LANGUAGE languageZitroneEN = new LANGUAGE();
    languageZitroneEN.setISO639(ISO639.EN);
    languageZitroneEN.setTEXT("Lemon");

    LANGUAGE languageZitroneES = new LANGUAGE();
    languageZitroneES.setISO639(ISO639.ES);
    languageZitroneES.setTEXT("Limón");

    languagesZitrone.getLANGUAGE().add(languageZitroneDE);
    languagesZitrone.getLANGUAGE().add(languageZitroneEN);
    languagesZitrone.getLANGUAGE().add(languageZitroneES);

    commandZitrone.setLANGUAGES(languagesZitrone);

    COMMAND commandServerVideoRunning = new COMMAND();
    commandServerVideoRunning.setKEY(KEY.SERVER_VIDEO_RUNNING);
    LANGUAGES languagesServerVideoRunning = new LANGUAGES();
    LANGUAGE languageServerVideoRunningDE = new LANGUAGE();
    languageServerVideoRunningDE.setISO639(ISO639.DE);
    languageServerVideoRunningDE.setTEXT("XXX teilt seinen Bildschirm mit anderen.");

    LANGUAGE languageServerVideoRunningEN = new LANGUAGE();
    languageServerVideoRunningEN.setISO639(ISO639.EN);
    languageServerVideoRunningEN.setTEXT("XXX is sharing its screen with others.");

    LANGUAGE languageServerVideoRunningES = new LANGUAGE();
    languageServerVideoRunningES.setISO639(ISO639.EN);
    languageServerVideoRunningES.setTEXT("XXX está compartiendo su pantalla con otros.");

    languagesServerVideoRunning.getLANGUAGE().add(languageServerVideoRunningDE);
    languagesServerVideoRunning.getLANGUAGE().add(languageServerVideoRunningEN);
    languagesServerVideoRunning.getLANGUAGE().add(languageServerVideoRunningES);

    commandServerVideoRunning.setLANGUAGES(languagesServerVideoRunning);

    COMMAND commandServerDrittePerson = new COMMAND();
    commandServerDrittePerson.setKEY(KEY.SERVER_DRITTE_PERSON);
    LANGUAGES languagesDrittePerson = new LANGUAGES();

    LANGUAGE languageDrittePersonDE = new LANGUAGE();
    languageDrittePersonDE.setISO639(ISO639.DE);
    languageDrittePersonDE.setTEXT("Du kannst nicht teilen, wenn ein anderer teilt.");

    // Du kannst nicht teilen, wenn ein anderer teilt

    LANGUAGE languageDrittePersonEN = new LANGUAGE();
    languageDrittePersonEN.setISO639(ISO639.EN);
    languageDrittePersonEN.setTEXT("You can't share if someone else is sharing.");

    LANGUAGE languageDrittePersonES = new LANGUAGE();
    languageDrittePersonES.setISO639(ISO639.ES);
    languageDrittePersonES.setTEXT("No puedes compartir si otro comparte.");

    languagesDrittePerson.getLANGUAGE().add(languageDrittePersonDE);
    languagesDrittePerson.getLANGUAGE().add(languageDrittePersonEN);
    languagesDrittePerson.getLANGUAGE().add(languageDrittePersonES);

    commandServerDrittePerson.setLANGUAGES(languagesDrittePerson);

    COMMAND commandServerForwardingImage = new COMMAND();
    commandServerForwardingImage.setKEY(KEY.SERVER_FORWARDING_IMAGE);
    LANGUAGES languagesForwardingImage = new LANGUAGES();

    LANGUAGE languageForwardingImageDE = new LANGUAGE();
    languageForwardingImageDE.setISO639(ISO639.DE);
    languageForwardingImageDE.setTEXT("Bilder weiterleiten an Dritte ist nicht erlaubt.");

    LANGUAGE languageForwardingImageEN = new LANGUAGE();
    languageForwardingImageEN.setISO639(ISO639.EN);
    languageForwardingImageEN.setTEXT("Forwarding images to third parties is not permitted.");

    LANGUAGE languageForwardingImageES = new LANGUAGE();
    languageForwardingImageES.setISO639(ISO639.ES);
    languageForwardingImageES.setTEXT("No está permitido reenviar imágenes a terceros.");

    languagesForwardingImage.getLANGUAGE().add(languageForwardingImageDE);
    languagesForwardingImage.getLANGUAGE().add(languageForwardingImageEN);
    languagesForwardingImage.getLANGUAGE().add(languageForwardingImageES);

    commandServerForwardingImage.setLANGUAGES(languagesForwardingImage);

    COMMAND commandFrameVideokonferenz = new COMMAND();
    commandFrameVideokonferenz.setKEY(KEY.FRAME_VIDEOKONFERNEZ);
    LANGUAGES languagesFrameVideokonferenz = new LANGUAGES();
    LANGUAGE languageFrameVideokonferenzDE = new LANGUAGE();
    languageFrameVideokonferenzDE.setISO639(ISO639.DE);
    languageFrameVideokonferenzDE.setTEXT("Geteilt vonXXX");

    LANGUAGE languageFrameVideokonferenzEN = new LANGUAGE();
    languageFrameVideokonferenzEN.setISO639(ISO639.EN);
    languageFrameVideokonferenzEN.setTEXT("Shared byXXX");

    LANGUAGE languageFrameVideokonferenzES = new LANGUAGE();
    languageFrameVideokonferenzES.setISO639(ISO639.ES);
    languageFrameVideokonferenzES.setTEXT("Compartido porXXX");

    languagesFrameVideokonferenz.getLANGUAGE().add(languageFrameVideokonferenzDE);
    languagesFrameVideokonferenz.getLANGUAGE().add(languageFrameVideokonferenzEN);
    languagesFrameVideokonferenz.getLANGUAGE().add(languageFrameVideokonferenzES);

    commandFrameVideokonferenz.setLANGUAGES(languagesFrameVideokonferenz);

    COMMAND commandStringEinzigeKonferenzteilnehmer = new COMMAND();
    commandStringEinzigeKonferenzteilnehmer.setKEY(KEY.STRING_EINZIGE_KONFERENZTEILNEHMER);
    LANGUAGES languagesEinzigeKonferenzteilnehmer = new LANGUAGES();
    LANGUAGE languageEinzigeKonferenzteilnehmerDE = new LANGUAGE();
    languageEinzigeKonferenzteilnehmerDE.setISO639(ISO639.DE);
    languageEinzigeKonferenzteilnehmerDE.setTEXT("Du bist der einzige Konferenzteilnehmer.");

    LANGUAGE languageEinzigeKonferenzteilnehmerEN = new LANGUAGE();
    languageEinzigeKonferenzteilnehmerEN.setISO639(ISO639.EN);
    languageEinzigeKonferenzteilnehmerEN.setTEXT("You are the only participant in the conference.");

    LANGUAGE languageEinzigeKonferenzteilnehmerES = new LANGUAGE();
    languageEinzigeKonferenzteilnehmerES.setISO639(ISO639.ES);
    languageEinzigeKonferenzteilnehmerES.setTEXT("Estás el único participante en la conferencia.");

    languagesEinzigeKonferenzteilnehmer.getLANGUAGE().add(languageEinzigeKonferenzteilnehmerDE);
    languagesEinzigeKonferenzteilnehmer.getLANGUAGE().add(languageEinzigeKonferenzteilnehmerEN);
    languagesEinzigeKonferenzteilnehmer.getLANGUAGE().add(languageEinzigeKonferenzteilnehmerES);

    commandStringEinzigeKonferenzteilnehmer.setLANGUAGES(languagesEinzigeKonferenzteilnehmer);

    COMMAND commandNichtAnwesendInKonferenz = new COMMAND();
    commandNichtAnwesendInKonferenz.setKEY(KEY.STRING_NICHT_ANWESEND_IN_KONFERENZ);
    LANGUAGES languagesNichtAnwesendInKonferenz = new LANGUAGES();
    LANGUAGE languageNichtAnwesendInKonferenzDE = new LANGUAGE();
    languageNichtAnwesendInKonferenzDE.setISO639(ISO639.DE);
    languageNichtAnwesendInKonferenzDE.setTEXT("Du bist nicht anwesend in der Konferenz.");

    LANGUAGE languageNichtAnwesendInKonferenzEN = new LANGUAGE();
    languageNichtAnwesendInKonferenzEN.setISO639(ISO639.EN);
    languageNichtAnwesendInKonferenzEN.setTEXT("You are not present at the conference.");

    LANGUAGE languageNichtAnwesendInKonferenzES = new LANGUAGE();
    languageNichtAnwesendInKonferenzES.setISO639(ISO639.ES);
    languageNichtAnwesendInKonferenzES.setTEXT("No estás presente en la conferencia.");

    languagesNichtAnwesendInKonferenz.getLANGUAGE().add(languageNichtAnwesendInKonferenzDE);
    languagesNichtAnwesendInKonferenz.getLANGUAGE().add(languageNichtAnwesendInKonferenzEN);
    languagesNichtAnwesendInKonferenz.getLANGUAGE().add(languageNichtAnwesendInKonferenzES);

    commandNichtAnwesendInKonferenz.setLANGUAGES(languagesNichtAnwesendInKonferenz);

    COMMAND commandCloseAllRooms = new COMMAND();
    commandCloseAllRooms.setKEY(KEY.BUTTON_CLOSE_ALL_ROOMS);
    LANGUAGES languagesButtonCloseAllRooms = new LANGUAGES();

    LANGUAGE languageButtonCloseAllRoomsDE = new LANGUAGE();
    languageButtonCloseAllRoomsDE.setISO639(ISO639.DE);
    languageButtonCloseAllRoomsDE.setTEXT("Alle Räume schließen");

    LANGUAGE languageButtonCloseAllRoomsEN = new LANGUAGE();
    languageButtonCloseAllRoomsEN.setISO639(ISO639.EN);
    languageButtonCloseAllRoomsEN.setTEXT("Close all rooms");

    LANGUAGE languageButtonCloseAllRoomsES = new LANGUAGE();
    languageButtonCloseAllRoomsES.setISO639(ISO639.ES);
    languageButtonCloseAllRoomsES.setTEXT("Cerrar todas las salas");

    languagesButtonCloseAllRooms.getLANGUAGE().add(languageButtonCloseAllRoomsDE);
    languagesButtonCloseAllRooms.getLANGUAGE().add(languageButtonCloseAllRoomsEN);
    languagesButtonCloseAllRooms.getLANGUAGE().add(languageButtonCloseAllRoomsES);

    commandCloseAllRooms.setLANGUAGES(languagesButtonCloseAllRooms);

    COMMAND commandAndererNickname = new COMMAND();
    commandAndererNickname.setKEY(KEY.SERVER_ANDERER_NICKNAME);
    LANGUAGES languagesAndererNickname = new LANGUAGES();
    LANGUAGE languageAndererNameDE = new LANGUAGE();
    languageAndererNameDE.setISO639(ISO639.DE);
    languageAndererNameDE.setTEXT("Der Nickname ist schon vergeben.");

    LANGUAGE languageAndererNameEN = new LANGUAGE();
    languageAndererNameEN.setISO639(ISO639.EN);
    languageAndererNameEN.setTEXT("The nickname is already taken.");

    LANGUAGE languageAndererNameES = new LANGUAGE();
    languageAndererNameES.setISO639(ISO639.ES);
    languageAndererNameES.setTEXT("El alias ya está en uso.");

    languagesAndererNickname.getLANGUAGE().add(languageAndererNameDE);
    languagesAndererNickname.getLANGUAGE().add(languageAndererNameEN);
    languagesAndererNickname.getLANGUAGE().add(languageAndererNameES);

    commandAndererNickname.setLANGUAGES(languagesAndererNickname);

    COMMAND commandServerPasswortZuKurz = new COMMAND();
    commandServerPasswortZuKurz.setKEY(KEY.SERVER_PASSWORT_ZU_KURZ);
    LANGUAGES languagesServerPasswortZuKurz = new LANGUAGES();
    LANGUAGE languagePasswortZuKurzDE = new LANGUAGE();
    languagePasswortZuKurzDE.setISO639(ISO639.DE);
    languagePasswortZuKurzDE.setTEXT("Das Passwort muss mindestens XXX Zeichen lang sein.");

    LANGUAGE languagePasswortZuKurzEN = new LANGUAGE();
    languagePasswortZuKurzEN.setISO639(ISO639.EN);
    languagePasswortZuKurzEN.setTEXT("The password must be at least XXX characters long.");

    LANGUAGE languagePasswortZuKurzES = new LANGUAGE();
    languagePasswortZuKurzES.setISO639(ISO639.ES);
    languagePasswortZuKurzES.setTEXT("La contraseña debe tener al menos XXX caracteres.");

    languagesServerPasswortZuKurz.getLANGUAGE().add(languagePasswortZuKurzDE);
    languagesServerPasswortZuKurz.getLANGUAGE().add(languagePasswortZuKurzEN);
    languagesServerPasswortZuKurz.getLANGUAGE().add(languagePasswortZuKurzES);
    commandServerPasswortZuKurz.setLANGUAGES(languagesServerPasswortZuKurz);

    COMMAND commandServerUnerlaubteZeichen = new COMMAND();
    commandServerUnerlaubteZeichen.setKEY(KEY.SERVER_UNERLAUBTE_ZEICHEN);
    LANGUAGES languagesUnerlaubteZeichen = new LANGUAGES();
    LANGUAGE languageServerUnerlaubteZeichenDE = new LANGUAGE();
    languageServerUnerlaubteZeichenDE.setISO639(ISO639.DE);
    languageServerUnerlaubteZeichenDE.setTEXT("Der Nickname enthält unerlaubte Zeichen.");

    LANGUAGE languageServerUnerlaubteZeichenEN = new LANGUAGE();
    languageServerUnerlaubteZeichenEN.setISO639(ISO639.EN);
    languageServerUnerlaubteZeichenEN.setTEXT("The nickname contains invalid characters.");

    LANGUAGE languageServerUnerlaubteZeichenES = new LANGUAGE();
    languageServerUnerlaubteZeichenES.setISO639(ISO639.ES);
    languageServerUnerlaubteZeichenES.setTEXT("El alias contiene caracteres no permitidos.");

    languagesUnerlaubteZeichen.getLANGUAGE().add(languageServerUnerlaubteZeichenDE);
    languagesUnerlaubteZeichen.getLANGUAGE().add(languageServerUnerlaubteZeichenEN);
    languagesUnerlaubteZeichen.getLANGUAGE().add(languageServerUnerlaubteZeichenES);

    commandServerUnerlaubteZeichen.setLANGUAGES(languagesUnerlaubteZeichen);

    COMMAND commandServerVollmitgliedEinschreiben = new COMMAND();
    commandServerVollmitgliedEinschreiben.setKEY(KEY.SERVER_VOLLMITGLIED_EINSCHREIBEN);
    LANGUAGES languagesServerVollmitgliedEinschreiben = new LANGUAGES();
    LANGUAGE languageVollmitgliedEinschreibenDE = new LANGUAGE();
    languageVollmitgliedEinschreibenDE.setISO639(ISO639.DE);
    languageVollmitgliedEinschreibenDE
        .setTEXT("Du bist Vollmitglied und kannst dich nicht erneut einschreiben.");

    LANGUAGE languageVollmitgliedEinschreibenEN = new LANGUAGE();
    languageVollmitgliedEinschreibenEN.setISO639(ISO639.EN);
    languageVollmitgliedEinschreibenEN.setTEXT("You are a full member and cannot register again.");

    LANGUAGE languageVollmitgliedEinschreibenES = new LANGUAGE();
    languageVollmitgliedEinschreibenES.setISO639(ISO639.ES);
    languageVollmitgliedEinschreibenES.setTEXT("Eres miembro completo y no puedes volver a registrarte.");

    languagesServerVollmitgliedEinschreiben.getLANGUAGE().add(languageVollmitgliedEinschreibenDE);
    languagesServerVollmitgliedEinschreiben.getLANGUAGE().add(languageVollmitgliedEinschreibenEN);
    languagesServerVollmitgliedEinschreiben.getLANGUAGE().add(languageVollmitgliedEinschreibenES);

    commandServerVollmitgliedEinschreiben.setLANGUAGES(languagesServerVollmitgliedEinschreiben);

    COMMAND commandKeinRegistrierterAnwender = new COMMAND();
    commandKeinRegistrierterAnwender.setKEY(KEY.STRING_KEIN_REGISTRIERTER_ANWENDER);
    LANGUAGES languagesKeinRegistrierterAnwender = new LANGUAGES();
    LANGUAGE languageKeinRegistrierterAnwenderDE = new LANGUAGE();
    languageKeinRegistrierterAnwenderDE.setISO639(ISO639.DE);
    languageKeinRegistrierterAnwenderDE.setTEXT("Du bist kein registrierter Anwender.");

    LANGUAGE languageKeinRegistrierterAnwenderEN = new LANGUAGE();
    languageKeinRegistrierterAnwenderEN.setISO639(ISO639.EN);
    languageKeinRegistrierterAnwenderEN.setTEXT("It seems you are not a registered user.");

    LANGUAGE languageKeinRegistrierterAnwenderES = new LANGUAGE();
    languageKeinRegistrierterAnwenderES.setISO639(ISO639.ES);
    languageKeinRegistrierterAnwenderES.setTEXT("No eres un usuario registrado.");

    languagesKeinRegistrierterAnwender.getLANGUAGE().add(languageKeinRegistrierterAnwenderDE);
    languagesKeinRegistrierterAnwender.getLANGUAGE().add(languageKeinRegistrierterAnwenderEN);
    languagesKeinRegistrierterAnwender.getLANGUAGE().add(languageKeinRegistrierterAnwenderES);

    commandKeinRegistrierterAnwender.setLANGUAGES(languagesKeinRegistrierterAnwender);

    COMMAND commandEncryptingProperly = new COMMAND();
    commandEncryptingProperly.setKEY(KEY.STRING_NOT_ENCRYPTING_PROPERLY);
    LANGUAGES languagesNotEncryptingProperly = new LANGUAGES();

    LANGUAGE languageNotEncryptingProperlyDE = new LANGUAGE();
    languageNotEncryptingProperlyDE.setISO639(ISO639.DE);
    languageNotEncryptingProperlyDE.setTEXT("Der Client verschlüsselt die Daten nicht korrekt.");

    LANGUAGE languageNotEncryptingProperlyEN = new LANGUAGE();
    languageNotEncryptingProperlyEN.setISO639(ISO639.EN);
    languageNotEncryptingProperlyEN.setTEXT("The client is not encrypting the data properly.");

    LANGUAGE languageNotEncryptingProperlyES = new LANGUAGE();
    languageNotEncryptingProperlyES.setISO639(ISO639.ES);
    languageNotEncryptingProperlyES.setTEXT("El cliente no cifra los datos correctamente.");

    languagesNotEncryptingProperly.getLANGUAGE().add(languageNotEncryptingProperlyDE);
    languagesNotEncryptingProperly.getLANGUAGE().add(languageNotEncryptingProperlyEN);
    languagesNotEncryptingProperly.getLANGUAGE().add(languageNotEncryptingProperlyES);

    commandEncryptingProperly.setLANGUAGES(languagesNotEncryptingProperly);

    COMMAND commandZutrittsberechtigung = new COMMAND();
    commandZutrittsberechtigung.setKEY(KEY.SERVER_ZUTRITTSBERECHTIGUNG);
    LANGUAGES languagesZutrittsberechtigung = new LANGUAGES();
    LANGUAGE languageZutrittsberechtigungDE = new LANGUAGE();
    languageZutrittsberechtigungDE.setISO639(ISO639.DE);
    languageZutrittsberechtigungDE.setTEXT("Du hast für diesen Raum keine Zutrittsberechtigung.");

    LANGUAGE languageZutrittsberechtigungEN = new LANGUAGE();
    languageZutrittsberechtigungEN.setISO639(ISO639.EN);
    languageZutrittsberechtigungEN.setTEXT("You're not cleared to be in here.");

    LANGUAGE languageZutrittsberechtigungES = new LANGUAGE();
    languageZutrittsberechtigungES.setISO639(ISO639.ES);
    languageZutrittsberechtigungES.setTEXT("No tienes autorización para entrar en esta sala.");

    languagesZutrittsberechtigung.getLANGUAGE().add(languageZutrittsberechtigungDE);
    languagesZutrittsberechtigung.getLANGUAGE().add(languageZutrittsberechtigungEN);
    languagesZutrittsberechtigung.getLANGUAGE().add(languageZutrittsberechtigungES);
    commandZutrittsberechtigung.setLANGUAGES(languagesZutrittsberechtigung);

    COMMAND commandDoppelklicken = new COMMAND();
    commandDoppelklicken.setKEY(KEY.STRING_DOPPELKLICKEN);
    LANGUAGES languagesDoppelklicken = new LANGUAGES();

    LANGUAGE languageDoppelklickenDE = new LANGUAGE();
    languageDoppelklickenDE.setISO639(ISO639.DE);
    languageDoppelklickenDE.setTEXT("Doppelklicken für einen 1:1 Chat");

    LANGUAGE languageDoppelklickenEN = new LANGUAGE();
    languageDoppelklickenEN.setISO639(ISO639.EN);
    languageDoppelklickenEN.setTEXT("Double-click for a 1-on-1 chat");

    LANGUAGE languageDoppelklickenES = new LANGUAGE();
    languageDoppelklickenES.setISO639(ISO639.ES);
    languageDoppelklickenES.setTEXT("Haz doble clic para un chat 1:1");

    languagesDoppelklicken.getLANGUAGE().add(languageDoppelklickenDE);
    languagesDoppelklicken.getLANGUAGE().add(languageDoppelklickenEN);
    languagesDoppelklicken.getLANGUAGE().add(languageDoppelklickenES);

    commandDoppelklicken.setLANGUAGES(languagesDoppelklicken);

    COMMAND commandUserIstOffline = new COMMAND();
    commandUserIstOffline.setKEY(KEY.SERVER_USER_IST_OFFLINE);
    LANGUAGES languagesUserIstOffline = new LANGUAGES();
    LANGUAGE languageUserIstOfflineDE = new LANGUAGE();
    languageUserIstOfflineDE.setISO639(ISO639.DE);
    languageUserIstOfflineDE.setTEXT("<html><b>XXX</b> ist offline.</html>");

    LANGUAGE languageUserIstOfflineEN = new LANGUAGE();
    languageUserIstOfflineEN.setISO639(ISO639.EN);
    languageUserIstOfflineEN.setTEXT("<html><b>XXX</b> is offline.</html>");

    LANGUAGE languageUserIstOfflineES = new LANGUAGE();
    languageUserIstOfflineES.setISO639(ISO639.ES);
    languageUserIstOfflineES.setTEXT("<html><b>XXX</b> está desconectado.</html>");

    languagesUserIstOffline.getLANGUAGE().add(languageUserIstOfflineDE);
    languagesUserIstOffline.getLANGUAGE().add(languageUserIstOfflineEN);
    languagesUserIstOffline.getLANGUAGE().add(languageUserIstOfflineES);

    commandUserIstOffline.setLANGUAGES(languagesUserIstOffline);

    COMMAND commandStringJustHangUp = new COMMAND();
    commandStringJustHangUp.setKEY(KEY.STRING_JUST_HANG_UP);
    LANGUAGES languagesStringHangUp = new LANGUAGES();
    LANGUAGE languageStringHangUpDE = new LANGUAGE();
    languageStringHangUpDE.setISO639(ISO639.DE);
    languageStringHangUpDE.setTEXT("Du kannst das Fenster schließen, wenn du den Telefonhörer auflegst.");

    LANGUAGE languageStringHangUpEN = new LANGUAGE();
    languageStringHangUpEN.setISO639(ISO639.EN);
    languageStringHangUpEN.setTEXT("Just close the window after you hang up.");

    LANGUAGE languageStringHangUpES = new LANGUAGE();
    languageStringHangUpES.setISO639(ISO639.ES);
    languageStringHangUpES.setTEXT("Puedes cerrar la ventana cuando cuelgues.");

    languagesStringHangUp.getLANGUAGE().add(languageStringHangUpDE);
    languagesStringHangUp.getLANGUAGE().add(languageStringHangUpEN);
    languagesStringHangUp.getLANGUAGE().add(languageStringHangUpES);

    commandStringJustHangUp.setLANGUAGES(languagesStringHangUp);

    COMMAND commandServerNicknameVerboten = new COMMAND();
    commandServerNicknameVerboten.setKEY(KEY.SERVER_NICKNAME_VERBOTEN);
    LANGUAGES languagesServerNicknameVerboten = new LANGUAGES();
    LANGUAGE languageNicknameVerbotenDE = new LANGUAGE();
    languageNicknameVerbotenDE.setISO639(ISO639.DE);
    languageNicknameVerbotenDE.setTEXT("Der gewählte Alias ist nicht erlaubt. Bitte wähle einen anderen.");

    LANGUAGE languageNicknameVerbotenEN = new LANGUAGE();
    languageNicknameVerbotenEN.setISO639(ISO639.EN);
    languageNicknameVerbotenEN.setTEXT("The chosen alias is not allowed. Please choose another.");

    LANGUAGE languageNicknameVerbotenES = new LANGUAGE();
    languageNicknameVerbotenES.setISO639(ISO639.ES);
    languageNicknameVerbotenES.setTEXT("El alias que elegiste no está permitido. Por favor, elige otro.");

    languagesServerNicknameVerboten.getLANGUAGE().add(languageNicknameVerbotenDE);
    languagesServerNicknameVerboten.getLANGUAGE().add(languageNicknameVerbotenEN);
    languagesServerNicknameVerboten.getLANGUAGE().add(languageNicknameVerbotenES);

    commandServerNicknameVerboten.setLANGUAGES(languagesServerNicknameVerboten);

    COMMAND commandStringDvdTitel = new COMMAND();
    commandStringDvdTitel.setKEY(KEY.STRING_DVD_TITEL);
    LANGUAGES languagesDvdTitel = new LANGUAGES();

    LANGUAGE languageDvdTitelDE = new LANGUAGE();
    languageDvdTitelDE.setISO639(ISO639.DE);
    languageDvdTitelDE.setTEXT("Titel_");

    LANGUAGE languageDvdTitelEN = new LANGUAGE();
    languageDvdTitelEN.setISO639(ISO639.EN);
    languageDvdTitelEN.setTEXT("Title_");

    LANGUAGE languageDvdTitelES = new LANGUAGE();
    languageDvdTitelES.setISO639(ISO639.ES);
    languageDvdTitelES.setTEXT("Título_");

    languagesDvdTitel.getLANGUAGE().add(languageDvdTitelDE);
    languagesDvdTitel.getLANGUAGE().add(languageDvdTitelEN);
    languagesDvdTitel.getLANGUAGE().add(languageDvdTitelES);

    commandStringDvdTitel.setLANGUAGES(languagesDvdTitel);

    COMMAND commandServerTestmail = new COMMAND();
    commandServerTestmail.setKEY(KEY.SERVER_TESTMAIL);
    LANGUAGES languagesServerTestmail = new LANGUAGES();
    LANGUAGE languageServerTestmailDE = new LANGUAGE();
    languageServerTestmailDE.setISO639(ISO639.DE);
    languageServerTestmailDE.setTEXT(
        "Die Testmail ist angekommen.\r\n" + "Übertrage deine Mailkonfiguration in die Datei context.xml.\r\n"
            + "Du findest die Datei im Verzeichnis ./javacommserver/src/main/webapp/META-INF\r\n"
    );

    LANGUAGE languageServerTestmailEN = new LANGUAGE();
    languageServerTestmailEN.setISO639(ISO639.EN);
    languageServerTestmailEN.setTEXT(
        "The test email has been received.\r\n"
            + "Please transfer your mail configuration to the file context.xml.\r\n"
            + "The file is located in the directory ./javacommserver/src/main/webapp/META-INF."
    );

    LANGUAGE languageServerTestmailES = new LANGUAGE();
    languageServerTestmailES.setISO639(ISO639.ES);
    languageServerTestmailES.setTEXT(
        "El correo de prueba ha sido recibido.\r\n"
            + "Transfiera la configuración de correo al archivo context.xml.\r\n"
            + "El archivo se encuentra en el directorio ./javacommserver/src/main/webapp/META-INF."
    );

    languagesServerTestmail.getLANGUAGE().add(languageServerTestmailDE);
    languagesServerTestmail.getLANGUAGE().add(languageServerTestmailEN);
    languagesServerTestmail.getLANGUAGE().add(languageServerTestmailES);

    commandServerTestmail.setLANGUAGES(languagesServerTestmail);

    COMMAND commandServerTestmailBetreff = new COMMAND();
    commandServerTestmailBetreff.setKEY(KEY.SERVER_BETREFF_TESTMAIL);
    LANGUAGES languagesBetreffTestmail = new LANGUAGES();
    LANGUAGE languageTestmailBetreffDE = new LANGUAGE();
    languageTestmailBetreffDE.setISO639(ISO639.DE);
    languageTestmailBetreffDE.setTEXT("Testmail – Eingang bestätigt");

    LANGUAGE languageTestmailBetreffEN = new LANGUAGE();
    languageTestmailBetreffEN.setISO639(ISO639.EN);
    languageTestmailBetreffEN.setTEXT("Test Email – Received");

    LANGUAGE languageTestmailBetreffES = new LANGUAGE();
    languageTestmailBetreffES.setISO639(ISO639.ES);
    languageTestmailBetreffES.setTEXT("Correo de prueba – Recibido");

    languagesBetreffTestmail.getLANGUAGE().add(languageTestmailBetreffDE);
    languagesBetreffTestmail.getLANGUAGE().add(languageTestmailBetreffEN);
    languagesBetreffTestmail.getLANGUAGE().add(languageTestmailBetreffES);

    commandServerTestmailBetreff.setLANGUAGES(languagesBetreffTestmail);

    COMMAND commandServerRaumfilter_Gepseichert = new COMMAND();
    commandServerRaumfilter_Gepseichert.setKEY(KEY.SERVER_RAUMFILTER_GESPEICHERT);
    LANGUAGES languagesRaumfilterGespeichert = new LANGUAGES();
    LANGUAGE languageRaumfilterGespeichertDE = new LANGUAGE();
    languageRaumfilterGespeichertDE.setISO639(ISO639.DE);
    languageRaumfilterGespeichertDE.setTEXT("<html>Raumfilter <b>XXX</b> wurde gespeichert.</html>");

    LANGUAGE languageRaumfilterGespeichertEN = new LANGUAGE();
    languageRaumfilterGespeichertEN.setISO639(ISO639.EN);
    languageRaumfilterGespeichertEN.setTEXT("<html>Room filter <b>XXX</b> saved.</html>");

    LANGUAGE languageRaumfilterGespeichertES = new LANGUAGE();
    languageRaumfilterGespeichertES.setISO639(ISO639.ES);
    languageRaumfilterGespeichertES.setTEXT("<html>El filtro de sala <b>XXX</b> se ha guardado.</html>");

    languagesRaumfilterGespeichert.getLANGUAGE().add(languageRaumfilterGespeichertDE);
    languagesRaumfilterGespeichert.getLANGUAGE().add(languageRaumfilterGespeichertEN);
    languagesRaumfilterGespeichert.getLANGUAGE().add(languageRaumfilterGespeichertES);

    commandServerRaumfilter_Gepseichert.setLANGUAGES(languagesRaumfilterGespeichert);

    COMMAND commandServerRaumfilter_Nicht_Geloescht = new COMMAND();
    commandServerRaumfilter_Nicht_Geloescht.setKEY(KEY.SERVER_RAUMFILTER_NOT_DELETED);
    LANGUAGES languagesRaumfilterNichtGeloescht = new LANGUAGES();
    LANGUAGE languageRaumfilterNichtGeloeschtDE = new LANGUAGE();
    languageRaumfilterNichtGeloeschtDE.setISO639(ISO639.DE);
    languageRaumfilterNichtGeloeschtDE.setTEXT("Raumfilter wurden nicht gelöscht.");

    LANGUAGE languageRaumfilterNichtGeloeschtEN = new LANGUAGE();
    languageRaumfilterNichtGeloeschtEN.setISO639(ISO639.EN);
    languageRaumfilterNichtGeloeschtEN.setTEXT("Room filters were not deleted.");

    LANGUAGE languageRaumfilterNichtGeloeschtES = new LANGUAGE();
    languageRaumfilterNichtGeloeschtES.setISO639(ISO639.ES);
    languageRaumfilterNichtGeloeschtES.setTEXT("Los filtros de sala no se han eliminado.");

    languagesRaumfilterNichtGeloescht.getLANGUAGE().add(languageRaumfilterNichtGeloeschtDE);
    languagesRaumfilterNichtGeloescht.getLANGUAGE().add(languageRaumfilterNichtGeloeschtEN);
    languagesRaumfilterNichtGeloescht.getLANGUAGE().add(languageRaumfilterNichtGeloeschtES);

    commandServerRaumfilter_Nicht_Geloescht.setLANGUAGES(languagesRaumfilterNichtGeloescht);

    COMMAND commandServerRaumfilter_Geloescht = new COMMAND();
    commandServerRaumfilter_Geloescht.setKEY(KEY.SERVER_RAUMFILTER_DELETED);
    LANGUAGES languagesRaumfilterGeloescht = new LANGUAGES();
    LANGUAGE languageRaumfilterGeloeschtDE = new LANGUAGE();
    languageRaumfilterGeloeschtDE.setISO639(ISO639.DE);
    languageRaumfilterGeloeschtDE.setTEXT(
        "<html>" + "<p style='text-align:center'>Raumfilter wurden gelöscht.</p><br>"
            + "<p style='text-align:center'>Gelöschte Filter:</p>"
            + "<p style='text-align:center'>XXX</p>"
            + "</html>"
    );
    LANGUAGE languageRaumfilterGeloeschtEN = new LANGUAGE();
    languageRaumfilterGeloeschtEN.setISO639(ISO639.EN);
    languageRaumfilterGeloeschtEN.setTEXT(
        "<html>" + "<p style='text-align:center'>Room filters deleted.</p><br>"
            + "<p style='text-align:center'>Deleted filters:</p>"
            + "<p style='text-align:center'>XXX</p>"
            + "</html>"
    );
    LANGUAGE languageRaumfilterGeloeschtES = new LANGUAGE();
    languageRaumfilterGeloeschtES.setISO639(ISO639.ES);
    languageRaumfilterGeloeschtES.setTEXT(
        "<html>" + "<p style='text-align:center'>Los filtros de sala se han eliminado.</p><br>"
            + "<p style='text-align:center'>Filtros eliminados:</p>"
            + "<p style='text-align:center'>XXX</p>"
            + "</html>"
    );
    languagesRaumfilterGeloescht.getLANGUAGE().add(languageRaumfilterGeloeschtDE);
    languagesRaumfilterGeloescht.getLANGUAGE().add(languageRaumfilterGeloeschtEN);
    languagesRaumfilterGeloescht.getLANGUAGE().add(languageRaumfilterGeloeschtES);

    commandServerRaumfilter_Geloescht.setLANGUAGES(languagesRaumfilterGeloescht);

    COMMAND commandRaumfilter_vorhanden = new COMMAND();
    commandRaumfilter_vorhanden.setKEY(KEY.STRING_RAUMFILTER_VORHANDEN);
    LANGUAGES languagesRaumfilterVorhanden = new LANGUAGES();
    LANGUAGE languageRaumfilterVorhandenDE = new LANGUAGE();
    languageRaumfilterVorhandenDE.setISO639(ISO639.DE);
    languageRaumfilterVorhandenDE.setTEXT("<html>Der Raumfilter <b>XXX</b> ist bereits vorhanden.</html>");

    LANGUAGE languageRaumfilterVorhandenEN = new LANGUAGE();
    languageRaumfilterVorhandenEN.setISO639(ISO639.EN);
    languageRaumfilterVorhandenEN.setTEXT("<html>The room filter <b>XXX</b> already exists.</html>");

    LANGUAGE languageRaumfilterVorhandenES = new LANGUAGE();
    languageRaumfilterVorhandenES.setISO639(ISO639.ES);
    languageRaumfilterVorhandenES.setTEXT("<html>El filtro de sala <b>XXX</b> ya existe.</html>");

    languagesRaumfilterVorhanden.getLANGUAGE().add(languageRaumfilterVorhandenDE);
    languagesRaumfilterVorhanden.getLANGUAGE().add(languageRaumfilterVorhandenEN);
    languagesRaumfilterVorhanden.getLANGUAGE().add(languageRaumfilterVorhandenES);

    commandRaumfilter_vorhanden.setLANGUAGES(languagesRaumfilterVorhanden);

    COMMAND commandStringRoomFilter = new COMMAND();
    commandStringRoomFilter.setKEY(KEY.STRING_ROOM_FILTER);
    LANGUAGES languagesStringRoomFilter = new LANGUAGES();
    LANGUAGE languageStringRoomFilterDE = new LANGUAGE();
    languageStringRoomFilterDE.setISO639(ISO639.DE);
    languageStringRoomFilterDE.setTEXT("Raumfilter");

    LANGUAGE languageStringRoomFilterEN = new LANGUAGE();
    languageStringRoomFilterEN.setISO639(ISO639.EN);
    languageStringRoomFilterEN.setTEXT("Room filter");

    LANGUAGE languageStringRoomFilterES = new LANGUAGE();
    languageStringRoomFilterES.setISO639(ISO639.ES);
    languageStringRoomFilterES.setTEXT("Filtro de sala");

    languagesStringRoomFilter.getLANGUAGE().add(languageStringRoomFilterDE);
    languagesStringRoomFilter.getLANGUAGE().add(languageStringRoomFilterEN);
    languagesStringRoomFilter.getLANGUAGE().add(languageStringRoomFilterES);

    commandStringRoomFilter.setLANGUAGES(languagesStringRoomFilter);

    COMMAND commandStringNeuerRaumfilter = new COMMAND();
    commandStringNeuerRaumfilter.setKEY(KEY.STRING_NEUER_RAUMFILTER);
    LANGUAGES languagesNeuerRaumfilter = new LANGUAGES();
    LANGUAGE languageNeuerRaumfilterDE = new LANGUAGE();
    languageNeuerRaumfilterDE.setISO639(ISO639.DE);
    languageNeuerRaumfilterDE.setTEXT("Filter für einen Raumnamen eingeben.");

    LANGUAGE languageNeuerRaumfilterEN = new LANGUAGE();
    languageNeuerRaumfilterEN.setISO639(ISO639.EN);
    languageNeuerRaumfilterEN.setTEXT("Enter a filter for a room name.");

    LANGUAGE languageNeuerRaumfilterES = new LANGUAGE();
    languageNeuerRaumfilterES.setISO639(ISO639.ES);
    languageNeuerRaumfilterES.setTEXT("Ingrese un filtro para un nombre de sala.");

    languagesNeuerRaumfilter.getLANGUAGE().add(languageNeuerRaumfilterDE);
    languagesNeuerRaumfilter.getLANGUAGE().add(languageNeuerRaumfilterEN);
    languagesNeuerRaumfilter.getLANGUAGE().add(languageNeuerRaumfilterES);

    commandStringNeuerRaumfilter.setLANGUAGES(languagesNeuerRaumfilter);

    COMMAND commandStringStreamBelegen = new COMMAND();
    commandStringStreamBelegen.setKEY(KEY.STRING_STREAM_BELEGEN);
    LANGUAGES languagesStreamBelegen = new LANGUAGES();
    LANGUAGE languageStreamBelegenDE = new LANGUAGE();
    languageStreamBelegenDE.setISO639(ISO639.DE);
    languageStreamBelegenDE.setTEXT("Stream belegen");

    LANGUAGE languageStreamBelegenEN = new LANGUAGE();
    languageStreamBelegenEN.setISO639(ISO639.EN);
    languageStreamBelegenEN.setTEXT("Assign Stream");

    LANGUAGE languageStreamBelegenES = new LANGUAGE();
    languageStreamBelegenES.setISO639(ISO639.ES);
    languageStreamBelegenES.setTEXT("Assignar Stream");

    languagesStreamBelegen.getLANGUAGE().add(languageStreamBelegenDE);
    languagesStreamBelegen.getLANGUAGE().add(languageStreamBelegenEN);
    languagesStreamBelegen.getLANGUAGE().add(languageStreamBelegenES);

    commandStringStreamBelegen.setLANGUAGES(languagesStreamBelegen);

    COMMAND commandStringNichBelegt = new COMMAND();
    commandStringNichBelegt.setKEY(KEY.STRING_NICHT_BELEGT);
    LANGUAGES languagesNichtBelegt = new LANGUAGES();
    LANGUAGE languageNichtBelegtDE = new LANGUAGE();
    languageNichtBelegtDE.setISO639(ISO639.DE);
    languageNichtBelegtDE.setTEXT("# nicht belegt");

    LANGUAGE languageNichtBelegtEN = new LANGUAGE();
    languageNichtBelegtEN.setISO639(ISO639.EN);
    languageNichtBelegtEN.setTEXT("# Unassigned");

    LANGUAGE languageNichtBelegtES = new LANGUAGE();
    languageNichtBelegtES.setISO639(ISO639.ES);
    languageNichtBelegtES.setTEXT("# Sin asignar");

    languagesNichtBelegt.getLANGUAGE().add(languageNichtBelegtDE);
    languagesNichtBelegt.getLANGUAGE().add(languageNichtBelegtEN);
    languagesNichtBelegt.getLANGUAGE().add(languageNichtBelegtES);

    commandStringNichBelegt.setLANGUAGES(languagesNichtBelegt);

    COMMAND commandLabelStreamName = new COMMAND();
    commandLabelStreamName.setKEY(KEY.LABEL_STREAM_NAME);
    LANGUAGES languagesLabelStreamName = new LANGUAGES();
    LANGUAGE languageStreamNameDE = new LANGUAGE();
    languageStreamNameDE.setISO639(ISO639.DE);
    languageStreamNameDE.setTEXT("Stream Name");

    LANGUAGE languageStreamNameEN = new LANGUAGE();
    languageStreamNameEN.setISO639(ISO639.EN);
    languageStreamNameEN.setTEXT("Stream Name");

    LANGUAGE languageStreamNameES = new LANGUAGE();
    languageStreamNameES.setISO639(ISO639.ES);
    languageStreamNameES.setTEXT("Nombre del Stream");

    languagesLabelStreamName.getLANGUAGE().add(languageStreamNameDE);
    languagesLabelStreamName.getLANGUAGE().add(languageStreamNameEN);
    languagesLabelStreamName.getLANGUAGE().add(languageStreamNameES);

    commandLabelStreamName.setLANGUAGES(languagesLabelStreamName);

    COMMAND commandLabelStreamUrl = new COMMAND();
    commandLabelStreamUrl.setKEY(KEY.LABEL_STREAM_URL);
    LANGUAGES languagesLabelStreamUrl = new LANGUAGES();
    LANGUAGE languageStreamUrlDE = new LANGUAGE();
    languageStreamUrlDE.setISO639(ISO639.DE);
    languageStreamUrlDE.setTEXT("Stream URL");

    LANGUAGE languageStreamUrlEN = new LANGUAGE();
    languageStreamUrlEN.setISO639(ISO639.EN);
    languageStreamUrlEN.setTEXT("Stream URL");

    LANGUAGE languageStreamUrlES = new LANGUAGE();
    languageStreamUrlES.setISO639(ISO639.ES);
    languageStreamUrlES.setTEXT("URL del Stream");

    languagesLabelStreamUrl.getLANGUAGE().add(languageStreamUrlDE);
    languagesLabelStreamUrl.getLANGUAGE().add(languageStreamUrlEN);
    languagesLabelStreamUrl.getLANGUAGE().add(languageStreamUrlES);

    commandLabelStreamUrl.setLANGUAGES(languagesLabelStreamUrl);

    COMMAND commandButtonFreigeben = new COMMAND();
    commandButtonFreigeben.setKEY(KEY.BUTTON_FREIGEBEN);
    LANGUAGES languagesButtonFreigeben = new LANGUAGES();
    LANGUAGE languageButtonFreigebenDE = new LANGUAGE();
    languageButtonFreigebenDE.setISO639(ISO639.DE);
    languageButtonFreigebenDE.setTEXT("Freigeben");

    LANGUAGE languageButtonFreigebenEN = new LANGUAGE();
    languageButtonFreigebenEN.setISO639(ISO639.EN);
    languageButtonFreigebenEN.setTEXT("Unassign");

    LANGUAGE languageButtonFreigebenES = new LANGUAGE();
    languageButtonFreigebenES.setISO639(ISO639.ES);
    languageButtonFreigebenES.setTEXT("Desasignar");

    languagesButtonFreigeben.getLANGUAGE().add(languageButtonFreigebenDE);
    languagesButtonFreigeben.getLANGUAGE().add(languageButtonFreigebenEN);
    languagesButtonFreigeben.getLANGUAGE().add(languageButtonFreigebenES);

    commandButtonFreigeben.setLANGUAGES(languagesButtonFreigeben);

    commands.getCOMMAND().add(commandButtonFreigeben);
    commands.getCOMMAND().add(commandLabelStreamUrl);
    commands.getCOMMAND().add(commandLabelStreamName);
    commands.getCOMMAND().add(commandStringNichBelegt);
    commands.getCOMMAND().add(commandStringStreamBelegen);
    commands.getCOMMAND().add(commandStringNeuerRaumfilter);
    commands.getCOMMAND().add(commandStringRoomFilter);
    commands.getCOMMAND().add(commandRaumfilter_vorhanden);
    commands.getCOMMAND().add(commandServerRaumfilter_Geloescht);
    commands.getCOMMAND().add(commandServerRaumfilter_Nicht_Geloescht);
    commands.getCOMMAND().add(commandServerRaumfilter_Gepseichert);
    commands.getCOMMAND().add(commandServerTestmailBetreff);
    commands.getCOMMAND().add(commandServerTestmail);
    commands.getCOMMAND().add(commandStringDvdTitel);
    commands.getCOMMAND().add(commandServerNicknameVerboten);
    commands.getCOMMAND().add(commandStringJustHangUp);
    commands.getCOMMAND().add(commandUserIstOffline);
    commands.getCOMMAND().add(commandDoppelklicken);
    commands.getCOMMAND().add(commandZutrittsberechtigung);
    commands.getCOMMAND().add(commandEncryptingProperly);
    commands.getCOMMAND().add(commandKeinRegistrierterAnwender);
    commands.getCOMMAND().add(commandServerVollmitgliedEinschreiben);
    commands.getCOMMAND().add(commandServerUnerlaubteZeichen);
    commands.getCOMMAND().add(commandServerPasswortZuKurz);
    commands.getCOMMAND().add(commandAndererNickname);
    commands.getCOMMAND().add(commandCloseAllRooms);
    commands.getCOMMAND().add(commandNichtAnwesendInKonferenz);
    commands.getCOMMAND().add(commandStringEinzigeKonferenzteilnehmer);
    commands.getCOMMAND().add(commandFrameVideokonferenz);
    commands.getCOMMAND().add(commandServerForwardingImage);
    commands.getCOMMAND().add(commandServerDrittePerson);
    commands.getCOMMAND().add(commandServerVideoRunning);
    commands.getCOMMAND().add(commandZitrone);
    commands.getCOMMAND().add(commandChatExhausted);
    commands.getCOMMAND().add(commandStringHatKeineBerechtigung);
    commands.getCOMMAND().add(commandChatIsRunning);
    commands.getCOMMAND().add(commandSeelen);
    commands.getCOMMAND().add(commandTeilen);
    commands.getCOMMAND().add(commandSerververbindung);
    commands.getCOMMAND().add(commandVerzeichnisname);
    commands.getCOMMAND().add(commandIstNichtVorhanden);
    commands.getCOMMAND().add(commandAufzeichnen);
    commands.getCOMMAND().add(commandIstInEinerKonferenz);
    commands.getCOMMAND().add(commandButtonReport);
    commands.getCOMMAND().add(commandButtonPruefenGenB);
    commands.getCOMMAND().add(commandLabelChatStunden);
    commands.getCOMMAND().add(commandStringChatModule);
    commands.getCOMMAND().add(commandLabelDuHastVerloren);
    commands.getCOMMAND().add(commandLabelSchwierig);
    commands.getCOMMAND().add(commandLabelEinfach);
    commands.getCOMMAND().add(commandStringWederNoch);
    commands.getCOMMAND().add(commandLabelDuHastGewonnen);
    commands.getCOMMAND().add(commandStringRunde);
    commands.getCOMMAND().add(commandStringDieRundeIst);
    commands.getCOMMAND().add(commandLabelDuBistInRunde);
    commands.getCOMMAND().add(commandColoringConditions);
    commands.getCOMMAND().add(commandColoringByConditions);
    commands.getCOMMAND().add(commandDerSchwierigkeitsgrad);
    commands.getCOMMAND().add(commandGameHasStarted);
    commands.getCOMMAND().add(commandSpielAbbrechen);
    commands.getCOMMAND().add(commandStringFortsetzen);
    commands.getCOMMAND().add(commandStringSpiel);
    commands.getCOMMAND().add(commandWeiterspielenOderAbbrechen);
    commands.getCOMMAND().add(commandStringUnderConstruction);
    commands.getCOMMAND().add(commandStringGameIsRunning);
    commands.getCOMMAND().add(commandStringEsWurdeNicht);
    commands.getCOMMAND().add(commandStringBenutzerfehler);
    commands.getCOMMAND().add(commandCheckboxFarbmuster);
    commands.getCOMMAND().add(commandLabelSchwierigkeitsgrad);
    commands.getCOMMAND().add(commandStringSolution);
    commands.getCOMMAND().add(commandSpielStarten);
    commands.getCOMMAND().add(commandNeuesSpiel);
    commands.getCOMMAND().add(commandNeuesSpiel);
    commands.getCOMMAND().add(commandButtonAnleitung);
    commands.getCOMMAND().add(commandFrameMastermind);
    commands.getCOMMAND().add(commandMenuGaming);
    commands.getCOMMAND().add(commandStringModified);
    commands.getCOMMAND().add(commandStringType);
    commands.getCOMMAND().add(commandStringSize);
    commands.getCOMMAND().add(commandStringName);
    commands.getCOMMAND().add(commandStringUpload);
    commands.getCOMMAND().add(commandStringBack);
    commands.getCOMMAND().add(commandStringApply);
    commands.getCOMMAND().add(commandStringTeilnehmerliste);
    commands.getCOMMAND().add(commandStringBenutzerkontoAktiviert);
    commands.getCOMMAND().add(commandStringDasBenutzerkonto);
    commands.getCOMMAND().add(commandStringAblaufdatum);
    commands.getCOMMAND().add(commandStringLogischGeloescht);
    commands.getCOMMAND().add(commandStringKontoAnmelden);
    commands.getCOMMAND().add(commandStringDeinKontoWurde);
    commands.getCOMMAND().add(commandStringAnwender);
    commands.getCOMMAND().add(commandStringRemoveFiles);
    commands.getCOMMAND().add(commandStringAddFiles);
    commands.getCOMMAND().add(commandStringMindestens2Dateien);
    commands.getCOMMAND().add(commandStringKorrupteDateien);
    commands.getCOMMAND().add(commandButtonValidieren);
    commands.getCOMMAND().add(commandStringBemerkung);
    commands.getCOMMAND().add(commandFrameSchemapruefung);
    commands.getCOMMAND().add(commandStringVerzeichnis);
    commands.getCOMMAND().add(commandButtonMerge);
    commands.getCOMMAND().add(commandButtonOdxMinus);
    commands.getCOMMAND().add(commandButtonOdxPlus);
    commands.getCOMMAND().add(commandStringDieDatei);
    commands.getCOMMAND().add(commandStringHinweis);
    commands.getCOMMAND().add(commandStringError);
    commands.getCOMMAND().add(commandStringSnippet);
    commands.getCOMMAND().add(commandStringLine);
    commands.getCOMMAND().add(commandReport);
    commands.getCOMMAND().add(commandAlleSpeicherOptionen);
    commands.getCOMMAND().add(commandCheckboxBackup);
    commands.getCOMMAND().add(commandLabelKeineFehlerGefunden);
    commands.getCOMMAND().add(commandStringMoveAndSort);
    commands.getCOMMAND().add(commandLabelSchemadatei);
    commands.getCOMMAND().add(commandButtonPruefen);
    commands.getCOMMAND().add(commandCheckboxDiagnosevorgaben);
    commands.getCOMMAND().add(commandCheckboxIndex);
    commands.getCOMMAND().add(commandEinGesetzterHaken);
    commands.getCOMMAND().add(commandModul);
    commands.getCOMMAND().add(commandSearchIn);
    commands.getCOMMAND().add(commandImport);
    commands.getCOMMAND().add(commandOdx);
    commands.getCOMMAND().add(commandConfirmDirectory);
    commands.getCOMMAND().add(commandClickFileOrDirectory);
    commands.getCOMMAND().add(commandStringEntferneAnhang);
    commands.getCOMMAND().add(commandStringTelefonkonferenz);
    commands.getCOMMAND().add(commandLabelOrganisator);
    commands.getCOMMAND().add(commandLabelAusente);
    commands.getCOMMAND().add(commandLabelAnwesend);
    commands.getCOMMAND().add(commandServerVerbindungsproblem);
    commands.getCOMMAND().add(commandServerLeitungUnterbrochen);
    commands.getCOMMAND().add(commandLabelVerfallsdatum);
    commands.getCOMMAND().add(commandButtonAendern);
    commands.getCOMMAND().add(commandStringMarkieren);
    commands.getCOMMAND().add(commandStringZeitspanne);
    commands.getCOMMAND().add(commandStringPauseFortsetzen);
    commands.getCOMMAND().add(commandStringAnDenAnfang);
    commands.getCOMMAND().add(commandButtonEinladen);
    commands.getCOMMAND().add(commandLabelMeineKonferenzenOrganisieren);
    commands.getCOMMAND().add(commandStringBackward);
    commands.getCOMMAND().add(commandStringForward);
    commands.getCOMMAND().add(commandLabelDieBeschreibungWird);
    commands.getCOMMAND().add(commandStringChattenAbgelehnt);
    commands.getCOMMAND().add(commandServerLehntChatanfragenAb);
    commands.getCOMMAND().add(commandStringNaechsterTitel);
    commands.getCOMMAND().add(commandFrameTelefonkonferenzErstellen);
    commands.getCOMMAND().add(commandStringTeilnehmen);
    commands.getCOMMAND().add(commandStringCreate);
    commands.getCOMMAND().add(commandButtonNotify);
    commands.getCOMMAND().add(commandStringOrganize);

    write(multilingual);

  }



  @ParameterizedTest
  @EnumSource(KEY.class)
  @DisplayName(value = "Alle KEYS vorhanden?")
  public void getCommand(KEY key) {
    COMMAND command = Multilingual.getInstance().getCommand(key);
    assertNotNull(command);
  }



  /**
   * Eine Konfigurationsdatei wird gelesen.
   *
   *
   * @return der Wurzelknoten
   * @throws JAXBException
   * @throws SAXException
   */
  public MULTILINGUAL read() throws JAXBException, SAXException {
    MULTILINGUAL root = null;
    schema = schemafactory.newSchema(source);

    try(
      InputStream sqlmapper_xml = getClass()
          .getResourceAsStream("net/javacomm/multilingual/schema/multilingual.xml")
    ) {
      JAXBContext jc = JAXBContext.newInstance("net.javacomm.multilingual.schema");
      Unmarshaller unmarshaller = jc.createUnmarshaller();
      unmarshaller.setSchema(schema);
      Source source = new StreamSource(sqlmapper_xml);
      JAXBElement<MULTILINGUAL> jaxbCollection = unmarshaller.unmarshal(source, MULTILINGUAL.class);
      root = jaxbCollection.getValue();
    }
    catch (IOException e) {
      log.warn(e.getMessage(), e);
    }
    return root;
  }



  @BeforeEach
  public void setUp() {
    multilingual = new MULTILINGUAL();
    path = Paths
        .get("src", "test", "resources", "net", "javacomm", "multilingual", "schema", "multilingual.xml");
    schemafactory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
    schemaFile = Paths.get("target", "test-classes", "multilingual.xsd");
    source = new StreamSource(schemaFile.toFile());
  }



  @AfterEach
  public void tearDown() {

  }



  public void write(MULTILINGUAL root) throws JAXBException, IOException, SAXException {
    if (root == null) throw new IllegalArgumentException("root is null");
    schema = schemafactory.newSchema(source);
    Charset charset = Charset.forName("UTF-8");
    try(BufferedWriter buferredWriter = Files.newBufferedWriter(path, charset);) {
      JAXBContext jc = JAXBContext.newInstance("net.javacomm.multilingual.schema");
      Marshaller marshaller = jc.createMarshaller();
      marshaller.setSchema(schema);
      ObjectFactory factory = new ObjectFactory();
      JAXBElement<MULTILINGUAL> newroot = factory.createMULTILINGUAL(root);
      marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
      marshaller.setProperty(Marshaller.JAXB_NO_NAMESPACE_SCHEMA_LOCATION, "multilingual.xsd");
      marshaller.marshal(newroot, buferredWriter);
    }
  }

}
