/**
 *  Copyright © 2021-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.administer;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.javacomm.client.gui.MultilingualServiceButton;
import net.javacomm.multilingual.Babelfish;
import net.javacomm.multilingual.schema.ISO639;
import net.javacomm.multilingual.schema.KEY;
import net.javacomm.transfer.TransferUser;
import net.javacomm.window.manager.Control;



public class JBenutzerVerwalten extends JPanel implements Babelfish {

  private static final long serialVersionUID = -2559242869200099753L;
  private MultilingualServiceButton knopfleiste = new MultilingualServiceButton(
      KEY.BUTTON_SPEICHERN, KEY.BUTTON_SCHLIESSEN
  );
  private JPanel panSouth = new JPanel(new FlowLayout(FlowLayout.CENTER));
  private PropertyChangeSupport changes = new PropertyChangeSupport(this);
  private JScrollBenutzerantraege scrollkonto = new JScrollBenutzerantraege();
  private JSeparator separator = new JSeparator();

  private GridBagLayout gridbag = new GridBagLayout();
  private GridBagConstraints con = new GridBagConstraints();

  public JBenutzerVerwalten() {
    setLayout(gridbag);

    con.gridx = 0;
    con.gridy = 0;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.BOTH;
    con.weightx = 1.0;
    con.weighty = 1.0;
    con.insets = new Insets(12, 12, 0, 12);
    con.anchor = GridBagConstraints.CENTER;
    gridbag.setConstraints(scrollkonto, con);
    add(scrollkonto);
    scrollkonto.getVerticalScrollBar().setUnitIncrement(12);
    scrollkonto.getHorizontalScrollBar().setUnitIncrement(12);

    con.gridx = 0;
    con.gridy = 1;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.HORIZONTAL;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(24, 12, 0, 12);
    con.anchor = GridBagConstraints.CENTER;
    gridbag.setConstraints(separator, con);
    add(separator);

    con.gridx = 0;
    con.gridy = 2;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.NONE;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(12, 12, 12, 12);
    con.anchor = GridBagConstraints.EAST;
    gridbag.setConstraints(panSouth, con);
    add(panSouth);
    panSouth.add(knopfleiste);
    knopfleiste.addButtonListener((event) -> {
      Control value = (Control) event.getNewValue();
      switch(value) {
        case BUTTON_1:
          changes.firePropertyChange(JBenutzerVerwalten.class.getName(), Control.NULL, Control.SAVE);
          break;
        case BUTTON_2:
          changes.firePropertyChange(JBenutzerVerwalten.class.getName(), Control.NULL, Control.CLOSE);
          break;
        default:
          break;
      }
    });
    knopfleiste.setEnabledButton1();

  }



  /**
   * Zeige Kontoaktivitäten an.
   * 
   * @param userliste
   *                  diese User haben Kontoaktivitäten
   */
  public void setAntraege(List<TransferUser> userliste) {
    scrollkonto.setKontoaktivitaet(userliste);
  }



  protected List<TransferUser> getAntraege() {
    return scrollkonto.getKontoaktivitaet();
  }



  /**
   * Die Spaltenüberschriften werden zentriert.
   */
  public void centerHeader() {
    scrollkonto.centerHeader();
  }



  public synchronized void addAntraegeListener(PropertyChangeListener listener) {
    changes.addPropertyChangeListener(listener);
  }



  public synchronized void removeAntraegeListener(PropertyChangeListener listener) {
    changes.removePropertyChangeListener(listener);
  }



  public synchronized void removeAllListener() {
    for (PropertyChangeListener listener : changes.getPropertyChangeListeners()) {
      removeAntraegeListener(listener);
    }
    knopfleiste.removeAllListener();
  }



  @Override
  public void setLanguage(ISO639 code) {
    knopfleiste.setLanguage(code);
    scrollkonto.setLanguage(code);
  }

}
