/**
 *  Copyright © 2021-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.administer;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.javacomm.client.gui.MultilingualServiceButton;
import net.javacomm.multilingual.Babelfish;
import net.javacomm.multilingual.MultilingualLabel;
import net.javacomm.multilingual.MultilingualRadioButton;
import net.javacomm.multilingual.schema.ISO639;
import net.javacomm.multilingual.schema.KEY;
import net.javacomm.window.manager.Control;



public class JDomain extends JPanel implements Babelfish {

  private static final long serialVersionUID = -5251783481363237002L;
//  private final static Logger log = LogManager.getLogger(JDomain.class);
  private GridBagLayout gridbag = new GridBagLayout();
  private GridBagConstraints con = new GridBagConstraints();
  private JTextField textfieldDomain = new JTextField(24);
  private MultilingualLabel labelDomain = new MultilingualLabel(KEY.LABEL_AUF_MEINER_DOMAENE);
  private MultilingualRadioButton open = new MultilingualRadioButton(KEY.RADIO_BUTTON_OFFENE_DOMAENE);
  private MultilingualRadioButton close = new MultilingualRadioButton(KEY.RADIO_BUTTON_GESCHLOSSENE_DOMAENE);
  private ButtonGroup buttonGroup = new ButtonGroup();
  private JSeparator separator = new JSeparator();
  private MultilingualServiceButton serviceButton = new MultilingualServiceButton(
      KEY.BUTTON_SPEICHERN, KEY.BUTTON_SCHLIESSEN
  );

  private PropertyChangeSupport changes = new PropertyChangeSupport(this);

  public JDomain() {
    setLayout(gridbag);

    con.gridx = 0;
    con.gridy = 0;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.NONE;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(12, 12, 0, 12);
    con.anchor = GridBagConstraints.WEST;
    gridbag.setConstraints(labelDomain, con);
    add(labelDomain);

    con.gridx = 1;
    con.gridy = 0;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.NONE;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(6, 6, 0, 12);
    con.anchor = GridBagConstraints.CENTER;
    gridbag.setConstraints(textfieldDomain, con);
    add(textfieldDomain);

    buttonGroup.add(open);
    buttonGroup.add(close);
    open.setSelected(true);

    con.gridx = 0;
    con.gridy = 1;
    con.gridwidth = 2;
    con.gridheight = 1;
    con.fill = GridBagConstraints.NONE;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(6, 12, 0, 0);
    con.anchor = GridBagConstraints.WEST;
    gridbag.setConstraints(open, con);
    add(open);

    con.gridx = 0;
    con.gridy = 2;
    con.gridwidth = 2;
    con.gridheight = 1;
    con.fill = GridBagConstraints.NONE;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(6, 12, 0, 0);
    con.anchor = GridBagConstraints.WEST;
    gridbag.setConstraints(close, con);
    add(close);

    con.gridx = 0;
    con.gridy = 3;
    con.gridwidth = 2;
    con.gridheight = 1;
    con.fill = GridBagConstraints.HORIZONTAL;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(24, 12, 0, 12);
    con.anchor = GridBagConstraints.CENTER;
    gridbag.setConstraints(separator, con);
    add(separator);

    con.gridx = 1;
    con.gridy = 4;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.NONE;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(12, 12, 0, 12);
    con.anchor = GridBagConstraints.EAST;
    gridbag.setConstraints(serviceButton, con);
    add(serviceButton);
    serviceButton.addButtonListener((event) -> {
      Control value = (Control) event.getNewValue();
      switch(value) {
        case BUTTON_1:
          changes.firePropertyChange(JDomain.class.getName(), Control.NULL, Control.SAVE);
          break;
        case BUTTON_2:
          changes.firePropertyChange(JDomain.class.getName(), Control.NULL, Control.CLOSE);
          break;
        default:
          break;
      }
    });
    serviceButton.setEnabledButton1();


  }



  public synchronized void addDomainListener(PropertyChangeListener listener) {
    changes.addPropertyChangeListener(listener);
  }



  public synchronized void removeDomainListener(PropertyChangeListener listener) {
    changes.removePropertyChangeListener(listener);
  }



  public synchronized void removeAllListener() {
    for (PropertyChangeListener listener : changes.getPropertyChangeListeners()) {
      removeDomainListener(listener);
    }
    serviceButton.removeAllListener();
  }



  public void setDomain(String value) {
    textfieldDomain.setText(value);
  }



  public String getDomain() {
    return textfieldDomain.getText();
  }



  public void setIsPublic(boolean value) {
    if (value) {
      open.setSelected(true);
    }
    else {
      close.setSelected(true);
    }
  }



  public boolean getIsPublic() {
    return open.isSelected();
  }



  @Override
  public void setLanguage(ISO639 code) {
    labelDomain.setLanguage(code);
    open.setLanguage(code);
    close.setLanguage(code);
    serviceButton.setLanguage(code);
  }

}
