/**
 *  Copyright © 2026, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.client.administer;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import javax.swing.SwingWorker;
import net.javacomm.restserver.Wrapper;
import net.javacomm.share.Constants;



public class RemoveRoomfilterWorker extends SwingWorker<Boolean, Void> {

  private String userid;
  private String password;
  private List<String> filterlist;

  public RemoveRoomfilterWorker(String userid, String password, List<String> filterlist) {
    this.filterlist = List.copyOf(filterlist);
    this.userid = userid;
    this.password = password;
  }



  @Override
  protected Boolean doInBackground() throws Exception {

    Form form = new Form();
    form.param("userid", userid).param("password", password)
        .param("filterlist", Wrapper.toString(filterlist));

    try(Client client = ClientBuilder.newClient()) {
      WebTarget target = client
          .target(Constants.PROTOCOL + Constants.DOMAIN + "/javacommserver/administrator/remove/roomfilter");
      try(Response response = target.request(MediaType.TEXT_PLAIN).post(Entity.form(form))) {
        boolean result = response.readEntity(Boolean.class);
        return result;
      }
    }
  }

}
