/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.client.base;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import javax.swing.SwingWorker;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import net.javacomm.restserver.MessageBodyTransferConfig;
import net.javacomm.share.Constants;
import net.javacomm.transfer.TransferConfig;



/**
 * Dieser Webservice (Jersey) liest die Konfigurationseinstellungen aus.
 */
public class ReadKonfigurationsdatenWorker extends SwingWorker<TransferConfig, Void> {

  private String userid;
  private String password;

  /**
   * Webservice initialisieren
   * 
   * @param userid
   *                 diese userid
   * @param password
   *                 dieses Passwort
   */
  public ReadKonfigurationsdatenWorker(String userid, String password) {
    this.userid = userid;
    this.password = password;
  }



  @Override
  protected TransferConfig doInBackground() throws Exception {
    try(Client client = ClientBuilder.newClient()) {
      client.register(MultiPartFeature.class);
      client.register(MessageBodyTransferConfig.class);

      StringBuilder url = new StringBuilder();
      url.append(Constants.PROTOCOL).append(Constants.DOMAIN)
          .append("/javacommserver/administrator/read/config");

      WebTarget webtarget = client.target(url.toString());
      try(FormDataMultiPart multipart = new FormDataMultiPart()) {
        multipart.field("userid", userid);
        multipart.field("password", password);
        return webtarget.request(MediaType.APPLICATION_JSON)
            .post(Entity.entity(multipart, multipart.getMediaType()), TransferConfig.class);
      }
    }
  }

}
