/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.client.base;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.util.ArrayList;
import javax.swing.SwingWorker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import net.javacomm.restserver.MessageBodyTransferRoomfilter;
import net.javacomm.share.Constants;
import net.javacomm.transfer.TransferRoomfilter;



/**
 * Dieser Webservice (Jersey) liest Raumfilter aus.
 */
public class ReadRoomfilterWorker extends SwingWorker<ArrayList<TransferRoomfilter>, Void> {

  private final static Logger log = LogManager.getLogger(ReadRoomfilterWorker.class);

  private String password;
  private String userid;

  /**
   * Webservice initialisieren
   * 
   * @param userid
   *                 diese userid
   * @param password
   *                 dieses Passwort
   */
  public ReadRoomfilterWorker(String userid, String password) {
    this.userid = userid;
    this.password = password;
  }



  @Override
  protected ArrayList<TransferRoomfilter> doInBackground() throws Exception {

    GenericType<ArrayList<TransferRoomfilter>> configType = new GenericType<>() {};
    ArrayList<TransferRoomfilter> result = null;
    try(
      Client client = ClientBuilder.newClient();
      FormDataMultiPart multipart = new FormDataMultiPart()
    ) {
      client.register(MessageBodyTransferRoomfilter.class);
      client.register(MultiPartFeature.class);
      multipart.field("userid", userid);
      multipart.field("password", password);

      WebTarget webtarget = client
          .target(Constants.PROTOCOL + Constants.DOMAIN + "/javacommserver/administrator/read/roomfilter");

      result = webtarget.request(MediaType.APPLICATION_JSON)
          .post(Entity.entity(multipart, multipart.getMediaType()), configType);
      return result;
    }

  }

}
