/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.filetransfer;

import java.util.EventObject;



/**
 * Allerhand Dinge, die in einem Channel passieren können.
 * 
 * @author llange
 *
 */
public class ChannelEvent extends EventObject {

  public enum Status {STARTED, PROGRESSED, CANCELED, FINISHED, CLOSED};


  
  private static final long serialVersionUID = 4507662889678734105L;
  
  private int progress;
  private Status status;
  private String errorMessage;

  
  /**
   * Ein Ereignis im Channel.
   * 
   * @param source
   *               das auslösende Objekt
   */
  public ChannelEvent(Object source) {
    super(source);
  }

  
  
  /**
   * Ein Ereignis im Channel.
   * 
   * @param source
   *                 das auslösende Objekt
   * @param id
   *                 warum wurde das Ereignis ausgelöst?
   * @param progress
   *                 der aktuelle Fortschritt
   */
  public ChannelEvent(Object source, Status id, int progress) {
    this(source);
    this.progress = progress;
    status = id;
  }
  

  public ChannelEvent(Object source, Status id, int progress, String errorMessage) {
    this(source, id, progress);
    this.errorMessage = errorMessage;
  }
  

  
  /**
   * Ein Ereignis im Channel.
   * 
   * @param source
   *               das auslösende Objekt
   * @param id
   *               warum wurde das Ereignis ausgelöst?
   */
  public ChannelEvent(Object source, Status id) {
    this(source);
    status = id;
  }

  

  
  public String getErrorMessage() {
    return errorMessage;
  }
  
  
  /**
   * Was ist passiert?
   * 
   * @return der Status
   */
  public Status getStatus() {
    return status;
  }

  
  
  /**
   * Der Übertragungsfortschritt in Prozent [%].
   * 
   * @return ein Wert von[0..100]
   */
  public int getProgress() {
    return progress;
  }
  
}
