/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.filetransfer;

import java.util.EventListener;


public interface ChannelListener extends EventListener {
  
  /**
   * Der Channel ist nicht mehr zu gebrauchen.
   * 
   * @param event ein Ereignis auf dem Channel
   */
  public void onError(ChannelEvent event);
  
  
  /**
   * 
   * Eine Übertragung wurde vollständig abgeschlossen.
   * 
   * @param event
   *              ein Ereignis auf dem Channel
   */
  public void onFinished(ChannelEvent event);
  
  
  /**
   * Der Channel ist bereit für Übertragungen.
   * 
   * @param event
   *              ein Ereignis auf dem Channel
   */
  public void onStarted(ChannelEvent event);

  
  /**
   * Die Übertragung ist fortgeschritten.
   * 
   * @param event
   *              der Auslöser
   */
  public void onProgressed(ChannelEvent event);
  
  
  
  /**
   * Der Channel wurde geschlossen. Die Verbindung zum Server wurde geschlossen.
   * 
   * @param event
   *              der Auslöser
   */
  public void onClosed(ChannelEvent event);

}
