/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.filetransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;


public class FileFoundSelection implements Transferable {

	private final static Logger log = LogManager.getLogger(FileFoundSelection.class);
	
	private GefundeneDatei filefound;
	
	static final DataFlavor[] flavor = new DataFlavor[1];
	
	static DataFlavor filefoundFlavor; 

	static {
		try {
//		  log.info(String.valueOf(JTrefferliste.class));
//			filefoundFlavor = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType + ";class=net.javacomm.client.filetransfer.GefundeneDatei");
      filefoundFlavor = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType + ";class=" + JTrefferliste.class.getName());
			flavor[0] = filefoundFlavor;
		}
		catch (ClassNotFoundException e) {
			log.warn(e.getMessage());
		}
		
	}
	
	
	public FileFoundSelection(GefundeneDatei value) {
		filefound = value;
	}
	
	
	@Override
	public Object getTransferData(DataFlavor value)
			throws UnsupportedFlavorException, IOException {
	
		if (!isDataFlavorSupported(value)) throw new UnsupportedFlavorException(value);
		
		return filefound;
	}


	@Override
	public DataFlavor[] getTransferDataFlavors() {
		return flavor;
	}


	@Override
	public boolean isDataFlavorSupported(DataFlavor value) {
		int count = flavor.length;
		for (int index = 0; index<count; index++) {
			if (flavor[index].equals(value)) return true;
		}
		return false;	
	}


	
}
