/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.filetransfer;



/**
 * Ein Slot beschreibt ein Dateiübertragungsobjekt. Ein Slot hat eine Nummer,
 * einen Verzeichnispfad und einen Dateinamen. Zwei Slots d�rfen niemals
 * dieselbe Nummer haben. Der Slot kann belegt sein oder frei.
 * 
 * 
 * 
 * @author llange
 *
 */
public class Slot {

  
  private int slotnumber;
  private String sourcepath;
  private String filename;
  private String downloadDir;
  
  
  /**
   * Wenn ein Slot neu erzeugt wird, ist er verfügbar.
   * 
   * 
   */
  public Slot() {
   
  }


  /**
   * Die Slotnummer 0, 1, 2 ....
   * 
   * @return ein Wert
   */
  public int getSlotnumber() {
    return slotnumber;
  }


  /**
   * Jeder Slot hat eine Nummer.
   * 
   * 
   * @param slotnumber ein Wert 0, 1, 2 ....
   */
  public void setSlotnumber(int slotnumber) {
    this.slotnumber = slotnumber;
  }


  /**
   * Der absolute Vezeichnispfad auf eine Datei.
   * 
   * @return ein Verzeichnispfad ohne Dateiname
   */
  public String getSourcepath() {
    return sourcepath;
  }


  /**
   * Der absolute Vezeichnispfad auf den Ursprung der Datei.
   * 
   * @param path ein Verzeichnispfad ohne Dateiname
   */
  public void setSourcepath(String path) {
    this.sourcepath = path;
  }


  public String getFilename() {
    return filename;
  }


  public void setFilename(String filename) {
    this.filename = filename;
  }




  /**
   * 
   * @return ein Dateiverzeichnis
   */
  public String getDownloadDir() {
    return downloadDir;
  }


  
  /**
   * In diesem Verzeichnis wird die zu übertragende Datei abgelegt.
   * 
   * @param downloadDir
   *                    ein Dateiverzeichnis
   */
  public void setDownloadDir(String downloadDir) {
    this.downloadDir = downloadDir;
  }
  
  
}
