/**
 *  Copyright © 2021-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.gui;

import java.awt.Component;
import java.awt.HeadlessException;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;



@SuppressWarnings("serial")
@Deprecated
public class JavacommOptionPane extends JOptionPane {

  protected JavacommOptionPaneUI optionpaneUI;

  public JavacommOptionPane() {
    super();
  }



  public JavacommOptionPane(Object message) {
    super(message);
  }



  public JavacommOptionPane(Object message, int messageType) {
    super(message, messageType);
  }



  public JavacommOptionPane(Object message, int messageType, int optionType, Icon icon) {
    super(message, messageType, optionType, icon, null);
  }



  public JavacommOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options) {
    super(message, messageType, optionType, icon, options, null);
  }



  public JavacommOptionPane(Object message, int messageType, int optionType) {
    super(message, messageType, optionType, null);
  }



  public JavacommOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options, Object initialValue) {
    super(message, messageType, optionType, icon, options, initialValue);
  }



  @Override
  public int getMaxCharactersPerLineCount() {
    return 10;
  }



  @Override
  public void updateUI() {
    optionpaneUI = new JavacommOptionPaneUI();
    super.setUI(optionpaneUI);
  }



  @Deprecated
  public static String showInputDialog(Component parentComponent, Object message, String title,
      int messageType) throws HeadlessException {
    return (String) showInputDialog(parentComponent, message, title, messageType, null, null, null);
  }



  @Deprecated
  public static Object showInputDialog(Component parentComponent, Object message, String title,
      int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue)
      throws HeadlessException {
    JavacommOptionPane pane = new JavacommOptionPane(
        message, messageType, OK_CANCEL_OPTION, icon, null, null
    );

    pane.setWantsInput(true);
    pane.setSelectionValues(selectionValues);
    pane.setInitialSelectionValue(initialSelectionValue);
    pane.setComponentOrientation(
        ((parentComponent == null) ? getRootFrame() : parentComponent).getComponentOrientation()
    );

    int style = styleFromMessageType(messageType);
//    JDialog dialog = pane.createDialog(parentComponent, title, style);
    JDialog dialog = pane.createDialog(parentComponent, title);

    pane.selectInitialValue();
    dialog.setVisible(true);
    dialog.dispose();

    Object value = pane.getInputValue();

    if (value == UNINITIALIZED_VALUE) {
      return null;
    }
    return value;
  }



  private static int styleFromMessageType(int messageType) {
    switch(messageType) {
      case ERROR_MESSAGE:
        return JRootPane.ERROR_DIALOG;
      case QUESTION_MESSAGE:
        return JRootPane.QUESTION_DIALOG;
      case WARNING_MESSAGE:
        return JRootPane.WARNING_DIALOG;
      case INFORMATION_MESSAGE:
        return JRootPane.INFORMATION_DIALOG;
      case PLAIN_MESSAGE:
      default:
        return JRootPane.PLAIN_DIALOG;
    }
  }

}
