/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.gui;

import javax.swing.JSlider;



public class Videoslider extends JSlider {

  private static final long serialVersionUID = -5037664279784540748L;
  public final static int OUTSIDE_TRACK = -1;

  private VideosliderUI videosliderUI;

  public Videoslider() {
    super();
    init();
  }



  public Videoslider(int orientation) {
    super(orientation);
    init();
  }



  public Videoslider(int min, int max) {
    super(min, max);
    init();
  }



  public Videoslider(int min, int max, int value) {
    super(min, max, value);
    init();
  }



  /**
   * Gib die maximale Zeit in Pixel zurück.
   * 
   * @return die Zeitdauer in Pixel
   */
  public int getMaxTimevalue() {
    if (videosliderUI == null) return 0;
    return videosliderUI.getMaxTimevalue();
  }



  /**
   * Gib die aktuelle Timerposition auf der Trackleiste zurück.
   * 
   * @return die Pixelposition [0..x] für Videoformate, für Audioformat ist der
   *         Wert immer 0
   */
  public int getTimerposition() {
    return videosliderUI.getTimerposition();
  }



  private void init() {}



  /**
   * Bezieht sich der Schieberegler auf ein Videoformat? Miniaturbilder werden nur
   * f�r Videobilder ausgegeben.
   * 
   * @param value
   *              {@code true}, ist ein Videoformat
   */
  public void isVideoformat() {
    updateUI();
  }



  @Override
  public void updateUI() {
    videosliderUI = new VideosliderUI(this);
//    if (isVideo) {
//      videosliderUI.addVidosliderListener((event) -> {
//        //      log.info("(" + videosliderUI.getMousePoint().x + "/" + videosliderUI.getMousePoint().y + ")");
//        //      log.info("maxZeit in Pixel : " + videosliderUI.getMaxTimevalue());
//        //      log.info("   Zeit in Pixel : " + videosliderUI.getTimerposition());
//        timerposition = videosliderUI.getTimerposition();
//      });
//    }
    setUI(videosliderUI);
    // Update UI for slider labels. This must be called after updating the
    // UI of the slider. Refer to JSlider.updateUI().
    updateLabelUIs();
  }



  /**
   * Die Länge des Schiebereglers wird in Pixel gemessen und auf 0.0 bis 1.0
   * abgebildet. Die Gesamtzahl der Pixel entspricht der Position 1.0 im
   * Mediaplayer. Die Gesamtzahl der Pixel kann variieren, wenn sich die
   * Komponentengröße des Schiebereglers ändert.
   * 
   * @param pixel
   *                     die Gesamtzahl der Pixel;
   * @param countThreads
   *                     die Anzahl der Threads
   * 
   * @return die Bildbereiche
   * 
   * @throws BalancerException
   *                           es gibt mehr Threads als Pixel
   * 
   * @deprecated wird nicht verwendet
   */
  @Deprecated
  public static Snapshot[] createBalancer(int pixel, int countThreads) throws BalancerException {
    if (
      countThreads > pixel
    ) throw new BalancerException(
        "Es gibt mehr Threads als Pixels - Threads: " + countThreads + " Pixel: " + pixel
    );
    Snapshot[] snap = new Snapshot[countThreads];
    for (int index = 0; index < countThreads; index++) {
      snap[index] = new Snapshot();
    }
    for (int snapindex = 0; snapindex < pixel; snapindex++) {
      snap[snapindex % countThreads].getBilder().add(snapindex);
    }
    return snap;
  }

}
