/**
 *  Copyright © 2026, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.client.streams;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.WindowConstants;
import javax.swing.text.PlainDocument;
import org.nexuswob.gui.InputDocument;
import org.nexuswob.gui.UrlDocumentFilter;
import org.nexuswob.gui.swing.JavacommInternalFrame;
import net.javacomm.multilingual.Babelfish;
import net.javacomm.multilingual.MultilingualButton;
import net.javacomm.multilingual.MultilingualLabel;
import net.javacomm.multilingual.schema.ISO639;
import net.javacomm.multilingual.schema.KEY;
import net.javacomm.window.manager.Control;



/**
 * Über StreamAssignFrame werden Livestreams eingerichtet. Ein Name und eine URL
 * werden eingetragen.
 */
@SuppressWarnings("serial")
public class InternalAssignFrame extends JavacommInternalFrame implements Babelfish {

  final static int StreamDialogWidth = 720;
  final static int StreamDialogHeight = 330;
  private final static int LEN = 30;

  private JPanel mainpanel = new JPanel();
  private GridBagLayout gridbag = new GridBagLayout();
  private GridBagConstraints con = new GridBagConstraints();
  private MultilingualLabel labelStreamname = new MultilingualLabel(KEY.LABEL_STREAM_NAME);
  private MultilingualLabel labelUrl = new MultilingualLabel(KEY.LABEL_STREAM_URL);
  private JTextField textfieldStreamName = new JTextField(20);
  private JTextField textfieldUrl = new JTextField(40);
  private PlainDocument textfieldUrlDocument;
  private JSeparator separator = new JSeparator();
  private MultilingualButton buttonClose = new MultilingualButton(KEY.BUTTON_SCHLIESSEN);
  private MultilingualButton buttonSave = new MultilingualButton(KEY.BUTTON_SPEICHERN);
  private MultilingualButton buttonUnassign = new MultilingualButton(KEY.BUTTON_FREIGEBEN);
  private JPanel buttonPanel = new JPanel(new GridLayout(1, 3, 12, 0));
  private PropertyChangeSupport changes = new PropertyChangeSupport(this);

  public InternalAssignFrame() {
    this("");
  }



  /**
   * Der StreamDialog Wird eingerichtet. Der Dialog ist modal.
   * 
   * @param title
   *              der Name vom Dialog
   */
  public InternalAssignFrame(String title) {
    super(title);
    init();
  }



  public void addInternalAssignFrameListener(PropertyChangeListener listener) {
    changes.addPropertyChangeListener(listener);
  }



  @Override
  public Dimension getMinimumSize() {
    return new Dimension(StreamDialogWidth - 80, StreamDialogHeight - 30);
  }



  @Override
  public Dimension getPreferredSize() {
    return new Dimension(StreamDialogWidth, StreamDialogHeight);
  }



  /**
   * Returns the Stream Name.
   * 
   * @return the Stream Name
   */
  String getStreamName() {
    return textfieldStreamName.getText();
  }



  /**
   * Returns the Stream URL.
   * 
   * @return the URL
   */
  String getStreamUrl() {
    return textfieldUrl.getText();
  }



  private void init() {
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    setContentPane(mainpanel);
    mainpanel.setLayout(gridbag);

    con.insets = new Insets(24, 12, 0, 12);
    con.gridx = 0;
    con.gridy = 0;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.NONE;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.anchor = GridBagConstraints.WEST;
    gridbag.setConstraints(labelStreamname, con);
    mainpanel.add(labelStreamname);

    con.insets = new Insets(0, 12, 0, 12);
    con.gridx = 0;
    con.gridy++;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.NONE;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.anchor = GridBagConstraints.WEST;
    gridbag.setConstraints(textfieldStreamName, con);
    mainpanel.add(textfieldStreamName);
    textfieldStreamName.setDocument(new InputDocument(LEN));

    con.insets = new Insets(24, 12, 0, 12);
    con.gridx = 0;
    con.gridy++;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.NONE;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.anchor = GridBagConstraints.WEST;
    gridbag.setConstraints(labelUrl, con);
    mainpanel.add(labelUrl);

    con.insets = new Insets(0, 12, 0, 12);
    con.gridx = 0;
    con.gridy++;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.HORIZONTAL;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.anchor = GridBagConstraints.WEST;
    gridbag.setConstraints(textfieldUrl, con);
    mainpanel.add(textfieldUrl);
    textfieldUrlDocument = (PlainDocument) textfieldUrl.getDocument();
    textfieldUrlDocument.setDocumentFilter(new UrlDocumentFilter());

    con.insets = new Insets(24, 12, 0, 12);
    con.gridx = 0;
    con.gridy++;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.HORIZONTAL;
    con.weightx = 1.0;
    con.weighty = 0.0;
    con.anchor = GridBagConstraints.NORTHWEST;
    gridbag.setConstraints(separator, con);
    mainpanel.add(separator);

    buttonPanel.add(buttonSave);
    buttonSave.addActionListener(event -> {
      changes.firePropertyChange(InternalAssignFrame.class.getName(), Control.NULL, Control.SAVE);
      InternalAssignFrame.this.doDefaultCloseAction();
    });
    buttonPanel.add(buttonClose);
    buttonClose.addActionListener(event -> {
      InternalAssignFrame.this.doDefaultCloseAction();
    });

    con.insets = new Insets(24, 12, 12, 12);
    con.gridx = 0;
    con.gridy++;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.NONE;
    con.weightx = 1.0;
    con.weighty = 0.0;
    con.anchor = GridBagConstraints.NORTHEAST;
    gridbag.setConstraints(buttonPanel, con);
    mainpanel.add(buttonPanel);

  }



  public void removeAllListener() {
    Arrays.stream(changes.getPropertyChangeListeners()).forEach(listener -> {
      removeInternalAssignFrameListener(listener);
    });
  }



  public void removeInternalAssignFrameListener(PropertyChangeListener listener) {
    changes.removePropertyChangeListener(listener);
  }



  @Override
  public void setLanguage(ISO639 code) {
    buttonClose.setLanguage(code);
    buttonSave.setLanguage(code);
    buttonUnassign.setLanguage(code);
    labelStreamname.setLanguage(code);
    labelUrl.setLanguage(code);
  }



  /**
   * Dieser Stream Name wird angezeigt.
   * 
   * @param streamName
   *                   diser Streamname
   */
  void setStreamName(String streamName) {
    textfieldStreamName.setText(streamName);
  }



  /**
   * Diese URL wird angezeigt.
   * 
   * @param url
   *            diese URL
   */
  void setStreamUrl(String url) {
    textfieldUrl.setText(url);
  }



  /**
   * Der Programmknopf kann wieder freigegeben werden.
   */
  public void setUnassignedPossible() {
    buttonPanel.removeAll();
    buttonPanel.add(buttonSave);
    buttonPanel.add(buttonUnassign);
    buttonUnassign.addActionListener(event -> {
      changes.firePropertyChange(InternalAssignFrame.class.getName(), Control.NULL, Control.UNASSIGN_STREAM);
      doDefaultCloseAction();
    });
    buttonPanel.add(buttonClose);
  }

}
