/**
 *  Copyright © 2021-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.streams;

import javax.swing.JButton;



/**
 * Der Programmauswahlknopf für einen Sender. In der Grundeinstellung ist dem
 * Knopf noch kein Sendercode und keine URL zugewiesen.
 * 
 * 
 * @author llange
 *
 */
public class StreamButton extends JButton {

  private static final long serialVersionUID = -1269908316447589195L;

  private Integer code;
  private String url;

  public StreamButton() {
    super();
  }



  /**
   * Der Knopfname in der Senderauswahl.
   * 
   * 
   * @param sendername
   *                   ein Fernsehprogrammname
   */
  public StreamButton(String sendername) {
    super(sendername);
  }



  /**
   * Der Sendercode ist eine Zahl wie auf einer Fernbedienung. Der Rückgabewert
   * kann {@code null} sein, wenn der Knopf keinem Sender zugeordnet werden kann.
   * 
   * @return der Sendercode
   */
  public Integer getCode() {
    return code;
  }



  public void setCode(Integer code) {
    this.code = code;
  }



  /**
   * Über diese Url wird das Programm empfangen. Der Rückgabewert kann
   * {@code null} sein, wenn der Knopf keinem Sender zugeordnet werden kann.
   * 
   * @return die Sender URL
   */
  public String getStreamURL() {
    return url;
  }



  /**
   * Die StreamURL wird gesetzt. Der Wert darf {@code null} sein, wenn der Knopf
   * nicht belegt ist.
   * 
   * @param value
   *              diese StreamURL
   */
  public void setStreamURL(String value) {
    url = value;
  }

}
