/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.telko;

import javax.sound.sampled.LineUnavailableException;
import net.javacomm.client.phone.MixerNotFoundException;
import net.javacomm.client.phone.Speaker;
import net.javacomm.client.phone.Telefonformat;



/**
 * Diese Klasse wird für Telefonkonferenzen verwendet. Für jeden
 * Konferenzteilnehmer muss eine separate Lautsprecherleitung eingerichtet
 * werden.
 */
public class ConferenceSpeaker extends Speaker {

  private String userid;

  /**
   * Der Lautsprecher wird für einen Absender eingerichtet. Für jeden Absender
   * wird eine Mixerleitung geöffnet. Über die {@code userid} wird die Leitung
   * identifiziert.
   * 
   * @param speakername
   *                      dieser Lautsprechername
   * @param telefonformat
   *                      dieses Telefonformat
   * @param userid
   *                      diese Userid
   * 
   * @throws MixerNotFoundException
   *                                  für diesen Lautsprecher konnte kein Mixer
   *                                  gefunden werden
   * @throws LineUnavailableException
   *                                  diese Leitung ist belegt oder wird von einer
   *                                  anderen Anwendung benutzt
   */
  public ConferenceSpeaker(String speakername, Telefonformat telefonformat, String userid)
      throws MixerNotFoundException, LineUnavailableException {

    super(speakername, telefonformat);
    this.userid = userid;
  }



  public String getUserid() {
    return userid;
  }

}
