/**
 *  Copyright © 2022-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.telko;

/**
 * Wird geworfen, wenn der Konferenzname {@code null} ist.
 * 
 * @author llange
 *
 */
public class KonferenznameException extends Exception {

  private static final long serialVersionUID = 4694922184661538660L;

  public KonferenznameException() {}



  public KonferenznameException(String message) {
    super(message);
  }



  public KonferenznameException(String message, Exception e) {
    super(message, e);
  }



  public KonferenznameException(Throwable t) {
    super(t);
  }



  public KonferenznameException(String message, Throwable t) {
    super(message, t);
  }

}
