/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.telko;

import java.beans.PropertyVetoException;
import javax.swing.JOptionPane;
import javax.swing.WindowConstants;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import net.javacomm.client.screencaster.ProjektorInternalFrame;
import net.javacomm.multilingual.MultilingualString;
import net.javacomm.multilingual.schema.ISO639;
import net.javacomm.multilingual.schema.KEY;
import net.javacomm.window.manager.Control;
import net.javacomm.window.manager.Frames;



/**
 * Dieser Frame wird für die Videokonferenz verwendet.
 */
@SuppressWarnings("serial")
public class TelkoProjektorInternalFrame extends ProjektorInternalFrame {

  private final static Logger log = LogManager.getLogger(TelkoProjektorInternalFrame.class);

  private String nickname;
  private MultilingualString justHangup = new MultilingualString(KEY.STRING_JUST_HANG_UP);
  private MultilingualString hinweis = new MultilingualString(KEY.STRING_HINWEIS);
  private boolean flag = false;

  public TelkoProjektorInternalFrame() {
    this("");
    setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
    removeInternalFrameListener(internalFrameAdapter); // internalFrameAdapter aus der Superclass
    internalFrameAdapter = new InternalFrameAdapter() {

      @Override
      public void internalFrameClosing(InternalFrameEvent e) {

        if (flag) {
          changes.firePropertyChange(ProjektorInternalFrame.class.getName(), Control.NULL, Control.CLOSE);
        }
        else {
          JOptionPane.showMessageDialog(
              TelkoProjektorInternalFrame.this, justHangup.toString(), hinweis.toString(),
              JOptionPane.INFORMATION_MESSAGE
          );
        }
      }

    };
    addInternalFrameListener(internalFrameAdapter);

  }



  @Override
  public void closeWindow() {
    flag = true;
    try {
      setClosed(true);
    }
    catch (PropertyVetoException e) {}
  }



  public TelkoProjektorInternalFrame(String nickname) {
    setNickname(nickname);
  }



  @Override
  public Frames getType() {
    return Frames.TELKOPROJEKTOR;
  }



  @Override
  public void setLanguage(ISO639 code) {
    setLanguage(KEY.FRAME_VIDEOKONFERNEZ, code, nickname);
    treeView(code);
    justHangup.setLanguage(code);
    hinweis.setLanguage(code);
  }



  /**
   * Der Nickname erscheint in der Baumansicht und im Framenamen.
   * 
   * @param nickname
   *                 dieser Nickname
   */
  public void setNickname(String nickname) {
    this.nickname = nickname;
  }

}
