/**
 *  Copyright © 2024-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.websocket;

/**
 * Wird geworfen, wenn der Server die Verbindung schließt.
 */
@SuppressWarnings("serial")
public class WebsocketCloseException extends Exception {

  /**
   * Der Server hat die Verbindung gekappt.
   * 
   */
  public WebsocketCloseException() {}



  /**
   * Der Server hat die Verbindung gekappt.
   * 
   * @param message
   *                Fehlernachricht
   */
  public WebsocketCloseException(String message) {
    super(message);
  }



  /**
   * Der Server hat die Verbindung gekappt.
   * 
   * @param cause
   *              Fehlerursache
   */
  public WebsocketCloseException(Throwable cause) {
    super(cause);
  }



  /**
   * Der Server hat die Verbindung gekappt.
   * 
   * @param message
   *                Fehlernachricht
   * @param cause
   *                Fehlerursache
   */
  public WebsocketCloseException(String message, Throwable cause) {
    super(message, cause);
  }



  /**
   * Der Server hat die Verbindung gekappt.
   * 
   * @param message
   *                           Fehlernachricht
   * @param cause
   *                           Fehlerursache
   * @param enableSuppression
   * @param writableStackTrace
   *                           Fehlerverfolgung aktivieren oder deaktivieren
   */
  public WebsocketCloseException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
    super(message, cause, enableSuppression, writableStackTrace);
  }

}
