/**
 *  Copyright © 2026, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 */
package net.javacomm.database;

/**
 * Wird geworfen, wenn ein Mailingport nicht unterstützt wird.
 */
@SuppressWarnings("serial")
public class MailportException extends Exception {
  /**
   * Dieser Port wird nicht unterstützt.
   * 
   * @param message
   *                Fehlernachricht
   */
  public MailportException(String message) {
    super(message);
  }



  /**
   * Dieser Port wird nicht unterstützt.
   * 
   * @param cause
   *              Fehlerursache
   */
  public MailportException(Throwable cause) {
    super(cause);
  }



  /**
   * Dieser Port wird nicht unterstützt.
   * 
   * @param message
   *                Fehlernachricht
   * @param cause
   *                Fehlerursache
   */
  public MailportException(String message, Throwable cause) {
    super(message, cause);
  }



  /**
   * Dieser Port wird nicht unterstützt.
   * 
   * @param message
   *                           Fehlernachricht
   * @param cause
   *                           Fehlerursache
   * @param enableSuppression
   * @param writableStackTrace
   *                           Fehlerverfolgung aktivieren oder deaktivieren
   */
  public MailportException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
    super(message, cause, enableSuppression, writableStackTrace);
  }

}
