/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.database;

import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import net.javacomm.database.sqlmapper.SQL;
import net.javacomm.database.sqlmapper.SQLMAPPER;
import net.javacomm.environment.Environment;



/**
 *
 * Jeder Schlüssel ist mit einem Datenbankbefehl verknüpft. Der Datenbankbefehl
 * liegt in der Datei <b>sqlmapper.xml</b>.
 *
 * @author llange
 *
 */
public class Persistence {

  private final static Logger log = LogManager.getLogger(Persistence.class);

  public final static String KEY_UPDATE_CONFIRM_PASSWORD = "KEY_UPDATE_CONFIRM_PASSWORD";
  public final static String KEY_CREATE_ROOM = "KEY_CREATE_ROOM";
  public final static String KEY_READ_ROOMS = "KEY_READ_ROOMS";
  public final static String KEY_GROUP_USER = "KEY_GROUP_USER";
  public final static String KEY_USER_CHAT = "KEY_USER_CHAT";
  public final static String KEY_DELETE_GRUPPE_USER = "KEY_DELETE_GRUPPE_USER";
  public final static String KEY_CREATE_TESTUSER = "KEY_CREATE_TESTUSER";
  public final static String KEY_CREATE_USER = "KEY_CREATE_USER";
  public final static String KEY_IS_PUBLICROOM = "KEY_IS_PUBLICROOM";
  public final static String KEY_IS_PROTECTEDROOM = "KEY_IS_PROTECTEDROOM";
  public final static String KEY_CHECK_PASSWORD = "KEY_CHECK_PASSWORD";
  public final static String KEY_LEAVEROOM = "KEY_LEAVEROOM";
  public final static String KEY_CLEAR_GRUPPE = "KEY_CLEAR_GRUPPE";
  public final static String KEY_FETCH_ROOMLIST = "KEY_FETCH_ROOMLIST";
  public final static String KEY_FETCH_ONLINELIST = "KEY_FETCH_ONLINELIST";
  public final static String KEY_FETCH_HISTORYMESSAGE = "KEY_FETCH_HISTORYMESSAGE";
  public final static String KEY_UPDATE_USER = "KEY_UPDATE_USER";
  public final static String KEY_UPDATE_OWNER = "KEY_UPDATE_OWNER";
  public final static String READ_TOPICROOM_OWNER = "READ_TOPICROOM_OWNER";
  public final static String USERLOGIN = "USERLOGIN";
  public final static String INSERTUSER = "INSERTUSER";
  public final static String KEY_TOPICMEMBER = "KEY_TOPICMEMBER";
  public final static String KEY_CANDIDATE_MEMBER = "KEY_CANDIDATE_MEMBER";
  public final static String KEY_CHANGE_TOPICMEMBER = "KEY_CHANGE_TOPICMEMBER";
  public final static String KEY_IS_ROOM_EXISTS = "KEY_IS_ROOM_EXISTS";
  public final static String KEY_FETCHUSER = "KEY_USERNICKNAME";
  public final static String KEY_DELETE_ROOM = "KEY_DELETE_ROOM";
  public final static String KEY_DELETE_RECORD = "KEY_DELETE_RECORD";
  public final static String KEY_DELETEALL_USER_CHAT = "KEY_DELETEALL_USER_CHAT";
  public final static String KEY_DELETE_TEMPROOMS = "KEY_DELETE_TEMPROOMS";
  public final static String KEY_FETCH_LIFETIME = "KEY_FETCH_LIFETIME";
  public final static String KEY_CALL_REMOTEUSER = "KEY_CALL_REMOTEUSER";
  public final static String KEY_FETCH_USERONLINELIST = "KEY_FETCH_USERONLINELIST";
  public final static String KEY_COUNT_TEMPROOM_USER = "KEY_COUNT_TEMPROOM_USER";
  public final static String KEY_FETCH_TEMPROOMS = "KEY_FETCH_TEMPROOMS";
  public final static String KEY_INSERT_SESSIONIDS = "KEY_INSERT_SESSIONIDS";
  public final static String KEY_FETCH_USER = "KEY_FETCH_USER";
  public final static String KEY_DELETE_USER = "KEY_DELETE_USER";
  public final static String KEY_DELETE_INACTIVE_USER = "KEY_DELETE_INACTIVE_USER";
  public final static String KEY_LAST_LOGIN = "KEY_LAST_LOGIN";
  public final static String KEY_FETCH_USER_BY_SESSIONID = "KEY_FETCH_USER_BY_SESSIONID";
  public final static String KEY_DELETE_ONLINE = "KEY_DELETE_ONLINE";
  public final static String KEY_DELETE_USER_CHATROOMS = "KEY_DELETE_USER_CHATROOMS";
  public final static String KEY_DELETE_TRANSFERLIB = "KEY_DELETE_TRANSFERLIB";
  public final static String KEY_DELETE_UPLOADFILES = "KEY_DELETE_UPLOADFILES";
  public final static String KEY_INSERT_UPLOADFILES = "KEY_INSERT_UPLOADFILES";
  public final static String KEY_FETCH_FILE_BY_NUMBER = "KEY_FETCH_FILE_BY_NUMBER";
  public final static String KEY_UPDATE_PORT = "KEY_UPDATE_PORT";
  public final static String KEY_INSERT_CHATMESSAGE = "KEY_INSERT_CHATMESSAGE";
  public final static String KEY_DELETE_RECORDS = "KEY_DELETE_RECORDS";
  public final static String KEY_SELECT_HOURS = "KEY_SELECT_HOURS";
  public final static String KEY_DELETE_PRIVATECHATS = "KEY_DELETE_PRIVATECHATS";
  public final static String KEY_FETCH_REMOTESESSION = "KEY_FETCH_REMOTESESSION";
  public final static String KEY_DELETE_REMOTE_LOCAL = "KEY_DELETE_REMOTE_LOCAL";
  public final static String KEY_DELETE_USER_CHATS = "KEY_DELETE_USER_CHATS";
  public final static String KEY_DELETE_ALL_PRIVATECHATS = "KEY_DELETE_ALL_PRIVATECHATS";
  public final static String KEY_DELETE_ALL_ONLINE = "KEY_DELETE_ALL_ONLINE";
  public final static String KEY_DELETE_ALL_ROOMS_WITHOUT_EXISTING_OWNER = "KEY_DELETE_ALL_ROOMS_WITHOUT_EXISTING_OWNER";
  public final static String KEY_SIGNIN_PRESENT = "KEY_SIGNIN_PRESENT";
  public final static String KEY_CREATE_CONFIRMATION_KEY = "KEY_CREATE_CONFIRMATION_KEY";
  public final static String KEY_UPDATE_CONFIRMATION_FLAG = "KEY_UPDATE_CONFIRMATION_FLAG";
  public final static String KEY_DELETE_CONFIRMATION_FLAG = "KEY_DELETE_CONFIRMATION_FLAG";
  public final static String KEY_CONFIRMATION_FLAG_PRESENT = "KEY_CONFIRMATION_FLAG_PRESENT";
  public final static String KEY_SELECT_NEUES_PASSWORD = "KEY_SELECT_NEUES_PASSWORD";
  public final static String KEY_UPDATE_PASSWORD = "KEY_UPDATE_PASSWORD";
  public final static String KEY_FETCH_CHATUSERLIST = "KEY_FETCH_CHATUSERLIST";
  public final static String KEY_FETCH_ONLINE_ROOMLIST = "KEY_FETCH_ONLINE_ROOMLIST";
  public final static String KEY_CLEAR_TRANSFERLIB = "KEY_CLEAR_TRANSFERLIB";
  public final static String KEY_FORBIDDEN_ROOMS = "KEY_FORBIDDEN_ROOMS";
  public final static String KEY_FORBIDDEN_ROOM = "KEY_FORBIDDEN_ROOM";
  public final static String KEY_FETCH_SESSIONLIST = "KEY_FETCH_SESSIONLIST";
  public final static String KEY_SEARCH_FILES = "KEY_SEARCH_FILES";
  public final static String KEY_COUNT_ONLINE = "KEY_COUNT_ONLINE";
  public final static String KEY_DELETE_FORBIDDEN_ROOM = "KEY_DELETE_FORBIDDEN_ROOM";
  public final static String KEY_DELETE_ALL_USER = "KEY_DELETE_ALL_USER";
  public final static String KEY_DIAL = "KEY_DIAL";
  public final static String KEY_IS_ON_CALL = "KEY_IS_ON_CALL";
  public final static String SESSIONID_BY_NICKNAME = "SESSIONID_BY_NICKNAME";
  public final static String KEY_IS_ON_BUSY = "KEY_IS_ON_BUSY";
  public final static String KEY_SESSIONID_BY_USERID = "KEY_SESSIONID_BY_USERID";
  public final static String KEY_ONBUSY = "KEY_ONBUSY";
  public final static String KEY_IS_ON_BUSY_BY_UID = "KEY_IS_ON_BUSY_BY_UID";
  public final static String KEY_DELETE_TOPHONE = "KEY_DELETE_TOPHONE";
  public final static String KEY_INSERT_TOPHONE = "KEY_INSERT_TOPHONE";
  public final static String KEY_FIND_PARTNER_USERID = "KEY_FIND_PARTNER_USERID";
  public final static String KEY_DELETE_PARTNER_USERID = "KEY_DELETE_PARTNER_USERID";
  public final static String KEY_CALLER_TOPHONE = "KEY_CALLER_TOPHONE";
  public final static String FETCH_SUFFIXES = "FETCH_SUFFIXES";
  public final static String CREATE_USER_FILE_BLACKLIST = "CREATE_USER_FILE_BLACKLIST";
  public final static String KEY_FETCH_SUFFIXES = "KEY_FETCH_SUFFIXES";
  public final static String KEY_FIND_NIRVANA_SUFFIXES = "KEY_FIND_NIRVANA_SUFFIXES";
  public final static String KEY_UPDATE_SUFFIXES = "KEY_UPDATE_SUFFIXES";
  public final static String KEY_CREATE_BLACKLIST = "KEY_CREATE_BLACKLIST";
  public final static String KEY_UPDATE_BLACKLIST = "KEY_UPDATE_BLACKLIST";
  public final static String KEY_FETCH_USER_BLACKLIST = "KEY_FETCH_USER_BLACKLIST";
  public final static String KEY_DELETE_USER_SUFFIXES = "KEY_DELETE_USER_SUFFIXES";
  public final static String KEY_ROOMTYPE = "KEY_ROOMTYPE";
  public final static String KEY_READ_BREAKROOMS = "KEY_READ_BREAKROOMS";
  public final static String KEY_DELETE_TEMPROOM = "KEY_DELETE_TEMPROOM";
  public final static String KEY_READ_CONFIG = "KEY_READ_CONFIG";
  public final static String KEY_UPDATE_CONFIG = "KEY_UPDATE_CONFIG";
  public final static String KEY_UPDATE_BENUTZERSTATUS = "KEY_UPDATE_BENUTZERSTATUS";
  public final static String KEY_DELETE_BENUTZERSTATUS = "KEY_DELETE_BENUTZERSTATUS";
  public final static String KEY_INFORM_ADMIN = "KEY_INFORM_ADMIN";
  public final static String KEY_READ_CONFIRM_MEMBERSHIP = "KEY_READ_CONFIRM_MEMBERSHIP";
  public final static String KEY_CREATE_PASSWORD = "KEY_CREATE_PASSWORD";
  public final static String KEY_CHANGE_TO_FORUM = "KEY_CHANGE_TO_FORUM";
  public final static String KEY_ONLINE_ROOMLIST = "KEY_ONLINE_ROOMLIST";
  public final static String KEY_ISADMIN = "KEY_ISADMIN";
  public final static String FETCH_FORBIDDEN_ROOM = "FETCH_FORBIDDEN_ROOM";
  public final static String KEY_CREATE_TESTUSER2 = "KEY_CREATE_TESTUSER2";
  public final static String KEY_CLEAR_FORBIDDEN_ROOM = "KEY_CLEAR_FORBIDDEN_ROOM";
  public final static String KEY_INSERT_FORBIDDEN_ROOM = "KEY_INSERT_FORBIDDEN_ROOM";
  public final static String KEY_PHONE_VOLUME = "KEY_PHONE_VOLUME";
  public final static String KEY_USER_ONCALL = "KEY_USER_ONCALL";
  public final static String KEY_UPDATE_TELEFONPORT = "KEY_UPDATE_TELEFONPORT";
  public final static String INSERT_FTS_CONFIG = "INSERT_FTS_CONFIG";
  public final static String DELETE_FTS_CONFIG = "DELETE_FTS_CONFIG";
  public final static String CHECK_UID_FTS = "CHECK_UID_FTS";
  public final static String KEY_FORUM_CHECK = "KEY_FORUM_CHECK";
  public final static String KEY_READ_FTS_CONFIG = "KEY_READ_FTS_CONFIG";
  public final static String KEY_UPDATE_FTS_CONFIG = "KEY_UPDATE_FTS_CONFIG";
  public final static String KEY_DELETE_ORPHAINED_FTS_CONFIG = "KEY_DELETE_ORPHAINED_FTS_CONFIG";
  public final static String KEY_UPDATE_PLAYERVOLUME = "KEY_UPDATE_PLAYERVOLUME";
  public final static String KEY_FETCH_PLAYERVOLUME = "KEY_FETCH_PLAYERVOLUME";
  public final static String KEY_WRITE_TELEFON = "KEY_WRITE_TELEFON";
  public final static String KEY_CHATDENIED = "KEY_CHATDENIED";
  public final static String KEY_WRITE_EIS = "KEY_WRITE_EIS";
  public final static String WRITE_FTS_DIRECTORIES = "WRITE_FTS_DIRECTORIES";
  public final static String KEY_WRITE_REKORDER = "KEY_WRITE_REKORDER";
  public final static String KEY_ONLINE_ONRECORD = "KEY_ONLINE_ONRECORD";
  public final static String KEY_WRITE_ONREKORDER = "KEY_WRITE_ONREKORDER";
  public final static String KEY_FETCH_SPEAKER = "KEY_FETCH_SPEAKER";
  public final static String KEY_FETCH_OUTDATED = "KEY_FETCH_OUTDATED";
  public final static String KEY_WRITE_ONPROJEKTOR = "KEY_WRITE_ONPROJEKTOR";
  public final static String KEY_DELETE_SCREENCAST = "KEY_DELETE_SCREENCAST";
  public final static String KEY_ON_PROJEKTOR = "KEY_ON_PROJEKTOR";
  public final static String KEY_INSERT_ON_PROJEKTOR = "KEY_INSERT_ON_PROJEKTOR";
  public final static String KEY_DELETE_SCREENCAST_USER = "KEY_DELETE_SCREENCAST_USER";
  public final static String KEY_SCREENCAST_BY_RECEIVERSESSION = "KEY_SCREENCAST_BY_RECEIVERSESSION";
  public final static String KEY_WRITE_REKORDERPORT = "KEY_WRITE_REKORDERPORT";
  public final static String KEY_FETCH_NICKNAMES = "KEY_FETCH_NICKNAMES";
  public final static String KEY_FETCH_DELETE_NICKNAMES = "KEY_FETCH_DELETE_NICKNAMES";
  public final static String KEY_UPDATE_USER_NICKNAME = "KEY_UPDATE_USER_NICKNAME";
  public final static String KEY_UPDATE_OWNER_NICKNAME = "KEY_UPDATE_OWNER_NICKNAME";
  public final static String KEY_FETCH_IPTV = "KEY_FETCH_IPTV";
  public final static String KEY_WRITE_GLOBAL_ATTRIBUTES = "KEY_WRITE_GLOBAL_ATTRIBUTES";
  public final static String KEY_WRITE_CHATTOOLTIP = "KEY_WRITE_CHATTOOLTIP";
  public final static String KEY_DELETE_ALL_PRIVATE_CHATFILES = "KEY_DELETE_ALL_PRIVATE_CHATFILES";
  public final static String KEY_DELETE_USER_CHATFILES = "KEY_DELETE_USER_CHATFILES";
  public final static String KEY_INSERT_PRIVATE_CHATFILE = "KEY_INSERT_PRIVATE_CHATFILE";
  public final static String KEY_DELETE_PRIVATE_CHATFILES = "KEY_DELETE_PRIVATE_CHATFILES";
  public final static String KEY_UPDATE_CHATFILE = "KEY_UPDATE_CHATFILE";
  public final static String KEY_DELETE_ATTACHMENT = "KEY_DELETE_ATTACHMENT";
  public final static String KEY_DELETE_ORPHAINED_CHATFILES = "KEY_DELETE_ORPHAINED_CHATFILES";
  public final static String KEY_INSERT_CHATFILES = "KEY_INSERT_CHATFILES";
  public final static String KEY_DELETABLE = "KEY_DELETABLE";
  public final static String KEY_UPDATE_CHATFILES = "KEY_UPDATE_CHATFILES";
  public final static String KEY_DELETE_CHATID_CHATFILES = "KEY_DELETE_CHATID_CHATFILES";
  public final static String KEY_MAX_ANLAGE = "KEY_MAX_ANLAGE";
  public final static String KEY_FETCH_ANLAGE = "KEY_FETCH_ANLAGE";
  public final static String KEY_FETCH_ANLAGE_SIZE = "KEY_FETCH_ANLAGE_SIZE";
  public final static String KEY_SCREENCAST_BY_CALLERSESSION = "KEY_SCREENCAST_BY_CALLERSESSION";
  public final static String KEY_CREATE_TELEFONKONFERENZ = "KEY_CREATE_TELEFONKONFERENZ";
  public final static String KEY_DELETE_TELKO = "KEY_DELETE_TELKO";
  public final static String KEY_READ_TELEFONKONFERENZEN = "KEY_READ_TELEFONKONFERENZEN";
  public final static String KEY_DELETE_TELKOS = "KEY_DELETE_TELKOS";
  public final static String KEY_CANDIDATE_KONFERENZRAUM = "KEY_CANDIDATE_KONFERENZRAUM";
  public final static String KEY_INSERT_KONFERENZRAUM = "KEY_INSERT_KONFERENZRAUM";
  public final static String KEY_DELETE_KONFERENZRAUM = "KEY_DELETE_KONFERENZRAUM";
  public final static String KEY_DELETE_TB_FILETRANSFER_CONFIG = "KEY_DELETE_TB_FILETRANSFER_CONFIG";
  public final static String KEY_DELETE_FORCE_TB_RECORD = "KEY_DELETE_FORCE_TB_RECORD";
  public final static String KEY_READ_TEILNEHMER = "KEY_READ_TEILNEHMER";
  public final static String KEY_DELETEALL_KONFERENZRAUM = "KEY_DELETEALL_KONFERENZRAUM";
  public final static String KEY_DELETE_CONFIG = "KEY_DELETE_CONFIG";
  public final static String KEY_INSERT_CONFIG = "KEY_INSERT_CONFIG";
  public final static String KEY_WRITE_TELKO_DESCRIPTION = "KEY_WRITE_TELKO_DESCRIPTION";
  public final static String KEY_WRITE_VERFALLSDATUM = "KEY_WRITE_VERFALLSDATUM";
  public final static String KEY_DELETE_TELKO_TEILNEHMER = "KEY_DELETE_TELKO_TEILNEHMER";
  public final static String KEY_INSERT_NEUE_TEILNEHMER = "KEY_INSERT_NEUE_TEILNEHMER";
  public final static String KEY_FINDE_TEILNEHMER = "KEY_FINDE_TEILNEHMER";
  public final static String KEY_DELETE_KONFERENZTEILNEHMER = "KEY_DELETE_KONFERENZTEILNEHMER";
  public final static String KEY_MEINE_KONFERENZEN = "KEY_MEINE_KONFERENZEN";
  public final static String KEY_KONFERENZRAUM_STATUS = "KEY_KONFERENZRAUM_STATUS";
  public final static String KEY_UPDATE_KONFERENZRAUM_STATUS = "KEY_UPDATE_KONFERENZRAUM_STATUS";
  public final static String KEY_FETCH_KONFERENZRAUM_SESSIONS = "KEY_FETCH_KONFERENZRAUM_SESSIONS";
  public final static String KEY_DELETE_KONFERENZRAUM_SESSIONS = "KEY_DELETE_KONFERENZRAUM_SESSIONS";
  public final static String KEY_BLOCK_CONFERENCE_CALL = "KEY_BLOCK_CONFERENCE_CALL";
  public final static String KEY_GRANT_MODULE = "KEY_GRANT_MODULE";
  public final static String KEY_FETCH_MODULE = "KEY_FETCH_MODULE";
  public final static String KEY_REVOKE_MODULE = "KEY_REVOKE_MODULE";
  public final static String KEY_REVOKE_ALL_MODULES = "KEY_REVOKE_ALL_MODULES";
  public final static String KEY_DELETE_USER_MODULE = "KEY_DELETE_USER_MODULE";
  public final static String KEY_ORPHAINED_KONFERENZRAUM = "KEY_ORPHAINED_KONFERENZRAUM";
  public final static String KEY_IS_ONLINE = "KEY_IS_ONLINE";
  public final static String KEY_FETCH_ODXUSER = "KEY_FETCH_ODXUSER";
  public final static String KEY_UPDATE_ODX_LASTDIR = "KEY_UPDATE_ODX_LASTDIR";
  public final static String KEY_FETCH_ODX_LASTDIR = "KEY_FETCH_ODX_LASTDIR";
  public final static String DELETE_TABLE_USER_ODX = "DELETE_TABLE_USER_ODX";
  public final static String KEY_INSERT_USER_ODX = "KEY_INSERT_USER_ODX";
  public final static String KEY_DELETE_USER_ODX = "KEY_DELETE_USER_ODX";
  public final static String KEY_LDELETE_USER = "KEY_LDELETE_USER";
  public final static String KEY_IS_LDELETE_USER = "KEY_IS_LDELETE_USER";
  public final static String KEY_FETCH_USERS = "KEY_FETCH_USERS";
  public final static String KEY_DELETE_GROUPS = "KEY_DELETE_GROUPS";
  public final static String KEY_DELETE_CHATROOMS = "KEY_DELETE_CHATROOMS";
  public final static String KEY_DELETE_ORPHAINED_TB_ONLINE = "KEY_DELETE_ORPHAINED_TB_ONLINE";
  public final static String KEY_READ_TOPICROOMS = "KEY_READ_TOPICROOMS";
  public final static String KEY_COUNT_BREAKROOMS = "KEY_COUNT_BREAKROOMS";
  public final static String KEY_DELETE_ORPHAINED_TB_TELKO = "KEY_DELETE_ORPHAINED_TB_TELKO";
  public final static String KEY_UPDATE_KEEPALIVE = "KEY_UPDATE_KEEPALIVE";
  public final static String KEEPALIVE_EXPIRED = "KEEPALIVE_EXPIRED";
  public final static String KEY_INSERT_CHUNKS = "KEY_INSERT_CHUNKS";
  public final static String KEY_DELETE_ALL_CHUNKS = "KEY_DELETE_ALL_CHUNKS";
  public final static String KEY_FETCH_CHUNK = "KEY_FETCH_CHUNK";
  public final static String KEY_DELETE_ANLAGE = "KEY_DELETE_ANLAGE";
  public final static String KEY_FETCH_CHUNKNUMBERS = "KEY_FETCH_CHUNKNUMBERS";
  public final static String KEY_DELETE_PRIVATE_CHATFILE_CHUNKS = "KEY_DELETE_PRIVATE_CHATFILE_CHUNKS";
  public final static String KEY_INSERT_PRIVATE_CHUNKS = "KEY_INSERT_PRIVATE_CHUNKS";
  public final static String KEY_FETCH_PRIVATE_CHUNKNUMBERS = "KEY_FETCH_PRIVATE_CHUNKNUMBERS";
  public final static String KEY_FETCH_PRIVATE_ANLAGE_SIZE = "KEY_FETCH_PRIVATE_ANLAGE_SIZE";
  public final static String KEY_DELETE_CHATFILES = "KEY_DELETE_CHATFILES";
  public final static String KEY_FETCH_PRIVATE_CHUNK = "KEY_FETCH_PRIVATE_CHUNK";
  public final static String KEY_TEST_MUTE = "KEY_TEST_MUTE";
  public final static String KEY_UNMUTE_ALL = "KEY_UNMUTE_ALL";
  public final static String KEY_UPDATE_MUTE = "KEY_UPDATE_MUTE";
  public final static String KEY_UPDATE_UNMUTE = "KEY_UPDATE_UNMUTE";
  public final static String KEY_BASE_CONFIG = "KEY_BASE_CONFIG";
  public final static String KEY_FETCH_TELKO = "KEY_FETCH_TELKO";
  public final static String KEY_COUNT_CHATS = "KEY_COUNT_CHATS";
  public final static String KEY_UID_BY_NICKNAME = "KEY_UID_BY_NICKNAME";
  public final static String KEY_FETCH_AGENT = "KEY_FETCH_AGENT";
  public final static String KEY_FETCH_LANGUAGE = "KEY_FETCH_LANGUAGE";
  public final static String KEY_UPDATE_LANGUAGE = "KEY_UPDATE_LANGUAGE";
  public final static String KEY_DELETE_VIDEO = "KEY_DELETE_VIDEO";
  public final static String KEY_DELETE_VIDEO_USER = "KEY_DELETE_VIDEO_USER";
  public final static String KEY_INSERT_SENDER_RECEIVER_VIDEO = "KEY_INSERT_SENDER_RECEIVER_VIDEO";
  public final static String KEY_IS_VIDEO_RUNNING = "KEY_IS_VIDEO_RUNNING";
  public final static String KEY_COUNT_VIDEO_SENDER = "KEY_COUNT_VIDEO_SENDER";
  public final static String KEY_IS_RECEIVER_SENDER = "KEY_IS_RECEIVER_SENDER";
  public final static String KEY_DELETE_VIDEO_SENDER = "KEY_DELETE_VIDEO_SENDER";
  public final static String KEY_INSERT_VIDEO_SENDER = "KEY_INSERT_VIDEO_SENDER";
  public final static String KEY_IS_PRESENT_VIDEOSENDER = "KEY_IS_PRESENT_VIDEOSENDER";
  public final static String KEY_DELETE_VIDEO_SENDER_USER = "KEY_DELETE_VIDEO_SENDER_USER";
  public final static String KEY_SENDER_FROM_RECEIVER = "KEY_SENDER_FROM_RECEIVER";
  public final static String KEY_REPLACE_NICKNAME = "KEY_REPLACE_NICKNAME";
  public final static String KEY_FETCH_NICKNAME = "KEY_FETCH_NICKNAME";
  public final static String KEY_UPDATE_NICKNAME = "KEY_UPDATE_NICKNAME";
  public final static String KEY_DELETE_ALL_PROJEKTORS = "KEY_DELETE_ALL_PROJEKTORS";
  public final static String KEY_IS_SENDER_RECEIVER = "KEY_IS_SENDER_RECEIVER";
  public final static String KEY_DELETE_VIDEO_RECEIVER = "KEY_DELETE_VIDEO_RECEIVER";
  public final static String KEY_FETCH_KONFERENZRAUM_ACTIVE_USER = "KEY_FETCH_KONFERENZRAUM_ACTIVE_USER";
  public final static String KEY_ORPHAINED_SENDER = "KEY_ORPHAINED_SENDER";
  public final static String KEY_COUNT_VIDEOSENDER = "KEY_COUNT_VIDEOSENDER";
  public final static String KEY_DELETE_VIDEO_SCREENCASTER = "KEY_DELETE_VIDEO_SCREENCASTER";
  public final static String KEY_FETCH_VIDEO_USER_BY_RECEIVER = "KEY_FETCH_VIDEO_USER_BY_RECEIVER";
  public final static String KEY_UPDATE_RSA = "KEY_UPDATE_RSA";
  public final static String KEY_FETCH_RSA_PUBLIC = "KEY_FETCH_RSA_PUBLIC";
  public final static String KEY_FETCH_RSA_PRIVATE = "KEY_FETCH_RSA_PRIVATE";
  public final static String KEY_FETCH_AES = "KEY_FETCH_AES";
  public final static String KEY_FETCH_ONLINE_BY_UID = "KEY_FETCH_ONLINE_BY_UID";
  public final static String KEY_INSERT_TOKEN = "KEY_INSERT_TOKEN";
  public final static String KEY_DELETE_ALL_TOKEN = "KEY_DELETE_ALL_TOKEN";
  public final static String KEY_DELETE_TOKEN = "KEY_DELETE_TOKEN";
  public final static String KEY_FETCH_PASSWORD = "KEY_FETCH_PASSWORD";
  public final static String KEY_FETCH_KONFERENZTEILNEHMER = "KEY_FETCH_KONFERENZTEILNEHMER";
  public final static String KEY_FETCH_RECEIVERS_BY_SENDER = "KEY_FETCH_RECEIVERS_BY_SENDER";
  public final static String KEY_DELETE_FORBIDDEN_ROOMFILTER = "KEY_DELETE_FORBIDDEN_ROOMFILTER";

  private static Persistence instance;

  static {
    instance = new Persistence();
  }

  private Hashtable<String, String> sqlhash;

  private Persistence() {
    SQLMapper sqlmapper = SQLMapper.getInstance();
    try {
      SQLMAPPER root = sqlmapper.read();
      List<SQL> sqllist = root.getSQLS().getSQL();
      int count = sqllist.size();
      sqlhash = new Hashtable<>(count);
      for (int index = 0; index < count; index++) {
        SQL sql = sqllist.get(index);
        sqlhash.put(sql.getId(), sql.getCOMMAND());
      }
    }
    catch (JAXBException e) {
      log.error(e.getMessage(), e.getCause());
    }
  }



  /**
   * Ein Singeleton verhindert, dass unnötige Instanzen der Klasse erzeugt werden.
   *
   * @return
   */
  public static synchronized Persistence getInstance() {
    return instance;
  }



  /**
   * Lies alle SQL/id - Attribute aus der <b>sqlmapper.xml</b> aus.
   *
   *
   * @return alle id-Attribute
   */
  public List<String> getAllKeys() {
    Enumeration<String> keys = sqlhash.keys();
    ArrayList<String> values = new ArrayList<>(75);
    while (keys.hasMoreElements()) {
      values.add(keys.nextElement());
    }
    return values;
  }



  /**
   * Lies einen SQL-Befehl aus der <b>sqlmapper.xml</b> aus.
   *
   *
   * @param id
   *           das id-Attribut im SQL-Element
   * @return SQL-Befehl
   */
  public String getSQL(String id) {
    if (getSQLMap().get(id) == null) {
      log.error("KEY:        " + id);
      log.error("missing in :" + Environment.DEFAULT_SQLMAPPER);
      log.error("--");
    }
    return getSQLMap().get(id);
  }



  /**
   * Gib alle SQL/Command - Paare zurück.
   *
   * @return die Map enthält alle Paare aus (SQL-id | Command)
   */
  public Map<String, String> getSQLMap() {
    return sqlhash;
  }

}
