/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.database.entity;

public class Chatfile {
  private long anlage;
  private long filesize;
  private boolean deletable;
  private String chatid;
  private String absoluteFilename;
  private String filename;

  public Chatfile() {}



  public long getAnlage() {
    return anlage;
  }



  public void setAnlage(long anlage) {
    this.anlage = anlage;
  }



  public long getFilesize() {
    return filesize;
  }



  public void setFilesize(long filesize) {
    this.filesize = filesize;
  }



  public String getChatid() {
    return chatid;
  }



  public void setChatid(String chatid) {
    this.chatid = chatid;
  }



  public String getAbsoluteFilename() {
    return absoluteFilename;
  }



  public void setAbsoluteFilename(String absoluteFilename) {
    this.absoluteFilename = absoluteFilename;
  }



  public String getFilename() {
    return filename;
  }



  public void setFilename(String filename) {
    this.filename = filename;
  }



  public boolean isDeletable() {
    return deletable;
  }



  public void setDeletable(boolean deletable) {
    this.deletable = deletable;
  }

}
