/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.database.entity;

import java.time.ZonedDateTime;
import net.javacomm.protocol.Language;



/**
 *
 * Die Klasse bildet die Table TB_USER ab.
 *
 * @author llange
 *
 */
public class EntityUser {

  private String uid;
  private String mail;
  private String nickname;
  private int number;
  private int benutzerstatus;
  private int foreground;
  private int background;
  private int volume;
  private int playervolume = 68;
  private int iptvvolume = 68;
  private boolean oncall;
  private int telefonpuffer = 2;
  private String speaker;
  private String mikrofon;
  private int eis = 2;
  private boolean chatdenied = false;
  private boolean chattooltip = false;
  private String chatDownloadDir;
  private String chatUploadDir;
  private boolean onrekord;
  private boolean onprojektor = false;
  private String password;
  private String neues_password;
  private int confirmation_key;
  private int confirmation_flag;
  private ZonedDateTime time;
  private boolean admin;
  private Language language;
  private boolean ldelete;

  public EntityUser() {}



  public int getBackground() {
    return background;
  }



  public int getBenutzerstatus() {
    return benutzerstatus;
  }



  public int getConfirmation_flag() {
    return confirmation_flag;
  }



  public int getConfirmation_key() {
    return confirmation_key;
  }



  public int getForeground() {
    return foreground;
  }



  public String getMail() {
    return mail;
  }



  public String getNeues_password() {
    return neues_password;
  }



  public String getNickname() {
    return nickname;
  }



  public int getNumber() {
    return number;
  }



  public String getPassword() {
    return password;
  }



  public ZonedDateTime getTime() {
    return time;
  }



  public String getUid() {
    return uid;
  }



  public void setBackground(int background) {
    this.background = background;
  }



  public void setBenutzerstatus(int benutzerstatus) {
    this.benutzerstatus = benutzerstatus;
  }



  public void setConfirmation_flag(int confirmation_flag) {
    this.confirmation_flag = confirmation_flag;
  }



  public void setConfirmation_key(int confirmation_key) {
    this.confirmation_key = confirmation_key;
  }



  public void setForeground(int foreground) {
    this.foreground = foreground;
  }



  public void setMail(String mail) {
    this.mail = mail;
  }



  public void setNeues_password(String neues_password) {
    this.neues_password = neues_password;
  }



  public void setNickname(String nickname) {
    this.nickname = nickname;
  }



  public void setNumber(int number) {
    this.number = number;
  }



  public void setPassword(String password) {
    this.password = password;
  }



  public void setTime(ZonedDateTime time) {
    this.time = time;
  }



  public void setUid(String uid) {
    this.uid = uid;
  }



  public boolean isAdmin() {
    return admin;
  }



  public void setAdmin(boolean admin) {
    this.admin = admin;
  }



  public int getVolume() {
    return volume;
  }



  public void setVolume(int volume) {
    this.volume = volume;
  }



  public boolean isOncall() {
    return oncall;
  }



  public void setOncall(boolean oncall) {
    this.oncall = oncall;
  }



  public int getTelefonpuffer() {
    return telefonpuffer;
  }



  public void setTelefonpuffer(int telefonpuffer) {
    this.telefonpuffer = telefonpuffer;
  }



  public int getPlayervolume() {
    return playervolume;
  }



  public void setPlayervolume(int playervolume) {
    this.playervolume = playervolume;
  }



  public boolean isChatdenied() {
    return chatdenied;
  }



  public void setChatdenied(boolean chatdenied) {
    this.chatdenied = chatdenied;
  }



  public int getEis() {
    return eis;
  }



  public void setEis(int eis) {
    this.eis = eis;
  }



  public String getSpeaker() {
    return speaker;
  }



  public void setSpeaker(String speaker) {
    this.speaker = speaker;
  }



  public String getMikrofon() {
    return mikrofon;
  }



  public void setMikrofon(String mikrofon) {
    this.mikrofon = mikrofon;
  }



  public Language getLanguage() {
    return language;
  }



  public void setLanguage(Language language) {
    this.language = language;
  }



  public boolean isOnrekord() {
    return onrekord;
  }



  public void setOnrekord(boolean onrekord) {
    this.onrekord = onrekord;
  }



  public boolean isOnprojektor() {
    return onprojektor;
  }



  public void setOnprojektor(boolean onprojektor) {
    this.onprojektor = onprojektor;
  }



  public int getIptvvolume() {
    return iptvvolume;
  }



  public void setIptvvolume(int iptvvolume) {
    this.iptvvolume = iptvvolume;
  }



  public boolean isChattooltip() {
    return chattooltip;
  }



  public void setChattooltip(boolean chattooltip) {
    this.chattooltip = chattooltip;
  }



  public String getChatDownloadDir() {
    return chatDownloadDir;
  }



  public void setChatDownloadDir(String chatDownloadDir) {
    this.chatDownloadDir = chatDownloadDir;
  }



  public String getChatUploadDir() {
    return chatUploadDir;
  }



  public void setChatUploadDir(String chatUploadDir) {
    this.chatUploadDir = chatUploadDir;
  }



  public boolean isLdelete() {
    return ldelete;
  }



  public void setLdelete(boolean ldelete) {
    this.ldelete = ldelete;
  }

}
