/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.environment;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import net.javacomm.database.SQLMapper;



/**
 * 
 * 
 * 
 * @author llange
 *
 */
public class Environment {

  private final static Logger log = LogManager.getLogger(Environment.class);
  public final static String CONFIG_FILE = "connection.xml";
  public final static String DEFAULT_SQLMAPPER = "sqlmapper.xml";

  // private File etcdir = new File("etc").getAbsoluteFile();
  private static Environment instance;
  private URL url;

  private Path etcdir = Paths.get("etc").toAbsolutePath();

  private Environment() {
    url = getClass().getResource(SQLMapper.MAPPERFILE);
  }

  static {
    instance = new Environment();
  }

  public Path getEtcdir() {
    return etcdir;
  }



  /**
   * Alle Methoden in Environment werden über getInstance() aufgerufen.
   * 
   * @return eine Instanz auf Environment.
   */
  public synchronized static Environment getInstance() {
    return instance;
  }



  public File getSQLMapper() {
    File file = null;
    try {
      file = new File(url.toURI());
    }
    catch (URISyntaxException e) {
      log.error(e.getMessage(), e.getCause());
    }
    return file;
  }



  public void setEtcdir(Path value) {
    etcdir = value;
  }

}
