/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.server;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.WebListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import net.javacomm.database.WebdatabaseImpl;
import net.javacomm.facade.DatabaseService;



@WebListener
public class ServerListener implements ServletContextListener {

  final Logger log = LogManager.getLogger(ServerListener.class);
  private DatabaseService databaseService;

  @Override
  public void contextInitialized(ServletContextEvent sce) {
    log.info("javacommserver has started...");
    Webserver.startup();
    ServletContext servletcontext = sce.getServletContext();
    String resource = servletcontext.getInitParameter("resource-name");
    log.info(resource);
    databaseService = WebdatabaseImpl.getInstance(resource);
    databaseService.init();
  }



  @Override
  public void contextDestroyed(ServletContextEvent sce) {
    log.info("ich räume auf");
    log.info("beende alle Threads");
    databaseService.shutdown();
    Webserver.shutdown();
  }

}
