/**
 * The MIT License
 * Copyright © 2020 Thorsten Schulz <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package net.javacomm.schulz;

import java.util.Vector;

/*****************************************************************************/
/*                                                                           */
/* Class       : EventHandlingClass                                          */
/* Owner       : Thorsten Schulz                                             */
/* License     : All rights reserved                                         */
/* Createtd    : 20.11.2014 by Thorsten Schulz, TSchulz@javacomm.net         */
/* Last Update : 21.11.2014 by Thorsten Schulz                               */
/*                                                                           */
/*****************************************************************************/


public class EventHandlingClass{

    private int sourcePanel;      // Gibt das Panel an, wo das Event ausgel�st wurde
    private int sourceObject;     // Gibt das konkrete Objekt an, das das Event ausl�ste
    Object obj;                   // Objekt, welches �bermittelt werden soll
    Vector<?> vector;             // Objektreihe, die �bermittelt werden soll
    String value;
    String[] values;
    Object[] objValues;

  public EventHandlingClass(){
    //Defaultwerte setzen:

    vector = new Vector<>();
    obj    = new Object();
    sourcePanel = 0;
    sourceObject = 0;
    value = new String("");
    values = new String[1];
    values[0] = new String("");
    objValues = new Object[1];
    objValues[0] = new Object();
  }

  public Object getObject(){
    return(obj);
  }

  public void setObject(Object object){
    obj = object;
  }

  public Vector<?> getVector(){
    return(vector);
  }

  public <T> void setVector(Vector<T> vect){
    vector = vect;
  }

  public int getSourcePanel(){
    return(sourcePanel);
  }

  public void setSourcePanel(int source){
    sourcePanel = source;
  }

  public int getSourceObject(){
    return(sourceObject);
  }

  public void setSourceObject(int source){
    sourceObject = source;
  }

  public String getValue(){
    return(value);
  }

  public void setValue(String value){
    this.value = value;
  }

  public String[] getValues(){
    return(values);
  }

  public void setValues(String[] values){
    this.values = values;
  }

  public void setObjValues(Object[] objValues){
    this.objValues = objValues;
  }

  public Object[] getObjValues(){
    return(objValues);
  }
}