/**
 * The MIT License
 * Copyright © 2020 Thorsten Schulz <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package net.javacomm.schulz;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;

/*****************************************************************************/
/*                                                                           */
/* Class       : JArrowButtonPanel                                           */
/* Owner       : Thorsten Schulz                                             */
/* License     : All rights reserved                                         */
/* Createtd    : 30.03.2004 by Thorsten Schulz, TSchulz@javacomm.net         */
/* Last Update : 17.04.2020 by Thorsten Schulz                               */
/*                                                                           */
/*****************************************************************************/

public class JArrowButtonPanel extends JPanel implements ActionListener{

  /**
	*  
	*/
  private static final long serialVersionUID = -9197101445634279419L;
	
  private GridBagLayout gridbag        = new GridBagLayout();
  private GridBagConstraints c         = new GridBagConstraints();
  private PropertyChangeSupport change = new PropertyChangeSupport(this);
  private JPolygonButton up, down;
  private int[] x1, y1, x2, y2;
  private int n1, n2;

  public JArrowButtonPanel(){

    n1 = 3;
    n2 = 3;
    x1 = new int[n1];
    y1 = new int[n1];
    x2 = new int[n2];
    y2 = new int[n2];

    x1[0] = 3;
    y1[0] = 0;

    x1[1] = 7;
    y1[1] = 7;

    x1[2] = 0;
    y1[2] = 7;

    x2[0] = 0;
    y2[0] = 0;

    x2[1] = 7;
    y2[1] = 0;

    x2[2] = 3;
    y2[2] = 7;

    up   = new JPolygonButton(x1, y1, n1);
    down = new JPolygonButton(x2, y2, n2);

    up.addActionListener(this);
    down.addActionListener(this);

    setLayout(gridbag);

    c.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(up, c);
    add(up);

    c.insets = new Insets(5,0,0,0);
    gridbag.setConstraints(down, c);
    add(down);
  }

  @Override
  public void actionPerformed(ActionEvent event){
    Object obj;
    obj = event.getSource();

    if(obj.equals(up)){
      change.firePropertyChange("up", obj, Boolean.valueOf(false));
    }
    if(obj.equals(down)){
      change.firePropertyChange("down", obj, Boolean.valueOf(true));
    }
    return;
  }

  public synchronized void addJArrowPanelListener(PropertyChangeListener l){

    change.addPropertyChangeListener(l);
    return;
  }

  public synchronized void removeJArrowPanelListener(PropertyChangeListener l){

    change.removePropertyChangeListener(l);
    return;
  }
}