/**
 * The MIT License
 * Copyright © 2020 Luis Andrés Lange <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.nexuswob.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.SwingConstants;

@SuppressWarnings("serial")
public class ArrowTooltip extends JToolTip {

  
  private JLabel labelText;
  private Color background;

  
  /**
   * Die Standardfarbe außerhalb des geschlossenen Rahmens ist die vorgegebene
   * Systemfarbe.
   * 
   */
  public ArrowTooltip() {
    this(Color.WHITE);
  }

  
  
  /**
   * Der Farbbereich außerhalb des Rahmens.
   * 
   * @param background
   *                   die Farbe außerhalb des geschlossenen Rahmens
   */
  public ArrowTooltip(Color background) {
    this.background = background;
    labelText = new JLabel();
    setLayout(new BorderLayout());
    add(BorderLayout.CENTER, labelText);

  }
  
  
  @Override
  public void paintComponent(Graphics g) {
    Graphics2D g2 = (Graphics2D) g;
    int biWidth = getSize().width;
    int biHeight = getSize().height;
    BufferedImage bufferedimage = new BufferedImage (biWidth,biHeight,BufferedImage.TYPE_INT_RGB);
    Graphics2D gOffline = bufferedimage.createGraphics ();
    gOffline.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    gOffline.setColor(background);
    gOffline.fillRect(0, 0, biWidth, biHeight);
    gOffline.dispose ();
    
    g2.drawImage (bufferedimage, 0,0, null);
    
  }

  
  
  
  
  
  /**
   * 
   * Die Attribute für den ToolTipText werden gesetzt.
   * 
   * @param font
   *                       ein TrueType-Font
   * @param textForeground
   *                       die Textvordergrundfarbe
   * @param textBackground
   *                       die Texthintergrundfarbe
   */
  public void setTextAttributes(Font font, Color textForeground, Color textBackground) {
    labelText.setText(super.getComponent().getToolTipText());
    labelText.setFont(font);
    labelText.setHorizontalAlignment(SwingConstants.CENTER);
    labelText.setBackground(textBackground);
    labelText.setForeground(textForeground);
    labelText.setOpaque(true);
  }
  
  
    
}
