/**
 * The MIT License
 * Copyright © 2020 Luis Andrés Lange <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.nexuswob.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class JOkDialog extends JDialog implements ActionListener {

  public final static Color ERROR_COLOR = new Color (255,94,128);
  public final static Color INFO_COLOR = new Color (204,221,255);
  private final static long serialVersionUID = 1106078309044L;
  private GridBagLayout gridbag = new GridBagLayout ();
  private GridBagConstraints con = new GridBagConstraints ();
  private BorderLayout border = new BorderLayout ();
  private JPanel mainPanel = new JPanel (border);
  private JButton buttonOk = new JButton ("OK");
  private JPanel panButton = new JPanel (new FlowLayout (FlowLayout.CENTER));
  private JPanel panText = new JPanel (gridbag);
  private JTextArea labelText = new JTextArea ();



  public JOkDialog () {
    super ();
    setContentPane (mainPanel);


    con.anchor = GridBagConstraints.CENTER;
    con.weightx = 1.0;
    con.insets = new Insets (6,6,6,6);
    con.fill = GridBagConstraints.HORIZONTAL;
    gridbag.setConstraints (labelText, con);
    panText.add (labelText);
    labelText.setLineWrap (true);
    labelText.setWrapStyleWord (true);
    labelText.setEditable (false);


    setFgText (Color.black);
    panButton.add (buttonOk);

    buttonOk.addActionListener (this);
    buttonOk.setForeground (Color.black);
    buttonOk.setBorderPainted (true);
    buttonOk.setRolloverEnabled (true);
    buttonOk.setFocusPainted (false);


    mainPanel.add (BorderLayout.CENTER, panText);
    mainPanel.add (BorderLayout.SOUTH, panButton);

    setBg (Color.lightGray);
  }



  @Override
  public void actionPerformed (ActionEvent event) {
    Object obj;

    obj = event.getSource ();
    if (obj.equals (buttonOk)) {
      processWindowEvent (new WindowEvent (this, WindowEvent.WINDOW_CLOSING));
    }
  }



  public void setText (String txt) {
    labelText.setText (txt);
    mainPanel.revalidate ();
  }


  public void setFgText (Color c) {
    labelText.setForeground (c);
  }


  public void setBg (Color c) {
    mainPanel.setBackground (c);
    panButton.setBackground (c);
    buttonOk.setBackground (Color.black);
    buttonOk.setForeground (c);
    panText.setBackground (c);
    labelText.setBackground (c);
  }



  @Override
  public void setFont (Font f) {
    labelText.setFont (f);
    buttonOk.setFont (f);
  }



}