/**
 * The MIT License
 * Copyright © 2020 Luis Andrés Lange <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.nexuswob.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class RoundedPanel extends JPanel {

  private static final long serialVersionUID = -7757092739877832607L;

  private Color backgroundColor;
  private int cornerRadius = 15;

  public RoundedPanel(LayoutManager layout, int radius) {
      super(layout);
      cornerRadius = radius;
  }

  public RoundedPanel(LayoutManager layout, int radius, Color bgColor) {
      super(layout);
      cornerRadius = radius;
      backgroundColor = bgColor;
  }

  public RoundedPanel(int radius) {
      super();
      cornerRadius = radius;
  }

  public RoundedPanel(int radius, Color bgColor) {
      super();
      cornerRadius = radius;
      backgroundColor = bgColor;
  }

  @Override
  protected void paintComponent(Graphics g) {
      super.paintComponent(g);
      Dimension arcs = new Dimension(cornerRadius, cornerRadius);
      int width = getWidth();
      int height = getHeight();
      Graphics2D graphics = (Graphics2D) g;
      graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

      //Draws the rounded panel with borders.
      if (backgroundColor != null) {
          graphics.setColor(backgroundColor);
      } else {
          graphics.setColor(getBackground());
      }
      graphics.fillRoundRect(0, 0, width-1, height-1, arcs.width, arcs.height); //paint background
      graphics.setColor(getForeground());
      graphics.drawRoundRect(0, 0, width-1, height-1, arcs.width, arcs.height); //paint border
  }

  
  
}
