/*
 * Copyright © 2021, Luis Andrés Lange <https://javacomm.net>
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
package org.nexuswob.gui.swing;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.synth.SynthInternalFrameUI;



public class JavacommInternalFrameUI extends SynthInternalFrameUI {

//  private final static Logger log = LogManager.getLogger(JavacommInternalFrameUI.class);

  protected JavacommInternalFrameUI(JInternalFrame b) {
    super(b);
  }



  @Override
  protected JComponent createNorthPane(JInternalFrame w) {
    JComponent component = super.createNorthPane(w);

//    log.info(component);
    BasicInternalFrameTitlePane titlePane = (BasicInternalFrameTitlePane) component;
//    titlePane.setForeground(Resource.JQUERY_BLAU);

    Dimension dim = titlePane.getPreferredSize();
    dim.height = 24;
    titlePane.setPreferredSize(dim);

    return component;
  }

}
