/*
 * The MIT License
 * Copyright © 2025 Luis Andrés Lange <https://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.nexuswob.gui.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;



@SuppressWarnings("serial")
public class JavacommTreeCellRenderer extends JLabel implements TreeCellRenderer {

  public JavacommTreeCellRenderer() {
    setOpaque(true); // Damit der Hintergrund sichtbar ist
  }



  @Override
  public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded,
      boolean leaf, int row, boolean hasFocus) {

    DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;

    // Setze den Text des Labels basierend auf dem Knoten
    setText(node.toString());

    // Setze die Hintergrundfarbe basierend auf dem Knoten-Typ
    if (node.isLeaf()) {
      setBackground(Color.LIGHT_GRAY); // Dateien
    }
    else {
      setBackground(Color.CYAN); // Ordner
    }

    // Setze die Textfarbe für ausgewählte Knoten
    if (selected) {
      setForeground(Color.WHITE);
    }
    else {
      setForeground(Color.BLACK);
    }

    return this;

  }

}
