/**
 * The MIT License
 * Copyright © 2020 Luis Andrés Lange <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.nexuswob.util;

/*****************************************************************************/
/*                                                                           */
/*                         Interface SelectNodeIndex                         */
/*                                                                           */
/*****************************************************************************/


public interface SelectNodeIndex  {

  int ALPHA_NUMERIC = 0;
  int NUMERIC = 1;

  /**
   * Nach dieser Spalte wird sortiert.
   * 
   * @param index die Spalte in einer Zeile
   */
  void setKeyIndex (int index);

  
  /**
   * 
   * @return nach dieser Spalte wird sortiert
   */
  int getKeyIndex ();
  
  
  /**
   * Der Datentyp, nach dem sortiert wird.
   * 
   * @param type
   */
  void setType (int type);
  int getType ();

}

