/**
 * The MIT License
 * Copyright © 2022 Luis Andrés Lange <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.nexuswob.util;

import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Objects;



/**
 * UploadFile ist eine Datei, die auf andere Rechner kopiert wird.
 * 
 * @author llange
 *
 */
public class UploadFile {

  private Path path;
  private FileTime lastModified;

  public UploadFile() {}



  /**
   * Wo liegt die Datei im Verzeichnisbaum? Der Dateiname ist im Pfad enthalten.
   * 
   * @return ein vollständiger Dateipfad
   */
  public Path getPath() {
    return path;
  }



  /**
   * Das Uploadverzeichnis für den FTService.
   * 
   * @param path
   *             ein vollständiger Dateipfad
   */
  public void setPath(Path path) {
    this.path = path;
  }



  /**
   * Wann wurde die Datei das letzte Mal verändert oder neu geschrieben?
   * 
   * @return ein Zeitpunkt
   */
  public FileTime getLastModified() {
    return lastModified;
  }



  /**
   * Zu diesem Zeitpunkt wurde die Datei das letze Mal in das Verzeichnis kopiert
   * oder gespeichert.
   * 
   * @param lastModified
   *                     ein Zeitpunkt
   */
  public void setLastModified(FileTime lastModified) {
    this.lastModified = lastModified;
  }



  @Override
  public int hashCode() {
    return Objects.hash(lastModified, path);
  }



  @Override
  public boolean equals(Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (getClass() != obj.getClass()) return false;
    UploadFile other = (UploadFile) obj;
    return Objects.equals(lastModified, other.lastModified) && Objects.equals(path, other.path);
  }

}
