/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;



/**
 * CHATMESSAGE ist eine gesendete Chatnachricht an alle User in einem Raum
 * 
 * @author llange
 *
 */
public class CHATMESSAGE extends MESSAGE implements Attachment {

  public final static String CHATUSER = "CHATUSER";
  public final static String ROOM = "ROOM";
  public final static String MESSAGE = "MESSAGE";
  public final static String DATETIME = "DATETIME";

  /* die Nachricht kommt aus diesem Raum */
  @SerializedName(value = "ROOM")
  private String room;

  /**
   * der Anwender hat gerade diese Nachricht geschrieben
   */
  @SerializedName(value = "MESSAGE")
  private String message;

  /**
   * der Anwender verschickt einen Anhang, ist optional
   */
  @SerializedName(value = "ATTACHMENT")
  private Long attachment;
  @SerializedName(value = "FILENAME")
  private String filename;
  @SerializedName(value = "FILESIZE")
  private Long filesize;

  // Chatuser enthält den Absender der Nachricht
  @SerializedName(value = "CHATUSER")
  private ChatUser chatuser;

  /**
   * In diesem Moment wurde die Nachricht in der Datenbank gespeichert.
   */
  @SerializedName(value = "DATETIME")
  private Long datetime;

  @Override
  public void setMessage(String value) {
    message = value;
  }



  @Override
  public String getMessage() {
    return message;
  }



  @Override
  public void setChatUser(ChatUser value) {
    chatuser = value;
  }



  @Override
  public ChatUser getChatUser() {
    return chatuser;
  }



  @Override
  public void setRoom(String value) {
    room = value;
  }



  @Override
  public String getRoom() {
    return room;
  }



  @Override
  public void setDatetime(Long value) {
    datetime = value;
  }



  @Override
  public Long getDatetime() {
    return datetime;
  }



  @Override
  public void setAttachment(Long value) {
    attachment = value;
  }



  @Override
  public void setFilename(String value) {
    filename = value;
  }



  @Override
  public void setFilesize(Long value) {
    filesize = value;
  }



  @Override
  public Long getAttachment() {
    return attachment;
  }



  @Override
  public String getFilename() {
    return filename;
  }



  @Override
  public Long getFilesize() {
    return filesize;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    Gson gson = builder.registerTypeAdapter(CHATMESSAGE.class, new ChatMessageSerializer())
        .registerTypeAdapter(ChatUser.class, new ChatUserSerializer()).create();
    return gson.toJson(this);
  }

}
