/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

public class CREATETEMPROOM extends MESSAGE {

    
  
  public final static String ROOM = "ROOM";
  public final static String USER = "USER";
  public final static String LIFETIME = "LIFETIME";
  public final static String ENTRY = "ENTRY";
  public final static String PASSWORD = "PASSWORD";
  public final static String NICKNAME = "NICKNAME";
  public final static String ROOMTYPE = "ROOMTYPE";

  
  private String room;
  private String user;
  private Lifetime lifetime;
  private Entry entry;
  private String password;
  private String nickname;
  private Roomtype roomtype;


  
  public void setNickname(String value) {
    nickname = value;
  }
  
  
  public String getNickname() {
    return nickname;
  }
  
  
  public Entry getEntry() {
    return entry;
  }
  
  
  public Lifetime getLifetime() {
    return lifetime;
  }
  
  
  public final String getPassword() {
    return password;
  }
  
  
  public String getRoom() {
    return room;
  }
  
  
  public void setEntry(Entry value) {
    entry = value;
  }
  
  
  public void setLifetime(Lifetime value) {
    lifetime = value;
  }
  
  
  public final void setPassword(String value) {
    password = value;
  }
  
  
  public void setRoom(String value) {
    room = value;
  }
  
  
  public void setUser(String value) {
  	user = value;
  }
  
  
  public String getUser() {
  	return user;
  }


  public Roomtype getRoomtype() {
    return roomtype;
  }


  public void setRoomtype(Roomtype roomtype) {
    this.roomtype = roomtype;
  }
  
  
}
