/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;



/**
 * 
 * @author llange
 *
 * @deprecated wird nicht benötigt
 */
@Deprecated
public class ConferenceDeserializer implements JsonDeserializer<CONFERENCE> {

  @Override
  public CONFERENCE deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
      throws JsonParseException {

    JsonObject jsonobject = json.getAsJsonObject();

    HEADER header = HEADER.valueOf(jsonobject.getAsJsonPrimitive(Protocol.HEADER).getAsString());
    JsonObject dataset = jsonobject.getAsJsonObject(Protocol.DATASET);
    String konferenzname = dataset.get(CONFERENCE.KONFERENZNAME).getAsString();
    String organisatorUid = dataset.get(CONFERENCE.ORGANISATOR_UID).getAsString();
    JsonArray array = dataset.getAsJsonArray(CONFERENCE.KONFERENZRAUMUSER);
    int count = array.size();
    KonferenzraumUser[] konferenzraumUser = new KonferenzraumUser[count];
    for (int index = 0; index < count; index++) {
      KonferenzraumUser user = new KonferenzraumUser();
      konferenzraumUser[index] = user;
      JsonObject arrayObject = array.get(index).getAsJsonObject();
      boolean online = arrayObject.get(KonferenzraumUser.ANWESEND).getAsBoolean();
      String session = null;
      try {
        session = arrayObject.get(KonferenzraumUser.SESSION).getAsString();
      }
      catch (NullPointerException e) {}

      JsonObject chatuser = arrayObject.get(KonferenzraumUser.CHATUSER).getAsJsonObject();
      int background = chatuser.get(KonferenzraumUser.BACKGROUND_COLOR).getAsInt();
      int foreground = chatuser.get(KonferenzraumUser.FOREGROUND_COLOR).getAsInt();
      String nickname = chatuser.get(KonferenzraumUser.NICKNAME).getAsString();
      String userid = chatuser.get(KonferenzraumUser.USERID).getAsString();

      konferenzraumUser[index].setBackgroundColor(background);
      konferenzraumUser[index].setForegroundColor(foreground);
      konferenzraumUser[index].setNickname(nickname);
      konferenzraumUser[index].setAnwesend(online);
      konferenzraumUser[index].setSession(session);
      konferenzraumUser[index].setUserid(userid);

    }

    CONFERENCE conference = new CONFERENCE();
    conference.setHeader(header);
    conference.setCommand(Command.CONFERENCE);
    conference.setDataset(Protocol.DATASET);
    conference.setKonferenzname(konferenzname);
    conference.setOrganisatorUid(organisatorUid);
    conference.setKonferenzraumUser(konferenzraumUser);

    return conference;
  }

}
