/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

public class DOWNLOAD extends MESSAGE {
	
	
  public final static String USERID = "USERID";
  public final static String SLOT = "SLOT";
  public final static String FILENAME = "FILENAME";
  public final static String INDEX = "INDEX";
  public final static String IP = "IP";
  public final static String PATHFILE = "PATHFILE";
  public final static String PORT = "PORT";

	
	private String userid;
	private int slot;
	private String filename;
	private int index;
	private String ip;
	private String pathfile;
	private int port;
	
	
	
	public void setFilename(String value) {
		filename = value;
	}
	
	
	public void setIndex(int value) {
		index = value;
	}
	
	
	public void setIp(String value) {
	  ip = value;
	}
	
	
	public void setPathfile(String value) {
	  pathfile = value;
	}
	
	
	public void setPort(int value) {
	  port = value;
	}
	
	
	public void setSlot(int value) {
		slot = value;
	}
	
	
	public void setUserid(String value) {
		userid = value;
	}
	
	
	public String getFilename() {
		return filename;
	}
	
	
	public int getIndex() {
		return index;
	}
	
	
	public String getIp() {
	  return ip;
	}
	
	
	public String getPathfile() {
	  return pathfile;
	}
	
	
	public int getPort() {
	  return port;
	}
	
	
	public int getSlot() {
		return slot;
	}
	
	
	public String getUserid() {
		return userid;
	}
	
	

}
